/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.KeyStore;
import org.compiere.install.ConfigurationData;
import org.compiere.install.KeyStoreMgt;
import org.compiere.util.Ini;

public class ConfigurationConsole {
    ConfigurationData data = new ConfigurationData(null);

    public void doSetup() {
        BufferedReader reader = null;
        PrintWriter writer = null;
        reader = new BufferedReader(new InputStreamReader(System.in));
        writer = new PrintWriter(System.out, true);
        Ini.setShowLicenseDialog((boolean)false);
        this.data.load();
        this.data.initJava();
        try {
            this.jvmHome(reader, writer);
            this.jvmOptions(reader, writer);
            this.adempiereHome(reader, writer);
            this.keyStorePass(reader, writer);
            this.appServerHostname(reader, writer);
            this.appServerWebPort(reader, writer);
            this.appServerSSLPort(reader, writer);
            this.dbExists(reader, writer);
            this.dbType(reader, writer);
            this.dbHostname(reader, writer);
            this.dbPort(reader, writer);
            this.dbName(reader, writer);
            this.dbUser(reader, writer);
            this.dbPassword(reader, writer);
            this.dbSystemPassword(reader, writer);
            this.mailServer(reader, writer);
            this.mailUser(reader, writer);
            this.mailPassword(reader, writer);
            this.mailAdmin(reader, writer);
            writer.println("Save changes (Y/N) [Y]: ");
            String yesNo = reader.readLine();
            if (yesNo == null || yesNo.trim().length() == 0 || "y".equalsIgnoreCase(yesNo)) {
                boolean b = this.data.save();
                if (b) {
                    writer.println("Changes save successfully.");
                } else {
                    writer.println("Failed to save changes.");
                }
            } else {
                writer.println("Changes ignore.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void mailAdmin(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            String error;
            writer.println("Administrator EMail [" + this.data.getAdminEMail() + "]:");
            String adminEMail = reader.readLine();
            if (adminEMail != null && adminEMail.trim().length() > 0) {
                this.data.setAdminEMail(adminEMail);
            }
            if ((error = this.data.testMail()) == null || error.trim().length() <= 0) break;
            writer.println("Mail setting validation error: " + error);
            this.mailServer(reader, writer);
            this.mailUser(reader, writer);
            this.mailPassword(reader, writer);
        }
    }

    private void mailPassword(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Mail User Password [" + this.data.getMailPassword() + "]");
        String mailPassword = reader.readLine();
        if (mailPassword != null && mailPassword.trim().length() > 0) {
            this.data.setMailPassword(mailPassword);
        }
    }

    private void mailUser(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Mail User Login [" + this.data.getMailUser() + "]:");
        String userName = reader.readLine();
        if (userName != null && userName.trim().length() > 0) {
            this.data.setMailUser(userName);
        }
    }

    private void mailServer(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Mail Server Host Name [" + this.data.getMailServer() + "]:");
        String hostName = reader.readLine();
        if (hostName != null && hostName.trim().length() > 0) {
            this.data.setMailServer(hostName);
        }
    }

    private void dbPort(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            writer.println("Database Server Port [" + this.data.getDatabasePort() + "]:");
            String input = reader.readLine();
            if (input == null || input.trim().length() <= 0) break;
            try {
                int inputPort = Integer.parseInt(input);
                if (inputPort <= 0 || inputPort > 65535) {
                    writer.println("Invalid input, please enter a valid port number");
                    continue;
                }
                this.data.setDatabasePort(input);
            }
            catch (NumberFormatException numberFormatException) {
                writer.println("Invalid input, please enter a valid port number");
                continue;
            }
            break;
        }
    }

    private void dbSystemPassword(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            String error;
            writer.println("Database System User Password [" + this.data.getDatabaseSystemPassword() + "]");
            String dbPassword = reader.readLine();
            if (dbPassword != null && dbPassword.trim().length() > 0) {
                this.data.setDatabaseSystemPassword(dbPassword);
            }
            if ((error = this.data.testDatabase(null)) == null || error.trim().length() <= 0) break;
            writer.println("Database test fail: " + error);
            this.dbExists(reader, writer);
            this.dbType(reader, writer);
            this.dbHostname(reader, writer);
            this.dbPort(reader, writer);
            this.dbName(reader, writer);
            this.dbUser(reader, writer);
            this.dbPassword(reader, writer);
        }
    }

    private void dbPassword(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Database Password [" + this.data.getDatabasePassword() + "]:");
        String dbPassword = reader.readLine();
        if (dbPassword != null && dbPassword.trim().length() > 0) {
            this.data.setDatabasePassword(dbPassword);
        }
    }

    private void dbUser(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Database user [" + this.data.getDatabaseUser() + "]:");
        String dbUser = reader.readLine();
        if (dbUser != null && dbUser.trim().length() > 0) {
            this.data.setDatabaseUser(dbUser);
        }
    }

    private void dbName(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Database Name[" + this.data.getDatabaseName() + "]:");
        String dbName = reader.readLine();
        if (dbName != null && dbName.trim().length() > 0) {
            this.data.setDatabaseName(dbName);
        }
    }

    private void dbHostname(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Database Server Host Name [" + this.data.getDatabaseServer() + "]:");
        String hostName = reader.readLine();
        if (hostName != null && hostName.trim().length() > 0) {
            this.data.setDatabaseServer(hostName);
        }
    }

    private void appServerSSLPort(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            writer.println("Application Server SSL Port[" + this.data.getAppsServerSSLPort() + "]:");
            String input = reader.readLine();
            if (input == null || input.trim().length() <= 0) break;
            try {
                int inputPort = Integer.parseInt(input);
                if (inputPort <= 0 || inputPort > 65535) {
                    writer.println("Invalid input, please enter a valid port number");
                    continue;
                }
                this.data.setAppsServerSSLPort(input);
                String error = this.data.testAppsServer();
                if (error == null || error.trim().length() <= 0) break;
                writer.println("Application server test fail: " + error);
                this.appServerHostname(reader, writer);
                this.appServerWebPort(reader, writer);
            }
            catch (NumberFormatException numberFormatException) {
                writer.println("Invalid input, please enter a valid port number");
            }
        }
    }

    private void appServerWebPort(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            writer.println("Application Server Web Port [" + this.data.getAppsServerWebPort() + "]:");
            String input = reader.readLine();
            if (input == null || input.trim().length() <= 0) break;
            try {
                int inputPort = Integer.parseInt(input);
                if (inputPort <= 0 || inputPort > 65535) {
                    writer.println("Invalid input, please enter a valid port number");
                    continue;
                }
                this.data.setAppsServerWebPort(input);
            }
            catch (NumberFormatException numberFormatException) {
                writer.println("Invalid input, please enter a valid port number");
                continue;
            }
            break;
        }
    }

    private void appServerHostname(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Application Server Host Name [" + this.data.getAppsServer() + "]:");
        String hostName = reader.readLine();
        if (hostName != null && hostName.trim().length() > 0) {
            this.data.setAppsServer(hostName);
        }
    }

    private void keyStorePass(BufferedReader reader, PrintWriter writer) throws Exception {
        while (true) {
            String error;
            writer.println("Key Store Password [" + this.data.getKeyStore() + "]:");
            String password = reader.readLine();
            if (password != null && password.trim().length() > 0) {
                this.data.setKeyStore(password);
            } else {
                password = this.data.getKeyStore();
            }
            File adempiereHome = new File(this.data.getAdempiereHome());
            String fileName = KeyStoreMgt.getKeystoreFileName(adempiereHome.getAbsolutePath());
            KeyStoreMgt storeMgt = new KeyStoreMgt(fileName, password.toCharArray());
            KeyStore keyStore = storeMgt.getKeyStore();
            if (keyStore == null) {
                String country;
                String st;
                String lt;
                String o;
                String ou;
                String cn = this.data.getProperty("ADEMPIERE_CERT_CN");
                if (cn == null) {
                    cn = System.getProperty("user.name");
                }
                if ((ou = this.data.getProperty("ADEMPIERE_CERT_ORG_UNIT")) == null) {
                    ou = "iDempiereUser";
                }
                if ((o = this.data.getProperty("ADEMPIERE_CERT_ORG")) == null) {
                    o = System.getProperty("user.name");
                }
                if ((lt = this.data.getProperty("ADEMPIERE_CERT_LOCATION")) == null) {
                    lt = "MyTown";
                }
                if ((st = this.data.getProperty("ADEMPIERE_CERT_STATE")) == null) {
                    st = "";
                }
                if ((country = this.data.getProperty("ADEMPIERE_CERT_COUNTRY")) == null) {
                    country = System.getProperty("user.country");
                }
                writer.println("KeyStore Settings.");
                writer.println("(ON) Common Name [" + cn + "]:");
                String input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    cn = input;
                    this.data.updateProperty("ADEMPIERE_CERT_CN", input);
                }
                writer.println("(OU) Organization Unit [" + ou + "]:");
                input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    ou = input;
                    this.data.updateProperty("ADEMPIERE_CERT_ORG_UNIT", ou);
                }
                writer.println("(O) Organization [" + o + "]:");
                input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    o = input;
                    this.data.updateProperty("ADEMPIERE_CERT_ORG", o);
                }
                writer.println("(L) Locale/Town [" + lt + "]:");
                input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    lt = input;
                    this.data.updateProperty("ADEMPIERE_CERT_LOCATION", lt);
                }
                writer.println("(S) State [" + st + "]:");
                input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    st = input;
                    this.data.updateProperty("ADEMPIERE_CERT_STATE", st);
                }
                writer.println("(C) Country (2 Char) [" + country + "]");
                input = reader.readLine();
                if (input != null && input.trim().length() > 0) {
                    country = input;
                    this.data.updateProperty("ADEMPIERE_CERT_COUNTRY", input);
                }
            }
            if ((error = this.data.testAdempiere()) == null || error.trim().length() <= 0) break;
            writer.println("iDempiere home and keystore validation error: " + error);
            this.adempiereHome(reader, writer);
        }
    }

    private void adempiereHome(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("iDempiere Home [" + this.data.getAdempiereHome() + "]:");
        String input = reader.readLine();
        if (input != null && input.trim().length() > 0) {
            this.data.setAdempiereHome(input);
        }
    }

    private void jvmHome(BufferedReader reader, PrintWriter writer) throws IOException {
        while (true) {
            String error;
            writer.println("Java Home [" + this.data.getJavaHome() + "]:");
            String input = reader.readLine();
            if (input != null && input.trim().length() > 0) {
                this.data.setJavaHome(input);
            }
            if ((error = this.data.testJava()) == null || error.trim().length() <= 0) break;
            writer.println("JVM test fail: " + error);
        }
    }

    private void jvmOptions(BufferedReader reader, PrintWriter writer) throws IOException {
        writer.println("Java Options [" + this.data.getJavaOptions() + "]:");
        String input = reader.readLine();
        if (input != null && input.trim().length() > 0) {
            this.data.setJavaOptions(input);
        }
    }

    private void dbExists(BufferedReader reader, PrintWriter writer) throws IOException {
        String dbExists = this.data.getDatabaseExists() ? "Y" : "N";
        writer.println("DB Already Exists?(Y/N) [" + dbExists + "]: ");
        String yesNo = reader.readLine();
        if (yesNo == null || yesNo.trim().length() == 0) {
            yesNo = dbExists;
        }
        if ("n".equalsIgnoreCase(yesNo)) {
            this.data.setDatabaseExists("N");
        } else {
            this.data.setDatabaseExists("Y");
        }
    }

    private void dbType(BufferedReader reader, PrintWriter writer) throws IOException {
        String dbType = this.data.getDatabaseType();
        int dbTypeSelected = 0;
        int i = 0;
        while (i < ConfigurationData.DBTYPE.length) {
            if (ConfigurationData.DBTYPE[i].equals(dbType)) {
                dbTypeSelected = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < ConfigurationData.DBTYPE.length) {
            writer.println(i + 1 + ". " + ConfigurationData.DBTYPE[i]);
            ++i;
        }
        while (true) {
            writer.println("Database Type [" + (dbTypeSelected + 1) + "]");
            String input = reader.readLine();
            try {
                int inputIndex;
                if (input == null || input.trim().length() == 0) {
                    input = Integer.toString(dbTypeSelected + 1);
                }
                if ((inputIndex = Integer.parseInt(input)) <= 0 || inputIndex > ConfigurationData.DBTYPE.length) {
                    writer.println("Invalid input, please enter numeric value of 1 to " + ConfigurationData.DBTYPE.length);
                    continue;
                }
                if (dbTypeSelected + 1 != inputIndex) {
                    this.data.dbChanged();
                }
                this.data.initDatabase(ConfigurationData.DBTYPE[inputIndex - 1]);
                this.data.setDatabaseType(ConfigurationData.DBTYPE[inputIndex - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                writer.println("Invalid input, please enter numeric value of 1 to " + ConfigurationData.DBTYPE.length);
                continue;
            }
            break;
        }
    }
}

