/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.credit;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CreditManagerPayment
implements ICreditManager {
    private MPayment payment;

    public CreditManagerPayment(MPayment po) {
        this.payment = po;
    }

    @Override
    public CreditStatus checkCreditStatus(String docAction) {
        Object errorMsg = null;
        if ("PR".equals(docAction) && !this.payment.isReceipt()) {
            MBPartner bp = new MBPartner(this.payment.getCtx(), this.payment.getC_BPartner_ID(), this.payment.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                errorMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                errorMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
        } else if ("CO".equals(docAction)) {
            boolean createdAllocationRecords = false;
            if (this.payment.getC_Charge_ID() == 0) {
                createdAllocationRecords = this.payment.allocateIt();
                this.payment.testAllocation();
            }
            if (this.payment.getC_BPartner_ID() != 0 && this.payment.getC_Invoice_ID() == 0 && this.payment.getC_Charge_ID() == 0 && MPaymentAllocate.get(this.payment).length == 0 && !createdAllocationRecords) {
                Properties ctx = this.payment.getCtx();
                MBPartner bp = new MBPartner(ctx, this.payment.getC_BPartner_ID(), this.payment.get_TrxName());
                DB.getDatabase().forUpdate(bp, 0);
                BigDecimal payAmt = null;
                int baseCurrencyId = Env.getContextAsInt(ctx, "$C_Currency_ID");
                if (this.payment.getC_Currency_ID() != baseCurrencyId && this.payment.isOverrideCurrencyRate()) {
                    payAmt = this.payment.getConvertedAmt();
                } else {
                    payAmt = MConversionRate.convertBase(ctx, this.payment.getPayAmt(), this.payment.getC_Currency_ID(), this.payment.getDateAcct(), this.payment.getC_ConversionType_ID(), this.payment.getAD_Client_ID(), this.payment.getAD_Org_ID());
                    if (payAmt == null) {
                        errorMsg = MConversionRateUtil.getErrorMessage(ctx, "ErrorConvertingCurrencyToBaseCurrency", this.payment.getC_Currency_ID(), MClient.get(ctx).getC_Currency_ID(), this.payment.getC_ConversionType_ID(), this.payment.getDateAcct(), this.payment.get_TrxName());
                    }
                }
                BigDecimal newBalance = bp.getTotalOpenBalance();
                if (newBalance == null) {
                    newBalance = Env.ZERO;
                }
                newBalance = this.payment.isReceipt() ? newBalance.subtract(payAmt) : newBalance.add(payAmt);
                bp.setTotalOpenBalance(newBalance);
                bp.setSOCreditStatus();
                bp.saveEx();
            }
        } else if (("RA".equals(docAction) || "RC".equals(docAction)) && this.payment.getC_BPartner_ID() != 0) {
            MBPartner bp = new MBPartner(this.payment.getCtx(), this.payment.getC_BPartner_ID(), this.payment.get_TrxName());
            bp.setTotalOpenBalance();
            bp.saveEx(this.payment.get_TrxName());
        }
        return new CreditStatus((String)errorMsg, !Util.isEmpty(errorMsg));
    }
}

