/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRoleMenu;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
@Deprecated
public class UpdateRoleMenu
extends SvrProcess {
    private int p_role_id = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Role_ID")) {
                    this.p_role_id = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    private MRoleMenu addUpdateRole(Properties ctx, int roleId, int menuId, boolean active, String trxName) {
        MRoleMenu roleMenu;
        StringBuilder whereClause = new StringBuilder("AD_Role_ID=").append(roleId).append(" AND U_WebMenu_ID=").append(menuId);
        int[] roleMenuIds = MRoleMenu.getAllIDs((String)"U_RoleMenu", (String)whereClause.toString(), (String)trxName);
        if (roleMenuIds.length == 1) {
            roleMenu = new MRoleMenu(ctx, roleMenuIds[0], trxName);
        } else if (roleMenuIds.length == 0) {
            roleMenu = new MRoleMenu(ctx, 0, trxName);
        } else {
            throw new IllegalStateException("More than one role menu defined.");
        }
        roleMenu.setAD_Role_ID(roleId);
        roleMenu.setU_WebMenu_ID(menuId);
        roleMenu.setIsActive(active);
        if (!roleMenu.save()) {
            throw new IllegalStateException("Could not create/update role menu, RoleMenuId: " + roleMenu.get_ID());
        }
        return roleMenu;
    }

    protected String doIt() throws Exception {
        if (this.p_role_id == 0) {
            throw new Exception("No Role defined or cannot assign menus to System Administrator");
        }
        String sqlStmt = "SELECT U_WebMenu_ID, IsActive FROM U_WebMenu";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlStmt, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int menuId = rs.getInt(1);
                    boolean active = "Y".equals(rs.getString(2));
                    this.addUpdateRole(this.getCtx(), this.p_role_id, menuId, active, this.get_TrxName());
                }
                this.commitEx();
            }
            catch (Exception ex) {
                this.rollback();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "Role updated successfully";
    }
}

