/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.process;

import java.util.ArrayList;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MField;
import org.compiere.model.MProcessPara;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_FieldSuggestion;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Process
public class AcceptFieldSuggestion
extends SvrProcess {
    private boolean p_updateBaseLanguage;
    private String p_fieldSuggestionTarget;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("IsUpdateBaseLanguage")) {
                    this.p_updateBaseLanguage = para.getParameterAsBoolean();
                } else if (name.equals("FieldSuggestionTarget")) {
                    this.p_fieldSuggestionTarget = para.getParameterAsString();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        X_AD_FieldSuggestion suggestion = new X_AD_FieldSuggestion(Env.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if ("E".equals(this.p_fieldSuggestionTarget)) {
            return this.updateElement(suggestion);
        }
        if ("F".equals(this.p_fieldSuggestionTarget)) {
            return this.updateField(suggestion);
        }
        this.addLog("Invalid target for application of changes: " + this.p_fieldSuggestionTarget);
        return "@Error@";
    }

    private String updateField(X_AD_FieldSuggestion suggestion) {
        boolean changed = false;
        if (this.p_updateBaseLanguage) {
            MField field = new MField(this.getCtx(), suggestion.getAD_Field_ID(), this.get_TrxName());
            if (!Util.isEmpty((String)suggestion.getName())) {
                field.setName(suggestion.getName());
            }
            if (!Util.isEmpty((String)suggestion.getDescription())) {
                field.setDescription(suggestion.getDescription());
            }
            if (!Util.isEmpty((String)suggestion.getHelp())) {
                field.setHelp(suggestion.getHelp());
            }
            if (field.is_Changed()) {
                field.setIsCentrallyMaintained(false);
                field.saveEx();
                changed = true;
            }
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder update = new StringBuilder("UPDATE AD_Field_Trl SET ");
        if (!Util.isEmpty((String)suggestion.getName())) {
            update.append("Name=? ");
            params.add(suggestion.getName());
        }
        if (!Util.isEmpty((String)suggestion.getDescription())) {
            if (!params.isEmpty()) {
                update.append(", ");
            }
            update.append("Description=? ");
            params.add(suggestion.getDescription());
        }
        if (!Util.isEmpty((String)suggestion.getHelp())) {
            if (!params.isEmpty()) {
                update.append(", ");
            }
            update.append("Help=? ");
            params.add(suggestion.getHelp());
        }
        if (!params.isEmpty()) {
            update.append("WHERE AD_Field_ID=? AND AD_Language=?");
            params.add(suggestion.getAD_Field_ID());
            params.add(suggestion.getAD_Language());
            DB.executeUpdateEx((String)update.toString(), (Object[])params.toArray(), (String)this.get_TrxName());
            changed = true;
        }
        suggestion.setIsApproved(true);
        suggestion.setIsUpdateBaseLanguage(this.p_updateBaseLanguage);
        suggestion.setProcessed(true);
        suggestion.saveEx();
        if (changed) {
            return "Suggestion accepted and applied to field";
        }
        return "No changes found";
    }

    private String updateElement(X_AD_FieldSuggestion suggestion) {
        boolean changed = false;
        MField mField = new MField(this.getCtx(), suggestion.getAD_Field_ID(), this.get_TrxName());
        M_Element element = new M_Element(this.getCtx(), mField.getAD_Column().getAD_Element_ID(), this.get_TrxName());
        if (this.p_updateBaseLanguage) {
            if (!Util.isEmpty((String)suggestion.getName())) {
                element.setName(suggestion.getName());
            }
            if (!Util.isEmpty((String)suggestion.getDescription())) {
                element.setDescription(suggestion.getDescription());
            }
            if (!Util.isEmpty((String)suggestion.getHelp())) {
                element.setHelp(suggestion.getHelp());
            }
            if (element.is_Changed()) {
                element.saveEx();
                changed = true;
            }
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder update = new StringBuilder("UPDATE AD_Element_Trl SET ");
        if (!Util.isEmpty((String)suggestion.getName())) {
            update.append("Name=? ");
            params.add(suggestion.getName());
        }
        if (!Util.isEmpty((String)suggestion.getDescription())) {
            if (!params.isEmpty()) {
                update.append(", ");
            }
            update.append("Description=? ");
            params.add(suggestion.getDescription());
        }
        if (!Util.isEmpty((String)suggestion.getHelp())) {
            if (!params.isEmpty()) {
                update.append(", ");
            }
            update.append("Help=? ");
            params.add(suggestion.getHelp());
        }
        if (!params.isEmpty()) {
            update.append("WHERE AD_Element_ID=? AND AD_Language=?");
            params.add(element.getAD_Element_ID());
            params.add(suggestion.getAD_Language());
            DB.executeUpdateEx((String)update.toString(), (Object[])params.toArray(), (String)this.get_TrxName());
            changed = true;
        }
        suggestion.setIsApproved(true);
        suggestion.setIsUpdateBaseLanguage(this.p_updateBaseLanguage);
        suggestion.setProcessed(true);
        suggestion.saveEx();
        if (changed) {
            return "Suggestion accepted and applied to element";
        }
        return "No changes found";
    }
}

