/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.datatable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.zk.datatable.DatatableReportRenderer;
import org.json.JSONArray;
import org.json.JSONString;

public class DataTableOptions {
    public final Integer DESC_OFFSET = 1000000;
    private HashMap<DatatableReportRenderer.FunctionTypes, ArrayList<Integer>> functionMap = new HashMap();
    private Integer printColLastIndex;
    private String locale;

    public DataTableOptions(String locale) {
        this.locale = locale;
    }

    public String getDataTableOptions(String path) {
        String footerFunction;
        String groupByDataSrc;
        StringBuilder dataOptions = new StringBuilder();
        dataOptions.append(" { ");
        dataOptions.append(" pageLength: ").append(250);
        dataOptions.append(", lengthMenu: [ [250, 500, 1000, -1], [250, 500, 1000,\"").append(Msg.getMsg((String)Language.getAD_Language((String)this.locale), (String)"All")).append("\" ] ] ");
        dataOptions.append(", colReorder: ").append(true);
        dataOptions.append(", responsive: ").append(true);
        dataOptions.append(", ordering: ").append(true);
        dataOptions.append(", search: { return: ").append(true).append(" }");
        dataOptions.append(", language: { url: '").append(path).append("DataTables/i18n/").append(this.locale).append(".json' }");
        dataOptions.append(", dom: \"lfrtip\" ");
        dataOptions.append(", initComplete:").append(" function () { this.api().columns().every( function () { var that = this; $('input', this.footer()).on('keyup change clear', function () { if (that.search() !== this.value) {  that.search(this.value).draw();}});});}");
        String orderBy = this.getOrderBy();
        if (orderBy != null) {
            dataOptions.append(", order: ").append(orderBy);
        }
        if ((groupByDataSrc = this.getGroupDataSrc()) != null) {
            dataOptions.append(", rowGroup: { ");
            dataOptions.append(" dataSrc: ").append(groupByDataSrc);
            String aggregateFunctions = this.getRowGroupRendered();
            if (!Util.isEmpty((String)aggregateFunctions)) {
                dataOptions.append(" , ").append(" endRender: ").append(aggregateFunctions);
                dataOptions.append(" , ").append(" startRender: null ");
            }
            dataOptions.append(" } ");
        }
        if (!Util.isEmpty((String)(footerFunction = this.getFootAggregateFunctions()))) {
            dataOptions.append(", footerCallback: ").append(footerFunction);
        }
        dataOptions.append(" } ");
        return dataOptions.toString();
    }

    private String getRowGroupRendered() {
        ArrayList<Integer> groupByList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.GROUP_BY);
        Integer groupBy = groupByList.get(0);
        TreeMap<Integer, String[]> groupRowNamesMap = new TreeMap<Integer, String[]>();
        StringBuilder retValue = new StringBuilder();
        retValue.append(" function ( rows, group ) { ");
        retValue.append(" let locale = '" + this.locale + "'; ");
        String groupName = "groupBy_" + String.valueOf(groupBy);
        retValue.append(" let ").append(groupName);
        retValue.append(" = group; ");
        String[] stringArray = new String[2];
        stringArray[0] = groupName;
        groupRowNamesMap.put(groupBy, stringArray);
        retValue.append(" let totalRows = []; ");
        retValue.append(" let displayRows = rows.data(); ");
        retValue.append(" rows.rows().data().filter(function(value, index) { ").append(" let groupValue = null; ").append(" if(value[").append(groupBy).append("].includes('<a ')) { ").append(" let htmlObject = $(value[").append(groupBy).append("]);").append(" groupValue = htmlObject[0].innerText;").append(" } else { ").append(" groupValue = value[").append(groupBy).append("] }  ").append(" if( groupValue === group ) ").append(" { totalRows.push(value);  } ").append(" }); ");
        this.setAggregateFunctions(retValue, groupRowNamesMap);
        retValue.append(" let rowRender = $('<tr/>') ");
        Integer prevColIndex = 0;
        for (Map.Entry<Integer, String[]> groupRowNameSet : groupRowNamesMap.entrySet()) {
            Integer actualColIndex = groupRowNameSet.getKey();
            String[] varValues = groupRowNameSet.getValue();
            if (actualColIndex - prevColIndex > 0) {
                retValue.append(".append( '<td ");
                retValue.append("colspan=\"").append(actualColIndex - prevColIndex).append("\"/>");
                retValue.append("')");
            }
            if (varValues != null && varValues.length == 2) {
                String varName = varValues[0];
                String varTotalName = varValues[1];
                if (varName.contains("groupBy_")) {
                    retValue.append(".append( '<td class=\"datatable-text\" >  ");
                } else {
                    retValue.append(".append( '<td class=\"datatable-number\" > ");
                }
                if (!Util.isEmpty((String)varName)) {
                    retValue.append("'+" + varName + "+'");
                }
                if (!Util.isEmpty((String)varTotalName)) {
                    retValue.append(" <br> ('+" + varTotalName + "+')");
                }
                if (varName.contains("groupBy_")) {
                    retValue.append("  \u03a3 ");
                }
            }
            retValue.append("</td>' )");
            prevColIndex = varValues == null ? actualColIndex : actualColIndex + 1;
        }
        if (prevColIndex < this.printColLastIndex + 1) {
            retValue.append(".append( '<td ");
            if (this.printColLastIndex + 1 - prevColIndex > 1) {
                retValue.append("colspan=\"").append(this.printColLastIndex + 1 - prevColIndex).append("\"/>");
            }
            retValue.append("') ");
        }
        retValue.append("; ");
        retValue.append("return rowRender;");
        retValue.append(" } ");
        return retValue.toString();
    }

    private String getFootAggregateFunctions() {
        TreeMap<Integer, String[]> groupRowNamesMap = new TreeMap<Integer, String[]>();
        StringBuilder retValue = new StringBuilder();
        retValue.append(" function ( tfoot, data, start, end, display ) { ");
        retValue.append(" let api = this.api(); ");
        retValue.append(" let locale = '" + this.locale + "'; ");
        ArrayList<Integer> groupByList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.GROUP_BY);
        if (groupByList != null) {
            Integer groupBy = groupByList.get(0);
            String groupName = "groupBy_" + String.valueOf(groupBy);
            retValue.append(" let ").append(groupName);
            retValue.append(" = ' \u03a3'; ");
            String[] stringArray = new String[2];
            stringArray[0] = groupName;
            groupRowNamesMap.put(groupBy, stringArray);
        }
        retValue.append(" let totalRows = data; ");
        retValue.append(" let displayRows = api.rows({ page: 'current' }).data(); ");
        this.setAggregateFunctions(retValue, groupRowNamesMap);
        for (Map.Entry<Integer, String[]> groupRowNameSet : groupRowNamesMap.entrySet()) {
            Integer actualColIndex = groupRowNameSet.getKey();
            String[] varValues = groupRowNameSet.getValue();
            if (varValues == null || varValues.length != 2) continue;
            String varValue = varValues[0];
            String varTotalValue = varValues[1];
            retValue.append(" $( api.column( ");
            retValue.append(actualColIndex);
            retValue.append(" ).footer() ).html(").append(varValue);
            if (!Util.isEmpty((String)varTotalValue)) {
                retValue.append(" ).append('<br>') ");
                retValue.append(".append( '(' + ").append(varTotalValue).append(" +')'");
            }
            retValue.append(" ) ");
            if (varValue.contains("groupBy_")) {
                retValue.append(".addClass( 'datatable-text');");
                continue;
            }
            retValue.append(".addClass( 'datatable-number');");
        }
        retValue.append(" } ");
        return retValue.toString();
    }

    private void setAggregateFunctions(StringBuilder retValue, TreeMap<Integer, String[]> groupRowNamesMap) {
        String varName;
        String varTotalName;
        ArrayList<Integer> averageList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.AVG);
        ArrayList<Integer> countList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.COUNT);
        ArrayList<Integer> deviationList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.DEVIATION);
        ArrayList<Integer> maxList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.MAX);
        ArrayList<Integer> minList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.MIN);
        ArrayList<Integer> sumList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.SUM);
        ArrayList<Integer> varianceList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.VARIANCE);
        if (averageList != null) {
            for (Integer averageID : averageList) {
                varTotalName = "average_total_" + String.valueOf(averageID);
                retValue.append(" let ").append(varTotalName).append(" =  new Intl.NumberFormat(locale).format(+(( totalRows.map(i => new NumberParser(locale).parse(i[").append(averageID).append("])).reduce( function (a, b) { return a + b*1; }, 0) ");
                retValue.append(" / totalRows.length ).toFixed(4))); ");
                varName = "average_" + String.valueOf(averageID);
                groupRowNamesMap.put(averageID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" =  new Intl.NumberFormat(locale).format(+(( displayRows.map(i => new NumberParser(locale).parse(i[").append(averageID).append("])).reduce( function (a, b) { return a + b*1; }, 0) ");
                retValue.append(" / displayRows.length ).toFixed(4))); ");
            }
        }
        if (countList != null) {
            for (Integer countID : countList) {
                varTotalName = "count_total_" + String.valueOf(countID);
                retValue.append(" let ").append(varTotalName).append(" =  new Intl.NumberFormat(locale).format(totalRows.length); ");
                varName = "count_" + String.valueOf(countID);
                groupRowNamesMap.put(countID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" =  new Intl.NumberFormat(locale).format(displayRows.length); ");
            }
        }
        if (sumList != null) {
            for (Integer sumID : sumList) {
                varTotalName = "sum_total_" + String.valueOf(sumID);
                retValue.append(" let ").append(varTotalName).append(" =  new Intl.NumberFormat(locale).format(+((totalRows.map(i => new NumberParser(locale).parse(i[").append(sumID).append("])).reduce( function (a, b) { return a + b*1; }, 0)).toFixed(4))); ");
                varName = "sum_" + String.valueOf(sumID);
                groupRowNamesMap.put(sumID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" =  new Intl.NumberFormat(locale).format(+((displayRows.map(i => new NumberParser(locale).parse(i[").append(sumID).append("])).reduce( function (a, b) { return a + b*1; }, 0)).toFixed(4))); ");
            }
        }
        if (maxList != null) {
            for (Integer maxID : maxList) {
                varTotalName = "max_total_" + String.valueOf(maxID);
                retValue.append(" let ").append(varTotalName).append(" =  new Intl.NumberFormat(locale).format(totalRows.map(i => new NumberParser(locale).parse(i[").append(maxID).append("])).reduce(function(a, b) { return Math.max(a, b);})); ");
                varName = "max_" + String.valueOf(maxID);
                groupRowNamesMap.put(maxID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" =  new Intl.NumberFormat(locale).format(displayRows.map(i => new NumberParser(locale).parse(i[").append(maxID).append("])).reduce(function(a, b) { return Math.max(a, b);})); ");
            }
        }
        if (minList != null) {
            for (Integer minID : minList) {
                varTotalName = "min_total_" + String.valueOf(minID);
                retValue.append(" let ").append(varTotalName).append(" =  new Intl.NumberFormat(locale).format( totalRows.map(i => new NumberParser(locale).parse(i[").append(minID).append("])).reduce(function(a, b) { return Math.min(a, b);})); ");
                varName = "min_" + String.valueOf(minID);
                groupRowNamesMap.put(minID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" =  new Intl.NumberFormat(locale).format( displayRows.map(i => new NumberParser(locale).parse(i[").append(minID).append("])).reduce(function(a, b) { return Math.min(a, b);})); ");
            }
        }
        if (varianceList != null) {
            for (Integer varianceID : varianceList) {
                varTotalName = "variance_total_" + String.valueOf(varianceID);
                retValue.append(" let ").append(varTotalName).append(" = totalRows.map((i) => { return { sum: new NumberParser(locale).parse(i[").append(varianceID).append("]), sumSquare: (new NumberParser(locale).parse(i[").append(varianceID).append("]) * new NumberParser(locale).parse(i[").append(varianceID).append("]))  ").append(" }; } )");
                retValue.append(".reduce( function (a, b) { let c = { sum: a.sum + b.sum*1, sumSquare: a.sumSquare + b.sumSquare*1 }; return c; }, { sum: 0, sumSquare: 0 }); ");
                retValue.append(varTotalName).append(" = new Intl.NumberFormat(locale).format( +(((").append(varTotalName).append(".sumSquare - (( ").append(varTotalName).append(".sum * ").append(varTotalName).append(".sum ) / totalRows.length ))/ totalRows.length ).toFixed(4))); ");
                varName = "variance_" + String.valueOf(varianceID);
                groupRowNamesMap.put(varianceID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" = displayRows.map((i) => { return { sum: new NumberParser(locale).parse(i[").append(varianceID).append("]), sumSquare: (new NumberParser(locale).parse(i[").append(varianceID).append("]) * new NumberParser(locale).parse(i[").append(varianceID).append("]))  ").append(" }; } )");
                retValue.append(".reduce( function (a, b) { let c = { sum: a.sum + b.sum*1, sumSquare: a.sumSquare + b.sumSquare*1 }; return c; }, { sum: 0, sumSquare: 0 }); ");
                retValue.append(varName).append(" = new Intl.NumberFormat(locale).format( +(((").append(varName).append(".sumSquare - (( ").append(varName).append(".sum * ").append(varName).append(".sum ) / displayRows.length ))/ displayRows.length ).toFixed(4))); ");
            }
        }
        if (deviationList != null) {
            for (Integer deviationID : deviationList) {
                varTotalName = "deviation_total_" + String.valueOf(deviationID);
                retValue.append(" let ").append(varTotalName).append(" = totalRows.map((i) => { return { sum: new NumberParser(locale).parse(i[").append(deviationID).append("]), sumSquare: (new NumberParser(locale).parse(i[").append(deviationID).append("]) * new NumberParser(locale).parse(i[").append(deviationID).append("]))  ").append(" }; } )");
                retValue.append(".reduce( function (a, b) { let c = { sum: a.sum + b.sum*1, sumSquare: a.sumSquare + b.sumSquare*1 }; return c; }, { sum: 0, sumSquare: 0 }); ");
                retValue.append(varTotalName).append(" = ((").append(varTotalName).append(".sumSquare - (( ").append(varTotalName).append(".sum * ").append(varTotalName).append(".sum ) / totalRows.length ))/ totalRows.length ); ");
                retValue.append(varTotalName).append(" =  new Intl.NumberFormat(locale).format(+(Math.sqrt(").append(varTotalName).append(").toFixed(4)));");
                varName = "deviation_" + String.valueOf(deviationID);
                groupRowNamesMap.put(deviationID, new String[]{varName, varTotalName});
                retValue.append(" let ").append(varName).append(" = displayRows.map((i) => { return { sum: new NumberParser(locale).parse(i[").append(deviationID).append("]), sumSquare: (new NumberParser(locale).parse(i[").append(deviationID).append("]) * new NumberParser(locale).parse(i[").append(deviationID).append("]))  ").append(" }; } )");
                retValue.append(".reduce( function (a, b) { let c = { sum: a.sum + b.sum*1, sumSquare: a.sumSquare + b.sumSquare*1 }; return c; }, { sum: 0, sumSquare: 0 }); ");
                retValue.append(varName).append(" = ((").append(varName).append(".sumSquare - (( ").append(varName).append(".sum * ").append(varName).append(".sum ) / displayRows.length ))/ displayRows.length ); ");
                retValue.append(varName).append(" =  new Intl.NumberFormat(locale).format(+(Math.sqrt(").append(varName).append(").toFixed(4)));");
            }
        }
    }

    public void addPrintColumnIndex(DatatableReportRenderer.FunctionTypes type, Integer id) {
        ArrayList<Integer> list = this.functionMap.get((Object)type);
        if (list == null) {
            list = new ArrayList();
            this.functionMap.put(type, list);
        }
        list.add(id);
    }

    private String getGroupDataSrc() {
        StringBuilder retValue = new StringBuilder();
        ArrayList<Integer> groupByList = this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.GROUP_BY);
        if (groupByList == null) {
            return null;
        }
        if (groupByList.size() > 1) {
            retValue.append(" [ ");
        }
        int index = 0;
        while (index < groupByList.size()) {
            Integer groupBy = groupByList.get(index);
            StringBuilder function = new StringBuilder();
            function.append("function(row) { ").append(" if(row[").append(groupBy).append("].includes('<a ')) { ").append(" let htmlObject = $(row[").append(groupBy).append("]);").append(" return htmlObject[0].innerText;").append(" } else { ").append(" return row[").append(groupBy).append("] } }");
            retValue.append(function.toString());
            if (index + 1 < groupByList.size()) {
                retValue.append(" , ");
            }
            ++index;
        }
        if (groupByList.size() > 1) {
            retValue.append(" ] ");
        }
        return retValue.toString();
    }

    private String getOrderBy() {
        String orderBy = this.orderListToJson(this.functionMap.get((Object)DatatableReportRenderer.FunctionTypes.ORDER_BY));
        return orderBy;
    }

    public Integer getPrintColLastIndex() {
        return this.printColLastIndex;
    }

    public void setPrintColLastIndex(Integer printColLastIndex) {
        this.printColLastIndex = printColLastIndex;
    }

    public String getLocale() {
        return this.locale;
    }

    private String orderListToJson(ArrayList<Integer> orderByList) {
        if (orderByList == null) {
            return null;
        }
        JSONArray orderArray = null;
        String orderString = "asc";
        for (int orderBy : orderByList) {
            if (orderArray == null) {
                orderArray = new JSONArray();
            }
            if (orderBy >= this.DESC_OFFSET) {
                orderBy -= this.DESC_OFFSET.intValue();
                orderString = "desc";
            } else {
                orderString = "asc";
            }
            JSONArray orderItem = new JSONArray();
            orderItem.put(orderBy);
            orderItem.put((Object)orderString);
            orderArray.put((Object)orderItem);
        }
        return orderArray.toString();
    }

    public class JSONFunction
    implements JSONString {
        private String string;

        public JSONFunction(String string) {
            this.string = string;
        }

        public String toJSONString() {
            return this.string;
        }
    }
}

