/*
 * Decompiled with CFR 0.152.
 */
package net.sf.compilo.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import net.sf.compilo.data.compiereDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;

public class ReportViewDataSource
extends compiereDataSource {
    private PrintData m_printData = null;
    private int m_index = 0;

    public ReportViewDataSource(Properties ctx, ProcessInfo pi, HashMap<String, Object> params) {
        ReportEngine re = ReportEngine.get((Properties)ctx, (ProcessInfo)pi);
        this.m_printData = re.getPrintData();
    }

    @Override
    public boolean next() throws JRException {
        if (this.m_index >= this.m_printData.getRowCount()) {
            return false;
        }
        this.m_printData.setRowIndex(this.m_index++);
        return true;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        PrintDataElement pde = (PrintDataElement)this.m_printData.getNode(field.getName());
        if (pde == null || pde.isNull()) {
            return null;
        }
        if (pde.isDate()) {
            return (Date)pde.getValue();
        }
        if (pde.isNumeric()) {
            return (BigDecimal)pde.getValue();
        }
        if (pde.isID() && field.getValueClassName().indexOf("Integer") >= 0) {
            return (Integer)pde.getValue();
        }
        if (pde.isID() && field.getValueClassName().indexOf("String") >= 0) {
            return pde.getValue().toString();
        }
        if (pde.isYesNo()) {
            return (Boolean)pde.getValue();
        }
        return pde.getValue().toString();
    }

    @Override
    public void close() {
    }
}

