/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.Core;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFNodePara;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProcessTest
extends AbstractTestCase {
    @Test
    public void testWorkflowProcess() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        int Process_Order = 104;
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)Process_Order);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setRecord_ID(order.get_ID());
        pi.setTransactionName(this.getTrxName());
        boolean ok = process.processIt(pi, this.getTrx(), false);
        if (!ok || pi.isError()) {
            Assertions.fail((String)("Error running Process_Order workflow process" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)order.getDocStatus().equals("CO"), (String)"Order not completed");
        pi = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"RE");
        if (pi.isError()) {
            Assertions.fail((String)("Failed to reactivate order" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)order.getDocStatus().equals("IP"), (String)"Order not reactivated");
    }

    @Test
    public void testJavaProcess() {
        int Verify_BOM = 136;
        int Patio_Chair = DictionaryIDs.M_Product.P_CHAIR.id;
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)Verify_BOM);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setRecord_ID(Patio_Chair);
        pi.setTransactionName(this.getTrxName());
        boolean ok = process.processIt(pi, this.getTrx(), false);
        if (!ok || pi.isError()) {
            Assertions.fail((String)("Error running Verify BOM process" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        pi = new ProcessInfo(process.getName(), process.get_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setRecord_ID(Patio_Chair);
        pi.setTransactionName(this.getTrxName());
        if (process.getAD_PrintFormat_ID() > 0) {
            pi.setTransientObject((Object)process.getAD_PrintFormat());
        }
        ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx());
        if (pi.isError()) {
            Assertions.fail((String)("Error running Verify BOM process" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
    }

    @Test
    public void testChainWorkflow() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)118));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)128));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        if (pi.isError()) {
            Assertions.fail((String)("Failed to complete order" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Expected Completed Status for Order");
        MOrder order1 = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order1.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)118));
        order1.setC_DocTypeTarget_ID("SO");
        order1.setDeliveryRule("O");
        order1.setDocStatus("DR");
        order1.setDocAction("CO");
        order1.setDateOrdered(today);
        order1.setDatePromised(today);
        order1.saveEx();
        MOrderLine line2 = new MOrderLine(order1);
        line2.setLine(10);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)128));
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(today);
        line2.saveEx();
        pi = MWorkflow.runDocumentActionWorkflow((PO)order1, (String)"CO");
        if (pi.isError()) {
            Assertions.fail((String)("Failed to complete order" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        order1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order1.getDocStatus(), (String)"Expected Completed Status for Order");
        int Process_InOutConfirmation = 124;
        MWorkflow wf = new MWorkflow(Env.getCtx(), Process_InOutConfirmation, null);
        MWFNode processNode = new MWFNode(wf, "Process_InOut", "Process_InOut");
        processNode.set_ValueNoCheck("AD_Client_ID", (Object)this.getAD_Client_ID());
        processNode.setAction("P");
        processNode.setAD_Process_ID(109);
        processNode.setEntityType("U");
        processNode.saveEx();
        MWFNodePara processNodePara = new MWFNodePara(Env.getCtx(), 0, null);
        processNodePara.set_ValueNoCheck("AD_Org_ID", (Object)0);
        processNodePara.setAD_WF_Node_ID(processNode.getAD_WF_Node_ID());
        processNodePara.setAttributeName("Record_ID");
        processNodePara.setAttributeValue("@M_InOut_ID@");
        processNodePara.setEntityType("U");
        processNodePara.saveEx();
        MWFNode docCompleteNode = new MWFNode(Env.getCtx(), 219, null);
        MWFNodeNext docCompleteNodeNext = new MWFNodeNext(docCompleteNode, processNode.getAD_WF_Node_ID());
        docCompleteNodeNext.set_ValueNoCheck("AD_Client_ID", (Object)this.getAD_Client_ID());
        docCompleteNodeNext.setEntityType("U");
        docCompleteNodeNext.saveEx();
        try {
            int MM_Shipment = 120;
            MInOut inout1 = new MInOut(order1, MM_Shipment, order1.getDateOrdered());
            inout1.setDocStatus("DR");
            inout1.setDocAction("CO");
            inout1.saveEx();
            int MM_Shipment_With_Pick = 148;
            MInOut inout = new MInOut(order, MM_Shipment_With_Pick, order.getDateOrdered());
            inout.setDocStatus("DR");
            inout.setDocAction("CO");
            inout.saveEx();
            MInOutLine il = new MInOutLine(inout);
            il.setOrderLine(line1, 0, new BigDecimal("1"));
            il.saveEx();
            pi = MWorkflow.runDocumentActionWorkflow((PO)inout, (String)"CO");
            if (pi.isError()) {
                Assertions.fail((String)("Failed to complete shipment" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
                return;
            }
            inout.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"IP", (Object)inout.getDocStatus(), (String)"Expected In Progress Status for Shipment");
            MInOutConfirm[] confirmations = inout.getConfirmations(true);
            Assertions.assertEquals((int)1, (int)confirmations.length, (String)"Expected 1 Shipment Confirmation Document");
            Assertions.assertTrue((confirmations[0].getM_InOutConfirm_ID() != inout.getM_InOut_ID() ? 1 : 0) != 0, (String)"Test should run with M_InOut_ID != M_InOutConfirm_ID");
            pi = MWorkflow.runDocumentActionWorkflow((PO)confirmations[0], (String)"CO");
            if (pi.isError()) {
                Assertions.fail((String)("Failed to complete shipment confirmation" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
                return;
            }
            confirmations[0].load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)confirmations[0].getDocStatus(), (String)"Expected Completed Status for Shipment Confirmation");
            inout.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)inout.getDocStatus(), (String)"Expected Completed Status for Shipment");
        }
        finally {
            this.rollback();
            docCompleteNodeNext.deleteEx(true);
            processNodePara.deleteEx(true);
            processNode.deleteEx(true);
        }
    }

    @Test
    public void testCoreJavaProcessMapping() {
        Query query = new Query(Env.getCtx(), "AD_Process", "AD_Process_ID < 1000000 AND ClassName IS NOT NULL  AND EXISTS (select 1 from ad_menu where isactive='Y' and ad_process_id=ad_process.ad_process_id)", this.getTrxName());
        List processes = query.setOnlyActiveRecords(true).list();
        for (MProcess process : processes) {
            ProcessCall pc = Core.getProcess((String)process.getClassname());
            Assertions.assertNotNull((Object)pc, (String)("Failed to load ProcessCall instance for " + process.toString() + ", " + process.getClassname()));
        }
    }

    @Test
    public void testGetInstanceLog() {
        MPInstancePara[] paras;
        MProcess process = MProcess.get((int)314);
        MPInstance pinstance = new MPInstance(process, 0, 0, null);
        MPInstancePara[] mPInstanceParaArray = paras = pinstance.getParameters();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara para = mPInstanceParaArray[n2];
            if (para.getParameterName().equals("C_BPartner_ID")) {
                para.setP_Number(DictionaryIDs.C_BPartner.JOE_BLOCK.id);
                para.saveEx();
                break;
            }
            ++n2;
        }
        ProcessInfo pi = new ProcessInfo(process.getName(), 314);
        pi.setAD_PInstance_ID(pinstance.getAD_PInstance_ID());
        process.processIt(pi, null, true);
        Assertions.assertTrue((!pi.isError() ? 1 : 0) != 0, (String)pi.getSummary());
        MPInstanceLog[] logs = pinstance.getLog();
        Assertions.assertTrue((logs != null && logs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve process instance logs");
        Assertions.assertEquals((int)pinstance.getAD_PInstance_ID(), (int)logs[0].getAD_PInstance_ID(), (String)"Invalid MPInstanceLog.AD_PInstance_ID value");
        Assertions.assertTrue((logs[0].getAD_PInstance_Log_UU() != null && logs[0].getAD_PInstance_Log_UU().length() == 36 ? 1 : 0) != 0, (String)"Invalid MPInstanceLog.AD_PInstance_Log_UU value");
        Assertions.assertEquals((Object)"R", (Object)logs[0].getPInstanceLogType(), (String)"Invalid MPInstanceLog.PInstanceLogType value");
    }
}

