/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.IMappedColumnCalloutFactory;
import org.adempiere.base.MappedColumnCalloutFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.TestActivator;
import org.idempiere.test.model.annotated.MyAnnotatedTestQtyCallout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.osgi.framework.BundleContext;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class MappedColumnCalloutFactoryTest
extends AbstractTestCase {
    @Test
    @Order(value=1)
    public void testDefaultMappedColumnCalloutFactory() {
        IMappedColumnCalloutFactory factory = Core.getMappedColumnCalloutFactory();
        factory.addMapping("Test", "T_Amount", () -> new MyTestAmountCallout());
        List list = Core.findCallout((String)"Test", (String)"T_Amount");
        Optional<IColumnCallout> optional = list.stream().filter(e -> e instanceof MyTestAmountCallout).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Can't find MyTestAmountCallout column callout for Test.T_Amount");
        factory.scan(TestActivator.context, new String[]{"org.idempiere.test.model.annotated"});
        list = Core.findCallout((String)"Test", (String)"T_Qty");
        optional = list.stream().filter(e -> e instanceof MyAnnotatedTestQtyCallout).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Can't find MyAnnotatedTestQtyCallout column callout for Test.T_Qty");
    }

    @Test
    @Order(value=2)
    public void testCustomMappedColumnCalloutFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IColumnCalloutFactory.class, (Object)new MyFactory(), properties);
        List list = Core.findCallout((String)"Test", (String)"T_Amount");
        Optional<IColumnCallout> optional = list.stream().filter(e -> e instanceof MyTestAmountCallout2).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Can't find MyTestAmountCallout2 column callout for Test.T_Amount");
    }

    private static final class MyFactory
    extends MappedColumnCalloutFactory {
        public MyFactory() {
            this.addMapping("Test", "T_Amount", () -> new MyTestAmountCallout2());
        }
    }

    private static final class MyTestAmountCallout
    implements IColumnCallout {
        private MyTestAmountCallout() {
        }

        public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            return null;
        }
    }

    private static final class MyTestAmountCallout2
    implements IColumnCallout {
        private MyTestAmountCallout2() {
        }

        public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            return null;
        }
    }
}

