/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedAssetsTest
extends AbstractTestCase {
    @Test
    public void test18MonthsDepreciation() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MAssetGroupAcct aga = new MAssetGroupAcct(ctx, DictionaryIDs.A_Asset_Group_Acct.EQUIPMENT_DOLLAR.id, trxName);
        aga.setUseLifeMonths(18);
        aga.setUseLifeYears(Env.ZERO);
        aga.setUseLifeMonths_F(18);
        aga.setUseLifeYears_F(Env.ZERO);
        aga.saveEx();
        aga.load(trxName, new String[0]);
        Assertions.assertTrue((new BigDecimal("1.5").compareTo(aga.getUseLifeYears()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new BigDecimal("1.5").compareTo(aga.getUseLifeYears_F()) == 0 ? 1 : 0) != 0);
        MAsset a = new MAsset(ctx, 0, trxName);
        a.setValue("test_18_m");
        a.setName("test_18_m");
        a.setA_Asset_Group_ID(DictionaryIDs.A_Asset_Group.EQUIPMENT.id);
        a.setM_Product_ID(DictionaryIDs.M_Product.ASSET_VEHICLE.id);
        a.setIsOwned(true);
        a.setIsDepreciated(true);
        a.saveEx();
        MAssetAddition aa = new MAssetAddition(ctx, 0, trxName);
        aa.setA_Asset_ID(a.getA_Asset_ID());
        aa.setDateDoc(new Timestamp(System.currentTimeMillis()));
        aa.setA_SourceType("MAN");
        aa.setAssetAmtEntered(new BigDecimal("12000.0"));
        aa.setAssetSourceAmt(aa.getAssetAmtEntered());
        aa.setA_Salvage_Value(new BigDecimal("2000.0"));
        aa.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)aa, (String)"CO");
        aa.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing asset addition: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)aa.getDocStatus(), (String)("Asset addition status is not completed: " + aa.getDocStatus()));
        Assertions.assertTrue((boolean)aa.isPosted(), (String)"Asset addition not posted");
        int cnt = DB.getSQLValueEx((String)trxName, (String)"SELECT COUNT(*) FROM A_Depreciation_Exp WHERE A_Asset_ID=? AND C_AcctSchema_ID=?", (Object[])new Object[]{a.getA_Asset_ID(), DictionaryIDs.C_AcctSchema.DOLLAR.id});
        Assertions.assertEquals((int)18, (int)cnt);
        BigDecimal sumExp = DB.getSQLValueBDEx((String)trxName, (String)"SELECT SUM(Expense) FROM A_Depreciation_Exp WHERE A_Asset_ID=? AND C_AcctSchema_ID=?", (Object[])new Object[]{a.getA_Asset_ID(), DictionaryIDs.C_AcctSchema.DOLLAR.id});
        Assertions.assertTrue((new BigDecimal("10000.0").compareTo(sumExp) == 0 ? 1 : 0) != 0);
    }
}

