/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchInvTest
extends AbstractTestCase {
    @Test
    public void testMatShipmentPosting() {
        MMatchInv[] miList;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(BigDecimal.ONE);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setName(order.getDocumentNo());
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.VENDOR_RETURN_MATERIAL.id);
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.setM_InOut_ID(receipt.get_ID());
        rma.setIsSOTrx(false);
        rma.setSalesRep_ID(100);
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setLine(10);
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(receiptLine.get_ID());
        rmaLine.setQty(BigDecimal.ONE);
        rmaLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
        MInOut delivery = new MInOut(Env.getCtx(), 0, this.getTrxName());
        delivery.setM_RMA_ID(rma.get_ID());
        delivery.setBPartner(bpartner);
        delivery.setIsSOTrx(false);
        delivery.setMovementType("V-");
        delivery.setC_DocType_ID(DictionaryIDs.C_DocType.MM_VENDOR_RETURN.id);
        delivery.setDocStatus("DR");
        delivery.setDocAction("CO");
        delivery.setM_Warehouse_ID(receipt.getM_Warehouse_ID());
        delivery.saveEx();
        MInOutLine deliveryLine = new MInOutLine(delivery);
        deliveryLine.setM_RMALine_ID(rmaLine.get_ID());
        deliveryLine.setLine(10);
        deliveryLine.setProduct(product);
        deliveryLine.setQty(BigDecimal.ONE);
        deliveryLine.setM_Locator_ID(receiptLine.getM_Locator_ID());
        deliveryLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)delivery, (String)"CO");
        delivery.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)delivery.getDocStatus());
        if (!delivery.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)delivery.getAD_Client_ID(), (int)319, (int)delivery.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        delivery.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)delivery.isPosted());
        MInvoice creditMemo = new MInvoice(delivery, delivery.getMovementDate());
        creditMemo.setC_DocTypeTarget_ID("APC");
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setM_InOutLine_ID(deliveryLine.get_ID());
        creditMemoLine.setLine(10);
        creditMemoLine.setProduct(product);
        creditMemoLine.setQty(BigDecimal.ONE);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
        if (!creditMemo.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)creditMemo.getAD_Client_ID(), (int)318, (int)creditMemo.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)creditMemo.isPosted());
        MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
        BigDecimal credMatchAmt = creditMemoLine.getMatchedQty().negate().multiply(creditMemoLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
        MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ids;
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount acctInvClr = pc.getAccount(10, as);
            String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            int n3 = ids.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)credMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctCr().toPlainString()));
                } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)credMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctDr().toPlainString()));
                }
                ++n4;
            }
            ++n2;
        }
        this.rollback();
    }

    @Test
    public void testMatReceiptPosting() {
        MMatchInv[] miList;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(BigDecimal.ONE);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
        BigDecimal invMatchAmt = invoiceLine.getMatchedQty().multiply(invoiceLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
        MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ids;
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount acctInvClr = pc.getAccount(10, as);
            String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            int n3 = ids.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctCr().toPlainString()));
                } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctCr().toPlainString()));
                }
                ++n4;
            }
            ++n2;
        }
        this.rollback();
    }

    @Test
    public void testCreditMemoPosting() {
        MMatchInv[] miList;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(BigDecimal.TEN);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setOrder(order);
        invoice.setDateAcct(order.getDateOrdered());
        invoice.setSalesRep_ID(order.getSalesRep_ID());
        invoice.setC_BPartner_ID(order.getBill_BPartner_ID());
        invoice.setC_BPartner_Location_ID(order.getBill_Location_ID());
        invoice.setAD_User_ID(order.getBill_User_ID());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setC_OrderLine_ID(orderLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(BigDecimal.TEN);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(new BigDecimal(9));
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
        BigDecimal invMatchAmt = invoiceLine.getMatchedQty().multiply(invoiceLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
        MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ids;
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount acctInvClr = pc.getAccount(10, as);
            String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            int n3 = ids.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctDr().toPlainString()));
                    Assertions.assertEquals((Object)mi.getQty(), (Object)fa.getQty(), (String)"Accounting fact quantity incorrect");
                } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctCr().toPlainString()));
                    Assertions.assertEquals((Object)mi.getQty().negate().setScale(2, RoundingMode.HALF_UP), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"Accounting fact quantity incorrect");
                }
                ++n4;
            }
            ++n2;
        }
        MInvoice creditMemo = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        creditMemo.setOrder(order);
        creditMemo.setDateAcct(order.getDateOrdered());
        creditMemo.setSalesRep_ID(order.getSalesRep_ID());
        creditMemo.setC_BPartner_ID(order.getBill_BPartner_ID());
        creditMemo.setC_BPartner_Location_ID(order.getBill_Location_ID());
        creditMemo.setAD_User_ID(order.getBill_User_ID());
        creditMemo.setC_DocTypeTarget_ID("APC");
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setC_OrderLine_ID(orderLine.get_ID());
        creditMemoLine.setLine(10);
        creditMemoLine.setProduct(product);
        creditMemoLine.setQty(BigDecimal.ONE);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
        if (!creditMemo.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)creditMemo.getAD_Client_ID(), (int)318, (int)creditMemo.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)creditMemo.isPosted());
        BigDecimal credMatchAmt = creditMemoLine.getMatchedQty().negate().multiply(creditMemoLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
        MMatchInv[] mMatchInvArray2 = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
        int n5 = miList.length;
        int n6 = 0;
        while (n6 < n5) {
            int[] ids;
            MMatchInv mi = mMatchInvArray2[n6];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount acctInvClr = pc.getAccount(10, as);
            BigDecimal amtAcctDrInvClr = BigDecimal.ZERO;
            BigDecimal amtAcctCrInvClr = BigDecimal.ZERO;
            String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            int n7 = ids.length;
            int n8 = 0;
            while (n8 < n7) {
                int id = nArray[n8];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctInvClr.getAccount_ID() && fa.getQty().compareTo(BigDecimal.ZERO) < 0) {
                    Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)credMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctCr().toPlainString()));
                    amtAcctCrInvClr = amtAcctCrInvClr.add(fa.getAmtAcctCr());
                    Assertions.assertEquals((Object)mi.getQty(), (Object)fa.getQty(), (String)"Accounting fact quantity incorrect");
                } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID() && fa.getQty().compareTo(BigDecimal.ZERO) > 0) {
                    Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)credMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)("MatchInv incorrect amount posted " + fa.getAmtAcctDr().toPlainString()));
                    amtAcctDrInvClr = amtAcctDrInvClr.add(fa.getAmtAcctDr());
                    Assertions.assertEquals((Object)mi.getQty().negate(), (Object)fa.getQty(), (String)"Accounting fact quantity incorrect");
                }
                ++n8;
            }
            Assertions.assertTrue((amtAcctDrInvClr.compareTo(amtAcctCrInvClr) == 0 ? 1 : 0) != 0);
            ++n6;
        }
        this.rollback();
    }

    @Test
    public void testMatReceiptPostingWithDiffCurrencyPrecision() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Purchase JPY " + System.currentTimeMillis());
        MCurrency japaneseYen = MCurrency.get((int)DictionaryIDs.C_Currency.JPY.id);
        priceList.setC_Currency_ID(japaneseYen.getC_Currency_ID());
        priceList.setPricePrecision(japaneseYen.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.PURCHASE_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        BigDecimal priceInYen = new BigDecimal(2400);
        MProductPrice pp = new MProductPrice(plv, product.getM_Product_ID(), priceInYen, priceInYen, Env.ZERO);
        pp.saveEx();
        BigDecimal yenToUsd = new BigDecimal(0.277582);
        MConversionRate cr1 = new MConversionRate(Env.getCtx(), 0, null);
        cr1.setC_Currency_ID(japaneseYen.getC_Currency_ID());
        cr1.setC_Currency_ID_To(DictionaryIDs.C_Currency.USD.id);
        cr1.setC_ConversionType_ID(DictionaryIDs.C_ConversionType.SPOT.id);
        cr1.setValidFrom(currentDate);
        cr1.setValidTo(currentDate);
        cr1.setMultiplyRate(yenToUsd);
        cr1.saveEx();
        BigDecimal euroToUsd = new BigDecimal(0.236675);
        MConversionRate cr2 = new MConversionRate(Env.getCtx(), 0, null);
        cr2.setC_Currency_ID(japaneseYen.getC_Currency_ID());
        cr2.setC_Currency_ID_To(DictionaryIDs.C_Currency.EUR.id);
        cr2.setC_ConversionType_ID(DictionaryIDs.C_ConversionType.SPOT.id);
        cr2.setValidFrom(currentDate);
        cr2.setValidTo(currentDate);
        cr2.setMultiplyRate(euroToUsd);
        cr2.saveEx();
        try {
            MMatchInv[] miList;
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setDateOrdered(currentDate);
            order.setDateAcct(currentDate);
            order.setM_PriceList_ID(priceList.getM_PriceList_ID());
            order.setC_ConversionType_ID(DictionaryIDs.C_ConversionType.SPOT.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(new BigDecimal(3));
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt.saveEx();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(product);
            receiptLine.setQty(new BigDecimal(3));
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDateInvoiced(currentDate);
            invoice.setDateAcct(currentDate);
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            BigDecimal qtyInvoiced = new BigDecimal(3);
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(qtyInvoiced);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
            BigDecimal acctAmount = priceInYen.multiply(yenToUsd).multiply(qtyInvoiced).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
            BigDecimal acctSource = priceInYen.multiply(qtyInvoiced).setScale(japaneseYen.getStdPrecision(), RoundingMode.HALF_UP);
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                int[] ids;
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
                int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    int id = nArray[n4];
                    MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                    if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                        Assertions.assertTrue((fa.getAmtAcctDr().compareTo(Env.ZERO) >= 0 ? 1 : 0) != 0);
                        Assertions.assertEquals((Object)acctAmount, (Object)fa.getAmtAcctDr(), (String)(fa.getAmtAcctDr().toPlainString() + " != " + acctAmount.toPlainString()));
                        Assertions.assertTrue((fa.getC_Currency_ID() == japaneseYen.getC_Currency_ID() ? 1 : 0) != 0);
                        Assertions.assertEquals((Object)acctSource, (Object)fa.getAmtSourceDr(), (String)(fa.getAmtSourceDr().toPlainString() + " != " + acctSource.toPlainString()));
                    } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                        Assertions.assertTrue((fa.getAmtAcctCr().compareTo(Env.ZERO) >= 0 ? 1 : 0) != 0);
                        Assertions.assertEquals((Object)acctAmount, (Object)fa.getAmtAcctCr(), (String)(fa.getAmtAcctCr().toPlainString() + " != " + acctAmount.toPlainString()));
                        Assertions.assertTrue((fa.getC_Currency_ID() == japaneseYen.getC_Currency_ID() ? 1 : 0) != 0);
                        Assertions.assertEquals((Object)acctSource, (Object)fa.getAmtSourceCr(), (String)(fa.getAmtSourceCr().toPlainString() + " != " + acctSource.toPlainString()));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            this.rollback();
            String whereClause = "ValidFrom=? AND ValidTo=? AND C_Currency_ID=? AND C_Currency_ID_To=? AND C_ConversionType_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
            MConversionRate reciprocal = (MConversionRate)new Query(Env.getCtx(), "C_Conversion_Rate", whereClause, null).setParameters(new Object[]{cr1.getValidFrom(), cr1.getValidTo(), cr1.getC_Currency_ID_To(), cr1.getC_Currency_ID(), cr1.getC_ConversionType_ID(), cr1.getAD_Client_ID(), cr1.getAD_Org_ID()}).firstOnly();
            if (reciprocal != null) {
                reciprocal.deleteEx(true);
            }
            cr1.deleteEx(true);
            reciprocal = (MConversionRate)new Query(Env.getCtx(), "C_Conversion_Rate", whereClause, null).setParameters(new Object[]{cr2.getValidFrom(), cr2.getValidTo(), cr2.getC_Currency_ID_To(), cr2.getC_Currency_ID(), cr2.getC_ConversionType_ID(), cr2.getAD_Client_ID(), cr2.getAD_Org_ID()}).firstOnly();
            if (reciprocal != null) {
                reciprocal.deleteEx(true);
            }
            cr2.deleteEx(true);
            pp.deleteEx(true);
            plv.deleteEx(true);
            priceList.deleteEx(true);
            throw throwable;
        }
        this.rollback();
        String whereClause = "ValidFrom=? AND ValidTo=? AND C_Currency_ID=? AND C_Currency_ID_To=? AND C_ConversionType_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
        MConversionRate reciprocal = (MConversionRate)new Query(Env.getCtx(), "C_Conversion_Rate", whereClause, null).setParameters(new Object[]{cr1.getValidFrom(), cr1.getValidTo(), cr1.getC_Currency_ID_To(), cr1.getC_Currency_ID(), cr1.getC_ConversionType_ID(), cr1.getAD_Client_ID(), cr1.getAD_Org_ID()}).firstOnly();
        if (reciprocal != null) {
            reciprocal.deleteEx(true);
        }
        cr1.deleteEx(true);
        reciprocal = (MConversionRate)new Query(Env.getCtx(), "C_Conversion_Rate", whereClause, null).setParameters(new Object[]{cr2.getValidFrom(), cr2.getValidTo(), cr2.getC_Currency_ID_To(), cr2.getC_Currency_ID(), cr2.getC_ConversionType_ID(), cr2.getAD_Client_ID(), cr2.getAD_Org_ID()}).firstOnly();
        if (reciprocal != null) {
            reciprocal.deleteEx(true);
        }
        cr2.deleteEx(true);
        pp.deleteEx(true);
        plv.deleteEx(true);
        priceList.deleteEx(true);
    }

    @Test
    public void testIsReversal() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(BigDecimal.ONE);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        MMatchInv[] beforeList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)beforeList.length);
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"RC");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)invoice.getDocStatus());
        MMatchInv[] afterList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)2, (int)afterList.length);
        beforeList[0].load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)beforeList[0].isReversal());
        MMatchInv[] mMatchInvArray = afterList;
        int n = afterList.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.equals((Object)beforeList[0])) {
                Assertions.assertTrue((boolean)mi.isReversal());
                break;
            }
            ++n2;
        }
    }

    @Test
    public void testIsReversalCM() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("2"));
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("2"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        MInvoice creditMemo = new MInvoice(receipt, receipt.getMovementDate());
        creditMemo.setC_DocTypeTarget_ID("APC");
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setM_InOutLine_ID(receiptLine.get_ID());
        creditMemoLine.setLine(10);
        creditMemoLine.setProduct(product);
        creditMemoLine.setQty(BigDecimal.ONE);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
        if (!creditMemo.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)creditMemo.getAD_Client_ID(), (int)318, (int)creditMemo.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)creditMemo.isPosted());
        MMatchInv[] beforeList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)beforeList.length);
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"RC");
        creditMemo.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)creditMemo.getDocStatus());
        MMatchInv[] afterList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)creditMemoLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)2, (int)afterList.length);
        beforeList[0].load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)beforeList[0].isReversal());
        MMatchInv[] mMatchInvArray = afterList;
        int n = afterList.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.equals((Object)beforeList[0])) {
                Assertions.assertTrue((boolean)mi.isReversal());
                break;
            }
            ++n2;
        }
    }

    @Test
    public void testReversalPosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(BigDecimal.ONE);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
        BigDecimal invMatchAmt = invoiceLine.getMatchedQty().multiply(invoiceLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"RC");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)invoice.getDocStatus());
        MMatchInv[] miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)2, (int)miList.length);
        MMatchInv[] mMatchInvArray = miList;
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ids;
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount acctInvClr = pc.getAccount(10, as);
            String whereClause = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            int n3 = ids.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    if (mi.isReversal()) {
                        Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)"MatchInv incorrect amount posted ");
                    } else {
                        Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)"MatchInv incorrect amount posted ");
                    }
                    Assertions.assertEquals((Object)mi.getQty(), (Object)fa.getQty(), (String)"Accounting fact quantity incorrect");
                } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                    if (mi.isReversal()) {
                        Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)"MatchInv incorrect amount posted ");
                    } else {
                        Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)"MatchInv incorrect amount posted ");
                    }
                    Assertions.assertEquals((Object)mi.getQty().negate(), (Object)fa.getQty(), (String)"Accounting fact quantity incorrect");
                }
                ++n4;
            }
            ++n2;
        }
    }
}

