/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.impl.XulElement;

public class WRadioGroupEditor
extends WEditor
implements ContextMenuListener,
ListDataListener,
IZoomableEditor {
    public static final String[] LISTENER_EVENTS = new String[]{"onCheck"};
    private static final CLogger logger = CLogger.getCLogger(WRadioGroupEditor.class);
    private Lookup lookup;
    private Object oldValue;
    private boolean onselecting = false;

    public WRadioGroupEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WRadioGroupEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new RadioGroupEditor(), gridField, tableEditor, editorConfiguration);
        this.lookup = gridField.getLookup();
        this.init();
    }

    public WRadioGroupEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new RadioGroupEditor(), label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        super.setColumnName(lookup.getColumnName());
        this.init();
    }

    public WRadioGroupEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super((Component)new RadioGroupEditor(), columnName, null, null, mandatory, isReadOnly, isUpdateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.init();
    }

    private void init() {
        boolean zoom = false;
        if (this.lookup != null) {
            this.lookup.addListDataListener((ListDataListener)this);
            this.lookup.setMandatory(true);
            this.lookup.setMandatory(this.isMandatory());
            if (this.lookup.getDisplayType() == 17 && Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Role_ID") == 0 || this.lookup.getDisplayType() != 17) {
                zoom = true;
            }
            if (this.isReadWrite()) {
                this.lookup.refresh();
            } else {
                this.refreshList();
            }
        }
        this.popupMenu = new WEditorPopupMenu(zoom, true, this.isShowPreference(), false, false, false, this.lookup);
        this.addChangeLogMenu(this.popupMenu);
    }

    @Override
    public String getDisplay() {
        String display = "";
        Radio selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            display = selItem.getLabel();
        }
        return display;
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        Radio selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            retVal = selItem.getValue();
            if (retVal instanceof Integer && (Integer)retVal == -1) {
                retVal = null;
            } else if (retVal instanceof String && "".equals(retVal)) {
                retVal = null;
            }
        }
        return retVal;
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && (value instanceof Integer || value instanceof String || value instanceof Timestamp || value instanceof BigDecimal)) {
            this.getComponent().setValue(value);
            if (!this.getComponent().isSelected(value)) {
                Object curValue = this.oldValue;
                this.oldValue = value;
                if (this.isReadWrite() && this.lookup != null) {
                    this.lookup.refresh();
                } else {
                    this.refreshList();
                }
                if (!(this.getComponent().isSelected(value) || !(value instanceof Integer) || this.gridField == null || this.gridField.getDisplayType() == 13 || this.gridTab != null && this.gridTab.getTableModel().isImporting())) {
                    String refTable;
                    MColumn col;
                    MRole role = MRole.getDefault((Properties)Env.getCtx(), (boolean)false);
                    int refTableID = -1;
                    if (this.gridTab != null && (col = MColumn.get((Properties)Env.getCtx(), (int)this.gridField.getAD_Column_ID())).get_ID() > 0 && (refTable = col.getReferenceTableName()) != null) {
                        MTable table2 = MTable.get((Properties)Env.getCtx(), (String)refTable);
                        refTableID = table2.getAD_Table_ID();
                    }
                    if (refTableID > 0 && !role.isRecordAccess(refTableID, ((Integer)value).intValue(), false)) {
                        this.oldValue = value;
                        this.setReadWrite(false);
                        this.gridField.setLockedRecord(true);
                    } else {
                        this.getComponent().setValue(null);
                        if (curValue == null) {
                            curValue = value;
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                        super.fireValueChange(changeEvent);
                        this.oldValue = null;
                        if (this.gridField != null) {
                            this.gridField.setLockedRecord(false);
                        }
                    }
                }
            } else {
                this.oldValue = value;
                if (this.gridField != null) {
                    this.gridField.setLockedRecord(false);
                }
            }
        } else {
            this.getComponent().setValue(null);
            this.oldValue = null;
        }
    }

    public RadioGroupEditor getComponent() {
        return (RadioGroupEditor)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    private void refreshList() {
        if (this.getComponent().getItemCount() > 0) {
            this.getComponent().removeAllItems();
        }
        if (this.isReadWrite()) {
            if (this.lookup != null) {
                NamePair pair;
                this.lookup.refresh();
                int size = this.lookup.getSize();
                boolean found = false;
                int i = 0;
                while (i < size) {
                    Object obj = this.lookup.getElementAt(i);
                    if (obj instanceof KeyNamePair) {
                        lookupKNPair = (KeyNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName(), lookupKNPair.getKey());
                        if (!found && this.oldValue != null && this.oldValue instanceof Integer && lookupKNPair.getKey() == ((Integer)this.oldValue).intValue()) {
                            found = true;
                        }
                    } else if (obj instanceof ValueNamePair) {
                        lookupKNPair = (ValueNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName(), lookupKNPair.getValue());
                        if (!found && this.oldValue != null && lookupKNPair.getValue().equals(this.oldValue.toString())) {
                            found = true;
                        }
                    }
                    ++i;
                }
                if (!found && this.oldValue != null && (pair = this.lookup.getDirect(this.oldValue, false, true)) != null) {
                    if (pair instanceof KeyNamePair) {
                        int key = ((KeyNamePair)pair).getKey();
                        this.getComponent().appendItem(pair.getName(), key);
                    } else if (pair instanceof ValueNamePair) {
                        ValueNamePair valueNamePair = (ValueNamePair)pair;
                        this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                    }
                }
            }
        } else if (this.lookup != null) {
            NamePair pair;
            GridTable gt;
            String trxName = null;
            if (this.gridField != null && this.gridField.getGridTab() != null && this.gridField.getGridTab().getTableModel() != null && (gt = this.gridField.getGridTab().getTableModel()).isImporting()) {
                trxName = gt.get_TrxName();
            }
            if ((pair = this.lookup.getDirect(this.oldValue, false, false, trxName)) != null) {
                if (pair instanceof KeyNamePair) {
                    int key = ((KeyNamePair)pair).getKey();
                    this.getComponent().appendItem(pair.getName(), key);
                } else if (pair instanceof ValueNamePair) {
                    ValueNamePair valueNamePair = (ValueNamePair)pair;
                    this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                }
            }
        }
        this.getComponent().setValue(this.oldValue);
    }

    public void onEvent(Event event) {
        block9: {
            if ("onCheck".equalsIgnoreCase(event.getName())) {
                try {
                    this.onselecting = true;
                    Object newValue = this.getValue();
                    if (!this.isValueChange(newValue)) break block9;
                    try {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(true);
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                        super.fireValueChange(changeEvent);
                        this.oldValue = newValue;
                        this.getComponent().setValue(newValue);
                    }
                    finally {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(false);
                        }
                    }
                }
                finally {
                    this.onselecting = false;
                }
            }
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void actionRefresh() {
        if (this.lookup != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                if (this.lookup instanceof MLookup) {
                    ((MLookup)this.lookup).refreshItemsAndCache();
                } else {
                    this.lookup.refresh();
                }
            } else {
                this.refreshList();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            } else if ("ZOOM".equals(evt.getContextEvent())) {
                this.actionZoom();
            }
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.oldValue != null && this.getComponent().getItemCount() > 0 && this.getComponent().getSelectedItem() == null) {
            this.getComponent().setValue(this.oldValue);
        }
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        if (this.lookup != null && (!this.lookup.isValidated() || !this.lookup.isLoaded() || this.isReadWrite() && this.lookup.getSize() != this.getComponent().getItemCount())) {
            this.actionRefresh();
        }
        super.dynamicDisplay(ctx);
        if (!ClientInfo.isMobile() && this.getPopupMenu().getParent() != null && this.getComponent().radioGroup.getContext() == null) {
            this.getPopupMenu().addContextElement((XulElement)this.getComponent().radioGroup);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshList();
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom(this.lookup, this.getValue());
    }

    public static class RadioGroupEditor
    extends Hlayout {
        private static final long serialVersionUID = 8713136500234252220L;
        private Radiogroup radioGroup;
        private boolean enabled;

        private RadioGroupEditor() {
            this.newRadioGroup();
            this.appendChild((Component)this.radioGroup);
            this.enabled = true;
            this.setSpacing("0");
            this.setStyle("white-space: normal");
        }

        public Radiogroup getRadiogroup() {
            return this.radioGroup;
        }

        private void newRadioGroup() {
            this.radioGroup = new Radiogroup();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean readWrite) {
            this.enabled = readWrite;
            List items = this.radioGroup.getItems();
            for (Radio radio : items) {
                radio.setDisabled(!readWrite);
            }
        }

        public boolean isSelected(Object value) {
            Radio radio = this.getSelectedItem();
            if (radio != null && radio.getValue() != null && value != null) {
                return radio.getValue().equals(value);
            }
            return false;
        }

        public Radio getSelectedItem() {
            return this.radioGroup.getSelectedItem();
        }

        public void setSelectedItem(Radio item) {
            if (item != null && item.isSelected()) {
                item.setSelected(false);
            }
            this.radioGroup.setSelectedItem(item);
        }

        public void removeAllItems() {
            List items = this.radioGroup.getItems();
            for (Radio radio : items) {
                radio.detach();
            }
        }

        public void setValue(Object newValue) {
            boolean found = false;
            if (newValue != null) {
                List items = this.radioGroup.getItems();
                for (Radio radio : items) {
                    if (radio.getValue() == null || !radio.getValue().equals(newValue)) continue;
                    this.setSelectedItem(radio);
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.setSelectedItem(null);
            }
        }

        public int getItemCount() {
            return this.radioGroup.getItemCount();
        }

        public void appendItem(String name, String value) {
            if (Util.isEmpty((String)name)) {
                return;
            }
            Radio radio = this.newRadio(name, value);
            this.radioGroup.appendChild((Component)radio);
        }

        protected Radio newRadio(String name, Object value) {
            Radio radio = new Radio(name);
            radio.setValue(value);
            radio.setDisabled(!this.enabled);
            radio.setStyle("padding-right:1em");
            return radio;
        }

        public void appendItem(String name, int key) {
            if (Util.isEmpty((String)name)) {
                return;
            }
            Radio radio = this.newRadio(name, key);
            this.radioGroup.appendChild((Component)radio);
        }

        public boolean addEventListener(String evtnm, EventListener<? extends Event> listener) {
            if ("onCheck".equals(evtnm)) {
                return this.radioGroup.addEventListener(evtnm, listener);
            }
            return super.addEventListener(evtnm, listener);
        }

        public boolean addEventListener(int priority, String evtnm, EventListener<? extends Event> listener) {
            if ("onCheck".equals(evtnm)) {
                return this.radioGroup.addEventListener(priority, evtnm, listener);
            }
            return super.addEventListener(priority, evtnm, listener);
        }

        public boolean removeEventListener(String evtnm, EventListener<? extends Event> listener) {
            if ("onCheck".equals(evtnm)) {
                return this.radioGroup.removeEventListener(evtnm, listener);
            }
            return super.removeEventListener(evtnm, listener);
        }
    }
}

