/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.image.AImage;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.sound.AAudio;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.media.Media;
import org.zkoss.video.AVideo;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.au.http.ServletRequestContext;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Uploadable;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Configuration;

public class AuDropUploader
implements AuExtension {
    private static final Logger log = LoggerFactory.getLogger(AuDropUploader.class);

    @Override
    public void init(DHtmlUpdateServlet servlet) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException, IOException {
        Session sess = Sessions.getCurrent(false);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        String alert = null;
        String uuid = null;
        String dtid = null;
        Desktop desktop = null;
        try {
            uuid = this.fetchParameter(request, "uuid", attrs);
            if (Strings.isEmpty((String)uuid)) {
                alert = this.generateAlertMessage(Uploadable.Error.MISSING_REQUIRED_COMPONENT, "uuid is required!");
            }
            if (Strings.isEmpty((String)(dtid = this.fetchParameter(request, "dtid", attrs)))) {
                alert = this.generateAlertMessage(Uploadable.Error.MISSING_REQUIRED_COMPONENT, "dtid is required!");
            }
            this.fetchParameter(request, "sid", attrs);
            if (alert == null) {
                desktop = ((WebAppCtrl)((Object)sess.getWebApp())).getDesktopCache(sess).getDesktop(dtid);
                Map<String, Object> params = AuDropUploader.parseRequest(request, desktop, "");
                AuDropUploader.processItems(desktop, params, attrs);
            }
        }
        catch (Throwable ex) {
            if (uuid == null && (uuid = request.getParameter("uuid")) != null) {
                attrs.put("uuid", uuid);
            }
            alert = ex instanceof ComponentNotFoundException ? this.generateAlertMessage(Uploadable.Error.MISSING_REQUIRED_COMPONENT, Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)uuid)) : this.handleError(ex);
        }
        if (alert != null) {
            if (desktop == null) {
                response.setIntHeader("ZK-Error", 410);
                return;
            }
            response.getWriter().write("error:" + alert);
        } else {
            response.setContentType("text/plain;charset=UTF-8");
        }
        if (log.isTraceEnabled()) {
            log.trace(Objects.toString(attrs));
        }
    }

    private String fetchParameter(HttpServletRequest request, String key, Map<String, String> attrs) {
        String value = request.getParameter(key);
        if (!Strings.isEmpty((String)value)) {
            attrs.put(key, value);
        }
        return value;
    }

    protected String handleError(Throwable ex) {
        log.error("Failed to upload", ex);
        if (ex instanceof FileUploadBase.SizeLimitExceededException) {
            try {
                FileUploadBase.SizeLimitExceededException fex = (FileUploadBase.SizeLimitExceededException)ex;
                long size = fex.getActualSize();
                long limit = fex.getPermittedSize();
                Class msgClass = Classes.forNameByThread((String)"org.zkoss.zul.mesg.MZul");
                Field msgField = msgClass.getField("UPLOAD_ERROR_EXCEED_MAXSIZE");
                int divisor1 = 1024;
                int divisor2 = 0x100000;
                String[] units = new String[]{" Bytes", " KB", " MB"};
                int i1 = (int)(Math.log(size) / Math.log(1024.0));
                int i2 = (int)(Math.log(limit) / Math.log(1024.0));
                String sizeAuto = Math.round((double)size / Math.pow(1024.0, i1)) + units[i1];
                String limitAuto = Math.round((double)limit / Math.pow(1024.0, i2)) + units[i2];
                Object[] args = new Object[]{sizeAuto, limitAuto, size, limit, Long.valueOf(size / (long)divisor1) + units[1], Long.valueOf(limit / (long)divisor1) + units[1], Long.valueOf(size / (long)divisor2) + units[2], Long.valueOf(limit / (long)divisor2) + units[2]};
                return this.generateAlertMessage(Uploadable.Error.SIZE_LIMIT_EXCEEDED, Messages.get((int)msgField.getInt(null), (Object[])args));
            }
            catch (Throwable e) {
                log.error("Failed to parse upload error message..", e);
            }
        }
        return this.generateAlertMessage(Uploadable.Error.SERVER_EXCEPTION, Exceptions.getMessage((Throwable)ex));
    }

    private String generateAlertMessage(Uploadable.Error type, String message) {
        return type.toString() + ":" + message;
    }

    private static final void processItems(Desktop desktop, Map<String, Object> params, Map<String, String> attrs) throws IOException {
        String uuid = attrs.get("uuid");
        String uploadInfoKey = uuid + "." + attrs.getOrDefault("sid", "");
        LinkedList<Media> meds = (LinkedList<Media>)desktop.getAttribute(uploadInfoKey);
        if (meds == null) {
            meds = new LinkedList<Media>();
            desktop.setAttribute(uploadInfoKey, meds);
        }
        boolean alwaysNative = Boolean.TRUE.equals(params.get("native"));
        Object fis = params.get("file");
        if (fis instanceof FileItem) {
            meds.add(AuDropUploader.processItem(desktop, (FileItem)fis, alwaysNative, (org.zkoss.zk.ui.sys.DiskFileItemFactory)params.get("diskFileItemFactory")));
        } else if (fis != null) {
            Iterator it = ((List)fis).iterator();
            while (it.hasNext()) {
                meds.add(AuDropUploader.processItem(desktop, (FileItem)it.next(), alwaysNative, (org.zkoss.zk.ui.sys.DiskFileItemFactory)params.get("diskFileItemFactory")));
            }
        }
    }

    private static final Media processItem(Desktop desktop, FileItem fi, boolean alwaysNative, org.zkoss.zk.ui.sys.DiskFileItemFactory factory) throws IOException {
        String s;
        int j;
        String ctype;
        String ctypelc;
        int k;
        int j2;
        String name = AuDropUploader.getBaseName(fi);
        if (name != null && (j2 = name.lastIndexOf(59)) > 0 && (k = name.lastIndexOf(46)) >= 0 && j2 > k && k > name.lastIndexOf(47)) {
            name = name.substring(0, j2);
        }
        String string = ctypelc = (ctype = fi.getContentType()) != null ? ctype.toLowerCase(Locale.ENGLISH) : null;
        if (name != null && "application/octet-stream".equals(ctypelc) && (j = name.lastIndexOf(46)) >= 0 && (s = ContentTypes.getContentType((String)name.substring(j + 1))) != null) {
            ctypelc = ctype = s;
        }
        if (factory != null) {
            return factory.createMedia(fi, ctype, name, alwaysNative);
        }
        if (!alwaysNative && ctypelc != null) {
            if (ctypelc.startsWith("image/")) {
                try {
                    return fi.isInMemory() ? new AImage(name, fi.get()) : new AImage(name, fi.getInputStream());
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("audio/")) {
                try {
                    return fi.isInMemory() ? new AAudio(name, fi.get()) : new StreamAudio(name, fi, ctypelc);
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("video/")) {
                try {
                    return fi.isInMemory() ? new AVideo(name, fi.get()) : new StreamVideo(name, fi, ctypelc);
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("text/")) {
                String charset = AuDropUploader.getCharset(ctype);
                if (charset == null) {
                    Configuration conf = desktop.getWebApp().getConfiguration();
                    CharsetFinder chfd = conf.getUploadCharsetFinder();
                    if (chfd != null) {
                        charset = chfd.getCharset(ctype, fi.isInMemory() ? new ByteArrayInputStream(fi.get()) : fi.getInputStream());
                    }
                    if (charset == null) {
                        charset = conf.getUploadCharset();
                    }
                }
                return fi.isInMemory() ? new AMedia(name, null, ctype, fi.getString(charset)) : new ReaderMedia(name, null, ctype, fi, charset);
            }
        }
        return fi.isInMemory() ? new AMedia(name, null, ctype, fi.get()) : new StreamMedia(name, null, ctype, fi);
    }

    private static String getCharset(String ctype) {
        String ctypelc = ctype.toLowerCase(Locale.ENGLISH);
        int j = 0;
        while ((j = ctypelc.indexOf("charset", j)) >= 0) {
            int k = Strings.skipWhitespacesBackward((CharSequence)ctype, (int)(j - 1));
            if ((k < 0 || ctype.charAt(k) == ';') && (k = Strings.skipWhitespaces((CharSequence)ctype, (int)(j + 7))) <= ctype.length() && ctype.charAt(k) == '=') {
                String charset;
                if ((charset = ((j = ctype.indexOf(59, ++k)) >= 0 ? ctype.substring(k, j) : ctype.substring(k)).trim()).length() <= 0) break;
                return charset;
            }
            j += 7;
        }
        return null;
    }

    private static Map<String, Object> parseRequest(HttpServletRequest request, Desktop desktop, String key) throws FileUploadException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Configuration conf = desktop.getWebApp().getConfiguration();
        int thrs = conf.getFileSizeThreshold();
        int sizeThreadHold = 131072;
        if (thrs > 0) {
            sizeThreadHold = 1024 * thrs;
        }
        File repository = null;
        if (conf.getFileRepository() != null && !(repository = new File(conf.getFileRepository())).isDirectory()) {
            log.warn("The file repository is not a directory! [" + repository + "]");
        }
        org.zkoss.zk.ui.sys.DiskFileItemFactory dfiFactory = null;
        if (conf.getFileItemFactoryClass() != null) {
            Class<?> cls = conf.getFileItemFactoryClass();
            try {
                dfiFactory = (org.zkoss.zk.ui.sys.DiskFileItemFactory)cls.newInstance();
                params.put("diskFileItemFactory", dfiFactory);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        ItemFactory fty = new ItemFactory(sizeThreadHold, repository, dfiFactory);
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)fty);
        Component comp = desktop.getComponentByUuid(request.getParameter("uuid"));
        Integer maxsz = null;
        try {
            Integer compMaxsz = (Integer)comp.getAttribute("org.zkoss.zk.upload.maxsize");
            maxsz = compMaxsz != null ? compMaxsz.intValue() : conf.getMaxUploadSize();
        }
        catch (NumberFormatException e) {
            throw new UiException("The upload max size must be a number");
        }
        if (Boolean.TRUE.equals(comp.getAttribute("org.zkoss.zk.upload.native"))) {
            params.put("native", true);
        }
        sfu.setSizeMax(maxsz != null ? (maxsz >= 0 ? 1024L * (long)maxsz.intValue() : -1L) : -1L);
        for (FileItem fi : sfu.parseRequest((RequestContext)new ServletRequestContext(request))) {
            LinkedList<Object> vals;
            Object val;
            String nm = fi.getFieldName();
            Object old = params.put(nm, val = fi.isFormField() ? fi.getString() : fi);
            if (old == null) continue;
            if (old instanceof List) {
                vals = Generics.cast((List)((List)old));
                params.put(nm, vals);
            } else {
                vals = new LinkedList<Object>();
                params.put(nm, vals);
                vals.add(old);
            }
            vals.add(val);
        }
        return params;
    }

    private static String getBaseName(FileItem fi) {
        String name = fi.getName();
        if (name == null) {
            return null;
        }
        String[] seps = new String[]{"/", "\\", "%5c", "%5C", "%2f", "%2F"};
        int j = seps.length;
        while (--j >= 0) {
            int k = name.lastIndexOf(seps[j]);
            if (k < 0) continue;
            name = name.substring(k + seps[j].length());
        }
        return name;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        return "post".equals(request.getMethod().toLowerCase(Locale.ENGLISH)) && FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(request));
    }

    private static class ItemFactory
    extends DiskFileItemFactory
    implements Serializable {
        private org.zkoss.zk.ui.sys.DiskFileItemFactory _factory;

        ItemFactory(int sizeThreshold, File repository, org.zkoss.zk.ui.sys.DiskFileItemFactory factory) {
            super(sizeThreshold, repository);
            this._factory = factory;
        }

        public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
            if (this._factory != null) {
                return this._factory.createItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
            }
            return new ZkFileItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
        }

        class ZkFileItem
        extends DiskFileItem {
            ZkFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
                super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
            }

            public String getCharSet() {
                String charset = super.getCharSet();
                return charset != null ? charset : "UTF-8";
            }
        }
    }

    private static class StreamVideo
    extends AVideo {
        private final FileItem _fi;
        private String _format;
        private String _ctype;

        public StreamVideo(String name, FileItem fi, String ctype) throws IOException {
            super(name, DYNAMIC_STREAM);
            this._fi = fi;
            this._ctype = ctype;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public String getFormat() {
            if (this._format == null) {
                this._format = ContentTypes.getFormat((String)this.getContentType());
            }
            return this._format;
        }

        public String getContentType() {
            return this._ctype != null ? this._ctype : this._fi.getContentType();
        }
    }

    private static class StreamAudio
    extends AAudio {
        private final FileItem _fi;
        private String _format;
        private String _ctype;

        public StreamAudio(String name, FileItem fi, String ctype) throws IOException {
            super(name, DYNAMIC_STREAM);
            this._fi = fi;
            this._ctype = ctype;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public String getFormat() {
            if (this._format == null) {
                this._format = ContentTypes.getFormat((String)this.getContentType());
            }
            return this._format;
        }

        public String getContentType() {
            return this._ctype != null ? this._ctype : this._fi.getContentType();
        }
    }

    private static class ReaderMedia
    extends AMedia {
        private final FileItem _fi;
        private final String _charset;

        public ReaderMedia(String name, String format, String ctype, FileItem fi, String charset) {
            super(name, format, ctype, DYNAMIC_READER);
            this._fi = fi;
            this._charset = charset;
        }

        public Reader getReaderData() {
            try {
                return new InputStreamReader(this._fi.getInputStream(), this._charset);
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public boolean isBinary() {
            return false;
        }

        public boolean inMemory() {
            return false;
        }
    }

    private static class StreamMedia
    extends AMedia {
        private final FileItem _fi;

        public StreamMedia(String name, String format, String ctype, FileItem fi) {
            super(name, format, ctype, DYNAMIC_STREAM);
            this._fi = fi;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public boolean isBinary() {
            return true;
        }

        public boolean inMemory() {
            return false;
        }
    }
}

