/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

public class FastReadCache<K, V>
implements Cache<K, V>,
Serializable,
Cloneable {
    private InnerCache _cache;
    private Map<K, V> _writeCache;
    private transient short _missCnt;
    private transient short _maxMissCnt = (short)100;
    private boolean _moreInWriteCache;

    public FastReadCache() {
        this(512, 1800000);
    }

    public FastReadCache(int maxSize, int lifetime) {
        this._cache = new InnerCache(maxSize, lifetime);
    }

    public FastReadCache(int maxSize, int lifetime, short maxMissCount) {
        this._cache = new InnerCache(maxSize, lifetime);
        this._maxMissCnt = maxMissCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean found = this._cache.containsKey(key);
        if (!found && this._moreInWriteCache) {
            FastReadCache fastReadCache = this;
            synchronized (fastReadCache) {
                if (this._writeCache != null && (found = this._writeCache.containsKey(key))) {
                    this.missed();
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object val = this._cache.get(key);
        if (val == null && this._moreInWriteCache) {
            FastReadCache fastReadCache = this;
            synchronized (fastReadCache) {
                if (this._writeCache != null && (val = this._writeCache.get(key)) != null) {
                    this.missed();
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V result = value;
        FastReadCache fastReadCache = this;
        synchronized (fastReadCache) {
            if (!Objects.equals(value, this._cache.getWithoutExpunge(key))) {
                result = this.syncToWriteCache().put(key, value);
                this._moreInWriteCache = true;
                if (this._cache.containsKeyWithoutExpunge(key)) {
                    this.syncToReadCache();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        V result = null;
        FastReadCache fastReadCache = this;
        synchronized (fastReadCache) {
            if (!this._cache.containsKeyWithoutExpunge(key) && !this._moreInWriteCache) {
                return null;
            }
            result = this.syncToWriteCache().remove(key);
            if (this._cache.containsKeyWithoutExpunge(key)) {
                this.syncToReadCache();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        FastReadCache fastReadCache = this;
        synchronized (fastReadCache) {
            this.setReadAndClearWrite(new InnerCache(this.getMaxSize(), this.getLifetime()));
        }
    }

    private void missed() {
        this._missCnt = (short)(this._missCnt + 1);
        if (this._missCnt == this._maxMissCnt) {
            this.syncToReadCache();
        }
    }

    private void syncToReadCache() {
        this._missCnt = 0;
        this._moreInWriteCache = false;
        InnerCache cache = new InnerCache(this.getMaxSize(), this.getLifetime());
        cache.putAll(this._writeCache);
        this._cache = cache;
    }

    private Map<K, V> syncToWriteCache() {
        if (this._writeCache == null) {
            this._writeCache = new LinkedHashMap();
            this._writeCache.putAll(this._cache);
        }
        return this._writeCache;
    }

    private void setReadAndClearWrite(InnerCache cache) {
        this._writeCache = null;
        this._missCnt = 0;
        this._moreInWriteCache = false;
        this._cache = cache;
    }

    @Override
    public int getLifetime() {
        return this._cache.getLifetime();
    }

    @Override
    public void setLifetime(int lifetime) {
        this._cache.setLifetime(lifetime);
    }

    @Override
    public int getMaxSize() {
        return this._cache.getMaxSize();
    }

    @Override
    public void setMaxSize(int maxsize) {
        this._cache.setMaxSize(maxsize);
    }

    private class InnerCache
    extends CacheMap<K, V> {
        private List<K> _removed;

        private InnerCache() {
            super(false);
        }

        private InnerCache(int maxSize, int lifetime) {
            super(maxSize, lifetime, false);
        }

        @Override
        void removeInExpunge(Iterator<Map.Entry<K, CacheMap.Value<V>>> it, K key) {
            this._removed.add(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doExpunge() {
            FastReadCache fastReadCache = FastReadCache.this;
            synchronized (fastReadCache) {
                this._removed = new ArrayList();
                try {
                    super.doExpunge();
                    if (!this._removed.isEmpty()) {
                        InnerCache cache = (InnerCache)this.clone();
                        for (Object key : this._removed) {
                            cache.remove(key);
                        }
                        FastReadCache.this.setReadAndClearWrite(cache);
                    }
                }
                finally {
                    this._removed = null;
                }
            }
        }

        @Override
        public Object clone() {
            InnerCache clone = (InnerCache)super.clone();
            clone._removed = null;
            return clone;
        }
    }
}

