/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;

public class XlsxContentTypesHelper
extends BaseHelper {
    private boolean containsMacro;

    public XlsxContentTypesHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public void setContainsMacro(boolean containsMacro) {
        this.containsMacro = containsMacro;
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n");
        if (this.containsMacro) {
            this.write("  <Default Extension=\"bin\" ContentType=\"application/vnd.ms-office.vbaProject\"/>\n");
        }
        this.write("  <Default Extension=\"gif\" ContentType=\"image/gif\"/>\n");
        this.write("  <Default Extension=\"jpeg\" ContentType=\"image/jpeg\"/>\n");
        this.write("  <Default Extension=\"jpg\" ContentType=\"image/jpeg\"/>\n");
        this.write("  <Default Extension=\"png\" ContentType=\"image/png\"/>\n");
        this.write("  <Default Extension=\"tiff\" ContentType=\"image/tiff\"/>\n");
        this.write("  <Default Extension=\"webp\" ContentType=\"image/webp\"/>\n");
        this.write("  <Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/>\n");
        this.write("  <Default Extension=\"xml\" ContentType=\"application/xml\"/>\n");
        this.write("  <Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/>\n");
        this.write("  <Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/>\n");
        this.write("  <Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/>\n");
        if (this.containsMacro) {
            this.write("  <Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.ms-excel.sheet.macroEnabled.main+xml\"/>\n");
            this.write("  <Override PartName=\"/xl/vbaProject.bin\" ContentType=\"application/vnd.ms-office.vbaProject\"/>\n");
        } else {
            this.write("  <Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>\n");
        }
    }

    public void exportSheet(int index) {
        this.write("  <Override PartName=\"/xl/worksheets/sheet" + index + ".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>\n");
        this.write("  <Override PartName=\"/xl/drawings/drawing" + index + ".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.drawing+xml\"/>\n");
    }

    public void exportFooter() {
        this.write("</Types>\n");
    }
}

