/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.jruby;

import org.jruby.Ruby;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;

public class JRubyInterpreter
extends GenericInterpreter {
    private Ruby _runtime;

    @Override
    public Object getNativeInterpreter() {
        return this._runtime;
    }

    @Override
    protected void exec(String script) {
        this._runtime.evalScriptlet(script);
    }

    @Override
    protected boolean contains(String name) {
        return this._runtime.getGlobalVariables().isDefined(GlobalVariable.variableName((String)name));
    }

    @Override
    protected Object get(String name) {
        IRubyObject ro = this._runtime.getGlobalVariables().get(GlobalVariable.variableName((String)name));
        return this.rubyToJava(ro);
    }

    @Override
    protected void set(String name, Object value) {
        this._runtime.getGlobalVariables().define(GlobalVariable.variableName((String)name), (IAccessor)new Variable(value), GlobalVariable.Scope.GLOBAL);
    }

    @Override
    protected void unset(String name) {
        this._runtime.getGlobalVariables().set(GlobalVariable.variableName((String)name), this._runtime.getNil());
    }

    @Override
    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        this._runtime = Ruby.newInstance();
        this._runtime.setGlobalVariables((GlobalVariables)new Variables(this._runtime));
    }

    @Override
    public void destroy() {
        JavaEmbedUtils.terminate((Ruby)this._runtime);
        this._runtime = null;
        super.destroy();
    }

    private IRubyObject javaToRuby(Object value) {
        IRubyObject ro = JavaUtil.convertJavaToRuby((Ruby)this._runtime, (Object)value);
        if (ro instanceof JavaObject) {
            return this._runtime.getModule("JavaUtilities").callMethod(this._runtime.getCurrentContext(), "wrap", ro);
        }
        return ro;
    }

    private Object rubyToJava(IRubyObject value) {
        return JavaUtil.convertRubyToJava((IRubyObject)value, Object.class);
    }

    private class Variable
    implements IAccessor {
        private Object _value;

        public Variable(Object value) {
            this._value = value;
        }

        public IRubyObject getValue() {
            return JRubyInterpreter.this.javaToRuby(this._value);
        }

        public IRubyObject setValue(IRubyObject value) {
            this._value = JRubyInterpreter.this.rubyToJava(value);
            return value;
        }
    }

    private class Variables
    extends GlobalVariables {
        private Variables(Ruby runtime) {
            super(runtime);
            GlobalVariables vars = runtime.getGlobalVariables();
            for (String nm : vars.getNames()) {
                this.set(nm, vars.get(nm));
            }
        }

        public IRubyObject get(String name) {
            IRubyObject ro = super.get(name);
            if (ro == JRubyInterpreter.this._runtime.getNil()) {
                Object val;
                if (name.length() > 1 && name.charAt(0) == '$') {
                    name = name.substring(1);
                }
                if ((val = JRubyInterpreter.this.getFromNamespace(name)) != GenericInterpreter.UNDEFINED) {
                    return JRubyInterpreter.this.javaToRuby(val);
                }
            }
            return ro;
        }
    }
}

