/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereSession {
    protected final Logger logger = LoggerFactory.getLogger(AtmosphereSession.class);
    protected final AtomicReference<AtmosphereResource> resource = new AtomicReference();
    protected String uuid;
    protected final Semaphore latch = new Semaphore(1);
    protected BroadcasterListenerAdapter broadcasterListener;
    protected Broadcaster[] relatedBroadcasters;
    protected final boolean usesLongPolling;

    public AtmosphereSession(AtmosphereResource r, Broadcaster ... broadcasters) {
        this.uuid = r.uuid();
        this.relatedBroadcasters = broadcasters;
        this.usesLongPolling = AtmosphereResource.TRANSPORT.LONG_POLLING == r.transport();
        this.resource.set(r);
        this.broadcasterListener = new BroadcasterListenerAdapter(){

            @Override
            public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
                boolean found = false;
                if (r.uuid().equalsIgnoreCase(AtmosphereSession.this.uuid)) {
                    AtmosphereSession.this.logger.trace("AtmosphereSession tracking :  AtmosphereResource {} added", (Object)AtmosphereSession.this.uuid);
                    AtmosphereSession.this.resource.set(r);
                    found = true;
                }
                if (found && AtmosphereSession.this.latch.availablePermits() == 0) {
                    AtmosphereSession.this.latch.release();
                }
            }

            @Override
            public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
                if (r.uuid().equalsIgnoreCase(AtmosphereSession.this.uuid)) {
                    AtmosphereSession.this.logger.trace("AtmosphereSession tracking :  AtmosphereResource {} removed", (Object)AtmosphereSession.this.uuid);
                    AtmosphereSession.this.resource.set(null);
                    AtmosphereSession.this.latch.tryAcquire();
                }
            }
        };
        for (Broadcaster b : broadcasters) {
            b.addBroadcasterListener(this.broadcasterListener);
        }
    }

    public AtmosphereSession(AtmosphereResource resource) {
        this(resource, resource.getAtmosphereConfig().getBroadcasterFactory().lookupAll().toArray(new Broadcaster[0]));
    }

    public AtmosphereResource acquire() {
        return this.resource.get();
    }

    public AtmosphereResource tryAcquire() throws InterruptedException {
        return this.tryAcquire(60);
    }

    public AtmosphereResource tryAcquire(int timeInSecond) throws InterruptedException {
        if (this.usesLongPolling || this.resource.get() == null) {
            this.latch.tryAcquire(timeInSecond, TimeUnit.SECONDS);
        }
        return this.resource.get();
    }

    public void close() {
        for (Broadcaster br : this.relatedBroadcasters) {
            br.removeBroadcasterListener(this.broadcasterListener);
        }
    }

    public String uuid() {
        return this.uuid;
    }
}

