/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.ConditionLeafInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.Utils;

public class AttributesInfo
extends ConditionLeafInfo {
    private final Map<String, Object> _attrs;
    private final int _composite;
    private final int _scope;

    public AttributesInfo(NodeInfo parent, Map<String, String> attrs, String scope, String composite, ConditionImpl cond) {
        super(parent, cond);
        if (composite == null || composite.length() == 0 || composite.equals("none")) {
            this._composite = 0;
        } else if (composite.equals("list")) {
            this._composite = 1;
        } else if (composite.equals("map")) {
            this._composite = 2;
        } else {
            throw new IllegalArgumentException("Unkonwn composite: " + composite);
        }
        if (attrs != null && !attrs.isEmpty()) {
            this._attrs = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> me : attrs.entrySet()) {
                this._attrs.put(me.getKey(), Utils.parseComposite(me.getValue(), Object.class, this._composite));
            }
        } else {
            this._attrs = null;
        }
        this._scope = scope == null ? -1 : Components.getScope(scope);
    }

    public AttributesInfo(NodeInfo parent, Map<String, String> attrs, String scope, ConditionImpl cond) {
        this(parent, attrs, scope, null, cond);
    }

    public String getScope() {
        return this._scope != -1 ? Components.scopeToString(this._scope) : null;
    }

    public String getComposite() {
        return this._composite == 1 ? "list" : (this._composite == 2 ? "map" : "none");
    }

    public void apply(Component comp) {
        if (this._attrs != null && this.isEffective(comp)) {
            Evaluator eval = this.getEvaluator();
            for (Map.Entry<String, Object> me : this._attrs.entrySet()) {
                Object controller;
                Object ctrlnm;
                String name = me.getKey();
                Object value = me.getValue();
                comp.setAttribute(name, Utils.evaluateComposite(eval, comp, value), this._scope != -1 ? this._scope : 0);
                if (!"composerName".equals(name) || !((ctrlnm = comp.getAttribute(name)) instanceof String) || (controller = comp.removeAttribute("_$composer$_")) == null || comp.getAttribute((String)ctrlnm) != null) continue;
                comp.setAttribute((String)ctrlnm, controller);
            }
        }
    }

    public void apply(Page page) {
        if (this._attrs != null && this.isEffective(page)) {
            Evaluator eval = this.getEvaluator();
            for (Map.Entry<String, Object> me : this._attrs.entrySet()) {
                String name = me.getKey();
                Object value = me.getValue();
                page.setAttribute(name, Utils.evaluateComposite(eval, page, value), this._scope != -1 ? this._scope : 2);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40).append("[custom-attributes:");
        if (this._attrs != null) {
            for (String name : this._attrs.keySet()) {
                sb.append(' ').append(name);
            }
        }
        return sb.append(']').toString();
    }
}

