/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.util.ExecutionMonitor;

public class EventProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventProcessor.class);
    private final Desktop _desktop;
    private final Component _comp;
    private Event _event;
    private static ThreadLocal<Boolean> _inEvt;

    public static final boolean inEventListener() {
        return Thread.currentThread() instanceof EventProcessingThread || _inEvt != null && _inEvt.get() != null;
    }

    static final void inEventListener(boolean in) {
        if (in) {
            if (_inEvt == null) {
                _inEvt = new ThreadLocal();
            }
            _inEvt.set(Boolean.TRUE);
        } else if (_inEvt != null) {
            _inEvt.set(null);
        }
    }

    public EventProcessor(Desktop desktop, Component comp, Event event) {
        if (desktop == null || comp == null || event == null) {
            throw new IllegalArgumentException("null");
        }
        Desktop dt = comp.getDesktop();
        if (dt != null && desktop != dt) {
            throw new IllegalStateException("Process events for another desktop? " + comp);
        }
        this._desktop = desktop;
        this._comp = comp;
        this._event = event;
    }

    public final Desktop getDesktop() {
        return this._desktop;
    }

    public final Event getEvent() {
        return this._event;
    }

    public final Component getComponent() {
        return this._comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        ExecutionMonitor execmon = this._desktop.getWebApp().getConfiguration().getExecutionMonitor();
        Scope scope = Scopes.beforeInterpret(this._comp);
        try {
            Scopes.setImplicit("event", this._event);
            this._event = ((DesktopCtrl)((Object)this._desktop)).beforeProcessEvent(this._event);
            if (this._event != null) {
                if (execmon != null) {
                    execmon.eventStart(this._event);
                }
                Scopes.setImplicit("event", this._event);
                ((ComponentCtrl)((Object)this._comp)).service(this._event, scope);
                ((DesktopCtrl)((Object)this._desktop)).afterProcessEvent(this._event);
            }
        }
        finally {
            Execution exec = this._desktop.getExecution();
            if (exec != null) {
                ((ExecutionCtrl)((Object)exec)).setExecutionInfo(null);
            }
            if (execmon != null && this._event != null) {
                execmon.eventComplete(this._event);
            }
            Scopes.afterInterpret();
        }
    }

    public void setup() {
        SessionsCtrl.setCurrent(this._desktop.getSession());
        Execution exec = this._desktop.getExecution();
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)((Object)exec)).setCurrentPage(this.getPage());
    }

    public void cleanup() {
        ExecutionsCtrl.setCurrent(null);
        SessionsCtrl.setCurrent((Session)null);
    }

    private Page getPage() {
        Page page = this._comp.getPage();
        if (page != null) {
            return page;
        }
        return this._desktop.getFirstPage();
    }

    public String toString() {
        return "[comp: " + this._comp + ", event: " + this._event + ']';
    }
}

