/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hdgf.streams;

import org.zkoss.poi.hdgf.chunks.ChunkFactory;
import org.zkoss.poi.hdgf.pointers.Pointer;
import org.zkoss.poi.hdgf.pointers.PointerFactory;
import org.zkoss.poi.hdgf.streams.ChunkStream;
import org.zkoss.poi.hdgf.streams.Stream;
import org.zkoss.poi.hdgf.streams.StreamStore;
import org.zkoss.poi.util.LittleEndian;

public class PointerContainingStream
extends Stream {
    private Pointer[] childPointers;
    private Stream[] childStreams;
    private ChunkFactory chunkFactory;
    private PointerFactory pointerFactory;
    private int numPointersLocalOffset;

    protected PointerContainingStream(Pointer pointer, StreamStore store, ChunkFactory chunkFactory, PointerFactory pointerFactory) {
        super(pointer, store);
        this.chunkFactory = chunkFactory;
        this.pointerFactory = pointerFactory;
        this.numPointersLocalOffset = (int)LittleEndian.getUInt(store.getContents(), 0);
        int numPointers = (int)LittleEndian.getUInt(store.getContents(), this.numPointersLocalOffset);
        this.childPointers = new Pointer[numPointers];
        int pos = this.numPointersLocalOffset + 4 + 4;
        for (int i = 0; i < numPointers; ++i) {
            this.childPointers[i] = pointerFactory.createPointer(store.getContents(), pos);
            pos += this.childPointers[i].getSizeInBytes();
        }
    }

    protected Pointer[] getChildPointers() {
        return this.childPointers;
    }

    public Stream[] getPointedToStreams() {
        return this.childStreams;
    }

    public void findChildren(byte[] documentData) {
        this.childStreams = new Stream[this.childPointers.length];
        for (int i = 0; i < this.childPointers.length; ++i) {
            Stream child;
            Pointer ptr = this.childPointers[i];
            this.childStreams[i] = Stream.createStream(ptr, documentData, this.chunkFactory, this.pointerFactory);
            if (this.childStreams[i] instanceof ChunkStream) {
                child = (ChunkStream)this.childStreams[i];
                ((ChunkStream)child).findChunks();
            }
            if (!(this.childStreams[i] instanceof PointerContainingStream)) continue;
            child = (PointerContainingStream)this.childStreams[i];
            ((PointerContainingStream)child).findChildren(documentData);
        }
    }
}

