/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.api.AreaRef;
import io.keikai.ui.impl.MergedRect;
import io.keikai.ui.impl.SequenceId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergeMatrixHelper
implements Serializable {
    private static final long serialVersionUID = -8360458859084652393L;
    private Map _leftTopIndex = new HashMap(5);
    private Map _mergeByIndex = new HashMap(20);
    private List<MergedRect> _mergeRanges = new LinkedList<MergedRect>();
    private int _frozenRow;
    private int _frozenCol;
    private SequenceId _mergeId = new SequenceId(0, 1);

    public MergeMatrixHelper(List mergeRange, int frozenRow, int frozenCol) {
        for (int[] r : mergeRange) {
            int left = r[0];
            int top = r[1];
            int right = r[2];
            int bottom = r[3];
            MergedRect block = new MergedRect(this._mergeId.next(), left, top, right, bottom);
            this._mergeRanges.add(block);
        }
        this._frozenRow = frozenRow;
        this._frozenCol = frozenCol;
        this.rebuildIndex();
    }

    private void rebuildIndex() {
        this._leftTopIndex = new HashMap(5);
        this._mergeByIndex = new HashMap(20);
        for (MergedRect block : this._mergeRanges) {
            int left = block.getColumn();
            int top = block.getRow();
            int right = block.getLastColumn();
            int bottom = block.getLastRow();
            this._leftTopIndex.put(top + "_" + left, block);
            for (int r = top; r <= bottom; ++r) {
                for (int c = left; c <= right; ++c) {
                    this._mergeByIndex.put(r + "_" + c, block);
                }
            }
        }
    }

    public void update(int frozenRow, int frozenCol) {
        this._frozenRow = frozenRow;
        this._frozenCol = frozenCol;
    }

    public boolean isMergeRangeLeftTop(int row, int col) {
        return this._leftTopIndex.get(row + "_" + col) != null;
    }

    public MergedRect getMergeRange(int row, int col) {
        MergedRect range = (MergedRect)this._mergeByIndex.get(row + "_" + col);
        return range;
    }

    public List<MergedRect> getRanges() {
        return this._mergeRanges;
    }

    public MergedRect getMergedRect(int id) {
        for (MergedRect r : this._mergeRanges) {
            if (r.getId() != id) continue;
            return r;
        }
        return null;
    }

    public Set getRangesByColumn(int col) {
        Iterator<MergedRect> iter = this._mergeRanges.iterator();
        HashSet<AreaRef> result = new HashSet<AreaRef>();
        while (iter.hasNext()) {
            AreaRef rect = iter.next();
            int left = rect.getColumn();
            int right = rect.getLastColumn();
            if (left > col || right < col) continue;
            result.add(rect);
        }
        return result;
    }

    public int getRightConnectedColumn(int col, int top, int bottom) {
        MergedRect rect;
        int size = this._mergeRanges.size();
        ArrayList<MergedRect> result = new ArrayList<MergedRect>();
        for (int i = 0; i < size; ++i) {
            rect = this._mergeRanges.get(i);
            if (rect.getRow() > this._frozenRow && (rect.getRow() < top || rect.getLastRow() > bottom)) continue;
            result.add(rect);
        }
        boolean conti = true;
        block1: while (conti) {
            conti = false;
            size = result.size();
            for (int i = 0; i < size; ++i) {
                rect = (MergedRect)result.get(i);
                if (rect.getLastColumn() <= col || rect.getColumn() > col) continue;
                col = rect.getLastColumn();
                conti = true;
                result.remove(i);
                continue block1;
            }
        }
        return col;
    }

    public int getLeftConnectedColumn(int col, int top, int bottom) {
        MergedRect rect;
        int size = this._mergeRanges.size();
        ArrayList<MergedRect> result = new ArrayList<MergedRect>();
        for (int i = 0; i < size; ++i) {
            rect = this._mergeRanges.get(i);
            if (rect.getRow() > this._frozenRow && (rect.getRow() < top || rect.getLastRow() > bottom)) continue;
            result.add(rect);
        }
        boolean conti = true;
        block1: while (conti) {
            conti = false;
            size = result.size();
            for (int i = 0; i < size; ++i) {
                rect = (MergedRect)result.get(i);
                if (rect.getColumn() >= col || rect.getLastColumn() < col) continue;
                col = rect.getColumn();
                conti = true;
                result.remove(i);
                continue block1;
            }
        }
        return col;
    }

    public int getBottomConnectedRow(int row, int left, int right) {
        MergedRect rect;
        int size = this._mergeRanges.size();
        ArrayList<MergedRect> result = new ArrayList<MergedRect>();
        for (int i = 0; i < size; ++i) {
            rect = this._mergeRanges.get(i);
            if (rect.getColumn() > this._frozenCol && (rect.getColumn() < left || rect.getLastColumn() > right)) continue;
            result.add(rect);
        }
        boolean conti = true;
        block1: while (conti) {
            conti = false;
            size = result.size();
            for (int i = 0; i < size; ++i) {
                rect = (MergedRect)result.get(i);
                if (rect.getLastRow() <= row || rect.getRow() > row) continue;
                row = rect.getLastRow();
                conti = true;
                result.remove(i);
                continue block1;
            }
        }
        return row;
    }

    public int getTopConnectedRow(int row, int left, int right) {
        MergedRect rect;
        int size = this._mergeRanges.size();
        ArrayList<MergedRect> result = new ArrayList<MergedRect>();
        for (int i = 0; i < size; ++i) {
            rect = this._mergeRanges.get(i);
            if (rect.getColumn() > this._frozenCol && (rect.getColumn() < left || rect.getLastColumn() > right)) continue;
            result.add(rect);
        }
        boolean conti = true;
        block1: while (conti) {
            conti = false;
            size = result.size();
            for (int i = 0; i < size; ++i) {
                rect = (MergedRect)result.get(i);
                if (rect.getRow() >= row || rect.getLastRow() < row) continue;
                row = rect.getRow();
                conti = true;
                result.remove(i);
                continue block1;
            }
        }
        return row;
    }

    public void updateMergeRange(int oleft, int otop, int oright, int obottom, int left, int top, int right, int bottom, Set toadd, Set torem) {
        for (int i = otop; i <= obottom; ++i) {
            MergedRect mblock = this.getMergeRange(i, oleft);
            if (mblock == null) continue;
            torem.add(mblock);
            this._mergeRanges.remove(mblock);
        }
        MergedRect mblock = new MergedRect(this._mergeId.next(), left, top, right, bottom);
        toadd.add(mblock);
        this._mergeRanges.add(mblock);
        this.rebuildIndex();
    }

    public void deleteMergeRange(int left, int top, int right, int bottom, Set torem) {
        this.deleteMergeRangeX(left, top, right, bottom, torem, true);
    }

    public void deleteMergeRangeX(int left, int top, int right, int bottom, Set torem, boolean rebuildIndex) {
        MergedRect mblock = this.getMergeRange(top, left);
        if (mblock != null) {
            torem.add(mblock);
            this._mergeRanges.remove(mblock);
        }
        if (rebuildIndex) {
            this.rebuildIndex();
        }
    }

    public void addMergeRange(int left, int top, int right, int bottom, Set toadd, Set torem) {
        this.addMergeRangeX(left, top, right, bottom, toadd, torem, true);
    }

    public void addMergeRangeX(int left, int top, int right, int bottom, Set toadd, Set torem, boolean rebuildIndex) {
        MergedRect mblock = this.getMergeRange(top, left);
        if (mblock != null) {
            torem.add(mblock);
            this._mergeRanges.remove(mblock);
        }
        mblock = new MergedRect(this._mergeId.next(), left, top, right, bottom);
        toadd.add(mblock);
        this._mergeRanges.add(mblock);
        if (rebuildIndex) {
            this.rebuildIndex();
        }
    }

    public void deleteAffectedMergeRangeByColumn(int col, Set removed) {
        for (MergedRect block : this._mergeRanges) {
            int right = block.getLastColumn();
            if (right < col) continue;
            removed.add(block);
        }
        for (MergedRect block : removed) {
            this._mergeRanges.remove(block);
        }
        this.rebuildIndex();
    }

    public void deleteAffectedMergeRangeByRow(int row, Set removed) {
        for (MergedRect block : this._mergeRanges) {
            int bottom = block.getLastRow();
            if (bottom < row) continue;
            removed.add(block);
        }
        for (MergedRect block : removed) {
            this._mergeRanges.remove(block);
        }
        this.rebuildIndex();
    }
}

