



zss.MergeMatrix =  zk.$extends(zk.Object, {
	mergeMatrix: [],
	$init: function (matrix, sheet) {
		this.$supers('$init', arguments);
		this.mergeMatrix = matrix;
		this.sheet = sheet;
	},
	
	getRangesByRow: function (row) {
		var size = this.mergeMatrix.length,
			result = [],
			range;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.top <= row && range.bottom >= row)
				result.push(range);
		}
		return result;
	},
	
	getTopConnectedRow: function (row, left, right) {
		var size = this.mergeMatrix.length,
			result = [],
			range,
			fzc = this.sheet.frozenCol;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.left > fzc && (range.left < left || range.right > right))
				continue;
			result.push(range);
		}
		
		var conti = true;
		while (conti) {
			conti = false;
			size = result.length;
			for(var i = 0; i < size; i++) {
				range = result[i];
				if (range.top < row && range.bottom >= row) {
					row = range.top;
					conti = true;
					
					break;
				}
			}
		}
		return row;
	},
	
	getBottomConnectedRow: function (row, left, right) {
		var size = this.mergeMatrix.length,
			result = [],
			range,
			fzc = this.sheet.frozenCol;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.left > fzc && (range.left < left || range.right > right))
				continue;
			result.push(range);
		}
		
		var conti = true;
		while (conti) {
			conti = false;
			size = result.length;
			for (var i = 0; i < size; i++) {
				range = result[i];
				if (range.bottom > row && range.top <= row) {
					row = range.bottom;
					conti = true;
					
					break;
				}
			}
		}
		return row;
	},
	
	getRangesByColumn: function (col) {
		var size = this.mergeMatrix.length,
			result = [],
			range;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.left <= col && range.right >= col)
				result.push(range);
		}
		return result;
	},
	
	getLeftConnectedColumn: function (col, top, bottom) {
		var size = this.mergeMatrix.length,
			result = [],
			range,
			fzr = this.sheet.frozenRow;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.top > fzr && (range.top < top || range.bottom > bottom))
				continue;
			result.push(range);
		}
		
		var conti = true;
		while (conti) {
			conti = false;
			size = result.length;
			for(var i = 0; i < size; i++) {
				range = result[i];
				if (range.left < col && range.right >= col) {
					col = range.left;
					conti = true;
					
					break;
				}
			}
		}
		return col;
	},
	
	getRightConnectedColumn: function (col, top, bottom) {
		var size = this.mergeMatrix.length,
			result = [],
			range,
			fzr = this.sheet.frozenRow;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.top > fzr && (range.top < top || range.bottom > bottom))
				continue;
			result.push(range);
		}
		
		var conti = true;
		while (conti) {
			conti = false;
			size = result.length;
			for (var i = 0; i < size; i++) {
				range = result[i];
				if (range.right > col && range.left <= col) {
					col = range.right;
					conti = true;
					
					break;
				}
			}
		}
		return col;
	},
	
	addMergeRange: function(id, left, top, right, bottom) {
		var range = new zss.Range(left, top, right, bottom);
		range.id = id;
		this.mergeMatrix.push(range);
	},
	
	removeMergeRange: function (id) {
		var mm = this.mergeMatrix,
			size = mm.length;
		for (var i = 0; i < size; i++) {
			range = mm[i];
			if (range.id == id) {
				var tail = mm.slice(i + 1, size);
				mm.length = i;
				mm.push.apply(mm,tail);
				break;
			}
		}
	},
	
	
	getTopRow: function (row) {
		var size = this.mergeMatrix.length,
			top = row,
			range;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.top <= row && range.bottom >= row && range.top < top)
				top = range.top;
		}
		return top;
	},
	
	
	getLeftCol: function (col) {
		var size = this.mergeMatrix.length,
			left = col,
			range;
		for (var i = 0; i < size; i++) {
			range = this.mergeMatrix[i];
			if (range.left <= col && range.right >= col && range.left < left)
				left = range.left;
		}
		return left;
	}
	,
	
	
	removeAllMergeRange: function (owner, fn) {
		if (fn) {
			var mm = this.mergeMatrix,
				size = mm.length;
			for (var i = 0; i < size; i++) {
				var range = mm[i];
				fn.call(owner, range);
			}
		}
		this.mergeMatrix = [];
	}
});