/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class RowRecord
extends StandardRecord {
    public static final short sid = 520;
    public static final int ENCODED_SIZE = 20;
    private static final int OPTION_BITS_ALWAYS_SET = 256;
    private static final int DEFAULT_HEIGHT_BIT = 32768;
    private int field_1_row_number;
    private int field_2_first_col;
    private int field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private int field_7_option_flags;
    private static final BitField outlineLevel = BitFieldFactory.getInstance(7);
    private static final BitField colapsed = BitFieldFactory.getInstance(16);
    private static final BitField zeroHeight = BitFieldFactory.getInstance(32);
    private static final BitField badFontHeight = BitFieldFactory.getInstance(64);
    private static final BitField formatted = BitFieldFactory.getInstance(128);
    private short field_8_xf_index;
    private static final BitField xfIndex = BitFieldFactory.getInstance(4095);
    private static final BitField thickBorderTop = BitFieldFactory.getInstance(4096);
    private static final BitField thickBorderBottom = BitFieldFactory.getInstance(8192);
    private static final BitField phonetic = BitFieldFactory.getInstance(16384);
    private static final BitField reserved = BitFieldFactory.getInstance(32768);

    public RowRecord(int rowNumber) {
        this.field_1_row_number = rowNumber;
        this.field_4_height = (short)255;
        this.field_5_optimize = 0;
        this.field_6_reserved = 0;
        this.field_7_option_flags = 256;
        this.field_8_xf_index = (short)15;
        this.setEmpty();
    }

    public RowRecord(RecordInputStream in) {
        this.field_1_row_number = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_last_col = in.readShort();
        this.field_4_height = in.readShort();
        this.field_5_optimize = in.readShort();
        this.field_6_reserved = in.readShort();
        this.field_7_option_flags = in.readShort();
        this.field_8_xf_index = in.readShort();
    }

    public void setEmpty() {
        this.field_2_first_col = 0;
        this.field_3_last_col = 0;
    }

    public boolean isEmpty() {
        return (this.field_2_first_col | this.field_3_last_col) == 0;
    }

    public void setRowNumber(int row) {
        this.field_1_row_number = row;
    }

    public void setFirstCol(int col) {
        this.field_2_first_col = col;
    }

    public void setLastCol(int col) {
        this.field_3_last_col = col;
    }

    public void setHeight(short height) {
        this.field_4_height = height;
    }

    public void setOptimize(short optimize) {
        this.field_5_optimize = optimize;
    }

    public void setOutlineLevel(short ol) {
        this.field_7_option_flags = outlineLevel.setValue(this.field_7_option_flags, ol);
    }

    public void setColapsed(boolean c) {
        this.field_7_option_flags = colapsed.setBoolean(this.field_7_option_flags, c);
    }

    public void setZeroHeight(boolean z) {
        this.field_7_option_flags = zeroHeight.setBoolean(this.field_7_option_flags, z);
    }

    public void setBadFontHeight(boolean f) {
        this.field_7_option_flags = badFontHeight.setBoolean(this.field_7_option_flags, f);
    }

    public void setFormatted(boolean f) {
        this.field_7_option_flags = formatted.setBoolean(this.field_7_option_flags, f);
    }

    public void setXFIndex(short index) {
        this.field_8_xf_index = xfIndex.setShortValue(this.field_8_xf_index, index);
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public int getFirstCol() {
        return this.field_2_first_col;
    }

    public int getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return (short)this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return (short)outlineLevel.getValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return xfIndex.getShortValue(this.field_8_xf_index);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ROW]\n");
        sb.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        sb.append("    .firstcol       = ").append(HexDump.shortToHex(this.getFirstCol())).append("\n");
        sb.append("    .lastcol        = ").append(HexDump.shortToHex(this.getLastCol())).append("\n");
        sb.append("    .height         = ").append(HexDump.shortToHex(this.getHeight())).append("\n");
        sb.append("    .optimize       = ").append(HexDump.shortToHex(this.getOptimize())).append("\n");
        sb.append("    .reserved       = ").append(HexDump.shortToHex(this.field_6_reserved)).append("\n");
        sb.append("    .optionflags    = ").append(HexDump.shortToHex(this.getOptionFlags())).append("\n");
        sb.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        sb.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        sb.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        sb.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        sb.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        sb.append("    .xfindex+flags  = ").append(HexDump.shortToHex(this.field_8_xf_index)).append("\n");
        sb.append("        .xfindex    = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        sb.append("        .thickBorderTop   = ").append(this.isThickBorderTop()).append("\n");
        sb.append("        .thickBorderBottom= ").append(this.isThickBorderBottom()).append("\n");
        sb.append("        .phonetic         = ").append(this.isPhonetic()).append("\n");
        sb.append("[/ROW]\n");
        return sb.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getRowNumber());
        out.writeShort(this.getFirstCol() == -1 ? 0 : this.getFirstCol());
        out.writeShort(this.getLastCol() == -1 ? 0 : this.getLastCol());
        out.writeShort(this.getHeight());
        out.writeShort(this.getOptimize());
        out.writeShort(this.field_6_reserved);
        out.writeShort(this.getOptionFlags());
        out.writeShort(this.field_8_xf_index);
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public short getSid() {
        return 520;
    }

    @Override
    public Object clone() {
        RowRecord rec = new RowRecord(this.field_1_row_number);
        rec.field_2_first_col = this.field_2_first_col;
        rec.field_3_last_col = this.field_3_last_col;
        rec.field_4_height = this.field_4_height;
        rec.field_5_optimize = this.field_5_optimize;
        rec.field_6_reserved = this.field_6_reserved;
        rec.field_7_option_flags = this.field_7_option_flags;
        rec.field_8_xf_index = this.field_8_xf_index;
        return rec;
    }

    public boolean isThickBorderTop() {
        return thickBorderTop.isSet(this.field_8_xf_index);
    }

    public void setThickBorderTop(boolean f) {
        this.field_8_xf_index = (short)thickBorderTop.setBoolean(this.field_8_xf_index, f);
    }

    public boolean isThickBorderBottom() {
        return thickBorderBottom.isSet(this.field_8_xf_index);
    }

    public void setThickBorderBottom(boolean f) {
        this.field_8_xf_index = (short)thickBorderBottom.setBoolean(this.field_8_xf_index, f);
    }

    public boolean isPhonetic() {
        return phonetic.isSet(this.field_8_xf_index);
    }

    public void setPhonetic(boolean f) {
        this.field_8_xf_index = (short)phonetic.setBoolean(this.field_8_xf_index, f);
    }
}

