/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.memberside.validator;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.submitjob.memberside.JobMetaDataParameterObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;

public final class JarOnClientValidator {
    private JarOnClientValidator() {
    }

    public static void validate(JobMetaDataParameterObject parameterObject) {
        JarOnClientValidator.validateUploadDirectoryPath(parameterObject.getUploadDirectoryPath());
        JarOnClientValidator.validateJobParameters(parameterObject.getJobParameters());
    }

    static void validateUploadDirectoryPath(String uploadDirectoryPath) {
        Path path;
        if (uploadDirectoryPath != null && !Files.exists(path = Paths.get(uploadDirectoryPath, new String[0]), new LinkOption[0])) {
            String errorMessage = String.format("The upload directory path does not exist: %s", path);
            throw new JetException(errorMessage);
        }
    }

    static void validateJobParameters(List<String> jobParameters) {
        if (Objects.isNull(jobParameters)) {
            throw new JetException("jobParameters can not be null");
        }
    }
}

