/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.felix.webconsole;

import java.util.Properties;
import java.util.logging.Level;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class SecurityProviderImpl
implements WebConsoleSecurityProvider {
    private static final CLogger log = CLogger.getCLogger(SecurityProviderImpl.class);

    public Object authenticate(String username, String password) {
        MUser user = MUser.get((Properties)Env.getCtx(), (String)username, (String)password);
        if (user == null) {
            log.warning("User not found: '" + username);
            return null;
        }
        if (!user.isAdministrator() && !user.hasURLFormAccess("/osgi/system/console")) {
            log.warning("User doesn't have access to /osgi/system/console = " + username);
            return null;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Name=" + username);
        }
        return Boolean.TRUE;
    }

    public boolean authorize(Object resource, String role) {
        return true;
    }
}

