/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.DeferredNamedListImpl;
import org.olap4j.driver.xmla.MetadataReader;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jDimension;
import org.olap4j.driver.xmla.XmlaOlap4jHierarchy;
import org.olap4j.driver.xmla.XmlaOlap4jLevel;
import org.olap4j.driver.xmla.XmlaOlap4jMeasure;
import org.olap4j.driver.xmla.XmlaOlap4jMember;
import org.olap4j.driver.xmla.XmlaOlap4jNamedSet;
import org.olap4j.driver.xmla.XmlaOlap4jSchema;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.NamedSet;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jCube
implements Cube,
Named {
    final XmlaOlap4jSchema olap4jSchema;
    private final String name;
    private final String description;
    final NamedList<XmlaOlap4jDimension> dimensions;
    final Map<String, XmlaOlap4jDimension> dimensionsByUname = new HashMap<String, XmlaOlap4jDimension>();
    private NamedList<XmlaOlap4jHierarchy> hierarchies = null;
    final Map<String, XmlaOlap4jHierarchy> hierarchiesByUname = new HashMap<String, XmlaOlap4jHierarchy>();
    final Map<String, XmlaOlap4jLevel> levelsByUname = new HashMap<String, XmlaOlap4jLevel>();
    final List<XmlaOlap4jMeasure> measures = new ArrayList<XmlaOlap4jMeasure>();
    private final HashMap<String, XmlaOlap4jMeasure> measuresMap = new HashMap();
    private final NamedList<XmlaOlap4jNamedSet> namedSets = new NamedListImpl<XmlaOlap4jNamedSet>();
    private final MetadataReader metadataReader;

    XmlaOlap4jCube(XmlaOlap4jSchema olap4jSchema, String name, String description) throws OlapException {
        assert (olap4jSchema != null);
        assert (description != null);
        assert (name != null);
        this.olap4jSchema = olap4jSchema;
        this.name = name;
        this.description = description;
        this.metadataReader = new CachingMetadataReader(new RawMetadataReader(), this.measuresMap);
        XmlaOlap4jConnection olap4jConnection = olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(this, null, null, null);
        Object[] restrictions = new String[]{"CATALOG_NAME", olap4jSchema.olap4jCatalog.getName(), "SCHEMA_NAME", olap4jSchema.getName(), "CUBE_NAME", this.getName()};
        this.dimensions = new DeferredNamedListImpl<XmlaOlap4jDimension>(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_DIMENSIONS, context, new XmlaOlap4jConnection.DimensionHandler(this), restrictions);
        olap4jConnection.populateList(this.measures, context, XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEASURES, new XmlaOlap4jConnection.MeasureHandler(this.dimensions.get("Measures")), restrictions);
        for (XmlaOlap4jMeasure measure : this.measures) {
            this.measuresMap.put(measure.getUniqueName(), measure);
        }
        olap4jConnection.populateList(this.namedSets, context, XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_SETS, new XmlaOlap4jConnection.NamedSetHandler(), restrictions);
    }

    @Override
    public Schema getSchema() {
        return this.olap4jSchema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return "[" + this.name + "]";
    }

    @Override
    public String getCaption(Locale locale) {
        return this.name;
    }

    @Override
    public String getDescription(Locale locale) {
        return this.description;
    }

    @Override
    public NamedList<Dimension> getDimensions() {
        return Olap4jUtil.cast(this.dimensions);
    }

    @Override
    public NamedList<Hierarchy> getHierarchies() {
        if (this.hierarchies == null) {
            this.hierarchies = new NamedListImpl<XmlaOlap4jHierarchy>();
            for (XmlaOlap4jDimension dim : this.dimensions) {
                this.hierarchies.addAll(dim.hierarchies);
            }
        }
        return Olap4jUtil.cast(this.hierarchies);
    }

    @Override
    public List<Measure> getMeasures() {
        return Olap4jUtil.cast(this.measures);
    }

    @Override
    public NamedList<NamedSet> getSets() {
        return Olap4jUtil.cast(this.namedSets);
    }

    @Override
    public Collection<Locale> getSupportedLocales() {
        return Collections.singletonList(Locale.getDefault());
    }

    @Override
    public Member lookupMember(String ... nameParts) throws OlapException {
        ArrayList<IdentifierNode.Segment> segmentList = new ArrayList<IdentifierNode.Segment>();
        for (String namePart : nameParts) {
            segmentList.add(new IdentifierNode.NameSegment(namePart));
        }
        return this.lookupMember(segmentList);
    }

    private Member lookupMember(List<IdentifierNode.Segment> segmentList) throws OlapException {
        StringBuilder buf = new StringBuilder();
        for (IdentifierNode.Segment segment : segmentList) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(((Object)segment).toString());
        }
        String uniqueName = buf.toString();
        return this.getMetadataReader().lookupMemberByUniqueName(uniqueName);
    }

    MetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    @Override
    public List<Member> lookupMembers(Set<Member.TreeOp> treeOps, String ... nameParts) throws OlapException {
        StringBuilder buf = new StringBuilder();
        for (String namePart : nameParts) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(new IdentifierNode.NameSegment(namePart));
        }
        String uniqueName = buf.toString();
        ArrayList<XmlaOlap4jMember> list = new ArrayList<XmlaOlap4jMember>();
        this.getMetadataReader().lookupMemberRelatives(treeOps, uniqueName, list);
        return Olap4jUtil.cast(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawMetadataReader
    implements MetadataReader {
        private RawMetadataReader() {
        }

        @Override
        public XmlaOlap4jMember lookupMemberByUniqueName(String memberUniqueName) throws OlapException {
            NamedListImpl<XmlaOlap4jMember> list = new NamedListImpl<XmlaOlap4jMember>();
            this.lookupMemberRelatives(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.SELF, (Enum[])new Member.TreeOp[0]), memberUniqueName, list);
            switch (list.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (XmlaOlap4jMember)list.get(0);
                }
            }
            throw new IllegalArgumentException("more than one member with unique name '" + memberUniqueName + "'");
        }

        @Override
        public void lookupMembersByUniqueName(List<String> memberUniqueNames, Map<String, XmlaOlap4jMember> memberMap) throws OlapException {
            if (XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.getDataSourceInfo().indexOf("Provider=Mondrian") != -1) {
                this.mondrianMembersLookup(memberUniqueNames, memberMap);
            } else {
                this.genericMembersLookup(memberUniqueNames, memberMap);
            }
        }

        private void mondrianMembersLookup(List<String> memberUniqueNames, Map<String, XmlaOlap4jMember> memberMap) throws OlapException {
            XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(XmlaOlap4jCube.this, null, null, null);
            ArrayList memberList = new ArrayList();
            XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.populateList(memberList, context, XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEMBERS, new XmlaOlap4jConnection.MemberHandler(), new Object[]{"CATALOG_NAME", XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.getName(), "SCHEMA_NAME", XmlaOlap4jCube.this.olap4jSchema.getName(), "CUBE_NAME", XmlaOlap4jCube.this.getName(), "MEMBER_UNIQUE_NAME", memberUniqueNames});
            for (XmlaOlap4jMember member : memberList) {
                if (member == null) continue;
                memberMap.put(member.getUniqueName(), member);
            }
        }

        private void genericMembersLookup(List<String> memberUniqueNames, Map<String, XmlaOlap4jMember> memberMap) throws OlapException {
            for (String currentMemberName : memberUniqueNames) {
                XmlaOlap4jMember member;
                if (memberMap.containsKey(currentMemberName) || (member = this.lookupMemberByUniqueName(currentMemberName)) == null) continue;
                memberMap.put(member.getUniqueName(), member);
            }
        }

        @Override
        public void lookupMemberRelatives(Set<Member.TreeOp> treeOps, String memberUniqueName, List<XmlaOlap4jMember> list) throws OlapException {
            XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(XmlaOlap4jCube.this, null, null, null);
            int treeOpMask = 0;
            for (Member.TreeOp treeOp : treeOps) {
                treeOpMask |= treeOp.xmlaOrdinal();
            }
            XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.populateList(list, context, XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEMBERS, new XmlaOlap4jConnection.MemberHandler(), new Object[]{"CATALOG_NAME", XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.getName(), "SCHEMA_NAME", XmlaOlap4jCube.this.olap4jSchema.getName(), "CUBE_NAME", XmlaOlap4jCube.this.getName(), "MEMBER_UNIQUE_NAME", memberUniqueName, "TREE_OP", String.valueOf(treeOpMask)});
        }

        @Override
        public List<XmlaOlap4jMember> getLevelMembers(XmlaOlap4jLevel level) throws OlapException {
            assert (level.olap4jHierarchy.olap4jDimension.olap4jCube == XmlaOlap4jCube.this);
            XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(level);
            ArrayList<XmlaOlap4jMember> list = new ArrayList<XmlaOlap4jMember>();
            switch (level.getDimension().getDimensionType()) {
                case MEASURE: {
                    if (level.olap4jHierarchy.olap4jDimension.olap4jCube.measures.isEmpty()) break;
                    return Olap4jUtil.cast(level.olap4jHierarchy.olap4jDimension.olap4jCube.measures);
                }
            }
            XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.populateList(list, context, XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEMBERS, new XmlaOlap4jConnection.MemberHandler(), new Object[]{"CATALOG_NAME", XmlaOlap4jCube.this.olap4jSchema.olap4jCatalog.getName(), "SCHEMA_NAME", XmlaOlap4jCube.this.olap4jSchema.getName(), "CUBE_NAME", XmlaOlap4jCube.this.getName(), "DIMENSION_UNIQUE_NAME", level.olap4jHierarchy.olap4jDimension.getUniqueName(), "HIERARCHY_UNIQUE_NAME", level.olap4jHierarchy.getUniqueName(), "LEVEL_UNIQUE_NAME", level.getUniqueName()});
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingMetadataReader
    extends DelegatingMetadataReader {
        private final Map<String, XmlaOlap4jMeasure> measuresMap;
        private final Map<String, SoftReference<XmlaOlap4jMember>> memberMap = new HashMap<String, SoftReference<XmlaOlap4jMember>>();
        private final Map<XmlaOlap4jLevel, SoftReference<List<XmlaOlap4jMember>>> levelMemberListMap = new HashMap<XmlaOlap4jLevel, SoftReference<List<XmlaOlap4jMember>>>();

        CachingMetadataReader(MetadataReader metadataReader, Map<String, XmlaOlap4jMeasure> measuresMap) {
            super(metadataReader);
            this.measuresMap = measuresMap;
        }

        @Override
        public XmlaOlap4jMember lookupMemberByUniqueName(String memberUniqueName) throws OlapException {
            XmlaOlap4jMember member;
            XmlaOlap4jMeasure measure = this.measuresMap.get(memberUniqueName);
            if (measure != null) {
                return measure;
            }
            SoftReference<XmlaOlap4jMember> memberRef = this.memberMap.get(memberUniqueName);
            if (memberRef != null && (member = memberRef.get()) != null) {
                return member;
            }
            member = super.lookupMemberByUniqueName(memberUniqueName);
            if (member != null && member.getDimension().type != Dimension.Type.MEASURE) {
                this.memberMap.put(memberUniqueName, new SoftReference<XmlaOlap4jMember>(member));
            }
            return member;
        }

        @Override
        public void lookupMembersByUniqueName(List<String> memberUniqueNames, Map<String, XmlaOlap4jMember> memberMap) throws OlapException {
            ArrayList<String> remainingMemberUniqueNames = new ArrayList<String>();
            for (String memberUniqueName : memberUniqueNames) {
                XmlaOlap4jMember member;
                XmlaOlap4jMeasure measure = this.measuresMap.get(memberUniqueName);
                if (measure != null) {
                    memberMap.put(memberUniqueName, measure);
                    continue;
                }
                SoftReference<XmlaOlap4jMember> memberRef = this.memberMap.get(memberUniqueName);
                if (memberRef != null && (member = memberRef.get()) != null) {
                    memberMap.put(memberUniqueName, member);
                    continue;
                }
                remainingMemberUniqueNames.add(memberUniqueName);
            }
            if (!remainingMemberUniqueNames.isEmpty()) {
                super.lookupMembersByUniqueName(remainingMemberUniqueNames, memberMap);
                for (String memberName : remainingMemberUniqueNames) {
                    XmlaOlap4jMember member = memberMap.get(memberName);
                    if (member == null || member instanceof Measure || member.getDimension().type == Dimension.Type.MEASURE) continue;
                    this.memberMap.put(memberName, new SoftReference<XmlaOlap4jMember>(member));
                }
            }
        }

        @Override
        public List<XmlaOlap4jMember> getLevelMembers(XmlaOlap4jLevel level) throws OlapException {
            List<XmlaOlap4jMember> memberList;
            SoftReference<List<XmlaOlap4jMember>> memberListRef = this.levelMemberListMap.get(level);
            if (memberListRef != null && (memberList = memberListRef.get()) != null) {
                return memberList;
            }
            memberList = super.getLevelMembers(level);
            if (level.olap4jHierarchy.olap4jDimension.type != Dimension.Type.MEASURE) {
                this.levelMemberListMap.put(level, new SoftReference<List<XmlaOlap4jMember>>(memberList));
            }
            return memberList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DelegatingMetadataReader
    implements MetadataReader {
        private final MetadataReader metadataReader;

        DelegatingMetadataReader(MetadataReader metadataReader) {
            this.metadataReader = metadataReader;
        }

        @Override
        public XmlaOlap4jMember lookupMemberByUniqueName(String memberUniqueName) throws OlapException {
            return this.metadataReader.lookupMemberByUniqueName(memberUniqueName);
        }

        @Override
        public void lookupMembersByUniqueName(List<String> memberUniqueNames, Map<String, XmlaOlap4jMember> memberMap) throws OlapException {
            this.metadataReader.lookupMembersByUniqueName(memberUniqueNames, memberMap);
        }

        @Override
        public void lookupMemberRelatives(Set<Member.TreeOp> treeOps, String memberUniqueName, List<XmlaOlap4jMember> list) throws OlapException {
            this.metadataReader.lookupMemberRelatives(treeOps, memberUniqueName, list);
        }

        @Override
        public List<XmlaOlap4jMember> getLevelMembers(XmlaOlap4jLevel level) throws OlapException {
            return this.metadataReader.getLevelMembers(level);
        }
    }
}

