/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.adempiere.eclipse.equinox.http.servlet.HttpSessionAdaptor;
import org.adempiere.eclipse.equinox.http.servlet.RequestDispatcherAdaptor;

public class HttpServletRequestAdaptor
extends HttpServletRequestWrapper {
    private String alias;
    private Servlet servlet;
    private boolean isRequestDispatcherInclude;
    private boolean calledByFilter;
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";

    public HttpServletRequestAdaptor(HttpServletRequest req, String alias, Servlet servlet, FilterChain filterChain) {
        super(req);
        this.alias = alias;
        this.servlet = servlet;
        this.isRequestDispatcherInclude = req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
        this.calledByFilter = filterChain != null;
    }

    public String getAuthType() {
        String authType = (String)super.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return super.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)super.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public String getPathInfo() {
        String pathInfo = HttpServletRequestAdaptor.getPathInfo(super.getPathInfo(), super.getContextPath(), super.getRequestURI(), this.calledByFilter);
        if (this.isRequestDispatcherInclude) {
            return pathInfo;
        }
        if (this.alias.equals("/")) {
            return pathInfo;
        }
        if ((pathInfo = pathInfo.substring(this.alias.length())).length() == 0) {
            return null;
        }
        return pathInfo;
    }

    public String getServletPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getServletPath();
        }
        if (this.alias.equals("/")) {
            return "";
        }
        return this.alias;
    }

    public String getContextPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getContextPath();
        }
        if (!this.calledByFilter) {
            return super.getContextPath() + super.getServletPath();
        }
        return super.getContextPath();
    }

    public Object getAttribute(String attributeName) {
        if (this.isRequestDispatcherInclude) {
            if (attributeName.equals(INCLUDE_CONTEXT_PATH_ATTRIBUTE)) {
                String servletPath;
                String contextPath = (String)super.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
                if (contextPath == null || contextPath.equals("/")) {
                    contextPath = "";
                }
                if ((servletPath = (String)super.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE)) == null || servletPath.equals("/")) {
                    servletPath = "";
                }
                return contextPath + servletPath;
            }
            if (attributeName.equals(INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                if (this.alias.equals("/")) {
                    return "";
                }
                return this.alias;
            }
            if (attributeName.equals(INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String pathInfo = (String)super.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if (this.alias.equals("/")) {
                    return pathInfo;
                }
                if ((pathInfo = pathInfo.substring(this.alias.length())).length() == 0) {
                    return null;
                }
                return pathInfo;
            }
        }
        return super.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(super.getRequestDispatcher(super.getServletPath() + arg0));
    }

    public static String getDispatchPathInfo(HttpServletRequest req, FilterChain filterChain) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            return (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        }
        return HttpServletRequestAdaptor.getPathInfo(req.getPathInfo(), req.getContextPath(), req.getRequestURI(), filterChain);
    }

    private static String getPathInfo(String pathInfo, String contextPath, String requestURI, FilterChain filterChain) {
        return HttpServletRequestAdaptor.getPathInfo(pathInfo, contextPath, requestURI, filterChain != null);
    }

    private static String getPathInfo(String pathInfo, String contextPath, String requestURI, boolean calledByFilter) {
        if (pathInfo != null) {
            return pathInfo;
        }
        if (!calledByFilter) {
            return null;
        }
        return requestURI.substring(contextPath.length(), requestURI.length());
    }

    public static String getDispatchServletPath(HttpServletRequest req) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            String servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
            return servletPath == null ? "" : servletPath;
        }
        return req.getServletPath();
    }

    public HttpSession getSession() {
        HttpSession session = super.getSession();
        if (session != null) {
            return new HttpSessionAdaptor(session, this.servlet);
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session != null) {
            return new HttpSessionAdaptor(session, this.servlet);
        }
        return null;
    }
}

