/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MJournal;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class CopyFromJournalDoc
extends SvrProcess {
    private int m_GL_Journal_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("GL_Journal_ID")) {
                    this.m_GL_Journal_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int To_GL_Journal_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - From GL_Journal_ID=" + this.m_GL_Journal_ID + " to " + To_GL_Journal_ID);
        }
        if (To_GL_Journal_ID == 0) {
            throw new IllegalArgumentException("Target GL_Journal_ID == 0");
        }
        if (this.m_GL_Journal_ID == 0) {
            throw new IllegalArgumentException("Source GL_Journal_ID == 0");
        }
        MJournal from = new MJournal(this.getCtx(), this.m_GL_Journal_ID, this.get_TrxName());
        MJournal to = new MJournal(this.getCtx(), To_GL_Journal_ID, this.get_TrxName());
        int no = to.copyLinesFrom(from, to.getDateAcct(), 'x');
        return "@Copied@=" + no;
    }
}

