/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.SheetAnchor;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.AuDataUtil;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.WidgetAction;
import io.keikai.ui.event.WidgetUpdateEvent;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class WidgetUpdateCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Map data = request.getData();
        if (data == null || data.size() != 12) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        String sheetId = (String)data.get("sheetId");
        if (!WidgetUpdateCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        String act = (String)data.get("action");
        WidgetAction action = null;
        if ("move".equals(act)) {
            action = WidgetAction.MOVE;
        } else if ("resize".equals(act)) {
            action = WidgetAction.RESIZE;
        } else {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        SheetAnchor anchor = this.getAnchor(data);
        if (anchor == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Object widgetData = this.getWidgetData(sheet, data);
        if (widgetData == null) {
            return;
        }
        WidgetUpdateEvent event = new WidgetUpdateEvent("onWidgetUpdate", comp, sheet, action, widgetData, anchor);
        Events.postEvent((Event)event);
    }

    private SheetAnchor getAnchor(Map data) {
        int dx1 = AuDataUtil.getInt(data, "dx1");
        int dy1 = AuDataUtil.getInt(data, "dy1");
        int dx2 = AuDataUtil.getInt(data, "dx2");
        int dy2 = AuDataUtil.getInt(data, "dy2");
        int col1 = (Integer)data.get("col1");
        int row1 = (Integer)data.get("row1");
        int col2 = (Integer)data.get("col2");
        int row2 = (Integer)data.get("row2");
        return new SheetAnchor(row1, col1, dx1, dy1, row2, col2, dx2, dy2);
    }

    private Object getWidgetData(Sheet sheet, Map data) {
        block3: {
            String widgetType;
            String id;
            block2: {
                id = (String)data.get("wgtId");
                widgetType = (String)data.get("wgtType");
                if (!"image".equals(widgetType)) break block2;
                for (Picture p : sheet.getPictures()) {
                    if (!p.getId().equals(id)) continue;
                    return p;
                }
                break block3;
            }
            if (!"chart".equals(widgetType)) break block3;
            for (Chart c : sheet.getCharts()) {
                if (!c.getId().equals(id)) continue;
                return c;
            }
        }
        return null;
    }
}

