/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.SheetOperationUtil;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractSheetHandler;

public class MoveSheetHandler
extends AbstractSheetHandler {
    private static final long serialVersionUID = 758336150863254712L;
    boolean _left;

    public MoveSheetHandler(boolean left) {
        this._left = left;
    }

    @Override
    public boolean isEnabled(Book book, Sheet sheet) {
        int sheetnum;
        if (book != null && sheet != null && (sheetnum = book.getNumberOfSheets()) > 1) {
            int index = book.getSheetIndex(sheet);
            if (index > 0 && this._left) {
                return true;
            }
            if (index < sheetnum - 1 && !this._left) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Book book = ctx.getBook();
        Sheet sheet = ctx.getSheet();
        int sheetnum = book.getNumberOfSheets();
        if (sheetnum > 1) {
            int index = book.getSheetIndex(sheet);
            if (index > 0 && this._left) {
                Range range = Ranges.range(sheet);
                SheetOperationUtil.setSheetOrder(range, index - 1);
            } else if (index < sheetnum - 1 && !this._left) {
                Range range = Ranges.range(sheet);
                SheetOperationUtil.setSheetOrder(range, index + 1);
            }
        }
        return true;
    }
}

