/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NonBlankCellsHelper
implements Serializable {
    private static final long serialVersionUID = 1651809355142266854L;
    int _defaultSize;
    private List<NonBlankCellInfo> _infos;

    public NonBlankCellsHelper(List<NonBlankCellInfo> infos) {
        this._infos = infos;
    }

    public List<NonBlankCellInfo> getInfos() {
        return new ArrayList<NonBlankCellInfo>(this._infos);
    }

    public boolean isNonBlank(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new NonBlankCellInfoComparator());
        return j >= 0 ? true : this._isNonBlank(-j - 1 - 1, cellIndex);
    }

    public int getNextNonBlank(int start) {
        int j = this.getListIndex(start);
        if (j < 0) {
            if ((j = -j - 1) >= this._infos.size()) {
                return -1;
            }
            NonBlankCellInfo info = this._infos.get(j);
            return info.start;
        }
        NonBlankCellInfo info = this._infos.get(j);
        if (start >= info.end) {
            if (++j >= this._infos.size()) {
                return -1;
            }
            info = this._infos.get(j);
            return info.start;
        }
        return info.end;
    }

    public int getPrevNonBlank(int start) {
        int j = this.getListIndex(start);
        if (j < 0) {
            if ((j = -j - 1 - 1) < 0) {
                return -1;
            }
            NonBlankCellInfo info = this._infos.get(j);
            return info.end;
        }
        NonBlankCellInfo info = this._infos.get(j);
        if (start <= info.start) {
            if (--j < 0) {
                return -1;
            }
            info = this._infos.get(j);
            return info.end;
        }
        return info.start;
    }

    private boolean _isNonBlank(int listIndex, int cellIndex) {
        if (listIndex < 0 || listIndex >= this._infos.size()) {
            return false;
        }
        NonBlankCellInfo info = this._infos.get(listIndex);
        return info.isNonBlank(cellIndex);
    }

    private int getListIndex(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new NonBlankCellInfoComparator());
        return j >= 0 || !this._isNonBlank(-j - 1 - 1, cellIndex) ? j : -j - 1 - 1;
    }

    public NonBlankCellInfo getInfo(int cellIndex) {
        int j = this.getListIndex(cellIndex);
        return j < 0 ? null : this._infos.get(j);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (NonBlankCellInfo info : this._infos) {
            sb.append("[");
            sb.append(info.start).append(", ");
            sb.append(info.end);
            sb.append("],");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class NonBlankCellInfoComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -1290415509269113184L;

        private NonBlankCellInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i1 = o1 instanceof NonBlankCellInfo ? ((NonBlankCellInfo)o1).start : (Integer)o1;
            int i2 = o2 instanceof NonBlankCellInfo ? ((NonBlankCellInfo)o2).start : (Integer)o2;
            return i1 - i2;
        }
    }

    public static class NonBlankCellInfo {
        public int start;
        public int end;

        public NonBlankCellInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void shift(int offset) {
            this.start += offset;
            this.end += offset;
        }

        public boolean isNonBlank(int cellIndex) {
            return this.start <= cellIndex && cellIndex <= this.end;
        }
    }
}

