/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui;

import io.keikai.model.EventQueueModelEventListener;
import io.keikai.model.ModelEvent;
import io.keikai.model.ModelEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public class ModelEventDispatcher
implements EventQueueModelEventListener {
    private static final long serialVersionUID = 1L;
    private Map<String, List<ModelEventListener>> _listeners = new HashMap<String, List<ModelEventListener>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ModelEvent event) {
        ReadWriteLock lock = event.getBook().getBookSeries().getLock();
        lock.writeLock().lock();
        try {
            String name = event.getName();
            List<ModelEventListener> list = this._listeners.get(name);
            if (list != null) {
                for (ModelEventListener listener : list) {
                    listener.onEvent(event);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public boolean addEventListener(String name, ModelEventListener listener) {
        List<ModelEventListener> list = this._listeners.get(name);
        if (list == null) {
            list = new ArrayList<ModelEventListener>(4);
            this._listeners.put(name, list);
        }
        return list.add(listener);
    }

    public boolean removeEventListener(String name, ModelEventListener listener) {
        List<ModelEventListener> list = this._listeners.get(name);
        return list != null ? list.remove(listener) : true;
    }
}

