/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;
import java.util.List;

public class MergeHelper
extends RangeHelperBase {
    public MergeHelper(SRange range) {
        super(range);
    }

    public void unmerge(boolean overlapped) {
        int tRow = this.getRow();
        int lCol = this.getColumn();
        int bRow = this.getLastRow();
        int rCol = this.getLastColumn();
        this.sheet.removeMergedRegion(new CellRegion(tRow, lCol, bRow, rCol), overlapped);
    }

    public void merge(boolean across) {
        int rCol;
        int bRow;
        int lCol;
        int tRow = this.range.getRow();
        List<CellRegion> overlaps = this.sheet.getOverlapsMergedRegions(new CellRegion(tRow, lCol = this.range.getColumn(), bRow = this.range.getLastRow(), rCol = this.range.getLastColumn()), false);
        if (overlaps.size() > 0) {
            this.unmerge(true);
        }
        if (across) {
            for (int r = tRow; r <= bRow; ++r) {
                this.merge0(this.sheet, r, lCol, r, rCol);
            }
        } else {
            this.merge0(this.sheet, tRow, lCol, bRow, rCol);
        }
    }

    private void setRowCustomHeight(SSheet sheet, int r) {
        int defaultHt;
        SRow row = sheet.getRow(r);
        int ht = row.getHeight();
        if (ht != (defaultHt = sheet.getDefaultRowHeight())) {
            row.setCustomHeight(true);
        }
    }

    private void merge0(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        if (tRow == bRow && lCol == rCol) {
            return;
        }
        SCell target = null;
        block0: for (int r = tRow; target == null && r <= bRow; ++r) {
            for (int c = lCol; c <= rCol; ++c) {
                SCell cell = sheet.getCell(r, c);
                if (MergeHelper.isBlank(cell)) continue;
                target = cell;
                continue block0;
            }
        }
        SCellStyle style = null;
        if (target != null) {
            SCellStyle source;
            int tgtRow = target.getRowIndex();
            int tgtCol = target.getColumnIndex();
            int nRow = tRow - tgtRow;
            int nCol = lCol - tgtCol;
            if (nRow != 0 || nCol != 0) {
                sheet.moveCell(tgtRow, tgtCol, tgtRow, tgtCol, nRow, nCol);
            }
            SCellStyle sCellStyle = style = (source = target.getCellStyle()).equals(sheet.getBook().getDefaultCellStyle()) ? null : sheet.getBook().createCellStyle(source, true);
            if (style != null) {
                style.setBorderLeft(SBorder.BorderType.NONE);
                style.setBorderTop(SBorder.BorderType.NONE);
                style.setBorderRight(SBorder.BorderType.NONE);
                style.setBorderBottom(SBorder.BorderType.NONE);
                target.setCellStyle(style);
            }
            this.setRowCustomHeight(sheet, tRow);
            for (int c = lCol + 1; c <= rCol; ++c) {
                SCell cell = sheet.getCell(tRow, c);
                cell.setCellStyle(style);
                cell.setValue(null);
            }
            for (int r = tRow + 1; r <= bRow; ++r) {
                for (int c = lCol; c <= rCol; ++c) {
                    SCell cell = sheet.getCell(r, c);
                    cell.setCellStyle(style);
                    cell.setValue(null);
                }
                this.setRowCustomHeight(sheet, r);
            }
        }
        CellRegion mergeArea = new CellRegion(tRow, lCol, bRow, rCol);
        sheet.addMergedRegion(mergeArea);
    }
}

