/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.Tag;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.utils.PortRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class AwsConfig {
    private final String region;
    private final String hostHeader;
    private final String securityGroupName;
    private final List<Tag> tags;
    private final int connectionTimeoutSeconds;
    private final int connectionRetries;
    private final int readTimeoutSeconds;
    private final PortRange hzPort;
    private final String accessKey;
    private final String secretKey;
    private final String iamRole;
    private final String cluster;
    private final String family;
    private final String serviceName;
    private final DiscoveryMode discoveryMode;

    private AwsConfig(String accessKey, String secretKey, String region, String iamRole, String hostHeader, String securityGroupName, String tagKey, String tagValue, int connectionTimeoutSeconds, int connectionRetries, int readTimeoutSeconds, PortRange hzPort, String cluster, String family, String serviceName, DiscoveryMode discoveryMode) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.iamRole = iamRole;
        this.hostHeader = hostHeader;
        this.securityGroupName = securityGroupName;
        this.tags = this.createTags(tagKey, tagValue);
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.connectionRetries = connectionRetries;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.hzPort = hzPort;
        this.cluster = cluster;
        this.family = family;
        this.serviceName = serviceName;
        this.discoveryMode = discoveryMode;
        this.validateConfig();
    }

    private List<Tag> createTags(String tagKeys, String tagValues) {
        Iterator<String> keys = AwsConfig.splitValue(tagKeys).iterator();
        Iterator<String> values = AwsConfig.splitValue(tagValues).iterator();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (keys.hasNext() || values.hasNext()) {
            if (keys.hasNext() && values.hasNext()) {
                tags.add(new Tag(keys.next(), values.next()));
                continue;
            }
            if (keys.hasNext()) {
                tags.add(new Tag(keys.next(), null));
                continue;
            }
            tags.add(new Tag(null, values.next()));
        }
        return tags;
    }

    private static List<String> splitValue(String value) {
        return StringUtil.isNullOrEmptyAfterTrim(value) ? Collections.emptyList() : Arrays.asList(value.split(","));
    }

    private void validateConfig() {
        if (this.anyOfEc2PropertiesConfigured() && this.anyOfEcsPropertiesConfigured()) {
            throw new InvalidConfigurationException("You have to configure either EC2 properties ('iam-role', 'security-group-name') or ECS properties ('cluster', 'family', 'service-name'). You cannot define both of them");
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.family) && !StringUtil.isNullOrEmptyAfterTrim(this.serviceName)) {
            throw new InvalidConfigurationException("You cannot configure ECS discovery with both 'family' and 'service-name', these filters are mutually exclusive");
        }
        if (!(StringUtil.isNullOrEmptyAfterTrim(this.iamRole) || StringUtil.isNullOrEmptyAfterTrim(this.accessKey) && StringUtil.isNullOrEmptyAfterTrim(this.secretKey))) {
            throw new InvalidConfigurationException("You cannot define both 'iam-role' and 'access-key'/'secret-key'. Choose how you want to authenticate with AWS API, either with IAM Role or with hardcoded AWS Credentials");
        }
        if (StringUtil.isNullOrEmptyAfterTrim(this.accessKey) && !StringUtil.isNullOrEmptyAfterTrim(this.secretKey) || !StringUtil.isNullOrEmptyAfterTrim(this.accessKey) && StringUtil.isNullOrEmptyAfterTrim(this.secretKey)) {
            throw new InvalidConfigurationException("You have to either define both ('access-key', 'secret-key') or none of them");
        }
    }

    boolean anyOfEc2PropertiesConfigured() {
        return !StringUtil.isNullOrEmptyAfterTrim(this.iamRole) || !StringUtil.isNullOrEmptyAfterTrim(this.securityGroupName);
    }

    boolean anyOfEcsPropertiesConfigured() {
        return !StringUtil.isNullOrEmptyAfterTrim(this.cluster) || !StringUtil.isNullOrEmptyAfterTrim(this.family) || !StringUtil.isNullOrEmptyAfterTrim(this.serviceName);
    }

    static Builder builder() {
        return new Builder();
    }

    String getAccessKey() {
        return this.accessKey;
    }

    String getSecretKey() {
        return this.secretKey;
    }

    String getRegion() {
        return this.region;
    }

    String getIamRole() {
        return this.iamRole;
    }

    String getHostHeader() {
        return this.hostHeader;
    }

    String getSecurityGroupName() {
        return this.securityGroupName;
    }

    List<Tag> getTags() {
        return this.tags;
    }

    int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    int getConnectionRetries() {
        return this.connectionRetries;
    }

    int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    PortRange getHzPort() {
        return this.hzPort;
    }

    String getCluster() {
        return this.cluster;
    }

    String getFamily() {
        return this.family;
    }

    String getServiceName() {
        return this.serviceName;
    }

    public DiscoveryMode getDiscoveryMode() {
        return this.discoveryMode;
    }

    public String toString() {
        return "AwsConfig{accessKey='***', secretKey='***', iamRole='" + this.iamRole + '\'' + ", region='" + this.region + '\'' + ", hostHeader='" + this.hostHeader + '\'' + ", securityGroupName='" + this.securityGroupName + '\'' + ", tags='" + this.tags + '\'' + ", hzPort=" + this.hzPort + ", cluster='" + this.cluster + '\'' + ", family='" + this.family + '\'' + ", serviceName='" + this.serviceName + '\'' + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", connectionRetries=" + this.connectionRetries + ", readTimeoutSeconds=" + this.readTimeoutSeconds + ", discoveryMode=" + (Object)((Object)this.discoveryMode) + '}';
    }

    static class Builder {
        private String accessKey;
        private String secretKey;
        private String region;
        private String iamRole;
        private String hostHeader;
        private String securityGroupName;
        private String tagKey;
        private String tagValue;
        private int connectionTimeoutSeconds;
        private int connectionRetries;
        private int readTimeoutSeconds;
        private PortRange hzPort;
        private String cluster;
        private String family;
        private String serviceName;
        private DiscoveryMode discoveryMode;

        Builder() {
        }

        Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        Builder setIamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        Builder setHostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        Builder setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
            return this;
        }

        Builder setTagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        Builder setTagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        Builder setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        Builder setConnectionRetries(int connectionRetries) {
            this.connectionRetries = connectionRetries;
            return this;
        }

        Builder setReadTimeoutSeconds(int readTimeoutSeconds) {
            this.readTimeoutSeconds = readTimeoutSeconds;
            return this;
        }

        Builder setHzPort(PortRange hzPort) {
            this.hzPort = hzPort;
            return this;
        }

        Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        Builder setFamily(String family) {
            this.family = family;
            return this;
        }

        Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        Builder setDiscoveryMode(DiscoveryMode discoveryMode) {
            this.discoveryMode = discoveryMode;
            return this;
        }

        AwsConfig build() {
            return new AwsConfig(this.accessKey, this.secretKey, this.region, this.iamRole, this.hostHeader, this.securityGroupName, this.tagKey, this.tagValue, this.connectionTimeoutSeconds, this.connectionRetries, this.readTimeoutSeconds, this.hzPort, this.cluster, this.family, this.serviceName, this.discoveryMode);
        }
    }
}

