/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.management.ScriptEngineManagerContext;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.security.AccessControlException;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class RunScriptOperation
extends AbstractLocalOperation {
    private final String engine;
    private final String script;

    public RunScriptOperation(String engine, String script) {
        this.engine = engine;
        this.script = script;
    }

    @Override
    public void run() {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        Future<Object> future = executionService.submit("hz:mc", () -> {
            ManagementCenterConfig managementCenterConfig = this.getNodeEngine().getConfig().getManagementCenterConfig();
            if (!managementCenterConfig.isScriptingEnabled()) {
                throw new AccessControlException("Using ScriptEngine is not allowed on this Hazelcast member.");
            }
            ScriptEngineManager scriptEngineManager = ScriptEngineManagerContext.getScriptEngineManager();
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(this.engine);
            if (scriptEngine == null) {
                throw new IllegalArgumentException("Could not find ScriptEngine named '" + this.engine + "'. Please add the corresponding ScriptEngine to the classpath of this Hazelcast member");
            }
            scriptEngine.put("hazelcast", this.getNodeEngine().getHazelcastInstance());
            try {
                return scriptEngine.eval(this.script);
            }
            catch (ScriptException e) {
                HazelcastException hazelcastException = new HazelcastException(e.getMessage());
                hazelcastException.setStackTrace(e.getStackTrace());
                throw hazelcastException;
            }
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (result, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : result)), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

