/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.client.impl.management.ClientConnectionProcessListenerRunner;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;

public class DefaultAddressProvider
implements AddressProvider {
    private static final EndpointQualifier CLIENT_PUBLIC_ENDPOINT_QUALIFIER = EndpointQualifier.resolve(ProtocolType.CLIENT, "public");
    private final ClientNetworkConfig networkConfig;
    private final BooleanSupplier translateToPublicAddressSupplier;

    public DefaultAddressProvider(ClientNetworkConfig networkConfig, BooleanSupplier translateToPublicAddressSupplier) {
        this.networkConfig = networkConfig;
        this.translateToPublicAddressSupplier = translateToPublicAddressSupplier;
    }

    @Override
    public Addresses loadAddresses(ClientConnectionProcessListenerRunner listenerRunner) {
        List<String> configuredAddresses = this.networkConfig.getAddresses();
        if (configuredAddresses.isEmpty()) {
            configuredAddresses.add("127.0.0.1");
        }
        Addresses addresses = new Addresses();
        ArrayList<Address> allAddresses = new ArrayList<Address>();
        for (String address : configuredAddresses) {
            Addresses socketAddresses = AddressHelper.getSocketAddresses(address, listenerRunner);
            addresses.addAll(socketAddresses);
        }
        allAddresses.addAll(addresses.primary());
        allAddresses.addAll(addresses.secondary());
        listenerRunner.onPossibleAddressesCollected((List<Address>)allAddresses);
        return addresses;
    }

    @Override
    public Address translate(Address address) {
        return address;
    }

    @Override
    public Address translate(Member member) {
        Address publicAddress;
        if (this.translateToPublicAddressSupplier.getAsBoolean() && (publicAddress = member.getAddressMap().get(CLIENT_PUBLIC_ENDPOINT_QUALIFIER)) != null) {
            return publicAddress;
        }
        return member.getAddress();
    }
}

