/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.WReport;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.WGraph;
import org.adempiere.webui.apps.graph.WPAWidget;
import org.adempiere.webui.apps.graph.WPerformanceDetail;
import org.adempiere.webui.apps.graph.WPerformanceIndicator;
import org.adempiere.webui.apps.graph.model.ChartModel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.dashboard.DashboardRunnable;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.ZoomEvent;
import org.adempiere.webui.report.HTMLExtension;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.util.ZkContextRunnable;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.ZkReportViewerProvider;
import org.compiere.Adempiere;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MChart;
import org.compiere.model.MDashboardContent;
import org.compiere.model.MDashboardContentAccess;
import org.compiere.model.MDashboardPreference;
import org.compiere.model.MGoal;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStatusLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.json.JSONArray;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Anchorchildren;
import org.zkoss.zul.Anchorlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Html;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Include;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vlayout;

public class DashboardController
implements EventListener<Event> {
    private static final CLogger logger = CLogger.getCLogger(DashboardController.class);
    private Component prevParent;
    private Component prevNext;
    private List<Panel> panelList = new ArrayList<Panel>();
    private List<Anchorchildren> columnList;
    private List<Anchorchildren> rowList;
    private Anchorlayout dashboardLayout = new Anchorlayout();
    private Anchorchildren maximizedHolder;
    private DashboardRunnable dashboardRunnable;
    private Timer dashboardTimer;
    private boolean isShowInDashboard;
    private int noOfCols;
    private static final String PANEL_EMPTY_ATTRIBUTE = "panel.empty";
    private static final String COLUMN_NO_ATTRIBUTE = "ColumnNo";
    private static final String LINE_ATTRIBUTE = "Line";
    private static final String IS_ADDITIONAL_ROW_ATTRIBUTE = "IsAdditionalRow";
    private static final String IS_ADDITIONAL_COLUMN_ATTRIBUTE = "IsAdditionalColumn";
    private static final String IS_SHOW_IN_DASHBOARD_ATTRIBUTE = "IsShowInDashboard";
    private static final String FLEX_GROW_ATTRIBUTE = "FlexGrow";
    private static final String IMAGES_CONTEXT_HELP_PNG = "images/Help16.png";
    private static final int DEFAULT_DASHBOARD_WIDTH = 99;
    private static final String DASHBOARD_LAYOUT_COLUMNS = "C";
    private static final String DASHBOARD_LAYOUT_ROWS = "R";
    private static final int MAX_NO_OF_PREFS_IN_ROW = 10;
    private static final int DEFAULT_FLEX_GROW = 1;

    public DashboardController() {
        this.dashboardLayout.setSclass("dashboard-layout");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.dashboardLayout, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.dashboardLayout, "1");
        this.maximizedHolder = new Anchorchildren();
        this.maximizedHolder.setAnchor("100% 100%");
        this.maximizedHolder.setStyle("overflow: hidden; border: none; margin: 0; padding: 0;");
    }

    public void render(Component parent, IDesktop desktopImpl, boolean isShowInDashboard) {
        String layoutOrientation = MSysConfig.getValue((String)"DASHBOARD_LAYOUT_ORIENTATION", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS) && isShowInDashboard) {
            this.renderRows(parent, desktopImpl, isShowInDashboard, false);
        } else {
            this.renderColumns(parent, desktopImpl, isShowInDashboard, false);
        }
    }

    protected void renderColumns(Component parent, IDesktop desktopImpl, boolean isShowInDashboard, boolean update) {
        this.isShowInDashboard = isShowInDashboard;
        if (!update) {
            parent.appendChild((Component)this.dashboardLayout);
        }
        if (!update && isShowInDashboard) {
            ((HtmlBasedComponent)parent).setStyle("overflow-x: auto;");
        }
        this.dashboardLayout.getChildren().clear();
        if (!this.dashboardLayout.getDesktop().isServerPushEnabled()) {
            this.dashboardLayout.getDesktop().enableServerPush(true);
        }
        if (!update) {
            this.dashboardRunnable = new DashboardRunnable(parent.getDesktop());
        }
        this.columnList = new ArrayList<Anchorchildren>();
        Vlayout dashboardColumnLayout = null;
        int currentColumnNo = 0;
        int noOfCols = 0;
        int width = 0;
        try {
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
            MDashboardPreference[] dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)true);
            MDashboardContent[] dcs = MDashboardContentAccess.get((Properties)Env.getCtx(), (int)AD_Role_ID, (int)AD_User_ID, null);
            if (dps.length == 0) {
                this.createDashboardPreference(AD_User_ID, AD_Role_ID);
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)true);
            } else if (this.updatePreferences(dps, dcs, Env.getCtx())) {
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)true);
            }
            noOfCols = MDashboardPreference.getForSessionColumnCount((boolean)isShowInDashboard, (int)AD_User_ID, (int)AD_Role_ID);
            if (ClientInfo.isMobile() && isShowInDashboard && ClientInfo.maxWidth(999)) {
                if (ClientInfo.maxWidth(699)) {
                    noOfCols = 1;
                } else if (noOfCols > 2) {
                    noOfCols = 2;
                }
            }
            this.noOfCols = noOfCols;
            int dashboardWidth = isShowInDashboard ? 99 : 100;
            width = noOfCols <= 0 ? dashboardWidth : dashboardWidth / noOfCols;
            int extraWidth = 100 - (noOfCols <= 0 ? dashboardWidth : width * noOfCols) - (100 - dashboardWidth - 1);
            MDashboardPreference[] mDashboardPreferenceArray = dps;
            int n = dps.length;
            int n2 = 0;
            while (n2 < n) {
                MDashboardPreference dp = mDashboardPreferenceArray[n2];
                if (dp.isActive() && dp.isShowInDashboard() == isShowInDashboard) {
                    final MDashboardContent dc = new MDashboardContent(dp.getCtx(), dp.getPA_DashboardContent_ID(), dp.get_TrxName());
                    int columnNo = dp.getColumnNo();
                    int effColumn = columnNo;
                    if (effColumn + 1 > noOfCols) {
                        effColumn = noOfCols - 1;
                    }
                    if (dashboardColumnLayout == null || currentColumnNo != effColumn) {
                        dashboardColumnLayout = new Vlayout();
                        dashboardColumnLayout.setSclass("dashboard-column");
                        dashboardColumnLayout.setAttribute(COLUMN_NO_ATTRIBUTE, (Object)columnNo);
                        dashboardColumnLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                        dashboardColumnLayout.setAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE, (Object)false);
                        Anchorchildren dashboardColumn = new Anchorchildren();
                        dashboardColumn.setAnchor(width + "% 100%");
                        if (!ClientInfo.isMobile()) {
                            dashboardColumn.setDroppable("true");
                            dashboardColumn.addEventListener("onDrop", (EventListener)this);
                        }
                        dashboardColumn.appendChild((Component)dashboardColumnLayout);
                        this.columnList.add(dashboardColumn);
                        this.dashboardLayout.appendChild((Component)dashboardColumn);
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardColumnLayout, "1");
                        currentColumnNo = effColumn;
                    }
                    Panel panel = null;
                    panel = update ? this.findPanel(dp.getPA_DashboardContent_ID(), dp.getPA_DashboardPreference_ID()) : this.newGadgetPanel(dp, dc);
                    if (panel != null && panel.getAttribute(PANEL_EMPTY_ATTRIBUTE) == null) {
                        dashboardColumnLayout.appendChild((Component)panel);
                    }
                    if (!update) {
                        final Panel fp = panel;
                        final ServerPushTemplate spt = new ServerPushTemplate(this.dashboardLayout.getDesktop());
                        final String contextPath = Executions.getCurrent().getContextPath();
                        final Panelchildren panelChildren = new Panelchildren();
                        fp.appendChild((Component)panelChildren);
                        BusyDialog busyDialog = new BusyDialog();
                        busyDialog.setShadow(false);
                        panelChildren.appendChild((Component)busyDialog);
                        Component zComponent = null;
                        if (!Util.isEmpty((String)dc.getZulFilePath(), (boolean)true)) {
                            try {
                                zComponent = Extensions.getDashboardGadget(dc.getZulFilePath(), (Component)panelChildren, dc);
                            }
                            catch (Exception e) {
                                throw new AdempiereException((Throwable)e);
                            }
                        }
                        final Component zulComponent = zComponent;
                        ZkContextRunnable cr = new ZkContextRunnable(){

                            protected void doRun() {
                                try {
                                    DashboardController.this.asyncRenderGadgetPanel(spt, dc, fp, contextPath, panelChildren, zulComponent);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        Adempiere.getThreadPoolExecutor().submit((Runnable)((Object)cr));
                    }
                }
                ++n2;
            }
            if (dps.length == 0) {
                dashboardColumnLayout = new Vlayout();
                dashboardColumnLayout.setAttribute(COLUMN_NO_ATTRIBUTE, (Object)"0");
                dashboardColumnLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                dashboardColumnLayout.setAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE, (Object)true);
                dashboardColumn = new Anchorchildren();
                dashboardColumn.setAnchor(width - 5 + "% 100%");
                if (!ClientInfo.isMobile()) {
                    dashboardColumn.setDroppable("true");
                    dashboardColumn.addEventListener("onDrop", (EventListener)this);
                }
                dashboardColumn.appendChild((Component)dashboardColumnLayout);
                this.columnList.add(dashboardColumn);
                this.dashboardLayout.appendChild((Component)dashboardColumn);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
            } else if (isShowInDashboard) {
                dashboardColumnLayout = new Vlayout();
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
                dashboardColumnLayout.setAttribute(COLUMN_NO_ATTRIBUTE, (Object)(currentColumnNo + 1));
                dashboardColumnLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                dashboardColumnLayout.setAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE, (Object)true);
                dashboardColumn = new Anchorchildren();
                dashboardColumn.setAnchor(extraWidth + "% 100%");
                if (!ClientInfo.isMobile()) {
                    dashboardColumn.setDroppable("true");
                    dashboardColumn.addEventListener("onDrop", (EventListener)this);
                }
                dashboardColumn.appendChild((Component)dashboardColumnLayout);
                this.columnList.add(dashboardColumn);
                this.dashboardLayout.appendChild((Component)dashboardColumn);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create dashboard content", (Throwable)e);
        }
        if (!update) {
            this.startDashboardRunnable(parent);
        }
    }

    private Panel newGadgetPanel(MDashboardPreference dp, MDashboardContent dc) {
        Panel panel = new Panel();
        String dcName = dc.get_Translation("Name");
        Caption caption = new Caption(dcName);
        panel.appendChild((Component)caption);
        panel.setAttribute("PA_DashboardContent_ID", (Object)dp.getPA_DashboardContent_ID());
        panel.setAttribute("PA_DashboardPreference_ID", (Object)dp.getPA_DashboardPreference_ID());
        this.panelList.add(panel);
        panel.addEventListener("onMaximize", (EventListener)this);
        panel.setSclass("dashboard-widget");
        panel.setMaximizable(dc.isMaximizable());
        String description = dc.get_Translation("Description");
        if (!Util.isEmpty((String)description, (boolean)true) && !description.equalsIgnoreCase(dcName)) {
            this.renderHelpButton(caption, description);
        }
        panel.setCollapsible(dc.isCollapsible());
        panel.setOpen(!dp.isCollapsedByDefault());
        panel.addEventListener("onOpen", (EventListener)this);
        if (!ClientInfo.isMobile()) {
            panel.setDroppable("true");
            panel.getCaption().setDraggable("true");
            panel.addEventListener("onDrop", (EventListener)this);
        }
        panel.setBorder("normal");
        return panel;
    }

    private void renderHelpButton(Caption caption, String text) {
        A icon = new A();
        icon.setSclass("dashboard-content-help-icon");
        if (ThemeManager.isUseFontIconForImage()) {
            icon.setIconSclass("z-icon-Help");
        } else {
            icon.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_HELP_PNG));
        }
        caption.appendChild((Component)icon);
        Div popup = new Div();
        Text t = new Text(text);
        popup.setSclass("dashboard-content-help-popup");
        popup.appendChild((Component)t);
        caption.appendChild((Component)popup);
    }

    private void asyncRenderGadgetPanel(ServerPushTemplate spt, MDashboardContent dashboardContent, Panel panel, String contextPath, Panelchildren panelChildren, Component zulComponent) throws Exception {
        ArrayList<Component> components = new ArrayList<Component>();
        this.asyncRenderComponents(dashboardContent, this.dashboardRunnable, contextPath, (HtmlBasedComponent)panelChildren, components, zulComponent, spt);
        if (components.size() > 0) {
            for (Component c : components) {
                DashboardPanel dpanel;
                if (c.getParent() != panelChildren) {
                    spt.executeAsync(() -> {
                        boolean bl = panelChildren.appendChild(c);
                    });
                }
                if (!(c instanceof DashboardPanel) || !(dpanel = (DashboardPanel)c).isLazy()) continue;
                try {
                    dpanel.refresh(spt);
                    if (!dpanel.isEmpty()) continue;
                    spt.executeAsync(() -> {
                        panel.detach();
                        panel.setAttribute(PANEL_EMPTY_ATTRIBUTE, (Object)Boolean.TRUE);
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
            spt.executeAsync(() -> {
                if (panelChildren.getFirstChild() != null && panelChildren.getFirstChild() instanceof BusyDialog) {
                    panelChildren.getFirstChild().detach();
                }
            });
        } else {
            spt.executeAsync(() -> {
                panel.detach();
                panel.setAttribute(PANEL_EMPTY_ATTRIBUTE, (Object)Boolean.TRUE);
            });
        }
    }

    private void startDashboardRunnable(Component parent) {
        int interval = MSysConfig.getIntValue((String)"ZK_DASHBOARD_REFRESH_INTERVAL", (int)60000);
        this.dashboardTimer = new Timer();
        this.dashboardTimer.setDelay(interval);
        this.dashboardTimer.setRepeats(true);
        this.dashboardTimer.addEventListener("onTimer", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (DashboardController.this.dashboardRunnable != null && !DashboardController.this.dashboardRunnable.isEmpty()) {
                    DashboardController.this.dashboardRunnable.run();
                }
            }
        });
        this.dashboardTimer.setPage(parent.getPage());
    }

    protected void renderRows(Component parent, IDesktop desktopImpl, boolean isShowInDashboard, boolean update) {
        this.isShowInDashboard = isShowInDashboard;
        if (!update) {
            parent.appendChild((Component)this.dashboardLayout);
        }
        if (!update && isShowInDashboard) {
            ((HtmlBasedComponent)parent).setStyle("overflow-x: auto;");
        }
        this.dashboardLayout.getChildren().clear();
        if (!this.dashboardLayout.getDesktop().isServerPushEnabled()) {
            this.dashboardLayout.getDesktop().enableServerPush(true);
        }
        if (!update) {
            this.dashboardRunnable = new DashboardRunnable(parent.getDesktop());
        }
        this.rowList = new ArrayList<Anchorchildren>();
        Hlayout dashboardLineLayout = null;
        int currentLineNo = 0;
        int noOfLines = 0;
        int width = 100;
        try {
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
            MDashboardPreference[] dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)false);
            MDashboardContent[] dcs = MDashboardContentAccess.get((Properties)Env.getCtx(), (int)AD_Role_ID, (int)AD_User_ID, null);
            if (dps.length == 0) {
                this.createDashboardPreference(AD_User_ID, AD_Role_ID);
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)false);
            } else if (this.updatePreferences(dps, dcs, Env.getCtx())) {
                dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID, (boolean)false);
            }
            noOfLines = MDashboardPreference.getForSessionRowCount((boolean)isShowInDashboard, (int)AD_User_ID, (int)AD_Role_ID);
            if (ClientInfo.isMobile() && isShowInDashboard && ClientInfo.maxWidth(999)) {
                if (ClientInfo.maxWidth(699)) {
                    noOfLines = 1;
                } else if (noOfLines > 2) {
                    noOfLines = 2;
                }
            }
            MDashboardPreference[] mDashboardPreferenceArray = dps;
            int n = dps.length;
            int n2 = 0;
            while (n2 < n) {
                MDashboardPreference dp = mDashboardPreferenceArray[n2];
                if (dp.isActive() && dp.isShowInDashboard() == isShowInDashboard) {
                    final MDashboardContent dc = new MDashboardContent(dp.getCtx(), dp.getPA_DashboardContent_ID(), dp.get_TrxName());
                    int lineNo = dp.getLine().intValue();
                    int flexGrow = dp.getFlexGrow();
                    int n3 = flexGrow = flexGrow > 0 ? flexGrow : 1;
                    if (dashboardLineLayout == null || currentLineNo != lineNo) {
                        dashboardLineLayout = new Hlayout();
                        dashboardLineLayout.setAttribute(LINE_ATTRIBUTE, (Object)lineNo);
                        dashboardLineLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                        dashboardLineLayout.setAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE, (Object)false);
                        dashboardLineLayout.setSclass("dashboard-row");
                        Anchorchildren dashboardLine = new Anchorchildren();
                        dashboardLine.setAnchor(width + "%");
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardLine, "min");
                        if (!ClientInfo.isMobile()) {
                            dashboardLine.setDroppable("true");
                            dashboardLine.addEventListener("onDrop", (EventListener)this);
                        }
                        dashboardLine.appendChild((Component)dashboardLineLayout);
                        this.rowList.add(dashboardLine);
                        this.dashboardLayout.appendChild((Component)dashboardLine);
                        currentLineNo = lineNo;
                    }
                    Panel panel = null;
                    if (update) {
                        panel = this.findPanel(dp.getPA_DashboardContent_ID(), dp.getPA_DashboardPreference_ID());
                    } else {
                        panel = this.newGadgetPanel(dp, dc);
                        panel.setAttribute(FLEX_GROW_ATTRIBUTE, (Object)String.valueOf(flexGrow));
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)panel, String.valueOf(flexGrow));
                    }
                    if (panel != null && panel.getAttribute(PANEL_EMPTY_ATTRIBUTE) == null) {
                        dashboardLineLayout.appendChild((Component)panel);
                    }
                    if (!update) {
                        final Panel fp = panel;
                        final ServerPushTemplate spt = new ServerPushTemplate(this.dashboardLayout.getDesktop());
                        final String contextPath = Executions.getCurrent().getContextPath();
                        final Panelchildren panelChildren = new Panelchildren();
                        fp.appendChild((Component)panelChildren);
                        BusyDialog busyDialog = new BusyDialog();
                        busyDialog.setShadow(false);
                        panelChildren.appendChild((Component)busyDialog);
                        Component zComponent = null;
                        if (!Util.isEmpty((String)dc.getZulFilePath(), (boolean)true)) {
                            try {
                                zComponent = Extensions.getDashboardGadget(dc.getZulFilePath(), (Component)panelChildren, dc);
                            }
                            catch (Exception e) {
                                throw new AdempiereException((Throwable)e);
                            }
                        }
                        final Component zulComponent = zComponent;
                        ZkContextRunnable cr = new ZkContextRunnable(){

                            protected void doRun() {
                                try {
                                    DashboardController.this.asyncRenderGadgetPanel(spt, dc, fp, contextPath, panelChildren, zulComponent);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        Adempiere.getThreadPoolExecutor().submit((Runnable)((Object)cr));
                    }
                }
                ++n2;
            }
            if (dps.length == 0) {
                dashboardLineLayout = new Hlayout();
                dashboardLineLayout.setAttribute(LINE_ATTRIBUTE, (Object)"0");
                dashboardLineLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                dashboardLineLayout.setAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE, (Object)true);
                dashboardLineLayout.setSclass("dashboard-row");
                Anchorchildren dashboardColumn = new Anchorchildren();
                dashboardColumn.setAnchor(width - 5 + "% 100%");
                if (!ClientInfo.isMobile()) {
                    dashboardColumn.setDroppable("true");
                    dashboardColumn.addEventListener("onDrop", (EventListener)this);
                }
                dashboardColumn.appendChild((Component)dashboardLineLayout);
                this.rowList.add(dashboardColumn);
                this.dashboardLayout.appendChild((Component)dashboardColumn);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardLineLayout, "100%");
            } else if (isShowInDashboard) {
                dashboardLineLayout = new Hlayout();
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardLineLayout, "100%");
                dashboardLineLayout.setAttribute(LINE_ATTRIBUTE, (Object)(currentLineNo + 1));
                dashboardLineLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                dashboardLineLayout.setAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE, (Object)true);
                dashboardLineLayout.setSclass("dashboard-row");
                Anchorchildren dashboardLine = new Anchorchildren();
                dashboardLine.setAnchor(width + "% 1%");
                ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardLine, "min");
                if (!ClientInfo.isMobile()) {
                    dashboardLine.setDroppable("true");
                    dashboardLine.addEventListener("onDrop", (EventListener)this);
                }
                dashboardLine.appendChild((Component)dashboardLineLayout);
                this.rowList.add(dashboardLine);
                this.dashboardLayout.appendChild((Component)dashboardLine);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardLineLayout, "100%");
                ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardLineLayout, "1");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create dashboard content", (Throwable)e);
        }
        if (!update) {
            this.startDashboardRunnable(parent);
        }
    }

    private Panel findPanel(int PA_DashboardContent_ID, int PA_DashboardPreference_ID) {
        for (Panel panel : this.panelList) {
            Object value1 = panel.getAttribute("PA_DashboardContent_ID");
            Object value2 = panel.getAttribute("PA_DashboardPreference_ID");
            if (value1 == null || !(value1 instanceof Number) || value2 == null || !(value2 instanceof Number)) continue;
            int id1 = ((Number)value1).intValue();
            int id2 = ((Number)value2).intValue();
            if (id1 != PA_DashboardContent_ID || id2 != PA_DashboardPreference_ID) continue;
            return panel;
        }
        return null;
    }

    private void asyncRenderComponents(final MDashboardContent dashboardContent, DashboardRunnable dashboardRunnable, String contextPath, HtmlBasedComponent parentComponent, List<Component> components, Component zulComponent, ServerPushTemplate spt) throws Exception {
        int AD_StatusLine_ID;
        int AD_Chart_ID;
        int PA_Goal_ID;
        int AD_Process_ID;
        int AD_Window_ID;
        String htmlContent;
        String string = htmlContent = dashboardContent.get_ID() > 0 ? dashboardContent.get_Translation("HTML") : null;
        if (!Util.isEmpty((String)htmlContent)) {
            StringBuilder result;
            block41: {
                result = new StringBuilder("<html><head>");
                URL url = this.getClass().getClassLoader().getResource("org/compiere/css/PAPanel.css");
                BufferedReader bufferedReader = null;
                try {
                    try {
                        String cssLine;
                        InputStreamReader ins = new InputStreamReader(url.openStream());
                        bufferedReader = new BufferedReader(ins);
                        result.append("<style type=\"text/css\">");
                        while ((cssLine = bufferedReader.readLine()) != null) {
                            result.append(cssLine + "\n");
                        }
                        result.append("</style>");
                    }
                    catch (Exception e1) {
                        logger.log(Level.SEVERE, e1.getLocalizedMessage(), (Throwable)e1);
                        if (bufferedReader == null) break block41;
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                        bufferedReader = null;
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                        bufferedReader = null;
                    }
                    throw throwable;
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                    bufferedReader = null;
                }
            }
            result.append("</head><body><div class=\"content\">\n");
            result.append(this.stripHtml(htmlContent, false) + "<br>\n");
            result.append("</div>\n</body>\n</html>");
            Html html = new Html();
            html.setContent(result.toString());
            components.add((Component)html);
        }
        if ((AD_Window_ID = dashboardContent.getAD_Window_ID()) > 0) {
            int AD_Menu_ID = dashboardContent.getAD_Menu_ID();
            Div div = new Div();
            ToolBarButton btn = new ToolBarButton(String.valueOf(AD_Menu_ID));
            I_AD_Menu menu = dashboardContent.getAD_Menu();
            btn.setLabel(menu.getName());
            btn.setAttribute("AD_Menu_ID", AD_Menu_ID);
            btn.addEventListener("onClick", this);
            div.appendChild((Component)btn);
            components.add((Component)div);
        }
        if ((AD_Process_ID = dashboardContent.getAD_Process_ID()) > 0) {
            int thisClientId;
            boolean systemAccess = false;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)AD_Process_ID);
            String accessLevel = process.getAccessLevel();
            if ("7".equals(accessLevel) || "4".equals(accessLevel) || "6".equals(accessLevel)) {
                systemAccess = true;
            }
            if ((thisClientId = Env.getAD_Client_ID((Properties)Env.getCtx())) == 0 && systemAccess || thisClientId != 0) {
                String sql = "SELECT AD_Menu_ID FROM AD_Menu WHERE AD_Process_ID=?";
                int AD_Menu_ID = DB.getSQLValueEx(null, (String)sql, (Object[])new Object[]{AD_Process_ID});
                ToolBarButton btn = new ToolBarButton();
                MMenu menu = new MMenu(Env.getCtx(), AD_Menu_ID, null);
                btn.setAttribute("AD_Menu_ID", AD_Menu_ID);
                btn.addEventListener("onClick", this);
                if (dashboardContent.isEmbedReportContent()) {
                    this.addDrillAcrossEventListener(AD_Process_ID, (Component)parentComponent);
                    String processParameters = dashboardContent.getProcessParameters();
                    ReportData reportData = this.generateReport(AD_Process_ID, dashboardContent.getAD_PrintFormat_ID(), processParameters, (Component)parentComponent, contextPath);
                    Div layout = new Div();
                    layout.setHeight("100%");
                    layout.setStyle("display: flex;flex-direction: column;");
                    components.add((Component)layout);
                    Iframe iframe = new Iframe();
                    iframe.setSclass("dashboard-report-iframe");
                    iframe.setStyle("flex-grow: 1;");
                    iframe.setContent((Media)reportData.getContent());
                    if (iframe.getContent() != null) {
                        layout.appendChild((Component)iframe);
                    } else {
                        layout.appendChild((Component)this.createFillMandatoryLabel(dashboardContent));
                    }
                    Toolbar toolbar = new Toolbar();
                    LayoutUtils.addSclass("dashboard-report-toolbar", (HtmlBasedComponent)toolbar);
                    layout.appendChild((Component)toolbar);
                    btn.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenRunDialog"));
                    toolbar.appendChild((Component)btn);
                    if (iframe.getContent() != null && reportData.getRowCount() >= 0) {
                        btn = new ToolBarButton();
                        btn.setAttribute("AD_Process_ID", AD_Process_ID);
                        btn.setAttribute("ProcessParameters", processParameters);
                        btn.setAttribute("AD_PrintFormat_ID", dashboardContent.getAD_PrintFormat_ID());
                        btn.addEventListener("onClick", this);
                        btn.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ViewReportInNewTab"));
                        toolbar.appendChild((Component)new Separator("vertical"));
                        toolbar.appendChild((Component)btn);
                    }
                    btn = new ToolBarButton();
                    if (ThemeManager.isUseFontIconForImage()) {
                        btn.setIconSclass("z-icon-Refresh");
                        btn.setSclass("trash-toolbarbutton");
                    } else {
                        btn.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
                    }
                    toolbar.appendChild((Component)btn);
                    Label rowCountLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"RowCount", (Object[])new Object[]{reportData.getRowCount()}));
                    if (reportData.getRowCount() >= 0) {
                        LayoutUtils.addSclass("rowcount-label", (HtmlBasedComponent)rowCountLabel);
                        toolbar.appendChild((Component)rowCountLabel);
                    }
                    btn.addEventListener("onClick", e -> {
                        ReportData refreshedData = this.generateReport(AD_Process_ID, dashboardContent.getAD_PrintFormat_ID(), processParameters, (Component)parentComponent, contextPath);
                        iframe.setContent((Media)refreshedData.getContent());
                        if (refreshedData.getRowCount() >= 0) {
                            rowCountLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"RowCount", (Object[])new Object[]{refreshedData.getRowCount()}));
                        }
                    });
                } else {
                    btn.setLabel(menu.getName());
                    components.add((Component)btn);
                }
            }
        }
        if ((PA_Goal_ID = dashboardContent.getPA_Goal_ID()) > 0) {
            String goalDisplay = dashboardContent.getGoalDisplay();
            MGoal goal = new MGoal(Env.getCtx(), PA_Goal_ID, null);
            if ("G".equals(goalDisplay)) {
                WPerformanceIndicator.Options options = new WPerformanceIndicator.Options();
                options.colorMap = new HashMap<String, Color>();
                options.colorMap.put("dialBackground", new Color(224, 224, 224, 1));
                WPAWidget paWidget = new WPAWidget(goal, options, dashboardContent.isShowTitle());
                components.add((Component)paWidget);
                spt.executeAsync(() -> LayoutUtils.addSclass("performance-gadget", parentComponent));
            } else {
                Div div = new Div();
                Toolbarbutton link = new Toolbarbutton();
                if (ThemeManager.isUseFontIconForImage()) {
                    link.setIconSclass("z-icon-Zoom");
                } else {
                    link.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
                }
                link.setAttribute("PA_Goal_ID", (Object)PA_Goal_ID);
                link.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        int PA_Goal_ID = (Integer)event.getTarget().getAttribute("PA_Goal_ID");
                        MGoal goal = new MGoal(Env.getCtx(), PA_Goal_ID, null);
                        new WPerformanceDetail(goal);
                    }
                });
                div.appendChild((Component)link);
                components.add((Component)div);
                WGraph graph = new WGraph(goal, 55, false, true, !DASHBOARD_LAYOUT_COLUMNS.equals(goalDisplay), DASHBOARD_LAYOUT_COLUMNS.equals(goalDisplay));
                components.add((Component)graph);
            }
        }
        if (zulComponent != null) {
            try {
                if (zulComponent instanceof Include) {
                    zulComponent = zulComponent.getFirstChild();
                }
                if (zulComponent instanceof DashboardPanel) {
                    DashboardPanel dashboardPanel = (DashboardPanel)zulComponent;
                    if (!dashboardPanel.getChildren().isEmpty()) {
                        components.add((Component)dashboardPanel);
                        this.addDashboardPanel(dashboardPanel);
                    }
                } else {
                    components.add(zulComponent);
                }
            }
            catch (Exception e2) {
                throw new AdempiereException((Throwable)e2);
            }
        }
        if ((AD_Chart_ID = dashboardContent.getAD_Chart_ID()) > 0) {
            final Div chartPanel = new Div();
            chartPanel.setSclass("chart-gadget");
            final MChart chartModel = new MChart(Env.getCtx(), AD_Chart_ID, null);
            components.add((Component)chartPanel);
            chartPanel.addEventListener("onAfterSize", (EventListener)new EventListener<AfterSizeEvent>(){

                public void onEvent(AfterSizeEvent event) throws Exception {
                    int width = event.getWidth() * 90 / 100;
                    int height = event.getHeight();
                    if (height == 0) {
                        height = width * 85 / 100;
                        chartPanel.setHeight(height + "px");
                    }
                    chartPanel.getChildren().clear();
                    ChartModel model = new ChartModel();
                    model.chart = chartModel;
                    DashboardController.this.renderChart(chartPanel, width, height, model, dashboardContent.isShowTitle());
                }
            });
        }
        if ((AD_StatusLine_ID = dashboardContent.getAD_StatusLine_ID()) > 0) {
            MStatusLine sl = new MStatusLine(Env.getCtx(), AD_StatusLine_ID, null);
            Html statusLineHtml = new Html();
            statusLineHtml.setContent(sl.parseLine(0));
            Div div = new Div();
            div.appendChild((Component)statusLineHtml);
            div.setSclass("statusline-gadget");
            components.add((Component)div);
            spt.executeAsync(() -> LayoutUtils.addSclass("statusline-wrapper", (HtmlBasedComponent)parentComponent.getParent()));
        }
    }

    public boolean render(Component content, MDashboardContent dashboardContent, DashboardRunnable dashboardRunnable) throws Exception {
        ArrayList<Component> components = new ArrayList<Component>();
        Component zulComponent = null;
        if (!Util.isEmpty((String)dashboardContent.getZulFilePath(), (boolean)true)) {
            try {
                zulComponent = Extensions.getDashboardGadget(dashboardContent.getZulFilePath(), content, dashboardContent);
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        ServerPushTemplate spt = new ServerPushTemplate(content.getDesktop());
        HtmlBasedComponent parentComponent = (HtmlBasedComponent)content;
        this.asyncRenderComponents(dashboardContent, dashboardRunnable, Executions.getCurrent().getContextPath(), parentComponent, components, zulComponent, spt);
        boolean empty = components.isEmpty();
        for (Component c : components) {
            DashboardPanel dpanel;
            if (c.getParent() != parentComponent) {
                parentComponent.appendChild(c);
            }
            if (!(c instanceof DashboardPanel) || !(dpanel = (DashboardPanel)c).isLazy()) continue;
            try {
                dpanel.refresh(spt);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
        }
        return !empty;
    }

    private void addDrillAcrossEventListener(final int processID, final Component component) {
        component.addEventListener("onDrillAcross", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DrillEvent) {
                    Clients.clearBusy();
                    DrillEvent de = (DrillEvent)event;
                    if (de.getData() != null && de.getData() instanceof DrillEvent.DrillData) {
                        JSONArray jsonData;
                        DrillEvent.DrillData data = (DrillEvent.DrillData)de.getData();
                        if (data.getData() instanceof JSONArray && (jsonData = (JSONArray)data.getData()).indexOf((Object)String.valueOf(processID)) < 0) {
                            return;
                        }
                        AEnv.actionDrill(data, SessionManager.getAppDesktop().findWindowNo(component), processID);
                    }
                }
            }
        });
        component.addEventListener("onZoom", event -> {
            ZoomEvent ze;
            Clients.clearBusy();
            if (event instanceof ZoomEvent && (ze = (ZoomEvent)event).getData() != null && ze.getData() instanceof MQuery) {
                AEnv.zoom((MQuery)ze.getData());
            }
        });
        component.addEventListener("onDrillDown", event -> {
            DrillEvent de;
            Clients.clearBusy();
            if (event instanceof DrillEvent && (de = (DrillEvent)event).getData() != null && de.getData() instanceof DrillEvent.DrillData) {
                DrillEvent.DrillData data = (DrillEvent.DrillData)de.getData();
                MQuery query = data.getQuery();
                this.executeDrill(query);
            }
        });
    }

    private void executeDrill(MQuery query) {
        int AD_Table_ID = MTable.getTable_ID((String)query.getTableName());
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            Dialog.error(0, "AccessCannotReport", query.getTableName());
            return;
        }
        if (AD_Table_ID != 0) {
            new WReport(AD_Table_ID, query);
        }
    }

    public void onEvent(Event event) throws Exception {
        block25: {
            String eventName;
            Component comp;
            block28: {
                Panel panel;
                String layoutOrientation;
                block29: {
                    block26: {
                        ToolBarButton btn;
                        block27: {
                            block23: {
                                Panel panel2;
                                block24: {
                                    comp = event.getTarget();
                                    eventName = event.getName();
                                    layoutOrientation = MSysConfig.getValue((String)"DASHBOARD_LAYOUT_ORIENTATION", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
                                    if (!layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS) && !layoutOrientation.equals(DASHBOARD_LAYOUT_COLUMNS)) {
                                        layoutOrientation = DASHBOARD_LAYOUT_COLUMNS;
                                    }
                                    if (!(event instanceof MaximizeEvent)) break block23;
                                    MaximizeEvent me = (MaximizeEvent)event;
                                    panel2 = (Panel)event.getTarget();
                                    if (!me.isMaximized()) break block24;
                                    this.prevParent = panel2.getParent();
                                    this.prevNext = panel2.getNextSibling();
                                    panel2.detach();
                                    if (this.columnList != null) {
                                        for (Anchorchildren anchorChildren : this.columnList) {
                                            anchorChildren.detach();
                                        }
                                    } else {
                                        for (Anchorchildren anchorChildren : this.rowList) {
                                            anchorChildren.detach();
                                        }
                                    }
                                    this.dashboardLayout.appendChild((Component)this.maximizedHolder);
                                    this.maximizedHolder.appendChild((Component)panel2);
                                    panel2.setSclass("dashboard-widget dashboard-widget-max");
                                    break block25;
                                }
                                this.maximizedHolder.detach();
                                panel2.detach();
                                this.prevParent.insertBefore((Component)panel2, this.prevNext);
                                if (this.columnList != null) {
                                    for (Anchorchildren anchorChildren : this.columnList) {
                                        this.dashboardLayout.appendChild((Component)anchorChildren);
                                    }
                                } else {
                                    for (Anchorchildren anchorChildren : this.rowList) {
                                        this.dashboardLayout.appendChild((Component)anchorChildren);
                                    }
                                }
                                panel2.setSclass("dashboard-widget");
                                ZKUpdateUtil.setHflex((HtmlBasedComponent)panel2, (String)panel2.getAttribute(FLEX_GROW_ATTRIBUTE));
                                ZKUpdateUtil.setHeight((HtmlBasedComponent)panel2, "100%");
                                if (panel2.getPanelchildren() == null) break block25;
                                panel2.getPanelchildren().getChildren().forEach(child -> Executions.schedule((Desktop)this.dashboardLayout.getDesktop(), e -> Events.postEvent((Component)child, (Event)event), (Event)new Event("onPostRestore")));
                                break block25;
                            }
                            if (!eventName.equals("onClick")) break block26;
                            if (!(comp instanceof ToolBarButton)) break block25;
                            btn = (ToolBarButton)comp;
                            if (btn.getAttribute("AD_Menu_ID") == null) break block27;
                            int menuId = (Integer)btn.getAttribute("AD_Menu_ID");
                            if (menuId > 0) {
                                SessionManager.getAppDesktop().onMenuSelected(menuId);
                            }
                            break block25;
                        }
                        if (btn.getAttribute("AD_Process_ID") == null) break block25;
                        int processId = (Integer)btn.getAttribute("AD_Process_ID");
                        String parameters = (String)btn.getAttribute("ProcessParameters");
                        int printFormatId = (Integer)btn.getAttribute("AD_PrintFormat_ID");
                        if (processId <= 0) break block25;
                        this.openReportInViewer(processId, printFormatId, parameters);
                        break block25;
                    }
                    if (!eventName.equals("onDrop")) break block28;
                    DropEvent de = (DropEvent)event;
                    Component dragged = de.getDragged();
                    if (!(dragged instanceof Caption)) break block25;
                    Caption caption = (Caption)dragged;
                    panel = null;
                    if (caption.getParent() instanceof Panel) {
                        panel = (Panel)caption.getParent();
                    }
                    if (panel == null) break block25;
                    if (!(comp instanceof Panel)) break block29;
                    Panel target = (Panel)comp;
                    boolean isParentHVlayout = false;
                    isParentHVlayout = layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS) ? target.getParent() instanceof Hlayout : target.getParent() instanceof Vlayout;
                    if (target.getParent() != null && isParentHVlayout) {
                        Hlayout dashboardColumnLayout;
                        if (layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS)) {
                            dashboardColumnLayout = (Hlayout)target.getParent();
                            List children = dashboardColumnLayout.getParent().getChildren();
                            if (children != null && children.size() >= 10) {
                                return;
                            }
                        } else {
                            dashboardColumnLayout = (Vlayout)target.getParent();
                        }
                        Component prevParent = panel.getParent();
                        dashboardColumnLayout.insertBefore((Component)panel, (Component)target);
                        this.saveDashboardPreference((Component)dashboardColumnLayout, prevParent);
                    }
                    break block25;
                }
                if (!(comp instanceof Anchorchildren)) break block25;
                Anchorchildren target = (Anchorchildren)comp;
                boolean isFirstChildHVlayout = false;
                if (layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS)) {
                    isFirstChildHVlayout = target.getFirstChild() instanceof Hlayout;
                    List children = target.getChildren();
                    if (children != null && children.size() >= 10) {
                        return;
                    }
                } else {
                    isFirstChildHVlayout = target.getFirstChild() instanceof Vlayout;
                }
                if (target.getFirstChild() == null || !isFirstChildHVlayout) break block25;
                Object dashboardColumnLayout = layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS) ? (Hlayout)target.getFirstChild() : (Vlayout)target.getFirstChild();
                Component prevParent = panel.getParent();
                dashboardColumnLayout.appendChild((Component)panel);
                this.saveDashboardPreference((Component)dashboardColumnLayout, prevParent);
                break block25;
            }
            if (eventName.equals("onOpen") && comp instanceof Panel) {
                Panel panel = (Panel)comp;
                Object value = panel.getAttribute("PA_DashboardPreference_ID");
                if (value != null) {
                    int PA_DashboardPreference_ID = Integer.parseInt(value.toString());
                    MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), PA_DashboardPreference_ID, null);
                    preference.setIsCollapsedByDefault(!panel.isOpen());
                    if (!preference.saveCrossTenantSafe()) {
                        logger.log(Level.SEVERE, "Failed to save dashboard preference " + preference.toString());
                    }
                }
                if (panel.getPanelchildren() != null) {
                    for (Component c : panel.getPanelchildren().getChildren()) {
                        Events.postEvent((Component)c, (Event)event);
                    }
                }
            }
        }
    }

    private Div createFillMandatoryLabel(MDashboardContent dc) {
        Div wrapper = new Div();
        wrapper.setSclass("fill-mandatory-process-para-wrapper");
        Div msgText = new Div();
        msgText.appendChild((Component)new Text(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatoryParametersDashboard", (Object[])new Object[]{dc.getEmptyMandatoryProcessPara()})));
        LayoutUtils.addSclass("fill-mandatory-process-para-text", (HtmlBasedComponent)msgText);
        wrapper.appendChild((Component)msgText);
        return wrapper;
    }

    private void createDashboardPreference(int AD_User_ID, int AD_Role_ID) {
        MDashboardContent[] dcs;
        MDashboardContent[] mDashboardContentArray = dcs = MDashboardContentAccess.get((Properties)Env.getCtx(), (int)AD_Role_ID, (int)AD_User_ID, null);
        int n = dcs.length;
        int n2 = 0;
        while (n2 < n) {
            MDashboardContent dc = mDashboardContentArray[n2];
            MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), 0, null);
            preference.setAD_Org_ID(0);
            preference.setAD_Role_ID(AD_Role_ID);
            preference.setAD_User_ID(AD_User_ID);
            preference.setColumnNo(dc.getColumnNo());
            preference.setIsCollapsedByDefault(dc.isCollapsedByDefault());
            preference.setIsShowInDashboard(dc.isShowInDashboard());
            preference.setLine(dc.getLine());
            preference.setPA_DashboardContent_ID(dc.getPA_DashboardContent_ID());
            if (!preference.save()) {
                logger.log(Level.SEVERE, "Failed to create dashboard preference " + preference.toString());
            }
            ++n2;
        }
    }

    private boolean updatePreferences(MDashboardPreference[] dps, MDashboardContent[] dcs, Properties ctx) {
        boolean change = false;
        int i = 0;
        while (i < dcs.length) {
            boolean isNew = true;
            int j = 0;
            while (j < dps.length) {
                if (dps[j].getPA_DashboardContent_ID() == dcs[i].getPA_DashboardContent_ID()) {
                    isNew = false;
                }
                ++j;
            }
            if (isNew) {
                MDashboardPreference preference = new MDashboardPreference(ctx, 0, null);
                preference.setAD_Org_ID(0);
                preference.setAD_Role_ID(Env.getAD_Role_ID((Properties)ctx));
                preference.setAD_User_ID(Env.getAD_User_ID((Properties)ctx));
                preference.setColumnNo(dcs[i].getColumnNo());
                preference.setIsCollapsedByDefault(dcs[i].isCollapsedByDefault());
                preference.setIsShowInDashboard(dcs[i].isShowInDashboard());
                preference.setLine(dcs[i].getLine());
                preference.setPA_DashboardContent_ID(dcs[i].getPA_DashboardContent_ID());
                preference.saveEx();
                if (!change) {
                    change = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < dps.length) {
            boolean found = false;
            int j = 0;
            while (j < dcs.length) {
                if (dcs[j].getPA_DashboardContent_ID() == dps[i].getPA_DashboardContent_ID()) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                dps[i].deleteEx(true);
                if (!change) {
                    change = true;
                }
            }
            ++i;
        }
        return change;
    }

    private void saveDashboardPreference(Component layout, Component prevLayout) {
        String layoutOrientation = MSysConfig.getValue((String)"DASHBOARD_LAYOUT_ORIENTATION", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (layoutOrientation.equals(DASHBOARD_LAYOUT_COLUMNS)) {
            Object value = layout.getAttribute(COLUMN_NO_ATTRIBUTE);
            if (value != null) {
                int columnNo = Integer.parseInt(value.toString());
                value = layout.getAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE);
                if (value != null) {
                    boolean isAdditionalColumn;
                    boolean isShowInDashboard = Boolean.parseBoolean(value.toString());
                    List children = layout.getChildren();
                    int counter = 0;
                    for (Component child : children) {
                        Panel panel;
                        if (!(child instanceof Panel) || (value = (panel = (Panel)child).getAttribute("PA_DashboardPreference_ID")) == null) continue;
                        int PA_DashboardPreference_ID = Integer.parseInt(value.toString());
                        MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), PA_DashboardPreference_ID, null);
                        preference.setColumnNo(columnNo);
                        preference.setLine(new BigDecimal(++counter * 10));
                        preference.setIsShowInDashboard(isShowInDashboard);
                        if (preference.save()) continue;
                        logger.log(Level.SEVERE, "Failed to save dashboard preference " + preference.toString());
                    }
                    if (isShowInDashboard && (value = layout.getAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE)) != null && (isAdditionalColumn = Boolean.parseBoolean(value.toString()))) {
                        layout.setAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE, (Object)false);
                        int noOfCols = this.columnList.size();
                        int dashboardWidth = 99;
                        int width = noOfCols <= 0 ? dashboardWidth : dashboardWidth / noOfCols;
                        int extraWidth = 100 - (noOfCols <= 0 ? dashboardWidth : width * noOfCols) - (100 - dashboardWidth - 1);
                        for (Anchorchildren column : this.columnList) {
                            column.setAnchor(width + "% 100%");
                        }
                        Vlayout dashboardColumnLayout = new Vlayout();
                        dashboardColumnLayout.setAttribute(COLUMN_NO_ATTRIBUTE, (Object)(columnNo + 1));
                        dashboardColumnLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                        dashboardColumnLayout.setAttribute(IS_ADDITIONAL_COLUMN_ATTRIBUTE, (Object)true);
                        Anchorchildren dashboardColumn = new Anchorchildren();
                        dashboardColumn.setAnchor(extraWidth + "% 100%");
                        if (!ClientInfo.isMobile()) {
                            dashboardColumn.setDroppable("true");
                            dashboardColumn.addEventListener("onDrop", (EventListener)this);
                        }
                        dashboardColumn.appendChild((Component)dashboardColumnLayout);
                        this.columnList.add(dashboardColumn);
                        this.dashboardLayout.appendChild((Component)dashboardColumn);
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardColumnLayout, "100%");
                        this.dashboardLayout.invalidate();
                    }
                    if (!this.dashboardRunnable.isEmpty()) {
                        this.dashboardRunnable.refreshDashboard(false);
                    }
                }
            }
        } else {
            Object value;
            if (prevLayout != null && (prevLayout.getChildren() == null || prevLayout.getChildren().size() <= 0)) {
                prevLayout.getParent().detach();
            }
            if ((value = layout.getAttribute(LINE_ATTRIBUTE)) != null) {
                int lineNo = Integer.parseInt(value.toString());
                value = layout.getAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE);
                if (value != null) {
                    boolean isAdditionalRow;
                    boolean isShowInDashboard = Boolean.parseBoolean(value.toString());
                    List children = layout.getChildren();
                    int counter = 0;
                    for (Component child : children) {
                        Panel panel;
                        if (!(child instanceof Panel) || (value = (panel = (Panel)child).getAttribute("PA_DashboardPreference_ID")) == null) continue;
                        int PA_DashboardPreference_ID = Integer.parseInt(value.toString());
                        MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), PA_DashboardPreference_ID, null);
                        preference.setColumnNo(counter++);
                        preference.setLine(new BigDecimal(lineNo));
                        preference.setIsShowInDashboard(isShowInDashboard);
                        if (!preference.save()) {
                            logger.log(Level.SEVERE, "Failed to save dashboard preference " + preference.toString());
                        }
                        if (!(layout instanceof Hlayout)) continue;
                        int flexGrow = preference.getFlexGrow();
                        flexGrow = flexGrow > 0 ? flexGrow : 1;
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)panel, String.valueOf(flexGrow));
                    }
                    if (isShowInDashboard && (value = layout.getAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE)) != null && (isAdditionalRow = Boolean.parseBoolean(value.toString()))) {
                        if (layout instanceof Hlayout) {
                            Anchorchildren anchorCh = (Anchorchildren)layout.getParent();
                            Component parent = anchorCh.getParent();
                            this.rowList.remove(anchorCh);
                            anchorCh.detach();
                            anchorCh = new Anchorchildren("100%");
                            ZKUpdateUtil.setHflex((HtmlBasedComponent)anchorCh, "min");
                            if (!ClientInfo.isMobile()) {
                                anchorCh.setDroppable("true");
                                anchorCh.addEventListener("onDrop", (EventListener)this);
                            }
                            this.rowList.add(anchorCh);
                            anchorCh.appendChild(layout);
                            parent.appendChild((Component)anchorCh);
                        }
                        layout.setAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE, (Object)false);
                        int width = 100;
                        Hlayout dashboardLineLayout = new Hlayout();
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardLineLayout, "100%");
                        dashboardLineLayout.setAttribute(LINE_ATTRIBUTE, (Object)(lineNo + 1));
                        dashboardLineLayout.setAttribute(IS_SHOW_IN_DASHBOARD_ATTRIBUTE, (Object)isShowInDashboard);
                        dashboardLineLayout.setAttribute(IS_ADDITIONAL_ROW_ATTRIBUTE, (Object)true);
                        dashboardLineLayout.setSclass("dashboard-row");
                        Anchorchildren dashboardLine = new Anchorchildren();
                        dashboardLine.setAnchor(width + "% 1%");
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardLine, "min");
                        if (!ClientInfo.isMobile()) {
                            dashboardLine.setDroppable("true");
                            dashboardLine.addEventListener("onDrop", (EventListener)this);
                        }
                        dashboardLine.appendChild((Component)dashboardLineLayout);
                        this.rowList.add(dashboardLine);
                        this.dashboardLayout.appendChild((Component)dashboardLine);
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)dashboardLineLayout, "100%");
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)dashboardLineLayout, "1");
                    }
                    if (!this.dashboardRunnable.isEmpty()) {
                        this.dashboardRunnable.refreshDashboard(false);
                    }
                }
            }
        }
    }

    public void onSetPage(Page page, Desktop desktop) {
        if (this.dashboardTimer != null) {
            DashboardRunnable tmp = this.dashboardRunnable;
            this.dashboardRunnable = new DashboardRunnable(tmp, desktop);
            this.dashboardTimer.setPage(page);
        }
    }

    public void onLogOut() {
        if (this.dashboardTimer != null) {
            this.dashboardTimer.detach();
            this.dashboardTimer = null;
        }
        if (this.dashboardRunnable != null) {
            this.dashboardRunnable = null;
        }
        this.dashboardLayout.detach();
        this.dashboardLayout = null;
    }

    private void addDashboardPanel(DashboardPanel dashboardPanel) {
        if (this.dashboardRunnable != null) {
            this.dashboardRunnable.add(dashboardPanel);
        }
    }

    private String stripHtml(String htmlString, boolean all) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        if (all) {
            htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
        }
        return htmlString;
    }

    private ReportEngine runReport(int AD_Process_ID, int AD_PrintFormat_ID, String parameters) {
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)AD_Process_ID);
        if (!process.isReport() || process.getAD_ReportView_ID() == 0) {
            throw new IllegalArgumentException("Not a Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName());
        }
        MPInstance pInstance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        if (AD_PrintFormat_ID > 0) {
            pInstance.setAD_PrintFormat_ID(AD_PrintFormat_ID);
        }
        pInstance.setIsProcessing(true);
        pInstance.saveEx();
        try {
            if (!this.fillParameter(pInstance, parameters)) {
                return null;
            }
            ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), 0, 0);
            pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
            pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            if (!process.processIt(pi, null) && pi.getClassName() != null) {
                throw new IllegalStateException("Process failed: (" + pi.getClassName() + ") " + pi.getSummary());
            }
            ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (ProcessInfo)pi);
            if (re == null) {
                throw new IllegalStateException("Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName());
            }
            ReportEngine reportEngine = re;
            return reportEngine;
        }
        finally {
            pInstance.setIsProcessing(false);
            pInstance.saveEx();
        }
    }

    private ReportData generateReport(int AD_Process_ID, int AD_PrintFormat_ID, String parameters, Component component, String contextPath) throws Exception {
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)AD_Process_ID);
        File file = null;
        if (process.getJasperReport() != null) {
            file = this.runJasperReport(process, parameters, AD_PrintFormat_ID);
            return new ReportData(new AMedia(process.getName(), "html", "text/html", file, false), -1);
        }
        ReportEngine re = this.runReport(AD_Process_ID, AD_PrintFormat_ID, parameters);
        if (re == null) {
            return null;
        }
        file = FileUtil.createTempFile((String)re.getName(), (String)".html");
        re.createHTML(file, false, AEnv.getLanguage(Env.getCtx()), (IHTMLExtension)new HTMLExtension(contextPath, "rp", component.getUuid(), String.valueOf(AD_Process_ID)));
        return new ReportData(new AMedia(process.getName(), "html", "text/html", file, false), re.getPrintData() != null ? re.getPrintData().getRowCount(false) : 0);
    }

    private File runJasperReport(MProcess process, String parameters, int AD_PrintFormat_ID) {
        MPInstance pInstance;
        block4: {
            pInstance = new MPInstance(Env.getCtx(), process.getAD_Process_ID(), 0, 0, null);
            pInstance.setIsProcessing(true);
            pInstance.saveEx();
            try {
                if (this.fillParameter(pInstance, parameters)) break block4;
                return null;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName());
            }
        }
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), 0, 0);
        pi.setExport(true);
        pi.setExportFileExtension("html");
        pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        if (AD_PrintFormat_ID > 0) {
            MPrintFormat format = new MPrintFormat(Env.getCtx(), AD_PrintFormat_ID, null);
            pi.setTransientObject((Object)format);
        }
        ServerProcessCtl.process((ProcessInfo)pi, null);
        return pi.getExportFile();
    }

    protected void openReportInViewer(int AD_Process_ID, int AD_PrintFormat_ID, String parameters) {
        ReportEngine re = this.runReport(AD_Process_ID, AD_PrintFormat_ID, parameters);
        new ZkReportViewerProvider().openViewer(re);
    }

    private boolean fillParameter(MPInstance pInstance, String parameters) {
        MProcessPara[] processParams = pInstance.getProcessParameters();
        if (parameters != null && parameters.trim().length() > 0) {
            Map paramMap = MDashboardContent.parseProcessParameters((String)parameters);
            int pi = 0;
            while (pi < processParams.length) {
                MPInstancePara iPara = new MPInstancePara(pInstance, processParams[pi].getSeqNo());
                iPara.setParameterName(processParams[pi].getColumnName());
                iPara.setInfo(processParams[pi].getName());
                MProcessPara sPara = processParams[pi];
                String variable = (String)paramMap.get(iPara.getParameterName());
                if (Util.isEmpty((String)variable, (boolean)true)) {
                    if (sPara.isMandatory()) {
                        return false;
                    }
                } else {
                    boolean isTo = false;
                    String[] stringArray = variable.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value;
                        block43: {
                            String paramValue = stringArray[n2];
                            value = paramValue;
                            if (paramValue == null || paramValue != null && paramValue.length() == 0) {
                                value = null;
                            } else if (paramValue.startsWith("@SQL=")) {
                                String sql = paramValue.substring(5);
                                sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)sql, (boolean)false, (boolean)false);
                                if (!Util.isEmpty((String)sql)) {
                                    CPreparedStatement stmt = null;
                                    ResultSet rs = null;
                                    try {
                                        try {
                                            stmt = DB.prepareStatement((String)sql, null);
                                            rs = stmt.executeQuery();
                                            if (rs.next()) {
                                                value = DisplayType.isNumeric((int)iPara.getDisplayType()) || DisplayType.isID((int)iPara.getDisplayType()) ? rs.getBigDecimal(1) : (DisplayType.isDate((int)iPara.getDisplayType()) ? rs.getTimestamp(1) : rs.getString(1));
                                            } else if (logger.isLoggable(Level.INFO)) {
                                                logger.log(Level.INFO, "(" + iPara.getParameterName() + ") - no Result: " + sql);
                                            }
                                        }
                                        catch (SQLException e) {
                                            logger.log(Level.WARNING, "(" + iPara.getParameterName() + ") " + sql, (Throwable)e);
                                            DB.close((ResultSet)rs, (Statement)stmt);
                                            rs = null;
                                            stmt = null;
                                            break block43;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        DB.close(rs, (Statement)stmt);
                                        rs = null;
                                        stmt = null;
                                        throw throwable;
                                    }
                                    DB.close((ResultSet)rs, (Statement)stmt);
                                    rs = null;
                                    stmt = null;
                                }
                            } else if (paramValue.indexOf(64) != -1) {
                                value = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)paramValue, (boolean)false, (boolean)false);
                            }
                        }
                        if (value == null) {
                            if (sPara.isMandatory()) {
                                return false;
                            }
                        } else {
                            if (DisplayType.isText((int)iPara.getDisplayType()) && Util.isEmpty((String)String.valueOf(value))) {
                                if (!logger.isLoggable(Level.FINE)) break;
                                logger.fine(iPara.getParameterName() + " - empty string");
                                break;
                            }
                            if (DisplayType.isNumeric((int)iPara.getDisplayType())) {
                                BigDecimal bd = null;
                                bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
                                DecimalFormat decimalFormat = DisplayType.getNumberFormat((int)iPara.getDisplayType());
                                info = decimalFormat.format(iPara.getP_Number());
                                if (isTo) {
                                    iPara.setP_Number_To(bd);
                                    iPara.setInfo_To(info);
                                } else {
                                    iPara.setP_Number(bd);
                                    iPara.setInfo(info);
                                }
                            } else if (iPara.getDisplayType() == 30 || iPara.getDisplayType() == 18 || iPara.getDisplayType() == 19) {
                                int id = new BigDecimal(value.toString()).intValue();
                                if (isTo) {
                                    iPara.setP_Number_To(new BigDecimal(value.toString()));
                                    iPara.setInfo_To(this.getDisplay(pInstance, iPara, id));
                                } else {
                                    iPara.setP_Number(new BigDecimal(value.toString()));
                                    iPara.setInfo(this.getDisplay(pInstance, iPara, id));
                                }
                            } else if (DisplayType.isDate((int)iPara.getDisplayType())) {
                                Timestamp ts = null;
                                ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
                                SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)iPara.getDisplayType());
                                info = dateFormat.format(ts);
                                if (isTo) {
                                    iPara.setP_Date_To(ts);
                                    iPara.setInfo_To(info);
                                } else {
                                    iPara.setP_Date(ts);
                                    iPara.setInfo(info);
                                }
                            } else if (isTo) {
                                iPara.setP_String_To(value.toString());
                                iPara.setInfo_To(value.toString());
                            } else if (DisplayType.isChosenMultipleSelection((int)iPara.getDisplayType())) {
                                iPara.setP_String(value.toString());
                                iPara.setInfo(this.getMultiSelectionDisplay(pInstance, iPara, value.toString()));
                            } else {
                                iPara.setP_String(value.toString());
                                iPara.setInfo(value.toString());
                            }
                            iPara.saveEx();
                            isTo = true;
                        }
                        ++n2;
                    }
                }
                ++pi;
            }
        } else {
            MProcessPara[] mProcessParaArray = processParams;
            int n = processParams.length;
            int n3 = 0;
            while (n3 < n) {
                MProcessPara processPara = mProcessParaArray[n3];
                if (processPara.isMandatory()) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private String getMultiSelectionDisplay(MPInstance i, MPInstancePara ip, String values) {
        String[] splittedValues;
        Object returnValue = "";
        String[] stringArray = splittedValues = values.split("[,]");
        int n = splittedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!Util.isEmpty((String)returnValue)) {
                returnValue = (String)returnValue + ", ";
            }
            returnValue = (String)returnValue + this.getDisplay(i, ip, 200161 == ip.getDisplayType() ? value : Integer.valueOf(Integer.parseInt(value)));
            ++n2;
        }
        return returnValue;
    }

    private String getDisplay(MPInstance i, MPInstancePara ip, Object value) {
        block11: {
            try {
                StringBuilder name;
                block13: {
                    MProcessPara pp = MProcess.get((int)i.getAD_Process_ID()).getParameter(ip.getParameterName());
                    if (pp == null) break block11;
                    MLookupInfo mli = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)0, (int)0, (int)pp.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)pp.getColumnName(), (int)pp.getAD_Reference_Value_ID(), (boolean)false, (String)"");
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    name = new StringBuilder("");
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)mli.QueryDirect, null);
                            if (value instanceof Integer) {
                                pstmt.setInt(1, (Integer)value);
                            } else {
                                pstmt.setString(1, Objects.toString(value, ""));
                            }
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                name.append(rs.getString(3));
                                boolean isActive = rs.getString(4).equals("Y");
                                if (!isActive) {
                                    name.insert(0, "~").append("~");
                                }
                                if (rs.next()) {
                                    logger.log(Level.SEVERE, "Error while displaying parameter for embedded report - Not unique (first returned) for SQL=" + mli.QueryDirect);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error while displaying parameter for embedded report - " + mli.KeyColumn + ": SQL=" + mli.QueryDirect + " : " + String.valueOf(e));
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                return name.toString();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to retrieve data to display for embedded report " + MProcess.get((int)i.getAD_Process_ID()).getName() + " : " + ip.getParameterName(), (Throwable)e);
            }
        }
        return Objects.toString(value, "");
    }

    public void updateLayout(ClientInfo clientInfo) {
        if (this.isShowInDashboard && ClientInfo.isMobile()) {
            int n = 0;
            if (ClientInfo.maxWidth(999)) {
                n = ClientInfo.maxWidth(699) ? 1 : 2;
            }
            if (this.noOfCols > 0 && n > 0 && this.noOfCols != n) {
                String layoutOrientation = MSysConfig.getValue((String)"DASHBOARD_LAYOUT_ORIENTATION", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
                if (layoutOrientation.equals(DASHBOARD_LAYOUT_ROWS)) {
                    this.renderRows(null, null, true, true);
                } else {
                    this.renderColumns(null, null, true, true);
                }
                this.dashboardLayout.invalidate();
            }
        }
    }

    private void renderChart(Div chartPanel, int width, int height, ChartModel model, boolean showTitle) {
        List<IChartRendererService> list = Extensions.getChartRendererServices();
        for (IChartRendererService renderer : list) {
            if (renderer.renderChart((Component)chartPanel, width, height, model, showTitle)) break;
        }
    }

    public class ReportData {
        private AMedia content;
        private int rowCount = 0;

        public ReportData(AMedia content, int rowCount) {
            this.content = content;
            this.rowCount = rowCount;
        }

        public AMedia getContent() {
            return this.content;
        }

        public int getRowCount() {
            return this.rowCount;
        }
    }
}

