/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.adempiere.webui.util.DesktopWatchDog;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.util.Monitor;

public class Statistic
implements Monitor {
    private final long _startTime;
    private LongAdder _nsess = new LongAdder();
    private LongAdder _actsess = new LongAdder();
    private LongAdder _ndt = new LongAdder();
    private LongAdder _actdt = new LongAdder();
    private LongAdder _nupd = new LongAdder();
    private LongAdder _actupd = new LongAdder();

    public Statistic() {
        this._startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getTotalSessionCount() {
        return this._nsess.longValue();
    }

    public long getActiveSessionCount() {
        return this._actsess.longValue();
    }

    public double getAverageSessionCount() {
        return (double)this._nsess.longValue() / this.getEscapedHours();
    }

    public long getTotalDesktopCount() {
        return this._ndt.longValue();
    }

    public long getActiveDesktopCount() {
        return this._actdt.longValue();
    }

    public double getAverageDesktopCount() {
        return (double)this._ndt.longValue() / this.getEscapedHours();
    }

    public long getTotalUpdateCount() {
        return this._nupd.longValue();
    }

    public long getActiveUpdateCount() {
        return this._actupd.longValue();
    }

    public double getAverageUpdateCount() {
        return (double)this._nupd.longValue() / this.getEscapedHours();
    }

    private double getEscapedHours() {
        long v = System.currentTimeMillis() - this._startTime;
        return (double)v / 3600000.0;
    }

    public void sessionCreated(Session sess) {
        this._nsess.increment();
        this._actsess.increment();
    }

    public void sessionDestroyed(Session sess) {
        this._actsess.decrement();
    }

    public void desktopCreated(Desktop desktop) {
        this._ndt.increment();
        this._actdt.increment();
        DesktopWatchDog.addDesktop(desktop);
    }

    public void desktopDestroyed(Desktop desktop) {
        this._actdt.decrement();
    }

    public void beforeUpdate(Desktop desktop, List<AuRequest> requests) {
        this._nupd.increment();
        this._actupd.increment();
    }

    public void afterUpdate(Desktop desktop) {
        this._actupd.decrement();
    }
}

