/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.adempiere.util.ServerContext;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZkContextRunnable;
import org.compiere.Adempiere;
import org.compiere.util.CLogger;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.DesktopCleanup;

public class DashboardRunnable
implements Runnable,
Serializable {
    private static final long serialVersionUID = 5995227773511788894L;
    private WeakReference<Desktop> desktop;
    private List<DashboardPanel> dashboardPanels;
    private Locale locale;
    private DesktopCleanup listener;
    private static final CLogger logger = CLogger.getCLogger(DashboardRunnable.class);

    public DashboardRunnable(Desktop desktop) {
        this.desktop = new WeakReference<Desktop>(desktop);
        this.dashboardPanels = new ArrayList<DashboardPanel>();
        this.locale = Locales.getCurrent();
        this.listener = new DesktopCleanup(){

            public void cleanup(Desktop desktop) throws Exception {
                DashboardRunnable.this.cleanup();
            }
        };
        ((Desktop)this.desktop.get()).addListener((Object)this.listener);
    }

    protected void cleanup() {
        this.dashboardPanels = null;
        if (this.desktop != null && this.desktop.get() != null) {
            ((Desktop)this.desktop.get()).removeListener((Object)this.listener);
        }
        this.desktop = null;
    }

    public DashboardRunnable(DashboardRunnable tmp, Desktop desktop) {
        this(desktop);
        this.dashboardPanels = tmp.dashboardPanels;
        tmp.cleanup();
    }

    @Override
    public void run() {
        if (this.dashboardPanels != null && this.desktop != null && this.desktop.get() != null && ((Desktop)this.desktop.get()).isAlive() && ((Desktop)this.desktop.get()).isServerPushEnabled()) {
            Locales.setThreadLocal((Locale)this.locale);
            try {
                this.refreshDashboard(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void refreshDashboard(boolean pooling) {
        final ServerPushTemplate template = new ServerPushTemplate((Desktop)this.desktop.get());
        Properties ctx = null;
        boolean isEventThread = Events.inEventListener();
        if (!isEventThread) {
            try {
                ctx = (Properties)template.getDesktop().getSession().getAttribute("WebUISessionContext");
            }
            catch (Exception exception) {
                ctx = null;
            }
            if (ctx == null) {
                return;
            }
        }
        try {
            if (!isEventThread) {
                ServerContext.setCurrentInstance(ctx);
            }
            int i = 0;
            while (i < this.dashboardPanels.size()) {
                if (!pooling || this.dashboardPanels.get(i).isPooling()) {
                    final DashboardPanel dpanel = this.dashboardPanels.get(i);
                    final BusyDialog busyDialog = new BusyDialog();
                    busyDialog.setShadow(false);
                    dpanel.getParent().insertBefore((Component)busyDialog, dpanel.getParent().getFirstChild());
                    ZkContextRunnable cr = new ZkContextRunnable(){

                        protected void doRun() {
                            dpanel.refresh(template);
                            template.executeAsync(() -> busyDialog.detach());
                        }
                    };
                    Adempiere.getThreadPoolExecutor().submit((Runnable)((Object)cr));
                }
                ++i;
            }
        }
        finally {
            if (!isEventThread) {
                ServerContext.dispose();
            }
        }
    }

    public void add(DashboardPanel dashboardPanel) {
        if (this.dashboardPanels != null) {
            this.dashboardPanels.add(dashboardPanel);
        }
    }

    public boolean isEmpty() {
        return this.dashboardPanels == null || this.dashboardPanels.isEmpty();
    }
}

