/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.Map;
import java.util.Properties;
import org.adempiere.webui.event.ZoomEvent;
import org.compiere.model.MQuery;
import org.compiere.model.MWindow;
import org.compiere.util.Env;
import org.zkoss.json.JSONArray;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class ZoomCommand
implements AuService {
    public boolean service(AuRequest request, boolean everError) {
        if (!"onZoom".equals(request.getCommand())) {
            return false;
        }
        Map map = request.getData();
        JSONArray data = (JSONArray)map.get("data");
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        if (data == null || data.size() < 2) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        String columnName = (String)data.get(0);
        String tableName = MQuery.getZoomTableName((String)columnName);
        Object code = null;
        int windowID = 0;
        if (columnName.endsWith("_ID")) {
            try {
                code = Integer.parseInt((String)data.get(1));
            }
            catch (Exception exception) {
                code = data.get(1);
            }
        } else {
            code = data.get(1);
        }
        if (data.size() > 3 && data.get(3) != null && data.get(2) != null && data.get(2).toString().equalsIgnoreCase("AD_Window_UU")) {
            String windowUU = (String)data.get(3);
            MWindow window = MWindow.get((Properties)Env.getCtx(), (String)windowUU);
            if (window != null) {
                windowID = window.getAD_Window_ID();
            }
        }
        MQuery query = new MQuery(tableName);
        query.addRestriction(columnName, "=", code);
        query.setRecordCount(1);
        query.setZoomTableName(tableName);
        query.setZoomColumnName(columnName);
        query.setZoomValue(code);
        query.setZoomWindowID(windowID);
        Events.postEvent((Event)new ZoomEvent(comp, query));
        return true;
    }
}

