/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.action;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.action.IAction;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.util.CCache;
import org.zkoss.image.AImage;

public class Actions {
    private static final String ACTION_IMAGES_PATH = "/action/images/";
    private static CCache<String, IServiceHolder<IAction>> trackerCache = new CCache(null, "ActionsServiceTracker", 5, false);
    private static CCache<String, AImage> imageCache = new CCache(null, "ActionsImages", 5, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServiceHolder<IAction> getAction(String actionId) {
        IServiceHolder action = null;
        CCache<String, IServiceHolder<IAction>> cCache = trackerCache;
        synchronized (cCache) {
            action = (IServiceHolder)trackerCache.get((Object)actionId);
        }
        if (action != null && action.getService() != null) {
            return action;
        }
        action = Service.locator().locate(IAction.class, actionId, null);
        if (action != null) {
            cCache = trackerCache;
            synchronized (cCache) {
                trackerCache.put((Object)actionId, (Object)action);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AImage getActionImage(String actionId) {
        AImage aImage = null;
        CCache<String, AImage> cCache = imageCache;
        synchronized (cCache) {
            aImage = (AImage)imageCache.get((Object)actionId);
        }
        if (aImage != null) {
            return aImage;
        }
        String imageName = actionId + "24.png";
        IServiceHolder<IAction> action = Actions.getAction(actionId);
        if (action.getService() != null) {
            block27: {
                String path;
                InputStream inputStream = null;
                String themePath = ThemeManager.getThemeResource(imageName);
                URL themeURL = ThemeManager.class.getResource(ThemeManager.toClassPathResourcePath(themePath));
                if (themeURL != null) {
                    try {
                        inputStream = themeURL.openStream();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream == null) {
                    path = ACTION_IMAGES_PATH + ThemeManager.getTheme() + "/" + imageName;
                    inputStream = ((IAction)action.getService()).getClass().getClassLoader().getResourceAsStream(path);
                }
                if (inputStream == null && !"default".equals(ThemeManager.getTheme())) {
                    path = "/action/images/default/" + imageName;
                    inputStream = ((IAction)action.getService()).getClass().getClassLoader().getResourceAsStream(path);
                }
                if (inputStream == null) {
                    path = ACTION_IMAGES_PATH + imageName;
                    inputStream = ((IAction)action.getService()).getClass().getClassLoader().getResourceAsStream(path);
                }
                if (inputStream != null) {
                    try {
                        try {
                            aImage = new AImage(actionId, inputStream);
                        }
                        catch (IOException iOException) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2) {}
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (aImage != null) {
                CCache<String, AImage> cCache2 = imageCache;
                synchronized (cCache2) {
                    imageCache.put((Object)actionId, (Object)aImage);
                }
            }
        }
        return aImage;
    }

    public static String getActionIconSclass(String actionId) {
        IServiceHolder<IAction> action = Actions.getAction(actionId);
        IAction service = (IAction)action.getService();
        if (service != null) {
            return service.getIconSclass();
        }
        return "";
    }
}

