/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.upload.IUploadHandler;
import org.adempiere.base.upload.IUploadService;
import org.adempiere.base.upload.UploadMedia;
import org.adempiere.base.upload.UploadResponse;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAttachment;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MSchedulerRecipient;
import org.compiere.model.MSession;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;

public class Scheduler
extends AdempiereServer {
    protected StringBuffer m_summary = new StringBuffer();
    protected Trx m_trx = null;
    protected int AD_Scheduler_ID;
    protected ProcessInfo pi;
    private static ImmutableIntPOCache<Integer, MScheduler> s_cache = new ImmutableIntPOCache("AD_Scheduler", 10, 60);

    public Scheduler(MScheduler model) {
        super((AdempiereProcessor)model, 30);
        this.AD_Scheduler_ID = model.getAD_Scheduler_ID();
    }

    @Override
    protected void doWork() {
        MScheduler scheduler;
        block11: {
            MOrgInfo schedorg;
            scheduler = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID);
            this.m_summary = new StringBuffer(scheduler.toString()).append(" - ");
            this.pi = null;
            MClient schedclient = MClient.get((Properties)this.getCtx(), (int)scheduler.getAD_Client_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Client_ID", (int)schedclient.getAD_Client_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)schedclient.getAD_Language());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Org_ID", (int)scheduler.getAD_Org_ID());
            if (scheduler.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)scheduler.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
                Env.setContext((Properties)this.getCtx(), (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
            }
            Env.setContext((Properties)this.getCtx(), (String)"#AD_User_ID", (int)this.getAD_User_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#SalesRep_ID", (int)this.getAD_User_ID());
            MUser scheduser = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
            MRole[] schedroles = scheduser.getRoles(scheduler.getAD_Org_ID());
            if (schedroles != null && schedroles.length > 0) {
                Env.setContext((Properties)this.getCtx(), (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
            Env.setContext((Properties)this.getCtx(), (String)"#Date", (String)(dateFormat4Timestamp.format(ts) + " 00:00:00"));
            MSession session = MSession.get((Properties)Env.getCtx());
            session = session == null ? MSession.create((Properties)Env.getCtx()) : new MSession(Env.getCtx(), session.getAD_Session_ID(), null);
            MProcess process = new MProcess(this.getCtx(), scheduler.getAD_Process_ID(), null);
            try {
                try {
                    this.m_trx = Trx.get((String)Trx.createTrxName((String)"Scheduler"), (boolean)true);
                    this.m_trx.setDisplayName(this.getClass().getName() + "_" + this.getModel().getName() + "_doWork");
                    this.m_summary.append(this.runProcess(process));
                    this.m_trx.commit(true);
                }
                catch (Throwable e) {
                    if (this.m_trx != null) {
                        this.m_trx.rollback();
                    }
                    this.log.log(Level.WARNING, process.toString(), e);
                    this.m_summary.append(e.toString());
                    if (this.m_trx != null) {
                        this.m_trx.close();
                    }
                    this.m_trx = null;
                    session.logout();
                    this.getCtx().remove("#AD_Session_ID");
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (this.m_trx != null) {
                    this.m_trx.close();
                }
                this.m_trx = null;
                session.logout();
                this.getCtx().remove("#AD_Session_ID");
                throw throwable;
            }
            if (this.m_trx != null) {
                this.m_trx.close();
            }
            this.m_trx = null;
            session.logout();
            this.getCtx().remove("#AD_Session_ID");
        }
        int no = scheduler.deleteLog();
        this.m_summary.append(" Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(scheduler, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)) + (String)(this.pi != null ? " AD_PInstance_ID=" + this.pi.getAD_PInstance_ID() : ""));
        this.pi = null;
        pLog.saveEx();
    }

    protected String runProcess(MProcess process) throws Exception {
        int supervisor;
        MSchedulerLog pLog;
        String error;
        StringBuilder summary;
        MClient client;
        int supervisor2;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(process.toString());
        }
        MScheduler scheduler = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID);
        boolean isReport = process.isReport() || process.getAD_ReportView_ID() > 0 || process.getJasperReport() != null || process.getAD_PrintFormat_ID() > 0;
        String schedulerName = Env.parseContext((Properties)this.getCtx(), (int)-1, (String)scheduler.getName(), (boolean)false, (boolean)true);
        int AD_Table_ID = scheduler.getAD_Table_ID();
        int Record_ID = scheduler.getRecord_ID();
        MPInstance pInstance = new MPInstance(this.getCtx(), process.getAD_Process_ID(), AD_Table_ID, Record_ID, null);
        pInstance.saveEx();
        this.fillParameter(pInstance);
        this.pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        this.pi.setAD_User_ID(this.getAD_User_ID());
        this.pi.setAD_Client_ID(scheduler.getAD_Client_ID());
        this.pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        this.pi.setAD_Process_UU(process.getAD_Process_UU());
        this.pi.setIsBatch(true);
        this.pi.setPrintPreview(true);
        this.pi.setReportType(scheduler.getReportOutputType());
        this.pi.setAD_Scheduler_ID(scheduler.getAD_Scheduler_ID());
        int AD_PrintFormat_ID = scheduler.getAD_PrintFormat_ID();
        if (AD_PrintFormat_ID > 0) {
            MPrintFormat format = new MPrintFormat(Env.getCtx(), AD_PrintFormat_ID, null);
            this.pi.setSerializableObject((Serializable)format);
        }
        MUser from = new MUser(this.getCtx(), this.pi.getAD_User_ID().intValue(), null);
        this.pi.setTransactionName(this.m_trx != null ? this.m_trx.getTrxName() : null);
        if (!Util.isEmpty((String)process.getJasperReport())) {
            this.pi.setExport(true);
            if ("HTML".equals(this.pi.getReportType())) {
                this.pi.setExportFileExtension("html");
            } else if ("CSV".equals(this.pi.getReportType())) {
                this.pi.setExportFileExtension("csv");
            } else if ("XLS".equals(this.pi.getReportType())) {
                this.pi.setExportFileExtension("xls");
            } else if ("XLSX".equals(this.pi.getReportType())) {
                this.pi.setExportFileExtension("xlsx");
            } else {
                this.pi.setExportFileExtension("pdf");
            }
        }
        ServerProcessCtl.process((ProcessInfo)this.pi, (Trx)this.m_trx);
        if (this.pi.isError() && (supervisor2 = scheduler.getSupervisor_ID()) > 0) {
            MUser user = new MUser(this.getCtx(), supervisor2, null);
            boolean email = user.isNotificationEMail();
            boolean notice = user.isNotificationNote();
            if (email || notice) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)this.pi);
            }
            if (email) {
                MClient client2 = MClient.get((Properties)scheduler.getCtx(), (int)scheduler.getAD_Client_ID());
                client2.sendEMail(from, user, schedulerName, this.pi.getSummary() + " " + this.pi.getLogInfo(), null);
            }
            if (notice) {
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor2, null);
                note.setClientOrg(scheduler.getAD_Client_ID(), scheduler.getAD_Org_ID());
                note.setTextMsg(schedulerName + "\n" + this.pi.getSummary());
                note.setRecord(282, this.pi.getAD_PInstance_ID());
                note.saveEx();
                String log = this.pi.getLogInfo(true);
                if (log != null && log.trim().length() > 0) {
                    MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), note.getAD_Note_UU(), null);
                    attachment.setClientOrg(scheduler.getAD_Client_ID(), scheduler.getAD_Org_ID());
                    attachment.setTextMsg(schedulerName);
                    attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                    attachment.saveEx();
                }
            }
        }
        ArrayList<String> sendErrors = new ArrayList<String>();
        Integer[] userIDs = scheduler.getRecipientAD_User_IDs(true);
        if (userIDs.length > 0 && this.pi.isNotifyRecipients()) {
            ProcessInfoUtil.setLogFromDB((ProcessInfo)this.pi);
            ArrayList<File> fileList = new ArrayList<File>();
            if (isReport && this.pi.getPDFReport() != null) {
                fileList.add(this.pi.getPDFReport());
            }
            if (this.pi.isExport() && this.pi.getExportFile() != null) {
                fileList.add(this.pi.getExportFile());
            }
            int i = 0;
            while (i < userIDs.length) {
                MUser user = new MUser(this.getCtx(), userIDs[i].intValue(), null);
                boolean email = user.isNotificationEMail();
                boolean notice = user.isNotificationNote();
                if (notice) {
                    int AD_Message_ID = 441;
                    if (isReport) {
                        AD_Message_ID = 884;
                    }
                    MNote note = new MNote(this.getCtx(), AD_Message_ID, userIDs[i].intValue(), null);
                    note.setClientOrg(scheduler.getAD_Client_ID(), scheduler.getAD_Org_ID());
                    if (isReport) {
                        note.setTextMsg(schedulerName);
                        note.setDescription(scheduler.getDescription());
                        note.setRecord(AD_Table_ID, Record_ID);
                    } else {
                        note.setTextMsg(schedulerName + "\n" + this.pi.getSummary());
                        note.setRecord(282, this.pi.getAD_PInstance_ID());
                    }
                    if (note.save()) {
                        String log;
                        MAttachment attachment = null;
                        if (fileList != null && !fileList.isEmpty()) {
                            attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), note.getAD_Note_UU(), null);
                            attachment.setClientOrg(scheduler.getAD_Client_ID(), scheduler.getAD_Org_ID());
                            attachment.setTextMsg(schedulerName);
                            for (File entry : fileList) {
                                attachment.addEntry(entry);
                            }
                        }
                        if ((log = this.pi.getLogInfo(true)) != null && log.trim().length() > 0) {
                            if (attachment == null) {
                                attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), note.getAD_Note_UU(), null);
                                attachment.setClientOrg(scheduler.getAD_Client_ID(), scheduler.getAD_Org_ID());
                                attachment.setTextMsg(schedulerName);
                            }
                            attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                            attachment.saveEx();
                        }
                        if (attachment != null) {
                            attachment.saveEx();
                        }
                    }
                }
                if (email) {
                    MMailText mailTemplate = new MMailText(this.getCtx(), scheduler.getR_MailText_ID(), null);
                    String mailContent = "";
                    if (mailTemplate.is_new()) {
                        mailContent = scheduler.getDescription() != null ? scheduler.getDescription() : "";
                    } else {
                        mailTemplate.setUser(user);
                        mailTemplate.setLanguage(Env.getContext((Properties)this.getCtx(), (String)"#AD_Language"));
                        mailContent = mailTemplate.getMailText(true);
                        schedulerName = mailTemplate.getMailHeader();
                    }
                    client = MClient.get((Properties)scheduler.getCtx(), (int)scheduler.getAD_Client_ID());
                    if (fileList != null && !fileList.isEmpty()) {
                        if (!client.sendEMailAttachments(from, user, schedulerName, mailContent, fileList)) {
                            summary = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerSendAttachmentFailed"));
                            summary.append(user.getName());
                            error = (String)Env.getCtx().remove("EmailSendMsg");
                            if (!Util.isEmpty((String)error)) {
                                summary.append(". Error: ").append(error);
                            }
                            sendErrors.add(summary.toString());
                            pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), summary.toString());
                            pLog.setTextMsg("From: " + from.getName() + " (" + from.getEMail() + ") To: " + user.getName() + " (" + user.getEMail() + ")");
                            pLog.setIsError(true);
                            pLog.saveEx();
                        }
                    } else if (!client.sendEMail(from, user, schedulerName, mailContent + "\n" + this.pi.getSummary() + "\n" + this.pi.getLogInfo(), null)) {
                        summary = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerSendNotificationFailed"));
                        summary.append(user.getName());
                        error = (String)Env.getCtx().remove("EmailSendMsg");
                        if (!Util.isEmpty((String)error)) {
                            summary.append(". Error: ").append(error);
                        }
                        sendErrors.add(summary.toString());
                        pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), summary.toString());
                        pLog.setTextMsg("From: " + from.getName() + " (" + from.getEMail() + ") To: " + user.getName() + " (" + user.getEMail() + ")");
                        pLog.setIsError(true);
                        pLog.saveEx();
                    }
                }
                ++i;
            }
            for (File file : fileList) {
                if (!file.exists() || file.delete()) continue;
                file.deleteOnExit();
            }
        }
        ArrayList<String> uploadErrors = new ArrayList<String>();
        MClient uploads = scheduler.getUploadRecipients();
        if (((MSchedulerRecipient[])uploads).length > 0) {
            File file = this.pi.getPDFReport();
            String contentType = "application/pdf";
            if (file == null) {
                file = this.pi.getExportFile();
                String extension = this.pi.getExportFileExtension();
                if ("xls".equals(extension)) {
                    contentType = "application/vnd.ms-excel";
                } else if ("csv".equals(extension)) {
                    contentType = "text/csv";
                } else if ("html".equals(extension)) {
                    contentType = "text/html";
                }
            }
            if (file != null) {
                client = uploads;
                int mailContent = ((MSchedulerRecipient[])client).length;
                int mailTemplate = 0;
                while (mailTemplate < mailContent) {
                    MSchedulerRecipient upload = client[mailTemplate];
                    MAuthorizationAccount account = new MAuthorizationAccount(Env.getCtx(), upload.getAD_AuthorizationAccount_ID(), null);
                    IUploadService service = Core.getUploadService((MAuthorizationAccount)account);
                    if (service != null) {
                        try {
                            IUploadHandler[] handlers = service.getUploadHandlers(contentType);
                            if (handlers.length > 0) {
                                UploadResponse response;
                                String fileName = null;
                                fileName = upload.getFileName();
                                if (fileName != null && fileName.contains("@")) {
                                    fileName = this.parseFileName((PO)upload, fileName);
                                }
                                if (Util.isEmpty((String)fileName)) {
                                    fileName = file.getName();
                                }
                                if ((response = handlers[0].uploadMedia(new UploadMedia(fileName, contentType, (InputStream)new FileInputStream(file), file.length()), account)).getLink() != null) {
                                    pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), Msg.getMsg((Properties)Env.getCtx(), (String)"UploadSuccess"));
                                    pLog.setTextMsg("User: " + upload.getAD_User().getName() + " Account: " + account.getEMail() + " Link: " + response.getLink());
                                    pLog.setIsError(false);
                                    pLog.saveEx();
                                } else {
                                    pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), Msg.getMsg((Properties)Env.getCtx(), (String)"UploadFailed"));
                                    pLog.setTextMsg("User: " + upload.getAD_User().getName() + " Account: " + account.getEMail());
                                    pLog.setIsError(true);
                                    pLog.saveEx();
                                    uploadErrors.add(pLog.getTextMsg());
                                }
                            }
                        }
                        catch (Throwable e) {
                            this.log.log(Level.WARNING, process.toString(), e);
                            MSchedulerLog pLog2 = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), Msg.getMsg((Properties)Env.getCtx(), (String)"UploadFailed"));
                            pLog2.setTextMsg("User: " + upload.getAD_User().getName() + " Account: " + account.getEMail() + " Error: " + e.getMessage());
                            pLog2.setIsError(true);
                            pLog2.saveEx();
                            uploadErrors.add(pLog2.getTextMsg());
                        }
                    }
                    ++mailTemplate;
                }
            }
        }
        if ((supervisor = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getSupervisor_ID()) > 0 && (sendErrors.size() > 0 || uploadErrors.size() > 0)) {
            MUser user = new MUser(this.getCtx(), supervisor, null);
            boolean email = user.isNotificationEMail();
            boolean notice = user.isNotificationNote();
            StringBuilder errors = new StringBuilder();
            for (String error2 : sendErrors) {
                if (errors.length() > 0) {
                    errors.append("\r\n\r\n");
                }
                errors.append(error2);
            }
            for (String error2 : uploadErrors) {
                if (errors.length() > 0) {
                    errors.append("\r\n\r\n");
                }
                errors.append(error2);
            }
            if (email && !(client = MClient.get((Properties)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getCtx(), (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID())).sendEMail(from, user, schedulerName + ": " + Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerSendAttachmentFailed"), errors.toString(), null, false)) {
                summary = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerSendNotificationFailed"));
                summary.append(user.getName());
                error = (String)Env.getCtx().remove("EmailSendMsg");
                if (!Util.isEmpty((String)error)) {
                    summary.append(". Error: ").append(error);
                }
                pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), summary.toString());
                pLog.setTextMsg("From: " + from.getName() + " (" + from.getEMail() + ") To: " + user.getName() + " (" + user.getEMail() + ")");
                pLog.setIsError(true);
                pLog.saveEx();
            }
            if (notice) {
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor, null);
                note.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                note.setTextMsg(schedulerName + "\n" + errors.toString());
                note.setRecord(282, this.pi.getAD_PInstance_ID());
                note.saveEx();
            }
        }
        return this.pi.getSummary();
    }

    protected int getAD_User_ID() {
        MScheduler scheduler = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID);
        int AD_User_ID = scheduler.getSupervisor_ID() > 0 ? scheduler.getSupervisor_ID() : (scheduler.getCreatedBy() > 0 ? scheduler.getCreatedBy() : (scheduler.getUpdatedBy() > 0 ? scheduler.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    protected void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getParameters(false);
        MProcessPara[] processParams = pInstance.getProcessParameters();
        int pi = 0;
        while (pi < processParams.length) {
            MPInstancePara iPara = new MPInstancePara(pInstance, processParams[pi].getSeqNo());
            iPara.setParameterName(processParams[pi].getColumnName());
            iPara.setInfo(processParams[pi].getName());
            int np = 0;
            while (np < sParams.length) {
                MSchedulerPara sPara = sParams[np];
                if (iPara.getParameterName().equals(sPara.getColumnName())) {
                    Object toValue;
                    String paraDesc = sPara.getDescription();
                    if (paraDesc != null && paraDesc.trim().length() > 0) {
                        iPara.setInfo(sPara.getDescription());
                    }
                    String variable = sPara.getParameterDefault();
                    String toVariable = sPara.getParameterToDefault();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(sPara.getColumnName() + " = " + variable);
                    }
                    Object value = this.parseVariable((PO)sPara, variable);
                    Object object = toValue = toVariable != null ? this.parseVariable((PO)sPara, toVariable) : null;
                    if (value == null && toValue == null) {
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(sPara.getColumnName() + " - empty");
                        break;
                    }
                    if (DisplayType.isText((int)sPara.getDisplayType()) && Util.isEmpty((String)String.valueOf(value)) && Util.isEmpty((String)String.valueOf(toValue))) {
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(sPara.getColumnName() + " - empty string");
                        break;
                    }
                    try {
                        if (DisplayType.isNumeric((int)sPara.getDisplayType()) || DisplayType.isID((int)sPara.getDisplayType())) {
                            DecimalFormat decimalFormat = DisplayType.getNumberFormat((int)sPara.getDisplayType());
                            BigDecimal bd = this.toBigDecimal(value);
                            iPara.setP_Number(bd);
                            if (toValue != null) {
                                bd = this.toBigDecimal(toValue);
                                iPara.setP_Number_To(bd);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = decimalFormat.format(iPara.getP_Number());
                                if (iPara.getP_Number_To() != null) {
                                    info = (String)info + " - " + decimalFormat.format(iPara.getP_Number_To());
                                }
                                iPara.setInfo((String)info);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + String.valueOf(bd) + "=)");
                            }
                        } else if (DisplayType.isDate((int)sPara.getDisplayType())) {
                            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)sPara.getDisplayType());
                            Timestamp ts = this.toTimestamp(value);
                            iPara.setP_Date(ts);
                            if (toValue != null) {
                                ts = this.toTimestamp(toValue);
                                iPara.setP_Date_To(ts);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = dateFormat.format(iPara.getP_Date());
                                if (iPara.getP_Date_To() != null) {
                                    info = (String)info + " - " + dateFormat.format(iPara.getP_Date_To());
                                }
                                iPara.setInfo((String)info);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + String.valueOf(ts) + "=)");
                            }
                        } else {
                            iPara.setP_String(value.toString());
                            if (toValue != null) {
                                iPara.setP_String_To(toValue.toString());
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                Object info = iPara.getP_String();
                                if (iPara.getP_String_To() != null) {
                                    info = (String)info + " - " + iPara.getP_String_To();
                                }
                                iPara.setInfo((String)info);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + String.valueOf(value) + "=) " + value.getClass().getName());
                            }
                        }
                        if (iPara.save()) break;
                        this.log.warning("Not Saved - " + sPara.getColumnName());
                    }
                    catch (Exception e) {
                        this.log.warning(sPara.getColumnName() + " = " + variable + " (" + String.valueOf(value) + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                    break;
                }
                ++np;
            }
            ++pi;
        }
    }

    private Timestamp toTimestamp(Object value) {
        Timestamp ts = null;
        ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
        return ts;
    }

    private BigDecimal toBigDecimal(Object value) {
        BigDecimal bd = null;
        bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
        return bd;
    }

    private String parseFileName(PO source, String inStr) {
        StringBuilder outStr = new StringBuilder();
        int i = inStr.indexOf(64);
        while (i != -1) {
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.log(Level.INFO, "No second tag: " + inStr);
                }
                outStr.append("@");
                break;
            }
            String token = inStr.substring(0, j);
            Object value = this.parseVariable(source, "@" + token + "@");
            outStr.append(value != null ? value.toString() : " ");
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf(64);
        }
        return outStr.toString();
    }

    private Object parseVariable(PO source, String variable) {
        Object value = variable;
        if (variable == null || variable != null && variable.length() == 0) {
            value = null;
        } else if (variable.startsWith("@SQL=")) {
            String defStr;
            block29: {
                defStr = "";
                String sql = variable.substring(5);
                sql = Env.parseContext((Properties)this.getCtx(), (int)0, (String)sql, (boolean)false, (boolean)false);
                if (sql.equals("")) {
                    this.log.log(Level.WARNING, "(" + source.toString() + ") - Default SQL variable parse failed: " + variable);
                } else {
                    CPreparedStatement stmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            stmt = DB.prepareStatement((String)sql, null);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                defStr = rs.getString(1);
                            } else if (this.log.isLoggable(Level.INFO)) {
                                this.log.log(Level.INFO, "(" + source.toString() + ") - no Result: " + sql);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.WARNING, "(" + source.toString() + ") " + sql, (Throwable)e);
                            DB.close((ResultSet)rs, (Statement)stmt);
                            rs = null;
                            stmt = null;
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                }
            }
            if (!Util.isEmpty((String)defStr)) {
                value = defStr;
            }
        } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
            int index = variable.indexOf(64);
            String columnName = variable.substring(index + 1);
            if ((index = columnName.indexOf(64)) == -1) {
                this.log.warning(source.toString() + " - cannot evaluate=" + variable);
                return null;
            }
            String tail = index < columnName.length() - 1 ? columnName.substring(index + 1) : null;
            columnName = columnName.substring(0, index);
            String env = Env.getContext((Properties)this.getCtx(), (String)columnName);
            if (env == null || env.length() == 0) {
                env = Env.getContext((Properties)this.getCtx(), (String)columnName);
            }
            if (env.length() == 0) {
                this.log.warning(source.toString() + " - not in environment =" + columnName + "(" + variable + ")");
                return null;
            }
            value = env;
            if (tail != null && columnName.equals("#Date") && ((tail = tail.trim()).startsWith("-") || tail.startsWith("+"))) {
                boolean negate = tail.startsWith("-");
                int type = 5;
                if ((tail = tail.substring(1)).endsWith("d")) {
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("m")) {
                    type = 2;
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("y")) {
                    type = 1;
                    tail = tail.substring(0, tail.length() - 1);
                }
                int toApply = 0;
                try {
                    toApply = Integer.parseInt(tail);
                }
                catch (Exception exception) {}
                if (toApply > 0) {
                    if (negate) {
                        toApply *= -1;
                    }
                    Timestamp ts = this.toTimestamp(value);
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(ts.getTime());
                    cal.add(type, toApply);
                    value = new Timestamp(cal.getTimeInMillis());
                }
            }
        }
        return value;
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    protected static MScheduler get(Properties ctx, int AD_Scheduler_ID) {
        Integer key = AD_Scheduler_ID;
        MScheduler retValue = (MScheduler)s_cache.get(ctx, (Object)key, e -> new MScheduler(ctx, e));
        if (retValue == null) {
            retValue = new MScheduler(ctx, AD_Scheduler_ID, null);
            if (AD_Scheduler_ID == 0) {
                String trxName = null;
                retValue.load(trxName, new String[0]);
            }
            if (retValue.get_ID() == AD_Scheduler_ID) {
                s_cache.put((Object)key, (PO)retValue, e -> new MScheduler(Env.getCtx(), e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }
}

