-- IDEMPIERE-5075 Many oracle constraints defined as non deferrable

alter table AD_ACCESSLOG drop constraint "ADCOLUMN_ADACCESSLOG"
;

alter table AD_ACCESSLOG add constraint ADCOLUMN_ADACCESSLOG foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ACCESSLOG drop constraint "ADTABLE_ADACCESLOG"
;

alter table AD_ACCESSLOG add constraint ADTABLE_ADACCESLOG foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERT drop constraint "CALERTPROCESSOR_ADALERT"
;

alter table AD_ALERT add constraint CALERTPROCESSOR_ADALERT foreign key (AD_ALERTPROCESSOR_ID) references AD_ALERTPROCESSOR(AD_ALERTPROCESSOR_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTPROCESSOR drop constraint "ADSCHEDULE_ADALERTPROCESSOR"
;

alter table AD_ALERTPROCESSOR add constraint ADSCHEDULE_ADALERTPROCESSOR foreign key (AD_SCHEDULE_ID) references AD_SCHEDULE(AD_SCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTPROCESSOR drop constraint "ADUSER_CALERTPROCESSOR"
;

alter table AD_ALERTPROCESSOR add constraint ADUSER_CALERTPROCESSOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTPROCESSORLOG drop constraint "CALERTPROCESSOR_LOG"
;

alter table AD_ALERTPROCESSORLOG add constraint CALERTPROCESSOR_LOG foreign key (AD_ALERTPROCESSOR_ID) references AD_ALERTPROCESSOR(AD_ALERTPROCESSOR_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTRECIPIENT drop constraint "ADALERT_ADALERTRECIPIENT"
;

alter table AD_ALERTRECIPIENT add constraint ADALERT_ADALERTRECIPIENT foreign key (AD_ALERT_ID) references AD_ALERT(AD_ALERT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTRECIPIENT drop constraint "ADROLE_ADALTERTRECIPIENT"
;

alter table AD_ALERTRECIPIENT add constraint ADROLE_ADALTERTRECIPIENT foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTRECIPIENT drop constraint "ADUSER_ADALERTRECIPIENT"
;

alter table AD_ALERTRECIPIENT add constraint ADUSER_ADALERTRECIPIENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTRULE drop constraint "ADALTERT_ARALERTRULE"
;

alter table AD_ALERTRULE add constraint ADALTERT_ARALERTRULE foreign key (AD_ALERT_ID) references AD_ALERT(AD_ALERT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ALERTRULE drop constraint "ADTABLE_ADALTERTRULE"
;

alter table AD_ALERTRULE add constraint ADTABLE_ADALTERTRULE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ARCHIVE drop constraint "ADPROCESS_ADARCHIVE"
;

alter table AD_ARCHIVE add constraint ADPROCESS_ADARCHIVE foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ARCHIVE drop constraint "ADTABLE_ADARCHIVE"
;

alter table AD_ARCHIVE add constraint ADTABLE_ADARCHIVE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ARCHIVE drop constraint "CBPARTNER_ADARCHIVE"
;

alter table AD_ARCHIVE add constraint CBPARTNER_ADARCHIVE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTACHMENT drop constraint "ADTABLE_ADATTACHMENT"
;

alter table AD_ATTACHMENT add constraint ADTABLE_ADATTACHMENT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTACHMENTNOTE drop constraint "ADATTACHMENT_NOTE"
;

alter table AD_ATTACHMENTNOTE add constraint ADATTACHMENT_NOTE foreign key (AD_ATTACHMENT_ID) references AD_ATTACHMENT(AD_ATTACHMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTACHMENTNOTE drop constraint "ADUSER_ADATTACHMENTNOTE"
;

alter table AD_ATTACHMENTNOTE add constraint ADUSER_ADATTACHMENTNOTE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTRIBUTE drop constraint "ADREFERENCEVALUE_ADATTRIBUTE"
;

alter table AD_ATTRIBUTE add constraint ADREFERENCEVALUE_ADATTRIBUTE foreign key (AD_REFERENCE_VALUE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTRIBUTE drop constraint "ADREFERENCE_ADATTRIBUTE"
;

alter table AD_ATTRIBUTE add constraint ADREFERENCE_ADATTRIBUTE foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTRIBUTE drop constraint "ADTABLE_ADATTRIBUTE"
;

alter table AD_ATTRIBUTE add constraint ADTABLE_ADATTRIBUTE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTRIBUTE drop constraint "ADVALRULE_ADATTRIBUTE"
;

alter table AD_ATTRIBUTE add constraint ADVALRULE_ADATTRIBUTE foreign key (AD_VAL_RULE_ID) references AD_VAL_RULE(AD_VAL_RULE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ATTRIBUTE_VALUE drop constraint "ADATTRIBUTE_ADATTRIBUTEVALUE"
;

alter table AD_ATTRIBUTE_VALUE add constraint ADATTRIBUTE_ADATTRIBUTEVALUE foreign key (AD_ATTRIBUTE_ID) references AD_ATTRIBUTE(AD_ATTRIBUTE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CHANGELOG drop constraint "ADCOLUMN_ADCHANGELOG"
;

alter table AD_CHANGELOG add constraint ADCOLUMN_ADCHANGELOG foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CHANGELOG drop constraint "ADSESSION_ADCHANGELOG"
;

alter table AD_CHANGELOG add constraint ADSESSION_ADCHANGELOG foreign key (AD_SESSION_ID) references AD_SESSION(AD_SESSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CHANGELOG drop constraint "ADTABLE_ADCHANGELOG"
;

alter table AD_CHANGELOG add constraint ADTABLE_ADCHANGELOG foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENT drop constraint "ADLANGU_ADCLIENT"
;

alter table AD_CLIENT add constraint ADLANGU_ADCLIENT foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENT drop constraint "ADPASSWORDRULE_ADCLIENT"
;

alter table AD_CLIENT add constraint ADPASSWORDRULE_ADCLIENT foreign key (AD_PASSWORDRULE_ID) references AD_PASSWORDRULE(AD_PASSWORDRULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENT drop constraint "ADREPLICATIONSTRATEGY_ADCLIENT"
;

alter table AD_CLIENT add constraint ADREPLICATIONSTRATEGY_ADCLIENT foreign key (AD_REPLICATIONSTRATEGY_ID) references AD_REPLICATIONSTRATEGY(AD_REPLICATIONSTRATEGY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADCLIENT_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADCLIENT_ADCLIENTINFO foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEACTIVITY_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEACTIVITY_ADCLIENTINFO foreign key (AD_TREE_ACTIVITY_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEBPARTNER_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEBPARTNER_ADCLIENTINFO foreign key (AD_TREE_BPARTNER_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREECAMPAIGN_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREECAMPAIGN_ADCLIENTINFO foreign key (AD_TREE_CAMPAIGN_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEMENU_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEMENU_ADCLIENTINFO foreign key (AD_TREE_MENU_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEORG_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEORG_ADCLIENTINFO foreign key (AD_TREE_ORG_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEPRODUCT_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEPRODUCT_ADCLIENTINFO foreign key (AD_TREE_PRODUCT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREEPROJECT_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREEPROJECT_ADCLIENTINFO foreign key (AD_TREE_PROJECT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "ADTREESALESREG_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint ADTREESALESREG_ADCLIENTINFO foreign key (AD_TREE_SALESREGION_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "CACCTSCHEMA1_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint CACCTSCHEMA1_ADCLIENTINFO foreign key (C_ACCTSCHEMA1_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "CBPARTNERCASHTRX_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint CBPARTNERCASHTRX_ADCLIENTINFO foreign key (C_BPARTNERCASHTRX_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "CCALENDAR_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint CCALENDAR_ADCLIENTINFO foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "C_UOM_LENGTH_AD_CLIENTINFO"
;

alter table AD_CLIENTINFO add constraint C_UOM_LENGTH_AD_CLIENTINFO foreign key (C_UOM_LENGTH_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "C_UOM_TIME_AD_CLIENTINFO"
;

alter table AD_CLIENTINFO add constraint C_UOM_TIME_AD_CLIENTINFO foreign key (C_UOM_TIME_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "C_UOM_VOLUME_AD_CLIENTINFO"
;

alter table AD_CLIENTINFO add constraint C_UOM_VOLUME_AD_CLIENTINFO foreign key (C_UOM_VOLUME_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "C_UOM_WEIGHT_AD_CLIENTINFO"
;

alter table AD_CLIENTINFO add constraint C_UOM_WEIGHT_AD_CLIENTINFO foreign key (C_UOM_WEIGHT_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "LOGOREPORT_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint LOGOREPORT_ADCLIENTINFO foreign key (LOGOREPORT_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "LOGOWEB_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint LOGOWEB_ADCLIENTINFO foreign key (LOGOWEB_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "LOGO_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint LOGO_ADCLIENTINFO foreign key (LOGO_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTINFO drop constraint "MPRODUCTFREIGHT_ADCLIENTINFO"
;

alter table AD_CLIENTINFO add constraint MPRODUCTFREIGHT_ADCLIENTINFO foreign key (M_PRODUCTFREIGHT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTSHARE drop constraint "ADCLIENT_ADCLIENTSHARE"
;

alter table AD_CLIENTSHARE add constraint ADCLIENT_ADCLIENTSHARE foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTSHARE drop constraint "ADORG_ADCLIENTSHARE"
;

alter table AD_CLIENTSHARE add constraint ADORG_ADCLIENTSHARE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_CLIENTSHARE drop constraint "ADTABLE_ADCLIENTSHARE"
;

alter table AD_CLIENTSHARE add constraint ADTABLE_ADCLIENTSHARE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLOR drop constraint "ADIMAGE_ADCOLOR"
;

alter table AD_COLOR add constraint ADIMAGE_ADCOLOR foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "ADPROCESS_ADCOLUMN"
;

alter table AD_COLUMN add constraint ADPROCESS_ADCOLUMN foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "AD_ELEMENT_AD_COLUMN"
;

alter table AD_COLUMN add constraint AD_ELEMENT_AD_COLUMN foreign key (AD_ELEMENT_ID) references AD_ELEMENT(AD_ELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "AD_REFERENCE_COLUMNDATATYPE"
;

alter table AD_COLUMN add constraint AD_REFERENCE_COLUMNDATATYPE foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "AD_REFERENCE_COLUMNVALUE"
;

alter table AD_COLUMN add constraint AD_REFERENCE_COLUMNVALUE foreign key (AD_REFERENCE_VALUE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "AD_TABLE_COLUMN"
;

alter table AD_COLUMN add constraint AD_TABLE_COLUMN foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "AD_VALRULE_COLUMN"
;

alter table AD_COLUMN add constraint AD_VALRULE_COLUMN foreign key (AD_VAL_RULE_ID) references AD_VAL_RULE(AD_VAL_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "COLUMNCLIENT"
;

alter table AD_COLUMN add constraint COLUMNCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "COLUMNORG"
;

alter table AD_COLUMN add constraint COLUMNORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN drop constraint "ENTITYT_ADCOLUMN"
;

alter table AD_COLUMN add constraint ENTITYT_ADCOLUMN foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN_ACCESS drop constraint "ADCOLUMN_ADCOLUMNACCESS"
;

alter table AD_COLUMN_ACCESS add constraint ADCOLUMN_ADCOLUMNACCESS foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN_ACCESS drop constraint "ADROLE_ADCOLUMNACCESS"
;

alter table AD_COLUMN_ACCESS add constraint ADROLE_ADCOLUMNACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN_ACCESS drop constraint "ADTABLE_ADCOLUMNACCESS"
;

alter table AD_COLUMN_ACCESS add constraint ADTABLE_ADCOLUMNACCESS foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN_TRL drop constraint "ADCOLUMN_ADCOLUMNTRL"
;

alter table AD_COLUMN_TRL add constraint ADCOLUMN_ADCOLUMNTRL foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_COLUMN_TRL drop constraint "ADLANGUAGE_ADCOLUMNTRL"
;

alter table AD_COLUMN_TRL add constraint ADLANGUAGE_ADCOLUMNTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOP drop constraint "ADCOLOR_ADDESKTOP"
;

alter table AD_DESKTOP add constraint ADCOLOR_ADDESKTOP foreign key (AD_COLOR_ID) references AD_COLOR(AD_COLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOP drop constraint "ADIMAGE_ADDESKTOP"
;

alter table AD_DESKTOP add constraint ADIMAGE_ADDESKTOP foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOPWORKBENCH drop constraint "ADDESKTOP_ADDESKTOPWB"
;

alter table AD_DESKTOPWORKBENCH add constraint ADDESKTOP_ADDESKTOPWB foreign key (AD_DESKTOP_ID) references AD_DESKTOP(AD_DESKTOP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOPWORKBENCH drop constraint "ADWORKBENCH_ADDESKTOPWB"
;

alter table AD_DESKTOPWORKBENCH add constraint ADWORKBENCH_ADDESKTOPWB foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOP_TRL drop constraint "ADDESKTOP_ADDESKTOPTRL"
;

alter table AD_DESKTOP_TRL add constraint ADDESKTOP_ADDESKTOPTRL foreign key (AD_DESKTOP_ID) references AD_DESKTOP(AD_DESKTOP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DESKTOP_TRL drop constraint "ADLANGUAGE_ADDESKTOPTRL"
;

alter table AD_DESKTOP_TRL add constraint ADLANGUAGE_ADDESKTOPTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DOCUMENT_ACTION_ACCESS drop constraint "ADREFLIST_ADDOCUMENTACTIONACCE"
;

alter table AD_DOCUMENT_ACTION_ACCESS add constraint ADREFLIST_ADDOCUMENTACTIONACCE foreign key (AD_REF_LIST_ID) references AD_REF_LIST(AD_REF_LIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DOCUMENT_ACTION_ACCESS drop constraint "ADROLE_ADDOCUMENTACTIONACCESS"
;

alter table AD_DOCUMENT_ACTION_ACCESS add constraint ADROLE_ADDOCUMENTACTIONACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_DOCUMENT_ACTION_ACCESS drop constraint "CDOCTYPE_ADDOCUMENTACTIONACCES"
;

alter table AD_DOCUMENT_ACTION_ACCESS add constraint CDOCTYPE_ADDOCUMENTACTIONACCES foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ELEMENT drop constraint "ENTITYT_ADELEMENT"
;

alter table AD_ELEMENT add constraint ENTITYT_ADELEMENT foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ELEMENT_TRL drop constraint "ADELEMENT_ADELEMENTTRL"
;

alter table AD_ELEMENT_TRL add constraint ADELEMENT_ADELEMENTTRL foreign key (AD_ELEMENT_ID) references AD_ELEMENT(AD_ELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ELEMENT_TRL drop constraint "AD_LANGUAGE_AD_ELEMENT_TRL"
;

alter table AD_ELEMENT_TRL add constraint AD_LANGUAGE_AD_ELEMENT_TRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ERROR drop constraint "ADLANGU_ADERROR"
;

alter table AD_ERROR add constraint ADLANGU_ADERROR foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "ADFIELDGROUP_ADFIELD"
;

alter table AD_FIELD add constraint ADFIELDGROUP_ADFIELD foreign key (AD_FIELDGROUP_ID) references AD_FIELDGROUP(AD_FIELDGROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "ADREFERENCEVALUE_ADFIELD"
;

alter table AD_FIELD add constraint ADREFERENCEVALUE_ADFIELD foreign key (AD_REFERENCE_VALUE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "ADREFERENCE_ADFIELD"
;

alter table AD_FIELD add constraint ADREFERENCE_ADFIELD foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "ADVALRULE_ADFIELD"
;

alter table AD_FIELD add constraint ADVALRULE_ADFIELD foreign key (AD_VAL_RULE_ID) references AD_VAL_RULE(AD_VAL_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "AD_COLUMN_FIELD"
;

alter table AD_FIELD add constraint AD_COLUMN_FIELD foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "AD_TAB_FIELD"
;

alter table AD_FIELD add constraint AD_TAB_FIELD foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "ENTITYT_ADFIELD"
;

alter table AD_FIELD add constraint ENTITYT_ADFIELD foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "FIELDCLIENT"
;

alter table AD_FIELD add constraint FIELDCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "FIELDORG"
;

alter table AD_FIELD add constraint FIELDORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD drop constraint "INCLUDEDTAB_ADFIELD"
;

alter table AD_FIELD add constraint INCLUDEDTAB_ADFIELD foreign key (INCLUDED_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELDGROUP drop constraint "ENTITYT_ADFIELDGROUP"
;

alter table AD_FIELDGROUP add constraint ENTITYT_ADFIELDGROUP foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELDGROUP_TRL drop constraint "ADLANGUAGE_ADFIELDGROUPTRL"
;

alter table AD_FIELDGROUP_TRL add constraint ADLANGUAGE_ADFIELDGROUPTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD_TRL drop constraint "AD_FIELDTRL"
;

alter table AD_FIELD_TRL add constraint AD_FIELDTRL foreign key (AD_FIELD_ID) references AD_FIELD(AD_FIELD_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIELD_TRL drop constraint "AD_LANGUAGE_FIELDTRL"
;

alter table AD_FIELD_TRL add constraint AD_LANGUAGE_FIELDTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FIND drop constraint "ADCOLUMN_ADFIND"
;

alter table AD_FIND add constraint ADCOLUMN_ADFIND foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FORM drop constraint "ENTITYT_ADFORM"
;

alter table AD_FORM add constraint ENTITYT_ADFORM foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FORM_ACCESS drop constraint "ADFORM_ADFORMACCESS"
;

alter table AD_FORM_ACCESS add constraint ADFORM_ADFORMACCESS foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FORM_ACCESS drop constraint "ADROLE_ADFORMACCESS"
;

alter table AD_FORM_ACCESS add constraint ADROLE_ADFORMACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FORM_TRL drop constraint "ADFORM_ADFORMTRL"
;

alter table AD_FORM_TRL add constraint ADFORM_ADFORMTRL foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_FORM_TRL drop constraint "ADLANGUAGE_ADFORMTRL"
;

alter table AD_FORM_TRL add constraint ADLANGUAGE_ADFORMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_HOUSEKEEPING drop constraint "ADTABLE_ADHOUSEKEEPING"
;

alter table AD_HOUSEKEEPING add constraint ADTABLE_ADHOUSEKEEPING foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_IMAGE drop constraint "ENTITYT_ADIMAGE"
;

alter table AD_IMAGE add constraint ENTITYT_ADIMAGE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_IMPFORMAT drop constraint "ADTABLE_ADIMPFORMAT"
;

alter table AD_IMPFORMAT add constraint ADTABLE_ADIMPFORMAT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_IMPFORMAT_ROW drop constraint "ADCOLUMN_ADIMPFORMATROW"
;

alter table AD_IMPFORMAT_ROW add constraint ADCOLUMN_ADIMPFORMATROW foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_IMPFORMAT_ROW drop constraint "ADIMPFORMAT_ADIMPFORMATROW"
;

alter table AD_IMPFORMAT_ROW add constraint ADIMPFORMAT_ADIMPFORMATROW foreign key (AD_IMPFORMAT_ID) references AD_IMPFORMAT(AD_IMPFORMAT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN drop constraint "ADELEMENT_ADINFOCOLUMN"
;

alter table AD_INFOCOLUMN add constraint ADELEMENT_ADINFOCOLUMN foreign key (AD_ELEMENT_ID) references AD_ELEMENT(AD_ELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN drop constraint "ADINFOWINDOW_ADINFOCOLUMN"
;

alter table AD_INFOCOLUMN add constraint ADINFOWINDOW_ADINFOCOLUMN foreign key (AD_INFOWINDOW_ID) references AD_INFOWINDOW(AD_INFOWINDOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN drop constraint "ADREFERENCE_ADINFOCOLUMN"
;

alter table AD_INFOCOLUMN add constraint ADREFERENCE_ADINFOCOLUMN foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN drop constraint "ENTITYT_ADINFOCOLUMN"
;

alter table AD_INFOCOLUMN add constraint ENTITYT_ADINFOCOLUMN foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN_TRL drop constraint "ADINFOCOLUMN_ADINFOCOLUMNTRL"
;

alter table AD_INFOCOLUMN_TRL add constraint ADINFOCOLUMN_ADINFOCOLUMNTRL foreign key (AD_INFOCOLUMN_ID) references AD_INFOCOLUMN(AD_INFOCOLUMN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOCOLUMN_TRL drop constraint "ADLANGUAGE_ADINFOCOLUMNTRL"
;

alter table AD_INFOCOLUMN_TRL add constraint ADLANGUAGE_ADINFOCOLUMNTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOWINDOW drop constraint "ADTABLE_ADINFOWINDOW"
;

alter table AD_INFOWINDOW add constraint ADTABLE_ADINFOWINDOW foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOWINDOW drop constraint "ENTITYT_ADINFOWINDOW"
;

alter table AD_INFOWINDOW add constraint ENTITYT_ADINFOWINDOW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOWINDOW_TRL drop constraint "ADINFOWINDOW_ADINFOWINDOWTRL"
;

alter table AD_INFOWINDOW_TRL add constraint ADINFOWINDOW_ADINFOWINDOWTRL foreign key (AD_INFOWINDOW_ID) references AD_INFOWINDOW(AD_INFOWINDOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_INFOWINDOW_TRL drop constraint "ADLANGUAGE_ADINFOWINDOWTRL"
;

alter table AD_INFOWINDOW_TRL add constraint ADLANGUAGE_ADINFOWINDOWTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "AASSET_ADISSUE"
;

alter table AD_ISSUE add constraint AASSET_ADISSUE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "ADFORM_ADISSUE"
;

alter table AD_ISSUE add constraint ADFORM_ADISSUE foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "ADPROCESS_ADISSUE"
;

alter table AD_ISSUE add constraint ADPROCESS_ADISSUE foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "ADWINDOW_ADISSUE"
;

alter table AD_ISSUE add constraint ADWINDOW_ADISSUE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "RISSUEPROJECT_ADISSUE"
;

alter table AD_ISSUE add constraint RISSUEPROJECT_ADISSUE foreign key (R_ISSUEPROJECT_ID) references R_ISSUEPROJECT(R_ISSUEPROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "RISSUESYSTEM_AD_ISSUE"
;

alter table AD_ISSUE add constraint RISSUESYSTEM_AD_ISSUE foreign key (R_ISSUESYSTEM_ID) references R_ISSUESYSTEM(R_ISSUESYSTEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "RISSUEUSER_ADISSUE"
;

alter table AD_ISSUE add constraint RISSUEUSER_ADISSUE foreign key (R_ISSUEUSER_ID) references R_ISSUEUSER(R_ISSUEUSER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "RKNOWNISSUE_ADISSUE"
;

alter table AD_ISSUE add constraint RKNOWNISSUE_ADISSUE foreign key (R_ISSUEKNOWN_ID) references R_ISSUEKNOWN(R_ISSUEKNOWN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ISSUE drop constraint "RREQUEST_ADISSUE"
;

alter table AD_ISSUE add constraint RREQUEST_ADISSUE foreign key (R_REQUEST_ID) references R_REQUEST(R_REQUEST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LABELPRINTERFUNCTION drop constraint "ADLABELPRINTER_FUNCTION"
;

alter table AD_LABELPRINTERFUNCTION add constraint ADLABELPRINTER_FUNCTION foreign key (AD_LABELPRINTER_ID) references AD_LABELPRINTER(AD_LABELPRINTER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LANGUAGE drop constraint "LANGUAGECLIENT"
;

alter table AD_LANGUAGE add constraint LANGUAGECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LANGUAGE drop constraint "LANGUAGEORG"
;

alter table AD_LANGUAGE add constraint LANGUAGEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LDAPACCESS drop constraint "ADLDAPPROCESSOR_ADLDAPACCESS"
;

alter table AD_LDAPACCESS add constraint ADLDAPPROCESSOR_ADLDAPACCESS foreign key (AD_LDAPPROCESSOR_ID) references AD_LDAPPROCESSOR(AD_LDAPPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LDAPACCESS drop constraint "ADUSER_ADLDAPACCESS"
;

alter table AD_LDAPACCESS add constraint ADUSER_ADLDAPACCESS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LDAPACCESS drop constraint "RINTERESTAREA_ADLDAPACCESS"
;

alter table AD_LDAPACCESS add constraint RINTERESTAREA_ADLDAPACCESS foreign key (R_INTERESTAREA_ID) references R_INTERESTAREA(R_INTERESTAREA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LDAPPROCESSOR drop constraint "ADUSER_ADLDAPPROCESSOR"
;

alter table AD_LDAPPROCESSOR add constraint ADUSER_ADLDAPPROCESSOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_LDAPPROCESSORLOG drop constraint "ADLDAPPROCESSOR_ADLDAPPROCLOG"
;

alter table AD_LDAPPROCESSORLOG add constraint ADLDAPPROCESSOR_ADLDAPPROCLOG foreign key (AD_LDAPPROCESSOR_ID) references AD_LDAPPROCESSOR(AD_LDAPPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADCLIENT_ADMENU"
;

alter table AD_MENU add constraint ADCLIENT_ADMENU foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADFORM_ADMENU"
;

alter table AD_MENU add constraint ADFORM_ADMENU foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADMENU_ADWORKBENCH"
;

alter table AD_MENU add constraint ADMENU_ADWORKBENCH foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADPROCESS_ADMENU"
;

alter table AD_MENU add constraint ADPROCESS_ADMENU foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADTASK_ADMENU"
;

alter table AD_MENU add constraint ADTASK_ADMENU foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADWINDOW_ADMENU"
;

alter table AD_MENU add constraint ADWINDOW_ADMENU foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ADWORKFLOW_ADMENU"
;

alter table AD_MENU add constraint ADWORKFLOW_ADMENU foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "AD_MENU_ORG"
;

alter table AD_MENU add constraint AD_MENU_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU drop constraint "ENTITYT_ADMENU"
;

alter table AD_MENU add constraint ENTITYT_ADMENU foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU_TRL drop constraint "AD_LANGUAGE_MENUTRL"
;

alter table AD_MENU_TRL add constraint AD_LANGUAGE_MENUTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MENU_TRL drop constraint "AD_MENUTRL"
;

alter table AD_MENU_TRL add constraint AD_MENUTRL foreign key (AD_MENU_ID) references AD_MENU(AD_MENU_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MESSAGE drop constraint "ENTITYT_ADMESSAGE"
;

alter table AD_MESSAGE add constraint ENTITYT_ADMESSAGE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MESSAGE drop constraint "MESSAGECLIENT"
;

alter table AD_MESSAGE add constraint MESSAGECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MESSAGE drop constraint "MESSAGEORG"
;

alter table AD_MESSAGE add constraint MESSAGEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MESSAGE_TRL drop constraint "AD_LANGUAGE_MESSAGETRL"
;

alter table AD_MESSAGE_TRL add constraint AD_LANGUAGE_MESSAGETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MESSAGE_TRL drop constraint "AD_MESSAGETRL"
;

alter table AD_MESSAGE_TRL add constraint AD_MESSAGETRL foreign key (AD_MESSAGE_ID) references AD_MESSAGE(AD_MESSAGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MODELVALIDATOR drop constraint "ENTITYT_ADMODELVALIDATOR"
;

alter table AD_MODELVALIDATOR add constraint ENTITYT_ADMODELVALIDATOR foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_MODIFICATION drop constraint "ADENRITYTYPE_ADMODIFICATION"
;

alter table AD_MODIFICATION add constraint ADENRITYTYPE_ADMODIFICATION foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_NOTE drop constraint "ADMESSAGE_ADNOTE"
;

alter table AD_NOTE add constraint ADMESSAGE_ADNOTE foreign key (AD_MESSAGE_ID) references AD_MESSAGE(AD_MESSAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_NOTE drop constraint "ADTABLE_ADNOTE"
;

alter table AD_NOTE add constraint ADTABLE_ADNOTE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_NOTE drop constraint "ADUSER_ADNOTE"
;

alter table AD_NOTE add constraint ADUSER_ADNOTE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_NOTE drop constraint "ADWFACTIVITY_ADNOTE"
;

alter table AD_NOTE add constraint ADWFACTIVITY_ADNOTE foreign key (AD_WF_ACTIVITY_ID) references AD_WF_ACTIVITY(AD_WF_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORG drop constraint "ADCLIENT_ADORG"
;

alter table AD_ORG add constraint ADCLIENT_ADORG foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORG drop constraint "AD_ORG__AD_REPLI_AD_REPLICA"
;

alter table AD_ORG add constraint AD_ORG__AD_REPLI_AD_REPLICA foreign key (AD_REPLICATIONSTRATEGY_ID) references AD_REPLICATIONSTRATEGY(AD_REPLICATIONSTRATEGY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "ADORGPARENT_ADORGINFO"
;

alter table AD_ORGINFO add constraint ADORGPARENT_ADORGINFO foreign key (PARENT_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "ADORGTYPE_ADORGINFO"
;

alter table AD_ORGINFO add constraint ADORGTYPE_ADORGINFO foreign key (AD_ORGTYPE_ID) references AD_ORGTYPE(AD_ORGTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "ADORG_ADORGINFO"
;

alter table AD_ORGINFO add constraint ADORG_ADORGINFO foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "ADUSER_ADORGINFO"
;

alter table AD_ORGINFO add constraint ADUSER_ADORGINFO foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "CCALENDAR_ADORGINFO"
;

alter table AD_ORGINFO add constraint CCALENDAR_ADORGINFO foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "C_LOCATION_AD_ORGINFO"
;

alter table AD_ORGINFO add constraint C_LOCATION_AD_ORGINFO foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "DROPSHIPWAREHOUSE_ADORGINFO"
;

alter table AD_ORGINFO add constraint DROPSHIPWAREHOUSE_ADORGINFO foreign key (DROPSHIP_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "LOGO_ADORGINFO"
;

alter table AD_ORGINFO add constraint LOGO_ADORGINFO foreign key (LOGO_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "MWAREHOUSE_ADORGINFO"
;

alter table AD_ORGINFO add constraint MWAREHOUSE_ADORGINFO foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "cbank_adorginfo"
;

alter table AD_ORGINFO add constraint cbank_adorginfo foreign key (TRANSFERBANK_ID) references C_BANK(C_BANK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGINFO drop constraint "ccashbook_adorginfo"
;

alter table AD_ORGINFO add constraint ccashbook_adorginfo foreign key (TRANSFERCASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ORGTYPE drop constraint "ADPRINTCOLOR_ADORGTYPE"
;

alter table AD_ORGTYPE add constraint ADPRINTCOLOR_ADORGTYPE foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADFORM_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADFORM_ADPACKAGEEXPCOMMON foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADIMPFORMAT_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADIMPFORMAT_ADPACKAGEEXPCOMMON foreign key (AD_IMPFORMAT_ID) references AD_IMPFORMAT(AD_IMPFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADMENU_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADMENU_ADPACKAGEEXPCOMMON foreign key (AD_MENU_ID) references AD_MENU(AD_MENU_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADPROCESS_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADPROCESS_ADPACKAGEEXPCOMMON foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADREPORTVIEW_ADPACKAGEEXPCOMMO"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADREPORTVIEW_ADPACKAGEEXPCOMMO foreign key (AD_REPORTVIEW_ID) references AD_REPORTVIEW(AD_REPORTVIEW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADROLE_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADROLE_ADPACKAGEEXPCOMMON foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADTABLE_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADTABLE_ADPACKAGEEXPCOMMON foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADWINDOW_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADWINDOW_ADPACKAGEEXPCOMMON foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADWORKBENCH_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADWORKBENCH_ADPACKAGEEXPCOMMON foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_COMMON drop constraint "ADWORKFLOW_ADPACKAGEEXPCOMMON"
;

alter table AD_PACKAGE_EXP_COMMON add constraint ADWORKFLOW_ADPACKAGEEXPCOMMON foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADFORM_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADFORM_ADPACKAGEEXPDETAIL foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADIMPFORMAT_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADIMPFORMAT_ADPACKAGEEXPDETAIL foreign key (AD_IMPFORMAT_ID) references AD_IMPFORMAT(AD_IMPFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADMENU_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADMENU_ADPACKAGEEXPDETAIL foreign key (AD_MENU_ID) references AD_MENU(AD_MENU_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADMESSAGE_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADMESSAGE_ADPACKAGEEXPDETAIL foreign key (AD_MESSAGE_ID) references AD_MESSAGE(AD_MESSAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADMODVAL_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADMODVAL_ADPACKAGEEXPDETAIL foreign key (AD_MODELVALIDATOR_ID) references AD_MODELVALIDATOR(AD_MODELVALIDATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADPACKAGEEXP_ADPACKAGEEXPDETAI"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADPACKAGEEXP_ADPACKAGEEXPDETAI foreign key (AD_PACKAGE_EXP_ID) references AD_PACKAGE_EXP(AD_PACKAGE_EXP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADPRINTFORMAT_ADPACKAGEEXPDETA"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADPRINTFORMAT_ADPACKAGEEXPDETA foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADPROCESS_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADPROCESS_ADPACKAGEEXPDETAIL foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADREFERENCE_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADREFERENCE_ADPACKAGEEXPDETAIL foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADREPORTVIEW_ADPACKAGEEXPDETAI"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADREPORTVIEW_ADPACKAGEEXPDETAI foreign key (AD_REPORTVIEW_ID) references AD_REPORTVIEW(AD_REPORTVIEW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADROLE_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADROLE_ADPACKAGEEXPDETAIL foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADTABLE_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADTABLE_ADPACKAGEEXPDETAIL foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADWINDOW_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADWINDOW_ADPACKAGEEXPDETAIL foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADWORKBENCH_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADWORKBENCH_ADPACKAGEEXPDETAIL foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_EXP_DETAIL drop constraint "ADWORKFLOW_ADPACKAGEEXPDETAIL"
;

alter table AD_PACKAGE_EXP_DETAIL add constraint ADWORKFLOW_ADPACKAGEEXPDETAIL foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_IMP_BACKUP drop constraint "ADCOLUMN_ADPACKAGEIMPBACKUP"
;

alter table AD_PACKAGE_IMP_BACKUP add constraint ADCOLUMN_ADPACKAGEIMPBACKUP foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PACKAGE_IMP_BACKUP drop constraint "ADREFERENCE_ADPACKAGEIMPBACKUP"
;

alter table AD_PACKAGE_IMP_BACKUP add constraint ADREFERENCE_ADPACKAGEIMPBACKUP foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PINSTANCE drop constraint "ADPROCESS_ADPINSTANCE"
;

alter table AD_PINSTANCE add constraint ADPROCESS_ADPINSTANCE foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PINSTANCE drop constraint "ADUSER_PINSTANCE"
;

alter table AD_PINSTANCE add constraint ADUSER_PINSTANCE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PINSTANCE_LOG drop constraint "ADPINSTANCE_PILOG"
;

alter table AD_PINSTANCE_LOG add constraint ADPINSTANCE_PILOG foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PINSTANCE_LOG drop constraint "ADTABLE_ADPINSTANCELOG"
;

alter table AD_PINSTANCE_LOG add constraint ADTABLE_ADPINSTANCELOG foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PINSTANCE_PARA drop constraint "ADPINSTANCE_ADPINSTANCEPARA"
;

alter table AD_PINSTANCE_PARA add constraint ADPINSTANCE_ADPINSTANCEPARA foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PREFERENCE drop constraint "AD_PREFERENCE_CLIENT"
;

alter table AD_PREFERENCE add constraint AD_PREFERENCE_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PREFERENCE drop constraint "AD_PREFERENCE_ORG"
;

alter table AD_PREFERENCE add constraint AD_PREFERENCE_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PREFERENCE drop constraint "AD_USER_PREFERENCE"
;

alter table AD_PREFERENCE add constraint AD_USER_PREFERENCE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PREFERENCE drop constraint "AD_WINDOW_PREFERENCE"
;

alter table AD_PREFERENCE add constraint AD_WINDOW_PREFERENCE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADCLIENT_ADPRINTFORM"
;

alter table AD_PRINTFORM add constraint ADCLIENT_ADPRINTFORM foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADPRINTFORMAT_FORMINVOICE"
;

alter table AD_PRINTFORM add constraint ADPRINTFORMAT_FORMINVOICE foreign key (INVOICE_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADPRINTFORMAT_FORMORDER"
;

alter table AD_PRINTFORM add constraint ADPRINTFORMAT_FORMORDER foreign key (ORDER_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADPRINTFORMAT_FORMPROJECT"
;

alter table AD_PRINTFORM add constraint ADPRINTFORMAT_FORMPROJECT foreign key (PROJECT_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADPRINTFORMAT_FORMREMITTANCE"
;

alter table AD_PRINTFORM add constraint ADPRINTFORMAT_FORMREMITTANCE foreign key (REMITTANCE_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "ADPRINTFORMAT_FORMSHIPMENT"
;

alter table AD_PRINTFORM add constraint ADPRINTFORMAT_FORMSHIPMENT foreign key (SHIPMENT_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "DISTRIBORDERMAILTEXT_ADPRINTFO"
;

alter table AD_PRINTFORM add constraint DISTRIBORDERMAILTEXT_ADPRINTFO foreign key (DISTRIB_ORDER_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "DISTRIBORDERPRINTFORMAT_ADPRIN"
;

alter table AD_PRINTFORM add constraint DISTRIBORDERPRINTFORMAT_ADPRIN foreign key (DISTRIB_ORDER_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "MANUFORDERMAILTEXT_ADPRINTFORM"
;

alter table AD_PRINTFORM add constraint MANUFORDERMAILTEXT_ADPRINTFORM foreign key (MANUF_ORDER_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "MANUFORDERPRINTFORMAT_ADPRINTF"
;

alter table AD_PRINTFORM add constraint MANUFORDERPRINTFORMAT_ADPRINTF foreign key (MANUF_ORDER_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "RMAILTEXT_INVOICEADPRINTFORM"
;

alter table AD_PRINTFORM add constraint RMAILTEXT_INVOICEADPRINTFORM foreign key (INVOICE_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "RMAILTEXT_ORDERADPRINTFORM"
;

alter table AD_PRINTFORM add constraint RMAILTEXT_ORDERADPRINTFORM foreign key (ORDER_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "RMAILTEXT_PROJECTADPRINTFORM"
;

alter table AD_PRINTFORM add constraint RMAILTEXT_PROJECTADPRINTFORM foreign key (PROJECT_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "RMAILTEXT_REMITADPRINTFORM"
;

alter table AD_PRINTFORM add constraint RMAILTEXT_REMITADPRINTFORM foreign key (REMITTANCE_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORM drop constraint "RMAILTEXT_SHIPADPRINTFORM"
;

alter table AD_PRINTFORM add constraint RMAILTEXT_SHIPADPRINTFORM foreign key (SHIPMENT_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "ADPRINTCOLOR_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint ADPRINTCOLOR_ADPRINTFORMAT foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "ADPRINTFORMATTABLE_FORMAT"
;

alter table AD_PRINTFORMAT add constraint ADPRINTFORMATTABLE_FORMAT foreign key (AD_PRINTTABLEFORMAT_ID) references AD_PRINTTABLEFORMAT(AD_PRINTTABLEFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "ADPRINTPAPER_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint ADPRINTPAPER_ADPRINTFORMAT foreign key (AD_PRINTPAPER_ID) references AD_PRINTPAPER(AD_PRINTPAPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "ADPRINTVIEW_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint ADPRINTVIEW_ADPRINTFORMAT foreign key (AD_REPORTVIEW_ID) references AD_REPORTVIEW(AD_REPORTVIEW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "ADTABLE_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint ADTABLE_ADPRINTFORMAT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "AD_PRINTFONT_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint AD_PRINTFONT_ADPRINTFORMAT foreign key (AD_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMAT drop constraint "JASPERPROCESS_ADPRINTFORMAT"
;

alter table AD_PRINTFORMAT add constraint JASPERPROCESS_ADPRINTFORMAT foreign key (JASPERPROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM drop constraint "ADPRINTCOLOR_ADPRINTFORMATITEM"
;

alter table AD_PRINTFORMATITEM add constraint ADPRINTCOLOR_ADPRINTFORMATITEM foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM drop constraint "ADPRINTFONT_ADPRINTFORMATITEM"
;

alter table AD_PRINTFORMATITEM add constraint ADPRINTFONT_ADPRINTFORMATITEM foreign key (AD_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM drop constraint "ADPRINTFORMAT_PRINTFORMATCHILD"
;

alter table AD_PRINTFORMATITEM add constraint ADPRINTFORMAT_PRINTFORMATCHILD foreign key (AD_PRINTFORMATCHILD_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM drop constraint "ADPRINTFORMAT_PRINTFORMATITEM"
;

alter table AD_PRINTFORMATITEM add constraint ADPRINTFORMAT_PRINTFORMATITEM foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM drop constraint "ADPRINTGRAPH_PRINTFORMATITEM"
;

alter table AD_PRINTFORMATITEM add constraint ADPRINTGRAPH_PRINTFORMATITEM foreign key (AD_PRINTGRAPH_ID) references AD_PRINTGRAPH(AD_PRINTGRAPH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM_TRL drop constraint "ADLANGUAGE_ADPRINTFORMITEMTRL"
;

alter table AD_PRINTFORMATITEM_TRL add constraint ADLANGUAGE_ADPRINTFORMITEMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTFORMATITEM_TRL drop constraint "ADPRINTFORMATITEM_TRL"
;

alter table AD_PRINTFORMATITEM_TRL add constraint ADPRINTFORMATITEM_TRL foreign key (AD_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDATA"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDATA foreign key (DATA_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDATA1"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDATA1 foreign key (DATA1_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDATA2"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDATA2 foreign key (DATA2_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDATA3"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDATA3 foreign key (DATA3_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDATA4"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDATA4 foreign key (DATA4_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMATITEM_GRAPHDESCR"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMATITEM_GRAPHDESCR foreign key (DESCRIPTION_PRINTFORMATITEM_ID) references AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTGRAPH drop constraint "ADPRINTFORMAT_ADPRINTGRAPH"
;

alter table AD_PRINTGRAPH add constraint ADPRINTFORMAT_ADPRINTGRAPH foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABEL drop constraint "ADLABELPRINTER_PRINTLABEL"
;

alter table AD_PRINTLABEL add constraint ADLABELPRINTER_PRINTLABEL foreign key (AD_LABELPRINTER_ID) references AD_LABELPRINTER(AD_LABELPRINTER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABEL drop constraint "ADTABLE_ADPRINTLABEL"
;

alter table AD_PRINTLABEL add constraint ADTABLE_ADPRINTLABEL foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABELLINE drop constraint "ADCOLUMN_ADPRINTLABELLINE"
;

alter table AD_PRINTLABELLINE add constraint ADCOLUMN_ADPRINTLABELLINE foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABELLINE drop constraint "ADLABELPRINTFUNC_LABELLINE"
;

alter table AD_PRINTLABELLINE add constraint ADLABELPRINTFUNC_LABELLINE foreign key (AD_LABELPRINTERFUNCTION_ID) references AD_LABELPRINTERFUNCTION(AD_LABELPRINTERFUNCTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABELLINE drop constraint "ADPRINTLABEL_ADPRINTLABELLINE"
;

alter table AD_PRINTLABELLINE add constraint ADPRINTLABEL_ADPRINTLABELLINE foreign key (AD_PRINTLABEL_ID) references AD_PRINTLABEL(AD_PRINTLABEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABELLINE_TRL drop constraint "ADLANGUAGE_ADPLABELLINETRL"
;

alter table AD_PRINTLABELLINE_TRL add constraint ADLANGUAGE_ADPLABELLINETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTLABELLINE_TRL drop constraint "ADPRINTLABELLINE_TRL"
;

alter table AD_PRINTLABELLINE_TRL add constraint ADPRINTLABELLINE_TRL foreign key (AD_PRINTLABELLINE_ID) references AD_PRINTLABELLINE(AD_PRINTLABELLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADIMAGE_ADPRINTTABLEFORMAT"
;

alter table AD_PRINTTABLEFORMAT add constraint ADIMAGE_ADPRINTTABLEFORMAT foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLEFUNCTBG"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLEFUNCTBG foreign key (FUNCTBG_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLEFUNCTFG"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLEFUNCTFG foreign key (FUNCTFG_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLEHDRLINE"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLEHDRLINE foreign key (HDRLINE_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLEHDRTEXTBG"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLEHDRTEXTBG foreign key (HDRTEXTBG_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLEHDRTEXTFG"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLEHDRTEXTFG foreign key (HDRTEXTFG_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTCOLOR_TABLELINE"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTCOLOR_TABLELINE foreign key (LINE_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTFONT_TABLEFORMATFUNC"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTFONT_TABLEFORMATFUNC foreign key (FUNCT_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRINTTABLEFORMAT drop constraint "ADPRINTFONT_TABLEHDR"
;

alter table AD_PRINTTABLEFORMAT add constraint ADPRINTFONT_TABLEHDR foreign key (HDR_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRIVATE_ACCESS drop constraint "ADTABLE_ADPRIVATEACCESS"
;

alter table AD_PRIVATE_ACCESS add constraint ADTABLE_ADPRIVATEACCESS foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PRIVATE_ACCESS drop constraint "ADUSER_ADPRIVATEACCESS"
;

alter table AD_PRIVATE_ACCESS add constraint ADUSER_ADPRIVATEACCESS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS drop constraint "ADFORM_ADPROCESS"
;

alter table AD_PROCESS add constraint ADFORM_ADPROCESS foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS drop constraint "ADPRINTFORMAT_ADPROCESS"
;

alter table AD_PROCESS add constraint ADPRINTFORMAT_ADPROCESS foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS drop constraint "ADREPORTVIEW_ADPROCESS"
;

alter table AD_PROCESS add constraint ADREPORTVIEW_ADPROCESS foreign key (AD_REPORTVIEW_ID) references AD_REPORTVIEW(AD_REPORTVIEW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS drop constraint "ADWORKFLOW_ADPROCESS"
;

alter table AD_PROCESS add constraint ADWORKFLOW_ADPROCESS foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS drop constraint "ENTITYT_ADPROCESS"
;

alter table AD_PROCESS add constraint ENTITYT_ADPROCESS foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_ACCESS drop constraint "ADPROCESS_ADPROCESSACCESS"
;

alter table AD_PROCESS_ACCESS add constraint ADPROCESS_ADPROCESSACCESS foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_ACCESS drop constraint "ADROLE_ADPROCESSACCESS"
;

alter table AD_PROCESS_ACCESS add constraint ADROLE_ADPROCESSACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_ACCESS drop constraint "AD_PROCESSACCESS_CLIENT"
;

alter table AD_PROCESS_ACCESS add constraint AD_PROCESSACCESS_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_ACCESS drop constraint "AD_PROCESSTACCESS_ORG"
;

alter table AD_PROCESS_ACCESS add constraint AD_PROCESSTACCESS_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ADELEMENT_ADPROCESSPARA"
;

alter table AD_PROCESS_PARA add constraint ADELEMENT_ADPROCESSPARA foreign key (AD_ELEMENT_ID) references AD_ELEMENT(AD_ELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ADPROCESS_ADPROCESSPARA"
;

alter table AD_PROCESS_PARA add constraint ADPROCESS_ADPROCESSPARA foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ADREFERENCEVALUE_ADPROCPARA"
;

alter table AD_PROCESS_PARA add constraint ADREFERENCEVALUE_ADPROCPARA foreign key (AD_REFERENCE_VALUE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ADREFERENCE_ADPROCESSPARA"
;

alter table AD_PROCESS_PARA add constraint ADREFERENCE_ADPROCESSPARA foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ADVALRULE_AD_PROCESSPARA"
;

alter table AD_PROCESS_PARA add constraint ADVALRULE_AD_PROCESSPARA foreign key (AD_VAL_RULE_ID) references AD_VAL_RULE(AD_VAL_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA drop constraint "ENTITYT_ADPROCESSPARA"
;

alter table AD_PROCESS_PARA add constraint ENTITYT_ADPROCESSPARA foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA_TRL drop constraint "ADLANGUAGE_ADPROCESSPARATRL"
;

alter table AD_PROCESS_PARA_TRL add constraint ADLANGUAGE_ADPROCESSPARATRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_PARA_TRL drop constraint "ADPROCPARA_ADPROCPARATRL"
;

alter table AD_PROCESS_PARA_TRL add constraint ADPROCPARA_ADPROCPARATRL foreign key (AD_PROCESS_PARA_ID) references AD_PROCESS_PARA(AD_PROCESS_PARA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_TRL drop constraint "AD_LANGUAGE_AD_PROCESS_TRL"
;

alter table AD_PROCESS_TRL add constraint AD_LANGUAGE_AD_PROCESS_TRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_PROCESS_TRL drop constraint "AD_PROCESS_AD_PROCESS_TRL"
;

alter table AD_PROCESS_TRL add constraint AD_PROCESS_AD_PROCESS_TRL foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_RECORD_ACCESS drop constraint "ADROLE_ARDECORDACCESS"
;

alter table AD_RECORD_ACCESS add constraint ADROLE_ARDECORDACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_RECORD_ACCESS drop constraint "ADTABLE_ADRECORDACCESS"
;

alter table AD_RECORD_ACCESS add constraint ADTABLE_ADRECORDACCESS foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REFERENCE drop constraint "ENTITYT_ADREFERENCE"
;

alter table AD_REFERENCE add constraint ENTITYT_ADREFERENCE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REFERENCE drop constraint "REFERENCECLIENT"
;

alter table AD_REFERENCE add constraint REFERENCECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REFERENCE drop constraint "REFERENCEORG"
;

alter table AD_REFERENCE add constraint REFERENCEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REFERENCE_TRL drop constraint "AD_LANGUAGE_REFERENCETRL"
;

alter table AD_REFERENCE_TRL add constraint AD_LANGUAGE_REFERENCETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REFERENCE_TRL drop constraint "AD_REFERENCETRL"
;

alter table AD_REFERENCE_TRL add constraint AD_REFERENCETRL foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST drop constraint "AD_REFERENCE_REFLIST"
;

alter table AD_REF_LIST add constraint AD_REFERENCE_REFLIST foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST drop constraint "AD_REFLIST_CLIENT"
;

alter table AD_REF_LIST add constraint AD_REFLIST_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST drop constraint "AD_REFLIST_ORG"
;

alter table AD_REF_LIST add constraint AD_REFLIST_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST drop constraint "ENTITYT_ADREFLIST"
;

alter table AD_REF_LIST add constraint ENTITYT_ADREFLIST foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST_TRL drop constraint "AD_LANGUAGE_REFLISTTRL"
;

alter table AD_REF_LIST_TRL add constraint AD_LANGUAGE_REFLISTTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_LIST_TRL drop constraint "AD_REFLISTTRL"
;

alter table AD_REF_LIST_TRL add constraint AD_REFLISTTRL foreign key (AD_REF_LIST_ID) references AD_REF_LIST(AD_REF_LIST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "ADD_TABLE_REFTABLE"
;

alter table AD_REF_TABLE add constraint ADD_TABLE_REFTABLE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "ADWINDOW_ADREFTABLE"
;

alter table AD_REF_TABLE add constraint ADWINDOW_ADREFTABLE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "AD_COLUMN_REFTABLE_DISPLAY"
;

alter table AD_REF_TABLE add constraint AD_COLUMN_REFTABLE_DISPLAY foreign key (AD_DISPLAY) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "AD_COLUMN_REFTABLE_ID"
;

alter table AD_REF_TABLE add constraint AD_COLUMN_REFTABLE_ID foreign key (AD_KEY) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "AD_REFERENCE_REFTABLE"
;

alter table AD_REF_TABLE add constraint AD_REFERENCE_REFTABLE foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "ENTITYT_ADREFTABLE"
;

alter table AD_REF_TABLE add constraint ENTITYT_ADREFTABLE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "REF_TABLECLIENT"
;

alter table AD_REF_TABLE add constraint REF_TABLECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REF_TABLE drop constraint "REF_TABLEORG"
;

alter table AD_REF_TABLE add constraint REF_TABLEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REGISTRATION drop constraint "ADSYSTEM_ADREGISTRATION"
;

alter table AD_REGISTRATION add constraint ADSYSTEM_ADREGISTRATION foreign key (AD_SYSTEM_ID, AD_CLIENT_ID) references AD_SYSTEM(AD_SYSTEM_ID, AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REGISTRATION drop constraint "CCURRENCY_ADREGISTRATION"
;

alter table AD_REGISTRATION add constraint CCURRENCY_ADREGISTRATION foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REGISTRATION drop constraint "CLOCATION_ADREGISTRATION"
;

alter table AD_REGISTRATION add constraint CLOCATION_ADREGISTRATION foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_RELATIONTYPE drop constraint "ADREFERENCESOURCE_ADRELATIONTY"
;

alter table AD_RELATIONTYPE add constraint ADREFERENCESOURCE_ADRELATIONTY foreign key (AD_REFERENCE_SOURCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_RELATIONTYPE drop constraint "ADREFERENCETARGET_ADRELATIONTY"
;

alter table AD_RELATIONTYPE add constraint ADREFERENCETARGET_ADRELATIONTY foreign key (AD_REFERENCE_TARGET_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION drop constraint "ADREPLICATIONSTRATEGY_ADREP"
;

alter table AD_REPLICATION add constraint ADREPLICATIONSTRATEGY_ADREP foreign key (AD_REPLICATIONSTRATEGY_ID) references AD_REPLICATIONSTRATEGY(AD_REPLICATIONSTRATEGY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION drop constraint "REMOTECLIENT_ADREPLICATION"
;

alter table AD_REPLICATION add constraint REMOTECLIENT_ADREPLICATION foreign key (REMOTE_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION drop constraint "REMOTEORG_ADREPLICATION"
;

alter table AD_REPLICATION add constraint REMOTEORG_ADREPLICATION foreign key (REMOTE_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONDOCUMENT drop constraint "ADTABLE_ADREPLICATIONDOCUMENT"
;

alter table AD_REPLICATIONDOCUMENT add constraint ADTABLE_ADREPLICATIONDOCUMENT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONDOCUMENT drop constraint "CDOCTYPE_ADREPLICATIONDOCUMENT"
;

alter table AD_REPLICATIONDOCUMENT add constraint CDOCTYPE_ADREPLICATIONDOCUMENT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONSTRATEGY drop constraint "ENTITYT_ADREPLICATIONSTRATEGY"
;

alter table AD_REPLICATIONSTRATEGY add constraint ENTITYT_ADREPLICATIONSTRATEGY foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONSTRATEGY drop constraint "EXPPROCESSOR_ADREPLICATIONSTRA"
;

alter table AD_REPLICATIONSTRATEGY add constraint EXPPROCESSOR_ADREPLICATIONSTRA foreign key (EXP_PROCESSOR_ID) references EXP_PROCESSOR(EXP_PROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONTABLE drop constraint "ADREPSTRATEGY_ADREPTABLE"
;

alter table AD_REPLICATIONTABLE add constraint ADREPSTRATEGY_ADREPTABLE foreign key (AD_REPLICATIONSTRATEGY_ID) references AD_REPLICATIONSTRATEGY(AD_REPLICATIONSTRATEGY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONTABLE drop constraint "ADTABLE_ADREPLICATIONTABLE"
;

alter table AD_REPLICATIONTABLE add constraint ADTABLE_ADREPLICATIONTABLE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATIONTABLE drop constraint "ENTITYT_ADREPLICATIONTABLE"
;

alter table AD_REPLICATIONTABLE add constraint ENTITYT_ADREPLICATIONTABLE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION_LOG drop constraint "ADREPLICATIONRUN_ADREPLOG"
;

alter table AD_REPLICATION_LOG add constraint ADREPLICATIONRUN_ADREPLOG foreign key (AD_REPLICATION_RUN_ID) references AD_REPLICATION_RUN(AD_REPLICATION_RUN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION_LOG drop constraint "ADREPTABLE_ADREPLOG"
;

alter table AD_REPLICATION_LOG add constraint ADREPTABLE_ADREPLOG foreign key (AD_REPLICATIONTABLE_ID) references AD_REPLICATIONTABLE(AD_REPLICATIONTABLE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPLICATION_RUN drop constraint "ADREPLICATION_ADREPRUN"
;

alter table AD_REPLICATION_RUN add constraint ADREPLICATION_ADREPRUN foreign key (AD_REPLICATION_ID) references AD_REPLICATION(AD_REPLICATION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPORTVIEW drop constraint "ADTABLE_ADREPORTVIEW"
;

alter table AD_REPORTVIEW add constraint ADTABLE_ADREPORTVIEW foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPORTVIEW drop constraint "ENTITYT_ADREPORTVIEW"
;

alter table AD_REPORTVIEW add constraint ENTITYT_ADREPORTVIEW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPORTVIEW_COL drop constraint "ADCOLUMN_ADREPORTVIEWCOL"
;

alter table AD_REPORTVIEW_COL add constraint ADCOLUMN_ADREPORTVIEWCOL foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_REPORTVIEW_COL drop constraint "ADREPORTVIEW_COL"
;

alter table AD_REPORTVIEW_COL add constraint ADREPORTVIEW_COL foreign key (AD_REPORTVIEW_ID) references AD_REPORTVIEW(AD_REPORTVIEW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "ADTREEORG_ADROLE"
;

alter table AD_ROLE add constraint ADTREEORG_ADROLE foreign key (AD_TREE_ORG_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "ADTREE_ADROLE"
;

alter table AD_ROLE add constraint ADTREE_ADROLE foreign key (AD_TREE_MENU_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "ADUSERSUPERVISOR_ADROLE"
;

alter table AD_ROLE add constraint ADUSERSUPERVISOR_ADROLE foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "AD_ROLECLIENT"
;

alter table AD_ROLE add constraint AD_ROLECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "AD_ROLEORG"
;

alter table AD_ROLE add constraint AD_ROLEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE drop constraint "C_CURRENCY_AD_ROLE"
;

alter table AD_ROLE add constraint C_CURRENCY_AD_ROLE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE_ORGACCESS drop constraint "ADORG_ADROLEORGACCESS"
;

alter table AD_ROLE_ORGACCESS add constraint ADORG_ADROLEORGACCESS foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_ROLE_ORGACCESS drop constraint "ADROLE_ADROLEORGACCESS"
;

alter table AD_ROLE_ORGACCESS add constraint ADROLE_ADROLEORGACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_RULE drop constraint "ENTITYT_ADRULE"
;

alter table AD_RULE add constraint ENTITYT_ADRULE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER drop constraint "ADPROCESS_ADSCHEDULER"
;

alter table AD_SCHEDULER add constraint ADPROCESS_ADSCHEDULER foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER drop constraint "ADSCHEDULE_ADSCHEDULER"
;

alter table AD_SCHEDULER add constraint ADSCHEDULE_ADSCHEDULER foreign key (AD_SCHEDULE_ID) references AD_SCHEDULE(AD_SCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER drop constraint "ADTABLE_ADSCHEDULER"
;

alter table AD_SCHEDULER add constraint ADTABLE_ADSCHEDULER foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER drop constraint "ADUSER_ADSCHEDULER"
;

alter table AD_SCHEDULER add constraint ADUSER_ADSCHEDULER foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULERLOG drop constraint "ADSCHEDULER_LOG"
;

alter table AD_SCHEDULERLOG add constraint ADSCHEDULER_LOG foreign key (AD_SCHEDULER_ID) references AD_SCHEDULER(AD_SCHEDULER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULERRECIPIENT drop constraint "ADROLE_ADSCHEDULERRECIPIENT"
;

alter table AD_SCHEDULERRECIPIENT add constraint ADROLE_ADSCHEDULERRECIPIENT foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULERRECIPIENT drop constraint "ADSCHEDULER_RECIPIENT"
;

alter table AD_SCHEDULERRECIPIENT add constraint ADSCHEDULER_RECIPIENT foreign key (AD_SCHEDULER_ID) references AD_SCHEDULER(AD_SCHEDULER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULERRECIPIENT drop constraint "ADUSER_ADSCHEDULERRECIPIENT"
;

alter table AD_SCHEDULERRECIPIENT add constraint ADUSER_ADSCHEDULERRECIPIENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER_PARA drop constraint "ADPROCESSPARA_ADSCHEDULERPARA"
;

alter table AD_SCHEDULER_PARA add constraint ADPROCESSPARA_ADSCHEDULERPARA foreign key (AD_PROCESS_PARA_ID) references AD_PROCESS_PARA(AD_PROCESS_PARA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SCHEDULER_PARA drop constraint "ADSCHEDULER_ADSCHEDULERPARA"
;

alter table AD_SCHEDULER_PARA add constraint ADSCHEDULER_ADSCHEDULERPARA foreign key (AD_SCHEDULER_ID) references AD_SCHEDULER(AD_SCHEDULER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEARCHDEFINITION drop constraint "ADCOLUMN_ADSEARCHDEFINITION"
;

alter table AD_SEARCHDEFINITION add constraint ADCOLUMN_ADSEARCHDEFINITION foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEARCHDEFINITION drop constraint "ADTABLE_ADSEARCHDEFINITION"
;

alter table AD_SEARCHDEFINITION add constraint ADTABLE_ADSEARCHDEFINITION foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEARCHDEFINITION drop constraint "ADWINDOW_ADSEARCHDEFINITION"
;

alter table AD_SEARCHDEFINITION add constraint ADWINDOW_ADSEARCHDEFINITION foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEARCHDEFINITION drop constraint "POWINDOW_ADSEARCHDEFINITION"
;

alter table AD_SEARCHDEFINITION add constraint POWINDOW_ADSEARCHDEFINITION foreign key (PO_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE drop constraint "SEQUENCECLIENT"
;

alter table AD_SEQUENCE add constraint SEQUENCECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE drop constraint "SEQUENCEORG"
;

alter table AD_SEQUENCE add constraint SEQUENCEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_AUDIT drop constraint "ADTABLE_ADSEQUENCEAUDIT"
;

alter table AD_SEQUENCE_AUDIT add constraint ADTABLE_ADSEQUENCEAUDIT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_AUDIT drop constraint "AD_SEQUENCE_SEQUENCEAUDIT"
;

alter table AD_SEQUENCE_AUDIT add constraint AD_SEQUENCE_SEQUENCEAUDIT foreign key (AD_SEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_AUDIT drop constraint "SEQUENCE_AUDITCLIENT"
;

alter table AD_SEQUENCE_AUDIT add constraint SEQUENCE_AUDITCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_AUDIT drop constraint "SEQUENCE_AUDITORG"
;

alter table AD_SEQUENCE_AUDIT add constraint SEQUENCE_AUDITORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_NO drop constraint "AD_SEQUENCE_SEQUENCENO"
;

alter table AD_SEQUENCE_NO add constraint AD_SEQUENCE_SEQUENCENO foreign key (AD_SEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_NO drop constraint "SEQUENCE_NOCLIENT"
;

alter table AD_SEQUENCE_NO add constraint SEQUENCE_NOCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SEQUENCE_NO drop constraint "SEQUENCE_NOORG"
;

alter table AD_SEQUENCE_NO add constraint SEQUENCE_NOORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SESSION drop constraint "ADROLE_ADSESSION"
;

alter table AD_SESSION add constraint ADROLE_ADSESSION foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_SYSCONFIG drop constraint "ENTITYT_ADSYSCONFIG"
;

alter table AD_SYSCONFIG add constraint ENTITYT_ADSYSCONFIG foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ADCOLUMN_ADTABSORTORDER"
;

alter table AD_TAB add constraint ADCOLUMN_ADTABSORTORDER foreign key (AD_COLUMNSORTORDER_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ADCOLUMN_ADTABSORTYESNO"
;

alter table AD_TAB add constraint ADCOLUMN_ADTABSORTYESNO foreign key (AD_COLUMNSORTYESNO_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ADIMAGE_ADTAB"
;

alter table AD_TAB add constraint ADIMAGE_ADTAB foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ADPROCESS_ADTAB"
;

alter table AD_TAB add constraint ADPROCESS_ADTAB foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ADTAB_INCLUDED"
;

alter table AD_TAB add constraint ADTAB_INCLUDED foreign key (INCLUDED_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "AD_COLUMN_AD_TAB"
;

alter table AD_TAB add constraint AD_COLUMN_AD_TAB foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "AD_TABLE_TAB"
;

alter table AD_TAB add constraint AD_TABLE_TAB foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "AD_WINDOW_TAB"
;

alter table AD_TAB add constraint AD_WINDOW_TAB foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "ENTITYT_ADTAB"
;

alter table AD_TAB add constraint ENTITYT_ADTAB foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "PARENTCOLUMN_ADTAB"
;

alter table AD_TAB add constraint PARENTCOLUMN_ADTAB foreign key (PARENT_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "TABCLIENT"
;

alter table AD_TAB add constraint TABCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB drop constraint "TABORG"
;

alter table AD_TAB add constraint TABORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "ADWINDOWPO_ADTABLE"
;

alter table AD_TABLE add constraint ADWINDOWPO_ADTABLE foreign key (PO_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "AD_VALRULE_TABLE"
;

alter table AD_TABLE add constraint AD_VALRULE_TABLE foreign key (AD_VAL_RULE_ID) references AD_VAL_RULE(AD_VAL_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "AD_WINDOW_TABLE"
;

alter table AD_TABLE add constraint AD_WINDOW_TABLE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "ENTITYT_ADTABLE"
;

alter table AD_TABLE add constraint ENTITYT_ADTABLE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "TABLECLIENT"
;

alter table AD_TABLE add constraint TABLECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE drop constraint "TABLEORG"
;

alter table AD_TABLE add constraint TABLEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_ACCESS drop constraint "ADROLE_ADTABLEACCESS"
;

alter table AD_TABLE_ACCESS add constraint ADROLE_ADTABLEACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_ACCESS drop constraint "ADTABLE_ADTABLEACCESS"
;

alter table AD_TABLE_ACCESS add constraint ADTABLE_ADTABLEACCESS foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_ACCESS drop constraint "AD_DATAACCESSCLIENT"
;

alter table AD_TABLE_ACCESS add constraint AD_DATAACCESSCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_ACCESS drop constraint "AD_DATAACCESSORG"
;

alter table AD_TABLE_ACCESS add constraint AD_DATAACCESSORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_SCRIPTVALIDATOR drop constraint "ADRULE_ADTABLESCRIPTVALIDATOR"
;

alter table AD_TABLE_SCRIPTVALIDATOR add constraint ADRULE_ADTABLESCRIPTVALIDATOR foreign key (AD_RULE_ID) references AD_RULE(AD_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_SCRIPTVALIDATOR drop constraint "ADTABLE_ADTABLESCRIPTVALIDATOR"
;

alter table AD_TABLE_SCRIPTVALIDATOR add constraint ADTABLE_ADTABLESCRIPTVALIDATOR foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_TRL drop constraint "ADLANGUAGE_ADTABLETRL"
;

alter table AD_TABLE_TRL add constraint ADLANGUAGE_ADTABLETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TABLE_TRL drop constraint "ADTABLE_ADTABLETRL"
;

alter table AD_TABLE_TRL add constraint ADTABLE_ADTABLETRL foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB_CUSTOMIZATION drop constraint "ADTAB_ADTABCUSTOMIZATION"
;

alter table AD_TAB_CUSTOMIZATION add constraint ADTAB_ADTABCUSTOMIZATION foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB_TRL drop constraint "AD_LANGUAGE_TABTRL"
;

alter table AD_TAB_TRL add constraint AD_LANGUAGE_TABTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TAB_TRL drop constraint "AD_TABTRL"
;

alter table AD_TAB_TRL add constraint AD_TABTRL foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK drop constraint "ENTITYT_ADTASK"
;

alter table AD_TASK add constraint ENTITYT_ADTASK foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK drop constraint "TASKCLIENT"
;

alter table AD_TASK add constraint TASKCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK drop constraint "TASKORG"
;

alter table AD_TASK add constraint TASKORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASKINSTANCE drop constraint "AD_TASK_TASKINSTANCE"
;

alter table AD_TASKINSTANCE add constraint AD_TASK_TASKINSTANCE foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASKINSTANCE drop constraint "TASKINSTANCECLIENT"
;

alter table AD_TASKINSTANCE add constraint TASKINSTANCECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASKINSTANCE drop constraint "TASKINSTANCEORG"
;

alter table AD_TASKINSTANCE add constraint TASKINSTANCEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_ACCESS drop constraint "ADROLE_ADTASKACCESS"
;

alter table AD_TASK_ACCESS add constraint ADROLE_ADTASKACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_ACCESS drop constraint "ADTASK_ADTASKACCESS"
;

alter table AD_TASK_ACCESS add constraint ADTASK_ADTASKACCESS foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_ACCESS drop constraint "AD_TASKACCESS_CLIENT"
;

alter table AD_TASK_ACCESS add constraint AD_TASKACCESS_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_ACCESS drop constraint "AD_TASKACCESS_ORG"
;

alter table AD_TASK_ACCESS add constraint AD_TASKACCESS_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_TRL drop constraint "AD_LANGUAGE_TASKTRL"
;

alter table AD_TASK_TRL add constraint AD_LANGUAGE_TASKTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TASK_TRL drop constraint "AD_TASKTRL"
;

alter table AD_TASK_TRL add constraint AD_TASKTRL foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTON drop constraint "ADPROCESS_ADTOOLBARBUTTON"
;

alter table AD_TOOLBARBUTTON add constraint ADPROCESS_ADTOOLBARBUTTON foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTON drop constraint "ADTAB_ADTOOLBARBUTTON"
;

alter table AD_TOOLBARBUTTON add constraint ADTAB_ADTOOLBARBUTTON foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTONRESTRICT drop constraint "ADPROCESS_ADTOOLBARBUTTONRESTR"
;

alter table AD_TOOLBARBUTTONRESTRICT add constraint ADPROCESS_ADTOOLBARBUTTONRESTR foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTONRESTRICT drop constraint "ADROLE_ADTOOLBARBUTTONRESTRICT"
;

alter table AD_TOOLBARBUTTONRESTRICT add constraint ADROLE_ADTOOLBARBUTTONRESTRICT foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTONRESTRICT drop constraint "ADTAB_ADTOOLBARBUTTONRESTRICT"
;

alter table AD_TOOLBARBUTTONRESTRICT add constraint ADTAB_ADTOOLBARBUTTONRESTRICT foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTONRESTRICT drop constraint "ADTOOLBARBUTTON_ADTOOLBARBUTTO"
;

alter table AD_TOOLBARBUTTONRESTRICT add constraint ADTOOLBARBUTTON_ADTOOLBARBUTTO foreign key (AD_TOOLBARBUTTON_ID) references AD_TOOLBARBUTTON(AD_TOOLBARBUTTON_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TOOLBARBUTTONRESTRICT drop constraint "ADWINDOW_ADTOOLBARBUTTONRESTRI"
;

alter table AD_TOOLBARBUTTONRESTRICT add constraint ADWINDOW_ADTOOLBARBUTTONRESTRI foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREEBAR drop constraint "ADTREE_ADTREEBAR"
;

alter table AD_TREEBAR add constraint ADTREE_ADTREEBAR foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREEBAR drop constraint "ADUSER_ADTREEBAR"
;

alter table AD_TREEBAR add constraint ADUSER_ADTREEBAR foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODE drop constraint "ADTREE_ADTREENODE"
;

alter table AD_TREENODE add constraint ADTREE_ADTREENODE foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEBP drop constraint "ADTREE_ADTREENODEBP"
;

alter table AD_TREENODEBP add constraint ADTREE_ADTREENODEBP foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODECMC drop constraint "ADTREE_ADTREENODECMC"
;

alter table AD_TREENODECMC add constraint ADTREE_ADTREENODECMC foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODECMM drop constraint "ADTREE_ADTREENODECMM"
;

alter table AD_TREENODECMM add constraint ADTREE_ADTREENODECMM foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODECMS drop constraint "ADTREE_ADTREENODECMS"
;

alter table AD_TREENODECMS add constraint ADTREE_ADTREENODECMS foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODECMT drop constraint "ADTREE_ADTREENODECMT"
;

alter table AD_TREENODECMT add constraint ADTREE_ADTREENODECMT foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEMM drop constraint "ADTREE_ADTREENODEMM"
;

alter table AD_TREENODEMM add constraint ADTREE_ADTREENODEMM foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEPR drop constraint "ADTREE_ADTREENODEPR"
;

alter table AD_TREENODEPR add constraint ADTREE_ADTREENODEPR foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEU1 drop constraint "ADTREE_ADTREENODEU1"
;

alter table AD_TREENODEU1 add constraint ADTREE_ADTREENODEU1 foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEU2 drop constraint "ADTREE_ADTREENODEU2"
;

alter table AD_TREENODEU2 add constraint ADTREE_ADTREENODEU2 foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEU3 drop constraint "ADTREE_ADTREENODEU3"
;

alter table AD_TREENODEU3 add constraint ADTREE_ADTREENODEU3 foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_TREENODEU4 drop constraint "ADTREE_ADTREENODEU4"
;

alter table AD_TREENODEU4 add constraint ADTREE_ADTREENODEU4 foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "ADORGTRX_ADUSER"
;

alter table AD_USER add constraint ADORGTRX_ADUSER foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "ADUSER_SUPERVISOR"
;

alter table AD_USER add constraint ADUSER_SUPERVISOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "AD_USER_CLIENT"
;

alter table AD_USER add constraint AD_USER_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "AD_USER_ORG"
;

alter table AD_USER add constraint AD_USER_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "CBPARTNER_ADUSER"
;

alter table AD_USER add constraint CBPARTNER_ADUSER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "CBPLOCATION_ADUSER"
;

alter table AD_USER add constraint CBPLOCATION_ADUSER foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "CGREETING_ADUSER"
;

alter table AD_USER add constraint CGREETING_ADUSER foreign key (C_GREETING_ID) references C_GREETING(C_GREETING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER drop constraint "CJOB_ADUSER"
;

alter table AD_USER add constraint CJOB_ADUSER foreign key (C_JOB_ID) references C_JOB(C_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERBPACCESS drop constraint "ADUSER_ADUSERBPACCESS"
;

alter table AD_USERBPACCESS add constraint ADUSER_ADUSERBPACCESS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERBPACCESS drop constraint "RREQUESTTYPE_ADUSERBPACCESS"
;

alter table AD_USERBPACCESS add constraint RREQUESTTYPE_ADUSERBPACCESS foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_FIELD drop constraint "ADFIELD_ADUSERDEFFIELD"
;

alter table AD_USERDEF_FIELD add constraint ADFIELD_ADUSERDEFFIELD foreign key (AD_FIELD_ID) references AD_FIELD(AD_FIELD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_FIELD drop constraint "ADUSERDEFTAB_ADUSERDEFFIELD"
;

alter table AD_USERDEF_FIELD add constraint ADUSERDEFTAB_ADUSERDEFFIELD foreign key (AD_USERDEF_TAB_ID) references AD_USERDEF_TAB(AD_USERDEF_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_TAB drop constraint "ADTAB_ADUSERDEFTAB"
;

alter table AD_USERDEF_TAB add constraint ADTAB_ADUSERDEFTAB foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_TAB drop constraint "ADUSERDEFWIN_ADUSERDEFTAB"
;

alter table AD_USERDEF_TAB add constraint ADUSERDEFWIN_ADUSERDEFTAB foreign key (AD_USERDEF_WIN_ID) references AD_USERDEF_WIN(AD_USERDEF_WIN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_WIN drop constraint "ADLANGU_ADUSERDEFWIN"
;

alter table AD_USERDEF_WIN add constraint ADLANGU_ADUSERDEFWIN foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_WIN drop constraint "ADROLE_ADUSERDEFWIN"
;

alter table AD_USERDEF_WIN add constraint ADROLE_ADUSERDEFWIN foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_WIN drop constraint "ADUSER_ADUSERDEFWIN"
;

alter table AD_USERDEF_WIN add constraint ADUSER_ADUSERDEFWIN foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERDEF_WIN drop constraint "ADWINDOW_ADUSERDEFWIN"
;

alter table AD_USERDEF_WIN add constraint ADWINDOW_ADUSERDEFWIN foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERMAIL drop constraint "ADUSER_ADUSERMAIL"
;

alter table AD_USERMAIL add constraint ADUSER_ADUSERMAIL foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERMAIL drop constraint "RMAILTEXT_ADUSERMAIL"
;

alter table AD_USERMAIL add constraint RMAILTEXT_ADUSERMAIL foreign key (R_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERMAIL drop constraint "WMAILMSG_ADUSERMAIL"
;

alter table AD_USERMAIL add constraint WMAILMSG_ADUSERMAIL foreign key (W_MAILMSG_ID) references W_MAILMSG(W_MAILMSG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERQUERY drop constraint "ADTABLE_ADUSERQUERY"
;

alter table AD_USERQUERY add constraint ADTABLE_ADUSERQUERY foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERQUERY drop constraint "ADTAB_ADUSERQUERY"
;

alter table AD_USERQUERY add constraint ADTAB_ADUSERQUERY foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USERQUERY drop constraint "ADUSER_ADUSERQUERY"
;

alter table AD_USERQUERY add constraint ADUSER_ADUSERQUERY foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ORGACCESS drop constraint "ADORG_ADUSERORGACCESS"
;

alter table AD_USER_ORGACCESS add constraint ADORG_ADUSERORGACCESS foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ORGACCESS drop constraint "ADUSER_ADUSERORGACCESS"
;

alter table AD_USER_ORGACCESS add constraint ADUSER_ADUSERORGACCESS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ROLES drop constraint "ADROLE_ADUSERROLES"
;

alter table AD_USER_ROLES add constraint ADROLE_ADUSERROLES foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ROLES drop constraint "ADUSER_USERROLES"
;

alter table AD_USER_ROLES add constraint ADUSER_USERROLES foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ROLES drop constraint "AD_USERROLESCLIENT"
;

alter table AD_USER_ROLES add constraint AD_USERROLESCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_ROLES drop constraint "AD_USERROLESORG"
;

alter table AD_USER_ROLES add constraint AD_USERROLESORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_SUBSTITUTE drop constraint "ADUSERSUB_AD_USERSUB"
;

alter table AD_USER_SUBSTITUTE add constraint ADUSERSUB_AD_USERSUB foreign key (SUBSTITUTE_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_USER_SUBSTITUTE drop constraint "ADUSER_ADUSERSUB"
;

alter table AD_USER_SUBSTITUTE add constraint ADUSER_ADUSERSUB foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_VAL_RULE drop constraint "ENTITYT_ADVALRULE"
;

alter table AD_VAL_RULE add constraint ENTITYT_ADVALRULE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_VAL_RULE drop constraint "VAL_RULECLIENT"
;

alter table AD_VAL_RULE add constraint VAL_RULECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_VAL_RULE drop constraint "VAL_RULEORG"
;

alter table AD_VAL_RULE add constraint VAL_RULEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADMESSAGE_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADMESSAGE_ADWFACTIVITY foreign key (AD_MESSAGE_ID) references AD_MESSAGE(AD_MESSAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADTABLE_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADTABLE_ADWFACTIVITY foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADUSER_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADUSER_ADWFACTIVITY foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADWFNODE_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADWFNODE_ADWFACTIVITY foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADWFPROCESS_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADWFPROCESS_ADWFACTIVITY foreign key (AD_WF_PROCESS_ID) references AD_WF_PROCESS(AD_WF_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADWFRESPONSIBLE_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADWFRESPONSIBLE_ADWFACTIVITY foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITY drop constraint "ADWORKFLOW_ADWFACTIVITY"
;

alter table AD_WF_ACTIVITY add constraint ADWORKFLOW_ADWFACTIVITY foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_ACTIVITYRESULT drop constraint "ADWFACTIVITY_ADWFACTRESULT"
;

alter table AD_WF_ACTIVITYRESULT add constraint ADWFACTIVITY_ADWFACTRESULT foreign key (AD_WF_ACTIVITY_ID) references AD_WF_ACTIVITY(AD_WF_ACTIVITY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_BLOCK drop constraint "ADWORKFLOW_ADWFBLOCK"
;

alter table AD_WF_BLOCK add constraint ADWORKFLOW_ADWFBLOCK foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_EVENTAUDIT drop constraint "ADTABLE_ADWFEVENTAUDIT"
;

alter table AD_WF_EVENTAUDIT add constraint ADTABLE_ADWFEVENTAUDIT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_EVENTAUDIT drop constraint "ADUSER_ADWFEVENTAUDIT"
;

alter table AD_WF_EVENTAUDIT add constraint ADUSER_ADWFEVENTAUDIT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_EVENTAUDIT drop constraint "ADWFNODE_ADWFEVENTAUDIT"
;

alter table AD_WF_EVENTAUDIT add constraint ADWFNODE_ADWFEVENTAUDIT foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_EVENTAUDIT drop constraint "ADWFPROCESS_ADWFEVENTAUDIT"
;

alter table AD_WF_EVENTAUDIT add constraint ADWFPROCESS_ADWFEVENTAUDIT foreign key (AD_WF_PROCESS_ID) references AD_WF_PROCESS(AD_WF_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_EVENTAUDIT drop constraint "ADWFRESPONSIB_ADWFEVENTAUDIT"
;

alter table AD_WF_EVENTAUDIT add constraint ADWFRESPONSIB_ADWFEVENTAUDIT foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NEXTCONDITION drop constraint "ADCOLUMN_ADWFNEXTCONDITION"
;

alter table AD_WF_NEXTCONDITION add constraint ADCOLUMN_ADWFNEXTCONDITION foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NEXTCONDITION drop constraint "ADWFNODENEXT_ADWFNEXTCOND"
;

alter table AD_WF_NEXTCONDITION add constraint ADWFNODENEXT_ADWFNEXTCOND foreign key (AD_WF_NODENEXT_ID) references AD_WF_NODENEXT(AD_WF_NODENEXT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NEXTCONDITION drop constraint "ENTITYT_ADWFNEXTCONDITION"
;

alter table AD_WF_NEXTCONDITION add constraint ENTITYT_ADWFNEXTCONDITION foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADCOLUMN_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADCOLUMN_ADWFNODE foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADFORM_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADFORM_ADWFNODE foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADIMAGE_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADIMAGE_ADWFNODE foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADPROCESS_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADPROCESS_ADWFNODE foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADTASK_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADTASK_ADWFNODE foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADWFBLOCK_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADWFBLOCK_ADWFNODE foreign key (AD_WF_BLOCK_ID) references AD_WF_BLOCK(AD_WF_BLOCK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADWFRESPONSIBLE_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADWFRESPONSIBLE_ADWFNODE foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADWINDOW_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADWINDOW_ADWFNODE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADWORKFLOW_ADWFNODE"
;

alter table AD_WF_NODE add constraint ADWORKFLOW_ADWFNODE foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ADWORKFLOW_ADWFNODESUBFLOW"
;

alter table AD_WF_NODE add constraint ADWORKFLOW_ADWFNODESUBFLOW foreign key (WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "CBPARTNER_ADWFNODE"
;

alter table AD_WF_NODE add constraint CBPARTNER_ADWFNODE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "ENTITYT_ADWFNODE"
;

alter table AD_WF_NODE add constraint ENTITYT_ADWFNODE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "RMAILTEXT_ADWFNODE"
;

alter table AD_WF_NODE add constraint RMAILTEXT_ADWFNODE foreign key (R_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "SRESOURCE_ADWFNODE"
;

alter table AD_WF_NODE add constraint SRESOURCE_ADWFNODE foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "WF_NODECLIENT"
;

alter table AD_WF_NODE add constraint WF_NODECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE drop constraint "WF_NODEORG"
;

alter table AD_WF_NODE add constraint WF_NODEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODENEXT drop constraint "ADWFNODENEXT_ADWFNODENEXT"
;

alter table AD_WF_NODENEXT add constraint ADWFNODENEXT_ADWFNODENEXT foreign key (AD_WF_NEXT_ID) references AD_WF_NODE(AD_WF_NODE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODENEXT drop constraint "ADWFNODE_ADWFNODENEXT"
;

alter table AD_WF_NODENEXT add constraint ADWFNODE_ADWFNODENEXT foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODENEXT drop constraint "ENTITYT_ADWFNODENEXT"
;

alter table AD_WF_NODENEXT add constraint ENTITYT_ADWFNODENEXT foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODENEXT drop constraint "WF_NODENEXTCLIENT"
;

alter table AD_WF_NODENEXT add constraint WF_NODENEXTCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODENEXT drop constraint "WF_NODENEXTORG"
;

alter table AD_WF_NODENEXT add constraint WF_NODENEXTORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE_PARA drop constraint "ADPROCESSPARA_ADWFNODEPARA"
;

alter table AD_WF_NODE_PARA add constraint ADPROCESSPARA_ADWFNODEPARA foreign key (AD_PROCESS_PARA_ID) references AD_PROCESS_PARA(AD_PROCESS_PARA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE_PARA drop constraint "ADWFNODE_ADWFNODEPARA"
;

alter table AD_WF_NODE_PARA add constraint ADWFNODE_ADWFNODEPARA foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE_PARA drop constraint "ENTITYT_ADWFNODEPARA"
;

alter table AD_WF_NODE_PARA add constraint ENTITYT_ADWFNODEPARA foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE_TRL drop constraint "AD_LANGUAGE_WFNODETRL"
;

alter table AD_WF_NODE_TRL add constraint AD_LANGUAGE_WFNODETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_NODE_TRL drop constraint "AD_WFNODETRL"
;

alter table AD_WF_NODE_TRL add constraint AD_WFNODETRL foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADMESSAGE_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADMESSAGE_ADWFPROCESS foreign key (AD_MESSAGE_ID) references AD_MESSAGE(AD_MESSAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADTABLE_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADTABLE_ADWFPROCESS foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADUSER_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADUSER_ADWFPROCESS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADWFPROCESS_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADWFPROCESS_ADWFPROCESS foreign key (AD_WF_PROCESS_ID) references AD_WF_PROCESS(AD_WF_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADWFRESPONSIBLE_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADWFRESPONSIBLE_ADWFPROCESS foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "ADWORKFLOW_ADWFPROCESS"
;

alter table AD_WF_PROCESS add constraint ADWORKFLOW_ADWFPROCESS foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "WF_INSTANCECLIENT"
;

alter table AD_WF_PROCESS add constraint WF_INSTANCECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESS drop constraint "WF_INSTANCEORG"
;

alter table AD_WF_PROCESS add constraint WF_INSTANCEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_PROCESSDATA drop constraint "ADWFPROCCESS_ADWFPROCESSDATA"
;

alter table AD_WF_PROCESSDATA add constraint ADWFPROCCESS_ADWFPROCESSDATA foreign key (AD_WF_PROCESS_ID) references AD_WF_PROCESS(AD_WF_PROCESS_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_RESPONSIBLE drop constraint "ADORG_ADWFRESPONSIBLE"
;

alter table AD_WF_RESPONSIBLE add constraint ADORG_ADWFRESPONSIBLE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_RESPONSIBLE drop constraint "ADROLE_ADWFRESPONSIBLE"
;

alter table AD_WF_RESPONSIBLE add constraint ADROLE_ADWFRESPONSIBLE foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_RESPONSIBLE drop constraint "ADUSER_ADWFRESPONSIBLE"
;

alter table AD_WF_RESPONSIBLE add constraint ADUSER_ADWFRESPONSIBLE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WF_RESPONSIBLE drop constraint "ENTITYT_ADWFRESPONSIBLE"
;

alter table AD_WF_RESPONSIBLE add constraint ENTITYT_ADWFRESPONSIBLE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW drop constraint "ADCOLOR_ADWINDOW"
;

alter table AD_WINDOW add constraint ADCOLOR_ADWINDOW foreign key (AD_COLOR_ID) references AD_COLOR(AD_COLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW drop constraint "ADIMAGE_ADWINDOW"
;

alter table AD_WINDOW add constraint ADIMAGE_ADWINDOW foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW drop constraint "ENTITYT_ADWINDOW"
;

alter table AD_WINDOW add constraint ENTITYT_ADWINDOW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW drop constraint "WINDOWCLIENT"
;

alter table AD_WINDOW add constraint WINDOWCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW drop constraint "WINDOWORG"
;

alter table AD_WINDOW add constraint WINDOWORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_ACCESS drop constraint "ADROLE_ADWINDOWACCESS"
;

alter table AD_WINDOW_ACCESS add constraint ADROLE_ADWINDOWACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_ACCESS drop constraint "ADWINDOW_ADWINDOWACCESS"
;

alter table AD_WINDOW_ACCESS add constraint ADWINDOW_ADWINDOWACCESS foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_ACCESS drop constraint "AD_FUNCTACCESSORG"
;

alter table AD_WINDOW_ACCESS add constraint AD_FUNCTACCESSORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_ACCESS drop constraint "AD_FUNCTACCESS_CLIENT"
;

alter table AD_WINDOW_ACCESS add constraint AD_FUNCTACCESS_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_TRL drop constraint "AD_LANGUAGE_WINDOWTRL"
;

alter table AD_WINDOW_TRL add constraint AD_LANGUAGE_WINDOWTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WINDOW_TRL drop constraint "AD_WINDOWTRL"
;

alter table AD_WINDOW_TRL add constraint AD_WINDOWTRL foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WIZARDPROCESS drop constraint "ADWFNODE_ADWIZARDPROCESS"
;

alter table AD_WIZARDPROCESS add constraint ADWFNODE_ADWIZARDPROCESS foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH drop constraint "ADCOLOR_ADWORKBENCH"
;

alter table AD_WORKBENCH add constraint ADCOLOR_ADWORKBENCH foreign key (AD_COLOR_ID) references AD_COLOR(AD_COLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH drop constraint "ADCOLUMN_ADWORKBENCH"
;

alter table AD_WORKBENCH add constraint ADCOLUMN_ADWORKBENCH foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH drop constraint "ADIMAGE_ADWORKBENCH"
;

alter table AD_WORKBENCH add constraint ADIMAGE_ADWORKBENCH foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH drop constraint "ENTITYT_ADWORKBENCH"
;

alter table AD_WORKBENCH add constraint ENTITYT_ADWORKBENCH foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ADFORM_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ADFORM_ADWORKBENCHWINDOW foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ADPROCESS_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ADPROCESS_ADWORKBENCHWINDOW foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ADTASK_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ADTASK_ADWORKBENCHWINDOW foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ADWINDOW_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ADWINDOW_ADWORKBENCHWINDOW foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ADWORKBENCH_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ADWORKBENCH_ADWORKBENCHWINDOW foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCHWINDOW drop constraint "ENTITYT_ADWORKBENCHWINDOW"
;

alter table AD_WORKBENCHWINDOW add constraint ENTITYT_ADWORKBENCHWINDOW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH_TRL drop constraint "ADLANGUAGE_ADWORKBENCHTRL"
;

alter table AD_WORKBENCH_TRL add constraint ADLANGUAGE_ADWORKBENCHTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKBENCH_TRL drop constraint "ADWORKBENCH_ADWORKBENCHTRL"
;

alter table AD_WORKBENCH_TRL add constraint ADWORKBENCH_ADWORKBENCHTRL foreign key (AD_WORKBENCH_ID) references AD_WORKBENCH(AD_WORKBENCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "ADTABLE_ADWORKFLOW"
;

alter table AD_WORKFLOW add constraint ADTABLE_ADWORKFLOW foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "ADWFNODE_ADWORKFLOW"
;

alter table AD_WORKFLOW add constraint ADWFNODE_ADWORKFLOW foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "ADWFRESPONSIBLE_ADWORKFLOW"
;

alter table AD_WORKFLOW add constraint ADWFRESPONSIBLE_ADWORKFLOW foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "ADWORKFLOWPROCESSOR_ADWF"
;

alter table AD_WORKFLOW add constraint ADWORKFLOWPROCESSOR_ADWF foreign key (AD_WORKFLOWPROCESSOR_ID) references AD_WORKFLOWPROCESSOR(AD_WORKFLOWPROCESSOR_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "ENTITYT_ADWORKFLOW"
;

alter table AD_WORKFLOW add constraint ENTITYT_ADWORKFLOW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "SRESOURCE_ADWORKFLOW"
;

alter table AD_WORKFLOW add constraint SRESOURCE_ADWORKFLOW foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "WORKFLOWCLIENT"
;

alter table AD_WORKFLOW add constraint WORKFLOWCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW drop constraint "WORKFLOWORG"
;

alter table AD_WORKFLOW add constraint WORKFLOWORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOWPROCESSOR drop constraint "ADSCHEDULE_ADWORKFLOWPROCESSOR"
;

alter table AD_WORKFLOWPROCESSOR add constraint ADSCHEDULE_ADWORKFLOWPROCESSOR foreign key (AD_SCHEDULE_ID) references AD_SCHEDULE(AD_SCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOWPROCESSOR drop constraint "ADUSER_ADWORKFLOWPROCESSOR"
;

alter table AD_WORKFLOWPROCESSOR add constraint ADUSER_ADWORKFLOWPROCESSOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOWPROCESSORLOG drop constraint "ADWORKFLOWPROCESSOR_LOG"
;

alter table AD_WORKFLOWPROCESSORLOG add constraint ADWORKFLOWPROCESSOR_LOG foreign key (AD_WORKFLOWPROCESSOR_ID) references AD_WORKFLOWPROCESSOR(AD_WORKFLOWPROCESSOR_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_ACCESS drop constraint "ADROLE_ADWORKFLOWACCESS"
;

alter table AD_WORKFLOW_ACCESS add constraint ADROLE_ADWORKFLOWACCESS foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_ACCESS drop constraint "ADWORKFOW_WORKFLOWACCESS"
;

alter table AD_WORKFLOW_ACCESS add constraint ADWORKFOW_WORKFLOWACCESS foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_ACCESS drop constraint "AD_WORKFLOWACCESS_CLIENT"
;

alter table AD_WORKFLOW_ACCESS add constraint AD_WORKFLOWACCESS_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_ACCESS drop constraint "AD_WORKFLOWACCESS_ORG"
;

alter table AD_WORKFLOW_ACCESS add constraint AD_WORKFLOWACCESS_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_TRL drop constraint "AD_LANGUAGE_WORKFLOWTRL"
;

alter table AD_WORKFLOW_TRL add constraint AD_LANGUAGE_WORKFLOWTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table AD_WORKFLOW_TRL drop constraint "AD_WORKFLOWTRL"
;

alter table AD_WORKFLOW_TRL add constraint AD_WORKFLOWTRL foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADFIELD_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADFIELD_ASPCLIENTEXCEPTION foreign key (AD_FIELD_ID) references AD_FIELD(AD_FIELD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADFORM_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADFORM_ASPCLIENTEXCEPTION foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADPROCESSPARA_ASPCLIENTEXCEPTI"
;

alter table ASP_CLIENTEXCEPTION add constraint ADPROCESSPARA_ASPCLIENTEXCEPTI foreign key (AD_PROCESS_PARA_ID) references AD_PROCESS_PARA(AD_PROCESS_PARA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADPROCESS_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADPROCESS_ASPCLIENTEXCEPTION foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADTAB_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADTAB_ASPCLIENTEXCEPTION foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADTASK_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADTASK_ASPCLIENTEXCEPTION foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADWFNODE_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADWFNODE_ASPCLIENTEXCEPTION foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADWINDOW_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADWINDOW_ASPCLIENTEXCEPTION foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTEXCEPTION drop constraint "ADWORKFLOW_ASPCLIENTEXCEPTION"
;

alter table ASP_CLIENTEXCEPTION add constraint ADWORKFLOW_ASPCLIENTEXCEPTION foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTLEVEL drop constraint "ASPLEVEL_ASPCLIENTLEVEL"
;

alter table ASP_CLIENTLEVEL add constraint ASPLEVEL_ASPCLIENTLEVEL foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_CLIENTLEVEL drop constraint "ASPMODULE_ASPCLIENTLEVEL"
;

alter table ASP_CLIENTLEVEL add constraint ASPMODULE_ASPCLIENTLEVEL foreign key (ASP_MODULE_ID) references ASP_MODULE(ASP_MODULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_FIELD drop constraint "ADFIELD_ASPFIELD"
;

alter table ASP_FIELD add constraint ADFIELD_ASPFIELD foreign key (AD_FIELD_ID) references AD_FIELD(AD_FIELD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_FIELD drop constraint "ASPTAB_ASPFIELD"
;

alter table ASP_FIELD add constraint ASPTAB_ASPFIELD foreign key (ASP_TAB_ID) references ASP_TAB(ASP_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_FORM drop constraint "ADFORM_ASPFORM"
;

alter table ASP_FORM add constraint ADFORM_ASPFORM foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_FORM drop constraint "ASPLEVEL_ASPFORM"
;

alter table ASP_FORM add constraint ASPLEVEL_ASPFORM foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_LEVEL drop constraint "ASPMODULE_ASPLEVEL"
;

alter table ASP_LEVEL add constraint ASPMODULE_ASPLEVEL foreign key (ASP_MODULE_ID) references ASP_MODULE(ASP_MODULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_PROCESS drop constraint "ADPROCESS_ASPPROCESS"
;

alter table ASP_PROCESS add constraint ADPROCESS_ASPPROCESS foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_PROCESS drop constraint "ASPLEVEL_ASPPROCESS"
;

alter table ASP_PROCESS add constraint ASPLEVEL_ASPPROCESS foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_PROCESS_PARA drop constraint "ADPROCESSPARA_ASPPROCESSPARA"
;

alter table ASP_PROCESS_PARA add constraint ADPROCESSPARA_ASPPROCESSPARA foreign key (AD_PROCESS_PARA_ID) references AD_PROCESS_PARA(AD_PROCESS_PARA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_PROCESS_PARA drop constraint "ASPPROCESS_ASPPROCESSPARA"
;

alter table ASP_PROCESS_PARA add constraint ASPPROCESS_ASPPROCESSPARA foreign key (ASP_PROCESS_ID) references ASP_PROCESS(ASP_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_REF_LIST drop constraint "ADREFERENCE_ASPREFLIST"
;

alter table ASP_REF_LIST add constraint ADREFERENCE_ASPREFLIST foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_REF_LIST drop constraint "ADREFLIST_ASPREFLIST"
;

alter table ASP_REF_LIST add constraint ADREFLIST_ASPREFLIST foreign key (AD_REF_LIST_ID) references AD_REF_LIST(AD_REF_LIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_REF_LIST drop constraint "ASPLEVEL_ASPREFLIST"
;

alter table ASP_REF_LIST add constraint ASPLEVEL_ASPREFLIST foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_TAB drop constraint "ADTAB_ASPTAB"
;

alter table ASP_TAB add constraint ADTAB_ASPTAB foreign key (AD_TAB_ID) references AD_TAB(AD_TAB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_TAB drop constraint "ASPWINDOW_ASPTAB"
;

alter table ASP_TAB add constraint ASPWINDOW_ASPTAB foreign key (ASP_WINDOW_ID) references ASP_WINDOW(ASP_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_TASK drop constraint "ADTASK_ASPTASK"
;

alter table ASP_TASK add constraint ADTASK_ASPTASK foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_TASK drop constraint "ASPLEVEL_ASPTASK"
;

alter table ASP_TASK add constraint ASPLEVEL_ASPTASK foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_WINDOW drop constraint "ADWINDOW_ASPWINDOW"
;

alter table ASP_WINDOW add constraint ADWINDOW_ASPWINDOW foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_WINDOW drop constraint "ASPLEVEL_ASPWINDOW"
;

alter table ASP_WINDOW add constraint ASPLEVEL_ASPWINDOW foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_WORKFLOW drop constraint "ADWORKFLOW_ASPWORKFLOW"
;

alter table ASP_WORKFLOW add constraint ADWORKFLOW_ASPWORKFLOW foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table ASP_WORKFLOW drop constraint "ASPLEVEL_ASPWORKFLOW"
;

alter table ASP_WORKFLOW add constraint ASPLEVEL_ASPWORKFLOW foreign key (ASP_LEVEL_ID) references ASP_LEVEL(ASP_LEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "AASSETCLASS_AASSET"
;

alter table A_ASSET add constraint AASSETCLASS_AASSET foreign key (A_ASSET_CLASS_ID) references A_ASSET_CLASS(A_ASSET_CLASS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "AASSETGROUP_AASSET"
;

alter table A_ASSET add constraint AASSETGROUP_AASSET foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "AASSETTYPE_AASSET"
;

alter table A_ASSET add constraint AASSETTYPE_AASSET foreign key (A_ASSET_TYPE_ID) references A_ASSET_TYPE(A_ASSET_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "ADUSER_AASSET"
;

alter table A_ASSET add constraint ADUSER_AASSET foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "APARENTASSET_AASSET"
;

alter table A_ASSET add constraint APARENTASSET_AASSET foreign key (A_PARENT_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CACTIVITY_AASSET"
;

alter table A_ASSET add constraint CACTIVITY_AASSET foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CBPARTNERSR_AASSET"
;

alter table A_ASSET add constraint CBPARTNERSR_AASSET foreign key (C_BPARTNERSR_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CBPARTNER_AASSET"
;

alter table A_ASSET add constraint CBPARTNER_AASSET foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CBPLOCATION_AASSET"
;

alter table A_ASSET add constraint CBPLOCATION_AASSET foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CLOCATION_AASSET"
;

alter table A_ASSET add constraint CLOCATION_AASSET foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "CPROJECT_AASSET"
;

alter table A_ASSET add constraint CPROJECT_AASSET foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "LEASEBPARTNER_AASSET"
;

alter table A_ASSET add constraint LEASEBPARTNER_AASSET foreign key (LEASE_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "MATTRIBUTESETINSTANCE_AASSET"
;

alter table A_ASSET add constraint MATTRIBUTESETINSTANCE_AASSET foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "MINOUTLINE_AASSET"
;

alter table A_ASSET add constraint MINOUTLINE_AASSET foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "MLOCATOR_AASSET"
;

alter table A_ASSET add constraint MLOCATOR_AASSET foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET drop constraint "MPRODUCT_AASSET"
;

alter table A_ASSET add constraint MPRODUCT_AASSET foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AACCUMDEPRECIATION_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint AACCUMDEPRECIATION_AASSETACCT foreign key (A_ACCUMDEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AASSETSPREAD_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint AASSETSPREAD_AASSETACCT foreign key (A_ASSET_SPREAD_ID) references A_ASSET_SPREAD(A_ASSET_SPREAD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONCONVF_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONCONVF_AASSETACCT foreign key (A_DEPRECIATION_CONV_F_ID) references A_DEPRECIATION_CONVENTION(A_DEPRECIATION_CONVENTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONCONV_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONCONV_AASSETACCT foreign key (A_DEPRECIATION_CONV_ID) references A_DEPRECIATION_CONVENTION(A_DEPRECIATION_CONVENTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONF_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONF_AASSETACCT foreign key (A_DEPRECIATION_F_ID) references A_DEPRECIATION(A_DEPRECIATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONMETHODF_AASSETACC"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONMETHODF_AASSETACC foreign key (A_DEPRECIATION_METHOD_F_ID) references A_DEPRECIATION_METHOD(A_DEPRECIATION_METHOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONMETHOD_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONMETHOD_AASSETACCT foreign key (A_DEPRECIATION_METHOD_ID) references A_DEPRECIATION_METHOD(A_DEPRECIATION_METHOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATIONTABLEHEADER_AASSE"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATIONTABLEHEADER_AASSE foreign key (A_DEPRECIATION_TABLE_HEADER_ID) references A_DEPRECIATION_TABLE_HEADER(A_DEPRECIATION_TABLE_HEADER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADEPRECIATION_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADEPRECIATION_AASSETACCT foreign key (A_DEPRECIATION_ID) references A_DEPRECIATION(A_DEPRECIATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADISPOSALGAIN_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADISPOSALGAIN_AASSETACCT foreign key (A_DISPOSAL_GAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADISPOSALLOSS_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADISPOSALLOSS_AASSETACCT foreign key (A_DISPOSAL_LOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "ADISPOSALREVENUE_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint ADISPOSALREVENUE_AASSETACCT foreign key (A_DISPOSAL_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AREVALADEPOFFSETCUR_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint AREVALADEPOFFSETCUR_AASSETACCT foreign key (A_REVAL_ADEP_OFFSET_CUR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AREVALADEPOFFSETPRIOR_AASSETAC"
;

alter table A_ASSET_ACCT add constraint AREVALADEPOFFSETPRIOR_AASSETAC foreign key (A_REVAL_ADEP_OFFSET_PRIOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AREVALCOSTOFFSETPRIOR_AASSETAC"
;

alter table A_ASSET_ACCT add constraint AREVALCOSTOFFSETPRIOR_AASSETAC foreign key (A_REVAL_COST_OFFSET_PRIOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AREVALCOSTOFFSET_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint AREVALCOSTOFFSET_AASSETACCT foreign key (A_REVAL_COST_OFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "AREVALDEPEXPOFFSET_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint AREVALDEPEXPOFFSET_AASSETACCT foreign key (A_REVAL_DEPEXP_OFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ACCT drop constraint "CACCTSCHEMA_AASSETACCT"
;

alter table A_ASSET_ACCT add constraint CACCTSCHEMA_AASSETACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "AASSET_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint AASSET_AASSETADDITION foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CCHARGE_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CCHARGE_AASSETADDITION foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CCONVERSIONTYPE_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CCONVERSIONTYPE_AASSETADDITION foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CCURRENCY_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CCURRENCY_AASSETADDITION foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CINVOICELINE_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CINVOICELINE_AASSETADDITION foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CINVOICE_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CINVOICE_AASSETADDITION foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "CPROJECT_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint CPROJECT_AASSETADDITION foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "GLJOURNALBATCH_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint GLJOURNALBATCH_AASSETADDITION foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "IFIXEDASSET_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint IFIXEDASSET_AASSETADDITION foreign key (I_FIXEDASSET_ID) references I_FIXEDASSET(I_FIXEDASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "MATTRIBUTESETINSTANCE_AASSETAD"
;

alter table A_ASSET_ADDITION add constraint MATTRIBUTESETINSTANCE_AASSETAD foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "MINOUTLINE_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint MINOUTLINE_AASSETADDITION foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "MLOCATOR_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint MLOCATOR_AASSETADDITION foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "MMATCHINV_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint MMATCHINV_AASSETADDITION foreign key (M_MATCHINV_ID) references M_MATCHINV(M_MATCHINV_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_ADDITION drop constraint "MPRODUCT_AASSETADDITION"
;

alter table A_ASSET_ADDITION add constraint MPRODUCT_AASSETADDITION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "AAADDITION_AACHANGE"
;

alter table A_ASSET_CHANGE add constraint AAADDITION_AACHANGE foreign key (A_ASSET_ADDITION_ID) references A_ASSET_ADDITION(A_ASSET_ADDITION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "AACCUMDEPRECIATION_AASSETCHANG"
;

alter table A_ASSET_CHANGE add constraint AACCUMDEPRECIATION_AASSETCHANG foreign key (A_ACCUMDEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "AARETIREMENT_AACHANGE"
;

alter table A_ASSET_CHANGE add constraint AARETIREMENT_AACHANGE foreign key (A_ASSET_RETIREMENT_ID) references A_ASSET_RETIREMENT(A_ASSET_RETIREMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "AASSET_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint AASSET_AASSETCHANGE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "ADEPRECIATIONTABLEHEADER_AASS2"
;

alter table A_ASSET_CHANGE add constraint ADEPRECIATIONTABLEHEADER_AASS2 foreign key (A_DEPRECIATION_TABLE_HEADER_ID) references A_DEPRECIATION_TABLE_HEADER(A_DEPRECIATION_TABLE_HEADER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "ADEPRECIATION_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint ADEPRECIATION_AASSETCHANGE foreign key (A_DEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "ADISPOSALLOSS_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint ADISPOSALLOSS_AASSETCHANGE foreign key (A_DISPOSAL_LOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "ADISPOSALREVENUE_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint ADISPOSALREVENUE_AASSETCHANGE foreign key (A_DISPOSAL_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "ADUSER_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint ADUSER_AASSETCHANGE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "APARENTASSET_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint APARENTASSET_AASSETCHANGE foreign key (A_PARENT_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "CACCTSCHEMA_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint CACCTSCHEMA_AASSETCHANGE foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "CBPARTNERLOCATION_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint CBPARTNERLOCATION_AASSETCHANGE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "CBPARTNER_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint CBPARTNER_AASSETCHANGE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "CLOCATION_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint CLOCATION_AASSETCHANGE foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE drop constraint "CVALIDCOMBINATI_AASSETCHANGE"
;

alter table A_ASSET_CHANGE add constraint CVALIDCOMBINATI_AASSETCHANGE foreign key (C_VALIDCOMBINATION_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE_AMT drop constraint "AASSETCHANGE_AASSETCHANGEAMT"
;

alter table A_ASSET_CHANGE_AMT add constraint AASSETCHANGE_AASSETCHANGEAMT foreign key (A_ASSET_CHANGE_ID) references A_ASSET_CHANGE(A_ASSET_CHANGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_CHANGE_AMT drop constraint "CACCTSCHEMA_AASSETCHANGEAMT"
;

alter table A_ASSET_CHANGE_AMT add constraint CACCTSCHEMA_AASSETCHANGEAMT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DELIVERY drop constraint "AASSET_AASSETDELIVERY"
;

alter table A_ASSET_DELIVERY add constraint AASSET_AASSETDELIVERY foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DELIVERY drop constraint "ADUSER_AASSETDELIVERY"
;

alter table A_ASSET_DELIVERY add constraint ADUSER_AASSETDELIVERY foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DELIVERY drop constraint "MOUTLINE_AASSETDELIVERY"
;

alter table A_ASSET_DELIVERY add constraint MOUTLINE_AASSETDELIVERY foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DELIVERY drop constraint "MPRODUCTDL_AASSETDELIVERY"
;

alter table A_ASSET_DELIVERY add constraint MPRODUCTDL_AASSETDELIVERY foreign key (M_PRODUCTDOWNLOAD_ID) references M_PRODUCTDOWNLOAD(M_PRODUCTDOWNLOAD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DISPOSED drop constraint "AASSETTRADE_AASSETDISPOSED"
;

alter table A_ASSET_DISPOSED add constraint AASSETTRADE_AASSETDISPOSED foreign key (A_ASSET_TRADE_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DISPOSED drop constraint "AASSET_AASSETDISPOSED"
;

alter table A_ASSET_DISPOSED add constraint AASSET_AASSETDISPOSED foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DISPOSED drop constraint "CINVOICELINE_AASSETDISPOSED"
;

alter table A_ASSET_DISPOSED add constraint CINVOICELINE_AASSETDISPOSED foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DISPOSED drop constraint "CINVOICE_AASSETDISPOSED"
;

alter table A_ASSET_DISPOSED add constraint CINVOICE_AASSETDISPOSED foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_DISPOSED drop constraint "CPERIOD_AASSETDISPOSED"
;

alter table A_ASSET_DISPOSED add constraint CPERIOD_AASSETDISPOSED foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP drop constraint "AASSETCLASS_AASSETGROUP"
;

alter table A_ASSET_GROUP add constraint AASSETCLASS_AASSETGROUP foreign key (A_ASSET_CLASS_ID) references A_ASSET_CLASS(A_ASSET_CLASS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP drop constraint "AASSETTYPE_AASSETGROUP"
;

alter table A_ASSET_GROUP add constraint AASSETTYPE_AASSETGROUP foreign key (A_ASSET_TYPE_ID) references A_ASSET_TYPE(A_ASSET_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AACCUMDEPRECIATION_AASSETGROUP"
;

alter table A_ASSET_GROUP_ACCT add constraint AACCUMDEPRECIATION_AASSETGROUP foreign key (A_ACCUMDEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AASSET_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint AASSET_AASSETGROUPACCT foreign key (A_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONCONVF_AASSETGROUP"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONCONVF_AASSETGROUP foreign key (A_DEPRECIATION_CONV_F_ID) references A_DEPRECIATION_CONVENTION(A_DEPRECIATION_CONVENTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONCONV_AASSETGROUPA"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONCONV_AASSETGROUPA foreign key (A_DEPRECIATION_CONV_ID) references A_DEPRECIATION_CONVENTION(A_DEPRECIATION_CONVENTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONF_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONF_AASSETGROUPACCT foreign key (A_DEPRECIATION_F_ID) references A_DEPRECIATION(A_DEPRECIATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONMETHODF_AASSETGRO"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONMETHODF_AASSETGRO foreign key (A_DEPRECIATION_METHOD_F_ID) references A_DEPRECIATION_METHOD(A_DEPRECIATION_METHOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONMETHOD_AASSETGROU"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONMETHOD_AASSETGROU foreign key (A_DEPRECIATION_METHOD_ID) references A_DEPRECIATION_METHOD(A_DEPRECIATION_METHOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATIONTABLEHEADER_AASS3"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATIONTABLEHEADER_AASS3 foreign key (A_DEPRECIATION_TABLE_HEADER_ID) references A_DEPRECIATION_TABLE_HEADER(A_DEPRECIATION_TABLE_HEADER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADEPRECIATION_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint ADEPRECIATION_AASSETGROUPACCT foreign key (A_DEPRECIATION_ID) references A_DEPRECIATION(A_DEPRECIATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADISPOSALGAIN_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint ADISPOSALGAIN_AASSETGROUPACCT foreign key (A_DISPOSAL_GAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADISPOSALLOSS_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint ADISPOSALLOSS_AASSETGROUPACCT foreign key (A_DISPOSAL_LOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "ADISPOSALREVENUE_AASSETGROUPAC"
;

alter table A_ASSET_GROUP_ACCT add constraint ADISPOSALREVENUE_AASSETGROUPAC foreign key (A_DISPOSAL_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AREVALADEPOFFSETCUR_AASSETGROU"
;

alter table A_ASSET_GROUP_ACCT add constraint AREVALADEPOFFSETCUR_AASSETGROU foreign key (A_REVAL_ADEP_OFFSET_CUR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AREVALADEPOFFSETPRIOR_AASSETGR"
;

alter table A_ASSET_GROUP_ACCT add constraint AREVALADEPOFFSETPRIOR_AASSETGR foreign key (A_REVAL_ADEP_OFFSET_PRIOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AREVALCOSTOFFSETPRIOR_AASSETGR"
;

alter table A_ASSET_GROUP_ACCT add constraint AREVALCOSTOFFSETPRIOR_AASSETGR foreign key (A_REVAL_COST_OFFSET_PRIOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AREVALCOSTOFFSET_AASSETGROUPAC"
;

alter table A_ASSET_GROUP_ACCT add constraint AREVALCOSTOFFSET_AASSETGROUPAC foreign key (A_REVAL_COST_OFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "AREVALDEPEXPOFFSET_AASSETGROUP"
;

alter table A_ASSET_GROUP_ACCT add constraint AREVALDEPEXPOFFSET_AASSETGROUP foreign key (A_REVAL_DEPEXP_OFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_GROUP_ACCT drop constraint "CACCTSCHEMA_AASSETGROUPACCT"
;

alter table A_ASSET_GROUP_ACCT add constraint CACCTSCHEMA_AASSETGROUPACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_INFO_FIN drop constraint "AASSET_AASSETINFOFIN"
;

alter table A_ASSET_INFO_FIN add constraint AASSET_AASSETINFOFIN foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_INFO_FIN drop constraint "CBPARTNER_AASSETINFOFIN"
;

alter table A_ASSET_INFO_FIN add constraint CBPARTNER_AASSETINFOFIN foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_INFO_LIC drop constraint "AASSET_AASSETINFOLIC"
;

alter table A_ASSET_INFO_LIC add constraint AASSET_AASSETINFOLIC foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_PRODUCT drop constraint "AASSET_AASSETPRODUCT"
;

alter table A_ASSET_PRODUCT add constraint AASSET_AASSETPRODUCT foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_PRODUCT drop constraint "MATTRIBUTESETINSTANCE_AASSETPR"
;

alter table A_ASSET_PRODUCT add constraint MATTRIBUTESETINSTANCE_AASSETPR foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_PRODUCT drop constraint "MLOCATOR_AASSETPRODUCT"
;

alter table A_ASSET_PRODUCT add constraint MLOCATOR_AASSETPRODUCT foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_PRODUCT drop constraint "MPRODUCT_AASSETPRODUCT"
;

alter table A_ASSET_PRODUCT add constraint MPRODUCT_AASSETPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_RETIREMENT drop constraint "AASSET_AASSETRETIREMENT"
;

alter table A_ASSET_RETIREMENT add constraint AASSET_AASSETRETIREMENT foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_RETIREMENT drop constraint "CINVOICELINE_AASSETRETIREMENT"
;

alter table A_ASSET_RETIREMENT add constraint CINVOICELINE_AASSETRETIREMENT foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL drop constraint "AASSET_AASSETREVAL"
;

alter table A_ASSET_REVAL add constraint AASSET_AASSETREVAL foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL_ENTRY drop constraint "CACCTSCHEMA_AASSETREVALENTRY"
;

alter table A_ASSET_REVAL_ENTRY add constraint CACCTSCHEMA_AASSETREVALENTRY foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL_ENTRY drop constraint "CCURRENCY_AASSETREVALENTRY"
;

alter table A_ASSET_REVAL_ENTRY add constraint CCURRENCY_AASSETREVALENTRY foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL_ENTRY drop constraint "CDOCTYPE_AASSETREVALENTRY"
;

alter table A_ASSET_REVAL_ENTRY add constraint CDOCTYPE_AASSETREVALENTRY foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL_ENTRY drop constraint "CPERIOD_AASSETREVALENTRY"
;

alter table A_ASSET_REVAL_ENTRY add constraint CPERIOD_AASSETREVALENTRY foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_REVAL_ENTRY drop constraint "GLCATEGORY_AASSETREVALENTRY"
;

alter table A_ASSET_REVAL_ENTRY add constraint GLCATEGORY_AASSETREVALENTRY foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_SPLIT drop constraint "CPERIOD_AASSETSPLIT"
;

alter table A_ASSET_SPLIT add constraint CPERIOD_AASSETSPLIT foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "AACCUMDEPRECIATIONNEW_AASSETTR"
;

alter table A_ASSET_TRANSFER add constraint AACCUMDEPRECIATIONNEW_AASSETTR foreign key (A_ACCUMDEPRECIATION_NEW_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "AACCUMDEPRECIATION_AASSETTRANS"
;

alter table A_ASSET_TRANSFER add constraint AACCUMDEPRECIATION_AASSETTRANS foreign key (A_ACCUMDEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "AASSETNEW_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint AASSETNEW_AASSETTRANSFER foreign key (A_ASSET_NEW_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "AASSET_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint AASSET_AASSETTRANSFER foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADEPRECIATIONNEW_AASSETTRANSFE"
;

alter table A_ASSET_TRANSFER add constraint ADEPRECIATIONNEW_AASSETTRANSFE foreign key (A_DEPRECIATION_NEW_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADEPRECIATION_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint ADEPRECIATION_AASSETTRANSFER foreign key (A_DEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADISPOSALLOSSNEW_AASSETTRANSFE"
;

alter table A_ASSET_TRANSFER add constraint ADISPOSALLOSSNEW_AASSETTRANSFE foreign key (A_DISPOSAL_LOSS_NEW_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADISPOSALLOSS_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint ADISPOSALLOSS_AASSETTRANSFER foreign key (A_DISPOSAL_LOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADISPOSALREVENUENEW_AASSETTRAN"
;

alter table A_ASSET_TRANSFER add constraint ADISPOSALREVENUENEW_AASSETTRAN foreign key (A_DISPOSAL_REVENUE_NEW_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "ADISPOSALREVENUE_AASSETTRANSFE"
;

alter table A_ASSET_TRANSFER add constraint ADISPOSALREVENUE_AASSETTRANSFE foreign key (A_DISPOSAL_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "CACCTSCHEMA_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint CACCTSCHEMA_AASSETTRANSFER foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_TRANSFER drop constraint "CPERIOD_AASSETTRANSFER"
;

alter table A_ASSET_TRANSFER add constraint CPERIOD_AASSETTRANSFER foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_ASSET_USE drop constraint "AASSET_AASSETUSE"
;

alter table A_ASSET_USE add constraint AASSET_AASSETUSE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_BUILD drop constraint "AENDASSET_ADEPRECIATIONBUILD"
;

alter table A_DEPRECIATION_BUILD add constraint AENDASSET_ADEPRECIATIONBUILD foreign key (A_END_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_BUILD drop constraint "ASTARTASSET_ADEPRECIATIONBUILD"
;

alter table A_DEPRECIATION_BUILD add constraint ASTARTASSET_ADEPRECIATIONBUILD foreign key (A_START_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_BUILD drop constraint "CPERIOD_ADEPRECIATIONBUILD"
;

alter table A_DEPRECIATION_BUILD add constraint CPERIOD_ADEPRECIATIONBUILD foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_ENTRY drop constraint "CACCTSCHEMA_ADEPRECIATIONENTRY"
;

alter table A_DEPRECIATION_ENTRY add constraint CACCTSCHEMA_ADEPRECIATIONENTRY foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_ENTRY drop constraint "CCURRENCY_ADEPRECIATIONENTRY"
;

alter table A_DEPRECIATION_ENTRY add constraint CCURRENCY_ADEPRECIATIONENTRY foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_ENTRY drop constraint "CDOCTYPE_ADEPRECIATIONENTRY"
;

alter table A_DEPRECIATION_ENTRY add constraint CDOCTYPE_ADEPRECIATIONENTRY foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_ENTRY drop constraint "CPERIOD_ADEPRECIATIONENTRY"
;

alter table A_DEPRECIATION_ENTRY add constraint CPERIOD_ADEPRECIATIONENTRY foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_ENTRY drop constraint "GLCATEGORY_ADEPRECIATIONENTRY"
;

alter table A_DEPRECIATION_ENTRY add constraint GLCATEGORY_ADEPRECIATIONENTRY foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "AACCOUNTNUMBER_ADEPRECIATIONEX"
;

alter table A_DEPRECIATION_EXP add constraint AACCOUNTNUMBER_ADEPRECIATIONEX foreign key (A_ACCOUNT_NUMBER_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "AASSETADDITION_ADEPRECIATIONEX"
;

alter table A_DEPRECIATION_EXP add constraint AASSETADDITION_ADEPRECIATIONEX foreign key (A_ASSET_ADDITION_ID) references A_ASSET_ADDITION(A_ASSET_ADDITION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "AASSETDISPOSED_ADEPRECIATIONEX"
;

alter table A_DEPRECIATION_EXP add constraint AASSETDISPOSED_ADEPRECIATIONEX foreign key (A_ASSET_DISPOSED_ID) references A_ASSET_DISPOSED(A_ASSET_DISPOSED_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "AASSET_ADEPRECIATIONEXP"
;

alter table A_DEPRECIATION_EXP add constraint AASSET_ADEPRECIATIONEXP foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "ADEPRECIATIONENTRY_ADEPRECIATI"
;

alter table A_DEPRECIATION_EXP add constraint ADEPRECIATIONENTRY_ADEPRECIATI foreign key (A_DEPRECIATION_ENTRY_ID) references A_DEPRECIATION_ENTRY(A_DEPRECIATION_ENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "CRACCOU_ADEPRECIATIONEXP"
;

alter table A_DEPRECIATION_EXP add constraint CRACCOU_ADEPRECIATIONEXP foreign key (CR_ACCOUNT_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_EXP drop constraint "DRACCOU_ADEPRECIATIONEXP"
;

alter table A_DEPRECIATION_EXP add constraint DRACCOU_ADEPRECIATIONEXP foreign key (DR_ACCOUNT_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_FORECAST drop constraint "AENDASSET_ADEPRECIATIONFORECAS"
;

alter table A_DEPRECIATION_FORECAST add constraint AENDASSET_ADEPRECIATIONFORECAS foreign key (A_END_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_FORECAST drop constraint "ASTARTASSET_ADEPRECIATIONFOREC"
;

alter table A_DEPRECIATION_FORECAST add constraint ASTARTASSET_ADEPRECIATIONFOREC foreign key (A_START_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_WORKFILE drop constraint "AASSET_ADEPRECIATIONWORKFILE"
;

alter table A_DEPRECIATION_WORKFILE add constraint AASSET_ADEPRECIATIONWORKFILE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_DEPRECIATION_WORKFILE drop constraint "AFUNDINGMODE_ADEPRECIATIONWORK"
;

alter table A_DEPRECIATION_WORKFILE add constraint AFUNDINGMODE_ADEPRECIATIONWORK foreign key (A_FUNDINGMODE_ID) references A_FUNDINGMODE(A_FUNDINGMODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_FUNDINGMODE_ACCT drop constraint "AFUNDINGMODE_AFUNDINGMODEACCT"
;

alter table A_FUNDINGMODE_ACCT add constraint AFUNDINGMODE_AFUNDINGMODEACCT foreign key (A_FUNDINGMODE_ID) references A_FUNDINGMODE(A_FUNDINGMODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_FUNDINGMODE_ACCT drop constraint "CACCTSCHEMA_AFUNDINGMODEACCT"
;

alter table A_FUNDINGMODE_ACCT add constraint CACCTSCHEMA_AFUNDINGMODEACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATION drop constraint "AASSET_AREGISTRATION"
;

alter table A_REGISTRATION add constraint AASSET_AREGISTRATION foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATION drop constraint "ADUSER_AREGISTRATION"
;

alter table A_REGISTRATION add constraint ADUSER_AREGISTRATION foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATION drop constraint "CBPARTNER_AREGISTRATION"
;

alter table A_REGISTRATION add constraint CBPARTNER_AREGISTRATION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATION drop constraint "MPRODUCT_AREGISTRATION"
;

alter table A_REGISTRATION add constraint MPRODUCT_AREGISTRATION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONATTRIBUTE drop constraint "ADREFERENCEVALUE_AREGATTRIBUTE"
;

alter table A_REGISTRATIONATTRIBUTE add constraint ADREFERENCEVALUE_AREGATTRIBUTE foreign key (AD_REFERENCE_VALUE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONATTRIBUTE drop constraint "ADREFERENCE_AREGATTRIBUTE"
;

alter table A_REGISTRATIONATTRIBUTE add constraint ADREFERENCE_AREGATTRIBUTE foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONPRODUCT drop constraint "AREGATTRIBUTE_AREGPRODUCT"
;

alter table A_REGISTRATIONPRODUCT add constraint AREGATTRIBUTE_AREGPRODUCT foreign key (A_REGISTRATIONATTRIBUTE_ID) references A_REGISTRATIONATTRIBUTE(A_REGISTRATIONATTRIBUTE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONPRODUCT drop constraint "MPRODUCT_AREGPRODUCT"
;

alter table A_REGISTRATIONPRODUCT add constraint MPRODUCT_AREGPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONVALUE drop constraint "AREGATTRIBUTE_AREGVALUE"
;

alter table A_REGISTRATIONVALUE add constraint AREGATTRIBUTE_AREGVALUE foreign key (A_REGISTRATIONATTRIBUTE_ID) references A_REGISTRATIONATTRIBUTE(A_REGISTRATIONATTRIBUTE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table A_REGISTRATIONVALUE drop constraint "AREGISTRATION_AREGVALUE"
;

alter table A_REGISTRATIONVALUE add constraint AREGISTRATION_AREGVALUE foreign key (A_REGISTRATION_ID) references A_REGISTRATION(A_REGISTRATION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BID drop constraint "ADUSER_BBID"
;

alter table B_BID add constraint ADUSER_BBID foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BID drop constraint "BBUYERFUNDS_BBID"
;

alter table B_BID add constraint BBUYERFUNDS_BBID foreign key (B_BUYERFUNDS_ID) references B_BUYERFUNDS(B_BUYERFUNDS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BID drop constraint "BBUYER_BBID"
;

alter table B_BID add constraint BBUYER_BBID foreign key (AD_USER_ID) references B_BUYER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BID drop constraint "BTOPIC_BBID"
;

alter table B_BID add constraint BTOPIC_BBID foreign key (B_TOPIC_ID) references B_TOPIC(B_TOPIC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BIDCOMMENT drop constraint "ADUSER_BIDCOMMENT"
;

alter table B_BIDCOMMENT add constraint ADUSER_BIDCOMMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BIDCOMMENT drop constraint "BTOPIC_BBIDCOMMENT"
;

alter table B_BIDCOMMENT add constraint BTOPIC_BBIDCOMMENT foreign key (B_TOPIC_ID) references B_TOPIC(B_TOPIC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BUYER drop constraint "ADUSER_BBUYER"
;

alter table B_BUYER add constraint ADUSER_BBUYER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BUYERFUNDS drop constraint "ADUSER_BBUYERFUNDS"
;

alter table B_BUYERFUNDS add constraint ADUSER_BBUYERFUNDS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BUYERFUNDS drop constraint "BBUYER_BBUYERFUNDS"
;

alter table B_BUYERFUNDS add constraint BBUYER_BBUYERFUNDS foreign key (AD_USER_ID) references B_BUYER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BUYERFUNDS drop constraint "CORDER_BBUYERSFUNDS"
;

alter table B_BUYERFUNDS add constraint CORDER_BBUYERSFUNDS foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_BUYERFUNDS drop constraint "CPAYMENT_BBUYERFUNDS"
;

alter table B_BUYERFUNDS add constraint CPAYMENT_BBUYERFUNDS foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_OFFER drop constraint "ADUSER_BOFFER"
;

alter table B_OFFER add constraint ADUSER_BOFFER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_OFFER drop constraint "BSELLERFUNDS_BOFFER"
;

alter table B_OFFER add constraint BSELLERFUNDS_BOFFER foreign key (B_SELLERFUNDS_ID) references B_SELLERFUNDS(B_SELLERFUNDS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_OFFER drop constraint "BSELLER_BOFFER"
;

alter table B_OFFER add constraint BSELLER_BOFFER foreign key (AD_USER_ID) references B_SELLER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_OFFER drop constraint "BTOPIC_BOFFER"
;

alter table B_OFFER add constraint BTOPIC_BOFFER foreign key (B_TOPIC_ID) references B_TOPIC(B_TOPIC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_SELLER drop constraint "ADUSER_BSELLER"
;

alter table B_SELLER add constraint ADUSER_BSELLER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_SELLERFUNDS drop constraint "ADUSER_BSELLERFUNDS"
;

alter table B_SELLERFUNDS add constraint ADUSER_BSELLERFUNDS foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_SELLERFUNDS drop constraint "BSELLER_BSELLERFUNDS"
;

alter table B_SELLERFUNDS add constraint BSELLER_BSELLERFUNDS foreign key (AD_USER_ID) references B_SELLER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_SELLERFUNDS drop constraint "CORDER_BSELLERFUNDS"
;

alter table B_SELLERFUNDS add constraint CORDER_BSELLERFUNDS foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_SELLERFUNDS drop constraint "CPAYMENT_BSELLERFUNDS"
;

alter table B_SELLERFUNDS add constraint CPAYMENT_BSELLERFUNDS foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPIC drop constraint "BTOPICCATEGORY_BTOPIC"
;

alter table B_TOPIC add constraint BTOPICCATEGORY_BTOPIC foreign key (B_TOPICCATEGORY_ID) references B_TOPICCATEGORY(B_TOPICCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPIC drop constraint "BTOPICTYPE_BTOPIC"
;

alter table B_TOPIC add constraint BTOPICTYPE_BTOPIC foreign key (B_TOPICTYPE_ID) references B_TOPICTYPE(B_TOPICTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPICCATEGORY drop constraint "BTOPICTYPE_BTOPICCATEGORY"
;

alter table B_TOPICCATEGORY add constraint BTOPICTYPE_BTOPICCATEGORY foreign key (B_TOPICTYPE_ID) references B_TOPICTYPE(B_TOPICTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPICTYPE drop constraint "MPRICELIST_BTOPICTYPE"
;

alter table B_TOPICTYPE add constraint MPRICELIST_BTOPICTYPE foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPICTYPE drop constraint "MPRODUCT_BTOPICTYPE"
;

alter table B_TOPICTYPE add constraint MPRODUCT_BTOPICTYPE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table B_TOPICTYPE drop constraint "MPRODUCT_BTOPICTYPEMEMBER"
;

alter table B_TOPICTYPE add constraint MPRODUCT_BTOPICTYPEMEMBER foreign key (M_PRODUCTMEMBER_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSCONTAINER drop constraint "CMACCESSPROFILE_CMACCCONTAINER"
;

alter table CM_ACCESSCONTAINER add constraint CMACCESSPROFILE_CMACCCONTAINER foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSCONTAINER drop constraint "CMCONTAINER_CMACCESSCONTAINER"
;

alter table CM_ACCESSCONTAINER add constraint CMCONTAINER_CMACCESSCONTAINER foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSLISTBPGROUP drop constraint "CBPGRPUP_CMALISTBPGROUP"
;

alter table CM_ACCESSLISTBPGROUP add constraint CBPGRPUP_CMALISTBPGROUP foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSLISTBPGROUP drop constraint "CMACCESSPROFILE_CMALBPGROUP"
;

alter table CM_ACCESSLISTBPGROUP add constraint CMACCESSPROFILE_CMALBPGROUP foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSLISTROLE drop constraint "ADROLE_CMALISTROLE"
;

alter table CM_ACCESSLISTROLE add constraint ADROLE_CMALISTROLE foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSLISTROLE drop constraint "CMACCESSPROFILE_CMALISTROLE"
;

alter table CM_ACCESSLISTROLE add constraint CMACCESSPROFILE_CMALISTROLE foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSMEDIA drop constraint "CMACCESSPROFILE_CMACCESSMEDIA"
;

alter table CM_ACCESSMEDIA add constraint CMACCESSPROFILE_CMACCESSMEDIA foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSMEDIA drop constraint "CMMEDIA_CMACCESSMEDIA"
;

alter table CM_ACCESSMEDIA add constraint CMMEDIA_CMACCESSMEDIA foreign key (CM_MEDIA_ID) references CM_MEDIA(CM_MEDIA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSNEWSCHANNEL drop constraint "CMACCESPROFILE_CMANEWSCHANNEL"
;

alter table CM_ACCESSNEWSCHANNEL add constraint CMACCESPROFILE_CMANEWSCHANNEL foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSNEWSCHANNEL drop constraint "CNMEWSCHANNEL_CMACCESSNEWSC"
;

alter table CM_ACCESSNEWSCHANNEL add constraint CNMEWSCHANNEL_CMACCESSNEWSC foreign key (CM_NEWSCHANNEL_ID) references CM_NEWSCHANNEL(CM_NEWSCHANNEL_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSSTAGE drop constraint "CMACCESSPROFILE_CMACCESSSTAGE"
;

alter table CM_ACCESSSTAGE add constraint CMACCESSPROFILE_CMACCESSSTAGE foreign key (CM_ACCESSPROFILE_ID) references CM_ACCESSPROFILE(CM_ACCESSPROFILE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_ACCESSSTAGE drop constraint "CMCSTAGE_CMACCESSSTAGE"
;

alter table CM_ACCESSSTAGE add constraint CMCSTAGE_CMACCESSSTAGE foreign key (CM_CSTAGE_ID) references CM_CSTAGE(CM_CSTAGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_AD drop constraint "CMADCAT_CMAD"
;

alter table CM_AD add constraint CMADCAT_CMAD foreign key (CM_AD_CAT_ID) references CM_AD_CAT(CM_AD_CAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_AD drop constraint "CMMEDIA_CMAD"
;

alter table CM_AD add constraint CMMEDIA_CMAD foreign key (CM_MEDIA_ID) references CM_MEDIA(CM_MEDIA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_AD_CAT drop constraint "CMWEBPROJECT_CMADCAT"
;

alter table CM_AD_CAT add constraint CMWEBPROJECT_CMADCAT foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_BROADCASTSERVER drop constraint "CMWEBPROJECT_CMBROADCASTSERVER"
;

alter table CM_BROADCASTSERVER add constraint CMWEBPROJECT_CMBROADCASTSERVER foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHAT drop constraint "ADTABLE_CMCHAT"
;

alter table CM_CHAT add constraint ADTABLE_CMCHAT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHAT drop constraint "CMCHATTYPE_CMCHAT"
;

alter table CM_CHAT add constraint CMCHATTYPE_CMCHAT foreign key (CM_CHATTYPE_ID) references CM_CHATTYPE(CM_CHATTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATENTRY drop constraint "ADUSER_CMCHATENTRY"
;

alter table CM_CHATENTRY add constraint ADUSER_CMCHATENTRY foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATENTRY drop constraint "CMCHATENTRY_GRANDPARENT"
;

alter table CM_CHATENTRY add constraint CMCHATENTRY_GRANDPARENT foreign key (CM_CHATENTRYGRANDPARENT_ID) references CM_CHATENTRY(CM_CHATENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATENTRY drop constraint "CMCHAT_CHCHATENTRY"
;

alter table CM_CHATENTRY add constraint CMCHAT_CHCHATENTRY foreign key (CM_CHAT_ID) references CM_CHAT(CM_CHAT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATENTRY drop constraint "CMENTRTY_CMENTRYPARENT"
;

alter table CM_CHATENTRY add constraint CMENTRTY_CMENTRYPARENT foreign key (CM_CHATENTRYPARENT_ID) references CM_CHATENTRY(CM_CHATENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATTYPE drop constraint "ADTABLE_CMCHATTYPE"
;

alter table CM_CHATTYPE add constraint ADTABLE_CMCHATTYPE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATTYPEUPDATE drop constraint "ADUSER_CMCHATTYPEUPDATE"
;

alter table CM_CHATTYPEUPDATE add constraint ADUSER_CMCHATTYPEUPDATE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATTYPEUPDATE drop constraint "CMCHATTYPE_CMCHATTYPEUPDATE"
;

alter table CM_CHATTYPEUPDATE add constraint CMCHATTYPE_CMCHATTYPEUPDATE foreign key (CM_CHATTYPE_ID) references CM_CHATTYPE(CM_CHATTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATUPDATE drop constraint "ADUSER_CMCHATUPDATE"
;

alter table CM_CHATUPDATE add constraint ADUSER_CMCHATUPDATE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CHATUPDATE drop constraint "CMCHAT_CMCHATUPDATE"
;

alter table CM_CHATUPDATE add constraint CMCHAT_CMCHATUPDATE foreign key (CM_CHAT_ID) references CM_CHAT(CM_CHAT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER drop constraint "CMCONTAINER_CMCONTAINERLINK"
;

alter table CM_CONTAINER add constraint CMCONTAINER_CMCONTAINERLINK foreign key (CM_CONTAINERLINK_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER drop constraint "CMTEMPLATE_CMCONTAINER"
;

alter table CM_CONTAINER add constraint CMTEMPLATE_CMCONTAINER foreign key (CM_TEMPLATE_ID) references CM_TEMPLATE(CM_TEMPLATE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER drop constraint "CMWEBPROJECT_CMCONTAINER"
;

alter table CM_CONTAINER add constraint CMWEBPROJECT_CMCONTAINER foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINERTTABLE drop constraint "CMCONTAINER_CMCONTAINERTTABLE"
;

alter table CM_CONTAINERTTABLE add constraint CMCONTAINER_CMCONTAINERTTABLE foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINERTTABLE drop constraint "CMTTABLE_CMCONTAINERTABLE"
;

alter table CM_CONTAINERTTABLE add constraint CMTTABLE_CMCONTAINERTABLE foreign key (CM_TEMPLATETABLE_ID) references CM_TEMPLATETABLE(CM_TEMPLATETABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_ELEMENT drop constraint "CMCONTAINER_CMCONTAINERELEMENT"
;

alter table CM_CONTAINER_ELEMENT add constraint CMCONTAINER_CMCONTAINERELEMENT foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_ELEMENT_TRL drop constraint "ADLANGUAGE_CMCONTAINERELETRL"
;

alter table CM_CONTAINER_ELEMENT_TRL add constraint ADLANGUAGE_CMCONTAINERELETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_ELEMENT_TRL drop constraint "CMCONTAINERELEMENT_CMCETRL"
;

alter table CM_CONTAINER_ELEMENT_TRL add constraint CMCONTAINERELEMENT_CMCETRL foreign key (CM_CONTAINER_ELEMENT_ID) references CM_CONTAINER_ELEMENT(CM_CONTAINER_ELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_TRL drop constraint "ADLANGUAGE_CMCONTAINERTRL"
;

alter table CM_CONTAINER_TRL add constraint ADLANGUAGE_CMCONTAINERTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_TRL drop constraint "CMCONTAINER_CMCONTAINERTRL"
;

alter table CM_CONTAINER_TRL add constraint CMCONTAINER_CMCONTAINERTRL foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CONTAINER_URL drop constraint "CMCONTAINER_CMCONTAINERURL"
;

alter table CM_CONTAINER_URL add constraint CMCONTAINER_CMCONTAINERURL foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE drop constraint "CMCSTAGE_CMCSTAGELINK"
;

alter table CM_CSTAGE add constraint CMCSTAGE_CMCSTAGELINK foreign key (CM_CSTAGELINK_ID) references CM_CSTAGE(CM_CSTAGE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE drop constraint "CMTEMPLATE_CMCSTAGE"
;

alter table CM_CSTAGE add constraint CMTEMPLATE_CMCSTAGE foreign key (CM_TEMPLATE_ID) references CM_TEMPLATE(CM_TEMPLATE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE drop constraint "CMWEBPROJECT_CMCSTAGE"
;

alter table CM_CSTAGE add constraint CMWEBPROJECT_CMCSTAGE foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGETTABLE drop constraint "CMSTAGE_CMCSTAGETTABLE"
;

alter table CM_CSTAGETTABLE add constraint CMSTAGE_CMCSTAGETTABLE foreign key (CM_CSTAGE_ID) references CM_CSTAGE(CM_CSTAGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGETTABLE drop constraint "CMTTABLE_CMSTAGETTABLE"
;

alter table CM_CSTAGETTABLE add constraint CMTTABLE_CMSTAGETTABLE foreign key (CM_TEMPLATETABLE_ID) references CM_TEMPLATETABLE(CM_TEMPLATETABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE_ELEMENT drop constraint "CMCSTAGE_CMCSTAGEELEMENT"
;

alter table CM_CSTAGE_ELEMENT add constraint CMCSTAGE_CMCSTAGEELEMENT foreign key (CM_CSTAGE_ID) references CM_CSTAGE(CM_CSTAGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE_ELEMENT_TRL drop constraint "ADLANGUAGE_CMCSTAGEELETRL"
;

alter table CM_CSTAGE_ELEMENT_TRL add constraint ADLANGUAGE_CMCSTAGEELETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE_ELEMENT_TRL drop constraint "CMCSTAGEELEMENT_CMCSETRL"
;

alter table CM_CSTAGE_ELEMENT_TRL add constraint CMCSTAGEELEMENT_CMCSETRL foreign key (CM_CSTAGE_ELEMENT_ID) references CM_CSTAGE_ELEMENT(CM_CSTAGE_ELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE_TRL drop constraint "ADLANGUAGE_CMCSTAGETRL"
;

alter table CM_CSTAGE_TRL add constraint ADLANGUAGE_CMCSTAGETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_CSTAGE_TRL drop constraint "CMCSTAGE_CMCSTAGETRL"
;

alter table CM_CSTAGE_TRL add constraint CMCSTAGE_CMCSTAGETRL foreign key (CM_CSTAGE_ID) references CM_CSTAGE(CM_CSTAGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_MEDIA drop constraint "ADIMAGE_CMMEDIA"
;

alter table CM_MEDIA add constraint ADIMAGE_CMMEDIA foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_MEDIA drop constraint "CMWEBPROJECT_CMMEDIA"
;

alter table CM_MEDIA add constraint CMWEBPROJECT_CMMEDIA foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_MEDIADEPLOY drop constraint "CMMEDIASERVER_CMMEDIADEPLOY"
;

alter table CM_MEDIADEPLOY add constraint CMMEDIASERVER_CMMEDIADEPLOY foreign key (CM_MEDIA_SERVER_ID) references CM_MEDIA_SERVER(CM_MEDIA_SERVER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_MEDIADEPLOY drop constraint "CMMEDIA_CMMEDIADEPLOY"
;

alter table CM_MEDIADEPLOY add constraint CMMEDIA_CMMEDIADEPLOY foreign key (CM_MEDIA_ID) references CM_MEDIA(CM_MEDIA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_MEDIA_SERVER drop constraint "CMWEBPROJECT_CMMEDIASERVER"
;

alter table CM_MEDIA_SERVER add constraint CMWEBPROJECT_CMMEDIASERVER foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_NEWSCHANNEL drop constraint "ADLANGU_CMNEWSCHANNEL"
;

alter table CM_NEWSCHANNEL add constraint ADLANGU_CMNEWSCHANNEL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_NEWSCHANNEL drop constraint "CMWEBPROJECT_CMNEWSCHANNEL"
;

alter table CM_NEWSCHANNEL add constraint CMWEBPROJECT_CMNEWSCHANNEL foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_NEWSITEM drop constraint "CMNEWSCHANNEL_CMNEWSITEM"
;

alter table CM_NEWSITEM add constraint CMNEWSCHANNEL_CMNEWSITEM foreign key (CM_NEWSCHANNEL_ID) references CM_NEWSCHANNEL(CM_NEWSCHANNEL_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_TEMPLATE drop constraint "CMWEBPROJECT_CMTEMPLATE"
;

alter table CM_TEMPLATE add constraint CMWEBPROJECT_CMTEMPLATE foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_TEMPLATETABLE drop constraint "ADTABLE_CMTEMPLATETABLE"
;

alter table CM_TEMPLATETABLE add constraint ADTABLE_CMTEMPLATETABLE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_TEMPLATETABLE drop constraint "CMTEMPLATE_CMTTABLE"
;

alter table CM_TEMPLATETABLE add constraint CMTEMPLATE_CMTTABLE foreign key (CM_TEMPLATE_ID) references CM_TEMPLATE(CM_TEMPLATE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_TEMPLATE_AD_CAT drop constraint "CMADCAT_CMTEMPLATEADCAT"
;

alter table CM_TEMPLATE_AD_CAT add constraint CMADCAT_CMTEMPLATEADCAT foreign key (CM_AD_CAT_ID) references CM_AD_CAT(CM_AD_CAT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_TEMPLATE_AD_CAT drop constraint "CMTEMPLATE_CMTEMPLATEADCAT"
;

alter table CM_TEMPLATE_AD_CAT add constraint CMTEMPLATE_CMTEMPLATEADCAT foreign key (CM_TEMPLATE_ID) references CM_TEMPLATE(CM_TEMPLATE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBACCESSLOG drop constraint "ADUSER_CMWEBACCESSLOG"
;

alter table CM_WEBACCESSLOG add constraint ADUSER_CMWEBACCESSLOG foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBACCESSLOG drop constraint "CMBROADCASTSERVER_CMWEBALOG"
;

alter table CM_WEBACCESSLOG add constraint CMBROADCASTSERVER_CMWEBALOG foreign key (CM_BROADCASTSERVER_ID) references CM_BROADCASTSERVER(CM_BROADCASTSERVER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBACCESSLOG drop constraint "CMMEDIA_CMWEBACCESSLOG"
;

alter table CM_WEBACCESSLOG add constraint CMMEDIA_CMWEBACCESSLOG foreign key (CM_MEDIA_ID) references CM_MEDIA(CM_MEDIA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBACCESSLOG drop constraint "CMWEBPROJECT_CMWEBACCESSLOG"
;

alter table CM_WEBACCESSLOG add constraint CMWEBPROJECT_CMWEBACCESSLOG foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT drop constraint "ADTREECMC_CMWEBPROJECT"
;

alter table CM_WEBPROJECT add constraint ADTREECMC_CMWEBPROJECT foreign key (AD_TREECMC_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT drop constraint "ADTREECMM_CMWEBPROJECT"
;

alter table CM_WEBPROJECT add constraint ADTREECMM_CMWEBPROJECT foreign key (AD_TREECMM_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT drop constraint "ADTREECMS_CMWEBPROJECT"
;

alter table CM_WEBPROJECT add constraint ADTREECMS_CMWEBPROJECT foreign key (AD_TREECMS_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT drop constraint "ADTREECMT_CMWEBPROJECT"
;

alter table CM_WEBPROJECT add constraint ADTREECMT_CMWEBPROJECT foreign key (AD_TREECMT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT_DOMAIN drop constraint "CMCONTAINER_CMWEBPROJECTDOMAIN"
;

alter table CM_WEBPROJECT_DOMAIN add constraint CMCONTAINER_CMWEBPROJECTDOMAIN foreign key (CM_CONTAINER_ID) references CM_CONTAINER(CM_CONTAINER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WEBPROJECT_DOMAIN drop constraint "CMWEBPROJECT_CMWPDOMAIN"
;

alter table CM_WEBPROJECT_DOMAIN add constraint CMWEBPROJECT_CMWPDOMAIN foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table CM_WIKITOKEN drop constraint "ADTABLE_CMWIKITOKEN"
;

alter table CM_WIKITOKEN add constraint ADTABLE_CMWIKITOKEN foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTPROCESSOR drop constraint "ADSCHEDULE_CACCTPROCESSOR"
;

alter table C_ACCTPROCESSOR add constraint ADSCHEDULE_CACCTPROCESSOR foreign key (AD_SCHEDULE_ID) references AD_SCHEDULE(AD_SCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTPROCESSOR drop constraint "ADTABLE_CACCTPROCESSOR"
;

alter table C_ACCTPROCESSOR add constraint ADTABLE_CACCTPROCESSOR foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTPROCESSOR drop constraint "ADUSER_CACCTPROCESSOR"
;

alter table C_ACCTPROCESSOR add constraint ADUSER_CACCTPROCESSOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTPROCESSOR drop constraint "CACCTSCHEMA_CACCTPROCESSOR"
;

alter table C_ACCTPROCESSOR add constraint CACCTSCHEMA_CACCTPROCESSOR foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTPROCESSORLOG drop constraint "CACCTPROCESSOR_LOG"
;

alter table C_ACCTPROCESSORLOG add constraint CACCTPROCESSOR_LOG foreign key (C_ACCTPROCESSOR_ID) references C_ACCTPROCESSOR(C_ACCTPROCESSOR_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "ADORGONLY_CACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint ADORGONLY_CACCTSCHEMA foreign key (AD_ORGONLY_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "AD_CLIENT_C_ACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint AD_CLIENT_C_ACCTSCHEMA foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "AD_ORG_C_ACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint AD_ORG_C_ACCTSCHEMA foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "CPERIOD_CACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint CPERIOD_CACCTSCHEMA foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "C_CURRENCY_C_ACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint C_CURRENCY_C_ACCTSCHEMA foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA drop constraint "MCOSTTYPE_CACCTSCHEMA"
;

alter table C_ACCTSCHEMA add constraint MCOSTTYPE_CACCTSCHEMA foreign key (M_COSTTYPE_ID) references M_COSTTYPE(M_COSTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "CACCTSCHEMA_DEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint CACCTSCHEMA_DEFAULT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "CHREVENUE_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint CHREVENUE_CACCTSCHEMADEFAULT foreign key (CH_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PAVERAGECOSTVARIANCE_CACCTSCHE"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PAVERAGECOSTVARIANCE_CACCTSCHE foreign key (P_AVERAGECOSTVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PBURDEN_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PBURDEN_CACCTSCHEMADEFAULT foreign key (P_BURDEN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PCOSTADJUSTMENT_CACCTSCHEMADEF"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PCOSTADJUSTMENT_CACCTSCHEMADEF foreign key (P_COSTADJUSTMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PCOSTOFPRODUCTION_CACCTSCHEMAD"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PCOSTOFPRODUCTION_CACCTSCHEMAD foreign key (P_COSTOFPRODUCTION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PFLOORSTOCK_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PFLOORSTOCK_CACCTSCHEMADEFAULT foreign key (P_FLOORSTOCK_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PINVENTORYCLEARING_CACCTSCHEMA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PINVENTORYCLEARING_CACCTSCHEMA foreign key (P_INVENTORYCLEARING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PLABOR_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PLABOR_CACCTSCHEMADEFAULT foreign key (P_LABOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PMETHODCHANGEVARIANCE_CACCTSCH"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PMETHODCHANGEVARIANCE_CACCTSCH foreign key (P_METHODCHANGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PMIXVARIANCE_CACCTSCHEMADEFAUL"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PMIXVARIANCE_CACCTSCHEMADEFAUL foreign key (P_MIXVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "POUTSIDEPROCESSING_CACCTSCHEMA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint POUTSIDEPROCESSING_CACCTSCHEMA foreign key (P_OUTSIDEPROCESSING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "POVERHEAD_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint POVERHEAD_CACCTSCHEMADEFAULT foreign key (P_OVERHEAD_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PRATEVARIANCE_CACCTSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PRATEVARIANCE_CACCTSCHEMADEFAU foreign key (P_RATEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PSCRAP_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PSCRAP_CACCTSCHEMADEFAULT foreign key (P_SCRAP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PUSAGEVARIANCE_CACCTSCHEMADEFA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PUSAGEVARIANCE_CACCTSCHEMADEFA foreign key (P_USAGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "PWIP_CACCTSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint PWIP_CACCTSCHEMADEFAULT foreign key (P_WIP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BASSET_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BASSET_CSCHEMADEFAULT foreign key (B_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BEXPENSE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BEXPENSE_CSCHEMADEFAULT foreign key (B_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BINTERESTEXP_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BINTERESTEXP_CSCHEMADEFAULT foreign key (B_INTERESTEXP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BINTERESTREV_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BINTERESTREV_CSCHEMADEFAULT foreign key (B_INTERESTREV_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BINTRANSIT_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BINTRANSIT_CSCHEMADEFAULT foreign key (B_INTRANSIT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BPAYMENTSELECT_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BPAYMENTSELECT_CSCHEMADEFAU foreign key (B_PAYMENTSELECT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BREVALUATIONGAIN_CSCHEMADEF"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BREVALUATIONGAIN_CSCHEMADEF foreign key (B_REVALUATIONGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BREVALUATIONLOSS_CSCHEMADEF"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BREVALUATIONLOSS_CSCHEMADEF foreign key (B_REVALUATIONLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BSETTLEMENTGAIN_CSCHEMADEFA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BSETTLEMENTGAIN_CSCHEMADEFA foreign key (B_SETTLEMENTGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BSETTLEMENTLOSS_CSCHEMADEFA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BSETTLEMENTLOSS_CSCHEMADEFA foreign key (B_SETTLEMENTLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BUNALLOCATEDCASH_CSCHEMADEF"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BUNALLOCATEDCASH_CSCHEMADEF foreign key (B_UNALLOCATEDCASH_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_BUNIDENTIFIED_CSCHEMADEFAUL"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_BUNIDENTIFIED_CSCHEMADEFAUL foreign key (B_UNIDENTIFIED_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_CHEXPENSE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_CHEXPENSE_CSCHEMADEFAULT foreign key (CH_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_CPREPAYMENT_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_CPREPAYMENT_CSCHEMADEFAULT foreign key (C_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_CRECEIVABLE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_CRECEIVABLE_CSCHEMADEFAULT foreign key (C_RECEIVABLE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_EEXPENSE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_EEXPENSE_CSCHEMADEFAULT foreign key (E_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_EPREPAYMENT_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_EPREPAYMENT_CSCHEMADEFAULT foreign key (E_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_NOTINVOICEDRECEIPTS_CSCHEMA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_NOTINVOICEDRECEIPTS_CSCHEMA foreign key (NOTINVOICEDRECEIPTS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_NOTINVOICEDREC_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_NOTINVOICEDREC_CSCHEMADEFAU foreign key (NOTINVOICEDRECEIVABLES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_NOTINVOICEDREVENUE_CSCHEMAD"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_NOTINVOICEDREVENUE_CSCHEMAD foreign key (NOTINVOICEDREVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PASSET_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PASSET_CSCHEMADEFAULT foreign key (P_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PAYDISCOUNTEXP_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PAYDISCOUNTEXP_CSCHEMADEFAU foreign key (PAYDISCOUNT_EXP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PAYDISCOUNTREV_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PAYDISCOUNTREV_CSCHEMADEFAU foreign key (PAYDISCOUNT_REV_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PCOGS_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PCOGS_CSCHEMADEFAULT foreign key (P_COGS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PEXPENSE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PEXPENSE_CSCHEMADEFAULT foreign key (P_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PINVOICEPV_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PINVOICEPV_CSCHEMADEFAULT foreign key (P_INVOICEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PJASSET_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PJASSET_CSCHEMADEFAULT foreign key (PJ_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PJWIP_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PJWIP_CSCHEMADEFAULT foreign key (PJ_WIP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PPURCHASEPV_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PPURCHASEPV_CSCHEMADEFAULT foreign key (P_PURCHASEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PREVENUE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PREVENUE_CSCHEMADEFAULT foreign key (P_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PTDISCOUNTGRANT_CSCHEMADEFA"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PTDISCOUNTGRANT_CSCHEMADEFA foreign key (P_TRADEDISCOUNTGRANT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_PTDISCOUNTREC_CSCHEMADEFAUL"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_PTDISCOUNTREC_CSCHEMADEFAUL foreign key (P_TRADEDISCOUNTREC_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_REALIZEDGAIN_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_REALIZEDGAIN_CSCHEMADEFAULT foreign key (REALIZEDGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_REALIZEDLOSS_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_REALIZEDLOSS_CSCHEMADEFAULT foreign key (REALIZEDLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_TCREDIT_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_TCREDIT_CSCHEMADEFAULT foreign key (T_CREDIT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_TDUE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_TDUE_CSCHEMADEFAULT foreign key (T_DUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_TEXPENSE_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_TEXPENSE_CSCHEMADEFAULT foreign key (T_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_TLIABILITY_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_TLIABILITY_CSCHEMADEFAULT foreign key (T_LIABILITY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_TREC_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_TREC_CSCHEMADEFAULT foreign key (T_RECEIVABLES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_UNREALIZEDGAIN_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_UNREALIZEDGAIN_CSCHEMADEFAU foreign key (UNREALIZEDGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_UNREALIZEDLOSS_CSCHEMADEFAU"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_UNREALIZEDLOSS_CSCHEMADEFAU foreign key (UNREALIZEDLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_VLIABILITY_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_VLIABILITY_CSCHEMADEFAULT foreign key (V_LIABILITY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_VPREPAYMENT_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_VPREPAYMENT_CSCHEMADEFAULT foreign key (V_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WDIFFERENCES_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WDIFFERENCES_CSCHEMADEFAULT foreign key (W_DIFFERENCES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WINVACTUALADJUST_CSCHEMADEF"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WINVACTUALADJUST_CSCHEMADEF foreign key (W_INVACTUALADJUST_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WINVENTORY_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WINVENTORY_CSCHEMADEFAULT foreign key (W_INVENTORY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WITHHOLDING_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WITHHOLDING_CSCHEMADEFAULT foreign key (WITHHOLDING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WREVALUATION_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WREVALUATION_CSCHEMADEFAULT foreign key (W_REVALUATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_DEFAULT drop constraint "VC_WRITEOFF_CSCHEMADEFAULT"
;

alter table C_ACCTSCHEMA_DEFAULT add constraint VC_WRITEOFF_CSCHEMADEFAULT foreign key (WRITEOFF_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "ADCLIENT_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint ADCLIENT_CASCHEMAELEMENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "ADCOLUMN_CACCTSCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint ADCOLUMN_CACCTSCHEMAELEMENT foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "ADORGID_C_ASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint ADORGID_C_ASCHEMAELEMENT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "ADORG_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint ADORG_CASCHEMAELEMENT foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CACCTSCHEMA_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CACCTSCHEMA_CASCHEMAELEMENT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CACTIVITY_CACCTSCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CACTIVITY_CACCTSCHEMAELEMENT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CBUSPARTNER_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CBUSPARTNER_CASCHEMAELEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CELEMENTVALUE_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CELEMENTVALUE_CASCHEMAELEMENT foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CELEMENT_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CELEMENT_CASCHEMAELEMENT foreign key (C_ELEMENT_ID) references C_ELEMENT(C_ELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CLOCATION_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CLOCATION_CASCHEMAELEMENT foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CPROJECT_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CPROJECT_CASCHEMAELEMENT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "CSALESREGION_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint CSALESREGION_CASCHEMAELEMENT foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "MPRODUCT_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint MPRODUCT_CASCHEMAELEMENT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_ELEMENT drop constraint "SOCAMPAIGN_CASCHEMAELEMENT"
;

alter table C_ACCTSCHEMA_ELEMENT add constraint SOCAMPAIGN_CASCHEMAELEMENT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "CACCTSCHEMA_CACCTSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint CACCTSCHEMA_CACCTSCHEMAGL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "COMMITMENTOFFSETSALES_CACCTSCH"
;

alter table C_ACCTSCHEMA_GL add constraint COMMITMENTOFFSETSALES_CACCTSCH foreign key (COMMITMENTOFFSETSALES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "COMMITMENTOFFSET_CACCTSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint COMMITMENTOFFSET_CACCTSCHEMAGL foreign key (COMMITMENTOFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_CURRENCYBALANCING_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_CURRENCYBALANCING_CSCHEMAGL foreign key (CURRENCYBALANCING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_INCOMESUMMARY_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_INCOMESUMMARY_CSCHEMAGL foreign key (INCOMESUMMARY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_INTERCOMPANYDUEFROM_CSCHEMA"
;

alter table C_ACCTSCHEMA_GL add constraint VC_INTERCOMPANYDUEFROM_CSCHEMA foreign key (INTERCOMPANYDUEFROM_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_INTERCOMPANYDUETO_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_INTERCOMPANYDUETO_CSCHEMAGL foreign key (INTERCOMPANYDUETO_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_PPVOFFSET_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_PPVOFFSET_CSCHEMAGL foreign key (PPVOFFSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_RETAINEDEARNING_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_RETAINEDEARNING_CSCHEMAGL foreign key (RETAINEDEARNING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_SUSPENSEBALANCING_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_SUSPENSEBALANCING_CSCHEMAGL foreign key (SUSPENSEBALANCING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ACCTSCHEMA_GL drop constraint "VC_SUSPENSEERROR_CSCHEMAGL"
;

alter table C_ACCTSCHEMA_GL add constraint VC_SUSPENSEERROR_CSCHEMAGL foreign key (SUSPENSEERROR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONHDR drop constraint "CCURRENCY_CALLOCATION"
;

alter table C_ALLOCATIONHDR add constraint CCURRENCY_CALLOCATION foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CALLOCATION_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CALLOCATION_CALLOCATIONLINE foreign key (C_ALLOCATIONHDR_ID) references C_ALLOCATIONHDR(C_ALLOCATIONHDR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CBPARTNER_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CBPARTNER_CALLOCATIONLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CCASHLINE_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CCASHLINE_CALLOCATIONLINE foreign key (C_CASHLINE_ID) references C_CASHLINE(C_CASHLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CCHARGE_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CCHARGE_CALLOCATIONLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CINVOICE_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CINVOICE_CALLOCATIONLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CORDER_CALLOCATION"
;

alter table C_ALLOCATIONLINE add constraint CORDER_CALLOCATION foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ALLOCATIONLINE drop constraint "CPAYMENT_CALLOCATIONLINE"
;

alter table C_ALLOCATIONLINE add constraint CPAYMENT_CALLOCATIONLINE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANK drop constraint "CLOCATION_CBANK"
;

alter table C_BANK add constraint CLOCATION_CBANK foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT drop constraint "CBANK_CBANKACCOUNT"
;

alter table C_BANKACCOUNT add constraint CBANK_CBANKACCOUNT foreign key (C_BANK_ID) references C_BANK(C_BANK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT drop constraint "CCURRENCY_CBANKACCOUNT"
;

alter table C_BANKACCOUNT add constraint CCURRENCY_CBANKACCOUNT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNTDOC drop constraint "ADPRINTFORMAT_CBANKACCOUNTDOC"
;

alter table C_BANKACCOUNTDOC add constraint ADPRINTFORMAT_CBANKACCOUNTDOC foreign key (CHECK_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNTDOC drop constraint "CBANKACCOUNT_CBADOC"
;

alter table C_BANKACCOUNTDOC add constraint CBANKACCOUNT_CBADOC foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "CACCTSCHEMA_CBANKACCOUNTACCT"
;

alter table C_BANKACCOUNT_ACCT add constraint CACCTSCHEMA_CBANKACCOUNTACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "CBANKACCOUNT_CBANKACCTACCT"
;

alter table C_BANKACCOUNT_ACCT add constraint CBANKACCOUNT_CBANKACCTACCT foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BASSET_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BASSET_CBANKACCOUNT foreign key (B_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BEXPENSE_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BEXPENSE_CBANKACCOUNT foreign key (B_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BINTERESTEXP_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BINTERESTEXP_CBANKACCOUNT foreign key (B_INTERESTEXP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BINTERESTREV_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BINTERESTREV_CBANKACCOUNT foreign key (B_INTERESTREV_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BINTRANSIT_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BINTRANSIT_CBANKACCOUNT foreign key (B_INTRANSIT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BPAYMENTSELECT_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BPAYMENTSELECT_CBANKACCOUNT foreign key (B_PAYMENTSELECT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BREVALUATIONGAIN_CBANKACCOU"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BREVALUATIONGAIN_CBANKACCOU foreign key (B_REVALUATIONGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BREVALUATIONLOSS_CBANKACCOU"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BREVALUATIONLOSS_CBANKACCOU foreign key (B_REVALUATIONLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BSETTLEMENTGAIN_CBANKACCOUN"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BSETTLEMENTGAIN_CBANKACCOUN foreign key (B_SETTLEMENTGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BSETTLEMENTLOSS_CBANKACCOUN"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BSETTLEMENTLOSS_CBANKACCOUN foreign key (B_SETTLEMENTLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BUNALLOCATEDCASH_CBANKACCOU"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BUNALLOCATEDCASH_CBANKACCOU foreign key (B_UNALLOCATEDCASH_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_ACCT drop constraint "VC_BUNIDENTIFIED_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_ACCT add constraint VC_BUNIDENTIFIED_CBANKACCOUNT foreign key (B_UNIDENTIFIED_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_PROCESSOR drop constraint "CBANKACCOUNT_CBANKACCOUNTPROCE"
;

alter table C_BANKACCOUNT_PROCESSOR add constraint CBANKACCOUNT_CBANKACCOUNTPROCE foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKACCOUNT_PROCESSOR drop constraint "CPAYMENTPROCESSOR_CBANKACCOUNT"
;

alter table C_BANKACCOUNT_PROCESSOR add constraint CPAYMENTPROCESSOR_CBANKACCOUNT foreign key (C_PAYMENTPROCESSOR_ID) references C_PAYMENTPROCESSOR(C_PAYMENTPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENT drop constraint "CBANKACCOUNT_CBANKSTATEMENT"
;

alter table C_BANKSTATEMENT add constraint CBANKACCOUNT_CBANKSTATEMENT foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CBPARTNER_CBANKSTATEMENTLINE"
;

alter table C_BANKSTATEMENTLINE add constraint CBPARTNER_CBANKSTATEMENTLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CBSTATEMENT_CBSTATEMENTLINE"
;

alter table C_BANKSTATEMENTLINE add constraint CBSTATEMENT_CBSTATEMENTLINE foreign key (C_BANKSTATEMENT_ID) references C_BANKSTATEMENT(C_BANKSTATEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CCHARGE_CBANKSTMTLIME"
;

alter table C_BANKSTATEMENTLINE add constraint CCHARGE_CBANKSTMTLIME foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CCURRENCY_CBANKSTMTLINE"
;

alter table C_BANKSTATEMENTLINE add constraint CCURRENCY_CBANKSTMTLINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CINVOICE_CBANKSTATEMENTLINE"
;

alter table C_BANKSTATEMENTLINE add constraint CINVOICE_CBANKSTATEMENTLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLINE drop constraint "CPAYMENT_CBANKSTMTLINE"
;

alter table C_BANKSTATEMENTLINE add constraint CPAYMENT_CBANKSTMTLINE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BANKSTATEMENTLOADER drop constraint "CBANKACCT_CBANKSTMTLOADER"
;

alter table C_BANKSTATEMENTLOADER add constraint CBANKACCT_CBANKSTMTLOADER foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "ADCLIENT_CBPARTNER"
;

alter table C_BPARTNER add constraint ADCLIENT_CBPARTNER foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "ADORG_CBPARTNER"
;

alter table C_BPARTNER add constraint ADORG_CBPARTNER foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "ADORG_CBPARTNERORG"
;

alter table C_BPARTNER add constraint ADORG_CBPARTNERORG foreign key (AD_ORGBP_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "ADPRINTFORMATINV_CBPARTNER"
;

alter table C_BPARTNER add constraint ADPRINTFORMATINV_CBPARTNER foreign key (INVOICE_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "ADUSERSALESREP_CBPARTNER"
;

alter table C_BPARTNER add constraint ADUSERSALESREP_CBPARTNER foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "AD_LANGUAGE_C_BUSPARTNER"
;

alter table C_BPARTNER add constraint AD_LANGUAGE_C_BUSPARTNER foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CBPARTNER_CPBARTNERPARENT"
;

alter table C_BPARTNER add constraint CBPARTNER_CPBARTNERPARENT foreign key (BPARTNER_PARENT_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CBPGROUP_CBPARTNER"
;

alter table C_BPARTNER add constraint CBPGROUP_CBPARTNER foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CDUNNING_CBPARTNER"
;

alter table C_BPARTNER add constraint CDUNNING_CBPARTNER foreign key (C_DUNNING_ID) references C_DUNNING(C_DUNNING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CGREETING_CBPARTNER"
;

alter table C_BPARTNER add constraint CGREETING_CBPARTNER foreign key (C_GREETING_ID) references C_GREETING(C_GREETING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CINVOICESCHEDULE_CBPARTNER"
;

alter table C_BPARTNER add constraint CINVOICESCHEDULE_CBPARTNER foreign key (C_INVOICESCHEDULE_ID) references C_INVOICESCHEDULE(C_INVOICESCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CPAYMENTTERM_CBPARTNER"
;

alter table C_BPARTNER add constraint CPAYMENTTERM_CBPARTNER foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CPOPAYMENTTERM_CBPARTNER"
;

alter table C_BPARTNER add constraint CPOPAYMENTTERM_CBPARTNER foreign key (PO_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "CTAXGROUP_CBPARTNER"
;

alter table C_BPARTNER add constraint CTAXGROUP_CBPARTNER foreign key (C_TAXGROUP_ID) references C_TAXGROUP(C_TAXGROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "LOGO_CBPARTNER"
;

alter table C_BPARTNER add constraint LOGO_CBPARTNER foreign key (LOGO_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "MDISCOUNTSPO_CBPARTNER"
;

alter table C_BPARTNER add constraint MDISCOUNTSPO_CBPARTNER foreign key (PO_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "MDISCOUNTS_CBPARTNER"
;

alter table C_BPARTNER add constraint MDISCOUNTS_CBPARTNER foreign key (M_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "MPRICELISTPO_CBUSPARTNER"
;

alter table C_BPARTNER add constraint MPRICELISTPO_CBUSPARTNER foreign key (PO_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER drop constraint "MPRICELIST_CBPARTNER"
;

alter table C_BPARTNER add constraint MPRICELIST_CBPARTNER foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_LOCATION drop constraint "CBPARTNER_CBPLOCATION"
;

alter table C_BPARTNER_LOCATION add constraint CBPARTNER_CBPLOCATION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_LOCATION drop constraint "CLOCATION_CBPLOCATION"
;

alter table C_BPARTNER_LOCATION add constraint CLOCATION_CBPLOCATION foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_LOCATION drop constraint "CSALESREGION_BPARTNERLOCATION"
;

alter table C_BPARTNER_LOCATION add constraint CSALESREGION_BPARTNERLOCATION foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_LOCATION drop constraint "C_BUSPARTNER_LOCATIONCLIENT"
;

alter table C_BPARTNER_LOCATION add constraint C_BUSPARTNER_LOCATIONCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_LOCATION drop constraint "C_BUSPARTNER_LOCATIONORG"
;

alter table C_BPARTNER_LOCATION add constraint C_BUSPARTNER_LOCATIONORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_PRODUCT drop constraint "CBPARTNER_CBPPRODUCT"
;

alter table C_BPARTNER_PRODUCT add constraint CBPARTNER_CBPPRODUCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BPARTNER_PRODUCT drop constraint "MPRODUCT_CBPPRODUCT"
;

alter table C_BPARTNER_PRODUCT add constraint MPRODUCT_CBPPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_BANKACCOUNT drop constraint "ADUSER_CBPBANKACCOUNT"
;

alter table C_BP_BANKACCOUNT add constraint ADUSER_CBPBANKACCOUNT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_BANKACCOUNT drop constraint "CBANK_CBPBANKACCOUNT"
;

alter table C_BP_BANKACCOUNT add constraint CBANK_CBPBANKACCOUNT foreign key (C_BANK_ID) references C_BANK(C_BANK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_BANKACCOUNT drop constraint "CBPARTNER_CBPBANKACCOUNT"
;

alter table C_BP_BANKACCOUNT add constraint CBPARTNER_CBPBANKACCOUNT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_CUSTOMER_ACCT drop constraint "CACCTSCHEMA_CBPCUSTOMERACCT"
;

alter table C_BP_CUSTOMER_ACCT add constraint CACCTSCHEMA_CBPCUSTOMERACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_CUSTOMER_ACCT drop constraint "CBUSPARTNER_CBPCUSTOMER_ACCT"
;

alter table C_BP_CUSTOMER_ACCT add constraint CBUSPARTNER_CBPCUSTOMER_ACCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_CUSTOMER_ACCT drop constraint "CRECEIVABLESERVICES_CBPCUSTOME"
;

alter table C_BP_CUSTOMER_ACCT add constraint CRECEIVABLESERVICES_CBPCUSTOME foreign key (C_RECEIVABLE_SERVICES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_CUSTOMER_ACCT drop constraint "VC_CPREPAYMENT_CBPCUSTOMER"
;

alter table C_BP_CUSTOMER_ACCT add constraint VC_CPREPAYMENT_CBPCUSTOMER foreign key (C_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_CUSTOMER_ACCT drop constraint "VC_CRECEIVABLE_CBPCUSTOMER"
;

alter table C_BP_CUSTOMER_ACCT add constraint VC_CRECEIVABLE_CBPCUSTOMER foreign key (C_RECEIVABLE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EDI drop constraint "ADSEQUENCE_CBPEDI"
;

alter table C_BP_EDI add constraint ADSEQUENCE_CBPEDI foreign key (AD_SEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EDI drop constraint "C_BPARTNER_CBPEDI"
;

alter table C_BP_EDI add constraint C_BPARTNER_CBPEDI foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EDI drop constraint "MWAREHOUSE_CBPEDI"
;

alter table C_BP_EDI add constraint MWAREHOUSE_CBPEDI foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EMPLOYEE_ACCT drop constraint "CACCTSCHEMA_CBPEMPLOYEEACCT"
;

alter table C_BP_EMPLOYEE_ACCT add constraint CACCTSCHEMA_CBPEMPLOYEEACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EMPLOYEE_ACCT drop constraint "CBUSPARTNER_C_BPEMPLOYEEACCT"
;

alter table C_BP_EMPLOYEE_ACCT add constraint CBUSPARTNER_C_BPEMPLOYEEACCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EMPLOYEE_ACCT drop constraint "VC_EEXPENSE_CBPEMPLOYEE"
;

alter table C_BP_EMPLOYEE_ACCT add constraint VC_EEXPENSE_CBPEMPLOYEE foreign key (E_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_EMPLOYEE_ACCT drop constraint "VC_EPREPAYMENT_CBPEMPLOYEE"
;

alter table C_BP_EMPLOYEE_ACCT add constraint VC_EPREPAYMENT_CBPEMPLOYEE foreign key (E_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "ADPRINTCOLOR_CBPGROUP"
;

alter table C_BP_GROUP add constraint ADPRINTCOLOR_CBPGROUP foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "CDUNNING_CBPGROUP"
;

alter table C_BP_GROUP add constraint CDUNNING_CBPGROUP foreign key (C_DUNNING_ID) references C_DUNNING(C_DUNNING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "MDISCOUNTSCHEMAPO_CBPGROUP"
;

alter table C_BP_GROUP add constraint MDISCOUNTSCHEMAPO_CBPGROUP foreign key (PO_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "MDISCOUNTSCHEMA_CBPGROUP"
;

alter table C_BP_GROUP add constraint MDISCOUNTSCHEMA_CBPGROUP foreign key (M_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "MPRICELISTPO_CBPGROUP"
;

alter table C_BP_GROUP add constraint MPRICELISTPO_CBPGROUP foreign key (PO_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP drop constraint "MPRICELIST_CBPGROUP"
;

alter table C_BP_GROUP add constraint MPRICELIST_CBPGROUP foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "CACCTSCHEMA_CBPGROUPACCT"
;

alter table C_BP_GROUP_ACCT add constraint CACCTSCHEMA_CBPGROUPACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "CBPGROUP_CBPGROUPACCT"
;

alter table C_BP_GROUP_ACCT add constraint CBPGROUP_CBPGROUPACCT foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "CRECEIVABLESERVICES_CBPGROUPAC"
;

alter table C_BP_GROUP_ACCT add constraint CRECEIVABLESERVICES_CBPGROUPAC foreign key (C_RECEIVABLE_SERVICES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_CPREPAYMENT_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_CPREPAYMENT_CBPGROUP foreign key (C_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_CRECEIVABLE_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_CRECEIVABLE_CBPGROUP foreign key (C_RECEIVABLE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_NOTINVOICEDRECEIPTS_CBPGROU"
;

alter table C_BP_GROUP_ACCT add constraint VC_NOTINVOICEDRECEIPTS_CBPGROU foreign key (NOTINVOICEDRECEIPTS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_NOTINVOICEDREC_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_NOTINVOICEDREC_CBPGROUP foreign key (NOTINVOICEDRECEIVABLES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_NOTINVOICEDREVENUE_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_NOTINVOICEDREVENUE_CBPGROUP foreign key (NOTINVOICEDREVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_PAYDISCOUNTEXP_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_PAYDISCOUNTEXP_CBPGROUP foreign key (PAYDISCOUNT_EXP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_PAYDISCOUNTREV_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_PAYDISCOUNTREV_CBPGROUP foreign key (PAYDISCOUNT_REV_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_UNEARNEDREVENUE_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_UNEARNEDREVENUE_CBPGROUP foreign key (UNEARNEDREVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_VLIABILITYSERVICES_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_VLIABILITYSERVICES_CBPGROUP foreign key (V_LIABILITY_SERVICES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_VLIABILITY_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_VLIABILITY_CBPGROUP foreign key (V_LIABILITY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_VPREPAYMENT_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_VPREPAYMENT_CBPGROUP foreign key (V_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_GROUP_ACCT drop constraint "VC_WRITEOFF_CBPGROUP"
;

alter table C_BP_GROUP_ACCT add constraint VC_WRITEOFF_CBPGROUP foreign key (WRITEOFF_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_RELATION drop constraint "CBPARTNER_CBPRELATION"
;

alter table C_BP_RELATION add constraint CBPARTNER_CBPRELATION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_RELATION drop constraint "CBPARTNER_CBPRELATIONBP"
;

alter table C_BP_RELATION add constraint CBPARTNER_CBPRELATIONBP foreign key (C_BPARTNERRELATION_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_RELATION drop constraint "CBPLOCATION_CBPRELATION"
;

alter table C_BP_RELATION add constraint CBPLOCATION_CBPRELATION foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_RELATION drop constraint "CBPLOCATION_CBPRELATIONBP"
;

alter table C_BP_RELATION add constraint CBPLOCATION_CBPRELATIONBP foreign key (C_BPARTNERRELATION_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_VENDOR_ACCT drop constraint "CACCTSCHEMA_CBPVENDORACCT"
;

alter table C_BP_VENDOR_ACCT add constraint CACCTSCHEMA_CBPVENDORACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_VENDOR_ACCT drop constraint "C_BUSPARTNER_C_BP_VENDOR_ACCT"
;

alter table C_BP_VENDOR_ACCT add constraint C_BUSPARTNER_C_BP_VENDOR_ACCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_VENDOR_ACCT drop constraint "VC_VLIABILITYSERVICES_CBPVENDO"
;

alter table C_BP_VENDOR_ACCT add constraint VC_VLIABILITYSERVICES_CBPVENDO foreign key (V_LIABILITY_SERVICES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_VENDOR_ACCT drop constraint "VC_VLIABILITY_CBPVENDOR"
;

alter table C_BP_VENDOR_ACCT add constraint VC_VLIABILITY_CBPVENDOR foreign key (V_LIABILITY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_VENDOR_ACCT drop constraint "VC_VPREPAYMENT_CBPVENDOR"
;

alter table C_BP_VENDOR_ACCT add constraint VC_VPREPAYMENT_CBPVENDOR foreign key (V_PREPAYMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_WITHHOLDING drop constraint "CBPARTNER_CBPWITHHOLDING"
;

alter table C_BP_WITHHOLDING add constraint CBPARTNER_CBPWITHHOLDING foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_BP_WITHHOLDING drop constraint "CWITHHOLDING_CBPWITHHOLDING"
;

alter table C_BP_WITHHOLDING add constraint CWITHHOLDING_CBPWITHHOLDING foreign key (C_WITHHOLDING_ID) references C_WITHHOLDING(C_WITHHOLDING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CALENDAR drop constraint "C_CALENDARCLIENT"
;

alter table C_CALENDAR add constraint C_CALENDARCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CALENDAR drop constraint "C_CALENDARORG"
;

alter table C_CALENDAR add constraint C_CALENDARORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CAMPAIGN drop constraint "CCHANNEL_CCAMPAIGN"
;

alter table C_CAMPAIGN add constraint CCHANNEL_CCAMPAIGN foreign key (C_CHANNEL_ID) references C_CHANNEL(C_CHANNEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "ADORGTRX_CCASH"
;

alter table C_CASH add constraint ADORGTRX_CCASH foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "ADORG_CCASH"
;

alter table C_CASH add constraint ADORG_CCASH foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CACTIVITY_CCASH"
;

alter table C_CASH add constraint CACTIVITY_CCASH foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CCAMPAIGN_CCASH"
;

alter table C_CASH add constraint CCAMPAIGN_CCASH foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CCASHBOOK_CCASH"
;

alter table C_CASH add constraint CCASHBOOK_CCASH foreign key (C_CASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CELEMENTVALUEUSER1_CCASH"
;

alter table C_CASH add constraint CELEMENTVALUEUSER1_CCASH foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CELEMENTVALUEUSER2_CCASH"
;

alter table C_CASH add constraint CELEMENTVALUEUSER2_CCASH foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASH drop constraint "CPROJECT_CCASH"
;

alter table C_CASH add constraint CPROJECT_CCASH foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK drop constraint "CCURRENCY_CCASHBOOK"
;

alter table C_CASHBOOK add constraint CCURRENCY_CCASHBOOK foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "CACCTSCHEMA_CCASHBOOKACCT"
;

alter table C_CASHBOOK_ACCT add constraint CACCTSCHEMA_CCASHBOOKACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "CCASHBOOK_CCASHBOOKACCT"
;

alter table C_CASHBOOK_ACCT add constraint CCASHBOOK_CCASHBOOKACCT foreign key (C_CASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "VC_CBASSET_CCASHBOOK"
;

alter table C_CASHBOOK_ACCT add constraint VC_CBASSET_CCASHBOOK foreign key (CB_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "VC_CBCASHTRANSFER_CCASHBOOK"
;

alter table C_CASHBOOK_ACCT add constraint VC_CBCASHTRANSFER_CCASHBOOK foreign key (CB_CASHTRANSFER_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "VC_CBDIFFERENCES_CCASHBOOK"
;

alter table C_CASHBOOK_ACCT add constraint VC_CBDIFFERENCES_CCASHBOOK foreign key (CB_DIFFERENCES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "VC_CBEXPENSE_CCASHBOOK"
;

alter table C_CASHBOOK_ACCT add constraint VC_CBEXPENSE_CCASHBOOK foreign key (CB_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHBOOK_ACCT drop constraint "VC_CBRECEIPT_CCASHBOOK"
;

alter table C_CASHBOOK_ACCT add constraint VC_CBRECEIPT_CCASHBOOK foreign key (CB_RECEIPT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CBANKACCT_CCASHLINE"
;

alter table C_CASHLINE add constraint CBANKACCT_CCASHLINE foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CCASH_CCASHLINE"
;

alter table C_CASHLINE add constraint CCASH_CCASHLINE foreign key (C_CASH_ID) references C_CASH(C_CASH_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CCHARGE_CCASHLINE"
;

alter table C_CASHLINE add constraint CCHARGE_CCASHLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CCURRENCY_CCASHLINE"
;

alter table C_CASHLINE add constraint CCURRENCY_CCASHLINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CINVOICE_CCASHLINE"
;

alter table C_CASHLINE add constraint CINVOICE_CCASHLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHLINE drop constraint "CPAYMENT_CCASHLINE"
;

alter table C_CASHLINE add constraint CPAYMENT_CCASHLINE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "ADORGTRX_CCASHPLAN"
;

alter table C_CASHPLAN add constraint ADORGTRX_CCASHPLAN foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "CACTIVITY_CCASHPLAN"
;

alter table C_CASHPLAN add constraint CACTIVITY_CCASHPLAN foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "CBPARTNER_CCASHPLAN"
;

alter table C_CASHPLAN add constraint CBPARTNER_CCASHPLAN foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "CCAMPAIGN_CCASHPLAN"
;

alter table C_CASHPLAN add constraint CCAMPAIGN_CCASHPLAN foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "CPROJECT_CCASHPLAN"
;

alter table C_CASHPLAN add constraint CPROJECT_CCASHPLAN foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "USER1_CCASHPLAN"
;

alter table C_CASHPLAN add constraint USER1_CCASHPLAN foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLAN drop constraint "USER2_CCASHPLAN"
;

alter table C_CASHPLAN add constraint USER2_CCASHPLAN foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "ADORGTRX_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint ADORGTRX_CCASHPLANLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CACTIVITY_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CACTIVITY_CCASHPLANLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CBPARTNER_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CBPARTNER_CCASHPLANLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CCAMPAIGN_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CCAMPAIGN_CCASHPLANLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CCASHPLAN_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CCASHPLAN_CCASHPLANLINE foreign key (C_CASHPLAN_ID) references C_CASHPLAN(C_CASHPLAN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CCHARGE_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CCHARGE_CCASHPLANLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CPROJECTPHASE_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CPROJECTPHASE_CCASHPLANLINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CPROJECTTASK_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CPROJECTTASK_CCASHPLANLINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "CPROJECT_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint CPROJECT_CCASHPLANLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "MPRODUCT_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint MPRODUCT_CCASHPLANLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "USER1_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint USER1_CCASHPLANLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CASHPLANLINE drop constraint "USER2_CCASHPLANLINE"
;

alter table C_CASHPLANLINE add constraint USER2_CCASHPLANLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHANNEL drop constraint "ADPRINTCOLOR_CCHANNEL"
;

alter table C_CHANNEL add constraint ADPRINTCOLOR_CCHANNEL foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE drop constraint "CBPARTNER_CCHARGE"
;

alter table C_CHARGE add constraint CBPARTNER_CCHARGE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE drop constraint "CCHARGETYPE_CCHARGE"
;

alter table C_CHARGE add constraint CCHARGETYPE_CCHARGE foreign key (C_CHARGETYPE_ID) references C_CHARGETYPE(C_CHARGETYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE drop constraint "CTAXCATEGORY_CCHARGE"
;

alter table C_CHARGE add constraint CTAXCATEGORY_CCHARGE foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGETYPE_DOCTYPE drop constraint "CCHARGETYPE_CCHARGETYPEDOCTYPE"
;

alter table C_CHARGETYPE_DOCTYPE add constraint CCHARGETYPE_CCHARGETYPEDOCTYPE foreign key (C_CHARGETYPE_ID) references C_CHARGETYPE(C_CHARGETYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGETYPE_DOCTYPE drop constraint "CDOCTYPE_CCHARGETYPEDOCTYPE"
;

alter table C_CHARGETYPE_DOCTYPE add constraint CDOCTYPE_CCHARGETYPEDOCTYPE foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_ACCT drop constraint "CACCTSCHEMA_CCHARGEACCT"
;

alter table C_CHARGE_ACCT add constraint CACCTSCHEMA_CCHARGEACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_ACCT drop constraint "CCHRAGE_CCHARGEACCT"
;

alter table C_CHARGE_ACCT add constraint CCHRAGE_CCHARGEACCT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_ACCT drop constraint "CHREVENUE_CCHARGEACCT"
;

alter table C_CHARGE_ACCT add constraint CHREVENUE_CCHARGEACCT foreign key (CH_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_ACCT drop constraint "VC_CHEXPENSE_CCHARGE"
;

alter table C_CHARGE_ACCT add constraint VC_CHEXPENSE_CCHARGE foreign key (CH_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_TRL drop constraint "ADLANGU_CCHARGETRL"
;

alter table C_CHARGE_TRL add constraint ADLANGU_CCHARGETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CHARGE_TRL drop constraint "CCHARGE_CCHARGETRL"
;

alter table C_CHARGE_TRL add constraint CCHARGE_CCHARGETRL foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CITY drop constraint "CCOUNTRY_CCITY"
;

alter table C_CITY add constraint CCOUNTRY_CCITY foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CITY drop constraint "CREGION_CCITY"
;

alter table C_CITY add constraint CREGION_CCITY foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CITY drop constraint "C_CITYCLIENT"
;

alter table C_CITY add constraint C_CITYCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CITY drop constraint "C_CITYORG"
;

alter table C_CITY add constraint C_CITYORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSION drop constraint "CBPARTNER_CCOMMISSION"
;

alter table C_COMMISSION add constraint CBPARTNER_CCOMMISSION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSION drop constraint "CCHARGE_CCOMMISSION"
;

alter table C_COMMISSION add constraint CCHARGE_CCOMMISSION foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSION drop constraint "CCURRENCY_CCOMMISSION"
;

alter table C_COMMISSION add constraint CCURRENCY_CCOMMISSION foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONAMT drop constraint "CCOMLINE_CCOMAMT"
;

alter table C_COMMISSIONAMT add constraint CCOMLINE_CCOMAMT foreign key (C_COMMISSIONLINE_ID) references C_COMMISSIONLINE(C_COMMISSIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONAMT drop constraint "CCOMMENTRUN_CCOMMISSIONAMT"
;

alter table C_COMMISSIONAMT add constraint CCOMMENTRUN_CCOMMISSIONAMT foreign key (C_COMMISSIONRUN_ID) references C_COMMISSIONRUN(C_COMMISSIONRUN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONDETAIL drop constraint "CCOMMISSIONAMT_CCOMDETAIL"
;

alter table C_COMMISSIONDETAIL add constraint CCOMMISSIONAMT_CCOMDETAIL foreign key (C_COMMISSIONAMT_ID) references C_COMMISSIONAMT(C_COMMISSIONAMT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONDETAIL drop constraint "CCURRENCY_CCOMMISSIONDETAIL"
;

alter table C_COMMISSIONDETAIL add constraint CCURRENCY_CCOMMISSIONDETAIL foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONDETAIL drop constraint "CINVOICELINE_CCOMMISSIONDET"
;

alter table C_COMMISSIONDETAIL add constraint CINVOICELINE_CCOMMISSIONDET foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONDETAIL drop constraint "CORDERLINE_CCOMMISSIONDETAIL"
;

alter table C_COMMISSIONDETAIL add constraint CORDERLINE_CCOMMISSIONDETAIL foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "ADORGTRX_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint ADORGTRX_CCOMMISSIONLINE foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "CBPARTNER_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint CBPARTNER_CCOMMISSIONLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "CBPGROUP_COMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint CBPGROUP_COMMISSIONLINE foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "CCOMMISSION_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint CCOMMISSION_CCOMMISSIONLINE foreign key (C_COMMISSION_ID) references C_COMMISSION(C_COMMISSION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "CSALESREGION_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint CSALESREGION_CCOMMISSIONLINE foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "MPRODUCTCAT_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint MPRODUCTCAT_CCOMMISSIONLINE foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONLINE drop constraint "MPRODUCT_CCOMMISSIONLINE"
;

alter table C_COMMISSIONLINE add constraint MPRODUCT_CCOMMISSIONLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COMMISSIONRUN drop constraint "CCOMMISSION_CCOMMISSIONRUN"
;

alter table C_COMMISSIONRUN add constraint CCOMMISSION_CCOMMISSIONRUN foreign key (C_COMMISSION_ID) references C_COMMISSION(C_COMMISSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CONVERSION_RATE drop constraint "CCONVERSIONTYPE_CCONVRATE"
;

alter table C_CONVERSION_RATE add constraint CCONVERSIONTYPE_CCONVRATE foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CONVERSION_RATE drop constraint "CCURRENCY_CCONVERSIONRATE"
;

alter table C_CONVERSION_RATE add constraint CCURRENCY_CCONVERSIONRATE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CONVERSION_RATE drop constraint "C_CONVERSION_RATECLIENT"
;

alter table C_CONVERSION_RATE add constraint C_CONVERSION_RATECLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CONVERSION_RATE drop constraint "C_CONVERSION_RATEORG"
;

alter table C_CONVERSION_RATE add constraint C_CONVERSION_RATEORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CONVERSION_RATE drop constraint "C_CURRENCYCONVRATETO"
;

alter table C_CONVERSION_RATE add constraint C_CURRENCYCONVRATETO foreign key (C_CURRENCY_ID_TO) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY drop constraint "ADLANGUAGE_CCOUNTRY"
;

alter table C_COUNTRY add constraint ADLANGUAGE_CCOUNTRY foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY drop constraint "CCOUNTRY_CCOUNTRY"
;

alter table C_COUNTRY add constraint CCOUNTRY_CCOUNTRY foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY drop constraint "CCURRENCY_CCOUNTRY"
;

alter table C_COUNTRY add constraint CCURRENCY_CCOUNTRY foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY drop constraint "C_COUNTRYCLIENT"
;

alter table C_COUNTRY add constraint C_COUNTRYCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY drop constraint "C_COUNTRYORG"
;

alter table C_COUNTRY add constraint C_COUNTRYORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY_TRL drop constraint "ADLANGUAGE_CCOUNTRYTRL"
;

alter table C_COUNTRY_TRL add constraint ADLANGUAGE_CCOUNTRYTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_COUNTRY_TRL drop constraint "CCOUNTRY_CCOUNTRYTRL"
;

alter table C_COUNTRY_TRL add constraint CCOUNTRY_CCOUNTRYTRL foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY drop constraint "C_CURRENCYCLIENT"
;

alter table C_CURRENCY add constraint C_CURRENCYCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY drop constraint "C_CURRENCYORG"
;

alter table C_CURRENCY add constraint C_CURRENCYORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "CACCTSCHEMA_CCURRENCYACCT"
;

alter table C_CURRENCY_ACCT add constraint CACCTSCHEMA_CCURRENCYACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "CCURRENCY_CCURRENCYACCT"
;

alter table C_CURRENCY_ACCT add constraint CCURRENCY_CCURRENCYACCT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "VC_REALIZEDGAIN_CCURRENCY"
;

alter table C_CURRENCY_ACCT add constraint VC_REALIZEDGAIN_CCURRENCY foreign key (REALIZEDGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "VC_REALIZEDLOSS_CCURRENCY"
;

alter table C_CURRENCY_ACCT add constraint VC_REALIZEDLOSS_CCURRENCY foreign key (REALIZEDLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "VC_UNREALIZEDGAIN_CCURRENCY"
;

alter table C_CURRENCY_ACCT add constraint VC_UNREALIZEDGAIN_CCURRENCY foreign key (UNREALIZEDGAIN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_ACCT drop constraint "VC_UNREALIZEDLOSS_CCURRENCY"
;

alter table C_CURRENCY_ACCT add constraint VC_UNREALIZEDLOSS_CCURRENCY foreign key (UNREALIZEDLOSS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_TRL drop constraint "ADLANGUAGE_CCURRENCYTRL"
;

alter table C_CURRENCY_TRL add constraint ADLANGUAGE_CCURRENCYTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CURRENCY_TRL drop constraint "CCURRENCY_CCURRENCYTRL"
;

alter table C_CURRENCY_TRL add constraint CCURRENCY_CCURRENCYTRL foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CYCLE drop constraint "CCURRENCY_CCYCLE"
;

alter table C_CYCLE add constraint CCURRENCY_CCYCLE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CYCLEPHASE drop constraint "CCYCLESTEP_CCYCLEPHASE"
;

alter table C_CYCLEPHASE add constraint CCYCLESTEP_CCYCLEPHASE foreign key (C_CYCLESTEP_ID) references C_CYCLESTEP(C_CYCLESTEP_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CYCLEPHASE drop constraint "CPHASE_CCYCLEPHASE"
;

alter table C_CYCLEPHASE add constraint CPHASE_CCYCLEPHASE foreign key (C_PHASE_ID) references C_PHASE(C_PHASE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_CYCLESTEP drop constraint "CCYCLE_CCYCLESTEP"
;

alter table C_CYCLESTEP add constraint CCYCLE_CCYCLESTEP foreign key (C_CYCLE_ID) references C_CYCLE(C_CYCLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "ADPRINTFORMAT_CDOCTYPE"
;

alter table C_DOCTYPE add constraint ADPRINTFORMAT_CDOCTYPE foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "AD_SEQUENCE_DOCTYPEDOC"
;

alter table C_DOCTYPE add constraint AD_SEQUENCE_DOCTYPEDOC foreign key (DOCNOSEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "CDOCTYPEDIFFERENCE_CDOCTYPE"
;

alter table C_DOCTYPE add constraint CDOCTYPEDIFFERENCE_CDOCTYPE foreign key (C_DOCTYPEDIFFERENCE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "CDOCTYPE_INVOICE"
;

alter table C_DOCTYPE add constraint CDOCTYPE_INVOICE foreign key (C_DOCTYPEINVOICE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "CDOCTYPE_PROFORMA"
;

alter table C_DOCTYPE add constraint CDOCTYPE_PROFORMA foreign key (C_DOCTYPEPROFORMA_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "CDOCTYPE_SHIPMENT"
;

alter table C_DOCTYPE add constraint CDOCTYPE_SHIPMENT foreign key (C_DOCTYPESHIPMENT_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "DEFINITESEQUENCE_CDOCTYPE"
;

alter table C_DOCTYPE add constraint DEFINITESEQUENCE_CDOCTYPE foreign key (DEFINITESEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE drop constraint "GLCATEGORY_CDOCTYPE"
;

alter table C_DOCTYPE add constraint GLCATEGORY_CDOCTYPE foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPECOUNTER drop constraint "CDOCTYPECOUNT_CDOCTYPECOUNT"
;

alter table C_DOCTYPECOUNTER add constraint CDOCTYPECOUNT_CDOCTYPECOUNT foreign key (COUNTER_C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPECOUNTER drop constraint "CDOCTYPE_CDOCTYPECOUNTER"
;

alter table C_DOCTYPECOUNTER add constraint CDOCTYPE_CDOCTYPECOUNTER foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE_TRL drop constraint "ADLANGUAGE_CDOCTYPETRL"
;

alter table C_DOCTYPE_TRL add constraint ADLANGUAGE_CDOCTYPETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DOCTYPE_TRL drop constraint "CDOCTYPE_CDOCTYPETRL"
;

alter table C_DOCTYPE_TRL add constraint CDOCTYPE_CDOCTYPETRL foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGLEVEL drop constraint "ADPRINTFORMAT_CDUNNINGLEVEL"
;

alter table C_DUNNINGLEVEL add constraint ADPRINTFORMAT_CDUNNINGLEVEL foreign key (DUNNING_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGLEVEL drop constraint "CDUNNING_CDUNNINGLEVEL"
;

alter table C_DUNNINGLEVEL add constraint CDUNNING_CDUNNINGLEVEL foreign key (C_DUNNING_ID) references C_DUNNING(C_DUNNING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGLEVEL drop constraint "CPAYMENTTERM_CDUNNINGLEVEL"
;

alter table C_DUNNINGLEVEL add constraint CPAYMENTTERM_CDUNNINGLEVEL foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGLEVEL_TRL drop constraint "ADLANGUAGE_CDUNNINGLEVEL"
;

alter table C_DUNNINGLEVEL_TRL add constraint ADLANGUAGE_CDUNNINGLEVEL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGLEVEL_TRL drop constraint "CDUNNINGLEVEL_CDLTRL"
;

alter table C_DUNNINGLEVEL_TRL add constraint CDUNNINGLEVEL_CDLTRL foreign key (C_DUNNINGLEVEL_ID) references C_DUNNINGLEVEL(C_DUNNINGLEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUN drop constraint "CDUNNINGLEVEL_CDUNNINGRUN"
;

alter table C_DUNNINGRUN add constraint CDUNNINGLEVEL_CDUNNINGRUN foreign key (C_DUNNINGLEVEL_ID) references C_DUNNINGLEVEL(C_DUNNINGLEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUN drop constraint "CDUNNING_CDUNNINGRUN"
;

alter table C_DUNNINGRUN add constraint CDUNNING_CDUNNINGRUN foreign key (C_DUNNING_ID) references C_DUNNING(C_DUNNING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "ADUSER_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint ADUSER_CDUNNINGRUNENTRY foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "CBPARTNERLOCATION_CDUNNINGRUNE"
;

alter table C_DUNNINGRUNENTRY add constraint CBPARTNERLOCATION_CDUNNINGRUNE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "CBPARTNER_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint CBPARTNER_CDUNNINGRUNENTRY foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "CCURRENCY_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint CCURRENCY_CDUNNINGRUNENTRY foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "CDUNNINGLEVEL_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint CDUNNINGLEVEL_CDUNNINGRUNENTRY foreign key (C_DUNNINGLEVEL_ID) references C_DUNNINGLEVEL(C_DUNNINGLEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "CDUNNINGRUN_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint CDUNNINGRUN_CDUNNINGRUNENTRY foreign key (C_DUNNINGRUN_ID) references C_DUNNINGRUN(C_DUNNINGRUN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNENTRY drop constraint "SALESREP_CDUNNINGRUNENTRY"
;

alter table C_DUNNINGRUNENTRY add constraint SALESREP_CDUNNINGRUNENTRY foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNLINE drop constraint "CDUNNINGRUNENTRY_LINE"
;

alter table C_DUNNINGRUNLINE add constraint CDUNNINGRUNENTRY_LINE foreign key (C_DUNNINGRUNENTRY_ID) references C_DUNNINGRUNENTRY(C_DUNNINGRUNENTRY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNLINE drop constraint "CINVOICEPAYSCHEDULE_CDUNNINGRU"
;

alter table C_DUNNINGRUNLINE add constraint CINVOICEPAYSCHEDULE_CDUNNINGRU foreign key (C_INVOICEPAYSCHEDULE_ID) references C_INVOICEPAYSCHEDULE(C_INVOICEPAYSCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNLINE drop constraint "CINVOICE_CDUNNINGRUNLINE"
;

alter table C_DUNNINGRUNLINE add constraint CINVOICE_CDUNNINGRUNLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_DUNNINGRUNLINE drop constraint "CPAYMENT_CDUNNINGRUNLINE"
;

alter table C_DUNNINGRUNLINE add constraint CPAYMENT_CDUNNINGRUNLINE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENT drop constraint "ADCLIENT_CELEMENT"
;

alter table C_ELEMENT add constraint ADCLIENT_CELEMENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENT drop constraint "ADTREE_CELEMENT"
;

alter table C_ELEMENT add constraint ADTREE_CELEMENT foreign key (AD_TREE_ID) references AD_TREE(AD_TREE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENT drop constraint "C_ELEMENTORG"
;

alter table C_ELEMENT add constraint C_ELEMENTORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE drop constraint "ADCLIENT_CELEMENTVALUE"
;

alter table C_ELEMENTVALUE add constraint ADCLIENT_CELEMENTVALUE foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE drop constraint "ADORG_CELEMENTVALUE"
;

alter table C_ELEMENTVALUE add constraint ADORG_CELEMENTVALUE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE drop constraint "CBANKACCOUNT_CELEMENTVALUE"
;

alter table C_ELEMENTVALUE add constraint CBANKACCOUNT_CELEMENTVALUE foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE drop constraint "CCURRENCY_CELEMENTVALUE"
;

alter table C_ELEMENTVALUE add constraint CCURRENCY_CELEMENTVALUE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE drop constraint "CELEMENT_CELEMENTVALUE"
;

alter table C_ELEMENTVALUE add constraint CELEMENT_CELEMENTVALUE foreign key (C_ELEMENT_ID) references C_ELEMENT(C_ELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE_TRL drop constraint "ADLANGUAGE_CELEMENTVALUETRL"
;

alter table C_ELEMENTVALUE_TRL add constraint ADLANGUAGE_CELEMENTVALUETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ELEMENTVALUE_TRL drop constraint "CELEMENTVALUE_CEVALUETRL"
;

alter table C_ELEMENTVALUE_TRL add constraint CELEMENTVALUE_CEVALUETRL foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_GREETING_TRL drop constraint "ADLANGUAGE_CGREETINGTRL"
;

alter table C_GREETING_TRL add constraint ADLANGUAGE_CGREETINGTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_GREETING_TRL drop constraint "CGREETING_CGREETINGTRL"
;

alter table C_GREETING_TRL add constraint CGREETING_CGREETINGTRL foreign key (C_GREETING_ID) references C_GREETING(C_GREETING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INTERORG_ACCT drop constraint "ADORGTO_CINTERORGACCT"
;

alter table C_INTERORG_ACCT add constraint ADORGTO_CINTERORGACCT foreign key (AD_ORGTO_ID) references AD_ORG(AD_ORG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INTERORG_ACCT drop constraint "ADORG_CINTERORGACCT"
;

alter table C_INTERORG_ACCT add constraint ADORG_CINTERORGACCT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INTERORG_ACCT drop constraint "CACCTSCHEMA_CINTERORGACCT"
;

alter table C_INTERORG_ACCT add constraint CACCTSCHEMA_CINTERORGACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INTERORG_ACCT drop constraint "VC_INTERCOMPANYDUEFROM_CINTERO"
;

alter table C_INTERORG_ACCT add constraint VC_INTERCOMPANYDUEFROM_CINTERO foreign key (INTERCOMPANYDUEFROM_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INTERORG_ACCT drop constraint "VC_INTERCOMPANYDUETO_CINTERORG"
;

alter table C_INTERORG_ACCT add constraint VC_INTERCOMPANYDUETO_CINTERORG foreign key (INTERCOMPANYDUETO_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "ADORGTRX_CINVOICE"
;

alter table C_INVOICE add constraint ADORGTRX_CINVOICE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "ADORG_CINVOICE"
;

alter table C_INVOICE add constraint ADORG_CINVOICE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "ADUSER_CINVOICE"
;

alter table C_INVOICE add constraint ADUSER_CINVOICE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "ADUSER_SR_CINVOICE"
;

alter table C_INVOICE add constraint ADUSER_SR_CINVOICE foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CACTIVITY_CINVOICE"
;

alter table C_INVOICE add constraint CACTIVITY_CINVOICE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CBPARTNER_CINVOICE"
;

alter table C_INVOICE add constraint CBPARTNER_CINVOICE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCAMPAIGN_CINVOICE"
;

alter table C_INVOICE add constraint CCAMPAIGN_CINVOICE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCASHLINE_CINVOICE"
;

alter table C_INVOICE add constraint CCASHLINE_CINVOICE foreign key (C_CASHLINE_ID) references C_CASHLINE(C_CASHLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCASHPLANLINE_CINVOICE"
;

alter table C_INVOICE add constraint CCASHPLANLINE_CINVOICE foreign key (C_CASHPLANLINE_ID) references C_CASHPLANLINE(C_CASHPLANLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCHARGE_CINVOICE"
;

alter table C_INVOICE add constraint CCHARGE_CINVOICE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCONVERSIONTYPE_CINVOICE"
;

alter table C_INVOICE add constraint CCONVERSIONTYPE_CINVOICE foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CCURRENCY_CINVOICE"
;

alter table C_INVOICE add constraint CCURRENCY_CINVOICE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CDOCTYPETARGET_CINVOICE"
;

alter table C_INVOICE add constraint CDOCTYPETARGET_CINVOICE foreign key (C_DOCTYPETARGET_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CDOCTYPE_CINVOICE"
;

alter table C_INVOICE add constraint CDOCTYPE_CINVOICE foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CDUNNINGLEVEL_CINVOICE"
;

alter table C_INVOICE add constraint CDUNNINGLEVEL_CINVOICE foreign key (C_DUNNINGLEVEL_ID) references C_DUNNINGLEVEL(C_DUNNINGLEVEL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CELEMENTVALUEUSER1_CINVOICE"
;

alter table C_INVOICE add constraint CELEMENTVALUEUSER1_CINVOICE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CELEMENTVALUEUSER2_CINVOICE"
;

alter table C_INVOICE add constraint CELEMENTVALUEUSER2_CINVOICE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CINVOICE_REF"
;

alter table C_INVOICE add constraint CINVOICE_REF foreign key (REF_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CORDER_CINVOICE"
;

alter table C_INVOICE add constraint CORDER_CINVOICE foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CPAYMENTTERM_CINVOICE"
;

alter table C_INVOICE add constraint CPAYMENTTERM_CINVOICE foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CPAYMENT_CINVOICE"
;

alter table C_INVOICE add constraint CPAYMENT_CINVOICE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "CPROJECT_CINVOICE"
;

alter table C_INVOICE add constraint CPROJECT_CINVOICE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "C_BPLOCATION_CINVOICE"
;

alter table C_INVOICE add constraint C_BPLOCATION_CINVOICE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "MPRICELIST_CINVOICE"
;

alter table C_INVOICE add constraint MPRICELIST_CINVOICE foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "MRMA_CINVOICE"
;

alter table C_INVOICE add constraint MRMA_CINVOICE foreign key (M_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICE drop constraint "REVERSAL_CINVOICE"
;

alter table C_INVOICE add constraint REVERSAL_CINVOICE foreign key (REVERSAL_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCH drop constraint "ADUSER_CINVOICEBATCH"
;

alter table C_INVOICEBATCH add constraint ADUSER_CINVOICEBATCH foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCH drop constraint "CCONVENTIONTYPE_CINVOICEBATCH"
;

alter table C_INVOICEBATCH add constraint CCONVENTIONTYPE_CINVOICEBATCH foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCH drop constraint "CCURRENCY_CINVOICEBATCH"
;

alter table C_INVOICEBATCH add constraint CCURRENCY_CINVOICEBATCH foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "ADORGTRX_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint ADORGTRX_CINVOICEBATCHLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "ADORG_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint ADORG_CINVOICEBATCHLINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "ADUSER_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint ADUSER_CINVOICEBATCHLINE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CACTIVITY_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CACTIVITY_CINVOICEBATCHLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CBPARTNER_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CBPARTNER_CINVOICEBATCHLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CBPLOCATION_CINVOICEBLINE"
;

alter table C_INVOICEBATCHLINE add constraint CBPLOCATION_CINVOICEBLINE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CCHARGE_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CCHARGE_CINVOICEBATCHLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CDOCTYPE_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CDOCTYPE_CINVOICEBATCHLINE foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CELEMENTVALUEU1_CINVOICEBLINE"
;

alter table C_INVOICEBATCHLINE add constraint CELEMENTVALUEU1_CINVOICEBLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CELEMENTVALUEU2_CINVOICEBLINE"
;

alter table C_INVOICEBATCHLINE add constraint CELEMENTVALUEU2_CINVOICEBLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CINVOICEBATCH_CINVOICEBLINE"
;

alter table C_INVOICEBATCHLINE add constraint CINVOICEBATCH_CINVOICEBLINE foreign key (C_INVOICEBATCH_ID) references C_INVOICEBATCH(C_INVOICEBATCH_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CINVOICELINE_CINVOICEBLINE"
;

alter table C_INVOICEBATCHLINE add constraint CINVOICELINE_CINVOICEBLINE foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CINVOICE_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CINVOICE_CINVOICEBATCHLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CPROJECT_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CPROJECT_CINVOICEBATCHLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEBATCHLINE drop constraint "CTAX_CINVOICEBATCHLINE"
;

alter table C_INVOICEBATCHLINE add constraint CTAX_CINVOICEBATCHLINE foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "AASSETGROUP_CINVOICELINE"
;

alter table C_INVOICELINE add constraint AASSETGROUP_CINVOICELINE foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "AASSET_CINVOICELINE"
;

alter table C_INVOICELINE add constraint AASSET_CINVOICELINE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "ADORGTRX_CINVOICELINE"
;

alter table C_INVOICELINE add constraint ADORGTRX_CINVOICELINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "ADORG_CINVOICELINE"
;

alter table C_INVOICELINE add constraint ADORG_CINVOICELINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CACTIVITY_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CACTIVITY_CINVOICELINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CCAMPAIGN_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CCAMPAIGN_CINVOICELINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CCHARGE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CCHARGE_CINVOICELINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CELEMENRVALUEUSER1_CINVLINE"
;

alter table C_INVOICELINE add constraint CELEMENRVALUEUSER1_CINVLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CELEMENRVALUEUSER2_CINVLINE"
;

alter table C_INVOICELINE add constraint CELEMENRVALUEUSER2_CINVLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CINVOICE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CINVOICE_CINVOICELINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CONVOICELINE_REF"
;

alter table C_INVOICELINE add constraint CONVOICELINE_REF foreign key (REF_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CORDERLINE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CORDERLINE_CINVOICELINE foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CPROJECTPHASE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CPROJECTPHASE_CINVOICELINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CPROJECTTASK_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CPROJECTTASK_CINVOICELINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CPROJECT_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CPROJECT_CINVOICELINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CTAX_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CTAX_CINVOICELINE foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "CUOM_CINVOICELINE"
;

alter table C_INVOICELINE add constraint CUOM_CINVOICELINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "MATTRSETINST_CINVOICELINE"
;

alter table C_INVOICELINE add constraint MATTRSETINST_CINVOICELINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "MINOUTLINE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint MINOUTLINE_CINVOICELINE foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "MPRODUCT_CINVOICELINE"
;

alter table C_INVOICELINE add constraint MPRODUCT_CINVOICELINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "MRMALINE_CINVOICELINE"
;

alter table C_INVOICELINE add constraint MRMALINE_CINVOICELINE foreign key (M_RMALINE_ID) references M_RMALINE(M_RMALINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICELINE drop constraint "SRESOURCEASSIGN_CINVOICELINE"
;

alter table C_INVOICELINE add constraint SRESOURCEASSIGN_CINVOICELINE foreign key (S_RESOURCEASSIGNMENT_ID) references S_RESOURCEASSIGNMENT(S_RESOURCEASSIGNMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEPAYSCHEDULE drop constraint "CINVOICE_CINVOICEPAYSCHED"
;

alter table C_INVOICEPAYSCHEDULE add constraint CINVOICE_CINVOICEPAYSCHED foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICEPAYSCHEDULE drop constraint "CPAYSCHEDULE_CINVOICEPAYSCHED"
;

alter table C_INVOICEPAYSCHEDULE add constraint CPAYSCHEDULE_CINVOICEPAYSCHED foreign key (C_PAYSCHEDULE_ID) references C_PAYSCHEDULE(C_PAYSCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICETAX drop constraint "CINVOICE_CINVOICETAX"
;

alter table C_INVOICETAX add constraint CINVOICE_CINVOICETAX foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_INVOICETAX drop constraint "CTAX_CINVOICETAX"
;

alter table C_INVOICETAX add constraint CTAX_CINVOICETAX foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_JOB drop constraint "CJOBCATEGORY_CJOB"
;

alter table C_JOB add constraint CJOBCATEGORY_CJOB foreign key (C_JOBCATEGORY_ID) references C_JOBCATEGORY(C_JOBCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_JOBASSIGNMENT drop constraint "ADUSER_CJOBASSIGNMENT"
;

alter table C_JOBASSIGNMENT add constraint ADUSER_CJOBASSIGNMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_JOBASSIGNMENT drop constraint "CJOB_CJOBASSIGNMENT"
;

alter table C_JOBASSIGNMENT add constraint CJOB_CJOBASSIGNMENT foreign key (C_JOB_ID) references C_JOB(C_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_JOBREMUNERATION drop constraint "CJOB_CJOBREMUNERATION"
;

alter table C_JOBREMUNERATION add constraint CJOB_CJOBREMUNERATION foreign key (C_JOB_ID) references C_JOB(C_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_JOBREMUNERATION drop constraint "CREMUNERATION_CJOBREM"
;

alter table C_JOBREMUNERATION add constraint CREMUNERATION_CJOBREM foreign key (C_REMUNERATION_ID) references C_REMUNERATION(C_REMUNERATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOST drop constraint "CCOSTELEMENT_CLANDEDCOST"
;

alter table C_LANDEDCOST add constraint CCOSTELEMENT_CLANDEDCOST foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOST drop constraint "CINVOICELINE_CLANDEDCOST"
;

alter table C_LANDEDCOST add constraint CINVOICELINE_CLANDEDCOST foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOST drop constraint "MINOUTLINE_CLANDEDCOST"
;

alter table C_LANDEDCOST add constraint MINOUTLINE_CLANDEDCOST foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOST drop constraint "MINOUT_CLANDEDCOST"
;

alter table C_LANDEDCOST add constraint MINOUT_CLANDEDCOST foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOST drop constraint "MPRODUCT_CLANDEDCOST"
;

alter table C_LANDEDCOST add constraint MPRODUCT_CLANDEDCOST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOSTALLOCATION drop constraint "CINVOICELINE_CLANDEDCOSTALLOC"
;

alter table C_LANDEDCOSTALLOCATION add constraint CINVOICELINE_CLANDEDCOSTALLOC foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOSTALLOCATION drop constraint "MASI_CLANDEDCOSTALLOCATION"
;

alter table C_LANDEDCOSTALLOCATION add constraint MASI_CLANDEDCOSTALLOCATION foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOSTALLOCATION drop constraint "MCOSTELEMENT_MLANDEDCOSTALLOC"
;

alter table C_LANDEDCOSTALLOCATION add constraint MCOSTELEMENT_MLANDEDCOSTALLOC foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LANDEDCOSTALLOCATION drop constraint "MPRODUCT_CLANDEDCOSTALLOC"
;

alter table C_LANDEDCOSTALLOCATION add constraint MPRODUCT_CLANDEDCOSTALLOC foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LOCATION drop constraint "ADCLIENT_CLOCATION"
;

alter table C_LOCATION add constraint ADCLIENT_CLOCATION foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LOCATION drop constraint "ADORG_CLOCATION"
;

alter table C_LOCATION add constraint ADORG_CLOCATION foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LOCATION drop constraint "CCITY_CLOCATION"
;

alter table C_LOCATION add constraint CCITY_CLOCATION foreign key (C_CITY_ID) references C_CITY(C_CITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LOCATION drop constraint "C_COUNTRY_LOCATION"
;

alter table C_LOCATION add constraint C_COUNTRY_LOCATION foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_LOCATION drop constraint "C_REGION_LOCATION"
;

alter table C_LOCATION add constraint C_REGION_LOCATION foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_NONBUSINESSDAY drop constraint "C_CALENDARNONBUSINESSDAY"
;

alter table C_NONBUSINESSDAY add constraint C_CALENDARNONBUSINESSDAY foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_NONBUSINESSDAY drop constraint "C_NONBUSINESDAYSCLIENT"
;

alter table C_NONBUSINESSDAY add constraint C_NONBUSINESDAYSCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_NONBUSINESSDAY drop constraint "C_NONBUSINESDAYSORG"
;

alter table C_NONBUSINESSDAY add constraint C_NONBUSINESDAYSORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "ADORGTRX_CORDER"
;

alter table C_ORDER add constraint ADORGTRX_CORDER foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "ADORG_CORDER"
;

alter table C_ORDER add constraint ADORG_CORDER foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "ADUSERBILL_CORDER"
;

alter table C_ORDER add constraint ADUSERBILL_CORDER foreign key (BILL_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "ADUSER_CORDER"
;

alter table C_ORDER add constraint ADUSER_CORDER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "ADUSER_SR_CORDER"
;

alter table C_ORDER add constraint ADUSER_SR_CORDER foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CACTIVITY_CORDER"
;

alter table C_ORDER add constraint CACTIVITY_CORDER foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPARTNERBILL_CORDER"
;

alter table C_ORDER add constraint CBPARTNERBILL_CORDER foreign key (BILL_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPARTNERLOCATION_CORDER"
;

alter table C_ORDER add constraint CBPARTNERLOCATION_CORDER foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPARTNERPAY_CORDER"
;

alter table C_ORDER add constraint CBPARTNERPAY_CORDER foreign key (PAY_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPARTNER_CORDER"
;

alter table C_ORDER add constraint CBPARTNER_CORDER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPLOCATIONBILL_CORDER"
;

alter table C_ORDER add constraint CBPLOCATIONBILL_CORDER foreign key (BILL_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CBPLOCATIONPAY_CORDER"
;

alter table C_ORDER add constraint CBPLOCATIONPAY_CORDER foreign key (PAY_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCAMPAIGN_CORDER"
;

alter table C_ORDER add constraint CCAMPAIGN_CORDER foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCASHLINE_CORDER"
;

alter table C_ORDER add constraint CCASHLINE_CORDER foreign key (C_CASHLINE_ID) references C_CASHLINE(C_CASHLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCASHPLANLINE_CORDER"
;

alter table C_ORDER add constraint CCASHPLANLINE_CORDER foreign key (C_CASHPLANLINE_ID) references C_CASHPLANLINE(C_CASHPLANLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCHARGE_CORDER"
;

alter table C_ORDER add constraint CCHARGE_CORDER foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCONVERSIONTYPE_CORDER"
;

alter table C_ORDER add constraint CCONVERSIONTYPE_CORDER foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CCURRENCY_CORDER"
;

alter table C_ORDER add constraint CCURRENCY_CORDER foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CDOCTYPETARGET_CORDER"
;

alter table C_ORDER add constraint CDOCTYPETARGET_CORDER foreign key (C_DOCTYPETARGET_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CELEMENRVALUEUSER2_CORDER"
;

alter table C_ORDER add constraint CELEMENRVALUEUSER2_CORDER foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CELEMENTVALUEUSER1_CORDER"
;

alter table C_ORDER add constraint CELEMENTVALUEUSER1_CORDER foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CORDER_REF"
;

alter table C_ORDER add constraint CORDER_REF foreign key (REF_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CPAYMENTTERM_SOHEADER"
;

alter table C_ORDER add constraint CPAYMENTTERM_SOHEADER foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CPAYMENT_CORDER"
;

alter table C_ORDER add constraint CPAYMENT_CORDER foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CPOS_CORDER"
;

alter table C_ORDER add constraint CPOS_CORDER foreign key (C_POS_ID) references C_POS(C_POS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "CPROJECT_CORDER"
;

alter table C_ORDER add constraint CPROJECT_CORDER foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "C_DOCTYPE_CORDER"
;

alter table C_ORDER add constraint C_DOCTYPE_CORDER foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "DROPSHIPBPARTNER_CORDER"
;

alter table C_ORDER add constraint DROPSHIPBPARTNER_CORDER foreign key (DROPSHIP_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "DROPSHIPLOCATION_CORDER"
;

alter table C_ORDER add constraint DROPSHIPLOCATION_CORDER foreign key (DROPSHIP_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "DROPSHIPUSER_CORDER"
;

alter table C_ORDER add constraint DROPSHIPUSER_CORDER foreign key (DROPSHIP_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "LINKORDER_CORDER"
;

alter table C_ORDER add constraint LINKORDER_CORDER foreign key (LINK_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "MFREIGHTCATEGORY_ORDER"
;

alter table C_ORDER add constraint MFREIGHTCATEGORY_ORDER foreign key (M_FREIGHTCATEGORY_ID) references M_FREIGHTCATEGORY(M_FREIGHTCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "MPRICELIST_SOHEADER"
;

alter table C_ORDER add constraint MPRICELIST_SOHEADER foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "MSHIPPER_CORDER"
;

alter table C_ORDER add constraint MSHIPPER_CORDER foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDER drop constraint "MWAREHOUSE_CORDER"
;

alter table C_ORDER add constraint MWAREHOUSE_CORDER foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "ADORGTRX_CORDERLINE"
;

alter table C_ORDERLINE add constraint ADORGTRX_CORDERLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "ADORG_CORDERLINE"
;

alter table C_ORDERLINE add constraint ADORG_CORDERLINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CACTIVITY_CORDERLINE"
;

alter table C_ORDERLINE add constraint CACTIVITY_CORDERLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CBPARTNERLOCATION_SOLINE"
;

alter table C_ORDERLINE add constraint CBPARTNERLOCATION_SOLINE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CBPARTNER_SOLINE"
;

alter table C_ORDERLINE add constraint CBPARTNER_SOLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CCAMPAIGN_CORDERLINE"
;

alter table C_ORDERLINE add constraint CCAMPAIGN_CORDERLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CCHARGE_CORDERLINE"
;

alter table C_ORDERLINE add constraint CCHARGE_CORDERLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CCURRENCY_CORDERLINE"
;

alter table C_ORDERLINE add constraint CCURRENCY_CORDERLINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CELEMENRVALUEUSER1_CORDERLINE"
;

alter table C_ORDERLINE add constraint CELEMENRVALUEUSER1_CORDERLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CELEMENRVALUEUSER2_CORDERLINE"
;

alter table C_ORDERLINE add constraint CELEMENRVALUEUSER2_CORDERLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CORDERLINE_REF"
;

alter table C_ORDERLINE add constraint CORDERLINE_REF foreign key (REF_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CPROJECTPHASE_CORDERLINE"
;

alter table C_ORDERLINE add constraint CPROJECTPHASE_CORDERLINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CPROJECTTASK_CORDERLINE"
;

alter table C_ORDERLINE add constraint CPROJECTTASK_CORDERLINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CPROJECT_CORDERLINE"
;

alter table C_ORDERLINE add constraint CPROJECT_CORDERLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CTAX_CORDERLINE"
;

alter table C_ORDERLINE add constraint CTAX_CORDERLINE foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "CUOM_CORDERLINE"
;

alter table C_ORDERLINE add constraint CUOM_CORDERLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "MATTRSETINST_CORDERLINE"
;

alter table C_ORDERLINE add constraint MATTRSETINST_CORDERLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "MPRODUCT_CORDERLINE"
;

alter table C_ORDERLINE add constraint MPRODUCT_CORDERLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "MPROMOTION_CORDERLINE"
;

alter table C_ORDERLINE add constraint MPROMOTION_CORDERLINE foreign key (M_PROMOTION_ID) references M_PROMOTION(M_PROMOTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "MSHIPPER_CORDERLINE"
;

alter table C_ORDERLINE add constraint MSHIPPER_CORDERLINE foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "MWAREHOUSE_CORDERLINE"
;

alter table C_ORDERLINE add constraint MWAREHOUSE_CORDERLINE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "PPCOSTCOLLECTOR_CORDERLINE"
;

alter table C_ORDERLINE add constraint PPCOSTCOLLECTOR_CORDERLINE foreign key (PP_COST_COLLECTOR_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERLINE drop constraint "SRESOURCEASSIGN_CORDERLINE"
;

alter table C_ORDERLINE add constraint SRESOURCEASSIGN_CORDERLINE foreign key (S_RESOURCEASSIGNMENT_ID) references S_RESOURCEASSIGNMENT(S_RESOURCEASSIGNMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERPAYSCHEDULE drop constraint "CORDER_CORDERPAYSCHEDULE"
;

alter table C_ORDERPAYSCHEDULE add constraint CORDER_CORDERPAYSCHEDULE foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERPAYSCHEDULE drop constraint "CPAYSCHEDULE_CORDERPAYSCHEDULE"
;

alter table C_ORDERPAYSCHEDULE add constraint CPAYSCHEDULE_CORDERPAYSCHEDULE foreign key (C_PAYSCHEDULE_ID) references C_PAYSCHEDULE(C_PAYSCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERTAX drop constraint "CORDER_CORDERTAX"
;

alter table C_ORDERTAX add constraint CORDER_CORDERTAX foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORDERTAX drop constraint "CTAX_CORDERTAX"
;

alter table C_ORDERTAX add constraint CTAX_CORDERTAX foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORGASSIGNMENT drop constraint "ADORG_CORGASSIGNMENT"
;

alter table C_ORGASSIGNMENT add constraint ADORG_CORGASSIGNMENT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_ORGASSIGNMENT drop constraint "ADUSER_CORGASSIGNMENT"
;

alter table C_ORGASSIGNMENT add constraint ADUSER_CORGASSIGNMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "ADORGTRX_CPAYMENT"
;

alter table C_PAYMENT add constraint ADORGTRX_CPAYMENT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "ADORG_CPAYMENT"
;

alter table C_PAYMENT add constraint ADORG_CPAYMENT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CACTIVITY_CPAYMENT"
;

alter table C_PAYMENT add constraint CACTIVITY_CPAYMENT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CBANKACCOUNT_CPAYMENT"
;

alter table C_PAYMENT add constraint CBANKACCOUNT_CPAYMENT foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CBPARTNER_CPAYMENT"
;

alter table C_PAYMENT add constraint CBPARTNER_CPAYMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CBPBANKACCT_CPAYMENT"
;

alter table C_PAYMENT add constraint CBPBANKACCT_CPAYMENT foreign key (C_BP_BANKACCOUNT_ID) references C_BP_BANKACCOUNT(C_BP_BANKACCOUNT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CCAMPAIGN_CPAYMENT"
;

alter table C_PAYMENT add constraint CCAMPAIGN_CPAYMENT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CCHARGE_CPAYMENT"
;

alter table C_PAYMENT add constraint CCHARGE_CPAYMENT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CCONVERSIONTYPE_CPAYMENT"
;

alter table C_PAYMENT add constraint CCONVERSIONTYPE_CPAYMENT foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CCURRENCY_CPAYMENT"
;

alter table C_PAYMENT add constraint CCURRENCY_CPAYMENT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CDOCTYPE_CPAYMENT"
;

alter table C_PAYMENT add constraint CDOCTYPE_CPAYMENT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CELEMENTVALUEUSER1_CPAYMENT"
;

alter table C_PAYMENT add constraint CELEMENTVALUEUSER1_CPAYMENT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CELEMENTVALUEUSER2_CPAYMENT"
;

alter table C_PAYMENT add constraint CELEMENTVALUEUSER2_CPAYMENT foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CINVOICE_CPAYMENT"
;

alter table C_PAYMENT add constraint CINVOICE_CPAYMENT foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CORDER_CPAYMENT"
;

alter table C_PAYMENT add constraint CORDER_CPAYMENT foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CPAYMENTBATCH_CPAYMENT"
;

alter table C_PAYMENT add constraint CPAYMENTBATCH_CPAYMENT foreign key (C_PAYMENTBATCH_ID) references C_PAYMENTBATCH(C_PAYMENTBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CPAYMENTPROCESSOR_CPAYMENT"
;

alter table C_PAYMENT add constraint CPAYMENTPROCESSOR_CPAYMENT foreign key (C_PAYMENTPROCESSOR_ID) references C_PAYMENTPROCESSOR(C_PAYMENTPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CPOSTENDERTYPE_CPAYMENT"
;

alter table C_PAYMENT add constraint CPOSTENDERTYPE_CPAYMENT foreign key (C_POSTENDERTYPE_ID) references C_POSTENDERTYPE(C_POSTENDERTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "CPROJECT_CPAYMENT"
;

alter table C_PAYMENT add constraint CPROJECT_CPAYMENT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "C_PAYMENT__C_CASHBO_C_CASHBOOK"
;

alter table C_PAYMENT add constraint C_PAYMENT__C_CASHBO_C_CASHBOOK foreign key (C_CASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "REFPAYMENT_CPAYMENT"
;

alter table C_PAYMENT add constraint REFPAYMENT_CPAYMENT foreign key (REF_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENT drop constraint "REVERSAL_CPAYMENT"
;

alter table C_PAYMENT add constraint REVERSAL_CPAYMENT foreign key (REVERSAL_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTALLOCATE drop constraint "CINVOICE_CPAYMENTALLOCATE"
;

alter table C_PAYMENTALLOCATE add constraint CINVOICE_CPAYMENTALLOCATE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTALLOCATE drop constraint "CPAYMENT_CPAYMENTALLOCATE"
;

alter table C_PAYMENTALLOCATE add constraint CPAYMENT_CPAYMENTALLOCATE foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTALLOCATE drop constraint "CPAYMTALLOCATE_CALLOCATIONLINE"
;

alter table C_PAYMENTALLOCATE add constraint CPAYMTALLOCATE_CALLOCATIONLINE foreign key (C_ALLOCATIONLINE_ID) references C_ALLOCATIONLINE(C_ALLOCATIONLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTBATCH drop constraint "CPAYMTPROCESSOR_CPAYMTBATCH"
;

alter table C_PAYMENTBATCH add constraint CPAYMTPROCESSOR_CPAYMTBATCH foreign key (C_PAYMENTPROCESSOR_ID) references C_PAYMENTPROCESSOR(C_PAYMENTPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTPROCESSOR drop constraint "ADSEQUENCE_CPAYMENTPROCESSOR"
;

alter table C_PAYMENTPROCESSOR add constraint ADSEQUENCE_CPAYMENTPROCESSOR foreign key (AD_SEQUENCE_ID) references AD_SEQUENCE(AD_SEQUENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTPROCESSOR drop constraint "CBANKACCOUNT_CPAYMTPROCESSOR"
;

alter table C_PAYMENTPROCESSOR add constraint CBANKACCOUNT_CPAYMTPROCESSOR foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTPROCESSOR drop constraint "CCURRENCY_CPAYMENTPROCESSOR"
;

alter table C_PAYMENTPROCESSOR add constraint CCURRENCY_CPAYMENTPROCESSOR foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTTERM_TRL drop constraint "ADLANGUAGE_CPAYMENTTERMTRL"
;

alter table C_PAYMENTTERM_TRL add constraint ADLANGUAGE_CPAYMENTTERMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYMENTTERM_TRL drop constraint "CPAYMENTTERM_CPAYTERMTRL"
;

alter table C_PAYMENTTERM_TRL add constraint CPAYMENTTERM_CPAYTERMTRL foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSCHEDULE drop constraint "CPAYMENTTERM_CPAYSCHEDULE"
;

alter table C_PAYSCHEDULE add constraint CPAYMENTTERM_CPAYSCHEDULE foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTION drop constraint "CBANKACCOUNT_CPAYSELECTION"
;

alter table C_PAYSELECTION add constraint CBANKACCOUNT_CPAYSELECTION foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONCHECK drop constraint "CBPARTNER_CPAYSELECTIONCHECK"
;

alter table C_PAYSELECTIONCHECK add constraint CBPARTNER_CPAYSELECTIONCHECK foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONCHECK drop constraint "CBPBANKACCOUNT_CPAYSELECTIONCH"
;

alter table C_PAYSELECTIONCHECK add constraint CBPBANKACCOUNT_CPAYSELECTIONCH foreign key (C_BP_BANKACCOUNT_ID) references C_BP_BANKACCOUNT(C_BP_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONCHECK drop constraint "CPAYMENT_CPAYSELECTIONCHECK"
;

alter table C_PAYSELECTIONCHECK add constraint CPAYMENT_CPAYSELECTIONCHECK foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONCHECK drop constraint "CPAYSELECTION_CPAYSELECTCHECK"
;

alter table C_PAYSELECTIONCHECK add constraint CPAYSELECTION_CPAYSELECTCHECK foreign key (C_PAYSELECTION_ID) references C_PAYSELECTION(C_PAYSELECTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONLINE drop constraint "CINVOICE_CPAYSELECTLINE"
;

alter table C_PAYSELECTIONLINE add constraint CINVOICE_CPAYSELECTLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONLINE drop constraint "CPAYSELCHECK_CPAYSELLINE"
;

alter table C_PAYSELECTIONLINE add constraint CPAYSELCHECK_CPAYSELLINE foreign key (C_PAYSELECTIONCHECK_ID) references C_PAYSELECTIONCHECK(C_PAYSELECTIONCHECK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PAYSELECTIONLINE drop constraint "CPAYSEL_CPAYSELLINE"
;

alter table C_PAYSELECTIONLINE add constraint CPAYSEL_CPAYSELLINE foreign key (C_PAYSELECTION_ID) references C_PAYSELECTION(C_PAYSELECTION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PERIOD drop constraint "C_PERIODCLIENT"
;

alter table C_PERIOD add constraint C_PERIODCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PERIOD drop constraint "C_PERIODORG"
;

alter table C_PERIOD add constraint C_PERIODORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PERIOD drop constraint "C_YEAR_PERIOD"
;

alter table C_PERIOD add constraint C_YEAR_PERIOD foreign key (C_YEAR_ID) references C_YEAR(C_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PERIODCONTROL drop constraint "C_PERIOD_PERIODCONTROL"
;

alter table C_PERIODCONTROL add constraint C_PERIOD_PERIODCONTROL foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PHASE drop constraint "CPROJECTTYPE_CPHASE"
;

alter table C_PHASE add constraint CPROJECTTYPE_CPHASE foreign key (C_PROJECTTYPE_ID) references C_PROJECTTYPE(C_PROJECTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PHASE drop constraint "MPRODUCT_CPHASE"
;

alter table C_PHASE add constraint MPRODUCT_CPHASE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "ADUSER_CPOS"
;

alter table C_POS add constraint ADUSER_CPOS foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "CBANKACCOUNT_CPOS"
;

alter table C_POS add constraint CBANKACCOUNT_CPOS foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "CBPARTNERCASHTRX_CPOS"
;

alter table C_POS add constraint CBPARTNERCASHTRX_CPOS foreign key (C_BPARTNERCASHTRX_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "CCASHBOOK_CPOS"
;

alter table C_POS add constraint CCASHBOOK_CPOS foreign key (C_CASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "CDOCTYPE_CPOS"
;

alter table C_POS add constraint CDOCTYPE_CPOS foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "CPOSKEYLAYOUT_CPOS"
;

alter table C_POS add constraint CPOSKEYLAYOUT_CPOS foreign key (C_POSKEYLAYOUT_ID) references C_POSKEYLAYOUT(C_POSKEYLAYOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "MPRICELIST_CPOS"
;

alter table C_POS add constraint MPRICELIST_CPOS foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "MWAREHOUSE_CPOS"
;

alter table C_POS add constraint MWAREHOUSE_CPOS foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "OSKKEYLAYOUT_CPOS"
;

alter table C_POS add constraint OSKKEYLAYOUT_CPOS foreign key (OSK_KEYLAYOUT_ID) references C_POSKEYLAYOUT(C_POSKEYLAYOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POS drop constraint "OSNPKEYLAYOUT_CPOS"
;

alter table C_POS add constraint OSNPKEYLAYOUT_CPOS foreign key (OSNP_KEYLAYOUT_ID) references C_POSKEYLAYOUT(C_POSKEYLAYOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "ADIMAGE_CPOSKEY"
;

alter table C_POSKEY add constraint ADIMAGE_CPOSKEY foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "ADPRINTCOLOR_CPOSKEY"
;

alter table C_POSKEY add constraint ADPRINTCOLOR_CPOSKEY foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "ADPRINTFONT_CPOSKEY"
;

alter table C_POSKEY add constraint ADPRINTFONT_CPOSKEY foreign key (AD_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "CPOSKEYLAYOUT_C_POSKEY"
;

alter table C_POSKEY add constraint CPOSKEYLAYOUT_C_POSKEY foreign key (C_POSKEYLAYOUT_ID) references C_POSKEYLAYOUT(C_POSKEYLAYOUT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "MPRODUCT_CPOSKEY"
;

alter table C_POSKEY add constraint MPRODUCT_CPOSKEY foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEY drop constraint "SUBKEYLAYOUT_CPOSKEY"
;

alter table C_POSKEY add constraint SUBKEYLAYOUT_CPOSKEY foreign key (SUBKEYLAYOUT_ID) references C_POSKEYLAYOUT(C_POSKEYLAYOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEYLAYOUT drop constraint "ADPRINTCOLOR_CPOSKEYLAYOUT"
;

alter table C_POSKEYLAYOUT add constraint ADPRINTCOLOR_CPOSKEYLAYOUT foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSKEYLAYOUT drop constraint "ADPRINTFONT_CPOSKEYLAYOUT"
;

alter table C_POSKEYLAYOUT add constraint ADPRINTFONT_CPOSKEYLAYOUT foreign key (AD_PRINTFONT_ID) references AD_PRINTFONT(AD_PRINTFONT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSPAYMENT drop constraint "CORDER_CPOSPAYMENT"
;

alter table C_POSPAYMENT add constraint CORDER_CPOSPAYMENT foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSPAYMENT drop constraint "CPAYMENT_CPOSPAYMENT"
;

alter table C_POSPAYMENT add constraint CPAYMENT_CPOSPAYMENT foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_POSPAYMENT drop constraint "CPOSTENDERTYPE_CPOSPAYMENT"
;

alter table C_POSPAYMENT add constraint CPOSTENDERTYPE_CPOSPAYMENT foreign key (C_POSTENDERTYPE_ID) references C_POSTENDERTYPE(C_POSTENDERTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "ADCLIENT_CPROJECT"
;

alter table C_PROJECT add constraint ADCLIENT_CPROJECT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "ADORG_CPROJECT"
;

alter table C_PROJECT add constraint ADORG_CPROJECT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "ADUSER_CPROJECT"
;

alter table C_PROJECT add constraint ADUSER_CPROJECT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "ADUSER_SR_CPROJECT"
;

alter table C_PROJECT add constraint ADUSER_SR_CPROJECT foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CBPARTNERSR_CPROJECT"
;

alter table C_PROJECT add constraint CBPARTNERSR_CPROJECT foreign key (C_BPARTNERSR_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CBPARTNER_CPROJECT"
;

alter table C_PROJECT add constraint CBPARTNER_CPROJECT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CBPLOCATION_CPROJECT"
;

alter table C_PROJECT add constraint CBPLOCATION_CPROJECT foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CCAMPAIGN_CPROJECT"
;

alter table C_PROJECT add constraint CCAMPAIGN_CPROJECT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CCURRENCY_CPROJECT"
;

alter table C_PROJECT add constraint CCURRENCY_CPROJECT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CPAYMENTTERM_CPROJECT"
;

alter table C_PROJECT add constraint CPAYMENTTERM_CPROJECT foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CPHASE_CPROJECT"
;

alter table C_PROJECT add constraint CPHASE_CPROJECT foreign key (C_PHASE_ID) references C_PHASE(C_PHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "CPROJECTTYPE_CPROJECT"
;

alter table C_PROJECT add constraint CPROJECTTYPE_CPROJECT foreign key (C_PROJECTTYPE_ID) references C_PROJECTTYPE(C_PROJECTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "MPRICELISTVERSION_CPROJECT"
;

alter table C_PROJECT add constraint MPRICELISTVERSION_CPROJECT foreign key (M_PRICELIST_VERSION_ID) references M_PRICELIST_VERSION(M_PRICELIST_VERSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT drop constraint "MWAREHOUSE_CPROJECT"
;

alter table C_PROJECT add constraint MWAREHOUSE_CPROJECT foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "CPROJECT_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint CPROJECT_CPROJECTISSUE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "MATTRSETINST_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint MATTRSETINST_CPROJECTISSUE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "MINOUTLINE_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint MINOUTLINE_CPROJECTISSUE foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "MLOCATOR_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint MLOCATOR_CPROJECTISSUE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "MPRODUCT_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint MPRODUCT_CPROJECTISSUE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUE drop constraint "STIMEEXPLINE_CPROJECTISSUE"
;

alter table C_PROJECTISSUE add constraint STIMEEXPLINE_CPROJECTISSUE foreign key (S_TIMEEXPENSELINE_ID) references S_TIMEEXPENSELINE(S_TIMEEXPENSELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUEMA drop constraint "CPROJECTISSUE_CPROJECTISSUEMA"
;

alter table C_PROJECTISSUEMA add constraint CPROJECTISSUE_CPROJECTISSUEMA foreign key (C_PROJECTISSUE_ID) references C_PROJECTISSUE(C_PROJECTISSUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTISSUEMA drop constraint "MASI_CPROJECTISSUEMA"
;

alter table C_PROJECTISSUEMA add constraint MASI_CPROJECTISSUEMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CORDERPO_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CORDERPO_CPROJECTLINE foreign key (C_ORDERPO_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CORDER_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CORDER_CPROJECTLINE foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CPROJECTISSUE_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CPROJECTISSUE_CPROJECTLINE foreign key (C_PROJECTISSUE_ID) references C_PROJECTISSUE(C_PROJECTISSUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CPROJECTPHASE_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CPROJECTPHASE_CPROJECTLINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CPROJECTTASK_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CPROJECTTASK_CPROJECTLINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "CPROJECT_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint CPROJECT_CPROJECTLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "MPRODUCTCAT_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint MPRODUCTCAT_CPROJECTLINE foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTLINE drop constraint "MPRODUCT_CPROJECTLINE"
;

alter table C_PROJECTLINE add constraint MPRODUCT_CPROJECTLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTPHASE drop constraint "CORDER_CPROJECTPHASE"
;

alter table C_PROJECTPHASE add constraint CORDER_CPROJECTPHASE foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTPHASE drop constraint "CPHASE_CPROJECTPHASE"
;

alter table C_PROJECTPHASE add constraint CPHASE_CPROJECTPHASE foreign key (C_PHASE_ID) references C_PHASE(C_PHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTPHASE drop constraint "CPROJECT_CPROJECTPHASE"
;

alter table C_PROJECTPHASE add constraint CPROJECT_CPROJECTPHASE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTPHASE drop constraint "MPRODUCT_CPROJECTPHASE"
;

alter table C_PROJECTPHASE add constraint MPRODUCT_CPROJECTPHASE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTTASK drop constraint "CPROJECTPHASE_CPROJECTTASK"
;

alter table C_PROJECTTASK add constraint CPROJECTPHASE_CPROJECTTASK foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTTASK drop constraint "CTASK_CPROJECTTASK"
;

alter table C_PROJECTTASK add constraint CTASK_CPROJECTTASK foreign key (C_TASK_ID) references C_TASK(C_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECTTASK drop constraint "MPRODUCT_CPROJECTTASK"
;

alter table C_PROJECTTASK add constraint MPRODUCT_CPROJECTTASK foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT_ACCT drop constraint "CACCTSCHEMA_CPROJECTACCT"
;

alter table C_PROJECT_ACCT add constraint CACCTSCHEMA_CPROJECTACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT_ACCT drop constraint "C_PROJECT_PROJECTACCT"
;

alter table C_PROJECT_ACCT add constraint C_PROJECT_PROJECTACCT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT_ACCT drop constraint "VC_PJASSET_CPROJECT"
;

alter table C_PROJECT_ACCT add constraint VC_PJASSET_CPROJECT foreign key (PJ_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_PROJECT_ACCT drop constraint "VC_PJWIP_CPROJECT"
;

alter table C_PROJECT_ACCT add constraint VC_PJWIP_CPROJECT foreign key (PJ_WIP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING drop constraint "CINVOICE_CRECURRING"
;

alter table C_RECURRING add constraint CINVOICE_CRECURRING foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING drop constraint "CORDER_CRECURRING"
;

alter table C_RECURRING add constraint CORDER_CRECURRING foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING drop constraint "CPAYMENT_CRECURRING"
;

alter table C_RECURRING add constraint CPAYMENT_CRECURRING foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING drop constraint "CPROJECT_CRECURRING"
;

alter table C_RECURRING add constraint CPROJECT_CRECURRING foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING drop constraint "GLJOURNALBATCH_CRECURRING"
;

alter table C_RECURRING add constraint GLJOURNALBATCH_CRECURRING foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "CINVOICE_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint CINVOICE_CRECURRINGRUN foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "CORDER_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint CORDER_CRECURRINGRUN foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "CPAYMENT_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint CPAYMENT_CRECURRINGRUN foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "CPROJECT_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint CPROJECT_CRECURRINGRUN foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "CRECURRING_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint CRECURRING_CRECURRINGRUN foreign key (C_RECURRING_ID) references C_RECURRING(C_RECURRING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RECURRING_RUN drop constraint "GLJOURNALBATCH_CRECURRINGRUN"
;

alter table C_RECURRING_RUN add constraint GLJOURNALBATCH_CRECURRINGRUN foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REGION drop constraint "CCOUNTRY_CREGION"
;

alter table C_REGION add constraint CCOUNTRY_CREGION foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REGION drop constraint "C_REGIONCLIENT"
;

alter table C_REGION add constraint C_REGIONCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REGION drop constraint "C_REGIONORG"
;

alter table C_REGION add constraint C_REGIONORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "CACCTSCHEMA_CREVRECPLAN"
;

alter table C_REVENUERECOGNITION_PLAN add constraint CACCTSCHEMA_CREVRECPLAN foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "CCURRENCY_CREVENUERECPLAN"
;

alter table C_REVENUERECOGNITION_PLAN add constraint CCURRENCY_CREVENUERECPLAN foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "CINVOICELINE_CREVENUERECPLAN"
;

alter table C_REVENUERECOGNITION_PLAN add constraint CINVOICELINE_CREVENUERECPLAN foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "CREVENUERECOGNITION_PLAN"
;

alter table C_REVENUERECOGNITION_PLAN add constraint CREVENUERECOGNITION_PLAN foreign key (C_REVENUERECOGNITION_ID) references C_REVENUERECOGNITION(C_REVENUERECOGNITION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "VC_PREVENUE_CREVENUERECOGNITIO"
;

alter table C_REVENUERECOGNITION_PLAN add constraint VC_PREVENUE_CREVENUERECOGNITIO foreign key (P_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_PLAN drop constraint "VC_UNEARNEDREVENUE_CREVENUEREC"
;

alter table C_REVENUERECOGNITION_PLAN add constraint VC_UNEARNEDREVENUE_CREVENUEREC foreign key (UNEARNEDREVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_RUN drop constraint "CREVRECPLAN_CREFRECRUN"
;

alter table C_REVENUERECOGNITION_RUN add constraint CREVRECPLAN_CREFRECRUN foreign key (C_REVENUERECOGNITION_PLAN_ID) references C_REVENUERECOGNITION_PLAN(C_REVENUERECOGNITION_PLAN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_REVENUERECOGNITION_RUN drop constraint "GLJOURNAL_CREVENUERECRUN"
;

alter table C_REVENUERECOGNITION_RUN add constraint GLJOURNAL_CREVENUERECRUN foreign key (GL_JOURNAL_ID) references GL_JOURNAL(GL_JOURNAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "ADUSERSALESREP_CRFQ"
;

alter table C_RFQ add constraint ADUSERSALESREP_CRFQ foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "ADUSER_CRFQ"
;

alter table C_RFQ add constraint ADUSER_CRFQ foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "CBPARTNER_CRFQ"
;

alter table C_RFQ add constraint CBPARTNER_CRFQ foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "CBPLOCATION_CRFQ"
;

alter table C_RFQ add constraint CBPLOCATION_CRFQ foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "CCURRENCY_CRFQ"
;

alter table C_RFQ add constraint CCURRENCY_CRFQ foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "CORDER_CRFQ"
;

alter table C_RFQ add constraint CORDER_CRFQ foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ drop constraint "CRFQTOPIC_CRFQ"
;

alter table C_RFQ add constraint CRFQTOPIC_CRFQ foreign key (C_RFQ_TOPIC_ID) references C_RFQ_TOPIC(C_RFQ_TOPIC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQLINE drop constraint "CRFQ_CRFQLINE"
;

alter table C_RFQLINE add constraint CRFQ_CRFQLINE foreign key (C_RFQ_ID) references C_RFQ(C_RFQ_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQLINE drop constraint "MASETINSTANCE_CRFQLINE"
;

alter table C_RFQLINE add constraint MASETINSTANCE_CRFQLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQLINE drop constraint "MPRODUCT_CRFQLINE"
;

alter table C_RFQLINE add constraint MPRODUCT_CRFQLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQLINEQTY drop constraint "CRFQLINE_CRFQLINEQTY"
;

alter table C_RFQLINEQTY add constraint CRFQLINE_CRFQLINEQTY foreign key (C_RFQLINE_ID) references C_RFQLINE(C_RFQLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQLINEQTY drop constraint "CUOM_CRFQLINEQTY"
;

alter table C_RFQLINEQTY add constraint CUOM_CRFQLINEQTY foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "ADUSER_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint ADUSER_CRFQRESPONSE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "CBPARTNER_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint CBPARTNER_CRFQRESPONSE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "CBPLOCATION_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint CBPLOCATION_CRFQRESPONSE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "CCURRENCY_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint CCURRENCY_CRFQRESPONSE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "CORDER_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint CORDER_CRFQRESPONSE foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSE drop constraint "CRFQ_CRFQRESPONSE"
;

alter table C_RFQRESPONSE add constraint CRFQ_CRFQRESPONSE foreign key (C_RFQ_ID) references C_RFQ(C_RFQ_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSELINE drop constraint "CRFQLINE_CRFQRESPONSELINE"
;

alter table C_RFQRESPONSELINE add constraint CRFQLINE_CRFQRESPONSELINE foreign key (C_RFQLINE_ID) references C_RFQLINE(C_RFQLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSELINE drop constraint "CRFQRESPONSE_LINE"
;

alter table C_RFQRESPONSELINE add constraint CRFQRESPONSE_LINE foreign key (C_RFQRESPONSE_ID) references C_RFQRESPONSE(C_RFQRESPONSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSELINEQTY drop constraint "CRFQLINEQTY_CRFQRESPLINEQTY"
;

alter table C_RFQRESPONSELINEQTY add constraint CRFQLINEQTY_CRFQRESPLINEQTY foreign key (C_RFQLINEQTY_ID) references C_RFQLINEQTY(C_RFQLINEQTY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQRESPONSELINEQTY drop constraint "CRFQRESONSELINE_QTY"
;

alter table C_RFQRESPONSELINEQTY add constraint CRFQRESONSELINE_QTY foreign key (C_RFQRESPONSELINE_ID) references C_RFQRESPONSELINE(C_RFQRESPONSELINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPIC drop constraint "ADPRINTFORMAT_ARFQTOPIC"
;

alter table C_RFQ_TOPIC add constraint ADPRINTFORMAT_ARFQTOPIC foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBER drop constraint "ADUSER_ARFQTOPICSUBCR"
;

alter table C_RFQ_TOPICSUBSCRIBER add constraint ADUSER_ARFQTOPICSUBCR foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBER drop constraint "CBPARTNERLOC_CRFQTOPICSUBR"
;

alter table C_RFQ_TOPICSUBSCRIBER add constraint CBPARTNERLOC_CRFQTOPICSUBR foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBER drop constraint "CBPARTNER_CRFQTOPICSUBR"
;

alter table C_RFQ_TOPICSUBSCRIBER add constraint CBPARTNER_CRFQTOPICSUBR foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBER drop constraint "C_RFQTOPIC_SUBSCRIBER"
;

alter table C_RFQ_TOPICSUBSCRIBER add constraint C_RFQTOPIC_SUBSCRIBER foreign key (C_RFQ_TOPIC_ID) references C_RFQ_TOPIC(C_RFQ_TOPIC_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBERONLY drop constraint "CRFQTOPICSUBSCRIBER_ONLY"
;

alter table C_RFQ_TOPICSUBSCRIBERONLY add constraint CRFQTOPICSUBSCRIBER_ONLY foreign key (C_RFQ_TOPICSUBSCRIBER_ID) references C_RFQ_TOPICSUBSCRIBER(C_RFQ_TOPICSUBSCRIBER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBERONLY drop constraint "MPRODCATEGORY_CRFQTSUBONLY"
;

alter table C_RFQ_TOPICSUBSCRIBERONLY add constraint MPRODCATEGORY_CRFQTSUBONLY foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_RFQ_TOPICSUBSCRIBERONLY drop constraint "MPRODUCT_CRFQTSUBONLY"
;

alter table C_RFQ_TOPICSUBSCRIBERONLY add constraint MPRODUCT_CRFQTSUBONLY foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SALESREGION drop constraint "SALESREP_CSALESREGION"
;

alter table C_SALESREGION add constraint SALESREP_CSALESREGION foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SERVICELEVEL drop constraint "CREVRECPLAN_CSERVICELEVEL"
;

alter table C_SERVICELEVEL add constraint CREVRECPLAN_CSERVICELEVEL foreign key (C_REVENUERECOGNITION_PLAN_ID) references C_REVENUERECOGNITION_PLAN(C_REVENUERECOGNITION_PLAN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SERVICELEVEL drop constraint "MPRODUCT_CSERVICELEVEL"
;

alter table C_SERVICELEVEL add constraint MPRODUCT_CSERVICELEVEL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SERVICELEVELLINE drop constraint "CSERVICELEVEL_LINE"
;

alter table C_SERVICELEVELLINE add constraint CSERVICELEVEL_LINE foreign key (C_SERVICELEVEL_ID) references C_SERVICELEVEL(C_SERVICELEVEL_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SUBACCT drop constraint "CELEMENTVALUE_CSUBACCT"
;

alter table C_SUBACCT add constraint CELEMENTVALUE_CSUBACCT foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SUBSCRIPTION drop constraint "CBPARTNER_CSUBSCRIPTION"
;

alter table C_SUBSCRIPTION add constraint CBPARTNER_CSUBSCRIPTION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SUBSCRIPTION drop constraint "CSUBSCRTYPE_CSUBSCRIPTION"
;

alter table C_SUBSCRIPTION add constraint CSUBSCRTYPE_CSUBSCRIPTION foreign key (C_SUBSCRIPTIONTYPE_ID) references C_SUBSCRIPTIONTYPE(C_SUBSCRIPTIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SUBSCRIPTION drop constraint "MPRODUCT_CSUBSCRIPTION"
;

alter table C_SUBSCRIPTION add constraint MPRODUCT_CSUBSCRIPTION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_SUBSCRIPTION_DELIVERY drop constraint "CSUBCRIPTION_CSUBSCRDELIVERY"
;

alter table C_SUBSCRIPTION_DELIVERY add constraint CSUBCRIPTION_CSUBSCRDELIVERY foreign key (C_SUBSCRIPTION_ID) references C_SUBSCRIPTION(C_SUBSCRIPTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TASK drop constraint "CPHASE_CTASK"
;

alter table C_TASK add constraint CPHASE_CTASK foreign key (C_PHASE_ID) references C_PHASE(C_PHASE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TASK drop constraint "MPRODUCT_CTASK"
;

alter table C_TASK add constraint MPRODUCT_CTASK foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "ADRULE_CTAX"
;

alter table C_TAX add constraint ADRULE_CTAX foreign key (AD_RULE_ID) references AD_RULE(AD_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "CTAXCATEGORY_CTAX"
;

alter table C_TAX add constraint CTAXCATEGORY_CTAX foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "CTAX_PARENT"
;

alter table C_TAX add constraint CTAX_PARENT foreign key (PARENT_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "C_COUNTRYTO_C_TAX"
;

alter table C_TAX add constraint C_COUNTRYTO_C_TAX foreign key (TO_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "C_COUNTRY_C_TAX"
;

alter table C_TAX add constraint C_COUNTRY_C_TAX foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "C_REGIONTO_C_TAX"
;

alter table C_TAX add constraint C_REGIONTO_C_TAX foreign key (TO_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX drop constraint "C_REGION_C_TAX"
;

alter table C_TAX add constraint C_REGION_C_TAX foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXCATEGORY_TRL drop constraint "ADLANGUAGE_CTAXCATEGORYTRL"
;

alter table C_TAXCATEGORY_TRL add constraint ADLANGUAGE_CTAXCATEGORYTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXCATEGORY_TRL drop constraint "CTAXCATEGORY_TRL"
;

alter table C_TAXCATEGORY_TRL add constraint CTAXCATEGORY_TRL foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONACCT drop constraint "CACCTSCHEMA_CTAXDECLACCT"
;

alter table C_TAXDECLARATIONACCT add constraint CACCTSCHEMA_CTAXDECLACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONACCT drop constraint "CTAXDECL_CTAXDECLACCT"
;

alter table C_TAXDECLARATIONACCT add constraint CTAXDECL_CTAXDECLACCT foreign key (C_TAXDECLARATION_ID) references C_TAXDECLARATION(C_TAXDECLARATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONACCT drop constraint "FACTACCT_CTAXDECLACCT"
;

alter table C_TAXDECLARATIONACCT add constraint FACTACCT_CTAXDECLACCT foreign key (FACT_ACCT_ID) references FACT_ACCT(FACT_ACCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CALLOCATIONLINE_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CALLOCATIONLINE_CTAXDECLLINE foreign key (C_ALLOCATIONLINE_ID) references C_ALLOCATIONLINE(C_ALLOCATIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CBPARTNER_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CBPARTNER_CTAXDECLLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CCURRENCY_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CCURRENCY_CTAXDECLLINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CINVOICELINE_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CINVOICELINE_CTAXDECLLINE foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CINVOICE_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CINVOICE_CTAXDECLLINE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CTAXDECLARATION_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CTAXDECLARATION_CTAXDECLLINE foreign key (C_TAXDECLARATION_ID) references C_TAXDECLARATION(C_TAXDECLARATION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDECLARATIONLINE drop constraint "CTAX_CTAXDECLLINE"
;

alter table C_TAXDECLARATIONLINE add constraint CTAX_CTAXDECLLINE foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "ADORGTYPE_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint ADORGTYPE_CTAXDEFINITION foreign key (AD_ORGTYPE_ID) references AD_ORGTYPE(AD_ORGTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CBPARTNER_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CBPARTNER_CTAXDEFINITION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CBPGROUP_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CBPGROUP_CTAXDEFINITION foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CTAXBASE_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CTAXBASE_CTAXDEFINITION foreign key (C_TAXBASE_ID) references C_TAXBASE(C_TAXBASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CTAXCATEGORY_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CTAXCATEGORY_CTAXDEFINITION foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CTAXGROUP_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CTAXGROUP_CTAXDEFINITION foreign key (C_TAXGROUP_ID) references C_TAXGROUP(C_TAXGROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CTAXTYPE_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CTAXTYPE_CTAXDEFINITION foreign key (C_TAXTYPE_ID) references C_TAXTYPE(C_TAXTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "CTAX_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint CTAX_CTAXDEFINITION foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "MPRODUCTCATEGORY_CTAXDEFINITIO"
;

alter table C_TAXDEFINITION add constraint MPRODUCTCATEGORY_CTAXDEFINITIO foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXDEFINITION drop constraint "MPRODUCT_CTAXDEFINITION"
;

alter table C_TAXDEFINITION add constraint MPRODUCT_CTAXDEFINITION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAXPOSTAL drop constraint "CTAX_CTAXPOSTAL"
;

alter table C_TAXPOSTAL add constraint CTAX_CTAXPOSTAL foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "CACCTSCHEMA_CTAXACCT"
;

alter table C_TAX_ACCT add constraint CACCTSCHEMA_CTAXACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "CTAX_CTAXACCT"
;

alter table C_TAX_ACCT add constraint CTAX_CTAXACCT foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "VC_TCREDIT_CTAX"
;

alter table C_TAX_ACCT add constraint VC_TCREDIT_CTAX foreign key (T_CREDIT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "VC_TDUE_CTAX"
;

alter table C_TAX_ACCT add constraint VC_TDUE_CTAX foreign key (T_DUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "VC_TEXPENSE_CTAX"
;

alter table C_TAX_ACCT add constraint VC_TEXPENSE_CTAX foreign key (T_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "VC_TLIABILITY_CTAX"
;

alter table C_TAX_ACCT add constraint VC_TLIABILITY_CTAX foreign key (T_LIABILITY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_ACCT drop constraint "VC_TREC_CTAX"
;

alter table C_TAX_ACCT add constraint VC_TREC_CTAX foreign key (T_RECEIVABLES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_TRL drop constraint "ADLANGUAGE_CTAXTRL"
;

alter table C_TAX_TRL add constraint ADLANGUAGE_CTAXTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_TAX_TRL drop constraint "CTAX_CTAXTRL"
;

alter table C_TAX_TRL add constraint CTAX_CTAXTRL foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM drop constraint "C_UOMCLIENT"
;

alter table C_UOM add constraint C_UOMCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM drop constraint "C_UOMORG"
;

alter table C_UOM add constraint C_UOMORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_CONVERSION drop constraint "CUOM_CUOMCONVERSION"
;

alter table C_UOM_CONVERSION add constraint CUOM_CUOMCONVERSION foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_CONVERSION drop constraint "C_UOMCONVERSIONTO"
;

alter table C_UOM_CONVERSION add constraint C_UOMCONVERSIONTO foreign key (C_UOM_TO_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_CONVERSION drop constraint "C_UOM_CONVERSIONCLIENT"
;

alter table C_UOM_CONVERSION add constraint C_UOM_CONVERSIONCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_CONVERSION drop constraint "C_UOM_CONVERSIONORG"
;

alter table C_UOM_CONVERSION add constraint C_UOM_CONVERSIONORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_CONVERSION drop constraint "MPRODUCT_CUOMCONVERSION"
;

alter table C_UOM_CONVERSION add constraint MPRODUCT_CUOMCONVERSION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_TRL drop constraint "ADLANGUAGE_CUOMTRL"
;

alter table C_UOM_TRL add constraint ADLANGUAGE_CUOMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_UOM_TRL drop constraint "CUOM_CUOMTRL"
;

alter table C_UOM_TRL add constraint CUOM_CUOMTRL foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_USERREMUNERATION drop constraint "ADUSER_CUSERREMUNERATION"
;

alter table C_USERREMUNERATION add constraint ADUSER_CUSERREMUNERATION foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_USERREMUNERATION drop constraint "CREMUNERATION_CUSERREM"
;

alter table C_USERREMUNERATION add constraint CREMUNERATION_CUSERREM foreign key (C_REMUNERATION_ID) references C_REMUNERATION(C_REMUNERATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "ADCLIENT_VC"
;

alter table C_VALIDCOMBINATION add constraint ADCLIENT_VC foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "ADORGTRX_VC"
;

alter table C_VALIDCOMBINATION add constraint ADORGTRX_VC foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "ADORG_VC"
;

alter table C_VALIDCOMBINATION add constraint ADORG_VC foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CACCTSCHEMA_CVALIDCOMBINATION"
;

alter table C_VALIDCOMBINATION add constraint CACCTSCHEMA_CVALIDCOMBINATION foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CACTIVITY_CVALIDCOMBINATION"
;

alter table C_VALIDCOMBINATION add constraint CACTIVITY_CVALIDCOMBINATION foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CBPARTNER_VC"
;

alter table C_VALIDCOMBINATION add constraint CBPARTNER_VC foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CELEMENTVALUEACCOUNT_VC"
;

alter table C_VALIDCOMBINATION add constraint CELEMENTVALUEACCOUNT_VC foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CELEMENTVALUEUSER1_VC"
;

alter table C_VALIDCOMBINATION add constraint CELEMENTVALUEUSER1_VC foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CELEMENTVALUEUSER2_VC"
;

alter table C_VALIDCOMBINATION add constraint CELEMENTVALUEUSER2_VC foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CPROJECT_VC"
;

alter table C_VALIDCOMBINATION add constraint CPROJECT_VC foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CSALESREGION_VC"
;

alter table C_VALIDCOMBINATION add constraint CSALESREGION_VC foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "CSUBACCT_CVALIDCOMBINATION"
;

alter table C_VALIDCOMBINATION add constraint CSUBACCT_CVALIDCOMBINATION foreign key (C_SUBACCT_ID) references C_SUBACCT(C_SUBACCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "MLOCATIONFROM_VC"
;

alter table C_VALIDCOMBINATION add constraint MLOCATIONFROM_VC foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "MLOCATIONTO_VC"
;

alter table C_VALIDCOMBINATION add constraint MLOCATIONTO_VC foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "MPRODUCT_VC"
;

alter table C_VALIDCOMBINATION add constraint MPRODUCT_VC foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_VALIDCOMBINATION drop constraint "SOCAMPAIGN_VC"
;

alter table C_VALIDCOMBINATION add constraint SOCAMPAIGN_VC foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_WITHHOLDING drop constraint "BENEFICI_CWITHHOLDING"
;

alter table C_WITHHOLDING add constraint BENEFICI_CWITHHOLDING foreign key (BENEFICIARY) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_WITHHOLDING drop constraint "CPAYMENTTERM_CWITHHOLDING"
;

alter table C_WITHHOLDING add constraint CPAYMENTTERM_CWITHHOLDING foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_WITHHOLDING_ACCT drop constraint "CACCTSCHEMA_CWITHHOLDINGACCT"
;

alter table C_WITHHOLDING_ACCT add constraint CACCTSCHEMA_CWITHHOLDINGACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_WITHHOLDING_ACCT drop constraint "CWITHHOLDING_CWITHHOLDINGACCT"
;

alter table C_WITHHOLDING_ACCT add constraint CWITHHOLDING_CWITHHOLDINGACCT foreign key (C_WITHHOLDING_ID) references C_WITHHOLDING(C_WITHHOLDING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_WITHHOLDING_ACCT drop constraint "VC_WITHHOLDING_CWITHHOLDING"
;

alter table C_WITHHOLDING_ACCT add constraint VC_WITHHOLDING_CWITHHOLDING foreign key (WITHHOLDING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_YEAR drop constraint "C_CALENDAR_YEAR"
;

alter table C_YEAR add constraint C_CALENDAR_YEAR foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_YEAR drop constraint "C_YEARCLIENT"
;

alter table C_YEAR add constraint C_YEARCLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table C_YEAR drop constraint "C_YEARORG"
;

alter table C_YEAR add constraint C_YEARORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_NETWORKDISTRIBUTION drop constraint "MCHANGENOTICE_DDNETWORKDISTRIB"
;

alter table DD_NETWORKDISTRIBUTION add constraint MCHANGENOTICE_DDNETWORKDISTRIB foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_NETWORKDISTRIBUTIONLINE drop constraint "DDNETWORKDISTRIBUTION_DDNETWOR"
;

alter table DD_NETWORKDISTRIBUTIONLINE add constraint DDNETWORKDISTRIBUTION_DDNETWOR foreign key (DD_NETWORKDISTRIBUTION_ID) references DD_NETWORKDISTRIBUTION(DD_NETWORKDISTRIBUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_NETWORKDISTRIBUTIONLINE drop constraint "MSHIPPER_DDNETWORKDISTRIBUTION"
;

alter table DD_NETWORKDISTRIBUTIONLINE add constraint MSHIPPER_DDNETWORKDISTRIBUTION foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_NETWORKDISTRIBUTIONLINE drop constraint "MWAREHOUSESOURCE_DDNETWORKDIST"
;

alter table DD_NETWORKDISTRIBUTIONLINE add constraint MWAREHOUSESOURCE_DDNETWORKDIST foreign key (M_WAREHOUSESOURCE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_NETWORKDISTRIBUTIONLINE drop constraint "MWAREHOUSE_DDNETWORKDISTRIBUTI"
;

alter table DD_NETWORKDISTRIBUTIONLINE add constraint MWAREHOUSE_DDNETWORKDISTRIBUTI foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "ADORGTRX_DDORDER"
;

alter table DD_ORDER add constraint ADORGTRX_DDORDER foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "ADUSER_DDORDER"
;

alter table DD_ORDER add constraint ADUSER_DDORDER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CACTIVITY_DDORDER"
;

alter table DD_ORDER add constraint CACTIVITY_DDORDER foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CBPARTNERLOCATION_DDORDER"
;

alter table DD_ORDER add constraint CBPARTNERLOCATION_DDORDER foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CBPARTNER_DDORDER"
;

alter table DD_ORDER add constraint CBPARTNER_DDORDER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CCAMPAIGN_DDORDER"
;

alter table DD_ORDER add constraint CCAMPAIGN_DDORDER foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CCHARGE_DDORDER"
;

alter table DD_ORDER add constraint CCHARGE_DDORDER foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CDOCTYPE_DDORDER"
;

alter table DD_ORDER add constraint CDOCTYPE_DDORDER foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CINVOICE_DDORDER"
;

alter table DD_ORDER add constraint CINVOICE_DDORDER foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CORDER_DDORDER"
;

alter table DD_ORDER add constraint CORDER_DDORDER foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "CPROJECT_DDORDER"
;

alter table DD_ORDER add constraint CPROJECT_DDORDER foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "MSHIPPER_DDORDER"
;

alter table DD_ORDER add constraint MSHIPPER_DDORDER foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "MWAREHOUSE_DDORDER"
;

alter table DD_ORDER add constraint MWAREHOUSE_DDORDER foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "SALESREP_DDORDER"
;

alter table DD_ORDER add constraint SALESREP_DDORDER foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "USER1_DDORDER"
;

alter table DD_ORDER add constraint USER1_DDORDER foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDER drop constraint "USER2_DDORDER"
;

alter table DD_ORDER add constraint USER2_DDORDER foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "ADORGTRX_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint ADORGTRX_DDORDERLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "CACTIVITY_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint CACTIVITY_DDORDERLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "CCAMPAIGN_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint CCAMPAIGN_DDORDERLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "CCHARGE_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint CCHARGE_DDORDERLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "CPROJECT_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint CPROJECT_DDORDERLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "CUOM_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint CUOM_DDORDERLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "DDORDER_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint DDORDER_DDORDERLINE foreign key (DD_ORDER_ID) references DD_ORDER(DD_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MATTRIBUTESETINSTANCETO_DDORDE"
;

alter table DD_ORDERLINE add constraint MATTRIBUTESETINSTANCETO_DDORDE foreign key (M_ATTRIBUTESETINSTANCETO_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MATTRIBUTESETINSTANCE_DDORDERL"
;

alter table DD_ORDERLINE add constraint MATTRIBUTESETINSTANCE_DDORDERL foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MLOCATORTO_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint MLOCATORTO_DDORDERLINE foreign key (M_LOCATORTO_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MLOCATOR_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint MLOCATOR_DDORDERLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MPRODUCT_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint MPRODUCT_DDORDERLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "MSHIPPER_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint MSHIPPER_DDORDERLINE foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "USER1_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint USER1_DDORDERLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table DD_ORDERLINE drop constraint "USER2_DDORDERLINE"
;

alter table DD_ORDERLINE add constraint USER2_DDORDERLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_FORMAT drop constraint "ADTABLE_EXPFORMAT"
;

alter table EXP_FORMAT add constraint ADTABLE_EXPFORMAT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_FORMATLINE drop constraint "ADCOLUMN_EXPFORMATLINE"
;

alter table EXP_FORMATLINE add constraint ADCOLUMN_EXPFORMATLINE foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_FORMATLINE drop constraint "EXPEMBEDDEDFORMAT_EXPFORMATLIN"
;

alter table EXP_FORMATLINE add constraint EXPEMBEDDEDFORMAT_EXPFORMATLIN foreign key (EXP_EMBEDDEDFORMAT_ID) references EXP_FORMAT(EXP_FORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_FORMATLINE drop constraint "EXPFORMAT_EXPFORMATLINE"
;

alter table EXP_FORMATLINE add constraint EXPFORMAT_EXPFORMATLINE foreign key (EXP_FORMAT_ID) references EXP_FORMAT(EXP_FORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_PROCESSOR drop constraint "EXPPROCESSORTYPE_EXPPROCESSOR"
;

alter table EXP_PROCESSOR add constraint EXPPROCESSORTYPE_EXPPROCESSOR foreign key (EXP_PROCESSOR_TYPE_ID) references EXP_PROCESSOR_TYPE(EXP_PROCESSOR_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table EXP_PROCESSORPARAMETER drop constraint "EXPPROCESSOR_EXPPROCESSORPARAM"
;

alter table EXP_PROCESSORPARAMETER add constraint EXPPROCESSOR_EXPPROCESSORPARAM foreign key (EXP_PROCESSOR_ID) references EXP_PROCESSOR(EXP_PROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "AASSET_FACTACCT"
;

alter table FACT_ACCT add constraint AASSET_FACTACCT foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "AC_CLIENT_FACT_ACCT"
;

alter table FACT_ACCT add constraint AC_CLIENT_FACT_ACCT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "ADTABLE_FACTACCT"
;

alter table FACT_ACCT add constraint ADTABLE_FACTACCT foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "AD_ORGTRX_FACT_ACCT"
;

alter table FACT_ACCT add constraint AD_ORGTRX_FACT_ACCT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "AD_ORG_FACT_ACCT"
;

alter table FACT_ACCT add constraint AD_ORG_FACT_ACCT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CACCTSCHEMA_FACTACCT"
;

alter table FACT_ACCT add constraint CACCTSCHEMA_FACTACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CACTIVITY_FACTACCT"
;

alter table FACT_ACCT add constraint CACTIVITY_FACTACCT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CELEMENTVALUEUSER1_FACTACCT"
;

alter table FACT_ACCT add constraint CELEMENTVALUEUSER1_FACTACCT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CELEMENTVALUEUSER2_FACTACCT"
;

alter table FACT_ACCT add constraint CELEMENTVALUEUSER2_FACTACCT foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CELEMENTVALUE_FACTACCT"
;

alter table FACT_ACCT add constraint CELEMENTVALUE_FACTACCT foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CPERIOD_FACTACCT"
;

alter table FACT_ACCT add constraint CPERIOD_FACTACCT foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CPROJECTPHASE_FACTACCT"
;

alter table FACT_ACCT add constraint CPROJECTPHASE_FACTACCT foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CPROJECTTASK_FACTACCT"
;

alter table FACT_ACCT add constraint CPROJECTTASK_FACTACCT foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CSUBACCT_FACTACCT"
;

alter table FACT_ACCT add constraint CSUBACCT_FACTACCT foreign key (C_SUBACCT_ID) references C_SUBACCT(C_SUBACCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "CTAX_FACTACCT"
;

alter table FACT_ACCT add constraint CTAX_FACTACCT foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_BUSPARTNER_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_BUSPARTNER_FACT_ACCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_CURRENCY_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_CURRENCY_FACT_ACCT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_LOCATIONFROM_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_LOCATIONFROM_FACT_ACCT foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_LOCATIONTO_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_LOCATIONTO_FACT_ACCT foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_PROJECT_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_PROJECT_FACT_ACCT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_SALESREGION_FACTACCT"
;

alter table FACT_ACCT add constraint C_SALESREGION_FACTACCT foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "C_UOM_FACT_ACCT"
;

alter table FACT_ACCT add constraint C_UOM_FACT_ACCT foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "GLBUDGET_FACTACCT"
;

alter table FACT_ACCT add constraint GLBUDGET_FACTACCT foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "GLCATEGORY_FACTACCT"
;

alter table FACT_ACCT add constraint GLCATEGORY_FACTACCT foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "MLOCATOR_FACTACCT"
;

alter table FACT_ACCT add constraint MLOCATOR_FACTACCT foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "M_PRODUCT_FACT_ACCT"
;

alter table FACT_ACCT add constraint M_PRODUCT_FACT_ACCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT drop constraint "SO_CAMPAIGN_FACT_ACCT"
;

alter table FACT_ACCT add constraint SO_CAMPAIGN_FACT_ACCT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "ACCOUNT_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint ACCOUNT_FACTACCTSUMMARY foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "ADORGTRX_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint ADORGTRX_FACTACCTSUMMARY foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CACCTSCHEMA_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CACCTSCHEMA_FACTACCTSUMMARY foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CACTIVITY_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CACTIVITY_FACTACCTSUMMARY foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CBPARTNER_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CBPARTNER_FACTACCTSUMMARY foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CCAMPAIGN_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CCAMPAIGN_FACTACCTSUMMARY foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CLOCFROM_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CLOCFROM_FACTACCTSUMMARY foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CLOCTO_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CLOCTO_FACTACCTSUMMARY foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CPERIOD_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CPERIOD_FACTACCTSUMMARY foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CPROJECTPHASE_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CPROJECTPHASE_FACTACCTSUMMARY foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CPROJECTTASK_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CPROJECTTASK_FACTACCTSUMMARY foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CPROJECT_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CPROJECT_FACTACCTSUMMARY foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CSALESREGION_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CSALESREGION_FACTACCTSUMMARY foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "CSUBACCT_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint CSUBACCT_FACTACCTSUMMARY foreign key (C_SUBACCT_ID) references C_SUBACCT(C_SUBACCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "GLBUDGET_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint GLBUDGET_FACTACCTSUMMARY foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "MPRODUCT_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint MPRODUCT_FACTACCTSUMMARY foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "PAREPORTCUBE_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint PAREPORTCUBE_FACTACCTSUMMARY foreign key (PA_REPORTCUBE_ID) references PA_REPORTCUBE(PA_REPORTCUBE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "USER1_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint USER1_FACTACCTSUMMARY foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_ACCT_SUMMARY drop constraint "USER2_FACTACCTSUMMARY"
;

alter table FACT_ACCT_SUMMARY add constraint USER2_FACTACCTSUMMARY foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table FACT_RECONCILIATION drop constraint "FACTACCT_FACTRECONCILIATION"
;

alter table FACT_RECONCILIATION add constraint FACTACCT_FACTRECONCILIATION foreign key (FACT_ACCT_ID) references FACT_ACCT(FACT_ACCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_BUDGETCONTROL drop constraint "CACCTSCHEMA_GLBUDGETCONTROL"
;

alter table GL_BUDGETCONTROL add constraint CACCTSCHEMA_GLBUDGETCONTROL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_BUDGETCONTROL drop constraint "GLBUDGET_GLBUDGETCONTROL"
;

alter table GL_BUDGETCONTROL add constraint GLBUDGET_GLBUDGETCONTROL foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "ADORGORG_GLDIST"
;

alter table GL_DISTRIBUTION add constraint ADORGORG_GLDIST foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "ADORGTRX_GLDIST"
;

alter table GL_DISTRIBUTION add constraint ADORGTRX_GLDIST foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "ADORG_GLDIST"
;

alter table GL_DISTRIBUTION add constraint ADORG_GLDIST foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CACCTSCHEMA_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CACCTSCHEMA_GLDIST foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CACTIVITY_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CACTIVITY_GLDIST foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CBPARTNER_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CBPARTNER_GLDIST foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CCAMPAIGN_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CCAMPAIGN_GLDIST foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CDOCTYPE_GLDISTRIBUTION"
;

alter table GL_DISTRIBUTION add constraint CDOCTYPE_GLDISTRIBUTION foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CEVALUEACCT_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CEVALUEACCT_GLDIST foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CEVALUEUSER1_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CEVALUEUSER1_GLDIST foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CEVALUEUSER2_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CEVALUEUSER2_GLDIST foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CLOCFROM_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CLOCFROM_GLDIST foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CLOCTO_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CLOCTO_GLDIST foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CPROJECT_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CPROJECT_GLDIST foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "CSALESREGOPN_GLDIST"
;

alter table GL_DISTRIBUTION add constraint CSALESREGOPN_GLDIST foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTION drop constraint "MPRODUCT_GLDIST"
;

alter table GL_DISTRIBUTION add constraint MPRODUCT_GLDIST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "ADORGORG_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint ADORGORG_GLDISTLINE foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "ADORGTRX_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint ADORGTRX_GLDISTLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "ADORG_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint ADORG_GLDISTLINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CACTIVITY_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CACTIVITY_GLDISTLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CBPARTNER_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CBPARTNER_GLDISTLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CCAMPAIGN_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CCAMPAIGN_GLDISTLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CEVALUEACCT_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CEVALUEACCT_GLDISTLINE foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CEVALUEUSER1_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CEVALUEUSER1_GLDISTLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CEVALUEUSER2_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CEVALUEUSER2_GLDISTLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CLOCFROM_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CLOCFROM_GLDISTLINE foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CLOCTO_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CLOCTO_GLDISTLINE foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CPROJECT_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CPROJECT_GLDISTLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "CSALESREGION_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint CSALESREGION_GLDISTLINE foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "GLDISTRIBUTION_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint GLDISTRIBUTION_GLDISTLINE foreign key (GL_DISTRIBUTION_ID) references GL_DISTRIBUTION(GL_DISTRIBUTION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_DISTRIBUTIONLINE drop constraint "MPRODUCT_GLDISTLINE"
;

alter table GL_DISTRIBUTIONLINE add constraint MPRODUCT_GLDISTLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_FUND drop constraint "CACCTSCHEMA_GLFUND"
;

alter table GL_FUND add constraint CACCTSCHEMA_GLFUND foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_FUNDRESTRICTION drop constraint "CELEMENTVALUE_GLFUNDRESTR"
;

alter table GL_FUNDRESTRICTION add constraint CELEMENTVALUE_GLFUNDRESTR foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_FUNDRESTRICTION drop constraint "GLFUND_GLFUNDRESTRICTION"
;

alter table GL_FUNDRESTRICTION add constraint GLFUND_GLFUNDRESTRICTION foreign key (GL_FUND_ID) references GL_FUND(GL_FUND_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "CCONVERSIONTYPE_GLJOURNAL"
;

alter table GL_JOURNAL add constraint CCONVERSIONTYPE_GLJOURNAL foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "CCURRENCY_GLJOURNAL"
;

alter table GL_JOURNAL add constraint CCURRENCY_GLJOURNAL foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "CDOCTYPE_GLJOURNAL"
;

alter table GL_JOURNAL add constraint CDOCTYPE_GLJOURNAL foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "C_ACCTSCHEMA_GL_JOURNAL"
;

alter table GL_JOURNAL add constraint C_ACCTSCHEMA_GL_JOURNAL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "C_PERIOD_JOURNAL"
;

alter table GL_JOURNAL add constraint C_PERIOD_JOURNAL foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "GLBUDGET_GLJOURNAL"
;

alter table GL_JOURNAL add constraint GLBUDGET_GLJOURNAL foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "GLCATEGORY_GLJOURNAL"
;

alter table GL_JOURNAL add constraint GLCATEGORY_GLJOURNAL foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "GLJOURNALBATCH_GLJOURNAL"
;

alter table GL_JOURNAL add constraint GLJOURNALBATCH_GLJOURNAL foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNAL drop constraint "REVERSAL_GLJOURNAL"
;

alter table GL_JOURNAL add constraint REVERSAL_GLJOURNAL foreign key (REVERSAL_ID) references GL_JOURNAL(GL_JOURNAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALBATCH drop constraint "CCURRENCY_GLJOURNALBATCH"
;

alter table GL_JOURNALBATCH add constraint CCURRENCY_GLJOURNALBATCH foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALBATCH drop constraint "CDOCTYPE_GLJOURNALBATCH"
;

alter table GL_JOURNALBATCH add constraint CDOCTYPE_GLJOURNALBATCH foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALBATCH drop constraint "C_PERIOD_JOURNALBATCH"
;

alter table GL_JOURNALBATCH add constraint C_PERIOD_JOURNALBATCH foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALBATCH drop constraint "GLCATEGORY_GLJOURNALBATCH"
;

alter table GL_JOURNALBATCH add constraint GLCATEGORY_GLJOURNALBATCH foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALBATCH drop constraint "REVERSAL_GLJOURNALBATCH"
;

alter table GL_JOURNALBATCH add constraint REVERSAL_GLJOURNALBATCH foreign key (REVERSAL_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATOR drop constraint "CACCTSCHEMA_QSSJOURNALGENERATO"
;

alter table GL_JOURNALGENERATOR add constraint CACCTSCHEMA_QSSJOURNALGENERATO foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATOR drop constraint "CDOCTYPE_QSSJOURNALGENERATOR"
;

alter table GL_JOURNALGENERATOR add constraint CDOCTYPE_QSSJOURNALGENERATOR foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATOR drop constraint "CELEMENTVALUEADJUSTCR_QSSJOURN"
;

alter table GL_JOURNALGENERATOR add constraint CELEMENTVALUEADJUSTCR_QSSJOURN foreign key (C_ELEMENTVALUEADJUSTCR_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATOR drop constraint "CELEMENTVALUEADJUSTDR_QSSJOURN"
;

alter table GL_JOURNALGENERATOR add constraint CELEMENTVALUEADJUSTDR_QSSJOURN foreign key (C_ELEMENTVALUEADJUSTDR_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATOR drop constraint "GLCATEGORY_QSSJOURNALGENERATOR"
;

alter table GL_JOURNALGENERATOR add constraint GLCATEGORY_QSSJOURNALGENERATOR foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORLINE drop constraint "CBPARTNER_QSSJOURNALGENERATORL"
;

alter table GL_JOURNALGENERATORLINE add constraint CBPARTNER_QSSJOURNALGENERATORL foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORLINE drop constraint "CELEMENTVALUECR_QSSJOURNALGENE"
;

alter table GL_JOURNALGENERATORLINE add constraint CELEMENTVALUECR_QSSJOURNALGENE foreign key (C_ELEMENTVALUECR_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORLINE drop constraint "CELEMENTVALUEDR_QSSJOURNALGENE"
;

alter table GL_JOURNALGENERATORLINE add constraint CELEMENTVALUEDR_QSSJOURNALGENE foreign key (C_ELEMENTVALUEDR_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORLINE drop constraint "QSSJOURNALGENERATOR_QSSJOURNAL"
;

alter table GL_JOURNALGENERATORLINE add constraint QSSJOURNALGENERATOR_QSSJOURNAL foreign key (GL_JOURNALGENERATOR_ID) references GL_JOURNALGENERATOR(GL_JOURNALGENERATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORSOURCE drop constraint "CELEMENTVALUE_QSSJOURNALGENERA"
;

alter table GL_JOURNALGENERATORSOURCE add constraint CELEMENTVALUE_QSSJOURNALGENERA foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORSOURCE drop constraint "GLCATEGORY_GLJOURNALGENERATORS"
;

alter table GL_JOURNALGENERATORSOURCE add constraint GLCATEGORY_GLJOURNALGENERATORS foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALGENERATORSOURCE drop constraint "QSSJOURNALGENERATORLINE_QSSJOU"
;

alter table GL_JOURNALGENERATORSOURCE add constraint QSSJOURNALGENERATORLINE_QSSJOU foreign key (GL_JOURNALGENERATORLINE_ID) references GL_JOURNALGENERATORLINE(GL_JOURNALGENERATORLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "AASSETGROUP_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint AASSETGROUP_GLJOURNALLINE foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "AASSET_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint AASSET_GLJOURNALLINE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "ACCOUNT_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint ACCOUNT_GLJOURNALLINE foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "ADCLIENT_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint ADCLIENT_GLJOURNALLINE foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "ADORGTRX_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint ADORGTRX_GLJOURNALLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "ADORG_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint ADORG_GLJOURNALLINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "ALIASVALIDCOMBINATION_GLJOURNA"
;

alter table GL_JOURNALLINE add constraint ALIASVALIDCOMBINATION_GLJOURNA foreign key (ALIAS_VALIDCOMBINATION_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CACTIVITY_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CACTIVITY_GLJOURNALLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CBPARTNER_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CBPARTNER_GLJOURNALLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CCAMPAIGN_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CCAMPAIGN_GLJOURNALLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CCONVERSIONTYPE_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CCONVERSIONTYPE_GLJOURNALLINE foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CCURRENCY_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CCURRENCY_GLJOURNALLINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CLOCFROM_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CLOCFROM_GLJOURNALLINE foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CLOCTO_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CLOCTO_GLJOURNALLINE foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CPROJECT_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CPROJECT_GLJOURNALLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CSALESREGION_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CSALESREGION_GLJOURNALLINE foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CSUBACCT_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CSUBACCT_GLJOURNALLINE foreign key (C_SUBACCT_ID) references C_SUBACCT(C_SUBACCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CUOM_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CUOM_GLJOURNALLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "CVC_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint CVC_GLJOURNALLINE foreign key (C_VALIDCOMBINATION_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "GLJOURNAL_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint GLJOURNAL_GLJOURNALLINE foreign key (GL_JOURNAL_ID) references GL_JOURNAL(GL_JOURNAL_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "MPRODUCT_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint MPRODUCT_GLJOURNALLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "USER1_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint USER1_GLJOURNALLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table GL_JOURNALLINE drop constraint "USER2_GLJOURNALLINE"
;

alter table GL_JOURNALLINE add constraint USER2_GLJOURNALLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "ADRULE_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint ADRULE_HRATTRIBUTE foreign key (AD_RULE_ID) references AD_RULE(AD_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "CBPARTNER_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint CBPARTNER_HRATTRIBUTE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HRATTRIBUTE_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HRATTRIBUTE_HRATTRIBUTE foreign key (HR_ATTRIBUTE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HRCONCEPT_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HRCONCEPT_HRATTRIBUTE foreign key (HR_CONCEPT_ID) references HR_CONCEPT(HR_CONCEPT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HRDEPARTMENT_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HRDEPARTMENT_HRATTRIBUTE foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HREMPLOYEE_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HREMPLOYEE_HRATTRIBUTE foreign key (HR_EMPLOYEE_ID) references HR_EMPLOYEE(HR_EMPLOYEE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HRJOB_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HRJOB_HRATTRIBUTE foreign key (HR_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_ATTRIBUTE drop constraint "HRPAYROLL_HRATTRIBUTE"
;

alter table HR_ATTRIBUTE add constraint HRPAYROLL_HRATTRIBUTE foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT drop constraint "ADREFERENCE_HRCONCEPT"
;

alter table HR_CONCEPT add constraint ADREFERENCE_HRCONCEPT foreign key (AD_REFERENCE_ID) references AD_REFERENCE(AD_REFERENCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT drop constraint "HRCONCEPTCATEGORY_HRCONCEPT"
;

alter table HR_CONCEPT add constraint HRCONCEPTCATEGORY_HRCONCEPT foreign key (HR_CONCEPT_CATEGORY_ID) references HR_CONCEPT_CATEGORY(HR_CONCEPT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT drop constraint "HRDEPARTMENT_HRCONCEPT"
;

alter table HR_CONCEPT add constraint HRDEPARTMENT_HRCONCEPT foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT drop constraint "HRJOB_HRCONCEPT"
;

alter table HR_CONCEPT add constraint HRJOB_HRCONCEPT foreign key (HR_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT drop constraint "HRPAYROLL_HRCONCEPT"
;

alter table HR_CONCEPT add constraint HRPAYROLL_HRCONCEPT foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "CACCTSCHEMA_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint CACCTSCHEMA_HRCONCEPTACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "CBPGROUP_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint CBPGROUP_HRCONCEPTACCT foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "HRCONCEPT_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint HRCONCEPT_HRCONCEPTACCT foreign key (HR_CONCEPT_ID) references HR_CONCEPT(HR_CONCEPT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "HREXPENSE_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint HREXPENSE_HRCONCEPTACCT foreign key (HR_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "HRREVENUE_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint HRREVENUE_HRCONCEPTACCT foreign key (HR_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "USER1_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint USER1_HRCONCEPTACCT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_ACCT drop constraint "USE_HRCONCEPTACCT"
;

alter table HR_CONCEPT_ACCT add constraint USE_HRCONCEPTACCT foreign key (USER2_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONCEPT_CATEGORY drop constraint "HRCONCEPT_HRCONCEPTCATEGORY"
;

alter table HR_CONCEPT_CATEGORY add constraint HRCONCEPT_HRCONCEPTCATEGORY foreign key (HR_CONCEPT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONTRACT drop constraint "CBPARTNER_HRCONTRACT"
;

alter table HR_CONTRACT add constraint CBPARTNER_HRCONTRACT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONTRACT drop constraint "CCAMPAIGN_HRCONTRACT"
;

alter table HR_CONTRACT add constraint CCAMPAIGN_HRCONTRACT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_CONTRACT drop constraint "CPROJECT_HRCONTRACT"
;

alter table HR_CONTRACT add constraint CPROJECT_HRCONTRACT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_DEPARTMENT drop constraint "CACTIVITY_HRDEPARTMENT"
;

alter table HR_DEPARTMENT add constraint CACTIVITY_HRDEPARTMENT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_EMPLOYEE drop constraint "CACTIVITY_HREMPLOYEE"
;

alter table HR_EMPLOYEE add constraint CACTIVITY_HREMPLOYEE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_EMPLOYEE drop constraint "CBPARTNER_HREMPLOYEE"
;

alter table HR_EMPLOYEE add constraint CBPARTNER_HREMPLOYEE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_EMPLOYEE drop constraint "HRDEPARTMENT_HREMPLOYEE"
;

alter table HR_EMPLOYEE add constraint HRDEPARTMENT_HREMPLOYEE foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_EMPLOYEE drop constraint "HRJOB_HREMPLOYEE"
;

alter table HR_EMPLOYEE add constraint HRJOB_HREMPLOYEE foreign key (HR_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_EMPLOYEE drop constraint "HRPAYROLL_HREMPLOYEE"
;

alter table HR_EMPLOYEE add constraint HRPAYROLL_HREMPLOYEE foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_JOB drop constraint "HRDEPARTMENT_HRJOB"
;

alter table HR_JOB add constraint HRDEPARTMENT_HRJOB foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_JOB drop constraint "NEXTJOB_HRJOB"
;

alter table HR_JOB add constraint NEXTJOB_HRJOB foreign key (NEXT_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_JOB drop constraint "SUPERVISOR_HRJOB"
;

alter table HR_JOB add constraint SUPERVISOR_HRJOB foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LIST drop constraint "HRDEPARTMENT_HRLIST"
;

alter table HR_LIST add constraint HRDEPARTMENT_HRLIST foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LIST drop constraint "HREMPLOYEE_HRLIST"
;

alter table HR_LIST add constraint HREMPLOYEE_HRLIST foreign key (HR_EMPLOYEE_ID) references HR_EMPLOYEE(HR_EMPLOYEE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LIST drop constraint "HRLISTTYPE_HRLIST"
;

alter table HR_LIST add constraint HRLISTTYPE_HRLIST foreign key (HR_LISTTYPE_ID) references HR_LISTTYPE(HR_LISTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LIST drop constraint "HRPAYROLL_HRLIST"
;

alter table HR_LIST add constraint HRPAYROLL_HRLIST foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LISTLINE drop constraint "HRLISTVERSION_HRLISTLINE"
;

alter table HR_LISTLINE add constraint HRLISTVERSION_HRLISTLINE foreign key (HR_LISTVERSION_ID) references HR_LISTVERSION(HR_LISTVERSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LISTVERSION drop constraint "HRLISTBASE_HRLISTVERSION"
;

alter table HR_LISTVERSION add constraint HRLISTBASE_HRLISTVERSION foreign key (HR_LISTBASE_ID) references HR_LIST(HR_LIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_LISTVERSION drop constraint "HRLIST_HRLISTVERSION"
;

alter table HR_LISTVERSION add constraint HRLIST_HRLISTVERSION foreign key (HR_LIST_ID) references HR_LIST(HR_LIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "ADORGTRX_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint ADORGTRX_HRMOVEMENT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "ADRULE_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint ADRULE_HRMOVEMENT foreign key (AD_RULE_ID) references AD_RULE(AD_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CACTIVITY_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CACTIVITY_HRMOVEMENT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CBPARTNER_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CBPARTNER_HRMOVEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CBPBANKACCOUNT_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CBPBANKACCOUNT_HRMOVEMENT foreign key (C_BP_BANKACCOUNT_ID) references C_BP_BANKACCOUNT(C_BP_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CBPGROUP_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CBPGROUP_HRMOVEMENT foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CCAMPAIGN_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CCAMPAIGN_HRMOVEMENT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CPROJECTPHASE_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CPROJECTPHASE_HRMOVEMENT foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CPROJECTTASK_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CPROJECTTASK_HRMOVEMENT foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "CPROJECT_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint CPROJECT_HRMOVEMENT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "HRCONCEPTCATEGORY_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint HRCONCEPTCATEGORY_HRMOVEMENT foreign key (HR_CONCEPT_CATEGORY_ID) references HR_CONCEPT_CATEGORY(HR_CONCEPT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "HRCONCEPT_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint HRCONCEPT_HRMOVEMENT foreign key (HR_CONCEPT_ID) references HR_CONCEPT(HR_CONCEPT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "HRDEPARTMENT_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint HRDEPARTMENT_HRMOVEMENT foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "HRJOB_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint HRJOB_HRMOVEMENT foreign key (HR_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "HRPROCESS_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint HRPROCESS_HRMOVEMENT foreign key (HR_PROCESS_ID) references HR_PROCESS(HR_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "PPCOSTCOLLECTOR_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint PPCOSTCOLLECTOR_HRMOVEMENT foreign key (PP_COST_COLLECTOR_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "USER1_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint USER1_HRMOVEMENT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_MOVEMENT drop constraint "USER2_HRMOVEMENT"
;

alter table HR_MOVEMENT add constraint USER2_HRMOVEMENT foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLL drop constraint "ADPRINTFORMAT_HRPAYROLL"
;

alter table HR_PAYROLL add constraint ADPRINTFORMAT_HRPAYROLL foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLL drop constraint "CCHARGE_HRPAYROLL"
;

alter table HR_PAYROLL add constraint CCHARGE_HRPAYROLL foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLL drop constraint "HRCONTRACT_HRPAYROLL"
;

alter table HR_PAYROLL add constraint HRCONTRACT_HRPAYROLL foreign key (HR_CONTRACT_ID) references HR_CONTRACT(HR_CONTRACT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLLCONCEPT drop constraint "ADRULE_HRPAYROLLCONCEPT"
;

alter table HR_PAYROLLCONCEPT add constraint ADRULE_HRPAYROLLCONCEPT foreign key (AD_RULE_ID) references AD_RULE(AD_RULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLLCONCEPT drop constraint "HRCONCEPT_HRPAYROLLCONCEPT"
;

alter table HR_PAYROLLCONCEPT add constraint HRCONCEPT_HRPAYROLLCONCEPT foreign key (HR_CONCEPT_ID) references HR_CONCEPT(HR_CONCEPT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PAYROLLCONCEPT drop constraint "HRPAYROLL_HRPAYROLLCONCEPT"
;

alter table HR_PAYROLLCONCEPT add constraint HRPAYROLL_HRPAYROLLCONCEPT foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PERIOD drop constraint "CPERIOD_HRPERIOD"
;

alter table HR_PERIOD add constraint CPERIOD_HRPERIOD foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PERIOD drop constraint "CYEAR_HRPERIOD"
;

alter table HR_PERIOD add constraint CYEAR_HRPERIOD foreign key (C_YEAR_ID) references C_YEAR(C_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PERIOD drop constraint "HRPAYROLL_HRPERIOD"
;

alter table HR_PERIOD add constraint HRPAYROLL_HRPERIOD foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PERIOD drop constraint "HRYEAR_HRPERIOD"
;

alter table HR_PERIOD add constraint HRYEAR_HRPERIOD foreign key (HR_YEAR_ID) references HR_YEAR(HR_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "ADPRINTFORMAT_HRPROCESS"
;

alter table HR_PROCESS add constraint ADPRINTFORMAT_HRPROCESS foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "ADWORKFLOW_HRPROCESS"
;

alter table HR_PROCESS add constraint ADWORKFLOW_HRPROCESS foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "CBPARTNER_HRPROCESS"
;

alter table HR_PROCESS add constraint CBPARTNER_HRPROCESS foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "CCHARGE_HRPROCESS"
;

alter table HR_PROCESS add constraint CCHARGE_HRPROCESS foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "CDOCTYPETARGET_HRPROCESS"
;

alter table HR_PROCESS add constraint CDOCTYPETARGET_HRPROCESS foreign key (C_DOCTYPETARGET_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "CDOCTYPE_HRPROCESS"
;

alter table HR_PROCESS add constraint CDOCTYPE_HRPROCESS foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "CPAYSELECTION_HRPROCESS"
;

alter table HR_PROCESS add constraint CPAYSELECTION_HRPROCESS foreign key (C_PAYSELECTION_ID) references C_PAYSELECTION(C_PAYSELECTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "HRDEPARTMENT_HRPROCESS"
;

alter table HR_PROCESS add constraint HRDEPARTMENT_HRPROCESS foreign key (HR_DEPARTMENT_ID) references HR_DEPARTMENT(HR_DEPARTMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "HREMPLOYEE_HRPROCESS"
;

alter table HR_PROCESS add constraint HREMPLOYEE_HRPROCESS foreign key (HR_EMPLOYEE_ID) references HR_EMPLOYEE(HR_EMPLOYEE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "HRJOB_HRPROCESS"
;

alter table HR_PROCESS add constraint HRJOB_HRPROCESS foreign key (HR_JOB_ID) references HR_JOB(HR_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "HRPAYROLL_HRPROCESS"
;

alter table HR_PROCESS add constraint HRPAYROLL_HRPROCESS foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "HRPERIOD_HRPROCESS"
;

alter table HR_PROCESS add constraint HRPERIOD_HRPROCESS foreign key (HR_PERIOD_ID) references HR_PERIOD(HR_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_PROCESS drop constraint "REVERSAL_HRPROCESS"
;

alter table HR_PROCESS add constraint REVERSAL_HRPROCESS foreign key (REVERSAL_ID) references HR_PROCESS(HR_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_YEAR drop constraint "CYEAR_HRYEAR"
;

alter table HR_YEAR add constraint CYEAR_HRYEAR foreign key (C_YEAR_ID) references C_YEAR(C_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table HR_YEAR drop constraint "HRPAYROLL_HRYEAR"
;

alter table HR_YEAR add constraint HRPAYROLL_HRYEAR foreign key (HR_PAYROLL_ID) references HR_PAYROLL(HR_PAYROLL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table IMP_PROCESSOR drop constraint "IMPPROCESSORTYPE_IMPPROCESSOR"
;

alter table IMP_PROCESSOR add constraint IMPPROCESSORTYPE_IMPPROCESSOR foreign key (IMP_PROCESSOR_TYPE_ID) references IMP_PROCESSOR_TYPE(IMP_PROCESSOR_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table IMP_PROCESSORLOG drop constraint "IMPPROCESSOR_IMPPROCESSORLOG"
;

alter table IMP_PROCESSORLOG add constraint IMPPROCESSOR_IMPPROCESSORLOG foreign key (IMP_PROCESSOR_ID) references IMP_PROCESSOR(IMP_PROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table IMP_PROCESSORPARAMETER drop constraint "IMPPROCESSOR_IMPPROCESSORPARAM"
;

alter table IMP_PROCESSORPARAMETER add constraint IMPPROCESSOR_IMPPROCESSORPARAM foreign key (IMP_PROCESSOR_ID) references IMP_PROCESSOR(IMP_PROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "AACCUMDEPRECIATION_IASSET"
;

alter table I_ASSET add constraint AACCUMDEPRECIATION_IASSET foreign key (A_ACCUMDEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "AASSETGROUP_IASSET"
;

alter table I_ASSET add constraint AASSETGROUP_IASSET foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "AASSET_IASSET"
;

alter table I_ASSET add constraint AASSET_IASSET foreign key (A_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "ADEPRECIATIONTABLEHEADER_IASSE"
;

alter table I_ASSET add constraint ADEPRECIATIONTABLEHEADER_IASSE foreign key (A_DEPRECIATION_TABLE_HEADER_ID) references A_DEPRECIATION_TABLE_HEADER(A_DEPRECIATION_TABLE_HEADER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "ADEPRECIATION_IASSET"
;

alter table I_ASSET add constraint ADEPRECIATION_IASSET foreign key (A_DEPRECIATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "CACCTSCHEMA_IASSET"
;

alter table I_ASSET add constraint CACCTSCHEMA_IASSET foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "CBPARTNERLOCATION_IASSET"
;

alter table I_ASSET add constraint CBPARTNERLOCATION_IASSET foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "CBPARTNER_IASSET"
;

alter table I_ASSET add constraint CBPARTNER_IASSET foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "CLOCATION_IASSET"
;

alter table I_ASSET add constraint CLOCATION_IASSET foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "MATTRIBUTESETINSTANCE_IASSET"
;

alter table I_ASSET add constraint MATTRIBUTESETINSTANCE_IASSET foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "MLOCATOR_IASSET"
;

alter table I_ASSET add constraint MLOCATOR_IASSET foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ASSET drop constraint "MPRODUCT_IASSET"
;

alter table I_ASSET add constraint MPRODUCT_IASSET foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CBANKACCOUNT_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CBANKACCOUNT_IBANKSTATEMENT foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CBANKSTATEMENT_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CBANKSTATEMENT_IBANKSTATEMENT foreign key (C_BANKSTATEMENT_ID) references C_BANKSTATEMENT(C_BANKSTATEMENT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CBANKSTMTLINE_IBANKSTMT"
;

alter table I_BANKSTATEMENT add constraint CBANKSTMTLINE_IBANKSTMT foreign key (C_BANKSTATEMENTLINE_ID) references C_BANKSTATEMENTLINE(C_BANKSTATEMENTLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CBPARTNER_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CBPARTNER_IBANKSTATEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CCHARGE_IBANKSTMT"
;

alter table I_BANKSTATEMENT add constraint CCHARGE_IBANKSTMT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CCURRENCY_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CCURRENCY_IBANKSTATEMENT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CINVOICE_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CINVOICE_IBANKSTATEMENT foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BANKSTATEMENT drop constraint "CPAYMENT_IBANKSTATEMENT"
;

alter table I_BANKSTATEMENT add constraint CPAYMENT_IBANKSTATEMENT foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "ADUSER_IBPARTNER"
;

alter table I_BPARTNER add constraint ADUSER_IBPARTNER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CBPARTNERLOCATION_IBPARTNER"
;

alter table I_BPARTNER add constraint CBPARTNERLOCATION_IBPARTNER foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CBPARTNER_IBPARTNER"
;

alter table I_BPARTNER add constraint CBPARTNER_IBPARTNER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CBPGROUP_IBPARTNER"
;

alter table I_BPARTNER add constraint CBPGROUP_IBPARTNER foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CCOUNTRY_IPARTNER"
;

alter table I_BPARTNER add constraint CCOUNTRY_IPARTNER foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CGREETING_IBPARTNER"
;

alter table I_BPARTNER add constraint CGREETING_IBPARTNER foreign key (C_GREETING_ID) references C_GREETING(C_GREETING_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "CREGION_IBPARTNER"
;

alter table I_BPARTNER add constraint CREGION_IBPARTNER foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_BPARTNER drop constraint "RINTERESTAREA_IBPARTNER"
;

alter table I_BPARTNER add constraint RINTERESTAREA_IBPARTNER foreign key (R_INTERESTAREA_ID) references R_INTERESTAREA(R_INTERESTAREA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_CONVERSION_RATE drop constraint "CCONVERSIONRATE_ICONVRATE"
;

alter table I_CONVERSION_RATE add constraint CCONVERSIONRATE_ICONVRATE foreign key (C_CONVERSION_RATE_ID) references C_CONVERSION_RATE(C_CONVERSION_RATE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_CONVERSION_RATE drop constraint "CCONVTYPE_ICONVRATE"
;

alter table I_CONVERSION_RATE add constraint CCONVTYPE_ICONVRATE foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_CONVERSION_RATE drop constraint "CCURRENCY_ICONVRATE"
;

alter table I_CONVERSION_RATE add constraint CCURRENCY_ICONVRATE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_CONVERSION_RATE drop constraint "CCURRENCY_ICONVRATETO"
;

alter table I_CONVERSION_RATE add constraint CCURRENCY_ICONVRATETO foreign key (C_CURRENCY_ID_TO) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ELEMENTVALUE drop constraint "ADCOLUMN_IELEMENTVALUE"
;

alter table I_ELEMENTVALUE add constraint ADCOLUMN_IELEMENTVALUE foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ELEMENTVALUE drop constraint "CELEMENTVALUE_IELEMENTVALUE"
;

alter table I_ELEMENTVALUE add constraint CELEMENTVALUE_IELEMENTVALUE foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ELEMENTVALUE drop constraint "CELEMENT_IELEMENTVALUE"
;

alter table I_ELEMENTVALUE add constraint CELEMENT_IELEMENTVALUE foreign key (C_ELEMENT_ID) references C_ELEMENT(C_ELEMENT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ELEMENTVALUE drop constraint "CEVALUEPARENT_IELEMENTVALUE"
;

alter table I_ELEMENTVALUE add constraint CEVALUEPARENT_IELEMENTVALUE foreign key (PARENTELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "ACCOUNT_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint ACCOUNT_IFAJOURNAL foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "ADORGDOC_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint ADORGDOC_IFAJOURNAL foreign key (AD_ORGDOC_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "ADORGTRX_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint ADORGTRX_IFAJOURNAL foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CACCTSCHEMA_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CACCTSCHEMA_IFAJOURNAL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CACTIVITY_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CACTIVITY_IFAJOURNAL foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CBPARTNER_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CBPARTNER_IFAJOURNAL foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CCAMPAIGN_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CCAMPAIGN_IFAJOURNAL foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CCURRENCY_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CCURRENCY_IFAJOURNAL foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CDOCTYPE_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CDOCTYPE_IFAJOURNAL foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CPERIOD_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CPERIOD_IFAJOURNAL foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CPROJECT_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CPROJECT_IFAJOURNAL foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CSALESREGION_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CSALESREGION_IFAJOURNAL foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CUOM_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CUOM_IFAJOURNAL foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "CVALIDCOMBINATION_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint CVALIDCOMBINATION_IFAJOURNAL foreign key (C_VALIDCOMBINATION_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "GLBUDGET_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint GLBUDGET_IFAJOURNAL foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "GLCATEGORY_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint GLCATEGORY_IFAJOURNAL foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "GLJOURNALBATCH_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint GLJOURNALBATCH_IFAJOURNAL foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "GLJOURNALLINE_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint GLJOURNALLINE_IFAJOURNAL foreign key (GL_JOURNALLINE_ID) references GL_JOURNALLINE(GL_JOURNALLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "GLJOURNAL_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint GLJOURNAL_IFAJOURNAL foreign key (GL_JOURNAL_ID) references GL_JOURNAL(GL_JOURNAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "MPRODUCT_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint MPRODUCT_IFAJOURNAL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "USER1_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint USER1_IFAJOURNAL foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FAJOURNAL drop constraint "USER2_IFAJOURNAL"
;

alter table I_FAJOURNAL add constraint USER2_IFAJOURNAL foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "AASSETCLASS_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint AASSETCLASS_IFIXEDASSET foreign key (A_ASSET_CLASS_ID) references A_ASSET_CLASS(A_ASSET_CLASS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "AASSETGROUP_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint AASSETGROUP_IFIXEDASSET foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "AASSETTYPE_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint AASSETTYPE_IFIXEDASSET foreign key (A_ASSET_TYPE_ID) references A_ASSET_TYPE(A_ASSET_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "AASSET_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint AASSET_IFIXEDASSET foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "CBPARTNERSR_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint CBPARTNERSR_IFIXEDASSET foreign key (C_BPARTNERSR_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "CCITY_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint CCITY_IFIXEDASSET foreign key (C_CITY_ID) references C_CITY(C_CITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "CUOM_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint CUOM_IFIXEDASSET foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "MLOCATOR_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint MLOCATOR_IFIXEDASSET foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_FIXEDASSET drop constraint "MPRODUCT_IFIXEDASSET"
;

alter table I_FIXEDASSET add constraint MPRODUCT_IFIXEDASSET foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "ADORGDOC_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint ADORGDOC_IGLJOURNAL foreign key (AD_ORGDOC_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "ADORGTRX_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint ADORGTRX_IGLJOURNAL foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "ADORG_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint ADORG_IGLJOURNAL foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CACCTSCHEMA_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CACCTSCHEMA_IGLJOURNAL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CACTIVITY_GLJOURNAL"
;

alter table I_GLJOURNAL add constraint CACTIVITY_GLJOURNAL foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CBPARTNER_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CBPARTNER_IGLJOURNAL foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CCAMPAIGN_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CCAMPAIGN_IGLJOURNAL foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CCONVERSIONTYPE_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CCONVERSIONTYPE_IGLJOURNAL foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CCURRENCY_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CCURRENCY_IGLJOURNAL foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CDOCTYPE_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CDOCTYPE_IGLJOURNAL foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CELVALUEACCOUNT_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CELVALUEACCOUNT_IGLJOURNAL foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CELVALUEUSER2_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CELVALUEUSER2_IGLJOURNAL foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CEVALUEUSER1_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CEVALUEUSER1_IGLJOURNAL foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CLOCFROM_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CLOCFROM_IGLJOURNAL foreign key (C_LOCFROM_ID) references C_LOCATION(C_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CLOCTO_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CLOCTO_IGLJOURNAL foreign key (C_LOCTO_ID) references C_LOCATION(C_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CPERIOD_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CPERIOD_IGLJOURNAL foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CPROJECT_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CPROJECT_IGLJOURNAL foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CSALESREGION_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CSALESREGION_IGLJOURNAL foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CUOM_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CUOM_IGLJOURNAL foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "CVALIDCOMBINATION_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint CVALIDCOMBINATION_IGLJOURNAL foreign key (C_VALIDCOMBINATION_ID) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "GLBUDGET_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint GLBUDGET_IGLJOURNAL foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "GLCATEGORY_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint GLCATEGORY_IGLJOURNAL foreign key (GL_CATEGORY_ID) references GL_CATEGORY(GL_CATEGORY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "GLJOURBELLINE_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint GLJOURBELLINE_IGLJOURNAL foreign key (GL_JOURNALLINE_ID) references GL_JOURNALLINE(GL_JOURNALLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "GLJOURNALBATCH_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint GLJOURNALBATCH_IGLJOURNAL foreign key (GL_JOURNALBATCH_ID) references GL_JOURNALBATCH(GL_JOURNALBATCH_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "GLJOURNAL_IGLJOURNAL"
;

alter table I_GLJOURNAL add constraint GLJOURNAL_IGLJOURNAL foreign key (GL_JOURNAL_ID) references GL_JOURNAL(GL_JOURNAL_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_GLJOURNAL drop constraint "MPRODUCT_OGLJOURNAL"
;

alter table I_GLJOURNAL add constraint MPRODUCT_OGLJOURNAL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_HR_MOVEMENT drop constraint "CBPARTNER_IHRMOVEMENT"
;

alter table I_HR_MOVEMENT add constraint CBPARTNER_IHRMOVEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_HR_MOVEMENT drop constraint "HRCONCEPT_IHRMOVEMENT"
;

alter table I_HR_MOVEMENT add constraint HRCONCEPT_IHRMOVEMENT foreign key (HR_CONCEPT_ID) references HR_CONCEPT(HR_CONCEPT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_HR_MOVEMENT drop constraint "HRMOVEMENT_IHRMOVEMENT"
;

alter table I_HR_MOVEMENT add constraint HRMOVEMENT_IHRMOVEMENT foreign key (HR_MOVEMENT_ID) references HR_MOVEMENT(HR_MOVEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_HR_MOVEMENT drop constraint "HRPROCESS_IHRMOVEMENT"
;

alter table I_HR_MOVEMENT add constraint HRPROCESS_IHRMOVEMENT foreign key (HR_PROCESS_ID) references HR_PROCESS(HR_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INOUTLINECONFIRM drop constraint "MINOUTLINECONFIRM_IMPORT"
;

alter table I_INOUTLINECONFIRM add constraint MINOUTLINECONFIRM_IMPORT foreign key (M_INOUTLINECONFIRM_ID) references M_INOUTLINECONFIRM(M_INOUTLINECONFIRM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "CCHARGE_IINVENTORY"
;

alter table I_INVENTORY add constraint CCHARGE_IINVENTORY foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "CDOCTYPE_IINVENTORY"
;

alter table I_INVENTORY add constraint CDOCTYPE_IINVENTORY foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "MINVENTORYLINE_IINVENTORY"
;

alter table I_INVENTORY add constraint MINVENTORYLINE_IINVENTORY foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "MINVENTORY_IINVENTORY"
;

alter table I_INVENTORY add constraint MINVENTORY_IINVENTORY foreign key (M_INVENTORY_ID) references M_INVENTORY(M_INVENTORY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "MLOCATOR_IINVENTORY"
;

alter table I_INVENTORY add constraint MLOCATOR_IINVENTORY foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "MPRODUCT_IINVENTORY"
;

alter table I_INVENTORY add constraint MPRODUCT_IINVENTORY foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVENTORY drop constraint "MWAREHOUSE_IINVENTORY"
;

alter table I_INVENTORY add constraint MWAREHOUSE_IINVENTORY foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "ADORGTRX_IINVOICE"
;

alter table I_INVOICE add constraint ADORGTRX_IINVOICE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "ADORG_IINVOICE"
;

alter table I_INVOICE add constraint ADORG_IINVOICE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "ADUSERSALESREP_IINVOICE"
;

alter table I_INVOICE add constraint ADUSERSALESREP_IINVOICE foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "ADUSER_IINVOICE"
;

alter table I_INVOICE add constraint ADUSER_IINVOICE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CACTIVITY_IINVOICE"
;

alter table I_INVOICE add constraint CACTIVITY_IINVOICE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CBPARTNER_IINVOICE"
;

alter table I_INVOICE add constraint CBPARTNER_IINVOICE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CBPLOCATION_IINVOICE"
;

alter table I_INVOICE add constraint CBPLOCATION_IINVOICE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CCAMPAIGN_IINVOICE"
;

alter table I_INVOICE add constraint CCAMPAIGN_IINVOICE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CCHARGE_IINVOICE"
;

alter table I_INVOICE add constraint CCHARGE_IINVOICE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CCOUNTRY_IINVOICE"
;

alter table I_INVOICE add constraint CCOUNTRY_IINVOICE foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CCURRENCY_IINVOICE"
;

alter table I_INVOICE add constraint CCURRENCY_IINVOICE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CDOCTYPE_IINVOICE"
;

alter table I_INVOICE add constraint CDOCTYPE_IINVOICE foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CINVLICELINE_IINVOICE"
;

alter table I_INVOICE add constraint CINVLICELINE_IINVOICE foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CINVOICE_IINVOICE"
;

alter table I_INVOICE add constraint CINVOICE_IINVOICE foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CLOCATION_IINVOICE"
;

alter table I_INVOICE add constraint CLOCATION_IINVOICE foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CPAYMENTTERM_IINVOICE"
;

alter table I_INVOICE add constraint CPAYMENTTERM_IINVOICE foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CPROJECT_IINVOICE"
;

alter table I_INVOICE add constraint CPROJECT_IINVOICE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CREGION_IINVOICE"
;

alter table I_INVOICE add constraint CREGION_IINVOICE foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "CTAX_IINVOICE"
;

alter table I_INVOICE add constraint CTAX_IINVOICE foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "MPRICELIST_IINVOICE"
;

alter table I_INVOICE add constraint MPRICELIST_IINVOICE foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_INVOICE drop constraint "NPRODUCT_IINVOICE"
;

alter table I_INVOICE add constraint NPRODUCT_IINVOICE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "ADORGTRX_IMOVEMENT"
;

alter table I_MOVEMENT add constraint ADORGTRX_IMOVEMENT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "ADUSER_IMOVEMENT"
;

alter table I_MOVEMENT add constraint ADUSER_IMOVEMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "CBPARTNER_IMOVEMENT"
;

alter table I_MOVEMENT add constraint CBPARTNER_IMOVEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "CCAMPAIGN_IMOVEMENT"
;

alter table I_MOVEMENT add constraint CCAMPAIGN_IMOVEMENT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "CDOCTYPE_IMOVEMENT"
;

alter table I_MOVEMENT add constraint CDOCTYPE_IMOVEMENT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "CPROJECT_IMOVEMENT"
;

alter table I_MOVEMENT add constraint CPROJECT_IMOVEMENT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MLOCATORTO_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MLOCATORTO_IMOVEMENT foreign key (M_LOCATORTO_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MLOCATOR_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MLOCATOR_IMOVEMENT foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MMOVEMENTLINE_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MMOVEMENTLINE_IMOVEMENT foreign key (M_MOVEMENTLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MMOVEMENT_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MMOVEMENT_IMOVEMENT foreign key (M_MOVEMENT_ID) references M_MOVEMENT(M_MOVEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MPRODUCT_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MPRODUCT_IMOVEMENT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_MOVEMENT drop constraint "MSHIPPER_IMOVEMENT"
;

alter table I_MOVEMENT add constraint MSHIPPER_IMOVEMENT foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "ADORGTRX_IORDER"
;

alter table I_ORDER add constraint ADORGTRX_IORDER foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "ADORG_IORDER"
;

alter table I_ORDER add constraint ADORG_IORDER foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "ADUSERSALESREP_IORDER"
;

alter table I_ORDER add constraint ADUSERSALESREP_IORDER foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "ADUSER_IORDER"
;

alter table I_ORDER add constraint ADUSER_IORDER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CACTIVITY_IORDER"
;

alter table I_ORDER add constraint CACTIVITY_IORDER foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CBOLOCATION_IORDER"
;

alter table I_ORDER add constraint CBOLOCATION_IORDER foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CBPARTNERLOCBILLTO_IORDER"
;

alter table I_ORDER add constraint CBPARTNERLOCBILLTO_IORDER foreign key (BILLTO_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CBPARTNER_IORDER"
;

alter table I_ORDER add constraint CBPARTNER_IORDER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CCAMPAIGN_IORDER"
;

alter table I_ORDER add constraint CCAMPAIGN_IORDER foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CCHARGE_IORDER"
;

alter table I_ORDER add constraint CCHARGE_IORDER foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CCOUNTRY_IORDER"
;

alter table I_ORDER add constraint CCOUNTRY_IORDER foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CCURRENCY_IORDER"
;

alter table I_ORDER add constraint CCURRENCY_IORDER foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CDOCTYPE_IORDER"
;

alter table I_ORDER add constraint CDOCTYPE_IORDER foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CLOCATION_IORDER"
;

alter table I_ORDER add constraint CLOCATION_IORDER foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CORDERLINE_IORDER"
;

alter table I_ORDER add constraint CORDERLINE_IORDER foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CORDERSOURCE_IORDER"
;

alter table I_ORDER add constraint CORDERSOURCE_IORDER foreign key (C_ORDERSOURCE_ID) references C_ORDERSOURCE(C_ORDERSOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CORDER_IORDER"
;

alter table I_ORDER add constraint CORDER_IORDER foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CPAYMENTTERM_IORDER"
;

alter table I_ORDER add constraint CPAYMENTTERM_IORDER foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CPROJECT_IORDER"
;

alter table I_ORDER add constraint CPROJECT_IORDER foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CREGION_IORDER"
;

alter table I_ORDER add constraint CREGION_IORDER foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CTAX_IORDER"
;

alter table I_ORDER add constraint CTAX_IORDER foreign key (C_TAX_ID) references C_TAX(C_TAX_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "CUOM_IORDER"
;

alter table I_ORDER add constraint CUOM_IORDER foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "MPRICELIST_IORDER"
;

alter table I_ORDER add constraint MPRICELIST_IORDER foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "MPRODUCT_IORDER"
;

alter table I_ORDER add constraint MPRODUCT_IORDER foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "MSHIPPER_IORDER"
;

alter table I_ORDER add constraint MSHIPPER_IORDER foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_ORDER drop constraint "MWAREHOUSE_IORDER"
;

alter table I_ORDER add constraint MWAREHOUSE_IORDER foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CBANKACCOUNT_IPAYMENT"
;

alter table I_PAYMENT add constraint CBANKACCOUNT_IPAYMENT foreign key (C_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CBPARTNER_IPAYMENT"
;

alter table I_PAYMENT add constraint CBPARTNER_IPAYMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CCHARGE_IPAYMENT"
;

alter table I_PAYMENT add constraint CCHARGE_IPAYMENT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CCURRENCY_IPAYMENT"
;

alter table I_PAYMENT add constraint CCURRENCY_IPAYMENT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CDOCTYPE_IPAYMENT"
;

alter table I_PAYMENT add constraint CDOCTYPE_IPAYMENT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CINVOICE_IPAYMENT"
;

alter table I_PAYMENT add constraint CINVOICE_IPAYMENT foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PAYMENT drop constraint "CPAYMENT_IPAYMENT"
;

alter table I_PAYMENT add constraint CPAYMENT_IPAYMENT foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "CBPARTNER_IPRICELIST"
;

alter table I_PRICELIST add constraint CBPARTNER_IPRICELIST foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "CCURRENCY_IPRICELIST"
;

alter table I_PRICELIST add constraint CCURRENCY_IPRICELIST foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "CUOM_IPRICELIST"
;

alter table I_PRICELIST add constraint CUOM_IPRICELIST foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "MPRICELISTVERSION_IPRICELIST"
;

alter table I_PRICELIST add constraint MPRICELISTVERSION_IPRICELIST foreign key (M_PRICELIST_VERSION_ID) references M_PRICELIST_VERSION(M_PRICELIST_VERSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "MPRICELIST_IPRICELIST"
;

alter table I_PRICELIST add constraint MPRICELIST_IPRICELIST foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRICELIST drop constraint "MPRODUCT_IPRICELIST"
;

alter table I_PRICELIST add constraint MPRODUCT_IPRICELIST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCT drop constraint "CBPARTNER_IPRODUCT"
;

alter table I_PRODUCT add constraint CBPARTNER_IPRODUCT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCT drop constraint "CCURRENCY_IPRODUCT"
;

alter table I_PRODUCT add constraint CCURRENCY_IPRODUCT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCT drop constraint "CUOM_IPRODUCT"
;

alter table I_PRODUCT add constraint CUOM_IPRODUCT foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCT drop constraint "MPRODUCTCATEGORY_IPRODUCT"
;

alter table I_PRODUCT add constraint MPRODUCTCATEGORY_IPRODUCT foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCT drop constraint "MPRODUCT_IPRODUCT"
;

alter table I_PRODUCT add constraint MPRODUCT_IPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "CBPARTNER_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint CBPARTNER_IPRODUCTPLANNING foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "MFORECASTLINE_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint MFORECASTLINE_IPRODUCTPLANNING foreign key (M_FORECASTLINE_ID) references M_FORECASTLINE(M_FORECASTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "MFORECAST_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint MFORECAST_IPRODUCTPLANNING foreign key (M_FORECAST_ID) references M_FORECAST(M_FORECAST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "MPRODUCT_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint MPRODUCT_IPRODUCTPLANNING foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "MWAREHOUSE_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint MWAREHOUSE_IPRODUCTPLANNING foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "PLANNER_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint PLANNER_IPRODUCTPLANNING foreign key (PLANNER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "PPPRODUCTBOM_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint PPPRODUCTBOM_IPRODUCTPLANNING foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "PPPRODUCTPLANNING_IPRODUCTPLAN"
;

alter table I_PRODUCTPLANNING add constraint PPPRODUCTPLANNING_IPRODUCTPLAN foreign key (PP_PRODUCT_PLANNING_ID) references PP_PRODUCT_PLANNING(PP_PRODUCT_PLANNING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_PRODUCTPLANNING drop constraint "SRESOURCE_IPRODUCTPLANNING"
;

alter table I_PRODUCTPLANNING add constraint SRESOURCE_IPRODUCTPLANNING foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_REPORTLINE drop constraint "CELEMENTVALUE_IREPORTLINE"
;

alter table I_REPORTLINE add constraint CELEMENTVALUE_IREPORTLINE foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_REPORTLINE drop constraint "PAREPORTLINESET_IREPORTLINE"
;

alter table I_REPORTLINE add constraint PAREPORTLINESET_IREPORTLINE foreign key (PA_REPORTLINESET_ID) references PA_REPORTLINESET(PA_REPORTLINESET_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_REPORTLINE drop constraint "PAREPORTLINE_IREPORTLINE"
;

alter table I_REPORTLINE add constraint PAREPORTLINE_IREPORTLINE foreign key (PA_REPORTLINE_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table I_REPORTLINE drop constraint "PAREPORTSOURCE_IREPORTLINE"
;

alter table I_REPORTLINE add constraint PAREPORTSOURCE_IREPORTLINE foreign key (PA_REPORTSOURCE_ID) references PA_REPORTSOURCE(PA_REPORTSOURCE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_CATEGORYVALUE drop constraint "KCATEGORY_KCATEGORYVALUE"
;

alter table K_CATEGORYVALUE add constraint KCATEGORY_KCATEGORYVALUE foreign key (K_CATEGORY_ID) references K_CATEGORY(K_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_COMMENT drop constraint "ADSESSION_KCOMMENT"
;

alter table K_COMMENT add constraint ADSESSION_KCOMMENT foreign key (AD_SESSION_ID) references AD_SESSION(AD_SESSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_COMMENT drop constraint "KENTRY_KCOMMENT"
;

alter table K_COMMENT add constraint KENTRY_KCOMMENT foreign key (K_ENTRY_ID) references K_ENTRY(K_ENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRY drop constraint "ADSESSION_KENTRY"
;

alter table K_ENTRY add constraint ADSESSION_KENTRY foreign key (AD_SESSION_ID) references AD_SESSION(AD_SESSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRY drop constraint "KSOURCE_KENTRY"
;

alter table K_ENTRY add constraint KSOURCE_KENTRY foreign key (K_SOURCE_ID) references K_SOURCE(K_SOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRY drop constraint "KTOPIC_KENTRY"
;

alter table K_ENTRY add constraint KTOPIC_KENTRY foreign key (K_TOPIC_ID) references K_TOPIC(K_TOPIC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRYCATEGORY drop constraint "KCATEGORYVALUE_KENTRYCATEGORY"
;

alter table K_ENTRYCATEGORY add constraint KCATEGORYVALUE_KENTRYCATEGORY foreign key (K_CATEGORYVALUE_ID) references K_CATEGORYVALUE(K_CATEGORYVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRYCATEGORY drop constraint "KCATEGORY_KENTRYCATEGORY"
;

alter table K_ENTRYCATEGORY add constraint KCATEGORY_KENTRYCATEGORY foreign key (K_CATEGORY_ID) references K_CATEGORY(K_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRYCATEGORY drop constraint "KENTRY_KENTRYCATALOG"
;

alter table K_ENTRYCATEGORY add constraint KENTRY_KENTRYCATALOG foreign key (K_ENTRY_ID) references K_ENTRY(K_ENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRYRELATED drop constraint "KENTRY_KENTRYRELATED"
;

alter table K_ENTRYRELATED add constraint KENTRY_KENTRYRELATED foreign key (K_ENTRY_ID) references K_ENTRY(K_ENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_ENTRYRELATED drop constraint "KENTRY_KENTRYRELATEDID"
;

alter table K_ENTRYRELATED add constraint KENTRY_KENTRYRELATEDID foreign key (K_ENTRYRELATED_ID) references K_ENTRY(K_ENTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEX drop constraint "ADTABLE_KINDEX"
;

alter table K_INDEX add constraint ADTABLE_KINDEX foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEX drop constraint "CDOCTYPE_KINDEX"
;

alter table K_INDEX add constraint CDOCTYPE_KINDEX foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEX drop constraint "CMWEBPROJECT_KINDEX"
;

alter table K_INDEX add constraint CMWEBPROJECT_KINDEX foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEX drop constraint "RREQUESTTYPE_KINDEX"
;

alter table K_INDEX add constraint RREQUESTTYPE_KINDEX foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEXSTOP drop constraint "CDOCTYPE_KINDEXSTOP"
;

alter table K_INDEXSTOP add constraint CDOCTYPE_KINDEXSTOP foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEXSTOP drop constraint "CMWEBPROJECT_KINDEXSTOP"
;

alter table K_INDEXSTOP add constraint CMWEBPROJECT_KINDEXSTOP foreign key (CM_WEBPROJECT_ID) references CM_WEBPROJECT(CM_WEBPROJECT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_INDEXSTOP drop constraint "RREQUESTTYPE_KINDEXSTOP"
;

alter table K_INDEXSTOP add constraint RREQUESTTYPE_KINDEXSTOP foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_SYNONYM drop constraint "ADLANGU_KSYNONYM"
;

alter table K_SYNONYM add constraint ADLANGU_KSYNONYM foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table K_TOPIC drop constraint "KTYPE_KTOPIC"
;

alter table K_TOPIC add constraint KTYPE_KTOPIC foreign key (K_TYPE_ID) references K_TYPE(K_TYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTE drop constraint "MATTRIBUTESEARCH_MATTRIBUTE"
;

alter table M_ATTRIBUTE add constraint MATTRIBUTESEARCH_MATTRIBUTE foreign key (M_ATTRIBUTESEARCH_ID) references M_ATTRIBUTESEARCH(M_ATTRIBUTESEARCH_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEINSTANCE drop constraint "MATTRIBUTEVALUE_MATTRINST"
;

alter table M_ATTRIBUTEINSTANCE add constraint MATTRIBUTEVALUE_MATTRINST foreign key (M_ATTRIBUTEVALUE_ID) references M_ATTRIBUTEVALUE(M_ATTRIBUTEVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEINSTANCE drop constraint "MATTRIBUTE_MATTRIBUTEINST"
;

alter table M_ATTRIBUTEINSTANCE add constraint MATTRIBUTE_MATTRIBUTEINST foreign key (M_ATTRIBUTE_ID) references M_ATTRIBUTE(M_ATTRIBUTE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEINSTANCE drop constraint "MATTRSETINST__MATTRINST"
;

alter table M_ATTRIBUTEINSTANCE add constraint MATTRSETINST__MATTRINST foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESET drop constraint "MLOTCTL_MATTRIBUTESET"
;

alter table M_ATTRIBUTESET add constraint MLOTCTL_MATTRIBUTESET foreign key (M_LOTCTL_ID) references M_LOTCTL(M_LOTCTL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESET drop constraint "MSERNOCTL_ATTRIBUTESET"
;

alter table M_ATTRIBUTESET add constraint MSERNOCTL_ATTRIBUTESET foreign key (M_SERNOCTL_ID) references M_SERNOCTL(M_SERNOCTL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESETEXCLUDE drop constraint "ADTABLE_MATTRIBUTESETEXCLUDE"
;

alter table M_ATTRIBUTESETEXCLUDE add constraint ADTABLE_MATTRIBUTESETEXCLUDE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESETEXCLUDE drop constraint "MATTRIBUTESET_MASEXCLUDE"
;

alter table M_ATTRIBUTESETEXCLUDE add constraint MATTRIBUTESET_MASEXCLUDE foreign key (M_ATTRIBUTESET_ID) references M_ATTRIBUTESET(M_ATTRIBUTESET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESETINSTANCE drop constraint "MATTRIBUTESET_MATTRIBSETINST"
;

alter table M_ATTRIBUTESETINSTANCE add constraint MATTRIBUTESET_MATTRIBSETINST foreign key (M_ATTRIBUTESET_ID) references M_ATTRIBUTESET(M_ATTRIBUTESET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTESETINSTANCE drop constraint "MLOT_MATTRIBUTESETINSTANCE"
;

alter table M_ATTRIBUTESETINSTANCE add constraint MLOT_MATTRIBUTESETINSTANCE foreign key (M_LOT_ID) references M_LOT(M_LOT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEUSE drop constraint "MATTRIBUTESET_MATTRIBUTEUSE"
;

alter table M_ATTRIBUTEUSE add constraint MATTRIBUTESET_MATTRIBUTEUSE foreign key (M_ATTRIBUTESET_ID) references M_ATTRIBUTESET(M_ATTRIBUTESET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEUSE drop constraint "MATTRIBUTE_MATTRIBUTEUSE"
;

alter table M_ATTRIBUTEUSE add constraint MATTRIBUTE_MATTRIBUTEUSE foreign key (M_ATTRIBUTE_ID) references M_ATTRIBUTE(M_ATTRIBUTE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_ATTRIBUTEVALUE drop constraint "MATTRIBUTE_MATTRIBUTEVALUE"
;

alter table M_ATTRIBUTEVALUE add constraint MATTRIBUTE_MATTRIBUTEVALUE foreign key (M_ATTRIBUTE_ID) references M_ATTRIBUTE(M_ATTRIBUTE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOM drop constraint "MCN_MBOM"
;

alter table M_BOM add constraint MCN_MBOM foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOM drop constraint "MPRODUCT_MBOM"
;

alter table M_BOM add constraint MPRODUCT_MBOM foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMALTERNATIVE drop constraint "MPRODUCT_MBOMALTERNATIVE"
;

alter table M_BOMALTERNATIVE add constraint MPRODUCT_MBOMALTERNATIVE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MASI_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MASI_MBOMPRODUCT foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MBOMALTERNATIVE_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MBOMALTERNATIVE_MBOMPRODUCT foreign key (M_BOMALTERNATIVE_ID) references M_BOMALTERNATIVE(M_BOMALTERNATIVE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MBOM_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MBOM_MBOMPRODUCT foreign key (M_BOM_ID) references M_BOM(M_BOM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MCN_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MCN_MBOMPRODUCT foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MPRODUCTOP_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MPRODUCTOP_MBOMPRODUCT foreign key (M_PRODUCTOPERATION_ID) references M_PRODUCTOPERATION(M_PRODUCTOPERATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_BOMPRODUCT drop constraint "MPRODUCT_MBOMPRODUCT"
;

alter table M_BOMPRODUCT add constraint MPRODUCT_MBOMPRODUCT foreign key (M_PRODUCTBOM_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_CHANGEREQUEST drop constraint "MCN_MCR"
;

alter table M_CHANGEREQUEST add constraint MCN_MCR foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_CHANGEREQUEST drop constraint "MFIXCHANGENOTICE_MCHANGEREQUES"
;

alter table M_CHANGEREQUEST add constraint MFIXCHANGENOTICE_MCHANGEREQUES foreign key (M_FIXCHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_CHANGEREQUEST drop constraint "PPPRODUCTBOM_MCHANGEREQUEST"
;

alter table M_CHANGEREQUEST add constraint PPPRODUCTBOM_MCHANGEREQUEST foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "ADCLIENT_MCOST"
;

alter table M_COST add constraint ADCLIENT_MCOST foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "ADORG_M_COST"
;

alter table M_COST add constraint ADORG_M_COST foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "CACCTSCHEMA_MCOST"
;

alter table M_COST add constraint CACCTSCHEMA_MCOST foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "MASI_MCOST"
;

alter table M_COST add constraint MASI_MCOST foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "MCOSTELEMENT_MCOST"
;

alter table M_COST add constraint MCOSTELEMENT_MCOST foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "MCOSTTYPE_MCOST"
;

alter table M_COST add constraint MCOSTTYPE_MCOST foreign key (M_COSTTYPE_ID) references M_COSTTYPE(M_COSTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COST drop constraint "MPRODUCT_MCOST"
;

alter table M_COST add constraint MPRODUCT_MCOST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "ADCLIENT_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint ADCLIENT_MCOSTDETAIL foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "ADORG_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint ADORG_MCOSTDETAIL foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "CACCTSCHEMA_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint CACCTSCHEMA_MCOSTDETAIL foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "CORDERLINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint CORDERLINE_MCOSTDETAIL foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "CPROJECTISSUE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint CPROJECTISSUE_MCOSTDETAIL foreign key (C_PROJECTISSUE_ID) references C_PROJECTISSUE(C_PROJECTISSUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MASI_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MASI_MCOSTDETAIL foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MCOSTELEMENT_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MCOSTELEMENT_MCOSTDETAIL foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MINOUTLINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MINOUTLINE_MCOSTDETAIL foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MINVENTORYLINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MINVENTORYLINE_MCOSTDETAIL foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MINVOICELINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MINVOICELINE_MCOSTDETAIL foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MMOVEMENTLINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MMOVEMENTLINE_MCOSTDETAIL foreign key (M_MOVEMENTLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MPRODUCTIONLINE_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MPRODUCTIONLINE_MCOSTDETAIL foreign key (M_PRODUCTIONLINE_ID) references M_PRODUCTIONLINE(M_PRODUCTIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "MPRODUCT_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint MPRODUCT_MCOSTDETAIL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTDETAIL drop constraint "PPCOSTCOLLECTOR_MCOSTDETAIL"
;

alter table M_COSTDETAIL add constraint PPCOSTCOLLECTOR_MCOSTDETAIL foreign key (PP_COST_COLLECTOR_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTHISTORY drop constraint "MATTRIBUTESETINSTANCE_MCOSTHIS"
;

alter table M_COSTHISTORY add constraint MATTRIBUTESETINSTANCE_MCOSTHIS foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTHISTORY drop constraint "MCOSTDETAIL_MCOSTHISTORY"
;

alter table M_COSTHISTORY add constraint MCOSTDETAIL_MCOSTHISTORY foreign key (M_COSTDETAIL_ID) references M_COSTDETAIL(M_COSTDETAIL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTHISTORY drop constraint "MCOSTELEMENT_MCOSTHISTORY"
;

alter table M_COSTHISTORY add constraint MCOSTELEMENT_MCOSTHISTORY foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTHISTORY drop constraint "MCOSTTYPE_MCOSTHISTORY"
;

alter table M_COSTHISTORY add constraint MCOSTTYPE_MCOSTHISTORY foreign key (M_COSTTYPE_ID) references M_COSTTYPE(M_COSTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTQUEUE drop constraint "CACCTSCHEMA_MCOSTQUEUE"
;

alter table M_COSTQUEUE add constraint CACCTSCHEMA_MCOSTQUEUE foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTQUEUE drop constraint "MASI_MCOSTQUEUE"
;

alter table M_COSTQUEUE add constraint MASI_MCOSTQUEUE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTQUEUE drop constraint "MCOSTELEMENT_MCOSTQUEUE"
;

alter table M_COSTQUEUE add constraint MCOSTELEMENT_MCOSTQUEUE foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTQUEUE drop constraint "MCOSTTYPE_MCOSTQUEUE"
;

alter table M_COSTQUEUE add constraint MCOSTTYPE_MCOSTQUEUE foreign key (M_COSTTYPE_ID) references M_COSTTYPE(M_COSTTYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_COSTQUEUE drop constraint "MPRODUCT_MCOSTQUEUE"
;

alter table M_COSTQUEUE add constraint MPRODUCT_MCOSTQUEUE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMAND drop constraint "CCALENDAR_MDEMAND"
;

alter table M_DEMAND add constraint CCALENDAR_MDEMAND foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMAND drop constraint "CYEAR_MDEMAND"
;

alter table M_DEMAND add constraint CYEAR_MDEMAND foreign key (C_YEAR_ID) references C_YEAR(C_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDDETAIL drop constraint "CORDERLINE_MDEMANDDETAIL"
;

alter table M_DEMANDDETAIL add constraint CORDERLINE_MDEMANDDETAIL foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDDETAIL drop constraint "MDEMANDLINE_MDEMANDDETAIL"
;

alter table M_DEMANDDETAIL add constraint MDEMANDLINE_MDEMANDDETAIL foreign key (M_DEMANDLINE_ID) references M_DEMANDLINE(M_DEMANDLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDDETAIL drop constraint "MFORECASTLINE_MDEMANDDETAIL"
;

alter table M_DEMANDDETAIL add constraint MFORECASTLINE_MDEMANDDETAIL foreign key (M_FORECASTLINE_ID) references M_FORECASTLINE(M_FORECASTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDDETAIL drop constraint "MREQLINE_MDEMANDDETAIL"
;

alter table M_DEMANDDETAIL add constraint MREQLINE_MDEMANDDETAIL foreign key (M_REQUISITIONLINE_ID) references M_REQUISITIONLINE(M_REQUISITIONLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDLINE drop constraint "CPERIOD_MDEMANDLINE"
;

alter table M_DEMANDLINE add constraint CPERIOD_MDEMANDLINE foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDLINE drop constraint "MDEMAND_MDEMANDLINE"
;

alter table M_DEMANDLINE add constraint MDEMAND_MDEMANDLINE foreign key (M_DEMAND_ID) references M_DEMAND(M_DEMAND_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DEMANDLINE drop constraint "MPRODUCT_MDEMANDLINE"
;

alter table M_DEMANDLINE add constraint MPRODUCT_MDEMANDLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMABREAK drop constraint "MDISCOUNTS_MDSBREAK"
;

alter table M_DISCOUNTSCHEMABREAK add constraint MDISCOUNTS_MDSBREAK foreign key (M_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMABREAK drop constraint "MPRODCATEGORY_MDISCOUNTSBREAK"
;

alter table M_DISCOUNTSCHEMABREAK add constraint MPRODCATEGORY_MDISCOUNTSBREAK foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMABREAK drop constraint "MPRODUCT_MDISCOUNTSBREAK"
;

alter table M_DISCOUNTSCHEMABREAK add constraint MPRODUCT_MDISCOUNTSBREAK foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMALINE drop constraint "CBPARTNER_MDISCOUNTSLINE"
;

alter table M_DISCOUNTSCHEMALINE add constraint CBPARTNER_MDISCOUNTSLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMALINE drop constraint "CCONVERSIONTYPE_MDISCSCHLINE"
;

alter table M_DISCOUNTSCHEMALINE add constraint CCONVERSIONTYPE_MDISCSCHLINE foreign key (C_CONVERSIONTYPE_ID) references C_CONVERSIONTYPE(C_CONVERSIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMALINE drop constraint "MDISCOUNTSCHEMA_MDSLINE"
;

alter table M_DISCOUNTSCHEMALINE add constraint MDISCOUNTSCHEMA_MDSLINE foreign key (M_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMALINE drop constraint "MPRODCATEGORY_MDISCOUNTSLINE"
;

alter table M_DISCOUNTSCHEMALINE add constraint MPRODCATEGORY_MDISCOUNTSLINE foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISCOUNTSCHEMALINE drop constraint "MPRODUCT_MDISCOUNTSLINE"
;

alter table M_DISCOUNTSCHEMALINE add constraint MPRODUCT_MDISCOUNTSLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONLISTLINE drop constraint "CBPARTNERLOC_MDISTLISTLINE"
;

alter table M_DISTRIBUTIONLISTLINE add constraint CBPARTNERLOC_MDISTLISTLINE foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONLISTLINE drop constraint "CBPARTNER_MDISTLISTLINE"
;

alter table M_DISTRIBUTIONLISTLINE add constraint CBPARTNER_MDISTLISTLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONLISTLINE drop constraint "MDISTRIBUTIONLIST_LINE"
;

alter table M_DISTRIBUTIONLISTLINE add constraint MDISTRIBUTIONLIST_LINE foreign key (M_DISTRIBUTIONLIST_ID) references M_DISTRIBUTIONLIST(M_DISTRIBUTIONLIST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONRUN drop constraint "CBPARTNER_MDISTRIBUTIONRUN"
;

alter table M_DISTRIBUTIONRUN add constraint CBPARTNER_MDISTRIBUTIONRUN foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONRUN drop constraint "CBPLOCATION_MDISTRIBUTIONRUN"
;

alter table M_DISTRIBUTIONRUN add constraint CBPLOCATION_MDISTRIBUTIONRUN foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONRUNLINE drop constraint "MDISTRIBUTIONLIST_RUNLINE"
;

alter table M_DISTRIBUTIONRUNLINE add constraint MDISTRIBUTIONLIST_RUNLINE foreign key (M_DISTRIBUTIONLIST_ID) references M_DISTRIBUTIONLIST(M_DISTRIBUTIONLIST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONRUNLINE drop constraint "MDISTRIBUTIONRUN_LINE"
;

alter table M_DISTRIBUTIONRUNLINE add constraint MDISTRIBUTIONRUN_LINE foreign key (M_DISTRIBUTIONRUN_ID) references M_DISTRIBUTIONRUN(M_DISTRIBUTIONRUN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_DISTRIBUTIONRUNLINE drop constraint "MPRODUCT_MDISTRIBUTIONRUN"
;

alter table M_DISTRIBUTIONRUNLINE add constraint MPRODUCT_MDISTRIBUTIONRUN foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_EDI drop constraint "CBPEDI_MEDI"
;

alter table M_EDI add constraint CBPEDI_MEDI foreign key (C_BP_EDI_ID) references C_BP_EDI(C_BP_EDI_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_EDI drop constraint "MPRODUCT_MEDI"
;

alter table M_EDI add constraint MPRODUCT_MEDI foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_EDI drop constraint "MWAREHOUSE_MEDI"
;

alter table M_EDI add constraint MWAREHOUSE_MEDI foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_EDI_INFO drop constraint "MEDI_EDIINFO"
;

alter table M_EDI_INFO add constraint MEDI_EDIINFO foreign key (M_EDI_ID) references M_EDI(M_EDI_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECAST drop constraint "CCALENDAR_MFORECAST"
;

alter table M_FORECAST add constraint CCALENDAR_MFORECAST foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECAST drop constraint "CYEAR_MFORECAST"
;

alter table M_FORECAST add constraint CYEAR_MFORECAST foreign key (C_YEAR_ID) references C_YEAR(C_YEAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECAST drop constraint "MPRICELIST_MFORECAST"
;

alter table M_FORECAST add constraint MPRICELIST_MFORECAST foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECASTLINE drop constraint "CPERIOD_MFORECASTLINE"
;

alter table M_FORECASTLINE add constraint CPERIOD_MFORECASTLINE foreign key (C_PERIOD_ID) references C_PERIOD(C_PERIOD_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECASTLINE drop constraint "MFORECAST_MFORECASTLINE"
;

alter table M_FORECASTLINE add constraint MFORECAST_MFORECASTLINE foreign key (M_FORECAST_ID) references M_FORECAST(M_FORECAST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECASTLINE drop constraint "MPRODUCT_MFORECASTLINE"
;

alter table M_FORECASTLINE add constraint MPRODUCT_MFORECASTLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FORECASTLINE drop constraint "MWAREHOUSE_MFORECASTLINE"
;

alter table M_FORECASTLINE add constraint MWAREHOUSE_MFORECASTLINE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "CCOUNTRYTO_MFREIGHT"
;

alter table M_FREIGHT add constraint CCOUNTRYTO_MFREIGHT foreign key (TO_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "CCOUNTRY_MFREIGHT"
;

alter table M_FREIGHT add constraint CCOUNTRY_MFREIGHT foreign key (C_COUNTRY_ID) references C_COUNTRY(C_COUNTRY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "CCURRENCY_MFREIGHT"
;

alter table M_FREIGHT add constraint CCURRENCY_MFREIGHT foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "CREGIONTO_MFREIGHT"
;

alter table M_FREIGHT add constraint CREGIONTO_MFREIGHT foreign key (TO_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "CREGION_MFREIGHT"
;

alter table M_FREIGHT add constraint CREGION_MFREIGHT foreign key (C_REGION_ID) references C_REGION(C_REGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "MFREIGHTCATEGORY_MFREIGHT"
;

alter table M_FREIGHT add constraint MFREIGHTCATEGORY_MFREIGHT foreign key (M_FREIGHTCATEGORY_ID) references M_FREIGHTCATEGORY(M_FREIGHTCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_FREIGHT drop constraint "MSHIPPER_MFREIGHT"
;

alter table M_FREIGHT add constraint MSHIPPER_MFREIGHT foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "ADORGTRX_MINOUT"
;

alter table M_INOUT add constraint ADORGTRX_MINOUT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "ADORG_MINOUT"
;

alter table M_INOUT add constraint ADORG_MINOUT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "ADUSER_MINOUT"
;

alter table M_INOUT add constraint ADUSER_MINOUT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "ADUSER_SR_MINOUT"
;

alter table M_INOUT add constraint ADUSER_SR_MINOUT foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CACTIVITY_MINOUT"
;

alter table M_INOUT add constraint CACTIVITY_MINOUT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CBPARTNER_MINOUT"
;

alter table M_INOUT add constraint CBPARTNER_MINOUT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CCAMPAIGN_MINOUT"
;

alter table M_INOUT add constraint CCAMPAIGN_MINOUT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CCHARGE_MINOUT"
;

alter table M_INOUT add constraint CCHARGE_MINOUT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CDOCTYPE_MINOUT"
;

alter table M_INOUT add constraint CDOCTYPE_MINOUT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CELEMENTVALUEUSER1_MINOUT"
;

alter table M_INOUT add constraint CELEMENTVALUEUSER1_MINOUT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CELEMENTVALUEUSER2_MINOUT"
;

alter table M_INOUT add constraint CELEMENTVALUEUSER2_MINOUT foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CINVOICE_MINOUT"
;

alter table M_INOUT add constraint CINVOICE_MINOUT foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CORDER_MINOUT"
;

alter table M_INOUT add constraint CORDER_MINOUT foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "CPROJECT_MINOUT"
;

alter table M_INOUT add constraint CPROJECT_MINOUT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "DROPSHIPBPARTNER_MINOUT"
;

alter table M_INOUT add constraint DROPSHIPBPARTNER_MINOUT foreign key (DROPSHIP_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "DROPSHIPLOCATION_MINOUT"
;

alter table M_INOUT add constraint DROPSHIPLOCATION_MINOUT foreign key (DROPSHIP_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "DROPSHIPUSER_MINOUT"
;

alter table M_INOUT add constraint DROPSHIPUSER_MINOUT foreign key (DROPSHIP_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "MINOUT_REF"
;

alter table M_INOUT add constraint MINOUT_REF foreign key (REF_INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "MRMA_MINOUT"
;

alter table M_INOUT add constraint MRMA_MINOUT foreign key (M_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "MSHIPPER_MINOUT"
;

alter table M_INOUT add constraint MSHIPPER_MINOUT foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "MWAREHOUSE_MINOUT"
;

alter table M_INOUT add constraint MWAREHOUSE_MINOUT foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "REVERSAL_MINOUT"
;

alter table M_INOUT add constraint REVERSAL_MINOUT foreign key (REVERSAL_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUT drop constraint "VBPLOCATION_MINOUT"
;

alter table M_INOUT add constraint VBPLOCATION_MINOUT foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTCONFIRM drop constraint "CINVOICE_MINOUTCONFIRM"
;

alter table M_INOUTCONFIRM add constraint CINVOICE_MINOUTCONFIRM foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTCONFIRM drop constraint "MINOUT_MINOUTCONFIRM"
;

alter table M_INOUTCONFIRM add constraint MINOUT_MINOUTCONFIRM foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTCONFIRM drop constraint "MINVENTORY_MINOUTCONFIRM"
;

alter table M_INOUTCONFIRM add constraint MINVENTORY_MINOUTCONFIRM foreign key (M_INVENTORY_ID) references M_INVENTORY(M_INVENTORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "ADORGTRX_MINOUTLINE"
;

alter table M_INOUTLINE add constraint ADORGTRX_MINOUTLINE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "ADORG_MINOUTLINE"
;

alter table M_INOUTLINE add constraint ADORG_MINOUTLINE foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CACTIVITY_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CACTIVITY_MINOUTLINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CCAMPAIGN_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CCAMPAIGN_MINOUTLINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CCHARGE_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CCHARGE_MINOUTLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CELEMENRVALUEUSER1_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CELEMENRVALUEUSER1_MINOUTLINE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CELEMENRVALUEUSER2_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CELEMENRVALUEUSER2_MINOUTLINE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CORDERLINE_MINOUT"
;

alter table M_INOUTLINE add constraint CORDERLINE_MINOUT foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CPROJECTTASK_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CPROJECTTASK_MINOUTLINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CPROJECT_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CPROJECT_MINOUTLINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "CUOM_MINOUTLINE"
;

alter table M_INOUTLINE add constraint CUOM_MINOUTLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "C_PROJECTPHASE_MINOUTLINE"
;

alter table M_INOUTLINE add constraint C_PROJECTPHASE_MINOUTLINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MATTRSETINST_MINOUTLINE"
;

alter table M_INOUTLINE add constraint MATTRSETINST_MINOUTLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MINOUTLINE_REF"
;

alter table M_INOUTLINE add constraint MINOUTLINE_REF foreign key (REF_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MINOUT_MINOUTLINE"
;

alter table M_INOUTLINE add constraint MINOUT_MINOUTLINE foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MLOCATOR_MINOUTLINE"
;

alter table M_INOUTLINE add constraint MLOCATOR_MINOUTLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MPRODUCT_MINOUTLINE"
;

alter table M_INOUTLINE add constraint MPRODUCT_MINOUTLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "MRMALINE_MINOUTLINE"
;

alter table M_INOUTLINE add constraint MRMALINE_MINOUTLINE foreign key (M_RMALINE_ID) references M_RMALINE(M_RMALINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINE drop constraint "REVERSALLINE_MINOUTLINE"
;

alter table M_INOUTLINE add constraint REVERSALLINE_MINOUTLINE foreign key (REVERSALLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINECONFIRM drop constraint "CINVOICELINE_MINOUTLINECONFIRM"
;

alter table M_INOUTLINECONFIRM add constraint CINVOICELINE_MINOUTLINECONFIRM foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINECONFIRM drop constraint "MINOUTCONFIRM_MINOUTLINECONF"
;

alter table M_INOUTLINECONFIRM add constraint MINOUTCONFIRM_MINOUTLINECONF foreign key (M_INOUTCONFIRM_ID) references M_INOUTCONFIRM(M_INOUTCONFIRM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINECONFIRM drop constraint "MINOUTLINE_MINOUTCONFIRM"
;

alter table M_INOUTLINECONFIRM add constraint MINOUTLINE_MINOUTCONFIRM foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINECONFIRM drop constraint "MINVENTORYLINE_MINOUTLINECONFI"
;

alter table M_INOUTLINECONFIRM add constraint MINVENTORYLINE_MINOUTLINECONFI foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINEMA drop constraint "MASI_MINOURLINEMA"
;

alter table M_INOUTLINEMA add constraint MASI_MINOURLINEMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INOUTLINEMA drop constraint "MINOUTLINE_MINOUTLINEMA"
;

alter table M_INOUTLINEMA add constraint MINOUTLINE_MINOUTLINEMA foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "ADORGTRX_MINVENTORY"
;

alter table M_INVENTORY add constraint ADORGTRX_MINVENTORY foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "ADORG_MINVENTORY"
;

alter table M_INVENTORY add constraint ADORG_MINVENTORY foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CACTIVITY_MINVENTORY"
;

alter table M_INVENTORY add constraint CACTIVITY_MINVENTORY foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CCAMPAIGN_MINVENTORY"
;

alter table M_INVENTORY add constraint CCAMPAIGN_MINVENTORY foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CDOCTYPE_MINVENTORY"
;

alter table M_INVENTORY add constraint CDOCTYPE_MINVENTORY foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CELEMENTVALUEUSER1_MINVENT"
;

alter table M_INVENTORY add constraint CELEMENTVALUEUSER1_MINVENT foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CELEMENTVALUEUSER2_MINVENT"
;

alter table M_INVENTORY add constraint CELEMENTVALUEUSER2_MINVENT foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "CPROJECT_MINVENTORY"
;

alter table M_INVENTORY add constraint CPROJECT_MINVENTORY foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "MPERPETUALINV_MINVENTORY"
;

alter table M_INVENTORY add constraint MPERPETUALINV_MINVENTORY foreign key (M_PERPETUALINV_ID) references M_PERPETUALINV(M_PERPETUALINV_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "MWAREHOUSE_MINVENTORY"
;

alter table M_INVENTORY add constraint MWAREHOUSE_MINVENTORY foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORY drop constraint "REVERSAL_MINVENTORY"
;

alter table M_INVENTORY add constraint REVERSAL_MINVENTORY foreign key (REVERSAL_ID) references M_INVENTORY(M_INVENTORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "CCHARGE_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint CCHARGE_MINVENTORYLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "MATTRSETINST_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint MATTRSETINST_MINVENTORYLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "MINVENTORY_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint MINVENTORY_MINVENTORYLINE foreign key (M_INVENTORY_ID) references M_INVENTORY(M_INVENTORY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "MLOCATOR_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint MLOCATOR_MINVENTORYLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "MPRODUCT_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint MPRODUCT_MINVENTORYLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINE drop constraint "REVERSALLINE_MINVENTORYLINE"
;

alter table M_INVENTORYLINE add constraint REVERSALLINE_MINVENTORYLINE foreign key (REVERSALLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINEMA drop constraint "MASI_MINVENTORYLINEMA"
;

alter table M_INVENTORYLINEMA add constraint MASI_MINVENTORYLINEMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_INVENTORYLINEMA drop constraint "MINVENTORYLINE_MILINEMA"
;

alter table M_INVENTORYLINEMA add constraint MINVENTORYLINE_MILINEMA foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOCATOR drop constraint "M_WAREHOUSE_LOCATOR"
;

alter table M_LOCATOR add constraint M_WAREHOUSE_LOCATOR foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOCATOR drop constraint "M_WH_LOCATOR_CLIENT"
;

alter table M_LOCATOR add constraint M_WH_LOCATOR_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOCATOR drop constraint "M_WH_LOCATOR_ORG"
;

alter table M_LOCATOR add constraint M_WH_LOCATOR_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOT drop constraint "MLOTCTL_MLOT"
;

alter table M_LOT add constraint MLOTCTL_MLOT foreign key (M_LOTCTL_ID) references M_LOTCTL(M_LOTCTL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOT drop constraint "MPRODUCT_MLOT"
;

alter table M_LOT add constraint MPRODUCT_MLOT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOTCTLEXCLUDE drop constraint "ADTABLE_MLOTCTLEXCLUDE"
;

alter table M_LOTCTLEXCLUDE add constraint ADTABLE_MLOTCTLEXCLUDE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_LOTCTLEXCLUDE drop constraint "MLOTCTL_MLOTCTLEXCLUDE"
;

alter table M_LOTCTLEXCLUDE add constraint MLOTCTL_MLOTCTLEXCLUDE foreign key (M_LOTCTL_ID) references M_LOTCTL(M_LOTCTL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHINV drop constraint "CONVOICELINE_MMATCHINV"
;

alter table M_MATCHINV add constraint CONVOICELINE_MMATCHINV foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHINV drop constraint "MATTRIBUTESETINSTANCE_MMATCHIN"
;

alter table M_MATCHINV add constraint MATTRIBUTESETINSTANCE_MMATCHIN foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHINV drop constraint "MINOUTLINE_MMATCHINV"
;

alter table M_MATCHINV add constraint MINOUTLINE_MMATCHINV foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHINV drop constraint "MPRODUCT_MMATCHINV"
;

alter table M_MATCHINV add constraint MPRODUCT_MMATCHINV foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHPO drop constraint "CINVOICELINE_MMATCHPO"
;

alter table M_MATCHPO add constraint CINVOICELINE_MMATCHPO foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHPO drop constraint "CORDERLINE_MMATCHPO"
;

alter table M_MATCHPO add constraint CORDERLINE_MMATCHPO foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHPO drop constraint "MATTRIBUTESETINSTANCE_MMATCHPO"
;

alter table M_MATCHPO add constraint MATTRIBUTESETINSTANCE_MMATCHPO foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHPO drop constraint "MINOUTLINE_MMATCHPO"
;

alter table M_MATCHPO add constraint MINOUTLINE_MMATCHPO foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MATCHPO drop constraint "MPRODUCT_MMATCHPO"
;

alter table M_MATCHPO add constraint MPRODUCT_MMATCHPO foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "ADORGTRX_MMOVEMENT"
;

alter table M_MOVEMENT add constraint ADORGTRX_MMOVEMENT foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "ADORG_MMOVEMENT"
;

alter table M_MOVEMENT add constraint ADORG_MMOVEMENT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "ADUSER_MMOVEMENT"
;

alter table M_MOVEMENT add constraint ADUSER_MMOVEMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CACTIVITY_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CACTIVITY_MMOVEMENT foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CBPARTNER_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CBPARTNER_MMOVEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CCAMPAIGN_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CCAMPAIGN_MMOVEMENT foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CCHARGE_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CCHARGE_MMOVEMENT foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CDOCTYPE_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CDOCTYPE_MMOVEMENT foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CELEMENTVALUEUSER1_MMOVE"
;

alter table M_MOVEMENT add constraint CELEMENTVALUEUSER1_MMOVE foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CELEMENTVALUEUSER2_MMOVE"
;

alter table M_MOVEMENT add constraint CELEMENTVALUEUSER2_MMOVE foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "CPROJECT_MMOVEMENT"
;

alter table M_MOVEMENT add constraint CPROJECT_MMOVEMENT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "DDORDER_MMOVEMENT"
;

alter table M_MOVEMENT add constraint DDORDER_MMOVEMENT foreign key (DD_ORDER_ID) references DD_ORDER(DD_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "MSHIPPER_MMOVEMENT"
;

alter table M_MOVEMENT add constraint MSHIPPER_MMOVEMENT foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "REVERSAL_MMOVEMENT"
;

alter table M_MOVEMENT add constraint REVERSAL_MMOVEMENT foreign key (REVERSAL_ID) references M_MOVEMENT(M_MOVEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENT drop constraint "SALESREP_MMOVEMENT"
;

alter table M_MOVEMENT add constraint SALESREP_MMOVEMENT foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTCONFIRM drop constraint "MINVENTORY_MMOVCONFIRM"
;

alter table M_MOVEMENTCONFIRM add constraint MINVENTORY_MMOVCONFIRM foreign key (M_INVENTORY_ID) references M_INVENTORY(M_INVENTORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTCONFIRM drop constraint "MMOVEMENT_MMOVEMENTCONFIRM"
;

alter table M_MOVEMENTCONFIRM add constraint MMOVEMENT_MMOVEMENTCONFIRM foreign key (M_MOVEMENT_ID) references M_MOVEMENT(M_MOVEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "DDORDERLINE_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint DDORDERLINE_MMOVEMENTLINE foreign key (DD_ORDERLINE_ID) references DD_ORDERLINE(DD_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MATTRIBUTESETINSTANCETO_MMOVEM"
;

alter table M_MOVEMENTLINE add constraint MATTRIBUTESETINSTANCETO_MMOVEM foreign key (M_ATTRIBUTESETINSTANCETO_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MATTRSETINST_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint MATTRSETINST_MMOVEMENTLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MLOCATORTO_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint MLOCATORTO_MMOVEMENTLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MLOCATOR_MOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint MLOCATOR_MOVEMENTLINE foreign key (M_LOCATORTO_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MMOVEMENT_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint MMOVEMENT_MMOVEMENTLINE foreign key (M_MOVEMENT_ID) references M_MOVEMENT(M_MOVEMENT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "MPRODUCT_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint MPRODUCT_MMOVEMENTLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINE drop constraint "REVERSALLINE_MMOVEMENTLINE"
;

alter table M_MOVEMENTLINE add constraint REVERSALLINE_MMOVEMENTLINE foreign key (REVERSALLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINECONFIRM drop constraint "MINVENTORYLINE_MMOVLINECONFIRM"
;

alter table M_MOVEMENTLINECONFIRM add constraint MINVENTORYLINE_MMOVLINECONFIRM foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINECONFIRM drop constraint "MMOVEMENTCONFIRM_MMOVLINECONF"
;

alter table M_MOVEMENTLINECONFIRM add constraint MMOVEMENTCONFIRM_MMOVLINECONF foreign key (M_MOVEMENTCONFIRM_ID) references M_MOVEMENTCONFIRM(M_MOVEMENTCONFIRM_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINECONFIRM drop constraint "MMOVEMENTLINE_MMOVLINECONFIRM"
;

alter table M_MOVEMENTLINECONFIRM add constraint MMOVEMENTLINE_MMOVLINECONFIRM foreign key (M_MOVEMENTLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINEMA drop constraint "MASI_MMOVEMENTLINEMA"
;

alter table M_MOVEMENTLINEMA add constraint MASI_MMOVEMENTLINEMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_MOVEMENTLINEMA drop constraint "MMOVEMENTLINE_MMOVEMENTLINEMA"
;

alter table M_MOVEMENTLINEMA add constraint MMOVEMENTLINE_MMOVEMENTLINEMA foreign key (M_MOVEMENTLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_OPERATIONRESOURCE drop constraint "AASSET_MOPERATIONRESOURCE"
;

alter table M_OPERATIONRESOURCE add constraint AASSET_MOPERATIONRESOURCE foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_OPERATIONRESOURCE drop constraint "CJOB_MOPERATIONRESOURCE"
;

alter table M_OPERATIONRESOURCE add constraint CJOB_MOPERATIONRESOURCE foreign key (C_JOB_ID) references C_JOB(C_JOB_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_OPERATIONRESOURCE drop constraint "MPRODUCTOP_MOPRESOURCE"
;

alter table M_OPERATIONRESOURCE add constraint MPRODUCTOP_MOPRESOURCE foreign key (M_PRODUCTOPERATION_ID) references M_PRODUCTOPERATION(M_PRODUCTOPERATION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PACKAGE drop constraint "MINOUT_MPACKAGE"
;

alter table M_PACKAGE add constraint MINOUT_MPACKAGE foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PACKAGE drop constraint "MSHIPPER_MPACKAGE"
;

alter table M_PACKAGE add constraint MSHIPPER_MPACKAGE foreign key (M_SHIPPER_ID) references M_SHIPPER(M_SHIPPER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PACKAGELINE drop constraint "MINOUTLINE_MPACKAGELINE"
;

alter table M_PACKAGELINE add constraint MINOUTLINE_MPACKAGELINE foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PACKAGELINE drop constraint "MPACKAGE_MPACKAGELINE"
;

alter table M_PACKAGELINE add constraint MPACKAGE_MPACKAGELINE foreign key (M_PACKAGE_ID) references M_PACKAGE(M_PACKAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PERPETUALINV drop constraint "MPRODCATEGORY_MPERPETUALINV"
;

alter table M_PERPETUALINV add constraint MPRODCATEGORY_MPERPETUALINV foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PERPETUALINV drop constraint "MWAREHOUSE_MPERPETUALINV"
;

alter table M_PERPETUALINV add constraint MWAREHOUSE_MPERPETUALINV foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRICELIST drop constraint "BASEPRICELIST"
;

alter table M_PRICELIST add constraint BASEPRICELIST foreign key (BASEPRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRICELIST drop constraint "CCURRENCY_MPRICELIST"
;

alter table M_PRICELIST add constraint CCURRENCY_MPRICELIST foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRICELIST_VERSION drop constraint "MDISCOUNTS_MPLVERSION"
;

alter table M_PRICELIST_VERSION add constraint MDISCOUNTS_MPLVERSION foreign key (M_DISCOUNTSCHEMA_ID) references M_DISCOUNTSCHEMA(M_DISCOUNTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRICELIST_VERSION drop constraint "MPRICELISTVERSIONBASE_MPRICELI"
;

alter table M_PRICELIST_VERSION add constraint MPRICELISTVERSIONBASE_MPRICELI foreign key (M_PRICELIST_VERSION_BASE_ID) references M_PRICELIST_VERSION(M_PRICELIST_VERSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRICELIST_VERSION drop constraint "MPRICELIST_MPRICELISTVERSION"
;

alter table M_PRICELIST_VERSION add constraint MPRICELIST_MPRICELISTVERSION foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "ADCLIENT_MPRODUCT"
;

alter table M_PRODUCT add constraint ADCLIENT_MPRODUCT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "AD_ORG_MPRODUCT"
;

alter table M_PRODUCT add constraint AD_ORG_MPRODUCT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "CREVRECOGNITION_MPRODUCT"
;

alter table M_PRODUCT add constraint CREVRECOGNITION_MPRODUCT foreign key (C_REVENUERECOGNITION_ID) references C_REVENUERECOGNITION(C_REVENUERECOGNITION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "CSUBSCRIPTIONTYPE_MPRODUCT"
;

alter table M_PRODUCT add constraint CSUBSCRIPTIONTYPE_MPRODUCT foreign key (C_SUBSCRIPTIONTYPE_ID) references C_SUBSCRIPTIONTYPE(C_SUBSCRIPTIONTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "CTAXCATEGORY_MPRODUCT"
;

alter table M_PRODUCT add constraint CTAXCATEGORY_MPRODUCT foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "CUOM_MPRODUCT"
;

alter table M_PRODUCT add constraint CUOM_MPRODUCT foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MATTRIBUTESET_MPRODUCT"
;

alter table M_PRODUCT add constraint MATTRIBUTESET_MPRODUCT foreign key (M_ATTRIBUTESET_ID) references M_ATTRIBUTESET(M_ATTRIBUTESET_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MATTRSETINST_MPRODUCT"
;

alter table M_PRODUCT add constraint MATTRSETINST_MPRODUCT foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MFREIGHTCATEGORY_MPRODUCT"
;

alter table M_PRODUCT add constraint MFREIGHTCATEGORY_MPRODUCT foreign key (M_FREIGHTCATEGORY_ID) references M_FREIGHTCATEGORY(M_FREIGHTCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MLOCATOR_MPRODUCT"
;

alter table M_PRODUCT add constraint MLOCATOR_MPRODUCT foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MPARTTYPE_MPRODUCT"
;

alter table M_PRODUCT add constraint MPARTTYPE_MPRODUCT foreign key (M_PARTTYPE_ID) references M_PARTTYPE(M_PARTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "MPRODUCT_MPRODUCTCATEGORY"
;

alter table M_PRODUCT add constraint MPRODUCT_MPRODUCTCATEGORY foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "RMAILTEXT_MPRODUCT"
;

alter table M_PRODUCT add constraint RMAILTEXT_MPRODUCT foreign key (R_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "SALESREP_MPRODUCT"
;

alter table M_PRODUCT add constraint SALESREP_MPRODUCT foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "SEXPENSETYPE_MPRODUCT"
;

alter table M_PRODUCT add constraint SEXPENSETYPE_MPRODUCT foreign key (S_EXPENSETYPE_ID) references S_EXPENSETYPE(S_EXPENSETYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT drop constraint "SRESOURCE_MPRODUCT"
;

alter table M_PRODUCT add constraint SRESOURCE_MPRODUCT foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTDOWNLOAD drop constraint "MPRODUCT_MPRODUCTDOWNLOAD"
;

alter table M_PRODUCTDOWNLOAD add constraint MPRODUCT_MPRODUCTDOWNLOAD foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "ADORGTRX_MPRODUCTION"
;

alter table M_PRODUCTION add constraint ADORGTRX_MPRODUCTION foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "ADORG_MPRODUCTION"
;

alter table M_PRODUCTION add constraint ADORG_MPRODUCTION foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CACTIVITY_MPRODUCTION"
;

alter table M_PRODUCTION add constraint CACTIVITY_MPRODUCTION foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CCAMPAIGN_MPRODUCTION"
;

alter table M_PRODUCTION add constraint CCAMPAIGN_MPRODUCTION foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CELEMENTVALUEUSER1_MPROD"
;

alter table M_PRODUCTION add constraint CELEMENTVALUEUSER1_MPROD foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CELEMENTVALUEUSER2_MPROD"
;

alter table M_PRODUCTION add constraint CELEMENTVALUEUSER2_MPROD foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CORDERLINE_MPRODUCTION"
;

alter table M_PRODUCTION add constraint CORDERLINE_MPRODUCTION foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "CPROJECT_MPRODUCTION"
;

alter table M_PRODUCTION add constraint CPROJECT_MPRODUCTION foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "MLOCATOR_MPRODUCTION"
;

alter table M_PRODUCTION add constraint MLOCATOR_MPRODUCTION foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTION drop constraint "MPRODUCT_MPRODUCTION"
;

alter table M_PRODUCTION add constraint MPRODUCT_MPRODUCTION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINE drop constraint "MATTRSETINST_MPRODUCTIONLINE"
;

alter table M_PRODUCTIONLINE add constraint MATTRSETINST_MPRODUCTIONLINE foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINE drop constraint "MLOCATOR_MPRODUCTIONLINE"
;

alter table M_PRODUCTIONLINE add constraint MLOCATOR_MPRODUCTIONLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINE drop constraint "MPRODUCTIONPLAN_LINE"
;

alter table M_PRODUCTIONLINE add constraint MPRODUCTIONPLAN_LINE foreign key (M_PRODUCTIONPLAN_ID) references M_PRODUCTIONPLAN(M_PRODUCTIONPLAN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINE drop constraint "MPRODUCTION_MPRODUCTIONLINE"
;

alter table M_PRODUCTIONLINE add constraint MPRODUCTION_MPRODUCTIONLINE foreign key (M_PRODUCTION_ID) references M_PRODUCTION(M_PRODUCTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINE drop constraint "MPRODUCT_MPRODUCTIONLINE"
;

alter table M_PRODUCTIONLINE add constraint MPRODUCT_MPRODUCTIONLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINEMA drop constraint "MASI_MPRODUCTIONLINEMA"
;

alter table M_PRODUCTIONLINEMA add constraint MASI_MPRODUCTIONLINEMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONLINEMA drop constraint "MPRODUCTIONLINE_MPLINEMA"
;

alter table M_PRODUCTIONLINEMA add constraint MPRODUCTIONLINE_MPLINEMA foreign key (M_PRODUCTIONLINE_ID) references M_PRODUCTIONLINE(M_PRODUCTIONLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONPLAN drop constraint "MLOCATOR_MPRODUCTIONPLAN"
;

alter table M_PRODUCTIONPLAN add constraint MLOCATOR_MPRODUCTIONPLAN foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONPLAN drop constraint "MPRODUCTION_PLAN"
;

alter table M_PRODUCTIONPLAN add constraint MPRODUCTION_PLAN foreign key (M_PRODUCTION_ID) references M_PRODUCTION(M_PRODUCTION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTIONPLAN drop constraint "MPRODUCT_MPRODUCTIONPLAN"
;

alter table M_PRODUCTIONPLAN add constraint MPRODUCT_MPRODUCTIONPLAN foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTOPERATION drop constraint "MPRODUCT_MPRODUCTOPERATION"
;

alter table M_PRODUCTOPERATION add constraint MPRODUCT_MPRODUCTOPERATION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTPRICE drop constraint "MPRICELISTVER_MPRODUCTPRICE"
;

alter table M_PRODUCTPRICE add constraint MPRICELISTVER_MPRODUCTPRICE foreign key (M_PRICELIST_VERSION_ID) references M_PRICELIST_VERSION(M_PRICELIST_VERSION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTPRICE drop constraint "MPRODUCT_MPRODUCTPRICE"
;

alter table M_PRODUCTPRICE add constraint MPRODUCT_MPRODUCTPRICE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTPRICEVENDORBREAK drop constraint "MPRICELISTVERSION_MPRODUCTPRIC"
;

alter table M_PRODUCTPRICEVENDORBREAK add constraint MPRICELISTVERSION_MPRODUCTPRIC foreign key (M_PRICELIST_VERSION_ID) references M_PRICELIST_VERSION(M_PRICELIST_VERSION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCTPRICEVENDORBREAK drop constraint "MPRODUCT_MPRODUCTPRICEVENDORBR"
;

alter table M_PRODUCTPRICEVENDORBREAK add constraint MPRODUCT_MPRODUCTPRICEVENDORBR foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "CACCTSCHEMA_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint CACCTSCHEMA_MPRODUCTACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "M_PRODUCT_M_PRODUCT_ACCT"
;

alter table M_PRODUCT_ACCT add constraint M_PRODUCT_M_PRODUCT_ACCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PAVERAGECOSTVARIANCE_MPRODUCTA"
;

alter table M_PRODUCT_ACCT add constraint PAVERAGECOSTVARIANCE_MPRODUCTA foreign key (P_AVERAGECOSTVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PBURDEN_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PBURDEN_MPRODUCTACCT foreign key (P_BURDEN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PCOSTADJUSTMENT_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PCOSTADJUSTMENT_MPRODUCTACCT foreign key (P_COSTADJUSTMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PCOSTOFPRODUCTION_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PCOSTOFPRODUCTION_MPRODUCTACCT foreign key (P_COSTOFPRODUCTION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PFLOORSTOCK_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PFLOORSTOCK_MPRODUCTACCT foreign key (P_FLOORSTOCK_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PINVENTORYCLEARING_MPRODUCTACC"
;

alter table M_PRODUCT_ACCT add constraint PINVENTORYCLEARING_MPRODUCTACC foreign key (P_INVENTORYCLEARING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PLABOR_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PLABOR_MPRODUCTACCT foreign key (P_LABOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PMETHODCHANGEVARIANCE_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint PMETHODCHANGEVARIANCE_MPRODUCT foreign key (P_METHODCHANGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PMIXVARIANCE_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PMIXVARIANCE_MPRODUCTACCT foreign key (P_MIXVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "POUTSIDEPROCESSING_MPRODUCTACC"
;

alter table M_PRODUCT_ACCT add constraint POUTSIDEPROCESSING_MPRODUCTACC foreign key (P_OUTSIDEPROCESSING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "POVERHEAD_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint POVERHEAD_MPRODUCTACCT foreign key (P_OVERHEAD_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PRATEVARIANCE_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PRATEVARIANCE_MPRODUCTACCT foreign key (P_RATEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PSCRAP_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PSCRAP_MPRODUCTACCT foreign key (P_SCRAP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PUSAGEVARIANCE_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PUSAGEVARIANCE_MPRODUCTACCT foreign key (P_USAGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "PWIP_MPRODUCTACCT"
;

alter table M_PRODUCT_ACCT add constraint PWIP_MPRODUCTACCT foreign key (P_WIP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PASSET_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PASSET_MPRODUCT foreign key (P_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PCOGS_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PCOGS_MPRODUCT foreign key (P_COGS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PEXPENSE_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PEXPENSE_MPRODUCT foreign key (P_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PINVOICEPV_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PINVOICEPV_MPRODUCT foreign key (P_INVOICEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PPURCHASEPV_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PPURCHASEPV_MPRODUCT foreign key (P_PURCHASEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PREVENUE_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PREVENUE_MPRODUCT foreign key (P_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PTDISCOUNTGRANT_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PTDISCOUNTGRANT_MPRODUCT foreign key (P_TRADEDISCOUNTGRANT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_ACCT drop constraint "VC_PTDISCOUNTREC_MPRODUCT"
;

alter table M_PRODUCT_ACCT add constraint VC_PTDISCOUNTREC_MPRODUCT foreign key (P_TRADEDISCOUNTREC_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_BOM_OLD drop constraint "MPRODUCT_BOMPRODUCT"
;

alter table M_PRODUCT_BOM_OLD add constraint MPRODUCT_BOMPRODUCT foreign key (M_PRODUCTBOM_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_BOM_OLD drop constraint "MPRODUCT_MPRODUCTBOM"
;

alter table M_PRODUCT_BOM_OLD add constraint MPRODUCT_MPRODUCTBOM foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY drop constraint "AASSETGROUP_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY add constraint AASSETGROUP_MPRODUCTCATEGORY foreign key (A_ASSET_GROUP_ID) references A_ASSET_GROUP(A_ASSET_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY drop constraint "ADPRINTCOLOR_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY add constraint ADPRINTCOLOR_MPRODUCTCATEGORY foreign key (AD_PRINTCOLOR_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY drop constraint "MPRODUCTCAT_PARENTCAT"
;

alter table M_PRODUCT_CATEGORY add constraint MPRODUCTCAT_PARENTCAT foreign key (M_PRODUCT_CATEGORY_PARENT_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "CACCTSCHEMA_MPRODCATACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint CACCTSCHEMA_MPRODCATACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "MPRODCAT_MPRODCATACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint MPRODCAT_MPRODCATACCT foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PAVERAGECOSTVARIANCE_MPRODUCTC"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PAVERAGECOSTVARIANCE_MPRODUCTC foreign key (P_AVERAGECOSTVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PBURDEN_MPRODUCTCATEGORYACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PBURDEN_MPRODUCTCATEGORYACCT foreign key (P_BURDEN_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PCOSTADJUSTMENT_MPRODUCTCATEGO"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PCOSTADJUSTMENT_MPRODUCTCATEGO foreign key (P_COSTADJUSTMENT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PCOSTOFPRODUCTION_MPRODUCTCATE"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PCOSTOFPRODUCTION_MPRODUCTCATE foreign key (P_COSTOFPRODUCTION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PFLOORSTOCK_MPRODUCTCATEGORYAC"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PFLOORSTOCK_MPRODUCTCATEGORYAC foreign key (P_FLOORSTOCK_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PINVENTORYCLEARING_MPRODUCTCAT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PINVENTORYCLEARING_MPRODUCTCAT foreign key (P_INVENTORYCLEARING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PLABOR_MPRODUCTCATEGORYACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PLABOR_MPRODUCTCATEGORYACCT foreign key (P_LABOR_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PMETHODCHANGEVARIANCE_MPRODCAT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PMETHODCHANGEVARIANCE_MPRODCAT foreign key (P_METHODCHANGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PMIXVARIANCE_MPRODUCTCATEGORYA"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PMIXVARIANCE_MPRODUCTCATEGORYA foreign key (P_MIXVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "POUTSIDEPROCESSING_MPRODUCTCAT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint POUTSIDEPROCESSING_MPRODUCTCAT foreign key (P_OUTSIDEPROCESSING_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "POVERHEAD_MPRODUCTCATEGORYACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint POVERHEAD_MPRODUCTCATEGORYACCT foreign key (P_OVERHEAD_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PRATEVARIANCE_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PRATEVARIANCE_MPRODUCTCATEGORY foreign key (P_RATEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PSCRAP_MPRODUCTCATEGORYACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PSCRAP_MPRODUCTCATEGORYACCT foreign key (P_SCRAP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PUSAGEVARIANCE_MPRODUCTCATEGOR"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PUSAGEVARIANCE_MPRODUCTCATEGOR foreign key (P_USAGEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "PWIP_MPRODUCTCATEGORYACCT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint PWIP_MPRODUCTCATEGORYACCT foreign key (P_WIP_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PASSET_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PASSET_MPRODUCTCATEGORY foreign key (P_ASSET_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PCOGS_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PCOGS_MPRODUCTCATEGORY foreign key (P_COGS_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PEXPENSE_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PEXPENSE_MPRODUCTCATEGORY foreign key (P_EXPENSE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PINVOICEPV_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PINVOICEPV_MPRODUCTCATEGORY foreign key (P_INVOICEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PPURCHASEPV_MPRODUCTCATEGOR"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PPURCHASEPV_MPRODUCTCATEGOR foreign key (P_PURCHASEPRICEVARIANCE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PREVENUE_MPRODUCTCATEGORY"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PREVENUE_MPRODUCTCATEGORY foreign key (P_REVENUE_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PTDISCOUNTGRANT_MPRODUCTCAT"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PTDISCOUNTGRANT_MPRODUCTCAT foreign key (P_TRADEDISCOUNTGRANT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_CATEGORY_ACCT drop constraint "VC_PTDISCOUNTREC_MPRODUCTCATEG"
;

alter table M_PRODUCT_CATEGORY_ACCT add constraint VC_PTDISCOUNTREC_MPRODUCTCATEG foreign key (P_TRADEDISCOUNTREC_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "CCURRENCY_MPRODUCTPO"
;

alter table M_PRODUCT_PO add constraint CCURRENCY_MPRODUCTPO foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "C_BUSPARTNER_M_PRODUCT_PO"
;

alter table M_PRODUCT_PO add constraint C_BUSPARTNER_M_PRODUCT_PO foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "C_UOM_M_PRODUCT_PO"
;

alter table M_PRODUCT_PO add constraint C_UOM_M_PRODUCT_PO foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "M_PRODUCTPO_CLIENT"
;

alter table M_PRODUCT_PO add constraint M_PRODUCTPO_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "M_PRODUCTPO_ORG"
;

alter table M_PRODUCT_PO add constraint M_PRODUCTPO_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_PO drop constraint "M_PRODUCT_PRODUCTPO"
;

alter table M_PRODUCT_PO add constraint M_PRODUCT_PRODUCTPO foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_QUALITYTEST drop constraint "MPRODUCT_MPRODUCTQUALITYTEST"
;

alter table M_PRODUCT_QUALITYTEST add constraint MPRODUCT_MPRODUCTQUALITYTEST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_QUALITYTEST drop constraint "MQUALITYTEST_MPRODUCTQUALITYTE"
;

alter table M_PRODUCT_QUALITYTEST add constraint MQUALITYTEST_MPRODUCTQUALITYTE foreign key (M_QUALITYTEST_ID) references M_QUALITYTEST(M_QUALITYTEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_TRL drop constraint "ADLANGUAGE_MPRODUCTTRL"
;

alter table M_PRODUCT_TRL add constraint ADLANGUAGE_MPRODUCTTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PRODUCT_TRL drop constraint "MPRODUCT_MPRODUCTTRL"
;

alter table M_PRODUCT_TRL add constraint MPRODUCT_MPRODUCTTRL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTION drop constraint "CCAMPAIGN_MPROMOTION"
;

alter table M_PROMOTION add constraint CCAMPAIGN_MPROMOTION foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONDISTRIBUTION drop constraint "MPROMOTIONLINE_MPROMOTIONDISTR"
;

alter table M_PROMOTIONDISTRIBUTION add constraint MPROMOTIONLINE_MPROMOTIONDISTR foreign key (M_PROMOTIONLINE_ID) references M_PROMOTIONLINE(M_PROMOTIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONDISTRIBUTION drop constraint "MPROMOTION_MPROMOTIONDISTRIBUT"
;

alter table M_PROMOTIONDISTRIBUTION add constraint MPROMOTION_MPROMOTIONDISTRIBUT foreign key (M_PROMOTION_ID) references M_PROMOTION(M_PROMOTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONGROUPLINE drop constraint "MPRODUCT_MPROMOTIONGROUPLINE"
;

alter table M_PROMOTIONGROUPLINE add constraint MPRODUCT_MPROMOTIONGROUPLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONGROUPLINE drop constraint "MPROMOTIONGROUP_MPROMOTIONGROU"
;

alter table M_PROMOTIONGROUPLINE add constraint MPROMOTIONGROUP_MPROMOTIONGROU foreign key (M_PROMOTIONGROUP_ID) references M_PROMOTIONGROUP(M_PROMOTIONGROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONLINE drop constraint "MPROMOTIONGROUP_MPROMOTIONLINE"
;

alter table M_PROMOTIONLINE add constraint MPROMOTIONGROUP_MPROMOTIONLINE foreign key (M_PROMOTIONGROUP_ID) references M_PROMOTIONGROUP(M_PROMOTIONGROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONLINE drop constraint "MPROMOTION_MPROMOTIONLINE"
;

alter table M_PROMOTIONLINE add constraint MPROMOTION_MPROMOTIONLINE foreign key (M_PROMOTION_ID) references M_PROMOTION(M_PROMOTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "CACTIVITY_MPROMOTIONPRECONDITI"
;

alter table M_PROMOTIONPRECONDITION add constraint CACTIVITY_MPROMOTIONPRECONDITI foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "CBPARTNER_MPROMOTIONPRECONDITI"
;

alter table M_PROMOTIONPRECONDITION add constraint CBPARTNER_MPROMOTIONPRECONDITI foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "CBPGROUP_MPROMOTIONPRECONDITIO"
;

alter table M_PROMOTIONPRECONDITION add constraint CBPGROUP_MPROMOTIONPRECONDITIO foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "MPRICELIST_MPROMOTIONPRECONDIT"
;

alter table M_PROMOTIONPRECONDITION add constraint MPRICELIST_MPROMOTIONPRECONDIT foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "MPROMOTION_MPROMOTIONPRECONDIT"
;

alter table M_PROMOTIONPRECONDITION add constraint MPROMOTION_MPROMOTIONPRECONDIT foreign key (M_PROMOTION_ID) references M_PROMOTION(M_PROMOTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONPRECONDITION drop constraint "MWAREHOUSE_MPROMOTIONPRECONDIT"
;

alter table M_PROMOTIONPRECONDITION add constraint MWAREHOUSE_MPROMOTIONPRECONDIT foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONREWARD drop constraint "CCHARGE_MPROMOTIONREWARD"
;

alter table M_PROMOTIONREWARD add constraint CCHARGE_MPROMOTIONREWARD foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONREWARD drop constraint "MPROMOTIONDISTRIBUTION_MPROMOT"
;

alter table M_PROMOTIONREWARD add constraint MPROMOTIONDISTRIBUTION_MPROMOT foreign key (M_PROMOTIONDISTRIBUTION_ID) references M_PROMOTIONDISTRIBUTION(M_PROMOTIONDISTRIBUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONREWARD drop constraint "MPROMOTION_MPROMOTIONREWARD"
;

alter table M_PROMOTIONREWARD add constraint MPROMOTION_MPROMOTIONREWARD foreign key (M_PROMOTION_ID) references M_PROMOTION(M_PROMOTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_PROMOTIONREWARD drop constraint "MTARGETDISTRIBUTION_MPROMOTION"
;

alter table M_PROMOTIONREWARD add constraint MTARGETDISTRIBUTION_MPROMOTION foreign key (M_TARGETDISTRIBUTION_ID) references M_PROMOTIONDISTRIBUTION(M_PROMOTIONDISTRIBUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_QUALITYTESTRESULT drop constraint "MATTRIBUTESETINSTANCE_MQUALITY"
;

alter table M_QUALITYTESTRESULT add constraint MATTRIBUTESETINSTANCE_MQUALITY foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_QUALITYTESTRESULT drop constraint "MQUALITYTEST_MQUALITYTESTRESUL"
;

alter table M_QUALITYTESTRESULT add constraint MQUALITYTEST_MQUALITYTESTRESUL foreign key (M_QUALITYTEST_ID) references M_QUALITYTEST(M_QUALITYTEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RELATEDPRODUCT drop constraint "MPRODUCT_MRELATEDPRODUCT"
;

alter table M_RELATEDPRODUCT add constraint MPRODUCT_MRELATEDPRODUCT foreign key (RELATEDPRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RELATEDPRODUCT drop constraint "MPRODUCT_MRELATED_PRODUCT"
;

alter table M_RELATEDPRODUCT add constraint MPRODUCT_MRELATED_PRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REPLENISH drop constraint "MLOCATOR_MREPLENISH"
;

alter table M_REPLENISH add constraint MLOCATOR_MREPLENISH foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REPLENISH drop constraint "MWAREHOUSESOURCE_MREPLENISH"
;

alter table M_REPLENISH add constraint MWAREHOUSESOURCE_MREPLENISH foreign key (M_WAREHOUSESOURCE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REPLENISH drop constraint "M_PRODUCT_REPLENISH"
;

alter table M_REPLENISH add constraint M_PRODUCT_REPLENISH foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REPLENISH drop constraint "M_WAREHOUSE_REPLENISH"
;

alter table M_REPLENISH add constraint M_WAREHOUSE_REPLENISH foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITION drop constraint "ADUSER_MREQUISITION"
;

alter table M_REQUISITION add constraint ADUSER_MREQUISITION foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITION drop constraint "CDOCTYPE_MREQUISITION"
;

alter table M_REQUISITION add constraint CDOCTYPE_MREQUISITION foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITION drop constraint "MPROCELIST_MREQUISITION"
;

alter table M_REQUISITION add constraint MPROCELIST_MREQUISITION foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITION drop constraint "MWAREHOUSE_MREQUISITION"
;

alter table M_REQUISITION add constraint MWAREHOUSE_MREQUISITION foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "CBPARTNER_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint CBPARTNER_MREQUISITIONLINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "CCHARGE_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint CCHARGE_MREQUISITIONLINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "CORDERLINE_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint CORDERLINE_MREQUISITIONLINE foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "CUOM_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint CUOM_MREQUISITIONLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "MATTRIBUTESETINSTANCE_MREQUISI"
;

alter table M_REQUISITIONLINE add constraint MATTRIBUTESETINSTANCE_MREQUISI foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "MPRODUCT_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint MPRODUCT_MREQUISITIONLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_REQUISITIONLINE drop constraint "MREQUISITION_MREQUISITIONLINE"
;

alter table M_REQUISITIONLINE add constraint MREQUISITION_MREQUISITIONLINE foreign key (M_REQUISITION_ID) references M_REQUISITION(M_REQUISITION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "CBPARTNER_MRMA"
;

alter table M_RMA add constraint CBPARTNER_MRMA foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "CCURRENCY_MRMA"
;

alter table M_RMA add constraint CCURRENCY_MRMA foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "CDOCTYPE_MRMA"
;

alter table M_RMA add constraint CDOCTYPE_MRMA foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "CORDER_MRMA"
;

alter table M_RMA add constraint CORDER_MRMA foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "MINOUT_MRMA"
;

alter table M_RMA add constraint MINOUT_MRMA foreign key (INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "MRMATYPE_MRMA"
;

alter table M_RMA add constraint MRMATYPE_MRMA foreign key (M_RMATYPE_ID) references M_RMATYPE(M_RMATYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "REFRMA_MRMA"
;

alter table M_RMA add constraint REFRMA_MRMA foreign key (REF_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMA drop constraint "SALESREP_MRMA"
;

alter table M_RMA add constraint SALESREP_MRMA foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMALINE drop constraint "CCHARGE_MRMALINE"
;

alter table M_RMALINE add constraint CCHARGE_MRMALINE foreign key (C_CHARGE_ID) references C_CHARGE(C_CHARGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMALINE drop constraint "MINOUTLINE_MRMALINE"
;

alter table M_RMALINE add constraint MINOUTLINE_MRMALINE foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMALINE drop constraint "MRMA_MRMALINE"
;

alter table M_RMALINE add constraint MRMA_MRMALINE foreign key (M_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_RMALINE drop constraint "REFRMALINE_MRMALINE"
;

alter table M_RMALINE add constraint REFRMALINE_MRMALINE foreign key (REF_RMALINE_ID) references M_RMALINE(M_RMALINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SERNOCTLEXCLUDE drop constraint "ADTABLE_MSERNOCTLEXCLUDE"
;

alter table M_SERNOCTLEXCLUDE add constraint ADTABLE_MSERNOCTLEXCLUDE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SERNOCTLEXCLUDE drop constraint "MSERNOCTL_MSERNOCTLEXCLUDE"
;

alter table M_SERNOCTLEXCLUDE add constraint MSERNOCTL_MSERNOCTLEXCLUDE foreign key (M_SERNOCTL_ID) references M_SERNOCTL(M_SERNOCTL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SHIPPER drop constraint "CBPARTNER_MSHIPPER"
;

alter table M_SHIPPER add constraint CBPARTNER_MSHIPPER foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SUBSTITUTE drop constraint "MPRODUCT_SUBSTITUTE"
;

alter table M_SUBSTITUTE add constraint MPRODUCT_SUBSTITUTE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SUBSTITUTE drop constraint "MPRODUCT_SUBSTITUTESUB"
;

alter table M_SUBSTITUTE add constraint MPRODUCT_SUBSTITUTESUB foreign key (SUBSTITUTE_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SUBSTITUTE drop constraint "M_SUBSTITUTE_CLIENT"
;

alter table M_SUBSTITUTE add constraint M_SUBSTITUTE_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_SUBSTITUTE drop constraint "M_SUBSTITUTE_ORG"
;

alter table M_SUBSTITUTE add constraint M_SUBSTITUTE_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "CPROJECTISSUE_MTRANSACTION"
;

alter table M_TRANSACTION add constraint CPROJECTISSUE_MTRANSACTION foreign key (C_PROJECTISSUE_ID) references C_PROJECTISSUE(C_PROJECTISSUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MATTRSETINST_MTRANSACTION"
;

alter table M_TRANSACTION add constraint MATTRSETINST_MTRANSACTION foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MINOUTLINE_MTRANSACTION"
;

alter table M_TRANSACTION add constraint MINOUTLINE_MTRANSACTION foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MINVENTORYLINE_MTRANSACTION"
;

alter table M_TRANSACTION add constraint MINVENTORYLINE_MTRANSACTION foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MLOCATOR_MINVENTORYCOUNT"
;

alter table M_TRANSACTION add constraint MLOCATOR_MINVENTORYCOUNT foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MMOVEMENTLINE_MTRANSACTION"
;

alter table M_TRANSACTION add constraint MMOVEMENTLINE_MTRANSACTION foreign key (M_MOVEMENTLINE_ID) references M_MOVEMENTLINE(M_MOVEMENTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MPRODUCTIONLINE_MTRANSACTION"
;

alter table M_TRANSACTION add constraint MPRODUCTIONLINE_MTRANSACTION foreign key (M_PRODUCTIONLINE_ID) references M_PRODUCTIONLINE(M_PRODUCTIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "MPRODUCT_MINVENTORYCOUNT"
;

alter table M_TRANSACTION add constraint MPRODUCT_MINVENTORYCOUNT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTION drop constraint "PPCOSTCOLLECTOR_MTRANSACTION"
;

alter table M_TRANSACTION add constraint PPCOSTCOLLECTOR_MTRANSACTION foreign key (PP_COST_COLLECTOR_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MATTRIBUTESETINST_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MATTRIBUTESETINST_MTRXALLOC foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MINOUTLINEOUT_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MINOUTLINEOUT_MTRXALLOC foreign key (OUT_M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MINOUTLINE_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MINOUTLINE_MTRXALLOC foreign key (M_INOUTLINE_ID) references M_INOUTLINE(M_INOUTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MINVENTORYLINEOUT_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MINVENTORYLINEOUT_MTRXALLOC foreign key (OUT_M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MINVENTORYLINE_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MINVENTORYLINE_MTRXALLOC foreign key (M_INVENTORYLINE_ID) references M_INVENTORYLINE(M_INVENTORYLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MPRODUCTIONLINEOUT_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MPRODUCTIONLINEOUT_MTRXALLOC foreign key (OUT_M_PRODUCTIONLINE_ID) references M_PRODUCTIONLINE(M_PRODUCTIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MPRODUCTIONLINE_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MPRODUCTIONLINE_MTRXALLOC foreign key (M_PRODUCTIONLINE_ID) references M_PRODUCTIONLINE(M_PRODUCTIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MPRODUCT_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MPRODUCT_MTRXALLOC foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MTRANSACTIONOUT_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MTRANSACTIONOUT_MTRXALLOC foreign key (OUT_M_TRANSACTION_ID) references M_TRANSACTION(M_TRANSACTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_TRANSACTIONALLOCATION drop constraint "MTTRANSACTION_MTRXALLOC"
;

alter table M_TRANSACTIONALLOCATION add constraint MTTRANSACTION_MTRXALLOC foreign key (M_TRANSACTION_ID) references M_TRANSACTION(M_TRANSACTION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE drop constraint "C_LOCATION_WAREHOUSE"
;

alter table M_WAREHOUSE add constraint C_LOCATION_WAREHOUSE foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE drop constraint "MWAREHOUSESOURCE_MWAREHOUSE"
;

alter table M_WAREHOUSE add constraint MWAREHOUSESOURCE_MWAREHOUSE foreign key (M_WAREHOUSESOURCE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE drop constraint "M_WAREHOUSE_CLIENT"
;

alter table M_WAREHOUSE add constraint M_WAREHOUSE_CLIENT foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE drop constraint "M_WAREHOUSE_ORG"
;

alter table M_WAREHOUSE add constraint M_WAREHOUSE_ORG foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "CACCTSCHEMA_MWAREHOUSEACCT"
;

alter table M_WAREHOUSE_ACCT add constraint CACCTSCHEMA_MWAREHOUSEACCT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "M_WAREHOUSE_WAREHOUSE_ACCT"
;

alter table M_WAREHOUSE_ACCT add constraint M_WAREHOUSE_WAREHOUSE_ACCT foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "VC_WDIFFERENCES_MWAREHOUSE"
;

alter table M_WAREHOUSE_ACCT add constraint VC_WDIFFERENCES_MWAREHOUSE foreign key (W_DIFFERENCES_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "VC_WINVACTUALADJUST_MWAREHOUSE"
;

alter table M_WAREHOUSE_ACCT add constraint VC_WINVACTUALADJUST_MWAREHOUSE foreign key (W_INVACTUALADJUST_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "VC_WINVENTORY_MWAREHOUSE"
;

alter table M_WAREHOUSE_ACCT add constraint VC_WINVENTORY_MWAREHOUSE foreign key (W_INVENTORY_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table M_WAREHOUSE_ACCT drop constraint "VC_WREVALUATION_MWAREHOUSE"
;

alter table M_WAREHOUSE_ACCT add constraint VC_WREVALUATION_MWAREHOUSE foreign key (W_REVALUATION_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_ACHIEVEMENT drop constraint "PAMEASURE_PAACHIEVEMENT"
;

alter table PA_ACHIEVEMENT add constraint PAMEASURE_PAACHIEVEMENT foreign key (PA_MEASURE_ID) references PA_MEASURE(PA_MEASURE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_BENCHMARKDATA drop constraint "PABENCHMARK_PABENCHMARKDATA"
;

alter table PA_BENCHMARKDATA add constraint PABENCHMARK_PABENCHMARKDATA foreign key (PA_BENCHMARK_ID) references PA_BENCHMARK(PA_BENCHMARK_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_COLORSCHEMA drop constraint "ADPRINTCOLOR1_PACOLORSCHEMA"
;

alter table PA_COLORSCHEMA add constraint ADPRINTCOLOR1_PACOLORSCHEMA foreign key (AD_PRINTCOLOR1_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_COLORSCHEMA drop constraint "ADPRINTCOLOR2_PACOLORSCHEMA"
;

alter table PA_COLORSCHEMA add constraint ADPRINTCOLOR2_PACOLORSCHEMA foreign key (AD_PRINTCOLOR2_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_COLORSCHEMA drop constraint "ADPRINTCOLOR3_PACOLORSCHEMA"
;

alter table PA_COLORSCHEMA add constraint ADPRINTCOLOR3_PACOLORSCHEMA foreign key (AD_PRINTCOLOR3_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_COLORSCHEMA drop constraint "ADPRINTCOLOR4_PACOLORSCHEMA"
;

alter table PA_COLORSCHEMA add constraint ADPRINTCOLOR4_PACOLORSCHEMA foreign key (AD_PRINTCOLOR4_ID) references AD_PRINTCOLOR(AD_PRINTCOLOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_COLORSCHEMA drop constraint "ENTITYT_PACOLORSCHEMA"
;

alter table PA_COLORSCHEMA add constraint ENTITYT_PACOLORSCHEMA foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT drop constraint "ADPROCESS_PADASHBOARDCONTENT"
;

alter table PA_DASHBOARDCONTENT add constraint ADPROCESS_PADASHBOARDCONTENT foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT drop constraint "ADROLE_PADASHBOARDCONTENT"
;

alter table PA_DASHBOARDCONTENT add constraint ADROLE_PADASHBOARDCONTENT foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT drop constraint "ADUSER_PADASHBOARDCONTENT"
;

alter table PA_DASHBOARDCONTENT add constraint ADUSER_PADASHBOARDCONTENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT drop constraint "ADWINDOW_PADASHBOARDCONTENT"
;

alter table PA_DASHBOARDCONTENT add constraint ADWINDOW_PADASHBOARDCONTENT foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT drop constraint "PAGOAL_PADASHBOARDCONTENT"
;

alter table PA_DASHBOARDCONTENT add constraint PAGOAL_PADASHBOARDCONTENT foreign key (PA_GOAL_ID) references PA_GOAL(PA_GOAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT_TRL drop constraint "ADLANGU_PADASHBOARDCONTENTTRL"
;

alter table PA_DASHBOARDCONTENT_TRL add constraint ADLANGU_PADASHBOARDCONTENTTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDCONTENT_TRL drop constraint "PADASHBOARDCONTENT_PADASHBOARD"
;

alter table PA_DASHBOARDCONTENT_TRL add constraint PADASHBOARDCONTENT_PADASHBOARD foreign key (PA_DASHBOARDCONTENT_ID) references PA_DASHBOARDCONTENT(PA_DASHBOARDCONTENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDPREFERENCE drop constraint "ADROLE_PADASHBOARDPREFERENCE"
;

alter table PA_DASHBOARDPREFERENCE add constraint ADROLE_PADASHBOARDPREFERENCE foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDPREFERENCE drop constraint "ADUSER_PADASHBOARDPREFERENCE"
;

alter table PA_DASHBOARDPREFERENCE add constraint ADUSER_PADASHBOARDPREFERENCE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_DASHBOARDPREFERENCE drop constraint "PADASHBOARDCONTENT_PADASHPREF"
;

alter table PA_DASHBOARDPREFERENCE add constraint PADASHBOARDCONTENT_PADASHPREF foreign key (PA_DASHBOARDCONTENT_ID) references PA_DASHBOARDCONTENT(PA_DASHBOARDCONTENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOAL drop constraint "ADROLE_PAGOAL"
;

alter table PA_GOAL add constraint ADROLE_PAGOAL foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOAL drop constraint "ADUSER_PAGOAL"
;

alter table PA_GOAL add constraint ADUSER_PAGOAL foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOAL drop constraint "PACOLORSCHEMA_PAGOAL"
;

alter table PA_GOAL add constraint PACOLORSCHEMA_PAGOAL foreign key (PA_COLORSCHEMA_ID) references PA_COLORSCHEMA(PA_COLORSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOAL drop constraint "PAGOALPARENT_PAGOAL"
;

alter table PA_GOAL add constraint PAGOALPARENT_PAGOAL foreign key (PA_GOALPARENT_ID) references PA_GOAL(PA_GOAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOAL drop constraint "PAMEASURE_PAGOAL"
;

alter table PA_GOAL add constraint PAMEASURE_PAGOAL foreign key (PA_MEASURE_ID) references PA_MEASURE(PA_MEASURE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "ADORG2_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint ADORG2_PAGOALRESTRICTION foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "ADORG_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint ADORG_PAGOALRESTRICTION foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "CBPARTNER_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint CBPARTNER_PAGOALRESTRICTION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "CBPGROUP_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint CBPGROUP_PAGOALRESTRICTION foreign key (C_BP_GROUP_ID) references C_BP_GROUP(C_BP_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "MPRODUCTCAT_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint MPRODUCTCAT_PAGOALRESTRICTION foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "MPRODUCT_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint MPRODUCT_PAGOALRESTRICTION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_GOALRESTRICTION drop constraint "PAGOAL_PAGOALRESTRICTION"
;

alter table PA_GOALRESTRICTION add constraint PAGOAL_PAGOALRESTRICTION foreign key (PA_GOAL_ID) references PA_GOAL(PA_GOAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEACCOUNT_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEACCOUNT_PAHIERARCHY foreign key (AD_TREE_ACCOUNT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEACTIVITY_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEACTIVITY_PAHIERARCHY foreign key (AD_TREE_ACTIVITY_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEBPARTNER_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEBPARTNER_PAHIERARCHY foreign key (AD_TREE_BPARTNER_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREECAMPAIGN_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREECAMPAIGN_PAHIERARCHY foreign key (AD_TREE_CAMPAIGN_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEORG_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEORG_PAHIERARCHY foreign key (AD_TREE_ORG_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEPRODUCT_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEPRODUCT_PAHIERARCHY foreign key (AD_TREE_PRODUCT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREEPROJECT_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREEPROJECT_PAHIERARCHY foreign key (AD_TREE_PROJECT_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_HIERARCHY drop constraint "ADTREESR_PAHIERARCHY"
;

alter table PA_HIERARCHY add constraint ADTREESR_PAHIERARCHY foreign key (AD_TREE_SALESREGION_ID) references AD_TREE(AD_TREE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "CPROJECTTYPE_PAMEASURE"
;

alter table PA_MEASURE add constraint CPROJECTTYPE_PAMEASURE foreign key (C_PROJECTTYPE_ID) references C_PROJECTTYPE(C_PROJECTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "PABENCHMARK_PAMEASURE"
;

alter table PA_MEASURE add constraint PABENCHMARK_PAMEASURE foreign key (PA_BENCHMARK_ID) references PA_BENCHMARK(PA_BENCHMARK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "PAHIERARCHY_PAMEASURE"
;

alter table PA_MEASURE add constraint PAHIERARCHY_PAMEASURE foreign key (PA_HIERARCHY_ID) references PA_HIERARCHY(PA_HIERARCHY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "PAMEASURECALC_PAMEASURE"
;

alter table PA_MEASURE add constraint PAMEASURECALC_PAMEASURE foreign key (PA_MEASURECALC_ID) references PA_MEASURECALC(PA_MEASURECALC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "PARATIO_PAMEASURE"
;

alter table PA_MEASURE add constraint PARATIO_PAMEASURE foreign key (PA_RATIO_ID) references PA_RATIO(PA_RATIO_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURE drop constraint "RREQUESTTYPE_PAMEASURE"
;

alter table PA_MEASURE add constraint RREQUESTTYPE_PAMEASURE foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURECALC drop constraint "ADTABLE_PAMEASURECALC"
;

alter table PA_MEASURECALC add constraint ADTABLE_PAMEASURECALC foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_MEASURECALC drop constraint "ENTITYT_PAMEASURECALC"
;

alter table PA_MEASURECALC add constraint ENTITYT_PAMEASURECALC foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_RATIO drop constraint "CACCTSCHEMA_PARATIO"
;

alter table PA_RATIO add constraint CACCTSCHEMA_PARATIO foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_RATIOELEMENT drop constraint "CELEMENTVALUE_PARATIOELEMENT"
;

alter table PA_RATIOELEMENT add constraint CELEMENTVALUE_PARATIOELEMENT foreign key (ACCOUNT_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_RATIOELEMENT drop constraint "PAMEASURECALC_PARATIOELEMENT"
;

alter table PA_RATIOELEMENT add constraint PAMEASURECALC_PARATIOELEMENT foreign key (PA_MEASURECALC_ID) references PA_MEASURECALC(PA_MEASURECALC_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_RATIOELEMENT drop constraint "PARATIOUSED_PARATIOELEMENT"
;

alter table PA_RATIOELEMENT add constraint PARATIOUSED_PARATIOELEMENT foreign key (PA_RATIOUSED_ID) references PA_RATIO(PA_RATIO_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_RATIOELEMENT drop constraint "PARATIO_PARATIOELEMENT"
;

alter table PA_RATIOELEMENT add constraint PARATIO_PARATIOELEMENT foreign key (PA_RATIO_ID) references PA_RATIO(PA_RATIO_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "ADORG_PAREPORT"
;

alter table PA_REPORT add constraint ADORG_PAREPORT foreign key (AD_ORG_ID) references AD_ORG(AD_ORG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "ADPRINTFORMAT_PAREPORT"
;

alter table PA_REPORT add constraint ADPRINTFORMAT_PAREPORT foreign key (AD_PRINTFORMAT_ID) references AD_PRINTFORMAT(AD_PRINTFORMAT_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "CACCTSCHEMA_PAREPORT"
;

alter table PA_REPORT add constraint CACCTSCHEMA_PAREPORT foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "CCALENDAR_PAREPORT"
;

alter table PA_REPORT add constraint CCALENDAR_PAREPORT foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "JASPERPROCESS_PAREPORT"
;

alter table PA_REPORT add constraint JASPERPROCESS_PAREPORT foreign key (JASPERPROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "PAREPORTCUBE_PAREPORT"
;

alter table PA_REPORT add constraint PAREPORTCUBE_PAREPORT foreign key (PA_REPORTCUBE_ID) references PA_REPORTCUBE(PA_REPORTCUBE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "PAREPORT_COLUMNSET"
;

alter table PA_REPORT add constraint PAREPORT_COLUMNSET foreign key (PA_REPORTCOLUMNSET_ID) references PA_REPORTCOLUMNSET(PA_REPORTCOLUMNSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORT drop constraint "PAREPORT_LINESET"
;

alter table PA_REPORT add constraint PAREPORT_LINESET foreign key (PA_REPORTLINESET_ID) references PA_REPORTLINESET(PA_REPORTLINESET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "ADORGTRX_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint ADORGTRX_PAREPORTCOLUMN foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "ADORG_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint ADORG_PAREPORTCOLUMN foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CACTIVITY_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CACTIVITY_PAREPORTCOLUMN foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CBPARTNER_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CBPARTNER_PAREPORTCOLUMN foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CCAMPAIGN_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CCAMPAIGN_PAREPORTCOLUMN foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CCURRENCY_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CCURRENCY_PAREPORTCOLUMN foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CELEMENTVALUE_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CELEMENTVALUE_PAREPORTCOLUMN foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CLOCATION_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CLOCATION_PAREPORTCOLUMN foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CPROJECT_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CPROJECT_PAREPORTCOLUMN foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "CSALESREGION_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint CSALESREGION_PAREPORTCOLUMN foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "GLBUDGET_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint GLBUDGET_PAREPORTCOLUMN foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "MPRODUCT_PAREPORTCOLUMN"
;

alter table PA_REPORTCOLUMN add constraint MPRODUCT_PAREPORTCOLUMN foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "PAREPORTCOLUMNSET_COLUMN"
;

alter table PA_REPORTCOLUMN add constraint PAREPORTCOLUMNSET_COLUMN foreign key (PA_REPORTCOLUMNSET_ID) references PA_REPORTCOLUMNSET(PA_REPORTCOLUMNSET_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "PAREPORTCOLUMN_OPER1"
;

alter table PA_REPORTCOLUMN add constraint PAREPORTCOLUMN_OPER1 foreign key (OPER_1_ID) references PA_REPORTCOLUMN(PA_REPORTCOLUMN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCOLUMN drop constraint "PAREPORTCOLUMN_OPER2"
;

alter table PA_REPORTCOLUMN add constraint PAREPORTCOLUMN_OPER2 foreign key (OPER_2_ID) references PA_REPORTCOLUMN(PA_REPORTCOLUMN_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTCUBE drop constraint "CCALENDAR_PAREPORTCUBE"
;

alter table PA_REPORTCUBE add constraint CCALENDAR_PAREPORTCUBE foreign key (C_CALENDAR_ID) references C_CALENDAR(C_CALENDAR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTLINE drop constraint "GLBUDGET_PAREPORTLINE"
;

alter table PA_REPORTLINE add constraint GLBUDGET_PAREPORTLINE foreign key (GL_BUDGET_ID) references GL_BUDGET(GL_BUDGET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTLINE drop constraint "PAREPORTLINESET_LINE"
;

alter table PA_REPORTLINE add constraint PAREPORTLINESET_LINE foreign key (PA_REPORTLINESET_ID) references PA_REPORTLINESET(PA_REPORTLINESET_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTLINE drop constraint "PAREPORTLINE_OPER1"
;

alter table PA_REPORTLINE add constraint PAREPORTLINE_OPER1 foreign key (OPER_1_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTLINE drop constraint "PAREPORTLINE_OPER2"
;

alter table PA_REPORTLINE add constraint PAREPORTLINE_OPER2 foreign key (OPER_2_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTLINE drop constraint "PAREPORTLINE_PARENT"
;

alter table PA_REPORTLINE add constraint PAREPORTLINE_PARENT foreign key (PARENT_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE SET NULL INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "ADORGTRX_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint ADORGTRX_PAREPORTSOURCE foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "ADORG_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint ADORG_PAREPORTSOURCE foreign key (ORG_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CACTIVITY_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CACTIVITY_PAREPORTSOURCE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CBPARTNER_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CBPARTNER_PAREPORTSOURCE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CCAMPAIGN_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CCAMPAIGN_PAREPORTSOURCE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CELEMENTVALUE_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CELEMENTVALUE_PAREPORTSOURCE foreign key (C_ELEMENTVALUE_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CLOCATION_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CLOCATION_PAREPORTSOURCE foreign key (C_LOCATION_ID) references C_LOCATION(C_LOCATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CPROJECT_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CPROJECT_PAREPORTSOURCE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "CSALESREGION_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint CSALESREGION_PAREPORTSOURCE foreign key (C_SALESREGION_ID) references C_SALESREGION(C_SALESREGION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "MPRODUCT_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint MPRODUCT_PAREPORTSOURCE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_REPORTSOURCE drop constraint "PAREPORTLINE_PAREPORTSOURCE"
;

alter table PA_REPORTSOURCE add constraint PAREPORTLINE_PAREPORTSOURCE foreign key (PA_REPORTLINE_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_SLA_GOAL drop constraint "CBPARTNER_PASLAGOAL"
;

alter table PA_SLA_GOAL add constraint CBPARTNER_PASLAGOAL foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_SLA_GOAL drop constraint "PASLACRITERIA_PASLAGOAL"
;

alter table PA_SLA_GOAL add constraint PASLACRITERIA_PASLAGOAL foreign key (PA_SLA_CRITERIA_ID) references PA_SLA_CRITERIA(PA_SLA_CRITERIA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_SLA_MEASURE drop constraint "ADTABLE_PASLAMEASURE"
;

alter table PA_SLA_MEASURE add constraint ADTABLE_PASLAMEASURE foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PA_SLA_MEASURE drop constraint "PASLAGOAL_PASLAMEASURE"
;

alter table PA_SLA_MEASURE add constraint PASLAGOAL_PASLAMEASURE foreign key (PA_SLA_GOAL_ID) references PA_SLA_GOAL(PA_SLA_GOAL_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "ADORGTRX_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint ADORGTRX_PPCOSTCOLLECTOR foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "ADUSER_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint ADUSER_PPCOSTCOLLECTOR foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CACTIVITY_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CACTIVITY_PPCOSTCOLLECTOR foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CCAMPAIGN_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CCAMPAIGN_PPCOSTCOLLECTOR foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CDOCTYPETARGET_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CDOCTYPETARGET_PPCOSTCOLLECTOR foreign key (C_DOCTYPETARGET_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CDOCTYPE_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CDOCTYPE_PPCOSTCOLLECTOR foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CPROJECT_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CPROJECT_PPCOSTCOLLECTOR foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "CUOM_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint CUOM_PPCOSTCOLLECTOR foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "MATTRIBUTESETINSTANCE_PPCOSTCO"
;

alter table PP_COST_COLLECTOR add constraint MATTRIBUTESETINSTANCE_PPCOSTCO foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "MLOCATOR_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint MLOCATOR_PPCOSTCOLLECTOR foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "MPRODUCT_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint MPRODUCT_PPCOSTCOLLECTOR foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "MWAREHOUSE_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint MWAREHOUSE_PPCOSTCOLLECTOR foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "PPORDERBOMLINE_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint PPORDERBOMLINE_PPCOSTCOLLECTOR foreign key (PP_ORDER_BOMLINE_ID) references PP_ORDER_BOMLINE(PP_ORDER_BOMLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "PPORDERNODE_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint PPORDERNODE_PPCOSTCOLLECTOR foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "PPORDERWORKFLOW_PPCOSTCOLLECTO"
;

alter table PP_COST_COLLECTOR add constraint PPORDERWORKFLOW_PPCOSTCOLLECTO foreign key (PP_ORDER_WORKFLOW_ID) references PP_ORDER_WORKFLOW(PP_ORDER_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "PPORDER_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint PPORDER_PPCOSTCOLLECTOR foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "REVERSAL_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint REVERSAL_PPCOSTCOLLECTOR foreign key (REVERSAL_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "SRESOURCE_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint SRESOURCE_PPCOSTCOLLECTOR foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "USER1_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint USER1_PPCOSTCOLLECTOR foreign key (USER1_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTOR drop constraint "USER2_PPCOSTCOLLECTOR"
;

alter table PP_COST_COLLECTOR add constraint USER2_PPCOSTCOLLECTOR foreign key (USER2_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTORMA drop constraint "MATTRIBUTESETINSTANCE_PPCOSTMA"
;

alter table PP_COST_COLLECTORMA add constraint MATTRIBUTESETINSTANCE_PPCOSTMA foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_COST_COLLECTORMA drop constraint "PPCOSTCOLLECTOR_PPCCMA"
;

alter table PP_COST_COLLECTORMA add constraint PPCOSTCOLLECTOR_PPCCMA foreign key (PP_COST_COLLECTOR_ID) references PP_COST_COLLECTOR(PP_COST_COLLECTOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "CBPARTNER_PPMRP"
;

alter table PP_MRP add constraint CBPARTNER_PPMRP foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "CORDERLINE_PPMRP"
;

alter table PP_MRP add constraint CORDERLINE_PPMRP foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "CORDER_PPMRP"
;

alter table PP_MRP add constraint CORDER_PPMRP foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "DDORDERLINE_PPMRP"
;

alter table PP_MRP add constraint DDORDERLINE_PPMRP foreign key (DD_ORDERLINE_ID) references DD_ORDERLINE(DD_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "DDORDER_PPMRP"
;

alter table PP_MRP add constraint DDORDER_PPMRP foreign key (DD_ORDER_ID) references DD_ORDER(DD_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MFORECASTLINE_PPMRP"
;

alter table PP_MRP add constraint MFORECASTLINE_PPMRP foreign key (M_FORECASTLINE_ID) references M_FORECASTLINE(M_FORECASTLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MFORECAST_PPMRP"
;

alter table PP_MRP add constraint MFORECAST_PPMRP foreign key (M_FORECAST_ID) references M_FORECAST(M_FORECAST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MPRODUCT_PPMRP"
;

alter table PP_MRP add constraint MPRODUCT_PPMRP foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MREQUISITIONLINE_PPMRP"
;

alter table PP_MRP add constraint MREQUISITIONLINE_PPMRP foreign key (M_REQUISITIONLINE_ID) references M_REQUISITIONLINE(M_REQUISITIONLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MREQUISITION_PPMRP"
;

alter table PP_MRP add constraint MREQUISITION_PPMRP foreign key (M_REQUISITION_ID) references M_REQUISITION(M_REQUISITION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "MWAREHOUSE_PPMRP"
;

alter table PP_MRP add constraint MWAREHOUSE_PPMRP foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "PLANNER_PPMRP"
;

alter table PP_MRP add constraint PLANNER_PPMRP foreign key (PLANNER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "PPORDERBOMLINE_PPMRP"
;

alter table PP_MRP add constraint PPORDERBOMLINE_PPMRP foreign key (PP_ORDER_BOMLINE_ID) references PP_ORDER_BOMLINE(PP_ORDER_BOMLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "PPORDER_PPMRP"
;

alter table PP_MRP add constraint PPORDER_PPMRP foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_MRP drop constraint "SRESOURCE_PPMRP"
;

alter table PP_MRP add constraint SRESOURCE_PPMRP foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "ADORGTRX_PPORDER"
;

alter table PP_ORDER add constraint ADORGTRX_PPORDER foreign key (AD_ORGTRX_ID) references AD_ORG(AD_ORG_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "ADWORKFLOW_PPORDER"
;

alter table PP_ORDER add constraint ADWORKFLOW_PPORDER foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CACTIVITY_PPORDER"
;

alter table PP_ORDER add constraint CACTIVITY_PPORDER foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CCAMPAIGN_PPORDER"
;

alter table PP_ORDER add constraint CCAMPAIGN_PPORDER foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CDOCTYPETARGET_PPORDER"
;

alter table PP_ORDER add constraint CDOCTYPETARGET_PPORDER foreign key (C_DOCTYPETARGET_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CDOCTYPE_PPORDER"
;

alter table PP_ORDER add constraint CDOCTYPE_PPORDER foreign key (C_DOCTYPE_ID) references C_DOCTYPE(C_DOCTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CORDERLINE_PPORDER"
;

alter table PP_ORDER add constraint CORDERLINE_PPORDER foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CPROJECT_PPORDER"
;

alter table PP_ORDER add constraint CPROJECT_PPORDER foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "CUOM_PPORDER"
;

alter table PP_ORDER add constraint CUOM_PPORDER foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "MATTRIBUTESETINSTANCE_PPORDER"
;

alter table PP_ORDER add constraint MATTRIBUTESETINSTANCE_PPORDER foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "MPRODUCT_PPORDER"
;

alter table PP_ORDER add constraint MPRODUCT_PPORDER foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "MWAREHOUSE_PPORDER"
;

alter table PP_ORDER add constraint MWAREHOUSE_PPORDER foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "PLANNER_PPORDER"
;

alter table PP_ORDER add constraint PLANNER_PPORDER foreign key (PLANNER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "PPPRODUCTBOM_PPORDER"
;

alter table PP_ORDER add constraint PPPRODUCTBOM_PPORDER foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "SRESOURCE_PPORDER"
;

alter table PP_ORDER add constraint SRESOURCE_PPORDER foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "USER1_PPORDER"
;

alter table PP_ORDER add constraint USER1_PPORDER foreign key (USER1_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER drop constraint "USER2_PPORDER"
;

alter table PP_ORDER add constraint USER2_PPORDER foreign key (USER2_ID) references C_ELEMENTVALUE(C_ELEMENTVALUE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM drop constraint "CUOM_PPORDERBOM"
;

alter table PP_ORDER_BOM add constraint CUOM_PPORDERBOM foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM drop constraint "MATTRIBUTESETINSTANCE_PPORDERB"
;

alter table PP_ORDER_BOM add constraint MATTRIBUTESETINSTANCE_PPORDERB foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM drop constraint "MCHANGENOTICE_PPORDERBOM"
;

alter table PP_ORDER_BOM add constraint MCHANGENOTICE_PPORDERBOM foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM drop constraint "MPRODUCT_PPORDERBOM"
;

alter table PP_ORDER_BOM add constraint MPRODUCT_PPORDERBOM foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM drop constraint "PPORDER_PPORDERBOM"
;

alter table PP_ORDER_BOM add constraint PPORDER_PPORDERBOM foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "ADUSER_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint ADUSER_PPORDERBOMLINE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "CUOM_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint CUOM_PPORDERBOMLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "MATTRIBUTESETINSTANCE_PPORDBL"
;

alter table PP_ORDER_BOMLINE add constraint MATTRIBUTESETINSTANCE_PPORDBL foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "MCHANGENOTICE_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint MCHANGENOTICE_PPORDERBOMLINE foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "MLOCATOR_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint MLOCATOR_PPORDERBOMLINE foreign key (M_LOCATOR_ID) references M_LOCATOR(M_LOCATOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "MPRODUCT_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint MPRODUCT_PPORDERBOMLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "MWAREHOUSE_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint MWAREHOUSE_PPORDERBOMLINE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "PPORDERBOM_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint PPORDERBOM_PPORDERBOMLINE foreign key (PP_ORDER_BOM_ID) references PP_ORDER_BOM(PP_ORDER_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE drop constraint "PPORDER_PPORDERBOMLINE"
;

alter table PP_ORDER_BOMLINE add constraint PPORDER_PPORDERBOMLINE foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE_TRL drop constraint "ADLANGU_PPORDERBOMLINETRL"
;

alter table PP_ORDER_BOMLINE_TRL add constraint ADLANGU_PPORDERBOMLINETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOMLINE_TRL drop constraint "PPORDERBOMLINE_PPORDERBOMLINET"
;

alter table PP_ORDER_BOMLINE_TRL add constraint PPORDERBOMLINE_PPORDERBOMLINET foreign key (PP_ORDER_BOMLINE_ID) references PP_ORDER_BOMLINE(PP_ORDER_BOMLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM_TRL drop constraint "ADLANGU_PPORDERBOMTRL"
;

alter table PP_ORDER_BOM_TRL add constraint ADLANGU_PPORDERBOMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_BOM_TRL drop constraint "PPORDERBOM_PPORDERBOMTRL"
;

alter table PP_ORDER_BOM_TRL add constraint PPORDERBOM_PPORDERBOMTRL foreign key (PP_ORDER_BOM_ID) references PP_ORDER_BOM(PP_ORDER_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "ADWORKFLOW_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint ADWORKFLOW_PPORDERCOST foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "CACCTSCHEMA_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint CACCTSCHEMA_PPORDERCOST foreign key (C_ACCTSCHEMA_ID) references C_ACCTSCHEMA(C_ACCTSCHEMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "MATTRIBUTESETINSTANCE_PPORDERC"
;

alter table PP_ORDER_COST add constraint MATTRIBUTESETINSTANCE_PPORDERC foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "MCOSTELEMENT_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint MCOSTELEMENT_PPORDERCOST foreign key (M_COSTELEMENT_ID) references M_COSTELEMENT(M_COSTELEMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "MCOSTTYPE_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint MCOSTTYPE_PPORDERCOST foreign key (M_COSTTYPE_ID) references M_COSTTYPE(M_COSTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "MPRODUCT_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint MPRODUCT_PPORDERCOST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_COST drop constraint "PPORDER_PPORDERCOST"
;

alter table PP_ORDER_COST add constraint PPORDER_PPORDERCOST foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADCOLUMN_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADCOLUMN_PPORDERNODE foreign key (AD_COLUMN_ID) references AD_COLUMN(AD_COLUMN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADFORM_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADFORM_PPORDERNODE foreign key (AD_FORM_ID) references AD_FORM(AD_FORM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADIMAGE_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADIMAGE_PPORDERNODE foreign key (AD_IMAGE_ID) references AD_IMAGE(AD_IMAGE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADPROCESS_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADPROCESS_PPORDERNODE foreign key (AD_PROCESS_ID) references AD_PROCESS(AD_PROCESS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADTASK_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADTASK_PPORDERNODE foreign key (AD_TASK_ID) references AD_TASK(AD_TASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADWFBLOCK_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADWFBLOCK_PPORDERNODE foreign key (AD_WF_BLOCK_ID) references AD_WF_BLOCK(AD_WF_BLOCK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADWFNODE_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADWFNODE_PPORDERNODE foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADWFRESPONSIBLE_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADWFRESPONSIBLE_PPORDERNODE foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADWINDOW_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADWINDOW_PPORDERNODE foreign key (AD_WINDOW_ID) references AD_WINDOW(AD_WINDOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ADWORKFLOW_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ADWORKFLOW_PPORDERNODE foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "CBPARTNER_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint CBPARTNER_PPORDERNODE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "ENTITYT_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint ENTITYT_PPORDERNODE foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "PPORDERWORKFLOW_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint PPORDERWORKFLOW_PPORDERNODE foreign key (PP_ORDER_WORKFLOW_ID) references PP_ORDER_WORKFLOW(PP_ORDER_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "PPORDER_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint PPORDER_PPORDERNODE foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "SRESOURCE_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint SRESOURCE_PPORDERNODE foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE drop constraint "WORKFLOW_PPORDERNODE"
;

alter table PP_ORDER_NODE add constraint WORKFLOW_PPORDERNODE foreign key (WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "ADWFNEXT_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint ADWFNEXT_PPORDERNODENEXT foreign key (AD_WF_NEXT_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "ADWFNODE_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint ADWFNODE_PPORDERNODENEXT foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "ENTITYT_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint ENTITYT_PPORDERNODENEXT foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "PPORDERNEXT_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint PPORDERNEXT_PPORDERNODENEXT foreign key (PP_ORDER_NEXT_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "PPORDERNODE_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint PPORDERNODE_PPORDERNODENEXT foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODENEXT drop constraint "PPORDER_PPORDERNODENEXT"
;

alter table PP_ORDER_NODENEXT add constraint PPORDER_PPORDERNODENEXT foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_ASSET drop constraint "AASSET_PPORDERNODEASSET"
;

alter table PP_ORDER_NODE_ASSET add constraint AASSET_PPORDERNODEASSET foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_ASSET drop constraint "PPORDERNODE_PPORDERNODEASSET"
;

alter table PP_ORDER_NODE_ASSET add constraint PPORDERNODE_PPORDERNODEASSET foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_ASSET drop constraint "PPORDERWORKFLOW_PPORDERNODEASS"
;

alter table PP_ORDER_NODE_ASSET add constraint PPORDERWORKFLOW_PPORDERNODEASS foreign key (PP_ORDER_WORKFLOW_ID) references PP_ORDER_WORKFLOW(PP_ORDER_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_ASSET drop constraint "PPORDER_PPORDERNODEASSET"
;

alter table PP_ORDER_NODE_ASSET add constraint PPORDER_PPORDERNODEASSET foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_PRODUCT drop constraint "MPRODUCT_PPORDERNODEPRODUCT"
;

alter table PP_ORDER_NODE_PRODUCT add constraint MPRODUCT_PPORDERNODEPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_PRODUCT drop constraint "PPORDERNODE_PPORDERNODEPRODUCT"
;

alter table PP_ORDER_NODE_PRODUCT add constraint PPORDERNODE_PPORDERNODEPRODUCT foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_PRODUCT drop constraint "PPORDERWORKFLOW_PPORDERNODEPRO"
;

alter table PP_ORDER_NODE_PRODUCT add constraint PPORDERWORKFLOW_PPORDERNODEPRO foreign key (PP_ORDER_WORKFLOW_ID) references PP_ORDER_WORKFLOW(PP_ORDER_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_PRODUCT drop constraint "PPORDER_PPORDERNODEPRODUCT"
;

alter table PP_ORDER_NODE_PRODUCT add constraint PPORDER_PPORDERNODEPRODUCT foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_TRL drop constraint "ADLANGU_PPORDERNODETRL"
;

alter table PP_ORDER_NODE_TRL add constraint ADLANGU_PPORDERNODETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_NODE_TRL drop constraint "PPORDERNODE_PPORDERNODETRL"
;

alter table PP_ORDER_NODE_TRL add constraint PPORDERNODE_PPORDERNODETRL foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ADTABLE_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint ADTABLE_PPORDERWORKFLOW foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ADWFNODE_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint ADWFNODE_PPORDERWORKFLOW foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ADWFRESPONSIBLE_PPORDERWORKFLO"
;

alter table PP_ORDER_WORKFLOW add constraint ADWFRESPONSIBLE_PPORDERWORKFLO foreign key (AD_WF_RESPONSIBLE_ID) references AD_WF_RESPONSIBLE(AD_WF_RESPONSIBLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ADWORKFLOWPROCESSOR_PPORDERWOR"
;

alter table PP_ORDER_WORKFLOW add constraint ADWORKFLOWPROCESSOR_PPORDERWOR foreign key (AD_WORKFLOWPROCESSOR_ID) references AD_WORKFLOWPROCESSOR(AD_WORKFLOWPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ADWORKFLOW_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint ADWORKFLOW_PPORDERWORKFLOW foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "ENTITYT_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint ENTITYT_PPORDERWORKFLOW foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "PPORDERNODE_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint PPORDERNODE_PPORDERWORKFLOW foreign key (PP_ORDER_NODE_ID) references PP_ORDER_NODE(PP_ORDER_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "PPORDER_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint PPORDER_PPORDERWORKFLOW foreign key (PP_ORDER_ID) references PP_ORDER(PP_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW drop constraint "SRESOURCE_PPORDERWORKFLOW"
;

alter table PP_ORDER_WORKFLOW add constraint SRESOURCE_PPORDERWORKFLOW foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW_TRL drop constraint "ADLANGU_PPORDERWORKFLOWTRL"
;

alter table PP_ORDER_WORKFLOW_TRL add constraint ADLANGU_PPORDERWORKFLOWTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_ORDER_WORKFLOW_TRL drop constraint "PPORDERWORKFLOW_PPORDERWORKFLO"
;

alter table PP_ORDER_WORKFLOW_TRL add constraint PPORDERWORKFLOW_PPORDERWORKFLO foreign key (PP_ORDER_WORKFLOW_ID) references PP_ORDER_WORKFLOW(PP_ORDER_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM drop constraint "CUOM_PPPRODUCTBOM"
;

alter table PP_PRODUCT_BOM add constraint CUOM_PPPRODUCTBOM foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM drop constraint "MATTRIBUTESETINSTANCE_PPPRODUC"
;

alter table PP_PRODUCT_BOM add constraint MATTRIBUTESETINSTANCE_PPPRODUC foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM drop constraint "MCHANGENOTICE_PPPRODUCTBOM"
;

alter table PP_PRODUCT_BOM add constraint MCHANGENOTICE_PPPRODUCTBOM foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM drop constraint "MPRODUCT_PPPRODUCTBOM"
;

alter table PP_PRODUCT_BOM add constraint MPRODUCT_PPPRODUCTBOM foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE drop constraint "CUOM_PPPRODUCTBOMLINE"
;

alter table PP_PRODUCT_BOMLINE add constraint CUOM_PPPRODUCTBOMLINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE drop constraint "MATTRIBUTESETINSTANCE_PPPRODBL"
;

alter table PP_PRODUCT_BOMLINE add constraint MATTRIBUTESETINSTANCE_PPPRODBL foreign key (M_ATTRIBUTESETINSTANCE_ID) references M_ATTRIBUTESETINSTANCE(M_ATTRIBUTESETINSTANCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE drop constraint "MCHANGENOTICE_PPPRODUCTBOMLINE"
;

alter table PP_PRODUCT_BOMLINE add constraint MCHANGENOTICE_PPPRODUCTBOMLINE foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE drop constraint "MPRODUCT_PPPRODUCTBOMLINE"
;

alter table PP_PRODUCT_BOMLINE add constraint MPRODUCT_PPPRODUCTBOMLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE drop constraint "PPPRODUCTBOM_PPPRODUCTBOMLINE"
;

alter table PP_PRODUCT_BOMLINE add constraint PPPRODUCTBOM_PPPRODUCTBOMLINE foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE_TRL drop constraint "ADLANGU_PPPRODUCTBOMLINETRL"
;

alter table PP_PRODUCT_BOMLINE_TRL add constraint ADLANGU_PPPRODUCTBOMLINETRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOMLINE_TRL drop constraint "PPPRODUCTBOMLINE_PPPRODUCTBOML"
;

alter table PP_PRODUCT_BOMLINE_TRL add constraint PPPRODUCTBOMLINE_PPPRODUCTBOML foreign key (PP_PRODUCT_BOMLINE_ID) references PP_PRODUCT_BOMLINE(PP_PRODUCT_BOMLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM_TRL drop constraint "ADLANGU_PPPRODUCTBOMTRL"
;

alter table PP_PRODUCT_BOM_TRL add constraint ADLANGU_PPPRODUCTBOMTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_BOM_TRL drop constraint "PPPRODUCTBOM_PPPRODUCTBOMTRL"
;

alter table PP_PRODUCT_BOM_TRL add constraint PPPRODUCTBOM_PPPRODUCTBOMTRL foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "ADWORKFLOW_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint ADWORKFLOW_PPPRODUCTPLANNING foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "DDNETWORKDISTRIBUTION_PPPRODUC"
;

alter table PP_PRODUCT_PLANNING add constraint DDNETWORKDISTRIBUTION_PPPRODUC foreign key (DD_NETWORKDISTRIBUTION_ID) references DD_NETWORKDISTRIBUTION(DD_NETWORKDISTRIBUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "MPRODUCT_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint MPRODUCT_PPPRODUCTPLANNING foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "MWAREHOUSE_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint MWAREHOUSE_PPPRODUCTPLANNING foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "PLANNER_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint PLANNER_PPPRODUCTPLANNING foreign key (PLANNER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "PPPRODUCTBOM_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint PPPRODUCTBOM_PPPRODUCTPLANNING foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_PRODUCT_PLANNING drop constraint "SRESOURCE_PPPRODUCTPLANNING"
;

alter table PP_PRODUCT_PLANNING add constraint SRESOURCE_PPPRODUCTPLANNING foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_WF_NODE_ASSET drop constraint "AASSET_PPWFNODEASSET"
;

alter table PP_WF_NODE_ASSET add constraint AASSET_PPWFNODEASSET foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_WF_NODE_ASSET drop constraint "ADWFNODE_PPWFNODEASSET"
;

alter table PP_WF_NODE_ASSET add constraint ADWFNODE_PPWFNODEASSET foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_WF_NODE_PRODUCT drop constraint "ADWFNODE_PPWFNODEPRODUCT"
;

alter table PP_WF_NODE_PRODUCT add constraint ADWFNODE_PPWFNODEPRODUCT foreign key (AD_WF_NODE_ID) references AD_WF_NODE(AD_WF_NODE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_WF_NODE_PRODUCT drop constraint "ENTITYT_PPWFNODEPRODUCT"
;

alter table PP_WF_NODE_PRODUCT add constraint ENTITYT_PPWFNODEPRODUCT foreign key (ENTITYTYPE) references AD_ENTITYTYPE(ENTITYTYPE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table PP_WF_NODE_PRODUCT drop constraint "MPRODUCT_PPWFNODEPRODUCT"
;

alter table PP_WF_NODE_PRODUCT add constraint MPRODUCT_PPWFNODEPRODUCT foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATION drop constraint "ADWORKFLOW_QMSPECIFICATION"
;

alter table QM_SPECIFICATION add constraint ADWORKFLOW_QMSPECIFICATION foreign key (AD_WORKFLOW_ID) references AD_WORKFLOW(AD_WORKFLOW_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATION drop constraint "MATTRIBUTESET_QMSPECIFICATION"
;

alter table QM_SPECIFICATION add constraint MATTRIBUTESET_QMSPECIFICATION foreign key (M_ATTRIBUTESET_ID) references M_ATTRIBUTESET(M_ATTRIBUTESET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATION drop constraint "MPRODUCT_QMSPECIFICATION"
;

alter table QM_SPECIFICATION add constraint MPRODUCT_QMSPECIFICATION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATION drop constraint "PPPRODUCTBOM_QMSPECIFICATION"
;

alter table QM_SPECIFICATION add constraint PPPRODUCTBOM_QMSPECIFICATION foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATIONLINE drop constraint "MATTRIBUTE_QMSPECIFICATIONLINE"
;

alter table QM_SPECIFICATIONLINE add constraint MATTRIBUTE_QMSPECIFICATIONLINE foreign key (M_ATTRIBUTE_ID) references M_ATTRIBUTE(M_ATTRIBUTE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table QM_SPECIFICATIONLINE drop constraint "QMSPECIFICATION_QMSPECIFICATIO"
;

alter table QM_SPECIFICATIONLINE add constraint QMSPECIFICATION_QMSPECIFICATIO foreign key (QM_SPECIFICATION_ID) references QM_SPECIFICATION(QM_SPECIFICATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_CATEGORY drop constraint "MPRODUCT_RCATEGORY"
;

alter table R_CATEGORY add constraint MPRODUCT_RCATEGORY foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_CATEGORYUPDATES drop constraint "ADUSER_RCATEGORYUPDATES"
;

alter table R_CATEGORYUPDATES add constraint ADUSER_RCATEGORYUPDATES foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_CATEGORYUPDATES drop constraint "RCATEGORY_RCATEGORYUPDATES"
;

alter table R_CATEGORYUPDATES add constraint RCATEGORY_RCATEGORYUPDATES foreign key (R_CATEGORY_ID) references R_CATEGORY(R_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_CONTACTINTEREST drop constraint "ADUSER_RCONTACTINTEREST"
;

alter table R_CONTACTINTEREST add constraint ADUSER_RCONTACTINTEREST foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_CONTACTINTEREST drop constraint "RINTERESTAREA_RCONTACTINTEREST"
;

alter table R_CONTACTINTEREST add constraint RINTERESTAREA_RCONTACTINTEREST foreign key (R_INTERESTAREA_ID) references R_INTERESTAREA(R_INTERESTAREA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_GROUP drop constraint "MBOM_RGROUP"
;

alter table R_GROUP add constraint MBOM_RGROUP foreign key (M_BOM_ID) references M_BOM(M_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_GROUP drop constraint "MCHANGENOTICE_RGROUP"
;

alter table R_GROUP add constraint MCHANGENOTICE_RGROUP foreign key (M_CHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_GROUP drop constraint "PPPRODUCTBOM_RGROUP"
;

alter table R_GROUP add constraint PPPRODUCTBOM_RGROUP foreign key (PP_PRODUCT_BOM_ID) references PP_PRODUCT_BOM(PP_PRODUCT_BOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_GROUPUPDATES drop constraint "ADUSER_RUSERUPDATES"
;

alter table R_GROUPUPDATES add constraint ADUSER_RUSERUPDATES foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_GROUPUPDATES drop constraint "RGROUP_RGROUPUPDATES"
;

alter table R_GROUPUPDATES add constraint RGROUP_RGROUPUPDATES foreign key (R_GROUP_ID) references R_GROUP(R_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEKNOWN drop constraint "RISSUERECOMMENDATION_RISSUEKNO"
;

alter table R_ISSUEKNOWN add constraint RISSUERECOMMENDATION_RISSUEKNO foreign key (R_ISSUERECOMMENDATION_ID) references R_ISSUERECOMMENDATION(R_ISSUERECOMMENDATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEKNOWN drop constraint "RISSUESTATUS_RISSUEKNOWN"
;

alter table R_ISSUEKNOWN add constraint RISSUESTATUS_RISSUEKNOWN foreign key (R_ISSUESTATUS_ID) references R_ISSUESTATUS(R_ISSUESTATUS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEKNOWN drop constraint "RREQUEST_RISSUEKNOWN"
;

alter table R_ISSUEKNOWN add constraint RREQUEST_RISSUEKNOWN foreign key (R_REQUEST_ID) references R_REQUEST(R_REQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEPROJECT drop constraint "AASSET_RISSUEPROJECT"
;

alter table R_ISSUEPROJECT add constraint AASSET_RISSUEPROJECT foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEPROJECT drop constraint "CPROJECT_RISSUEPROJECT"
;

alter table R_ISSUEPROJECT add constraint CPROJECT_RISSUEPROJECT foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUESOURCE drop constraint "RISSUEPROJECT_RISSUESOURCE"
;

alter table R_ISSUESOURCE add constraint RISSUEPROJECT_RISSUESOURCE foreign key (R_ISSUEPROJECT_ID) references R_ISSUEPROJECT(R_ISSUEPROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUESOURCE drop constraint "RISSUESYSTEM_RISSUESOURCE"
;

alter table R_ISSUESOURCE add constraint RISSUESYSTEM_RISSUESOURCE foreign key (R_ISSUESYSTEM_ID) references R_ISSUESYSTEM(R_ISSUESYSTEM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUESOURCE drop constraint "RISSUEUSER_RISSUESOURCE"
;

alter table R_ISSUESOURCE add constraint RISSUEUSER_RISSUESOURCE foreign key (R_ISSUEUSER_ID) references R_ISSUEUSER(R_ISSUEUSER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUESYSTEM drop constraint "AASSET_RISSUESYSTEM"
;

alter table R_ISSUESYSTEM add constraint AASSET_RISSUESYSTEM foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_ISSUEUSER drop constraint "ADUSER_RISSUEUSER"
;

alter table R_ISSUEUSER add constraint ADUSER_RISSUEUSER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_MAILTEXT_TRL drop constraint "ADLANGUAGE_RMAILTEXTTRL"
;

alter table R_MAILTEXT_TRL add constraint ADLANGUAGE_RMAILTEXTTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_MAILTEXT_TRL drop constraint "RMAILTEXT_RMAILTEXTTRL"
;

alter table R_MAILTEXT_TRL add constraint RMAILTEXT_RMAILTEXTTRL foreign key (R_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "AASSET_RREQUEST"
;

alter table R_REQUEST add constraint AASSET_RREQUEST foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "ADROLE_RREQUEST"
;

alter table R_REQUEST add constraint ADROLE_RREQUEST foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "ADTABLE_RREQUEST"
;

alter table R_REQUEST add constraint ADTABLE_RREQUEST foreign key (AD_TABLE_ID) references AD_TABLE(AD_TABLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "ADUSERSR_RREQUEST"
;

alter table R_REQUEST add constraint ADUSERSR_RREQUEST foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "ADUSER_RREQUEST"
;

alter table R_REQUEST add constraint ADUSER_RREQUEST foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CACTIVITY_RREQUEST"
;

alter table R_REQUEST add constraint CACTIVITY_RREQUEST foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CCAMPAIGN_RREQUEST"
;

alter table R_REQUEST add constraint CCAMPAIGN_RREQUEST foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CINVOICEREQUEST_RREQUEST"
;

alter table R_REQUEST add constraint CINVOICEREQUEST_RREQUEST foreign key (C_INVOICEREQUEST_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CORDER_RREQUEST"
;

alter table R_REQUEST add constraint CORDER_RREQUEST foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CPAYMENT_RREQUEST"
;

alter table R_REQUEST add constraint CPAYMENT_RREQUEST foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "CPROJECT_RREQUEST"
;

alter table R_REQUEST add constraint CPROJECT_RREQUEST foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "C_BPARTNER_RREQUEST"
;

alter table R_REQUEST add constraint C_BPARTNER_RREQUEST foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MCHANGEREQUEST_RREQUEST"
;

alter table R_REQUEST add constraint MCHANGEREQUEST_RREQUEST foreign key (M_CHANGEREQUEST_ID) references M_CHANGEREQUEST(M_CHANGEREQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MFIXCHANGENOTICE_RREQUEST"
;

alter table R_REQUEST add constraint MFIXCHANGENOTICE_RREQUEST foreign key (M_FIXCHANGENOTICE_ID) references M_CHANGENOTICE(M_CHANGENOTICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MINOUT_RREQUEST"
;

alter table R_REQUEST add constraint MINOUT_RREQUEST foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MPRODUCTSPENT_RREQUEST"
;

alter table R_REQUEST add constraint MPRODUCTSPENT_RREQUEST foreign key (M_PRODUCTSPENT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MPRODUCT_RREQUEST"
;

alter table R_REQUEST add constraint MPRODUCT_RREQUEST foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "MRMA_RREQUEST"
;

alter table R_REQUEST add constraint MRMA_RREQUEST foreign key (M_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RCATEGORY_RREQUEST"
;

alter table R_REQUEST add constraint RCATEGORY_RREQUEST foreign key (R_CATEGORY_ID) references R_CATEGORY(R_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RGROUP_RREQUEST"
;

alter table R_REQUEST add constraint RGROUP_RREQUEST foreign key (R_GROUP_ID) references R_GROUP(R_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RINVOICE_RREQUEST"
;

alter table R_REQUEST add constraint RINVOICE_RREQUEST foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RMAILTEXT_RREQUEST"
;

alter table R_REQUEST add constraint RMAILTEXT_RREQUEST foreign key (R_MAILTEXT_ID) references R_MAILTEXT(R_MAILTEXT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RREQUESTTYPE_RREQUEST"
;

alter table R_REQUEST add constraint RREQUESTTYPE_RREQUEST foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RREQUEST_RELATED"
;

alter table R_REQUEST add constraint RREQUEST_RELATED foreign key (R_REQUESTRELATED_ID) references R_REQUEST(R_REQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RRESOLUTION_RREQUEST"
;

alter table R_REQUEST add constraint RRESOLUTION_RREQUEST foreign key (R_RESOLUTION_ID) references R_RESOLUTION(R_RESOLUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RSTANDARDRESPONSE_RREQUEST"
;

alter table R_REQUEST add constraint RSTANDARDRESPONSE_RREQUEST foreign key (R_STANDARDRESPONSE_ID) references R_STANDARDRESPONSE(R_STANDARDRESPONSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUEST drop constraint "RSTATUS_RREQUEST"
;

alter table R_REQUEST add constraint RSTATUS_RREQUEST foreign key (R_STATUS_ID) references R_STATUS(R_STATUS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "AASSET_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint AASSET_RREQUESTACTION foreign key (A_ASSET_ID) references A_ASSET(A_ASSET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "ADROLE_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint ADROLE_RREQUESTACTION foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "ADUSERSR_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint ADUSERSR_RREQUESTACTION foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "ADUSER_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint ADUSER_RREQUESTACTION foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CACTIVITY_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CACTIVITY_RREQUESTACTION foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CBPARTNER_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CBPARTNER_RREQUESTACTION foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CINVOICE_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CINVOICE_RREQUESTACTION foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CORDER_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CORDER_RREQUESTACTION foreign key (C_ORDER_ID) references C_ORDER(C_ORDER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CPAYMENT_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CPAYMENT_RREQUESTACTION foreign key (C_PAYMENT_ID) references C_PAYMENT(C_PAYMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "CPROJECT_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint CPROJECT_RREQUESTACTION foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "MINOUT_MREQUESTACTION"
;

alter table R_REQUESTACTION add constraint MINOUT_MREQUESTACTION foreign key (M_INOUT_ID) references M_INOUT(M_INOUT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "MPRODUCTSPENT_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint MPRODUCTSPENT_RREQUESTACTION foreign key (M_PRODUCTSPENT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "MPRODUCT_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint MPRODUCT_RREQUESTACTION foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "MRMA_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint MRMA_RREQUESTACTION foreign key (M_RMA_ID) references M_RMA(M_RMA_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RCATEGORY_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RCATEGORY_RREQUESTACTION foreign key (R_CATEGORY_ID) references R_CATEGORY(R_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RGROUP_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RGROUP_RREQUESTACTION foreign key (R_GROUP_ID) references R_GROUP(R_GROUP_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RREQUESTTYPE_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RREQUESTTYPE_RREQUESTACTION foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RREQUEST_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RREQUEST_RREQUESTACTION foreign key (R_REQUEST_ID) references R_REQUEST(R_REQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RRESOLUTION_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RRESOLUTION_RREQUESTACTION foreign key (R_RESOLUTION_ID) references R_RESOLUTION(R_RESOLUTION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTACTION drop constraint "RSTATUS_RREQUESTACTION"
;

alter table R_REQUESTACTION add constraint RSTATUS_RREQUESTACTION foreign key (R_STATUS_ID) references R_STATUS(R_STATUS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR drop constraint "ADSCHEDULE_RREQUESTPROCESSOR"
;

alter table R_REQUESTPROCESSOR add constraint ADSCHEDULE_RREQUESTPROCESSOR foreign key (AD_SCHEDULE_ID) references AD_SCHEDULE(AD_SCHEDULE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR drop constraint "ADUSER_RREQUESTPROCESSOR"
;

alter table R_REQUESTPROCESSOR add constraint ADUSER_RREQUESTPROCESSOR foreign key (SUPERVISOR_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR drop constraint "RREQUESTTYPE_RREQUESTPROCESSOR"
;

alter table R_REQUESTPROCESSOR add constraint RREQUESTTYPE_RREQUESTPROCESSOR foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSORLOG drop constraint "RREQUESTPROCESSOR_LOG"
;

alter table R_REQUESTPROCESSORLOG add constraint RREQUESTPROCESSOR_LOG foreign key (R_REQUESTPROCESSOR_ID) references R_REQUESTPROCESSOR(R_REQUESTPROCESSOR_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR_ROUTE drop constraint "ADUSER_RREQUESTPROCESSORROUTE"
;

alter table R_REQUESTPROCESSOR_ROUTE add constraint ADUSER_RREQUESTPROCESSORROUTE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR_ROUTE drop constraint "RREQUESTPROCESSOR_ROUTE"
;

alter table R_REQUESTPROCESSOR_ROUTE add constraint RREQUESTPROCESSOR_ROUTE foreign key (R_REQUESTPROCESSOR_ID) references R_REQUESTPROCESSOR(R_REQUESTPROCESSOR_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTPROCESSOR_ROUTE drop constraint "RREQUESTTYPE_RPROCESSORRULE"
;

alter table R_REQUESTPROCESSOR_ROUTE add constraint RREQUESTTYPE_RPROCESSORRULE foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTTYPE drop constraint "RSTATUSCATEGORY_RREQUESTTYPE"
;

alter table R_REQUESTTYPE add constraint RSTATUSCATEGORY_RREQUESTTYPE foreign key (R_STATUSCATEGORY_ID) references R_STATUSCATEGORY(R_STATUSCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTTYPEUPDATES drop constraint "ADUSER_RREQUESTTYPEUPDATES"
;

alter table R_REQUESTTYPEUPDATES add constraint ADUSER_RREQUESTTYPEUPDATES foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTTYPEUPDATES drop constraint "RREQUESTTYPE_RRTUPDATES"
;

alter table R_REQUESTTYPEUPDATES add constraint RREQUESTTYPE_RRTUPDATES foreign key (R_REQUESTTYPE_ID) references R_REQUESTTYPE(R_REQUESTTYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTUPDATE drop constraint "MPRODUCTSPENT_RREQUESTUPDATE"
;

alter table R_REQUESTUPDATE add constraint MPRODUCTSPENT_RREQUESTUPDATE foreign key (M_PRODUCTSPENT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTUPDATE drop constraint "RREQUEST_RREQUESTUPDATE"
;

alter table R_REQUESTUPDATE add constraint RREQUEST_RREQUESTUPDATE foreign key (R_REQUEST_ID) references R_REQUEST(R_REQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTUPDATES drop constraint "ADUSER_RREQUESTUPDATES"
;

alter table R_REQUESTUPDATES add constraint ADUSER_RREQUESTUPDATES foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_REQUESTUPDATES drop constraint "RREQUEST_RRUPDATES"
;

alter table R_REQUESTUPDATES add constraint RREQUEST_RRUPDATES foreign key (R_REQUEST_ID) references R_REQUEST(R_REQUEST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_STATUS drop constraint "NEXTSTATUS_RSTATUS"
;

alter table R_STATUS add constraint NEXTSTATUS_RSTATUS foreign key (NEXT_STATUS_ID) references R_STATUS(R_STATUS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_STATUS drop constraint "RSTATUSCATEGORY_RSTATUS"
;

alter table R_STATUS add constraint RSTATUSCATEGORY_RSTATUS foreign key (R_STATUSCATEGORY_ID) references R_STATUSCATEGORY(R_STATUSCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table R_STATUS drop constraint "UPDATESTATUS_RSTATUS"
;

alter table R_STATUS add constraint UPDATESTATUS_RSTATUS foreign key (UPDATE_STATUS_ID) references R_STATUS(R_STATUS_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_EXPENSETYPE drop constraint "CTAXCATEGORY_SEXPENSETYPE"
;

alter table S_EXPENSETYPE add constraint CTAXCATEGORY_SEXPENSETYPE foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_EXPENSETYPE drop constraint "CUOM_SEXPENSETYPE"
;

alter table S_EXPENSETYPE add constraint CUOM_SEXPENSETYPE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_EXPENSETYPE drop constraint "MPRODUCTCATEGORY_SEXPENSETYPE"
;

alter table S_EXPENSETYPE add constraint MPRODUCTCATEGORY_SEXPENSETYPE foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCE drop constraint "ADUSER_SRESOURCE"
;

alter table S_RESOURCE add constraint ADUSER_SRESOURCE foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCE drop constraint "MWAREHOUSE_SRESOURCE"
;

alter table S_RESOURCE add constraint MWAREHOUSE_SRESOURCE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCE drop constraint "SRESOURCETYPE_SRESOURCE"
;

alter table S_RESOURCE add constraint SRESOURCETYPE_SRESOURCE foreign key (S_RESOURCETYPE_ID) references S_RESOURCETYPE(S_RESOURCETYPE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCEASSIGNMENT drop constraint "SRESOURCE_SRESOURCEASSIGNMENT"
;

alter table S_RESOURCEASSIGNMENT add constraint SRESOURCE_SRESOURCEASSIGNMENT foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCETYPE drop constraint "CTAXCATEGORY_SRESOURCETYPE"
;

alter table S_RESOURCETYPE add constraint CTAXCATEGORY_SRESOURCETYPE foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCETYPE drop constraint "CUOM_SRESOURCETYPE"
;

alter table S_RESOURCETYPE add constraint CUOM_SRESOURCETYPE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCETYPE drop constraint "MPRODCATEGORY_SRESOURCETYPE"
;

alter table S_RESOURCETYPE add constraint MPRODCATEGORY_SRESOURCETYPE foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_RESOURCEUNAVAILABLE drop constraint "SRESOURCE_SRESUNAVAILABLE"
;

alter table S_RESOURCEUNAVAILABLE add constraint SRESOURCE_SRESUNAVAILABLE foreign key (S_RESOURCE_ID) references S_RESOURCE(S_RESOURCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSE drop constraint "CBPARTNER_STIMEEXPENSE"
;

alter table S_TIMEEXPENSE add constraint CBPARTNER_STIMEEXPENSE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSE drop constraint "MPRICELIST_STIMEEXPENSE"
;

alter table S_TIMEEXPENSE add constraint MPRICELIST_STIMEEXPENSE foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSE drop constraint "MWAREHOUSE_STIMEEXPENSE"
;

alter table S_TIMEEXPENSE add constraint MWAREHOUSE_STIMEEXPENSE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CACTIVITY_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CACTIVITY_STIMEEXPENSELINE foreign key (C_ACTIVITY_ID) references C_ACTIVITY(C_ACTIVITY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CBPARTNER_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CBPARTNER_STIMEEXPENSELINE foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CCAMPAIGN_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CCAMPAIGN_STIMEEXPENSELINE foreign key (C_CAMPAIGN_ID) references C_CAMPAIGN(C_CAMPAIGN_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CCURRENCY_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CCURRENCY_STIMEEXPENSELINE foreign key (C_CURRENCY_ID) references C_CURRENCY(C_CURRENCY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CINVOICELINE_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CINVOICELINE_STIMEEXPENSELINE foreign key (C_INVOICELINE_ID) references C_INVOICELINE(C_INVOICELINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CORDERLINE_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CORDERLINE_STIMEEXPENSELINE foreign key (C_ORDERLINE_ID) references C_ORDERLINE(C_ORDERLINE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CPROJECTPHASE_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CPROJECTPHASE_STIMEEXPENSELINE foreign key (C_PROJECTPHASE_ID) references C_PROJECTPHASE(C_PROJECTPHASE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CPROJECTTASK_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CPROJECTTASK_STIMEEXPENSELINE foreign key (C_PROJECTTASK_ID) references C_PROJECTTASK(C_PROJECTTASK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CPROJECT_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CPROJECT_STIMEEXPENSELINE foreign key (C_PROJECT_ID) references C_PROJECT(C_PROJECT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "CUOM_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint CUOM_STIMEEXPENSELINE foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "MPRODUCT_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint MPRODUCT_STIMEEXPENSELINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "SRESOURCEASSIGN_STELINE"
;

alter table S_TIMEEXPENSELINE add constraint SRESOURCEASSIGN_STELINE foreign key (S_RESOURCEASSIGNMENT_ID) references S_RESOURCEASSIGNMENT(S_RESOURCEASSIGNMENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "STIMEEXPENSE_LINE"
;

alter table S_TIMEEXPENSELINE add constraint STIMEEXPENSE_LINE foreign key (S_TIMEEXPENSE_ID) references S_TIMEEXPENSE(S_TIMEEXPENSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TIMEEXPENSELINE drop constraint "STIMETYPE_STIMEEXPENSELINE"
;

alter table S_TIMEEXPENSELINE add constraint STIMETYPE_STIMEEXPENSELINE foreign key (S_TIMETYPE_ID) references S_TIMETYPE(S_TIMETYPE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TRAINING drop constraint "CTAXCATEGORY_STRAINING"
;

alter table S_TRAINING add constraint CTAXCATEGORY_STRAINING foreign key (C_TAXCATEGORY_ID) references C_TAXCATEGORY(C_TAXCATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TRAINING drop constraint "CUOM_STRAINING"
;

alter table S_TRAINING add constraint CUOM_STRAINING foreign key (C_UOM_ID) references C_UOM(C_UOM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TRAINING drop constraint "MPRODUCTCATEGORY_STRAINING"
;

alter table S_TRAINING add constraint MPRODUCTCATEGORY_STRAINING foreign key (M_PRODUCT_CATEGORY_ID) references M_PRODUCT_CATEGORY(M_PRODUCT_CATEGORY_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TRAINING_CLASS drop constraint "MPRODUCT_STRAININGCLASS"
;

alter table S_TRAINING_CLASS add constraint MPRODUCT_STRAININGCLASS foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table S_TRAINING_CLASS drop constraint "STRAINING_STRAININGCLASS"
;

alter table S_TRAINING_CLASS add constraint STRAINING_STRAININGCLASS foreign key (S_TRAINING_ID) references S_TRAINING(S_TRAINING_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table TEST drop constraint "VC_ACCOUNT_TEST"
;

alter table TEST add constraint VC_ACCOUNT_TEST foreign key (ACCOUNT_ACCT) references C_VALIDCOMBINATION(C_VALIDCOMBINATION_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_AGING drop constraint "ADPINSTANCE_TAGING"
;

alter table T_AGING add constraint ADPINSTANCE_TAGING foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_AGING drop constraint "CBPARTNER_TAGING"
;

alter table T_AGING add constraint CBPARTNER_TAGING foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "CBPARTNERLOCATION_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint CBPARTNERLOCATION_TDRDETAIL foreign key (C_BPARTNER_LOCATION_ID) references C_BPARTNER_LOCATION(C_BPARTNER_LOCATION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "CBPARTNER_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint CBPARTNER_TDRDETAIL foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "MDISTRIBUTIONLIST_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint MDISTRIBUTIONLIST_TDRDETAIL foreign key (M_DISTRIBUTIONLIST_ID) references M_DISTRIBUTIONLIST(M_DISTRIBUTIONLIST_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "MDISTRIBUTIONLLINE_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint MDISTRIBUTIONLLINE_TDRDETAIL foreign key (M_DISTRIBUTIONLISTLINE_ID) references M_DISTRIBUTIONLISTLINE(M_DISTRIBUTIONLISTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "MDISTRIBUTIONRUN_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint MDISTRIBUTIONRUN_TDRDETAIL foreign key (M_DISTRIBUTIONRUN_ID) references M_DISTRIBUTIONRUN(M_DISTRIBUTIONRUN_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_DISTRIBUTIONRUNDETAIL drop constraint "MPRODUCT_TDRDETAIL"
;

alter table T_DISTRIBUTIONRUNDETAIL add constraint MPRODUCT_TDRDETAIL foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVENTORYVALUE drop constraint "ADPINSTANCE_TINVENTORYVALUE"
;

alter table T_INVENTORYVALUE add constraint ADPINSTANCE_TINVENTORYVALUE foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVENTORYVALUE drop constraint "MPRODUCT_TINVENTORYVALUE"
;

alter table T_INVENTORYVALUE add constraint MPRODUCT_TINVENTORYVALUE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVENTORYVALUE drop constraint "MWAREHOUSE_TINVENTORYVALUE"
;

alter table T_INVENTORYVALUE add constraint MWAREHOUSE_TINVENTORYVALUE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVOICEGL drop constraint "ADPINSTANCE_TINVOICEGL"
;

alter table T_INVOICEGL add constraint ADPINSTANCE_TINVOICEGL foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVOICEGL drop constraint "CINVOICE_TINVOICEGL"
;

alter table T_INVOICEGL add constraint CINVOICE_TINVOICEGL foreign key (C_INVOICE_ID) references C_INVOICE(C_INVOICE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_INVOICEGL drop constraint "FACTACCT_TINVOICEGL"
;

alter table T_INVOICEGL add constraint FACTACCT_TINVOICEGL foreign key (FACT_ACCT_ID) references FACT_ACCT(FACT_ACCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_REPLENISH drop constraint "ADPINSTANCE_TREPLENISH"
;

alter table T_REPLENISH add constraint ADPINSTANCE_TREPLENISH foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_REPLENISH drop constraint "MPRODUCT_TREPLENISH"
;

alter table T_REPLENISH add constraint MPRODUCT_TREPLENISH foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_REPLENISH drop constraint "MWAREHOUSE_TREPLENISH"
;

alter table T_REPLENISH add constraint MWAREHOUSE_TREPLENISH foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_REPORT drop constraint "ADPINSTANCE_TREPORT"
;

alter table T_REPORT add constraint ADPINSTANCE_TREPORT foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_REPORT drop constraint "PAREPORTLINE_TREPORT"
;

alter table T_REPORT add constraint PAREPORTLINE_TREPORT foreign key (PA_REPORTLINE_ID) references PA_REPORTLINE(PA_REPORTLINE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_SPOOL drop constraint "ADPINSTANCE_TSPOOL"
;

alter table T_SPOOL add constraint ADPINSTANCE_TSPOOL foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_TRANSACTION drop constraint "ADPINSTANCE_TTRANSACTION"
;

alter table T_TRANSACTION add constraint ADPINSTANCE_TTRANSACTION foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_TRANSACTION drop constraint "MTRANSACTION_TTRANSACTION"
;

alter table T_TRANSACTION add constraint MTRANSACTION_TTRANSACTION foreign key (M_TRANSACTION_ID) references M_TRANSACTION(M_TRANSACTION_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table T_TRIALBALANCE drop constraint "AD_PINSTANCE_T_TRIALBALANCE"
;

alter table T_TRIALBALANCE add constraint AD_PINSTANCE_T_TRIALBALANCE foreign key (AD_PINSTANCE_ID) references AD_PINSTANCE(AD_PINSTANCE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CARDBANKACCOUNT_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint CARDBANKACCOUNT_UPOSTERMINAL foreign key (CARD_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CARDTRANSFERBANKACCOUNT_UPOSTE"
;

alter table U_POSTERMINAL add constraint CARDTRANSFERBANKACCOUNT_UPOSTE foreign key (CARDTRANSFERBANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CARDTRANSFERCASHBOOK_UPOSTERMI"
;

alter table U_POSTERMINAL add constraint CARDTRANSFERCASHBOOK_UPOSTERMI foreign key (CARDTRANSFERCASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CASHTRANSFERBANKACCOUNT_UPOSTE"
;

alter table U_POSTERMINAL add constraint CASHTRANSFERBANKACCOUNT_UPOSTE foreign key (CASHTRANSFERBANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CASHTRANSFERCASHBOOK_UPOSTERMI"
;

alter table U_POSTERMINAL add constraint CASHTRANSFERCASHBOOK_UPOSTERMI foreign key (CASHTRANSFERCASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CCASHBOOK_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint CCASHBOOK_UPOSTERMINAL foreign key (C_CASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CCASHBPARTNER_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint CCASHBPARTNER_UPOSTERMINAL foreign key (C_CASHBPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CHECKBANKACCOUNT_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint CHECKBANKACCOUNT_UPOSTERMINAL foreign key (CHECK_BANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CHECKTRANSFERBANKACCOUNT_UPOST"
;

alter table U_POSTERMINAL add constraint CHECKTRANSFERBANKACCOUNT_UPOST foreign key (CHECKTRANSFERBANKACCOUNT_ID) references C_BANKACCOUNT(C_BANKACCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CHECKTRANSFERCASHBOOK_UPOSTERM"
;

alter table U_POSTERMINAL add constraint CHECKTRANSFERCASHBOOK_UPOSTERM foreign key (CHECKTRANSFERCASHBOOK_ID) references C_CASHBOOK(C_CASHBOOK_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "CTEMPLATEBPARTNER_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint CTEMPLATEBPARTNER_UPOSTERMINAL foreign key (C_TEMPLATEBPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "MWAREHOUSE_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint MWAREHOUSE_UPOSTERMINAL foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "POPRICELIST_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint POPRICELIST_UPOSTERMINAL foreign key (PO_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "SALESREP_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint SALESREP_UPOSTERMINAL foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_POSTERMINAL drop constraint "SOPRICELIST_UPOSTERMINAL"
;

alter table U_POSTERMINAL add constraint SOPRICELIST_UPOSTERMINAL foreign key (SO_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_ROLEMENU drop constraint "ADROLE_UROLEMENU"
;

alter table U_ROLEMENU add constraint ADROLE_UROLEMENU foreign key (AD_ROLE_ID) references AD_ROLE(AD_ROLE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_ROLEMENU drop constraint "UWEBMENU_UROLEMENU"
;

alter table U_ROLEMENU add constraint UWEBMENU_UROLEMENU foreign key (U_WEBMENU_ID) references U_WEBMENU(U_WEBMENU_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table U_WEBMENU drop constraint "PARENTMENU_UWEBMENU"
;

alter table U_WEBMENU add constraint PARENTMENU_UWEBMENU foreign key (PARENTMENU_ID) references U_WEBMENU(U_WEBMENU_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_ADVERTISEMENT drop constraint "ADUSER_WADVERTISEMENT"
;

alter table W_ADVERTISEMENT add constraint ADUSER_WADVERTISEMENT foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_ADVERTISEMENT drop constraint "CBPARTNER_WADVERTISEMENT"
;

alter table W_ADVERTISEMENT add constraint CBPARTNER_WADVERTISEMENT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_ADVERTISEMENT drop constraint "WCLICKCOUNT_WADVERTISEMENT"
;

alter table W_ADVERTISEMENT add constraint WCLICKCOUNT_WADVERTISEMENT foreign key (W_CLICKCOUNT_ID) references W_CLICKCOUNT(W_CLICKCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_ADVERTISEMENT drop constraint "WCOUNTERCOUNT_WADVERTISEMENT"
;

alter table W_ADVERTISEMENT add constraint WCOUNTERCOUNT_WADVERTISEMENT foreign key (W_COUNTERCOUNT_ID) references W_COUNTERCOUNT(W_COUNTERCOUNT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_BASKET drop constraint "ADUSER_WBASKET"
;

alter table W_BASKET add constraint ADUSER_WBASKET foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_BASKET drop constraint "CBPARTNER_WBASKET"
;

alter table W_BASKET add constraint CBPARTNER_WBASKET foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_BASKET drop constraint "MPRICELIST_WBASKET"
;

alter table W_BASKET add constraint MPRICELIST_WBASKET foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_BASKETLINE drop constraint "MPRODUCT_WBASKETLINE"
;

alter table W_BASKETLINE add constraint MPRODUCT_WBASKETLINE foreign key (M_PRODUCT_ID) references M_PRODUCT(M_PRODUCT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_BASKETLINE drop constraint "WBASKET_WBASKETLINE"
;

alter table W_BASKETLINE add constraint WBASKET_WBASKETLINE foreign key (W_BASKET_ID) references W_BASKET(W_BASKET_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_CLICK drop constraint "ADUSER_WCLICK"
;

alter table W_CLICK add constraint ADUSER_WCLICK foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_CLICK drop constraint "WCLICKCOUNT_WCLICK"
;

alter table W_CLICK add constraint WCLICKCOUNT_WCLICK foreign key (W_CLICKCOUNT_ID) references W_CLICKCOUNT(W_CLICKCOUNT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_CLICKCOUNT drop constraint "CBPARTNER_WCLICKCOUNT"
;

alter table W_CLICKCOUNT add constraint CBPARTNER_WCLICKCOUNT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_COUNTER drop constraint "ADUSER_WCOUNTER"
;

alter table W_COUNTER add constraint ADUSER_WCOUNTER foreign key (AD_USER_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_COUNTER drop constraint "WCOUNTERCOUNT_WCOUNTER"
;

alter table W_COUNTER add constraint WCOUNTERCOUNT_WCOUNTER foreign key (W_COUNTERCOUNT_ID) references W_COUNTERCOUNT(W_COUNTERCOUNT_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_COUNTERCOUNT drop constraint "CBPARTNER_WCOUNTERCOUNT"
;

alter table W_COUNTERCOUNT add constraint CBPARTNER_WCOUNTERCOUNT foreign key (C_BPARTNER_ID) references C_BPARTNER(C_BPARTNER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_MAILMSG drop constraint "WSTORE_WMAILMSG"
;

alter table W_MAILMSG add constraint WSTORE_WMAILMSG foreign key (W_STORE_ID) references W_STORE(W_STORE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_MAILMSG_TRL drop constraint "ADLANGUAGE_WMAILMSGTRL"
;

alter table W_MAILMSG_TRL add constraint ADLANGUAGE_WMAILMSGTRL foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_MAILMSG_TRL drop constraint "WMAILMSG_WMAILMSGTRL"
;

alter table W_MAILMSG_TRL add constraint WMAILMSG_WMAILMSGTRL foreign key (W_MAILMSG_ID) references W_MAILMSG(W_MAILMSG_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE drop constraint "ADCLIENT_WSTORE"
;

alter table W_STORE add constraint ADCLIENT_WSTORE foreign key (AD_CLIENT_ID) references AD_CLIENT(AD_CLIENT_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE drop constraint "CPAYMENTTERM_WSTORE"
;

alter table W_STORE add constraint CPAYMENTTERM_WSTORE foreign key (C_PAYMENTTERM_ID) references C_PAYMENTTERM(C_PAYMENTTERM_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE drop constraint "MPRICELIST_WSTORE"
;

alter table W_STORE add constraint MPRICELIST_WSTORE foreign key (M_PRICELIST_ID) references M_PRICELIST(M_PRICELIST_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE drop constraint "MWAREHOUSE_WSTORE"
;

alter table W_STORE add constraint MWAREHOUSE_WSTORE foreign key (M_WAREHOUSE_ID) references M_WAREHOUSE(M_WAREHOUSE_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE drop constraint "SALESREP_WSTORE"
;

alter table W_STORE add constraint SALESREP_WSTORE foreign key (SALESREP_ID) references AD_USER(AD_USER_ID) INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE_TRL drop constraint "WSTORETRL_ADLANGAUGE"
;

alter table W_STORE_TRL add constraint WSTORETRL_ADLANGAUGE foreign key (AD_LANGUAGE) references AD_LANGUAGE(AD_LANGUAGE) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

alter table W_STORE_TRL drop constraint "WSTORE_WSTORETRL"
;

alter table W_STORE_TRL add constraint WSTORE_WSTORETRL foreign key (W_STORE_ID) references W_STORE(W_STORE_ID) ON DELETE CASCADE INITIALLY DEFERRED DEFERRABLE ENABLE NOVALIDATE
;

SELECT register_migration_script('202112051645_IDEMPIERE-5075.sql') FROM dual
;

