/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IDictionaryService;
import org.adempiere.util.IProcessUI;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.process.ProcessInfo;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractActivator
implements BundleActivator,
ServiceTrackerCustomizer<IDictionaryService, IDictionaryService>,
FrameworkListener {
    protected static final CLogger logger = CLogger.getCLogger((String)AbstractActivator.class.getName());
    protected BundleContext context;
    protected ServiceTracker<IDictionaryService, IDictionaryService> serviceTracker;
    protected IDictionaryService service;
    private String trxName = null;
    private ProcessInfo m_processInfo = null;
    private IProcessUI m_processUI = null;
    private static final Object mutex = new Object();
    private static boolean isFrameworkStarted = false;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.getName() + " " + this.getVersion() + " starting...");
        }
        this.serviceTracker = new ServiceTracker(context, IDictionaryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        if (!AbstractActivator.isFrameworkStarted().booleanValue()) {
            context.addFrameworkListener((FrameworkListener)this);
        }
        this.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.getName() + " " + this.getVersion() + " ready.");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.stop();
        this.serviceTracker.close();
        context.removeFrameworkListener((FrameworkListener)this);
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(context.getBundle().getSymbolicName() + " " + (String)context.getBundle().getHeaders().get("Bundle-Version") + " stopped.");
        }
    }

    protected boolean merge(File zipfile, String version) throws Exception {
        boolean success = false;
        if (!this.installedPackage(version)) {
            this.service.merge(this.context, zipfile);
            success = true;
        } else {
            logger.log(Level.WARNING, "The file was previously installed: " + zipfile.getName());
        }
        return success;
    }

    protected boolean directMerge(File zipfile, String version) throws Exception {
        boolean success = false;
        if (!this.installedPackage(version)) {
            IDictionaryService ids = Core.getDictionaryService();
            if (ids != null) {
                ids.merge(null, zipfile);
                success = true;
                if (ids.getAD_Package_Imp_Proc() != null) {
                    MClient client = MClient.get((Properties)Env.getCtx());
                    this.addLog(Level.INFO, this.getName() + " in " + client.getValue() + " -> " + ids.getAD_Package_Imp_Proc().getP_Msg());
                }
            } else {
                this.addLog(Level.SEVERE, "Could not find an IDictionaryService to process the zip files");
            }
        } else {
            this.addLog(Level.WARNING, "The file was previously installed: " + zipfile.getName());
            success = true;
        }
        return success;
    }

    protected boolean installedPackage(String version) {
        StringBuilder where = new StringBuilder("AD_Client_ID=? AND Name=? AND PK_Status='Completed successfully'");
        ArrayList<Object> params = new ArrayList<Object>();
        String fileName = this.getName();
        int clientId = Env.getAD_Client_ID((Properties)Env.getCtx());
        if (version == null) {
            String[] parts = fileName.split("_");
            if (parts.length < 2) {
                logger.warning("Wrong name, ignored " + fileName);
                return false;
            }
            logger.warning(fileName);
            String clientValue = parts[1];
            clientId = DB.getSQLValueEx(null, (String)"SELECT AD_Client_ID FROM AD_Client WHERE Value=?", (Object[])new Object[]{clientValue});
            if (clientId < 0) {
                clientId = 0;
            }
        }
        params.add(clientId);
        params.add(fileName);
        if (version != null) {
            where.append(" AND PK_Version LIKE ?");
            params.add(version + "%");
        }
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null).setParameters(params);
        return q.match();
    }

    public abstract String getName();

    public boolean getDBLock() throws AdempiereSystemError {
        int timeout = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_TIMEOUT", (int)120);
        int maxAttempts = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_RETRIES", (int)5);
        boolean lockAcquired = false;
        while (maxAttempts > 0 && !lockAcquired) {
            --maxAttempts;
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Acquiring lock with timeout " + timeout + " for " + this.getName() + " / remaining attempts " + maxAttempts);
            }
            try {
                if (!this.getDBLock(timeout)) continue;
                lockAcquired = true;
            }
            catch (Exception exception) {
                this.releaseLock();
            }
        }
        return lockAcquired;
    }

    public void releaseLock() {
        if (this.trxName != null) {
            Trx.get((String)this.trxName, (boolean)false).close();
            this.trxName = null;
        }
    }

    private boolean getDBLock(int timeout) throws AdempiereSystemError {
        return DB.getDatabase().forUpdate(this.getLockPO(), timeout);
    }

    private PO getLockPO() throws AdempiereSystemError {
        MSysConfig sysconfig = (MSysConfig)new Query(Env.getCtx(), "AD_SysConfig", "Name=? AND AD_Client_ID=0", null).setParameters(new Object[]{"AUTOMATIC_PACKIN_PROCESSING"}).firstOnly();
        if (sysconfig == null) {
            throw new AdempiereSystemError("AUTOMATIC_PACKIN_PROCESSING SysConfig does not exist");
        }
        this.trxName = Trx.createTrxName((String)"ActSysTrx");
        Trx.get((String)this.trxName, (boolean)true).setDisplayName(this.getClass().getName() + "_getLockPO");
        sysconfig.set_TrxName(this.trxName);
        return sysconfig;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.m_processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_processInfo;
    }

    public void setProcessUI(IProcessUI processUI) {
        this.m_processUI = processUI;
    }

    protected void statusUpdate(String message) {
        logger.warning(message);
        if (this.m_processUI != null) {
            this.m_processUI.statusUpdate(message);
        }
    }

    public void addLog(Level level, String msg) {
        logger.log(level, msg);
        if (this.m_processInfo != null) {
            this.m_processInfo.addLog(0, null, null, msg.replaceAll("\\n", "<br>"));
        }
    }

    public void setSummary(Level level, String msg) {
        logger.log(level, msg);
        if (this.m_processInfo != null) {
            this.m_processInfo.setSummary(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8) {
            Object object = mutex;
            synchronized (object) {
                isFrameworkStarted = true;
                this.frameworkStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isFrameworkStarted() {
        Object object = mutex;
        synchronized (object) {
            return isFrameworkStarted;
        }
    }

    protected abstract void frameworkStarted();

    protected void start() {
    }

    protected void stop() {
    }

    public String getVersion() {
        return "";
    }

    public IDictionaryService addingService(ServiceReference<IDictionaryService> reference) {
        Runnable runnable = () -> {
            this.service = (IDictionaryService)this.context.getService(reference);
            if (AbstractActivator.isFrameworkStarted().booleanValue()) {
                this.frameworkStarted();
            }
        };
        if (Adempiere.isStarted()) {
            Adempiere.getThreadPoolExecutor().submit(runnable);
        } else {
            MyServerStateChangeListener l = new MyServerStateChangeListener(runnable);
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)l);
        }
        return null;
    }

    public void modifiedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    public void removedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    private class MyServerStateChangeListener
    implements ServerStateChangeListener {
        private Runnable runnable;

        private MyServerStateChangeListener(Runnable r) {
            this.runnable = r;
        }

        public void stateChange(ServerStateChangeEvent e) {
            if (e.getEventType() == 0) {
                Adempiere.getThreadPoolExecutor().submit(this.runnable);
                Adempiere.removeServerStateChangeListener((ServerStateChangeListener)this);
            }
        }
    }
}

