/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPeriod;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class CalloutEngine
implements Callout {
    public static final String NO_ERROR = "";
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private GridTab m_mTab;
    private GridField m_mField;
    protected String[] additionalArgs;
    public static final String ARG_SEPARATOR = ",";

    @Override
    public String start(Properties ctx, String methodName, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        Method method;
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        this.m_mTab = mTab;
        this.m_mField = mField;
        String retValue = NO_ERROR;
        StringBuilder msg = new StringBuilder(methodName).append(" - ").append(mField.getColumnName()).append("=").append(value).append(" (old=").append(oldValue).append(") {active=").append(this.isCalloutActive()).append("}");
        if (!this.isCalloutActive() && this.log.isLoggable(Level.INFO)) {
            this.log.info(msg.toString());
        }
        if ((method = this.getMethod(methodName)) == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 5 && argLength != 6) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            try {
                Object[] args = null;
                args = argLength == 6 ? new Object[]{ctx, WindowNo, mTab, mField, value, oldValue} : new Object[]{ctx, WindowNo, mTab, mField, value};
                retValue = (String)method.invoke((Object)this, args);
            }
            catch (Exception e) {
                Throwable ex = e.getCause();
                if (ex == null) {
                    ex = e;
                }
                this.log.log(Level.SEVERE, "start: " + methodName, ex);
                retValue = ex.getLocalizedMessage();
                if (retValue == null) {
                    retValue = ex.toString();
                }
                this.m_mTab = null;
                this.m_mField = null;
            }
        }
        finally {
            this.m_mTab = null;
            this.m_mField = null;
        }
        return retValue;
    }

    @Override
    public String convert(String methodAndArgs, String value) {
        Method method;
        String methodName;
        if (methodAndArgs.contains("(") && methodAndArgs.substring(methodAndArgs.indexOf("(")).contains(")")) {
            methodName = methodAndArgs.substring(0, methodAndArgs.indexOf(40));
            this.additionalArgs = methodAndArgs.substring(methodAndArgs.indexOf("(") + 1, methodAndArgs.indexOf(")")).split(ARG_SEPARATOR);
        } else {
            methodName = methodAndArgs;
        }
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        String retValue = null;
        StringBuilder msg = new StringBuilder(methodName).append(" - ").append(value);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msg.toString());
        }
        if ((method = this.getMethod(methodName)) == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 1) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            Object[] args = new Object[]{value};
            retValue = (String)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "convert: " + methodName, e);
            e.printStackTrace(System.err);
        }
        return retValue;
    }

    private Method getMethod(String methodName) {
        Method[] allMethods = this.getClass().getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (methodName.equals(allMethods[i].getName())) {
                return allMethods[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean isCalloutActive() {
        return this.m_mTab != null ? this.m_mTab.getActiveCallouts().length > 1 : false;
    }

    protected static void setCalloutActive(boolean active) {
    }

    public String dateAcct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return NO_ERROR;
        }
        if (value == null || !(value instanceof Timestamp)) {
            return NO_ERROR;
        }
        mTab.setValue("DateAcct", value);
        return this.checkPeriodOpen(ctx, WindowNo, mTab, mField, value);
    }

    public String checkPeriodOpen(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return NO_ERROR;
        }
        if (value == null || !(value instanceof Timestamp)) {
            return NO_ERROR;
        }
        int orgID = 0;
        if (mTab.getValue("AD_Org_ID") != null) {
            orgID = (Integer)mTab.getValue("AD_Org_ID");
        }
        int doctypeID = -1;
        if (mTab.getValue("C_DocTypeTarget_ID") != null) {
            doctypeID = (Integer)mTab.getValue("C_DocTypeTarget_ID");
        } else if (mTab.getValue("C_DocType_ID") != null) {
            doctypeID = (Integer)mTab.getValue("C_DocType_ID");
        }
        String docBase = null;
        if (doctypeID <= 0) {
            if ("M_Inventory".equals(mTab.getTableName())) {
                docBase = "MMI";
            } else if ("M_Movement".equals(mTab.getTableName())) {
                docBase = "MMM";
            } else if ("M_Requisition".equals(mTab.getTableName())) {
                docBase = "POR";
            }
        }
        if (doctypeID > 0) {
            MPeriod.testPeriodOpen(ctx, (Timestamp)value, doctypeID, orgID);
        } else if (docBase != null) {
            MPeriod.testPeriodOpen(ctx, (Timestamp)value, docBase, orgID);
        }
        return NO_ERROR;
    }

    public String rate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return NO_ERROR;
        }
        BigDecimal rate1 = (BigDecimal)value;
        BigDecimal rate2 = Env.ZERO;
        if ((double)rate1.signum() != 0.0) {
            rate2 = MUOMConversion.getOppositeRate(rate1);
        }
        if (mField.getColumnName().equals("MultiplyRate")) {
            mTab.setValue("DivideRate", (Object)rate2);
        } else {
            mTab.setValue("MultiplyRate", (Object)rate2);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mField.getColumnName() + "=" + String.valueOf(rate1) + " => " + String.valueOf(rate2));
        }
        return NO_ERROR;
    }

    public GridTab getGridTab() {
        return this.m_mTab;
    }

    public GridField getGridField() {
        return this.m_mField;
    }
}

