/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class ServerReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static CLogger s_log = CLogger.getCLogger(ServerReportCtl.class);

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, String printerName) {
        return ServerReportCtl.startDocumentPrint(type, customPrintFormat, Record_ID, printerName, null);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, String printerName, ProcessInfo pi) {
        ReportEngine re = ReportEngine.get(Env.getCtx(), type, Record_ID);
        if (re == null) {
            CLogger log = CLogger.getCLogger(ServerReportCtl.class);
            log.warning("NoDocPrintFormat");
            return false;
        }
        if (customPrintFormat != null) {
            re.setPrintFormat(customPrintFormat);
        }
        if (re.getPrintFormat() != null) {
            MPrintFormat format = re.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                boolean result = ServerReportCtl.runJasperProcess(Record_ID, re, true, printerName, pi);
                return result;
            }
            if (pi != null && pi.isBatch() && pi.isPrintPreview()) {
                if ("HTML".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("html");
                    pi.setExportFile(re.getHTML());
                } else if ("CSV".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("csv");
                    pi.setExportFile(re.getCSV());
                } else if ("XLS".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("xls");
                    pi.setExportFile(re.getXLS());
                } else if ("XLSX".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("xlsx");
                    pi.setExportFile(re.getXLSX());
                } else {
                    pi.setPDFReport(re.getPDF());
                }
            } else {
                ServerReportCtl.createOutput(re, printerName);
            }
            ReportEngine.printConfirm(type, Record_ID);
        }
        return true;
    }

    public static boolean runJasperProcess(int Record_ID, ReportEngine re, boolean IsDirectPrint, String printerName) {
        return ServerReportCtl.runJasperProcess(Record_ID, re, IsDirectPrint, printerName, null);
    }

    public static boolean runJasperProcess(int Record_ID, ReportEngine re, boolean IsDirectPrint, String printerName, ProcessInfo pi) {
        boolean result;
        ProcessInfoParameter pip;
        MPrintFormat format = re.getPrintFormat();
        ProcessInfo jasperProcessInfo = new ProcessInfo("", format.getJasperProcess_ID());
        PrintInfo printInfo = re.getPrintInfo();
        if (pi != null) {
            jasperProcessInfo.setPrintPreview(pi.isPrintPreview());
            jasperProcessInfo.setIsBatch(pi.isBatch());
        } else {
            jasperProcessInfo.setPrintPreview(!IsDirectPrint);
        }
        jasperProcessInfo.setRecord_ID(Record_ID);
        jasperProcessInfo.setTable_ID(printInfo.getAD_Table_ID());
        jasperProcessInfo.setSerializableObject(format);
        ArrayList<ProcessInfoParameter> jasperPrintParams = new ArrayList<ProcessInfoParameter>();
        if (printerName != null && printerName.trim().length() > 0) {
            pip = new ProcessInfoParameter(PARAM_PRINTER_NAME, printerName, null, null, null);
            jasperPrintParams.add(pip);
        }
        pip = new ProcessInfoParameter(PARAM_PRINT_FORMAT, format, null, null, null);
        jasperPrintParams.add(pip);
        pip = new ProcessInfoParameter(PARAM_PRINT_INFO, re.getPrintInfo(), null, null, null);
        jasperPrintParams.add(pip);
        jasperProcessInfo.setParameter(jasperPrintParams.toArray(new ProcessInfoParameter[0]));
        ServerProcessCtl.process(jasperProcessInfo, pi != null && pi.getTransactionName() != null ? Trx.get(pi.getTransactionName(), false) : null);
        boolean bl = result = !jasperProcessInfo.isError();
        if (result && pi != null && pi.isBatch()) {
            pi.setPDFReport(jasperProcessInfo.getPDFReport());
        }
        return result;
    }

    private static void createOutput(ReportEngine re, String printerName) {
        if (printerName != null) {
            re.getPrintInfo().setPrinterName(printerName);
        }
        re.print();
    }

    public static boolean start(ProcessInfo pi) {
        MPInstance instance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        instance.setIsProcessing(true);
        instance.saveEx();
        try {
            if (pi.getAD_Process_ID() == 110) {
                boolean bl = ServerReportCtl.startDocumentPrint(0, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt PP_Order", null)) {
                boolean bl = ServerReportCtl.startDocumentPrint(8, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt DD_Order", null)) {
                boolean bl = ServerReportCtl.startDocumentPrint(9, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 116) {
                boolean bl = ServerReportCtl.startDocumentPrint(2, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 117) {
                boolean bl = ServerReportCtl.startDocumentPrint(1, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 217) {
                boolean bl = ServerReportCtl.startDocumentPrint(3, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 276) {
                boolean bl = ServerReportCtl.startDocumentPrint(4, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 159) {
                boolean bl = ServerReportCtl.startDocumentPrint(7, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
                boolean bl = ServerReportCtl.startFinReport(pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 291) {
                boolean bl = ServerReportCtl.startDocumentPrint(10, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            if (pi.getAD_Process_ID() == 290) {
                boolean bl = ServerReportCtl.startDocumentPrint(11, null, pi.getRecord_ID(), null, pi);
                return bl;
            }
            boolean bl = ServerReportCtl.startStandardReport(pi);
            return bl;
        }
        finally {
            instance.setIsProcessing(false);
            instance.saveEx();
        }
    }

    public static boolean startStandardReport(ProcessInfo pi, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ServerReportCtl.startStandardReport(pi);
    }

    public static boolean startStandardReport(ProcessInfo pi) {
        ReportEngine re = null;
        Object o = pi.getTransientObject();
        if (o == null) {
            o = pi.getSerializableObject();
        }
        if (o != null && o instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)o;
            String TableName = MTable.getTableName(ctx, format.getAD_Table_ID());
            MQuery query = MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
            PrintInfo info = new PrintInfo(pi);
            re = new ReportEngine(ctx, format, query, info, pi.isSummary(), pi.getTransactionName());
            if (pi.isPrintPreview() && pi.isBatch()) {
                if ("HTML".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("html");
                    pi.setExportFile(re.getHTML());
                } else if ("CSV".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("csv");
                    pi.setExportFile(re.getCSV());
                } else if ("XLS".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("xls");
                    pi.setExportFile(re.getXLS());
                } else if ("XLSX".equals(pi.getReportType())) {
                    pi.setExport(true);
                    pi.setExportFileExtension("xlsx");
                    pi.setExportFile(re.getXLSX());
                } else {
                    pi.setPDFReport(re.getPDF());
                }
            } else {
                ServerReportCtl.createOutput(re, null);
            }
            return true;
        }
        re = ReportEngine.get(Env.getCtx(), pi);
        if (re == null) {
            pi.setSummary("No ReportEngine");
            return false;
        }
        if (pi.isPrintPreview() && pi.isBatch()) {
            if ("HTML".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("html");
                pi.setExportFile(re.getHTML());
            } else if ("CSV".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("csv");
                pi.setExportFile(re.getCSV());
            } else if ("XLS".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("xls");
                pi.setExportFile(re.getXLS());
            } else if ("XLSX".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("xlsx");
                pi.setExportFile(re.getXLSX());
            } else {
                pi.setPDFReport(re.getPDF());
            }
        } else {
            ServerReportCtl.createOutput(re, null);
        }
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        Env.getAD_Client_ID(Env.getCtx());
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get(Env.getCtx(), pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
        if (pi.isPrintPreview() && pi.isBatch()) {
            if ("HTML".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("html");
                pi.setExportFile(re.getHTML());
            } else if ("CSV".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("csv");
                pi.setExportFile(re.getCSV());
            } else if ("XLS".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("xls");
                pi.setExportFile(re.getXLS());
            } else if ("XLSX".equals(pi.getReportType())) {
                pi.setExport(true);
                pi.setExportFileExtension("xlsx");
                pi.setExportFile(re.getXLSX());
            } else {
                pi.setPDFReport(re.getPDF());
            }
        } else {
            ServerReportCtl.createOutput(re, null);
        }
        return true;
    }
}

