/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class PO_LOB
implements Serializable {
    private static final long serialVersionUID = -325477490976139224L;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private String m_tableName;
    private String m_columnName;
    private String m_whereClause;
    private int m_displayType;
    private Object m_value;

    public PO_LOB(String tableName, String columnName, String whereClause, int displayType, Object value) {
        this.m_tableName = tableName;
        this.m_columnName = columnName;
        this.m_whereClause = whereClause;
        this.m_displayType = displayType;
        this.m_value = value;
    }

    public PO_LOB(PO_LOB copy) {
        this.m_columnName = copy.m_columnName;
        this.m_displayType = copy.m_displayType;
        this.m_tableName = copy.m_tableName;
        this.m_value = copy.m_value;
        this.m_whereClause = copy.m_whereClause;
    }

    public boolean save(String whereClause, String trxName) {
        this.m_whereClause = whereClause;
        return this.save(trxName);
    }

    public boolean save(String trxName) {
        boolean success;
        block47: {
            Connection con;
            Trx trx;
            block45: {
                block43: {
                    if (this.m_value == null || !(this.m_value instanceof String) && !(this.m_value instanceof byte[]) || this.m_value instanceof String && this.m_value.toString().length() == 0 || this.m_value instanceof byte[] && ((byte[])this.m_value).length == 0) {
                        StringBuilder sql = new StringBuilder("UPDATE ").append(this.m_tableName).append(" SET ").append(this.m_columnName).append("=null WHERE ").append(this.m_whereClause);
                        int no = DB.executeUpdate(sql.toString(), trxName);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("save [" + trxName + "] #" + no + " - no data - set to null - " + String.valueOf(this.m_value));
                        }
                        if (no == 0) {
                            this.log.warning("[" + trxName + "] - not updated - " + String.valueOf(sql));
                        }
                        return true;
                    }
                    StringBuilder sql = new StringBuilder("UPDATE ").append(this.m_tableName).append(" SET ").append(this.m_columnName).append("=? WHERE ").append(this.m_whereClause);
                    if (!DB.isPostgreSQL() && !DB.isOracle()) {
                        sql = new StringBuilder(DB.getDatabase().convertStatement(sql.toString()));
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("[" + trxName + "] - Local - " + String.valueOf(this.m_value));
                    }
                    trx = null;
                    if (trxName != null) {
                        trx = Trx.get(trxName, false);
                    }
                    con = null;
                    if (trx != null) {
                        con = trx.getConnection();
                    }
                    if (con == null) {
                        con = DB.createConnection(false, 2);
                    }
                    if (con == null) {
                        this.log.log(Level.SEVERE, "Could not get Connection");
                        return false;
                    }
                    PreparedStatement pstmt = null;
                    success = true;
                    try {
                        try {
                            pstmt = con.prepareStatement(sql.toString());
                            if (this.m_displayType == 36 || this.m_displayType == 200267) {
                                pstmt.setString(1, (String)this.m_value);
                            } else {
                                pstmt.setBytes(1, (byte[])this.m_value);
                            }
                            int no = pstmt.executeUpdate();
                            if (no != 1) {
                                this.log.warning("[" + trxName + "] - Not updated #" + no + " - " + String.valueOf(sql));
                                success = false;
                            }
                        }
                        catch (Throwable e) {
                            this.log.log(Level.SEVERE, "[" + trxName + "] - " + String.valueOf(sql), e);
                            success = false;
                            DB.close(pstmt);
                            pstmt = null;
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(pstmt);
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(pstmt);
                    pstmt = null;
                }
                if (success) {
                    if (trx != null) {
                        trx = null;
                        con = null;
                    } else {
                        try {
                            try {
                                con.commit();
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "[" + trxName + "] - commit ", e);
                                success = false;
                                try {
                                    con.close();
                                }
                                catch (SQLException sQLException) {}
                                con = null;
                                break block45;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                con.close();
                            }
                            catch (SQLException sQLException) {}
                            con = null;
                            throw throwable;
                        }
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                        con = null;
                    }
                }
            }
            if (!success) {
                this.log.severe("[" + trxName + "] - rollback");
                if (trx != null) {
                    trx.rollback();
                    trx = null;
                    con = null;
                } else {
                    try {
                        try {
                            con.rollback();
                        }
                        catch (Exception ee) {
                            this.log.log(Level.SEVERE, "[" + trxName + "] - rollback", ee);
                            try {
                                con.close();
                            }
                            catch (SQLException sQLException) {}
                            con = null;
                            break block47;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                        con = null;
                        throw throwable;
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                    con = null;
                }
            }
        }
        return success;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PO_LOB[");
        sb.append(this.m_tableName).append(".").append(this.m_columnName).append(",DisplayType=").append(this.m_displayType).append("]");
        return sb.toString();
    }
}

