/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class PO_Record {
    private static final CCache<String, KeyNamePair[]> s_po_record_tables_cache = new CCache(null, "PORecordTables", 100, 120, false);
    private static CLogger log = CLogger.getCLogger(PO_Record.class);

    protected static boolean deleteRecordCascade(int AD_Table_ID, Serializable Record_IDorUU, String trxName) {
        String columnName;
        int refId;
        if (Record_IDorUU instanceof Integer) {
            refId = 200202;
            columnName = "Record_ID";
        } else if (Record_IDorUU instanceof String) {
            refId = 200240;
            columnName = "Record_UU";
        } else {
            throw new IllegalArgumentException(Record_IDorUU.getClass().getName() + " not supported for ID/UUID");
        }
        KeyNamePair[] cascades = PO_Record.getTablesWithConstraintType(refId, "M", trxName);
        StringBuilder whereClause = new StringBuilder("AD_Table_ID=? AND ").append(columnName).append("=?");
        KeyNamePair[] keyNamePairArray = cascades;
        int n = cascades.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair table2 = keyNamePairArray[n2];
            List poList = new Query(Env.getCtx(), table2.getName(), whereClause.toString(), trxName).setParameters(AD_Table_ID, Record_IDorUU).list();
            int count = 0;
            for (PO po : poList) {
                if (po.get_Table_ID() == AD_Table_ID && (Record_IDorUU instanceof Integer && po.get_ID() == ((Integer)Record_IDorUU).intValue() || Record_IDorUU instanceof String && Record_IDorUU.equals(po.get_UUID()))) continue;
                po.deleteEx(true);
                ++count;
            }
            if (count > 0 && log.isLoggable(Level.CONFIG)) {
                log.config(table2.getName() + " (" + AD_Table_ID + "/" + String.valueOf(Record_IDorUU) + ") #" + count);
            }
            ++n2;
        }
        return true;
    }

    public static void deleteModelCascade(String tableName, Serializable Record_IDorUU, String trxName) {
        KeyNamePair[] tables;
        int refId;
        if (Record_IDorUU instanceof Integer) {
            refId = 200202;
        } else if (Record_IDorUU instanceof String) {
            refId = 200240;
        } else {
            throw new IllegalArgumentException(Record_IDorUU.getClass().getName() + " not supported for ID/UUID");
        }
        KeyNamePair[] keyNamePairArray = tables = PO_Record.getTablesWithModelCascade(refId, tableName, trxName);
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair table2 = keyNamePairArray[n2];
            int dependentTableId = table2.getKey();
            String dependentColumnName = table2.getName();
            String dependentWhere = dependentColumnName + "=?";
            List poList = new Query(Env.getCtx(), MTable.get(dependentTableId).getTableName(), dependentWhere, trxName).setParameters(Record_IDorUU).list();
            for (PO po : poList) {
                po.deleteEx(true, trxName);
            }
            ++n2;
        }
    }

    private static KeyNamePair[] getTablesWithModelCascade(int refId, String tableName, String trxName) {
        int refTableSearchId;
        int refTableId;
        int refTableDirId;
        if (refId == 200202) {
            refTableDirId = 19;
            refTableId = 18;
            refTableSearchId = 30;
        } else if (refId == 200240) {
            refTableDirId = 200234;
            refTableId = 200233;
            refTableSearchId = 200235;
        } else {
            throw new IllegalArgumentException(refId + " not supported for ID/UUID");
        }
        StringBuilder key = new StringBuilder("M").append("|").append(refId).append("|").append(tableName);
        KeyNamePair[] tables = s_po_record_tables_cache.get(key.toString());
        if (tables != null) {
            return tables;
        }
        List<List<Object>> dependents = DB.getSQLArrayObjectsEx(trxName, "SELECT t.AD_Table_ID,        c.ColumnName FROM   AD_Column c        JOIN AD_Table t ON c.AD_Table_ID = t.AD_Table_ID        LEFT JOIN AD_Ref_Table r ON c.AD_Reference_Value_ID = r.AD_Reference_ID        LEFT JOIN AD_Table tr ON r.AD_Table_ID = tr.AD_Table_ID WHERE  t.IsView = 'N'        AND t.IsActive = 'Y'        AND c.IsActive = 'Y'        AND ( ( c.AD_Reference_ID = ?                AND c.ColumnName = ? || '_ID' )               OR ( c.AD_Reference_ID IN (? , ?)                    AND ( tr.TableName = ? OR ( tr.TableName IS NULL AND c.ColumnName = ? || '_ID' ) ) ) )        AND c.FKConstraintType = ?", refTableDirId, tableName, refTableId, refTableSearchId, tableName, tableName, "M");
        if (dependents != null) {
            tables = new KeyNamePair[dependents.size()];
            int i2 = 0;
            while (i2 < dependents.size()) {
                KeyNamePair vnp;
                List<Object> row = dependents.get(i2);
                int dependentTableId = ((BigDecimal)row.get(0)).intValue();
                String dependentColumnName = (String)row.get(1);
                tables[i2] = vnp = new KeyNamePair(dependentTableId, dependentColumnName);
                ++i2;
            }
        } else {
            tables = new KeyNamePair[]{};
        }
        s_po_record_tables_cache.put(key.toString(), tables);
        return tables;
    }

    public static void setRecordNull(int AD_Table_ID, Serializable Record_IDorUU, String trxName) {
        String columnName;
        int refId;
        if (Record_IDorUU instanceof Integer) {
            refId = 200202;
            columnName = "Record_ID";
        } else if (Record_IDorUU instanceof String) {
            refId = 200240;
            columnName = "Record_UU";
        } else {
            throw new IllegalArgumentException(Record_IDorUU.getClass().getName() + " not supported for ID/UUID");
        }
        KeyNamePair[] tables = PO_Record.getTablesWithConstraintType(refId, "T", trxName);
        StringBuilder whereClause = new StringBuilder("AD_Table_ID=? AND ").append(columnName).append("=?");
        KeyNamePair[] keyNamePairArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair table2 = keyNamePairArray[n2];
            List poList = new Query(Env.getCtx(), table2.getName(), whereClause.toString(), trxName).setParameters(AD_Table_ID, Record_IDorUU).list();
            int count = 0;
            for (PO po : poList) {
                if (po.get_Table_ID() == AD_Table_ID && (Record_IDorUU instanceof Integer && po.get_ID() == ((Integer)Record_IDorUU).intValue() || Record_IDorUU instanceof String && Record_IDorUU.equals(po.get_UUID()))) continue;
                if (po.isColumnMandatory(po.get_ColumnIndex(columnName))) {
                    if (Record_IDorUU instanceof Integer) {
                        po.set_Value(columnName, (Object)0);
                    } else {
                        po.set_Value(columnName, (Object)"");
                    }
                } else {
                    po.set_Value(columnName, null);
                }
                po.saveEx(trxName);
                ++count;
            }
            if (count > 0 && log.isLoggable(Level.CONFIG)) {
                log.config(table2.getName() + " (" + AD_Table_ID + "/" + String.valueOf(Record_IDorUU) + ") #" + count);
            }
            ++n2;
        }
    }

    protected static String exists(int AD_Table_ID, Serializable Record_IDorUU, String trxName) {
        String columnName;
        int refId;
        if (Record_IDorUU instanceof Integer) {
            refId = 200202;
            columnName = "Record_ID";
        } else if (Record_IDorUU instanceof String) {
            refId = 200240;
            columnName = "Record_UU";
        } else {
            log.warning(Record_IDorUU.getClass().getName() + " not supported for ID/UUID");
            return null;
        }
        KeyNamePair[] restricts = PO_Record.getTablesWithConstraintType(refId, "O", trxName);
        int i2 = 0;
        while (i2 < restricts.length) {
            StringBuilder sqlb = new StringBuilder("SELECT 1 FROM ").append(restricts[i2].getName()).append(" WHERE AD_Table_ID=? AND ").append(columnName).append("=?");
            String sql = DB.getDatabase().addPagingSQL(sqlb.toString(), 1, 1);
            int no = DB.getSQLValueEx(trxName, sql.toString(), AD_Table_ID, Record_IDorUU);
            if (no == 1) {
                return Msg.getMsg(Env.getCtx(), "DeleteErrorDependent") + " -> " + restricts[i2].getName();
            }
            ++i2;
        }
        return null;
    }

    private static KeyNamePair[] getTablesWithConstraintType(int refId, String constraintType, String trxName) {
        String columnName;
        if (refId == 200202) {
            columnName = "Record_ID";
        } else if (refId == 200240) {
            columnName = "Record_UU";
        } else {
            log.warning(refId + " not supported for ID/UUID");
            return null;
        }
        StringBuilder key = new StringBuilder(constraintType).append("|").append(refId);
        KeyNamePair[] tables = s_po_record_tables_cache.get(key.toString());
        if (tables != null) {
            return tables;
        }
        List listTables = new Query(Env.getCtx(), "AD_Table", "c.AD_Reference_ID=? AND c.FKConstraintType=? AND AD_Table.IsView='N' AND c.ColumnName=?", trxName).addJoinClause("JOIN AD_Column c ON (c.AD_Table_ID=AD_Table.AD_Table_ID)").setOnlyActiveRecords(true).setParameters(refId, constraintType, columnName).list();
        tables = new KeyNamePair[listTables.size()];
        int i2 = 0;
        while (i2 < listTables.size()) {
            MTable table2 = (MTable)listTables.get(i2);
            tables[i2] = new KeyNamePair(table2.getAD_Table_ID(), table2.getTableName());
            ++i2;
        }
        s_po_record_tables_cache.put(key.toString(), tables);
        return tables;
    }
}

