/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.Doc_AllocationTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashLine;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AllocationHdr
extends Doc {
    private static final BigDecimal TOLERANCE = BigDecimal.valueOf(0.02);
    private ArrayList<Fact> m_facts = null;
    private ArrayList<FactLine> invGainLossFactLines = null;
    private ArrayList<FactLine> payGainLossFactLines = null;

    public Doc_AllocationHdr(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MAllocationHdr.class, rs, "CMA", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        this.setDateDoc(alloc.getDateTrx());
        this.p_lines = this.loadLines(alloc);
        return null;
    }

    private DocLine[] loadLines(MAllocationHdr alloc) {
        ArrayList<DocLine_Allocation> list = new ArrayList<DocLine_Allocation>();
        MAllocationLine[] lines = alloc.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MAllocationLine line = lines[i2];
            DocLine_Allocation docLine = new DocLine_Allocation(line, (Doc)this);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                C_ConversionType_ID = payment.getC_ConversionType_ID();
                docLine.setC_ConversionType_ID(C_ConversionType_ID);
                if (payment.isOverrideCurrencyRate()) {
                    docLine.setCurrencyRate(payment.getCurrencyRate());
                }
            } else if (line.getC_Invoice_ID() != 0) {
                MInvoice invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                C_ConversionType_ID = invoice.getC_ConversionType_ID();
                docLine.setC_ConversionType_ID(C_ConversionType_ID);
                if (invoice.isOverrideCurrencyRate()) {
                    docLine.setCurrencyRate(invoice.getCurrencyRate());
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(docLine.toString());
            }
            list.add(docLine);
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.m_facts = new ArrayList();
        this.invGainLossFactLines = new ArrayList();
        this.payGainLossFactLines = new ArrayList();
        Fact fact = new Fact(this, as, "A");
        Fact factForRGL = new Fact(this, as, "A");
        boolean isInterOrg = this.isInterOrg(as);
        MAccount bpAcct = null;
        MAccount bpAcctAr = null;
        MAccount bpAcctAp = null;
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            block59: {
                BigDecimal allocPaySource;
                BigDecimal allocPayAccounted;
                X_C_Invoice invoice;
                MPayment payment;
                BigDecimal allocationAccounted;
                BigDecimal allocationSource;
                DocLine_Allocation line;
                block62: {
                    FactLine flForRGL;
                    FactLine fl;
                    BigDecimal allocationSourceForRGL;
                    block63: {
                        block60: {
                            block61: {
                                line = (DocLine_Allocation)this.p_lines[i2];
                                this.setC_BPartner_ID(line.getC_BPartner_ID());
                                if (line.getC_Payment_ID() != 0 && line.getC_Invoice_ID() == 0 && line.getC_Order_ID() == 0 && line.getC_CashLine_ID() == 0 && line.getC_BPartner_ID() == 0 && Env.ZERO.compareTo(line.getDiscountAmt()) == 0 && Env.ZERO.compareTo(line.getWriteOffAmt()) == 0) break block59;
                                allocationSourceForRGL = allocationSource = line.getAmtSource().add(line.getDiscountAmt()).add(line.getWriteOffAmt());
                                allocationAccounted = Env.ZERO;
                                fl = null;
                                flForRGL = null;
                                payment = null;
                                if (line.getC_Payment_ID() != 0) {
                                    payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                                }
                                invoice = null;
                                if (line.getC_Invoice_ID() != 0) {
                                    invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                                }
                                allocPayAccounted = Env.ZERO;
                                allocPaySource = Env.ZERO;
                                if (invoice != null) break block60;
                                if (line.getC_Invoice_ID() != 0 || line.getC_Payment_ID() != 0 || line.getC_Charge_ID() == 0) break block61;
                                fl = fact.createLine(line, line.getChargeAccount(as, line.getAmtSource()), this.getC_Currency_ID(), line.getAmtSource());
                                break block62;
                            }
                            if (line.getC_Invoice_ID() == 0 && line.getC_Payment_ID() != 0) {
                                fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                                if (fl != null && payment != null) {
                                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                                    allocPayAccounted = allocPayAccounted.add(fl.getAcctBalance());
                                }
                                break block62;
                            } else {
                                this.p_Error = "Cannot determine SO/PO";
                                this.log.log(Level.SEVERE, this.p_Error);
                                return null;
                            }
                        }
                        if (!invoice.isSOTrx()) break block63;
                        MAccount acct_unallocated_cash = null;
                        if (line.getC_Payment_ID() != 0) {
                            acct_unallocated_cash = this.getPaymentAcct(as, line.getC_Payment_ID());
                        } else if (line.getC_CashLine_ID() != 0) {
                            acct_unallocated_cash = this.getCashAcct(as, line.getC_CashLine_ID());
                        }
                        MAccount acct_receivable = this.getAccount(1, as);
                        if (!as.isPostIfClearingEqual() && acct_unallocated_cash != null && acct_unallocated_cash.equals(acct_receivable) && !isInterOrg) {
                            allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                        } else if (line.getC_Payment_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            if (fl != null && payment != null) {
                                fl.setAD_Org_ID(payment.getAD_Org_ID());
                                allocPayAccounted = payment.getReversal_ID() > 0 ? allocPayAccounted.add(fl.getAcctBalance().negate()) : allocPayAccounted.add(fl.getAcctBalance());
                            }
                        } else if (line.getC_CashLine_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                            if (fl != null && cashLine.get_ID() != 0) {
                                fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                            }
                        }
                        if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(30, as), this.getC_Currency_ID(), line.getDiscountAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), line.getWriteOffAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (as.isAccrual()) {
                            if (bpAcctAr == null) {
                                bpAcctAr = this.getAccount(1, as);
                            }
                            if ((fl = fact.createLine((DocLine)line, bpAcct = bpAcctAr, this.getC_Currency_ID(), null, allocationSource)) != null) {
                                allocationAccounted = fl.getAcctBalance().negate();
                            }
                            if (fl != null && invoice != null) {
                                fl.setAD_Org_ID(invoice.getAD_Org_ID());
                            }
                            if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSourceForRGL)) != null) {
                                flForRGL.getAcctBalance().negate();
                            }
                            break block62;
                        } else {
                            allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                        }
                        break block62;
                    }
                    MAccount acct_payment_select = null;
                    if (line.getC_Payment_ID() != 0) {
                        acct_payment_select = this.getPaymentAcct(as, line.getC_Payment_ID());
                    } else if (line.getC_CashLine_ID() != 0) {
                        acct_payment_select = this.getCashAcct(as, line.getC_CashLine_ID());
                    }
                    MAccount acct_liability = this.getAccount(2, as);
                    boolean isUsingClearing = true;
                    allocationSourceForRGL = allocationSourceForRGL.negate();
                    if (!as.isPostIfClearingEqual() && acct_payment_select != null && acct_payment_select.equals(acct_liability) && !isInterOrg) {
                        allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                        isUsingClearing = false;
                    }
                    allocationSource = allocationSource.negate();
                    if (as.isAccrual()) {
                        if (bpAcctAp == null) {
                            bpAcctAp = this.getAccount(2, as);
                        }
                        if ((fl = fact.createLine((DocLine)line, bpAcct = bpAcctAp, this.getC_Currency_ID(), allocationSource, null)) != null) {
                            allocationAccounted = fl.getAcctBalance();
                        }
                        if (fl != null && invoice != null) {
                            fl.setAD_Org_ID(invoice.getAD_Org_ID());
                        }
                        if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSourceForRGL, null)) != null) {
                            flForRGL.getAcctBalance();
                        }
                    } else {
                        allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                    }
                    if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(31, as), this.getC_Currency_ID(), null, line.getDiscountAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), null, line.getWriteOffAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (isUsingClearing && line.getC_Payment_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        if (fl != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (fl != null) {
                            allocPayAccounted = allocPayAccounted.add(fl.getAcctBalance().negate());
                        }
                    } else if (isUsingClearing && line.getC_CashLine_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                        if (fl != null && cashLine.get_ID() != 0) {
                            fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                        }
                    }
                }
                if (invoice != null && as.isTaxCorrection()) {
                    BigDecimal taxCorrectionAmt = Env.ZERO;
                    if (as.isTaxCorrectionDiscount()) {
                        taxCorrectionAmt = line.getDiscountAmt();
                    }
                    if (as.isTaxCorrectionWriteOff()) {
                        taxCorrectionAmt = taxCorrectionAmt.add(line.getWriteOffAmt());
                    }
                    if (taxCorrectionAmt.signum() != 0 && !this.createTaxCorrection(as, fact, line, this.getAccount(invoice.isSOTrx() ? 30 : 31, as), this.getAccount(32, as), invoice.isSOTrx())) {
                        this.p_Error = "Cannot create Tax correction";
                        return null;
                    }
                }
                if (invoice != null && as.isAccrual() && (this.getC_Currency_ID() != as.getC_Currency_ID() || this.getC_Currency_ID() != line.getInvoiceC_Currency_ID())) {
                    this.p_Error = this.createInvoiceGainLoss(line, as, fact, bpAcct, (MInvoice)invoice, allocationSource, allocationAccounted);
                    if (this.p_Error != null) {
                        return null;
                    }
                }
                allocPaySource = allocPaySource.add(line.getAmtSource());
                if (payment != null && this.getC_Currency_ID() != as.getC_Currency_ID()) {
                    this.p_Error = this.createPaymentGainLoss(line, as, fact, this.getPaymentAcct(as, payment.get_ID()), payment, allocPaySource, allocPayAccounted);
                    if (this.p_Error != null) {
                        return null;
                    }
                }
            }
            ++i2;
        }
        if (this.getC_Currency_ID() != as.getC_Currency_ID()) {
            this.p_Error = this.createInvoiceRoundingCorrection(as, fact, bpAcctAr, bpAcctAp);
            if (this.p_Error != null) {
                return null;
            }
            this.p_Error = this.createPaymentRoundingCorrection(as, fact);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!as.isPostIfClearingEqual() && this.p_lines.length > 0 && !isInterOrg) {
            boolean allEquals = true;
            FactLine[] factlines = fact.getLines();
            BigDecimal netBalance = Env.ZERO;
            FactLine prevFactLine = null;
            FactLine[] factLineArray = factlines;
            int n = factlines.length;
            int n2 = 0;
            while (n2 < n) {
                FactLine factLine = factLineArray[n2];
                netBalance = netBalance.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
                if (prevFactLine != null && !this.equalFactLineIDs(prevFactLine, factLine)) {
                    allEquals = false;
                    break;
                }
                prevFactLine = factLine;
                ++n2;
            }
            if (netBalance.compareTo(Env.ZERO) == 0 && allEquals) {
                factLineArray = factlines;
                n = factlines.length;
                n2 = 0;
                while (n2 < n) {
                    FactLine factline = factLineArray[n2];
                    fact.remove(factline);
                    ++n2;
                }
            }
        }
        if (this.getC_Currency_ID() != as.getC_Currency_ID()) {
            this.balanceAccounting(as, fact);
        }
        this.setC_BPartner_ID(0);
        this.m_facts.add(fact);
        return this.m_facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        if (this.p_lines.length <= 0) {
            return false;
        }
        int startorg = this.p_lines[0].getAD_Org_ID();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i2];
            int orgpayment = startorg;
            MPayment payment = null;
            if (line.getC_Payment_ID() != 0) {
                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                orgpayment = payment.getAD_Org_ID();
            }
            int orginvoice = startorg;
            MInvoice invoice = null;
            if (line.getC_Invoice_ID() != 0) {
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                orginvoice = invoice.getAD_Org_ID();
            }
            int orgcashline = startorg;
            MCashLine cashline = null;
            if (line.getC_CashLine_ID() != 0) {
                cashline = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                orgcashline = cashline.getAD_Org_ID();
            }
            int orgorder = startorg;
            MOrder order = null;
            if (line.getC_Order_ID() != 0) {
                order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.getTrxName());
                orgorder = order.getAD_Org_ID();
            }
            if (line.getAD_Org_ID() != startorg || orgpayment != startorg || orginvoice != startorg || orgcashline != startorg || orgorder != startorg) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean equalFactLineIDs(FactLine prevFactLine, FactLine factLine) {
        return factLine.getA_Asset_ID() == prevFactLine.getA_Asset_ID() && factLine.getAccount_ID() == prevFactLine.getAccount_ID() && factLine.getAD_Client_ID() == prevFactLine.getAD_Client_ID() && factLine.getAD_Org_ID() == prevFactLine.getAD_Org_ID() && factLine.getAD_OrgTrx_ID() == prevFactLine.getAD_OrgTrx_ID() && factLine.getC_AcctSchema_ID() == prevFactLine.getC_AcctSchema_ID() && factLine.getC_Activity_ID() == prevFactLine.getC_Activity_ID() && factLine.getC_BPartner_ID() == prevFactLine.getC_BPartner_ID() && factLine.getC_Campaign_ID() == prevFactLine.getC_Campaign_ID() && factLine.getC_Currency_ID() == prevFactLine.getC_Currency_ID() && factLine.getC_LocFrom_ID() == prevFactLine.getC_LocFrom_ID() && factLine.getC_LocTo_ID() == prevFactLine.getC_LocTo_ID() && factLine.getC_Period_ID() == prevFactLine.getC_Period_ID() && factLine.getC_Project_ID() == prevFactLine.getC_Project_ID() && factLine.getC_ProjectPhase_ID() == prevFactLine.getC_ProjectPhase_ID() && factLine.getC_ProjectTask_ID() == prevFactLine.getC_ProjectTask_ID() && factLine.getC_SalesRegion_ID() == prevFactLine.getC_SalesRegion_ID() && factLine.getC_SubAcct_ID() == prevFactLine.getC_SubAcct_ID() && factLine.getC_Tax_ID() == prevFactLine.getC_Tax_ID() && factLine.getC_UOM_ID() == prevFactLine.getC_UOM_ID() && factLine.getGL_Budget_ID() == prevFactLine.getGL_Budget_ID() && factLine.getGL_Category_ID() == prevFactLine.getGL_Category_ID() && factLine.getM_Locator_ID() == prevFactLine.getM_Locator_ID() && factLine.getM_Product_ID() == prevFactLine.getM_Product_ID() && factLine.getUserElement1_ID() == prevFactLine.getUserElement1_ID() && factLine.getUserElement2_ID() == prevFactLine.getUserElement2_ID() && factLine.getUser1_ID() == prevFactLine.getUser1_ID() && factLine.getUser2_ID() == prevFactLine.getUser2_ID();
    }

    private BigDecimal createCashBasedAcct(MAcctSchema as, Fact fact, MInvoice invoice, BigDecimal allocationSource) {
        BigDecimal allocationAccounted = Env.ZERO;
        double percent = invoice.getGrandTotal().doubleValue() / allocationSource.doubleValue();
        if (percent > 0.99 && percent < 1.01) {
            percent = 1.0;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Multiplier=" + percent + " - GrandTotal=" + String.valueOf(invoice.getGrandTotal()) + " - Allocation Source=" + String.valueOf(allocationSource));
        }
        Doc_Invoice docInvoice = (Doc_Invoice)Doc.get(as, 318, invoice.getC_Invoice_ID(), this.getTrxName());
        docInvoice.loadDocumentDetails();
        allocationAccounted = docInvoice.createFactCash(as, fact, BigDecimal.valueOf(percent));
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Allocation Accounted=" + String.valueOf(allocationAccounted));
        }
        if (as.isCreatePOCommitment() && !invoice.isSOTrx()) {
            MInvoiceLine[] lines = invoice.getLines();
            int i2 = 0;
            while (i2 < lines.length) {
                Fact factC = Doc_Order.getCommitmentRelease(as, this, lines[i2].getQtyInvoiced(), lines[i2].getC_InvoiceLine_ID(), BigDecimal.valueOf(percent));
                if (factC == null) {
                    return null;
                }
                this.m_facts.add(factC);
                ++i2;
            }
        }
        return allocationAccounted;
    }

    private MAccount getPaymentAcct(MAcctSchema as, int C_Payment_ID) {
        this.setC_BankAccount_ID(0);
        int accountType = 10;
        int C_Charge_ID = 0;
        String sql = "SELECT p.C_BankAccount_ID, d.DocBaseType, p.IsReceipt, p.IsPrepayment, p.C_Charge_ID FROM C_Payment p INNER JOIN C_DocType d ON (p.C_DocType_ID=d.C_DocType_ID) WHERE C_Payment_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, C_Payment_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.setC_BankAccount_ID(rs.getInt(1));
                    C_Charge_ID = rs.getInt(5);
                    if ("APP".equals(rs.getString(2))) {
                        accountType = 12;
                    }
                    if ("Y".equals(rs.getString(4))) {
                        accountType = "Y".equals(rs.getString(3)) ? 13 : 14;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.getC_BankAccount_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_Payment_ID=" + C_Payment_ID);
            return null;
        }
        if (C_Charge_ID != 0) {
            return MCharge.getAccount(C_Charge_ID, as);
        }
        return this.getAccount(accountType, as);
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }

    private boolean createTaxCorrection(MAcctSchema as, Fact fact, DocLine_Allocation line, MAccount DiscountAccount, MAccount WriteOffAccoint, boolean isSOTrx) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(line.toString());
        }
        BigDecimal discount = Env.ZERO;
        if (as.isTaxCorrectionDiscount()) {
            discount = line.getDiscountAmt();
        }
        BigDecimal writeOff = Env.ZERO;
        if (as.isTaxCorrectionWriteOff()) {
            writeOff = line.getWriteOffAmt();
        }
        Doc_AllocationTax tax = new Doc_AllocationTax(DiscountAccount, discount, WriteOffAccoint, writeOff, isSOTrx);
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, 318);
                pstmt.setInt(2, line.getC_Invoice_ID());
                pstmt.setInt(3, as.getC_AcctSchema_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    tax.addInvoiceFact(new MFactAcct(this.getCtx(), rs, fact.get_TrxName()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tax.getLineCount() == 0) {
            this.log.warning("Invoice not posted yet - " + String.valueOf(line));
            return false;
        }
        if (tax.getLineCount() < 2) {
            return true;
        }
        return tax.createEntries(as, fact, line);
    }

    private String createInvoiceGainLoss(DocLine line, MAcctSchema as, Fact fact, MAccount acct, MInvoice invoice, BigDecimal allocationSource, BigDecimal allocationAccounted) {
        BigDecimal invoiceSource = null;
        BigDecimal invoiceAccounted = null;
        StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        List<Object> valuesInv = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID());
        if (valuesInv != null && valuesInv.size() >= 4) {
            if (invoice.getReversal_ID() == 0 || invoice.get_ID() < invoice.getReversal_ID()) {
                if (this.hasDebitTradeAmt(invoice)) {
                    invoiceSource = (BigDecimal)valuesInv.get(0);
                    invoiceAccounted = (BigDecimal)valuesInv.get(1);
                } else {
                    invoiceSource = (BigDecimal)valuesInv.get(2);
                    invoiceAccounted = (BigDecimal)valuesInv.get(3);
                }
            } else if (this.hasDebitTradeAmt(invoice)) {
                invoiceSource = (BigDecimal)valuesInv.get(2);
                invoiceAccounted = (BigDecimal)valuesInv.get(3);
            } else {
                invoiceSource = (BigDecimal)valuesInv.get(0);
                invoiceAccounted = (BigDecimal)valuesInv.get(1);
            }
        }
        if (invoiceSource == null || invoiceAccounted == null) {
            return "Gain/Loss - Invoice not posted yet";
        }
        StringBuilder description = new StringBuilder("Invoice=(").append(invoice.getC_Currency_ID()).append(")").append(invoiceSource).append("/").append(invoiceAccounted).append(" - Allocation=(").append(this.getC_Currency_ID()).append(")").append(allocationSource).append("/").append(allocationAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = null;
        if (allocationSource.abs().compareTo(invoiceSource.abs()) == 0) {
            acctDifference = invoiceAccounted.abs().subtract(allocationAccounted.abs());
            StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        } else {
            BigDecimal allocationAccounted0 = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            acctDifference = allocationAccounted0.abs().subtract(allocationAccounted.abs());
            if (acctDifference.abs().compareTo(TOLERANCE) < 0) {
                acctDifference = Env.ZERO;
            }
            int precision = as.getStdPrecision();
            if (acctDifference.scale() > precision) {
                acctDifference = acctDifference.setScale(precision, RoundingMode.HALF_UP);
            }
            StringBuilder d2 = new StringBuilder("(partial) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        }
        if (acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        if (alloc.getReversal_ID() == 0 || alloc.get_ID() < alloc.getReversal_ID()) {
            if (this.hasDebitTradeAmt(invoice)) {
                FactLine fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                this.invGainLossFactLines.add(fl);
                fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
            } else {
                FactLine fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                this.invGainLossFactLines.add(fl);
            }
        } else if (this.hasDebitTradeAmt(invoice)) {
            FactLine fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            fl = fact.createLine(line, gain, loss, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            this.invGainLossFactLines.add(fl);
        } else {
            FactLine fl = fact.createLine(line, gain, loss, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            this.invGainLossFactLines.add(fl);
            fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
        }
        return null;
    }

    private String createPaymentGainLoss(DocLine line, MAcctSchema as, Fact fact, MAccount acct, MPayment payment, BigDecimal allocationSource, BigDecimal allocationAccounted) {
        BigDecimal paymentSource = null;
        BigDecimal paymentAccounted = null;
        StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID = ? ").append(" AND PostingType='A'");
        List<Object> valuesPay = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 335, payment.getC_Payment_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID());
        if (valuesPay != null && valuesPay.size() >= 4) {
            paymentSource = (BigDecimal)valuesPay.get(0);
            paymentAccounted = (BigDecimal)valuesPay.get(1);
            if (paymentSource != null && paymentAccounted != null && paymentSource.signum() == 0 && paymentAccounted.signum() == 0) {
                paymentSource = (BigDecimal)valuesPay.get(2);
                paymentAccounted = (BigDecimal)valuesPay.get(3);
            }
        }
        if (paymentSource == null || paymentAccounted == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("Payment=(").append(payment.getC_Currency_ID()).append(")").append(paymentSource).append("/").append(paymentAccounted).append(" - Allocation=(").append(this.getC_Currency_ID()).append(")").append(allocationSource).append("/").append(allocationAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = null;
        if (allocationSource.abs().compareTo(paymentSource.abs()) == 0) {
            acctDifference = allocationAccounted.abs().subtract(paymentAccounted.abs());
            StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        } else {
            BigDecimal allocationAccounted0 = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), as.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), payment.getAD_Client_ID(), payment.getAD_Org_ID());
            acctDifference = allocationAccounted.abs().subtract(allocationAccounted0.abs());
            if (acctDifference.abs().compareTo(TOLERANCE) < 0) {
                acctDifference = Env.ZERO;
            }
            int precision = as.getStdPrecision();
            if (acctDifference.scale() > precision) {
                acctDifference = acctDifference.setScale(precision, RoundingMode.HALF_UP);
            }
            StringBuilder d2 = new StringBuilder("(partial) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        }
        if (acctDifference == null || acctDifference.signum() == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Difference");
            }
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        if (payment.isReceipt() && payment.getPayAmt().signum() >= 0 || !payment.isReceipt() && payment.getPayAmt().signum() < 0) {
            fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            this.payGainLossFactLines.add(fl);
        } else {
            fl = fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            this.payGainLossFactLines.add(fl);
        }
        return null;
    }

    private String createInvoiceRoundingCorrection(MAcctSchema as, Fact fact, MAccount acctAr, MAccount acctAp) {
        BigDecimal totalAmtSourceCr;
        HashMap<Integer, MInvoice> invList = new HashMap<Integer, MInvoice>();
        HashMap<Integer, Integer> htInvAllocLine = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            MInvoice invoice = null;
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i2];
            if (line.getC_Invoice_ID() != 0) {
                if (invList.containsKey(line.getC_Invoice_ID())) {
                    this.log.severe(line.getC_Invoice_ID() + ":same invoice included in more than one allocation line");
                } else {
                    invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                    invList.put(invoice.getC_Invoice_ID(), invoice);
                    htInvAllocLine.put(invoice.getC_Invoice_ID(), line.get_ID());
                }
            }
            ++i2;
        }
        HashMap<Integer, BigDecimal> htInvSource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htInvAccounted = new HashMap<Integer, BigDecimal>();
        for (MInvoice invoice : invList.values()) {
            StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
            MAccount acct = invoice.isSOTrx() ? acctAr : acctAp;
            List<Object> valuesInv = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID());
            if (valuesInv == null || valuesInv.size() < 4) continue;
            BigDecimal invoiceSource = null;
            BigDecimal invoiceAccounted = null;
            if (invoice.getReversal_ID() == 0 || invoice.get_ID() < invoice.getReversal_ID()) {
                if (this.hasDebitTradeAmt(invoice)) {
                    invoiceSource = (BigDecimal)valuesInv.get(0);
                    invoiceAccounted = (BigDecimal)valuesInv.get(1);
                } else {
                    invoiceSource = (BigDecimal)valuesInv.get(2);
                    invoiceAccounted = (BigDecimal)valuesInv.get(3);
                }
            } else if (this.hasDebitTradeAmt(invoice)) {
                invoiceSource = (BigDecimal)valuesInv.get(2);
                invoiceAccounted = (BigDecimal)valuesInv.get(3);
            } else {
                invoiceSource = (BigDecimal)valuesInv.get(0);
                invoiceAccounted = (BigDecimal)valuesInv.get(1);
            }
            htInvSource.put(invoice.getC_Invoice_ID(), invoiceSource);
            htInvAccounted.put(invoice.getC_Invoice_ID(), invoiceAccounted);
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        HashMap<Integer, BigDecimal> htTotalAmtSourceDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtSourceCr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctCr = new HashMap<Integer, BigDecimal>();
        FactLine[] factlines = fact.getLines();
        FactLine[] factLineArray = factlines;
        int n = factlines.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationLine allocationLine;
            FactLine factLine = factLineArray[n2];
            if (factLine.getLine_ID() > 0 && (allocationLine = new MAllocationLine(this.getCtx(), factLine.getLine_ID(), this.getTrxName())).getC_Invoice_ID() > 0) {
                MAccount acct;
                MInvoice invoice = (MInvoice)invList.get(allocationLine.getC_Invoice_ID());
                MAccount mAccount = acct = invoice.isSOTrx() ? acctAr : acctAp;
                if (factLine.getAccount_ID() == acct.getAccount_ID()) {
                    BigDecimal totalAmtAcctCr;
                    BigDecimal totalAmtSourceCr2;
                    BigDecimal totalAmtAcctDr;
                    totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(allocationLine.getC_Invoice_ID());
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(allocationLine.getC_Invoice_ID())) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr2 = (BigDecimal)htTotalAmtSourceCr.get(allocationLine.getC_Invoice_ID())) == null) {
                        totalAmtSourceCr2 = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(allocationLine.getC_Invoice_ID())) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
                    totalAmtAcctDr = totalAmtAcctDr.add(factLine.getAmtAcctDr());
                    totalAmtSourceCr2 = totalAmtSourceCr2.add(factLine.getAmtSourceCr());
                    totalAmtAcctCr = totalAmtAcctCr.add(factLine.getAmtAcctCr());
                    htTotalAmtSourceDr.put(allocationLine.getC_Invoice_ID(), totalAmtSourceDr);
                    htTotalAmtAcctDr.put(allocationLine.getC_Invoice_ID(), totalAmtAcctDr);
                    htTotalAmtSourceCr.put(allocationLine.getC_Invoice_ID(), totalAmtSourceCr2);
                    htTotalAmtAcctCr.put(allocationLine.getC_Invoice_ID(), totalAmtAcctCr);
                } else if ((factLine.getAccount_ID() == gain.getAccount_ID() || factLine.getAccount_ID() == loss.getAccount_ID()) && this.invGainLossFactLines.contains(factLine)) {
                    totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(allocationLine.getC_Invoice_ID());
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(allocationLine.getC_Invoice_ID())) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    totalAmtSourceDr = totalAmtSourceDr.subtract(factLine.getAmtSourceCr());
                    totalAmtSourceCr = totalAmtSourceCr.subtract(factLine.getAmtSourceDr());
                    htTotalAmtSourceDr.put(allocationLine.getC_Invoice_ID(), totalAmtSourceDr);
                    htTotalAmtSourceCr.put(allocationLine.getC_Invoice_ID(), totalAmtSourceCr);
                }
            }
            ++n2;
        }
        HashMap<Integer, BigDecimal> htAllocInvSource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htAllocInvAccounted = new HashMap<Integer, BigDecimal>();
        for (MInvoice invoice : invList.values()) {
            MAllocationHdr[] allocations;
            BigDecimal totalAmtAcctCr;
            BigDecimal totalAmtAcctDr;
            BigDecimal allocateSource = Env.ZERO;
            BigDecimal allocateAccounted = Env.ZERO;
            BigDecimal totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(invoice.getC_Invoice_ID());
            if (totalAmtSourceDr == null) {
                totalAmtSourceDr = Env.ZERO;
            }
            if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtAcctDr = Env.ZERO;
            }
            if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtSourceCr = Env.ZERO;
            }
            if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtAcctCr = Env.ZERO;
            }
            if (totalAmtSourceDr.signum() == 0 && totalAmtAcctDr.signum() == 0) {
                allocateSource = allocateSource.add(totalAmtSourceCr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctCr);
            } else if (totalAmtSourceCr.signum() == 0 && totalAmtAcctCr.signum() == 0) {
                allocateSource = allocateSource.add(totalAmtSourceDr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctDr);
            } else if (totalAmtAcctDr.compareTo(totalAmtAcctCr) > 0) {
                allocateSource = allocateSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
            } else {
                allocateSource = allocateSource.add(totalAmtSourceCr).subtract(totalAmtSourceDr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctCr).subtract(totalAmtAcctDr);
            }
            MAllocationHdr[] mAllocationHdrArray = allocations = MAllocationHdr.getOfInvoice(this.getCtx(), invoice.get_ID(), this.getTrxName());
            int n3 = allocations.length;
            int n4 = 0;
            while (n4 < n3) {
                MAllocationHdr alloc = mAllocationHdrArray[n4];
                if (alloc.get_ID() != this.get_ID()) {
                    BigDecimal currencyAdjustment = Env.ZERO;
                    StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?").append(" AND Line_ID IN (SELECT C_AllocationLine_ID FROM C_AllocationLine WHERE C_AllocationHdr_ID=? AND C_Invoice_ID=?)");
                    MAccount acct = invoice.isSOTrx() ? acctAr : acctAp;
                    List<Object> valuesAlloc = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 735, alloc.get_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID(), alloc.get_ID(), invoice.getC_Invoice_ID());
                    if (valuesAlloc != null && valuesAlloc.size() >= 4) {
                        totalAmtSourceDr = (BigDecimal)valuesAlloc.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesAlloc.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesAlloc.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesAlloc.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        if (totalAmtSourceDr.signum() == 0 && totalAmtAcctDr.signum() == 0) {
                            allocateSource = allocateSource.add(totalAmtSourceCr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctCr);
                        } else if (totalAmtSourceCr.signum() == 0 && totalAmtAcctCr.signum() == 0) {
                            allocateSource = allocateSource.add(totalAmtSourceDr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctDr);
                        } else if (totalAmtAcctDr.compareTo(totalAmtAcctCr) > 0) {
                            allocateSource = allocateSource.add(totalAmtSourceDr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                            currencyAdjustment = currencyAdjustment.add(totalAmtAcctCr);
                        } else {
                            allocateSource = allocateSource.add(totalAmtSourceCr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctCr).subtract(totalAmtAcctDr);
                            currencyAdjustment = currencyAdjustment.add(totalAmtAcctDr);
                        }
                    }
                    sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'Invoice%'").append(" AND Line_ID IN (SELECT C_AllocationLine_ID FROM C_AllocationLine WHERE C_AllocationHdr_ID=? AND C_Invoice_ID=?)");
                    valuesAlloc = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 735, alloc.get_ID(), as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID(), alloc.get_ID(), invoice.getC_Invoice_ID());
                    if (valuesAlloc != null && valuesAlloc.size() >= 4) {
                        totalAmtSourceDr = (BigDecimal)valuesAlloc.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesAlloc.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesAlloc.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesAlloc.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        allocateSource = allocateSource.subtract(totalAmtSourceDr).subtract(totalAmtSourceCr).add(currencyAdjustment);
                    }
                }
                ++n4;
            }
            htAllocInvSource.put(invoice.getC_Invoice_ID(), allocateSource);
            htAllocInvAccounted.put(invoice.getC_Invoice_ID(), allocateAccounted);
        }
        for (MInvoice invoice : invList.values()) {
            BigDecimal allocInvAccounted;
            BigDecimal allocInvSource;
            BigDecimal invAccounted;
            MAccount acct = invoice.isSOTrx() ? acctAr : acctAp;
            BigDecimal invSource = (BigDecimal)htInvSource.get(invoice.getC_Invoice_ID());
            if (invSource == null) {
                invSource = Env.ZERO;
            }
            if ((invAccounted = (BigDecimal)htInvAccounted.get(invoice.getC_Invoice_ID())) == null) {
                invAccounted = Env.ZERO;
            }
            if ((allocInvSource = (BigDecimal)htAllocInvSource.get(invoice.getC_Invoice_ID())) == null) {
                allocInvSource = Env.ZERO;
            }
            if ((allocInvAccounted = (BigDecimal)htAllocInvAccounted.get(invoice.getC_Invoice_ID())) == null) {
                allocInvAccounted = Env.ZERO;
            }
            StringBuilder description = new StringBuilder("Invoice=(").append(this.getC_Currency_ID()).append(")").append(invSource).append("/").append(invAccounted).append(" - Allocation=(").append(this.getC_Currency_ID()).append(")").append(allocInvSource).append("/").append(allocInvAccounted);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(description.toString());
            }
            BigDecimal acctDifference = null;
            if (allocInvSource.abs().compareTo(invSource.abs()) == 0) {
                acctDifference = allocInvAccounted.abs().subtract(invAccounted.abs());
                StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                description.append(" - ").append((CharSequence)d2);
            }
            if (acctDifference == null || acctDifference.signum() == 0) {
                this.log.fine("No Difference");
                continue;
            }
            Integer C_AllocationLine_ID = (Integer)htInvAllocLine.get(invoice.getC_Invoice_ID());
            MAllocationHdr alloc = (MAllocationHdr)this.getPO();
            if (alloc.getReversal_ID() == 0 || alloc.get_ID() < alloc.getReversal_ID()) {
                if (this.hasDebitTradeAmt(invoice)) {
                    FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
                    fl.setDescription(description.toString());
                    fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                    if (fact.isAcctBalanced()) continue;
                    fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != invoice.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
                    fl.setDescription(description.toString());
                    fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                    continue;
                }
                FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                if (fact.isAcctBalanced()) continue;
                fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != invoice.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                continue;
            }
            if (this.hasDebitTradeAmt(invoice)) {
                FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                if (fact.isAcctBalanced()) continue;
                fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != invoice.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference) : fact.createLine(null, gain, loss, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                continue;
            }
            FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
            if (fact.isAcctBalanced()) continue;
            fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != invoice.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, gain, loss, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
        }
        return null;
    }

    private String createPaymentRoundingCorrection(MAcctSchema as, Fact fact) {
        ArrayList<MPayment> payList = new ArrayList<MPayment>();
        HashMap<Integer, Integer> htPayAllocLine = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            MPayment payment = null;
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i2];
            if (line.getC_Payment_ID() != 0) {
                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                if (!payList.contains(payment)) {
                    payList.add(payment);
                }
                htPayAllocLine.put(payment.getC_Payment_ID(), line.get_ID());
            }
            ++i2;
        }
        HashMap<Integer, MAccount> htPayAcct = new HashMap<Integer, MAccount>();
        HashMap<Integer, BigDecimal> htPaySource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htPayAccounted = new HashMap<Integer, BigDecimal>();
        for (MPayment payment : payList) {
            htPayAcct.put(payment.getC_Payment_ID(), this.getPaymentAcct(as, payment.getC_Payment_ID()));
            StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID = ? ").append(" AND PostingType='A'");
            List<Object> valuesPay = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 335, payment.getC_Payment_ID(), as.getC_AcctSchema_ID(), ((MAccount)htPayAcct.get(payment.getC_Payment_ID())).getAccount_ID());
            if (valuesPay == null || valuesPay.size() < 4) continue;
            BigDecimal paymentSource = (BigDecimal)valuesPay.get(0);
            BigDecimal paymentAccounted = (BigDecimal)valuesPay.get(1);
            if (paymentSource == null || paymentAccounted == null) continue;
            if (paymentSource.signum() == 0 && paymentAccounted.signum() == 0) {
                paymentSource = (BigDecimal)valuesPay.get(2);
                paymentAccounted = (BigDecimal)valuesPay.get(3);
            }
            htPaySource.put(payment.getC_Payment_ID(), paymentSource);
            htPayAccounted.put(payment.getC_Payment_ID(), paymentAccounted);
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        HashMap<Integer, BigDecimal> htTotalAmtSourceDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtSourceCr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctCr = new HashMap<Integer, BigDecimal>();
        FactLine[] factlines = fact.getLines();
        FactLine[] factLineArray = factlines;
        int n = factlines.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationLine allocationLine;
            FactLine factLine = factLineArray[n2];
            if (factLine.getLine_ID() > 0 && (allocationLine = new MAllocationLine(this.getCtx(), factLine.getLine_ID(), this.getTrxName())).getC_Payment_ID() > 0) {
                if (factLine.getAccount_ID() == ((MAccount)htPayAcct.get(allocationLine.getC_Payment_ID())).getAccount_ID()) {
                    BigDecimal totalAmtAcctCr;
                    BigDecimal totalAmtSourceCr;
                    BigDecimal totalAmtAcctDr;
                    totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(allocationLine.getC_Payment_ID());
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(allocationLine.getC_Payment_ID())) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(allocationLine.getC_Payment_ID())) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(allocationLine.getC_Payment_ID())) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
                    totalAmtAcctDr = totalAmtAcctDr.add(factLine.getAmtAcctDr());
                    totalAmtSourceCr = totalAmtSourceCr.add(factLine.getAmtSourceCr());
                    totalAmtAcctCr = totalAmtAcctCr.add(factLine.getAmtAcctCr());
                    htTotalAmtSourceDr.put(allocationLine.getC_Payment_ID(), totalAmtSourceDr);
                    htTotalAmtAcctDr.put(allocationLine.getC_Payment_ID(), totalAmtAcctDr);
                    htTotalAmtSourceCr.put(allocationLine.getC_Payment_ID(), totalAmtSourceCr);
                    htTotalAmtAcctCr.put(allocationLine.getC_Payment_ID(), totalAmtAcctCr);
                } else if ((factLine.getAccount_ID() == gain.getAccount_ID() || factLine.getAccount_ID() == loss.getAccount_ID()) && this.payGainLossFactLines.contains(factLine)) {
                    BigDecimal totalAmtSourceCr;
                    totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(allocationLine.getC_Payment_ID());
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(allocationLine.getC_Payment_ID())) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    totalAmtSourceDr = totalAmtSourceDr.subtract(factLine.getAmtSourceCr());
                    totalAmtSourceCr = totalAmtSourceCr.subtract(factLine.getAmtSourceDr());
                    htTotalAmtSourceDr.put(allocationLine.getC_Payment_ID(), totalAmtSourceDr);
                    htTotalAmtSourceCr.put(allocationLine.getC_Payment_ID(), totalAmtSourceCr);
                }
            }
            ++n2;
        }
        HashMap<Integer, BigDecimal> htAllocPaySource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htAllocPayAccounted = new HashMap<Integer, BigDecimal>();
        for (MPayment payment : payList) {
            MAllocationHdr[] allocations;
            BigDecimal totalAmtAcctCr;
            BigDecimal totalAmtSourceCr;
            BigDecimal totalAmtAcctDr;
            BigDecimal allocateSource = Env.ZERO;
            BigDecimal allocateAccounted = Env.ZERO;
            BigDecimal totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(payment.getC_Payment_ID());
            if (totalAmtSourceDr == null) {
                totalAmtSourceDr = Env.ZERO;
            }
            if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(payment.getC_Payment_ID())) == null) {
                totalAmtAcctDr = Env.ZERO;
            }
            if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(payment.getC_Payment_ID())) == null) {
                totalAmtSourceCr = Env.ZERO;
            }
            if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(payment.getC_Payment_ID())) == null) {
                totalAmtAcctCr = Env.ZERO;
            }
            if (totalAmtSourceDr.signum() == 0 && totalAmtAcctDr.signum() == 0) {
                allocateSource = allocateSource.add(totalAmtSourceCr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctCr);
            } else if (totalAmtSourceCr.signum() == 0 && totalAmtAcctCr.signum() == 0) {
                allocateSource = allocateSource.add(totalAmtSourceDr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctDr);
            } else if (totalAmtAcctDr.compareTo(totalAmtAcctCr) > 0) {
                allocateSource = allocateSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
            } else {
                allocateSource = allocateSource.add(totalAmtSourceCr).subtract(totalAmtSourceDr);
                allocateAccounted = allocateAccounted.add(totalAmtAcctCr).subtract(totalAmtAcctDr);
            }
            MAllocationHdr[] mAllocationHdrArray = allocations = MAllocationHdr.getOfPayment(this.getCtx(), payment.get_ID(), this.getTrxName());
            int n3 = allocations.length;
            int n4 = 0;
            while (n4 < n3) {
                MAllocationHdr alloc = mAllocationHdrArray[n4];
                if (alloc.get_ID() != this.get_ID()) {
                    BigDecimal currencyAdjustment = Env.ZERO;
                    StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?").append(" AND Line_ID IN (SELECT C_AllocationLine_ID FROM C_AllocationLine WHERE C_AllocationHdr_ID=? AND C_Payment_ID=?)");
                    List<Object> valuesAlloc = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 735, alloc.get_ID(), as.getC_AcctSchema_ID(), ((MAccount)htPayAcct.get(payment.getC_Payment_ID())).getAccount_ID(), alloc.get_ID(), payment.getC_Payment_ID());
                    if (valuesAlloc != null && valuesAlloc.size() >= 4) {
                        totalAmtSourceDr = (BigDecimal)valuesAlloc.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesAlloc.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesAlloc.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesAlloc.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        if (totalAmtSourceDr.signum() == 0 && totalAmtAcctDr.signum() == 0) {
                            allocateSource = allocateSource.add(totalAmtSourceCr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctCr);
                        } else if (totalAmtSourceCr.signum() == 0 && totalAmtAcctCr.signum() == 0) {
                            allocateSource = allocateSource.add(totalAmtSourceDr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctDr);
                        } else if (totalAmtAcctDr.compareTo(totalAmtAcctCr) > 0) {
                            allocateSource = allocateSource.add(totalAmtSourceDr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                            currencyAdjustment = currencyAdjustment.add(totalAmtAcctCr);
                        } else {
                            allocateSource = allocateSource.add(totalAmtSourceCr);
                            allocateAccounted = allocateAccounted.add(totalAmtAcctCr).subtract(totalAmtAcctDr);
                            currencyAdjustment = currencyAdjustment.add(totalAmtAcctDr);
                        }
                    }
                    sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'Payment%'").append(" AND Line_ID IN (SELECT C_AllocationLine_ID FROM C_AllocationLine WHERE C_AllocationHdr_ID=? AND C_Payment_ID=?)");
                    valuesAlloc = DB.getSQLValueObjectsEx(this.getTrxName(), sql.toString(), 735, alloc.get_ID(), as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID(), alloc.get_ID(), payment.getC_Payment_ID());
                    if (valuesAlloc != null && valuesAlloc.size() >= 4) {
                        totalAmtSourceDr = (BigDecimal)valuesAlloc.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesAlloc.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesAlloc.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesAlloc.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        allocateSource = allocateSource.subtract(totalAmtSourceDr).subtract(totalAmtSourceCr).add(currencyAdjustment);
                        if (!as.isCurrencyBalancing() || as.getC_Currency_ID() == payment.getC_Currency_ID()) {
                            allocateAccounted = allocateAccounted.add(currencyAdjustment);
                        }
                    }
                }
                ++n4;
            }
            htAllocPaySource.put(payment.getC_Payment_ID(), allocateSource);
            htAllocPayAccounted.put(payment.getC_Payment_ID(), allocateAccounted);
        }
        for (MPayment payment : payList) {
            FactLine fl;
            BigDecimal allocPayAccounted;
            BigDecimal allocPaySource;
            BigDecimal payAccounted;
            BigDecimal paySource = (BigDecimal)htPaySource.get(payment.getC_Payment_ID());
            if (paySource == null) {
                paySource = Env.ZERO;
            }
            if ((payAccounted = (BigDecimal)htPayAccounted.get(payment.getC_Payment_ID())) == null) {
                payAccounted = Env.ZERO;
            }
            if ((allocPaySource = (BigDecimal)htAllocPaySource.get(payment.getC_Payment_ID())) == null) {
                allocPaySource = Env.ZERO;
            }
            if ((allocPayAccounted = (BigDecimal)htAllocPayAccounted.get(payment.getC_Payment_ID())) == null) {
                allocPayAccounted = Env.ZERO;
            }
            StringBuilder description = new StringBuilder("Payment=(").append(this.getC_Currency_ID()).append(")").append(paySource).append("/").append(payAccounted).append(" - Allocation=(").append(this.getC_Currency_ID()).append(")").append(allocPaySource).append("/").append(allocPayAccounted);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(description.toString());
            }
            BigDecimal acctDifference = null;
            if (allocPaySource.abs().compareTo(paySource.abs()) == 0) {
                acctDifference = allocPayAccounted.abs().subtract(payAccounted.abs());
                StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                description.append(" - ").append((CharSequence)d2);
            }
            if (acctDifference == null || acctDifference.signum() == 0) {
                this.log.fine("No Difference");
                continue;
            }
            Integer C_AllocationLine_ID = (Integer)htPayAllocLine.get(payment.getC_Payment_ID());
            if (payment.isReceipt() && payment.getPayAmt().signum() >= 0 || !payment.isReceipt() && payment.getPayAmt().signum() < 0) {
                fl = fact.createLine(null, (MAccount)htPayAcct.get(payment.getC_Payment_ID()), as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                if (fact.isAcctBalanced()) continue;
                fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != payment.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
                continue;
            }
            fl = fact.createLine(null, (MAccount)htPayAcct.get(payment.getC_Payment_ID()), as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
            if (fact.isAcctBalanced()) continue;
            fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != payment.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            fl.setLine_ID(C_AllocationLine_ID == null ? 0 : C_AllocationLine_ID);
        }
        return null;
    }

    private FactLine balanceAccounting(MAcctSchema as, Fact fact) {
        FactLine line = null;
        if (!fact.isAcctBalanced()) {
            MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
            MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
            BigDecimal totalAmtAcctDr = Env.ZERO;
            BigDecimal totalAmtAcctCr = Env.ZERO;
            FactLine[] factLineArray = fact.getLines();
            int n = factLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                FactLine factLine = factLineArray[n2];
                totalAmtAcctDr = totalAmtAcctDr.add(factLine.getAmtAcctDr());
                totalAmtAcctCr = totalAmtAcctCr.add(factLine.getAmtAcctCr());
                ++n2;
            }
            BigDecimal acctDifference = totalAmtAcctDr.subtract(totalAmtAcctCr);
            line = as.isCurrencyBalancing() && acctDifference.abs().compareTo(TOLERANCE) < 0 ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
        }
        return line;
    }

    private boolean hasDebitTradeAmt(MInvoice invoice) {
        return invoice.isSOTrx() && invoice.getGrandTotal().signum() >= 0 && !invoice.isCreditMemo() || invoice.isSOTrx() && invoice.getGrandTotal().signum() < 0 && invoice.isCreditMemo() || !invoice.isSOTrx() && invoice.getGrandTotal().signum() >= 0 && invoice.isCreditMemo() || !invoice.isSOTrx() && invoice.getGrandTotal().signum() < 0 && !invoice.isCreditMemo();
    }
}

