/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.credit;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MSysConfig;
import org.compiere.util.Util;

public class CreditManagerOrder
implements ICreditManager {
    private MOrder order;

    public CreditManagerOrder(MOrder po) {
        this.order = po;
    }

    @Override
    public CreditStatus checkCreditStatus(String docAction) {
        Properties ctx;
        MDocType dt;
        String errorMsg = null;
        if (!(!"PR".equals(docAction) || !this.order.isSOTrx() || "WR".equals((dt = MDocType.get(ctx = this.order.getCtx(), this.order.getC_DocTypeTarget_ID())).getDocSubTypeSO()) && "B".equals(this.order.getPaymentRule()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_CASH_POS_ORDER", true, this.order.getAD_Client_ID(), this.order.getAD_Org_ID()) || "PR".equals(dt.getDocSubTypeSO()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_PREPAY_ORDER", true, this.order.getAD_Client_ID(), this.order.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(ctx, this.order.getBill_BPartner_ID(), this.order.get_TrxName());
            if (this.order.getGrandTotal().signum() > 0) {
                BigDecimal grandTotal;
                if ("S".equals(bp.getSOCreditStatus())) {
                    errorMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                }
                if ("H".equals(bp.getSOCreditStatus())) {
                    errorMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                }
                if ("H".equals(bp.getSOCreditStatus(grandTotal = MConversionRate.convertBase(ctx, this.order.getGrandTotal(), this.order.getC_Currency_ID(), this.order.getDateOrdered(), this.order.getC_ConversionType_ID(), this.order.getAD_Client_ID(), this.order.getAD_Org_ID())))) {
                    errorMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @GrandTotal@=" + String.valueOf(grandTotal) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                }
            }
        }
        return new CreditStatus(errorMsg, !Util.isEmpty(errorMsg));
    }
}

