/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IReservationTracer;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MStorageReservation
extends X_M_StorageReservation {
    private static final long serialVersionUID = 8179093165315835613L;
    private static CLogger s_log = CLogger.getCLogger(MStorageReservation.class);

    public static MStorageReservation get(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, boolean isSOTrx, String trxName) {
        MStorageReservation retValue;
        block10: {
            retValue = null;
            Object sql = "SELECT * FROM M_StorageReservation WHERE M_Warehouse_ID=? AND M_Product_ID=? AND IsSOTrx=? AND ";
            sql = M_AttributeSetInstance_ID == 0 ? (String)sql + "(M_AttributeSetInstance_ID=? OR M_AttributeSetInstance_ID IS NULL)" : (String)sql + "M_AttributeSetInstance_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    pstmt.setString(3, isSOTrx ? "Y" : "N");
                    pstmt.setInt(4, M_AttributeSetInstance_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MStorageReservation(ctx, rs, trxName);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, (String)sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("Not Found - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", IsSOTrx=" + isSOTrx);
            }
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", IsSOTrx=" + isSOTrx);
        }
        return retValue;
    }

    public MStorageReservation(Properties ctx, String M_StorageReservation_UU, String trxName) {
        super(ctx, M_StorageReservation_UU, trxName);
    }

    public MStorageReservation(Properties ctx, int M_StorageReservation_ID, String trxName) {
        super(ctx, M_StorageReservation_ID, trxName);
    }

    public MStorageReservation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MStorageReservation(MWarehouse warehouse, int M_Product_ID, int M_AttributeSetInstance_ID, boolean isSOTrx) {
        this(warehouse.getCtx(), 0, warehouse.get_TrxName());
        this.setClientOrg(warehouse);
        this.setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setIsSOTrx(isSOTrx);
        this.setQty(Env.ZERO);
    }

    public static MStorageReservation[] get(Properties ctx, int m_Warehouse_ID, int m_Product_ID, int i, String trxName) {
        String sqlWhere = "M_Product_ID=? AND M_Warehouse_ID=?";
        List<MStorageReservation> list = new Query(ctx, "M_StorageReservation", sqlWhere, trxName).setParameters(m_Product_ID, m_Warehouse_ID).list();
        MStorageReservation[] retValue = new MStorageReservation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageReservation[] getOfProduct(Properties ctx, int M_Product_ID, String trxName) {
        String sqlWhere = "M_Product_ID=?";
        List<MStorageReservation> list = new Query(ctx, "M_StorageReservation", sqlWhere, trxName).setParameters(M_Product_ID).list();
        MStorageReservation[] retValue = new MStorageReservation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static BigDecimal getQty(int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID, boolean isSOTrx, String trxName) {
        BigDecimal qty;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(Qty) FROM M_StorageReservation sr").append(" WHERE sr.M_Product_ID=? AND sr.M_Warehouse_ID=?").append(" AND sr.IsSOTrx=?");
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        params.add(isSOTrx ? "Y" : "N");
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        if ((qty = DB.getSQLValueBDEx(trxName, sql.toString(), params)) == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyAvailable(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal qtyOnHand = MStorageOnHand.getQtyOnHandForReservation(M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID, trxName);
        BigDecimal qtyReserved = MStorageReservation.getQty(M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID, true, trxName);
        BigDecimal retValue = qtyOnHand.subtract(qtyReserved);
        return retValue;
    }

    @Deprecated
    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQty, boolean isSOTrx, String trxName) {
        return MStorageReservation.add(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, diffQty, isSOTrx, trxName, null);
    }

    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQty, boolean isSOTrx, String trxName, IReservationTracer tracer) {
        if (diffQty == null || diffQty.signum() == 0) {
            return true;
        }
        MProduct prd = MProduct.get(ctx, M_Product_ID);
        if (prd.getM_AttributeSet_ID() == 0 || !prd.getM_AttributeSet().isInstanceAttribute()) {
            M_AttributeSetInstance_ID = 0;
        }
        MStorageReservation storage = MStorageReservation.getCreate(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, isSOTrx, trxName);
        DB.getDatabase().forUpdate(storage, 120);
        if (storage.getM_Warehouse_ID() != M_Warehouse_ID && storage.getM_Product_ID() != M_Product_ID && storage.getM_AttributeSetInstance_ID() != M_AttributeSetInstance_ID) {
            s_log.severe("No Storage found - M_Warehouse_ID=" + M_Warehouse_ID + ",M_Product_ID=" + M_Product_ID + ",ASI=" + M_AttributeSetInstance_ID);
            return false;
        }
        storage.addQty(diffQty, tracer);
        if (s_log.isLoggable(Level.FINE)) {
            StringBuilder diffText = new StringBuilder("(Qty=").append(diffQty).append(") -> ").append(storage.toString());
            s_log.fine(diffText.toString());
        }
        return true;
    }

    @Deprecated
    public void addQty(BigDecimal addition) {
        this.addQty(addition, null);
    }

    public void addQty(BigDecimal addition, IReservationTracer tracer) {
        DB.executeUpdateEx("UPDATE M_StorageReservation SET Qty=Qty+?, Updated=getDate(), UpdatedBy=? WHERE M_Product_ID=? AND M_Warehouse_ID=? AND M_AttributeSetInstance_ID=? AND IsSOTrx=?", new Object[]{addition, Env.getAD_User_ID(Env.getCtx()), this.getM_Product_ID(), this.getM_Warehouse_ID(), this.getM_AttributeSetInstance_ID(), this.isSOTrx()}, this.get_TrxName());
        this.load(this.get_TrxName(), new String[0]);
        if (tracer != null) {
            BigDecimal oldQty = this.getQty().subtract(addition);
            tracer.trace(oldQty, addition);
        }
    }

    @Deprecated
    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int reservationAttributeSetInstance_ID, BigDecimal diffQty, boolean isSOTrx, String trxName) {
        return MStorageReservation.add(ctx, M_Warehouse_ID, M_Product_ID, reservationAttributeSetInstance_ID, diffQty, isSOTrx, trxName);
    }

    public static MStorageReservation getCreate(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, boolean isSOTrx, String trxName) {
        if (M_Warehouse_ID == 0) {
            throw new IllegalArgumentException("M_Warehouse_ID=0");
        }
        if (M_Product_ID == 0) {
            throw new IllegalArgumentException("M_Product_ID=0");
        }
        MStorageReservation retValue = MStorageReservation.get(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, isSOTrx, trxName);
        if (retValue != null) {
            return retValue;
        }
        MWarehouse warehouse = new MWarehouse(ctx, M_Warehouse_ID, trxName);
        if (warehouse.get_ID() != M_Warehouse_ID) {
            throw new IllegalArgumentException("Not found M_Warehouse_ID=" + M_Warehouse_ID);
        }
        retValue = new MStorageReservation(warehouse, M_Product_ID, M_AttributeSetInstance_ID, isSOTrx);
        retValue.saveEx(trxName);
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("New " + String.valueOf(retValue));
        }
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MStorageReservation[").append("M_Warehouse_ID=").append(this.getM_Warehouse_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(",IsSOTrx=").append(this.isSOTrx()).append(": Qty=").append(this.getQty()).append("]");
        return sb.toString();
    }
}

